# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class PppoeSettings(NetworkManagerSettingsMixin):
    """PPP-over-Ethernet Settings"""
    secret_fields_names = ['password']
    secret_name = 'pppoe'

    parent: Optional[str] = field(
        metadata={
            'dbus_name': 'parent',
            'dbus_type': 's',
        },
        default=None,
    )
    """If given, specifies the parent interface name on which this PPPoE
    connection should be created.  If this property is not specified,
    the connection is activated on the interface specified in
    "interface-name" of NMSettingConnection."""
    password: Optional[str] = field(
        metadata={
            'dbus_name': 'password',
            'dbus_type': 's',
        },
        default=None,
    )
    """Password used to authenticate with the PPPoE service."""
    password_flags: Optional[int] = field(
        metadata={
            'dbus_name': 'password-flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Flags indicating how to handle the "password" property."""
    service: Optional[str] = field(
        metadata={
            'dbus_name': 'service',
            'dbus_type': 's',
        },
        default=None,
    )
    """If specified, instruct PPPoE to only initiate sessions with access
    concentrators that provide the specified service.  For most
    providers, this should be left blank.  It is only required if there
    are multiple access concentrators or a specific service is known to
    be required."""
    username: Optional[str] = field(
        metadata={
            'dbus_name': 'username',
            'dbus_type': 's',
        },
        default=None,
    )
    """Username used to authenticate with the PPPoE service."""
