# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class OvsPortSettings(NetworkManagerSettingsMixin):
    """OvsPort Link Settings"""

    bond_downdelay: Optional[int] = field(
        metadata={
            'dbus_name': 'bond-downdelay',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The time port must be inactive in order to be considered down."""
    bond_mode: Optional[str] = field(
        metadata={
            'dbus_name': 'bond-mode',
            'dbus_type': 's',
        },
        default=None,
    )
    """Bonding mode. One of "active-backup", "balance-slb", or "balance-tcp"."""
    bond_updelay: Optional[int] = field(
        metadata={
            'dbus_name': 'bond-updelay',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The time port must be active before it starts forwarding traffic."""
    lacp: Optional[str] = field(
        metadata={
            'dbus_name': 'lacp',
            'dbus_type': 's',
        },
        default=None,
    )
    """LACP mode. One of "active", "off", or "passive"."""
    tag: Optional[int] = field(
        metadata={
            'dbus_name': 'tag',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The VLAN tag in the range 0-4095."""
    vlan_mode: Optional[str] = field(
        metadata={
            'dbus_name': 'vlan-mode',
            'dbus_type': 's',
        },
        default=None,
    )
    """The VLAN mode. One of "access", "native-tagged", "native-untagged",
    "trunk" or unset."""
