# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class OvsInterfaceSettings(NetworkManagerSettingsMixin):
    """Open vSwitch Interface Settings"""

    ofport_request: Optional[int] = field(
        metadata={
            'dbus_name': 'ofport-request',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Open vSwitch openflow port number. Defaults to zero which means that
    port number will not be specified and it will be chosen randomly by
    ovs. OpenFlow ports are the network interfaces for passing packets
    between OpenFlow processing and the rest of the network. OpenFlow
    switches connect logically to each other via their OpenFlow ports."""
    ovs_interface_type: Optional[str] = field(
        metadata={
            'dbus_name': 'type',
            'dbus_type': 's',
        },
        default=None,
    )
    """The interface type. Either "internal", "system", "patch", "dpdk", or
    empty."""
