# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class MatchSettings(NetworkManagerSettingsMixin):
    """Match settings"""

    driver: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'driver',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of driver names to match. Each element is a shell wildcard
    pattern.

    See NMSettingMatch:interface-name for how special characters '|',
    '&', '!' and '\\' are used for optional and mandatory matches and
    inverting the pattern."""
    interface_name: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'interface-name',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of interface names to match. Each element is a shell wildcard
    pattern.

    An element can be prefixed with a pipe symbol (|) or an ampersand
    (&). The former means that the element is optional and the latter
    means that it is mandatory. If there are any optional elements, than
    the match evaluates to true if at least one of the optional element
    matches (logical OR). If there are any mandatory elements, then they
    all must match (logical AND). By default, an element is optional.
    This means that an element "foo" behaves the same as "|foo". An
    element can also be inverted with exclamation mark (!) between the
    pipe symbol (or the ampersand) and before the pattern. Note that
    "!foo" is a shortcut for the mandatory match "&!foo". Finally, a
    backslash can be used at the beginning of the element (after the
    optional special characters) to escape the start of the pattern. For
    example, "&\\!a" is an mandatory match for literally "!a"."""
    kernel_command_line: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'kernel-command-line',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of kernel command line arguments to match. This may be used to
    check whether a specific kernel command line option is set (or
    unset, if prefixed with the exclamation mark). The argument must
    either be a single word, or an assignment (i.e. two words, joined by
    "="). In the former case the kernel command line is searched for the
    word appearing as is, or as left hand side of an assignment. In the
    latter case, the exact assignment is looked for with right and left
    hand side matching. Wildcard patterns are not supported.

    See NMSettingMatch:interface-name for how special characters '|',
    '&', '!' and '\\' are used for optional and mandatory matches and
    inverting the match."""
    path: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'path',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of paths to match against the ID_PATH udev property of devices.
    ID_PATH represents the topological persistent path of a device. It
    typically contains a subsystem string (pci, usb, platform, etc.) and
    a subsystem-specific identifier.

    For PCI devices the path has the form
    "pci-$domain:$bus:$device.$function", where each variable is an
    hexadecimal value; for example "pci-0000:0a:00.0".

    The path of a device can be obtained with "udevadm info
    /sys/class/net/$dev | grep ID_PATH=" or by looking at the "path"
    property exported by NetworkManager ("nmcli -f general.path device
    show $dev").

    Each element of the list is a shell wildcard pattern.

    See NMSettingMatch:interface-name for how special characters '|',
    '&', '!' and '\\' are used for optional and mandatory matches and
    inverting the pattern."""
