# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class MacvlanSettings(NetworkManagerSettingsMixin):
    """MAC VLAN Settings"""

    mode: Optional[int] = field(
        metadata={
            'dbus_name': 'mode',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The macvlan mode, which specifies the communication mechanism between
    multiple macvlans on the same lower device."""
    parent: Optional[str] = field(
        metadata={
            'dbus_name': 'parent',
            'dbus_type': 's',
        },
        default=None,
    )
    """If given, specifies the parent interface name or parent connection UUID
    from which this MAC-VLAN interface should be created.  If this
    property is not specified, the connection must contain an
    "802-3-ethernet" setting with a "mac-address" property."""
    promiscuous: Optional[bool] = field(
        metadata={
            'dbus_name': 'promiscuous',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Whether the interface should be put in promiscuous mode."""
    tap: Optional[bool] = field(
        metadata={
            'dbus_name': 'tap',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Whether the interface should be a MACVTAP."""
