# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class IpTunnelSettings(NetworkManagerSettingsMixin):
    """IP Tunneling Settings"""

    encapsulation_limit: Optional[int] = field(
        metadata={
            'dbus_name': 'encapsulation-limit',
            'dbus_type': 'u',
        },
        default=None,
    )
    """How many additional levels of encapsulation are permitted to be
    prepended to packets. This property applies only to IPv6 tunnels."""
    flags: Optional[int] = field(
        metadata={
            'dbus_name': 'flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Tunnel flags. Currently, the following values are supported:
    NM_IP_TUNNEL_FLAG_IP6_IGN_ENCAP_LIMIT (0x1),
    NM_IP_TUNNEL_FLAG_IP6_USE_ORIG_TCLASS (0x2),
    NM_IP_TUNNEL_FLAG_IP6_USE_ORIG_FLOWLABEL (0x4),
    NM_IP_TUNNEL_FLAG_IP6_MIP6_DEV (0x8),
    NM_IP_TUNNEL_FLAG_IP6_RCV_DSCP_COPY (0x10),
    NM_IP_TUNNEL_FLAG_IP6_USE_ORIG_FWMARK (0x20). They are valid only
    for IPv6 tunnels."""
    flow_label: Optional[int] = field(
        metadata={
            'dbus_name': 'flow-label',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The flow label to assign to tunnel packets. This property applies only
    to IPv6 tunnels."""
    input_key: Optional[str] = field(
        metadata={
            'dbus_name': 'input-key',
            'dbus_type': 's',
        },
        default=None,
    )
    """The key used for tunnel input packets; the property is valid only for
    certain tunnel modes (GRE, IP6GRE). If empty, no key is used."""
    local: Optional[str] = field(
        metadata={
            'dbus_name': 'local',
            'dbus_type': 's',
        },
        default=None,
    )
    """The local endpoint of the tunnel; the value can be empty, otherwise it
    must contain an IPv4 or IPv6 address."""
    mode: Optional[int] = field(
        metadata={
            'dbus_name': 'mode',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The tunneling mode, for example NM_IP_TUNNEL_MODE_IPIP (1) or
    NM_IP_TUNNEL_MODE_GRE (2)."""
    mtu: Optional[int] = field(
        metadata={
            'dbus_name': 'mtu',
            'dbus_type': 'u',
        },
        default=None,
    )
    """If non-zero, only transmit packets of the specified size or smaller,
    breaking larger packets up into multiple fragments."""
    output_key: Optional[str] = field(
        metadata={
            'dbus_name': 'output-key',
            'dbus_type': 's',
        },
        default=None,
    )
    """The key used for tunnel output packets; the property is valid only for
    certain tunnel modes (GRE, IP6GRE). If empty, no key is used."""
    parent: Optional[str] = field(
        metadata={
            'dbus_name': 'parent',
            'dbus_type': 's',
        },
        default=None,
    )
    """If given, specifies the parent interface name or parent connection UUID
    the new device will be bound to so that tunneled packets will only
    be routed via that interface."""
    path_mtu_discovery: Optional[bool] = field(
        metadata={
            'dbus_name': 'path-mtu-discovery',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Whether to enable Path MTU Discovery on this tunnel."""
    remote: Optional[str] = field(
        metadata={
            'dbus_name': 'remote',
            'dbus_type': 's',
        },
        default=None,
    )
    """The remote endpoint of the tunnel; the value must contain an IPv4 or
    IPv6 address."""
    tos: Optional[int] = field(
        metadata={
            'dbus_name': 'tos',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The type of service (IPv4) or traffic class (IPv6) field to be set on
    tunneled packets."""
    ttl: Optional[int] = field(
        metadata={
            'dbus_name': 'ttl',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The TTL to assign to tunneled packets. 0 is a special value meaning that
    packets inherit the TTL value."""
