# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple
from .base import NetworkManagerSettingsMixin
from .datatypes import Vlans


@dataclass
class BridgeSettings(NetworkManagerSettingsMixin):
    """Bridging Settings"""

    ageing_time: Optional[int] = field(
        metadata={
            'dbus_name': 'ageing-time',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The Ethernet MAC address aging time, in seconds."""
    forward_delay: Optional[int] = field(
        metadata={
            'dbus_name': 'forward-delay',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The Spanning Tree Protocol (STP) forwarding delay, in seconds."""
    group_address: Optional[bytes] = field(
        metadata={
            'dbus_name': 'group-address',
            'dbus_type': 'ay',
        },
        default=None,
    )
    """If specified, The MAC address of the multicast group this bridge uses
    for STP.

    The address must be a link-local address in standard Ethernet MAC
    address format, ie an address of the form 01:80:C2:00:00:0X, with X
    in [0, 4..F]. If not specified the default value is
    01:80:C2:00:00:00."""
    group_forward_mask: Optional[int] = field(
        metadata={
            'dbus_name': 'group-forward-mask',
            'dbus_type': 'u',
        },
        default=None,
    )
    """A mask of group addresses to forward. Usually, group addresses in the
    range from 01:80:C2:00:00:00 to 01:80:C2:00:00:0F are not forwarded
    according to standards. This property is a mask of 16 bits, each
    corresponding to a group address in that range that must be
    forwarded. The mask can't have bits 0, 1 or 2 set because they are
    used for STP, MAC pause frames and LACP."""
    hello_time: Optional[int] = field(
        metadata={
            'dbus_name': 'hello-time',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The Spanning Tree Protocol (STP) hello time, in seconds."""
    interface_name: Optional[str] = field(
        metadata={
            'dbus_name': 'interface-name',
            'dbus_type': 's',
        },
        default=None,
    )
    """Deprecated in favor of connection.interface-name, but can be used for
    backward-compatibility with older daemons, to set the bridge's
    interface name."""
    mac_address: Optional[bytes] = field(
        metadata={
            'dbus_name': 'mac-address',
            'dbus_type': 'ay',
        },
        default=None,
    )
    """If specified, the MAC address of bridge. When creating a new bridge,
    this MAC address will be set.

    If this field is left unspecified, the "ethernet.cloned-mac-address"
    is referred instead to generate the initial MAC address. Note that
    setting "ethernet.cloned-mac-address" anyway overwrites the MAC
    address of the bridge later while activating the bridge."""
    max_age: Optional[int] = field(
        metadata={
            'dbus_name': 'max-age',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The Spanning Tree Protocol (STP) maximum message age, in seconds."""
    multicast_hash_max: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-hash-max',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Set maximum size of multicast hash table (value must be a power of 2)."""
    multicast_last_member_count: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-last-member-count',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Set the number of queries the bridge will send before stopping
    forwarding a multicast group after a "leave" message has been
    received."""
    multicast_last_member_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-last-member-interval',
            'dbus_type': 't',
        },
        default=None,
    )
    """Set interval (in deciseconds) between queries to find remaining members
    of a group, after a "leave" message is received."""
    multicast_membership_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-membership-interval',
            'dbus_type': 't',
        },
        default=None,
    )
    """Set delay (in deciseconds) after which the bridge will leave a group, if
    no membership reports for this group are received."""
    multicast_querier: Optional[bool] = field(
        metadata={
            'dbus_name': 'multicast-querier',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Enable or disable sending of multicast queries by the bridge. If not
    specified the option is disabled."""
    multicast_querier_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-querier-interval',
            'dbus_type': 't',
        },
        default=None,
    )
    """If no queries are seen after this delay (in deciseconds) has passed, the
    bridge will start to send its own queries."""
    multicast_query_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-query-interval',
            'dbus_type': 't',
        },
        default=None,
    )
    """Interval (in deciseconds) between queries sent by the bridge after the
    end of the startup phase."""
    multicast_query_response_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-query-response-interval',
            'dbus_type': 't',
        },
        default=None,
    )
    """Set the Max Response Time/Max Response Delay (in deciseconds) for
    IGMP/MLD queries sent by the bridge."""
    multicast_query_use_ifaddr: Optional[bool] = field(
        metadata={
            'dbus_name': 'multicast-query-use-ifaddr',
            'dbus_type': 'b',
        },
        default=None,
    )
    """If enabled the bridge's own IP address is used as the source address for
    IGMP queries otherwise the default of 0.0.0.0 is used."""
    multicast_router: Optional[str] = field(
        metadata={
            'dbus_name': 'multicast-router',
            'dbus_type': 's',
        },
        default=None,
    )
    """Sets bridge's multicast router. Multicast-snooping must be enabled for
    this option to work.

    Supported values are: 'auto', 'disabled', 'enabled' to which kernel
    assigns the numbers 1, 0, and 2, respectively. If not specified the
    default value is 'auto' (1)."""
    multicast_snooping: Optional[bool] = field(
        metadata={
            'dbus_name': 'multicast-snooping',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Controls whether IGMP snooping is enabled for this bridge. Note that if
    snooping was automatically disabled due to hash collisions, the
    system may refuse to enable the feature until the collisions are
    resolved."""
    multicast_startup_query_count: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-startup-query-count',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Set the number of IGMP queries to send during startup phase."""
    multicast_startup_query_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'multicast-startup-query-interval',
            'dbus_type': 't',
        },
        default=None,
    )
    """Sets the time (in deciseconds) between queries sent out at startup to
    determine membership information."""
    priority: Optional[int] = field(
        metadata={
            'dbus_name': 'priority',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Sets the Spanning Tree Protocol (STP) priority for this bridge.  Lower
    values are "better"; the lowest priority bridge will be elected the
    root bridge."""
    stp: Optional[bool] = field(
        metadata={
            'dbus_name': 'stp',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Controls whether Spanning Tree Protocol (STP) is enabled for this
    bridge."""
    vlan_default_pvid: Optional[int] = field(
        metadata={
            'dbus_name': 'vlan-default-pvid',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The default PVID for the ports of the bridge, that is the VLAN id
    assigned to incoming untagged frames."""
    vlan_filtering: Optional[bool] = field(
        metadata={
            'dbus_name': 'vlan-filtering',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Control whether VLAN filtering is enabled on the bridge."""
    vlan_protocol: Optional[str] = field(
        metadata={
            'dbus_name': 'vlan-protocol',
            'dbus_type': 's',
        },
        default=None,
    )
    """If specified, the protocol used for VLAN filtering.

    Supported values are: '802.1Q', '802.1ad'. If not specified the
    default value is '802.1Q'."""
    vlan_stats_enabled: Optional[bool] = field(
        metadata={
            'dbus_name': 'vlan-stats-enabled',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Controls whether per-VLAN stats accounting is enabled."""
    vlans: Optional[List[Vlans]] = field(
        metadata={
            'dbus_name': 'vlans',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': Vlans,
        },
        default=None,
    )
    """Array of bridge VLAN objects. In addition to the VLANs specified here,
    the bridge will also have the default-pvid VLAN configured  by the
    bridge.vlan-default-pvid property.

    In nmcli the VLAN list can be specified with the following syntax:

    $vid [pvid] [untagged] [, $vid [pvid] [untagged]]...

    where $vid is either a single id between 1 and 4094 or a range,
    represented as a couple of ids separated by a dash."""
