# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class AdslSettings(NetworkManagerSettingsMixin):
    """ADSL Settings"""
    secret_fields_names = ['password']
    secret_name = 'adsl'

    encapsulation: Optional[str] = field(
        metadata={
            'dbus_name': 'encapsulation',
            'dbus_type': 's',
        },
        default=None,
    )
    """Encapsulation of ADSL connection.  Can be "vcmux" or "llc"."""
    password: Optional[str] = field(
        metadata={
            'dbus_name': 'password',
            'dbus_type': 's',
        },
        default=None,
    )
    """Password used to authenticate with the ADSL service."""
    password_flags: Optional[int] = field(
        metadata={
            'dbus_name': 'password-flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Flags indicating how to handle the "password" property."""
    protocol: Optional[str] = field(
        metadata={
            'dbus_name': 'protocol',
            'dbus_type': 's',
        },
        default=None,
    )
    """ADSL connection protocol.  Can be "pppoa", "pppoe" or "ipoatm"."""
    username: Optional[str] = field(
        metadata={
            'dbus_name': 'username',
            'dbus_type': 's',
        },
        default=None,
    )
    """Username used to authenticate with the ADSL service."""
    vci: Optional[int] = field(
        metadata={
            'dbus_name': 'vci',
            'dbus_type': 'u',
        },
        default=None,
    )
    """VCI of ADSL connection"""
    vpi: Optional[int] = field(
        metadata={
            'dbus_name': 'vpi',
            'dbus_type': 'u',
        },
        default=None,
    )
    """VPI of ADSL connection"""
