# -*- coding: utf-8 -*-
"""
THIS FILE IS PART OF NETWORK FOR MWAFU LIBRARY LOVE BOOK STORE BY MATT BELFAST BROWN
author_number.py - The core part of the Author Number Creation.

This is a library about automatic number-taking of "General Chinese Author Number Table".
At present, there is only one way to take the number, that is, directly looking up the table.
In the future, we will adapt to a variety of author numbering methods, please wait.
You can use the distributecode() method or fetchcode() method to find the author number.

Author: Matt Belfast Brown
Creat Date:2021-05-30
Version Date: 2022-02-15
Version:1.2.0

THIS PROGRAM IS FREE FOR EVERYONE,IS LICENSED UNDER GPL-3.0
YOU SHOULD HAVE RECEIVED A COPY OF GPL-3.0 LICENSE.

Copyright (C) 2021-2022 Matt Belfast Brown
Copyright (C) 2021-2022 MWAFU LIBRARY LOVE BOOK STORE

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

dict_fetc_code = {
    '白': {
        'A': '143', 'B': '143', 'C': '143', 'D': '143', 'E': '143', 'F': '143', 'G': '143', 'H': '143', 'I': '143',
        'J': '143', 'K': '143', 'L': '144', 'M': '144', 'N': '144', 'O': '144', 'P': '144', 'Q': '144', 'R': '144',
        'S': '144', 'T': '144', 'W': '145', 'X': '145', 'Y': '145', 'Z': '145'
    },
    '达': {
        'A': '112', 'B': '112', 'C': '112', 'D': '112', 'E': '112', 'F': '112', 'G': '112', 'H': '112', 'I': '112',
        'J': '112', 'K': '112', 'L': '113', 'M': '113', 'N': '113', 'O': '113', 'P': '113', 'Q': '113', 'R': '113',
        'S': '113', 'T': '113', 'W': '114', 'X': '114', 'Y': '114', 'Z': '114'
    },
    '利': {
        'A': '291', 'B': '291', 'C': '291', 'D': '291', 'E': '291', 'F': '291', 'G': '291', 'H': '291', 'I': '291',
        'J': '291', 'K': '291', 'L': '292', 'M': '292', 'N': '292', 'O': '292', 'P': '292', 'Q': '292', 'R': '292',
        'S': '292', 'T': '292', 'W': '293', 'X': '293', 'Y': '293', 'Z': '293'
    },
    '阿': {
        'A': '111', 'B': '111', 'C': '111', 'D': '111', 'E': '111', 'F': '111', 'G': '111', 'H': '112', 'I': '112',
        'J': '112', 'K': '112', 'L': '113', 'M': '113', 'N': '113', 'O': '113', 'P': '113', 'Q': '113', 'R': '113',
        'S': '114', 'T': '114', 'W': '115', 'X': '115', 'Y': '116', 'Z': '116'
    },
    '艾': {
        'A': '141', 'B': '141', 'C': '141', 'D': '141', 'E': '141', 'F': '141', 'G': '141', 'H': '141', 'I': '141',
        'J': '141', 'K': '141', 'L': '142', 'M': '142', 'N': '142', 'O': '142', 'P': '142', 'Q': '142', 'R': '142',
        'S': '142', 'T': '142', 'W': '143', 'X': '143', 'Y': '143', 'Z': '143'
    },
    '安': {
        'A': '151', 'B': '151', 'C': '151', 'D': '151', 'E': '151', 'F': '151', 'G': '151', 'H': '151', 'I': '151',
        'J': '151', 'K': '151', 'L': '152', 'M': '152', 'N': '152', 'O': '152', 'P': '152', 'Q': '152', 'R': '152',
        'S': '152', 'T': '152', 'W': '153', 'X': '153', 'Y': '153', 'Z': '153'
    },
    '奥': {
        'A': '191', 'B': '191', 'C': '191', 'D': '191', 'E': '191', 'F': '191', 'G': '191', 'H': '192', 'I': '192',
        'J': '192', 'K': '192', 'L': '193', 'M': '193', 'N': '193', 'O': '193', 'P': '193', 'Q': '193', 'R': '193',
        'S': '194', 'T': '194', 'W': '195', 'X': '195', 'Y': '196', 'Z': '196'
    },
    '巴': {
        'A': '111', 'B': '111', 'C': '111', 'D': '111', 'E': '111', 'F': '111', 'G': '111', 'H': '112', 'I': '112',
        'J': '112', 'K': '112', 'L': '113', 'M': '113', 'N': '113', 'O': '113', 'P': '113', 'Q': '113', 'R': '113',
        'S': '114', 'T': '114', 'W': '115', 'X': '115', 'Y': '116', 'Z': '116'
    },
    '包': {
        'A': '221', 'B': '221', 'C': '221', 'D': '221', 'E': '221', 'F': '221', 'G': '221', 'H': '221', 'I': '221',
        'J': '221', 'K': '221', 'L': '222', 'M': '222', 'N': '222', 'O': '222', 'P': '222', 'Q': '222', 'R': '222',
        'S': '222', 'T': '222', 'W': '223', 'X': '223', 'Y': '223', 'Z': '223'
    },
    '鲍': {
        'A': '251', 'B': '251', 'C': '251', 'D': '251', 'E': '251', 'F': '251', 'G': '251', 'H': '251', 'I': '251',
        'J': '251', 'K': '251', 'L': '252', 'M': '252', 'N': '252', 'O': '252', 'P': '252', 'Q': '252', 'R': '252',
        'S': '252', 'T': '252', 'W': '253', 'X': '253', 'Y': '253', 'Z': '253'
    },
    '北京': {
        'A': '35', 'B': '35', 'C': '35', 'D': '35', 'E': '35', 'F': '35', 'G': '35', 'H': '36', 'I': '36', 'J': '36',
        'K': '36', 'L': '37', 'M': '37', 'N': '37', 'O': '37', 'P': '37', 'Q': '37', 'R': '37', 'S': '38', 'T': '38',
        'W': '39', 'X': '39', 'Y': '41', 'Z': '41'
    },
    '北京市': {
        'A': '28', 'B': '28', 'C': '28', 'D': '28', 'E': '28', 'F': '28', 'G': '28', 'H': '29', 'I': '29', 'J': '29',
        'K': '29', 'L': '31', 'M': '31', 'N': '31', 'O': '31', 'P': '31', 'Q': '31', 'R': '31', 'S': '32', 'T': '32',
        'W': '33', 'X': '33', 'Y': '34', 'Z': '34'
    },
    '贝': {
        'A': '413', 'B': '413', 'C': '413', 'D': '413', 'E': '413', 'F': '413', 'G': '413', 'H': '413', 'I': '414',
        'J': '414', 'K': '414', 'L': '414', 'M': '414', 'N': '414', 'O': '414', 'P': '414', 'Q': '414', 'R': '414',
        'S': '414', 'T': '414', 'W': '415', 'X': '415', 'Y': '415', 'Z': '415'
    },
    '比': {
        'A': '467', 'B': '467', 'C': '467', 'D': '467', 'E': '467', 'F': '467', 'G': '467', 'H': '467', 'I': '467',
        'J': '467', 'K': '467', 'L': '468', 'M': '468', 'N': '468', 'O': '468', 'P': '468', 'Q': '468', 'R': '468',
        'S': '468', 'T': '468', 'W': '469', 'X': '469', 'Y': '469', 'Z': '469'
    },
    '彼': {
        'A': '464', 'B': '464', 'C': '464', 'D': '464', 'E': '464', 'F': '464', 'G': '464', 'H': '464', 'I': '465',
        'J': '465', 'K': '465', 'L': '465', 'M': '465', 'N': '465', 'O': '465', 'P': '465', 'Q': '465', 'R': '465',
        'S': '465', 'T': '465', 'W': '466', 'X': '466', 'Y': '466', 'Z': '466'
    },
    '毕': {
        'A': '475', 'B': '475', 'C': '475', 'D': '475', 'E': '475', 'F': '475', 'G': '475', 'H': '475', 'I': '475',
        'J': '475', 'K': '475', 'L': '476', 'M': '476', 'N': '476', 'O': '476', 'P': '476', 'Q': '476', 'R': '476',
        'S': '476', 'T': '476', 'W': '477', 'X': '477', 'Y': '477', 'Z': '477'
    },
    '别': '549',
    '波': {
        'A': '591', 'B': '591', 'C': '591', 'D': '591', 'E': '591', 'F': '591', 'G': '591', 'H': '592', 'I': '592',
        'J': '592', 'K': '592', 'L': '593', 'M': '593', 'N': '593', 'O': '593', 'P': '593', 'Q': '593', 'R': '593',
        'S': '594', 'T': '594', 'W': '595', 'X': '595', 'Y': '596', 'Z': '596'
    },
    '勃': {
        'A': '621', 'B': '621', 'C': '621', 'D': '621', 'E': '621', 'F': '621', 'G': '621', 'H': '621', 'I': '621',
        'J': '621', 'K': '621', 'L': '622', 'M': '622', 'N': '622', 'O': '622', 'P': '622', 'Q': '622', 'R': '622',
        'S': '622', 'T': '622', 'W': '623', 'X': '623', 'Y': '623', 'Z': '623'
    },
    '布': {
        'A': '661', 'B': '661', 'C': '661', 'D': '661', 'E': '661', 'F': '661', 'G': '661', 'H': '662', 'I': '662',
        'J': '662', 'K': '662', 'L': '663', 'M': '663', 'N': '663', 'O': '663', 'P': '663', 'Q': '663', 'R': '663',
        'S': '664', 'T': '664', 'W': '665', 'X': '665', 'Y': '666', 'Z': '666'
    },
    '蔡': {
        'A': '131', 'B': '131', 'C': '131', 'D': '131', 'E': '131', 'F': '131', 'G': '131', 'H': '131', 'I': '131',
        'J': '131', 'K': '131', 'L': '132', 'M': '132', 'N': '132', 'O': '132', 'P': '132', 'Q': '132', 'R': '132',
        'S': '132', 'T': '132', 'W': '133', 'X': '133', 'Y': '133', 'Z': '133'
    },
    '曹': {
        'A': '163', 'B': '163', 'C': '163', 'D': '163', 'E': '163', 'F': '163', 'G': '163', 'H': '163', 'I': '163',
        'J': '163', 'K': '163', 'L': '164', 'M': '164', 'N': '164', 'O': '164', 'P': '164', 'Q': '164', 'R': '164',
        'S': '164', 'T': '164', 'W': '165', 'X': '165', 'Y': '165', 'Z': '165'
    },
    '陈': {
        'A': '325', 'B': '326', 'C': '327', 'D': '328', 'E': '329', 'F': '331', 'G': '332', 'H': '333', 'J': '334',
        'K': '335', 'L': '336', 'M': '337', 'N': '338', 'O': '339', 'P': '341', 'Q': '342', 'R': '343', 'S': '344',
        'T': '345', 'W': '346', 'X': '347', 'Y': '348', 'Z': '349'
    },
    '程': {
        'A': '382', 'B': '382', 'C': '382', 'D': '382', 'E': '382', 'F': '382', 'G': '382', 'H': '382', 'I': '382',
        'J': '382', 'K': '382', 'L': '383', 'M': '383', 'N': '383', 'O': '383', 'P': '383', 'Q': '383', 'R': '383',
        'S': '383', 'T': '383', 'W': '384', 'X': '384', 'Y': '384', 'Z': '384'
    },
    '崔': {
        'A': '661', 'B': '661', 'C': '661', 'D': '661', 'E': '661', 'F': '661', 'G': '661', 'H': '661', 'I': '661',
        'J': '661', 'K': '661', 'L': '662', 'M': '662', 'N': '662', 'O': '662', 'P': '662', 'Q': '662', 'R': '662',
        'S': '662', 'T': '662', 'W': '663', 'X': '663', 'Y': '663', 'Z': '663'
    },
    '戴': {
        'A': '125', 'B': '125', 'C': '125', 'D': '125', 'E': '125', 'F': '125', 'G': '125', 'H': '125', 'I': '125',
        'J': '125', 'K': '125', 'L': '126', 'M': '126', 'N': '126', 'O': '126', 'P': '126', 'Q': '126', 'R': '126',
        'S': '126', 'T': '126', 'W': '127', 'X': '127', 'Y': '127', 'Z': '127'
    },
    '德': {
        'A': '181', 'B': '181', 'C': '181', 'D': '181', 'E': '181', 'F': '181', 'G': '181', 'H': '181', 'I': '181',
        'J': '181', 'K': '181', 'L': '182', 'M': '182', 'N': '182', 'O': '182', 'P': '182', 'Q': '182', 'R': '182',
        'S': '182', 'T': '182', 'W': '183', 'X': '183', 'Y': '183', 'Z': '183'
    },
    '地质部': {
        'A': '26', 'B': '26', 'C': '26', 'D': '26', 'E': '26', 'F': '26', 'G': '26', 'H': '26', 'I': '26', 'J': '26',
        'K': '26', 'L': '27', 'M': '27', 'N': '27', 'O': '27', 'P': '27', 'Q': '27', 'R': '27', 'S': '27', 'T': '27',
        'W': '28', 'X': '28', 'Y': '28', 'Z': '28'
    },
    '邓': {
        'A': '196', 'B': '196', 'C': '196', 'D': '196', 'E': '196', 'F': '196', 'G': '196', 'H': '196', 'I': '196',
        'J': '196', 'K': '196', 'L': '197', 'M': '197', 'N': '197', 'O': '197', 'P': '197', 'Q': '197', 'R': '197',
        'S': '197', 'T': '197', 'W': '198', 'X': '198', 'Y': '198', 'Z': '198'
    },
    '狄': {
        'A': '225', 'B': '225', 'C': '225', 'D': '225', 'E': '225', 'F': '225', 'G': '225', 'H': '225', 'I': '225',
        'J': '225', 'K': '225', 'L': '226', 'M': '226', 'N': '226', 'O': '226', 'P': '226', 'Q': '226', 'R': '226',
        'S': '226', 'T': '226', 'W': '227', 'X': '227', 'Y': '227', 'Z': '227'
    },
    '丁': {
        'A': '451', 'B': '451', 'C': '451', 'D': '451', 'E': '451', 'F': '451', 'G': '451', 'H': '451', 'I': '451',
        'J': '451', 'K': '451', 'L': '452', 'M': '452', 'N': '452', 'O': '452', 'P': '452', 'Q': '452', 'R': '452',
        'S': '452', 'T': '452', 'W': '453', 'X': '453', 'Y': '453', 'Z': '453'
    },
    '董': {
        'A': '475', 'B': '475', 'C': '475', 'D': '475', 'E': '475', 'F': '475', 'G': '475', 'H': '475', 'I': '475',
        'J': '475', 'K': '475', 'L': '476', 'M': '476', 'N': '476', 'O': '476', 'P': '476', 'Q': '476', 'R': '476',
        'S': '476', 'T': '476', 'W': '477', 'X': '477', 'Y': '477', 'Z': '477'
    },
    '杜': {
        'A': '541', 'B': '541', 'C': '541', 'D': '541', 'E': '541', 'F': '541', 'G': '541', 'H': '541', 'I': '541',
        'J': '541', 'K': '541', 'L': '542', 'M': '542', 'N': '542', 'O': '542', 'P': '542', 'Q': '542', 'R': '542',
        'S': '542', 'T': '542', 'W': '543', 'X': '543', 'Y': '543', 'Z': '543'
    },
    '段': {
        'A': '556', 'B': '556', 'C': '556', 'D': '556', 'E': '556', 'F': '556', 'G': '556', 'H': '556', 'I': '556',
        'J': '556', 'K': '556', 'L': '557', 'M': '557', 'N': '557', 'O': '557', 'P': '557', 'Q': '557', 'R': '557',
        'S': '557', 'T': '557', 'W': '558', 'X': '558', 'Y': '558', 'Z': '558'
    },
    '多': {
        'A': '615', 'B': '615', 'C': '615', 'D': '615', 'E': '615', 'F': '615', 'G': '615', 'H': '615', 'I': '615',
        'J': '615', 'K': '615', 'L': '616', 'M': '616', 'N': '616', 'O': '616', 'P': '616', 'Q': '616', 'R': '616',
        'S': '616', 'T': '616', 'W': '617', 'X': '617', 'Y': '617', 'Z': '617'
    },
    '法': {
        'A': '121', 'B': '121', 'C': '121', 'D': '121', 'E': '121', 'F': '121', 'G': '121', 'H': '121', 'I': '121',
        'J': '121', 'K': '121', 'L': '122', 'M': '122', 'N': '122', 'O': '122', 'P': '122', 'Q': '122', 'R': '122',
        'S': '122', 'T': '122', 'W': '123', 'X': '123', 'Y': '123', 'Z': '123'
    },
    '樊': {
        'A': '135', 'B': '135', 'C': '135', 'D': '135', 'E': '135', 'F': '135', 'G': '135', 'H': '135', 'I': '135',
        'J': '135', 'K': '135', 'L': '136', 'M': '136', 'N': '136', 'O': '136', 'P': '136', 'Q': '136', 'R': '136',
        'S': '136', 'T': '136', 'W': '137', 'X': '137', 'Y': '137', 'Z': '137'
    },
    '范': {
        'A': '155', 'B': '155', 'C': '155', 'D': '155', 'E': '155', 'F': '155', 'G': '155', 'H': '155', 'I': '155',
        'J': '155', 'K': '155', 'L': '156', 'M': '156', 'N': '156', 'O': '156', 'P': '156', 'Q': '156', 'R': '156',
        'S': '156', 'T': '156', 'W': '157', 'X': '157', 'Y': '157', 'Z': '157'
    },
    '方': {
        'A': '171', 'B': '171', 'C': '171', 'D': '171', 'E': '171', 'F': '171', 'G': '171', 'H': '171', 'I': '171',
        'J': '171', 'K': '171', 'L': '172', 'M': '172', 'N': '172', 'O': '172', 'P': '172', 'Q': '172', 'R': '172',
        'S': '172', 'T': '172', 'W': '173', 'X': '173', 'Y': '173', 'Z': '173'
    },
    '菲': {
        'A': '211', 'B': '211', 'C': '211', 'D': '211', 'E': '211', 'F': '211', 'G': '211', 'H': '211', 'I': '211',
        'J': '211', 'K': '212', 'L': '212', 'M': '212', 'N': '212', 'O': '212', 'P': '212', 'Q': '212', 'R': '212',
        'S': '212', 'T': '212', 'W': '213', 'X': '213', 'Y': '213', 'Z': '213'
    },
    '费': {
        'A': '231', 'B': '231', 'C': '231', 'D': '231', 'E': '231', 'F': '231', 'G': '231', 'H': '232', 'I': '232',
        'J': '232', 'K': '232', 'L': '233', 'M': '233', 'N': '233', 'O': '233', 'P': '233', 'Q': '233', 'R': '233',
        'S': '234', 'T': '234', 'W': '235', 'X': '235', 'Y': '236', 'Z': '236'
    },
    '冯': {
        'A': '291', 'B': '291', 'C': '291', 'D': '291', 'E': '291', 'F': '291', 'G': '291', 'H': '291', 'I': '291',
        'J': '291', 'K': '291', 'L': '292', 'M': '292', 'N': '292', 'O': '292', 'P': '292', 'Q': '292', 'R': '292',
        'S': '292', 'T': '292', 'W': '293', 'X': '293', 'Y': '293', 'Z': '293'
    },
    '弗': {
        'A': '395', 'B': '395', 'C': '395', 'D': '395', 'E': '395', 'F': '395', 'G': '395', 'H': '395', 'I': '395',
        'J': '395', 'K': '395', 'L': '396', 'M': '396', 'N': '396', 'O': '396', 'P': '396', 'Q': '396', 'R': '396',
        'S': '396', 'T': '396', 'W': '397', 'X': '397', 'Y': '397', 'Z': '397'
    },
    '伏': {
        'A': '392', 'B': '392', 'C': '392', 'D': '392', 'E': '392', 'F': '392', 'G': '392', 'H': '392', 'I': '392',
        'J': '392', 'K': '392', 'L': '393', 'M': '393', 'N': '393', 'O': '393', 'P': '393', 'Q': '393', 'R': '393',
        'S': '393', 'T': '393', 'W': '394', 'X': '394', 'Y': '394', 'Z': '394'
    },
    '符': {
        'A': '398', 'B': '398', 'C': '398', 'D': '398', 'E': '398', 'F': '398', 'G': '398', 'H': '398', 'I': '398',
        'J': '398', 'K': '398', 'L': '399', 'M': '399', 'N': '399', 'O': '399', 'P': '399', 'Q': '399', 'R': '399',
        'S': '399', 'T': '399', 'W': '411', 'X': '411', 'Y': '411', 'Z': '411'
    },
    '福建': {
        'A': '34', 'B': '34', 'C': '34', 'D': '34', 'E': '34', 'F': '34', 'G': '34', 'H': '34', 'I': '34', 'J': '34',
        'K': '34', 'L': '35', 'M': '35', 'N': '35', 'O': '35', 'P': '35', 'Q': '35', 'R': '35', 'S': '35', 'T': '35',
        'W': '36', 'X': '36', 'Y': '36', 'Z': '36'
    },
    '福州': {
        'A': '37', 'B': '37', 'C': '37', 'D': '37', 'E': '37', 'F': '37', 'G': '37', 'H': '37', 'I': '37', 'J': '37',
        'K': '37', 'L': '38', 'M': '38', 'N': '38', 'O': '38', 'P': '38', 'Q': '38', 'R': '38', 'S': '38', 'T': '38',
        'W': '39', 'X': '39', 'Y': '39', 'Z': '39'
    },
    '傅': {
        'A': '452', 'B': '452', 'C': '452', 'D': '452', 'E': '452', 'F': '452', 'G': '452', 'H': '452', 'I': '452',
        'J': '452', 'K': '452', 'L': '453', 'M': '453', 'N': '453', 'O': '453', 'P': '453', 'Q': '453', 'R': '453',
        'S': '453', 'T': '453', 'W': '454', 'X': '454', 'Y': '454', 'Z': '454'
    },
    '富': {
        'A': '455', 'B': '455', 'C': '455', 'D': '455', 'E': '455', 'F': '455', 'G': '455', 'H': '455', 'I': '455',
        'J': '455', 'K': '455', 'L': '456', 'M': '456', 'N': '456', 'O': '456', 'P': '456', 'Q': '456', 'R': '456',
        'S': '456', 'T': '456', 'W': '457', 'X': '457', 'Y': '457', 'Z': '457'
    },
    '盖': '314', '甘肃': {
        'A': '14', 'B': '14', 'C': '14', 'D': '14', 'E': '14', 'F': '14', 'G': '14', 'H': '15', 'I': '15', 'J': '15',
        'K': '15', 'L': '16', 'M': '16', 'N': '16', 'O': '16', 'P': '16', 'Q': '16', 'R': '16', 'S': '17', 'T': '17',
        'W': '18', 'X': '18', 'Y': '19', 'Z': '19'
    },
    '高': {
        'A': '241', 'B': '241', 'C': '241', 'D': '241', 'E': '242', 'F': '242', 'G': '242', 'H': '243', 'I': '243',
        'J': '243', 'K': '243', 'L': '244', 'M': '244', 'N': '244', 'O': '245', 'P': '245', 'Q': '245', 'R': '245',
        'S': '246', 'T': '246', 'W': '247', 'X': '247', 'Y': '248', 'Z': '249'
    },
    '戈': {
        'A': '271', 'B': '271', 'C': '271', 'D': '271', 'E': '271', 'F': '271', 'G': '271', 'H': '271', 'I': '271',
        'J': '271', 'K': '271', 'L': '272', 'M': '272', 'N': '272', 'O': '272', 'P': '272', 'Q': '272', 'R': '272',
        'S': '272', 'T': '272', 'W': '273', 'X': '273', 'Y': '273', 'Z': '273'
    },
    '格': {
        'A': '281', 'B': '281', 'C': '281', 'D': '281', 'E': '281', 'F': '281', 'G': '281', 'H': '282', 'I': '282',
        'J': '282', 'K': '282', 'L': '283', 'M': '283', 'N': '283', 'O': '283', 'P': '283', 'Q': '283', 'R': '283',
        'S': '284', 'T': '284', 'W': '285', 'X': '285', 'Y': '286', 'Z': '286'
    },
    '葛': {
        'A': '311', 'B': '311', 'C': '311', 'D': '311', 'E': '311', 'F': '311', 'G': '311', 'H': '311', 'I': '311',
        'J': '311', 'K': '311', 'L': '312', 'M': '312', 'N': '312', 'O': '312', 'P': '312', 'Q': '312', 'R': '312',
        'S': '312', 'T': '312', 'W': '313', 'X': '313', 'Y': '313', 'Z': '313'
    },
    '耿': {
        'A': '335', 'B': '335', 'C': '335', 'D': '335', 'E': '335', 'F': '335', 'G': '335', 'H': '335', 'I': '335',
        'J': '335', 'K': '335', 'L': '336', 'M': '336', 'N': '336', 'O': '336', 'P': '336', 'Q': '336', 'R': '336',
        'S': '336', 'T': '336', 'W': '337', 'X': '337', 'Y': '337', 'Z': '337'
    },
    '龚': {
        'A': '353', 'B': '353', 'C': '353', 'D': '353', 'E': '353', 'F': '353', 'G': '353', 'H': '353', 'I': '353',
        'J': '353', 'K': '353', 'L': '354', 'M': '354', 'N': '354', 'O': '354', 'P': '354', 'Q': '354', 'R': '354',
        'S': '354', 'T': '354', 'W': '355', 'X': '355', 'Y': '355', 'Z': '355'
    },
    '共青团': {
        'A': '37', 'B': '37', 'C': '37', 'D': '37', 'E': '37', 'F': '37', 'G': '37', 'H': '37', 'I': '37', 'J': '37',
        'K': '37', 'L': '38', 'M': '38', 'N': '38', 'O': '38', 'P': '38', 'Q': '38', 'R': '38', 'S': '38', 'T': '38',
        'W': '39', 'X': '39', 'Y': '39', 'Z': '39'
    },
    '谷': {
        'A': '441', 'B': '441', 'C': '441', 'D': '441', 'E': '441', 'F': '441', 'G': '441', 'H': '441', 'I': '441',
        'J': '441', 'K': '441', 'L': '442', 'M': '442', 'N': '442', 'O': '442', 'P': '442', 'Q': '442', 'R': '442',
        'S': '442', 'T': '442', 'W': '443', 'X': '443', 'Y': '443', 'Z': '443'
    },
    '顾': {
        'A': '461', 'B': '461', 'C': '461', 'D': '461', 'E': '461', 'F': '461', 'G': '461', 'H': '461', 'I': '461',
        'J': '461', 'K': '461', 'L': '462', 'M': '462', 'N': '462', 'O': '462', 'P': '462', 'Q': '462', 'R': '462',
        'S': '462', 'T': '462', 'W': '463', 'X': '463', 'Y': '463', 'Z': '463'
    },
    '关': {
        'A': '485', 'B': '485', 'C': '485', 'D': '485', 'E': '485', 'F': '485', 'G': '485', 'H': '485', 'I': '485',
        'J': '485', 'K': '485', 'L': '486', 'M': '486', 'N': '486', 'O': '486', 'P': '486', 'Q': '486', 'R': '486',
        'S': '486', 'T': '486', 'W': '487', 'X': '487', 'Y': '487', 'Z': '487'
    },
    '广东': {
        'A': '53', 'B': '53', 'C': '53', 'D': '53', 'E': '53', 'F': '53', 'G': '53', 'H': '53', 'I': '53', 'J': '53',
        'K': '53', 'L': '54', 'M': '54', 'N': '54', 'O': '54', 'P': '54', 'Q': '54', 'R': '54', 'S': '54', 'T': '54',
        'W': '55', 'X': '55', 'Y': '55', 'Z': '55'
    },
    '广西': {
        'A': '56', 'B': '56', 'C': '56', 'D': '56', 'E': '56', 'F': '56', 'G': '56', 'H': '56', 'I': '56', 'J': '56',
        'K': '56', 'L': '57', 'M': '57', 'N': '57', 'O': '57', 'P': '57', 'Q': '57', 'R': '57', 'S': '57', 'T': '57',
        'W': '58', 'X': '58', 'Y': '58', 'Z': '58'
    },
    '广州': {
        'A': '59', 'B': '59', 'C': '59', 'D': '59', 'E': '59', 'F': '59', 'G': '59', 'H': '59', 'I': '59', 'J': '59',
        'K': '59', 'L': '61', 'M': '61', 'N': '61', 'O': '61', 'P': '61', 'Q': '61', 'R': '61', 'S': '61', 'T': '61',
        'W': '62', 'X': '62', 'Y': '62', 'Z': '62'
    },
    '贵州': {
        'A': '66', 'B': '66', 'C': '66', 'D': '66', 'E': '66', 'F': '66', 'G': '66', 'H': '66', 'I': '66', 'J': '66',
        'K': '66', 'L': '67', 'M': '67', 'N': '67', 'O': '67', 'P': '67', 'Q': '67', 'R': '67', 'S': '67', 'T': '67',
        'W': '68', 'X': '68', 'Y': '68', 'Z': '68'
    },
    '郭': {
        'A': '711', 'B': '711', 'C': '711', 'D': '711', 'E': '711', 'F': '711', 'G': '711', 'H': '711', 'I': '711',
        'J': '711', 'K': '711', 'L': '712', 'M': '712', 'N': '712', 'O': '712', 'P': '712', 'Q': '712', 'R': '712',
        'S': '712', 'T': '712', 'W': '713', 'X': '713', 'Y': '713', 'Z': '713'
    },
    '国': {
        'A': '751', 'B': '751', 'C': '751', 'D': '751', 'E': '751', 'F': '751', 'G': '751', 'H': '751', 'I': '751',
        'J': '751', 'K': '751', 'L': '752', 'M': '752', 'N': '752', 'O': '752', 'P': '752', 'Q': '752', 'R': '752',
        'S': '752', 'T': '752', 'W': '753', 'X': '753', 'Y': '753', 'Z': '753'
    },
    '国务院': {
        'A': '73', 'B': '73', 'C': '73', 'D': '73', 'E': '73', 'F': '73', 'G': '73', 'H': '73', 'I': '73', 'J': '73',
        'K': '73', 'L': '74', 'M': '74', 'N': '74', 'O': '74', 'P': '74', 'Q': '74', 'R': '74', 'S': '74', 'T': '74',
        'W': '75', 'X': '75', 'Y': '75', 'Z': '75'
    },
    '哈': {
        'A': '131', 'B': '131', 'C': '131', 'D': '131', 'E': '131', 'F': '131', 'G': '131', 'H': '131', 'I': '131',
        'J': '131', 'K': '131', 'L': '132', 'M': '132', 'N': '132', 'O': '132', 'P': '132', 'Q': '132', 'R': '132',
        'S': '132', 'T': '132', 'W': '133', 'X': '133', 'Y': '133', 'Z': '133'
    },
    '哈尔滨': {
        'A': '11', 'B': '11', 'C': '11', 'D': '11', 'E': '11', 'F': '11', 'G': '11', 'H': '11', 'I': '11', 'J': '11',
        'K': '11', 'L': '12', 'M': '12', 'N': '12', 'O': '12', 'P': '12', 'Q': '12', 'R': '12', 'S': '12', 'T': '12',
        'W': '13', 'X': '13', 'Y': '13', 'Z': '13'
    },
    '海': {
        'A': '145', 'B': '145', 'C': '145', 'D': '145', 'E': '145', 'F': '145', 'G': '145', 'H': '145', 'I': '145',
        'J': '145', 'K': '145', 'L': '146', 'M': '146', 'N': '146', 'O': '146', 'P': '146', 'Q': '146', 'R': '146',
        'S': '146', 'T': '146', 'W': '147', 'X': '147', 'Y': '147', 'Z': '147'
    },
    '韩': {
        'A': '164', 'B': '164', 'C': '164', 'D': '164', 'E': '164', 'F': '164', 'G': '164', 'H': '164', 'I': '164',
        'J': '164', 'K': '164', 'L': '165', 'M': '165', 'N': '165', 'O': '165', 'P': '165', 'Q': '165', 'R': '165',
        'S': '165', 'T': '165', 'W': '166', 'X': '166', 'Y': '166', 'Z': '166'
    },
    '郝': {
        'A': '236', 'B': '236', 'C': '236', 'D': '236', 'E': '236', 'F': '236', 'G': '236', 'H': '236', 'I': '236',
        'J': '236', 'K': '236', 'L': '237', 'M': '237', 'N': '237', 'O': '237', 'P': '237', 'Q': '237', 'R': '237',
        'S': '237', 'T': '237', 'W': '238', 'X': '238', 'Y': '238', 'Z': '238'
    },
    '何': {
        'A': '334', 'B': '334', 'C': '334', 'D': '334', 'E': '334', 'F': '334', 'G': '334', 'H': '334', 'I': '334',
        'J': '334', 'K': '334', 'L': '335', 'M': '335', 'N': '335', 'O': '335', 'P': '335', 'Q': '335', 'R': '335',
        'S': '335', 'T': '335', 'W': '336', 'X': '336', 'Y': '336', 'Z': '336'
    },
    '河北': {
        'A': '26', 'B': '26', 'C': '26', 'D': '26', 'E': '26', 'F': '26', 'G': '26', 'H': '26', 'I': '26', 'J': '26',
        'K': '26', 'L': '27', 'M': '27', 'N': '27', 'O': '27', 'P': '27', 'Q': '27', 'R': '27', 'S': '27', 'T': '27',
        'W': '28', 'X': '28', 'Y': '28', 'Z': '28'
    },
    '河南': {
        'A': '29', 'B': '29', 'C': '29', 'D': '29', 'E': '29', 'F': '29', 'G': '29', 'H': '29', 'I': '29', 'J': '29',
        'K': '29', 'L': '31', 'M': '31', 'N': '31', 'O': '31', 'P': '31', 'Q': '31', 'R': '31', 'S': '31', 'T': '31',
        'W': '32', 'X': '32', 'Y': '32', 'Z': '32'
    },
    '贺': {
        'A': '341', 'B': '341', 'C': '341', 'D': '341', 'E': '341', 'F': '341', 'G': '341', 'H': '341', 'I': '341',
        'J': '341', 'K': '341', 'L': '342', 'M': '342', 'N': '342', 'O': '342', 'P': '342', 'Q': '342', 'R': '342',
        'S': '342', 'T': '342', 'W': '343', 'X': '343', 'Y': '343', 'Z': '343'
    },
    '赫': {
        'A': '344', 'B': '344', 'C': '344', 'D': '344', 'E': '344', 'F': '344', 'G': '344', 'H': '344', 'I': '344',
        'J': '344', 'K': '344', 'L': '345', 'M': '345', 'N': '345', 'O': '345', 'P': '345', 'Q': '345', 'R': '345',
        'S': '345', 'T': '345', 'W': '346', 'X': '346', 'Y': '346', 'Z': '346'
    },
    '黑龙江': {
        'A': '35', 'B': '35', 'C': '35', 'D': '35', 'E': '35', 'F': '35', 'G': '35', 'H': '35', 'I': '35', 'J': '35',
        'K': '35', 'L': '36', 'M': '36', 'N': '36', 'O': '36', 'P': '36', 'Q': '36', 'R': '36', 'S': '36', 'T': '36',
        'W': '37', 'X': '37', 'Y': '37', 'Z': '37'
    },
    '洪': {
        'A': '394', 'B': '394', 'C': '394', 'D': '394', 'E': '394', 'F': '394', 'G': '394', 'H': '394', 'I': '394',
        'J': '394', 'K': '394', 'L': '395', 'M': '395', 'N': '395', 'O': '395', 'P': '395', 'Q': '395', 'R': '395',
        'S': '395', 'T': '395', 'W': '396', 'X': '396', 'Y': '396', 'Z': '396'
    },
    '侯': {
        'A': '423', 'B': '423', 'C': '423', 'D': '423', 'E': '423', 'F': '423', 'G': '423', 'H': '423', 'I': '423',
        'J': '423', 'K': '423', 'L': '424', 'M': '424', 'N': '424', 'O': '424', 'P': '424', 'Q': '424', 'R': '424',
        'S': '424', 'T': '424', 'W': '425', 'X': '425', 'Y': '425', 'Z': '425'
    },
    '胡': {
        'A': '572', 'B': '572', 'C': '572', 'D': '572', 'E': '572', 'F': '572', 'G': '572', 'H': '573', 'I': '573',
        'J': '573', 'K': '573', 'L': '574', 'M': '574', 'N': '574', 'O': '574', 'P': '574', 'Q': '574', 'R': '574',
        'S': '575', 'T': '575', 'W': '576', 'X': '576', 'Y': '577', 'Z': '577'
    },
    '湖北': {
        'A': '45', 'B': '45', 'C': '45', 'D': '45', 'E': '45', 'F': '45', 'G': '45', 'H': '46', 'I': '46', 'J': '46',
        'K': '46', 'L': '47', 'M': '47', 'N': '47', 'O': '47', 'P': '47', 'Q': '47', 'R': '47', 'S': '48', 'T': '48',
        'W': '49', 'X': '49', 'Y': '51', 'Z': '51'
    },
    '湖南': {
        'A': '52', 'B': '52', 'C': '52', 'D': '52', 'E': '52', 'F': '52', 'G': '52', 'H': '53', 'I': '53', 'J': '53',
        'K': '53', 'L': '54', 'M': '54', 'N': '54', 'O': '54', 'P': '54', 'Q': '54', 'R': '54', 'S': '55', 'T': '55',
        'W': '56', 'X': '56', 'Y': '57', 'Z': '57'
    },
    '华北': {
        'A': '62', 'B': '62', 'C': '62', 'D': '62', 'E': '62', 'F': '62', 'G': '62', 'H': '62', 'I': '62', 'J': '62',
        'K': '62', 'L': '63', 'M': '63', 'N': '63', 'O': '63', 'P': '63', 'Q': '63', 'R': '63', 'S': '63', 'T': '63',
        'W': '64', 'X': '64', 'Y': '64', 'Z': '64'
    },
    '华东': {
        'A': '65', 'B': '65', 'C': '65', 'D': '65', 'E': '65', 'F': '65', 'G': '65', 'H': '65', 'I': '65', 'J': '65',
        'K': '65', 'L': '66', 'M': '66', 'N': '66', 'O': '66', 'P': '66', 'Q': '66', 'R': '66', 'S': '66', 'T': '66',
        'W': '67', 'X': '67', 'Y': '67', 'Z': '67'
    },
    '华南': {
        'A': '68', 'B': '68', 'C': '68', 'D': '68', 'E': '68', 'F': '68', 'G': '68', 'H': '68', 'I': '68', 'J': '68',
        'K': '68', 'L': '69', 'M': '69', 'N': '69', 'O': '69', 'P': '69', 'Q': '69', 'R': '69', 'S': '69', 'T': '69',
        'W': '71', 'X': '71', 'Y': '71', 'Z': '71'
    },
    '化学工业部': {
        'A': '73', 'B': '73', 'C': '73', 'D': '73', 'E': '73', 'F': '73', 'G': '73', 'H': '73', 'I': '73', 'J': '73',
        'K': '73', 'L': '74', 'M': '74', 'N': '74', 'O': '74', 'P': '74', 'Q': '74', 'R': '74', 'S': '74', 'T': '74',
        'W': '75', 'X': '75', 'Y': '75', 'Z': '75'
    },
    '黄': {
        'A': '851', 'B': '851', 'C': '851', 'D': '851', 'E': '851', 'F': '851', 'G': '851', 'H': '851', 'I': '851',
        'J': '851', 'K': '851', 'L': '852', 'M': '852', 'N': '852', 'O': '852', 'P': '852', 'Q': '852', 'R': '852',
        'S': '852', 'T': '852', 'W': '853', 'X': '853', 'Y': '853', 'Z': '853'
    },
    '黄河': {
        'A': '79', 'B': '79', 'C': '79', 'D': '79', 'E': '79', 'F': '79', 'G': '79', 'H': '81', 'I': '81', 'J': '81',
        'K': '81', 'L': '82', 'M': '82', 'N': '82', 'O': '82', 'P': '82', 'Q': '82', 'R': '82', 'S': '83', 'T': '83',
        'W': '84', 'X': '84', 'Y': '85', 'Z': '85'
    },
    '霍': {
        'A': '931', 'B': '931', 'C': '931', 'D': '931', 'E': '931', 'F': '931', 'G': '931', 'H': '931', 'I': '931',
        'J': '931', 'K': '931', 'L': '932', 'M': '932', 'N': '932', 'O': '932', 'P': '932', 'Q': '932', 'R': '932',
        'S': '932', 'T': '932', 'W': '933', 'X': '933', 'Y': '933', 'Z': '933'
    },
    '机械': {
        'A': '11', 'B': '11', 'C': '11', 'D': '11', 'E': '11', 'F': '11', 'G': '11', 'H': '11', 'I': '11', 'J': '11',
        'K': '11', 'L': '12', 'M': '12', 'N': '12', 'O': '12', 'P': '12', 'Q': '12', 'R': '12', 'S': '12', 'T': '12',
        'W': '13', 'X': '13', 'Y': '13', 'Z': '13'
    },
    '吉': {
        'A': '211', 'B': '211', 'C': '211', 'D': '211', 'E': '211', 'F': '211', 'G': '211', 'H': '211', 'I': '211',
        'J': '211', 'K': '211', 'L': '212', 'M': '212', 'N': '212', 'O': '212', 'P': '212', 'Q': '212', 'R': '212',
        'S': '212', 'T': '212', 'W': '213', 'X': '213', 'Y': '213', 'Z': '213'
    },
    '吉林': {
        'A': '15', 'B': '15', 'C': '15', 'D': '15', 'E': '15', 'F': '15', 'G': '15', 'H': '16', 'I': '16', 'J': '16',
        'K': '16', 'L': '17', 'M': '17', 'N': '17', 'O': '17', 'P': '17', 'Q': '17', 'R': '17', 'S': '18', 'T': '18',
        'W': '19', 'X': '19', 'Y': '21', 'Z': '21'
    },
    '纪': {
        'A': '241', 'B': '241', 'C': '241', 'D': '241', 'E': '241', 'F': '241', 'G': '241', 'H': '241', 'I': '241',
        'J': '241', 'K': '241', 'L': '242', 'M': '242', 'N': '242', 'O': '242', 'P': '242', 'Q': '242', 'R': '242',
        'S': '242', 'T': '242', 'W': '243', 'X': '243', 'Y': '243', 'Z': '243'
    },
    '季': {
        'A': '244', 'B': '244', 'C': '244', 'D': '244', 'E': '244', 'F': '244', 'G': '244', 'H': '244', 'I': '244',
        'J': '244', 'K': '244', 'L': '245', 'M': '245', 'N': '245', 'O': '245', 'P': '245', 'Q': '245', 'R': '245',
        'S': '245', 'T': '245', 'W': '246', 'X': '246', 'Y': '246', 'Z': '246'
    },
    '冀': {
        'A': '247', 'B': '247', 'C': '247', 'D': '247', 'E': '247', 'F': '247', 'G': '247', 'H': '247', 'I': '247',
        'J': '247', 'K': '247', 'L': '248', 'M': '248', 'N': '248', 'O': '248', 'P': '248', 'Q': '248', 'R': '248',
        'S': '248', 'T': '248', 'W': '249', 'X': '249', 'Y': '249', 'Z': '249'
    },
    '加': {
        'A': '271', 'B': '271', 'C': '271', 'D': '271', 'E': '271', 'F': '271', 'G': '271', 'H': '271', 'I': '271',
        'J': '271', 'K': '271', 'L': '272', 'M': '272', 'N': '272', 'O': '272', 'P': '272', 'Q': '272', 'R': '272',
        'S': '272', 'T': '272', 'W': '273', 'X': '273', 'Y': '273', 'Z': '273'
    },
    '贾': {
        'A': '295', 'B': '295', 'C': '295', 'D': '295', 'E': '295', 'F': '295', 'G': '295', 'H': '295', 'I': '295',
        'J': '295', 'K': '295', 'L': '296', 'M': '296', 'N': '296', 'O': '296', 'P': '296', 'Q': '296', 'R': '296',
        'S': '296', 'T': '296', 'W': '297', 'X': '297', 'Y': '297', 'Z': '297'
    },
    '建筑工程部': {
        'A': '36', 'B': '36', 'C': '36', 'D': '36', 'E': '36', 'F': '36', 'G': '36', 'H': '36', 'I': '36', 'J': '36',
        'K': '36', 'L': '37', 'M': '37', 'N': '37', 'O': '37', 'P': '37', 'Q': '37', 'R': '37', 'S': '37', 'T': '37',
        'W': '38', 'X': '38', 'Y': '38', 'Z': '38'
    },
    '江': {
        'A': '491', 'B': '491', 'C': '491', 'D': '491', 'E': '491', 'F': '491', 'G': '491', 'H': '491', 'I': '491',
        'J': '491', 'K': '491', 'L': '492', 'M': '492', 'N': '492', 'O': '492', 'P': '492', 'Q': '492', 'R': '492',
        'S': '492', 'T': '492', 'W': '493', 'X': '493', 'Y': '493', 'Z': '493'
    },
    '江苏': {
        'A': '41', 'B': '41', 'C': '41', 'D': '41', 'E': '41', 'F': '41', 'G': '41', 'H': '42', 'I': '42', 'J': '42',
        'K': '42', 'L': '43', 'M': '43', 'N': '43', 'O': '43', 'P': '43', 'Q': '43', 'R': '43', 'S': '44', 'T': '44',
        'W': '45', 'X': '45', 'Y': '46', 'Z': '46'
    },
    '江西': {
        'A': '47', 'B': '47', 'C': '47', 'D': '47', 'E': '47', 'F': '47', 'G': '47', 'H': '47', 'I': '47', 'J': '47',
        'K': '47', 'L': '48', 'M': '48', 'N': '48', 'O': '48', 'P': '48', 'Q': '48', 'R': '48', 'S': '48', 'T': '48',
        'W': '49', 'X': '49', 'Y': '49', 'Z': '49'
    },
    '姜': {
        'A': '494', 'B': '494', 'C': '494', 'D': '494', 'E': '494', 'F': '494', 'G': '494', 'H': '494', 'I': '494',
        'J': '494', 'K': '494', 'L': '495', 'M': '495', 'N': '495', 'O': '495', 'P': '495', 'Q': '495', 'R': '495',
        'S': '495', 'T': '495', 'W': '496', 'X': '496', 'Y': '496', 'Z': '496'
    },
    '蒋': {
        'A': '511', 'B': '511', 'C': '511', 'D': '511', 'E': '511', 'F': '511', 'G': '511', 'H': '511', 'I': '511',
        'J': '511', 'K': '511', 'L': '512', 'M': '512', 'N': '512', 'O': '512', 'P': '512', 'Q': '512', 'R': '512',
        'S': '512', 'T': '512', 'W': '513', 'X': '513', 'Y': '513', 'Z': '513'
    },
    '交通部': {
        'A': '53', 'B': '53', 'C': '53', 'D': '53', 'E': '53', 'F': '53', 'G': '53', 'H': '53', 'I': '53', 'J': '53',
        'K': '53', 'L': '54', 'M': '54', 'N': '54', 'O': '54', 'P': '54', 'Q': '54', 'R': '54', 'S': '54', 'T': '54',
        'W': '55', 'X': '55', 'Y': '55', 'Z': '55'
    },
    '杰': {
        'A': '591', 'B': '591', 'C': '591', 'D': '591', 'E': '591', 'F': '591', 'G': '591', 'H': '591', 'I': '591',
        'J': '591', 'K': '591', 'L': '592', 'M': '592', 'N': '592', 'O': '592', 'P': '592', 'Q': '592', 'R': '592',
        'S': '592', 'T': '592', 'W': '593', 'X': '593', 'Y': '593', 'Z': '593'
    },
    '捷': {
        'A': '594', 'B': '594', 'C': '594', 'D': '594', 'E': '594', 'F': '594', 'G': '594', 'H': '594', 'I': '594',
        'J': '594', 'K': '594', 'L': '595', 'M': '595', 'N': '595', 'O': '595', 'P': '595', 'Q': '595', 'R': '595',
        'S': '595', 'T': '595', 'W': '596', 'X': '596', 'Y': '596', 'Z': '596'
    },
    '金': {
        'A': '631', 'B': '631', 'C': '631', 'D': '631', 'E': '631', 'F': '631', 'G': '631', 'H': '632', 'I': '632',
        'J': '632', 'K': '632', 'L': '633', 'M': '633', 'N': '633', 'O': '633', 'P': '633', 'Q': '633', 'R': '633',
        'S': '634', 'T': '634', 'W': '635', 'X': '635', 'Y': '636', 'Z': '636'
    },
    '晋': {
        'A': '661', 'B': '661', 'C': '661', 'D': '661', 'E': '661', 'F': '661', 'G': '661', 'H': '661', 'I': '661',
        'J': '661', 'K': '661', 'L': '662', 'M': '662', 'N': '662', 'O': '662', 'P': '662', 'Q': '662', 'R': '662',
        'S': '662', 'T': '662', 'W': '663', 'X': '663', 'Y': '663', 'Z': '663'
    },
    '靳': {
        'A': '664', 'B': '664', 'C': '664', 'D': '664', 'E': '664', 'F': '664', 'G': '664', 'H': '664', 'I': '664',
        'J': '664', 'K': '664', 'L': '665', 'M': '665', 'N': '665', 'O': '665', 'P': '665', 'Q': '665', 'R': '665',
        'S': '665', 'T': '665', 'W': '666', 'X': '666', 'Y': '666', 'Z': '666'
    },
    '卡': '173', '凯': {
        'A': '134', 'B': '134', 'C': '134', 'D': '134', 'E': '134', 'F': '134', 'G': '134', 'H': '134', 'I': '134',
        'J': '134', 'K': '134', 'L': '135', 'M': '135', 'N': '135', 'O': '135', 'P': '135', 'Q': '135', 'R': '135',
        'S': '135', 'T': '135', 'W': '136', 'X': '136', 'Y': '136', 'Z': '136'
    },
    '康': {
        'A': '163', 'B': '163', 'C': '163', 'D': '163', 'E': '163', 'F': '163', 'G': '163', 'H': '163', 'I': '163',
        'J': '163', 'K': '163', 'L': '164', 'M': '164', 'N': '164', 'O': '164', 'P': '164', 'Q': '164', 'R': '164',
        'S': '164', 'T': '164', 'W': '165', 'X': '165', 'Y': '165', 'Z': '165'
    },
    '考': {
        'A': '181', 'B': '181', 'C': '181', 'D': '181', 'E': '181', 'F': '181', 'G': '181', 'H': '181', 'I': '181',
        'J': '181', 'K': '181', 'L': '182', 'M': '182', 'N': '182', 'O': '182', 'P': '182', 'Q': '182', 'R': '182',
        'S': '182', 'T': '182', 'W': '183', 'X': '183', 'Y': '183', 'Z': '183'
    },
    '柯': {
        'A': '227', 'B': '227', 'C': '227', 'D': '227', 'E': '227', 'F': '227', 'G': '227', 'H': '228', 'I': '228',
        'J': '228', 'K': '228', 'L': '229', 'M': '229', 'N': '229', 'O': '229', 'P': '229', 'Q': '229', 'R': '229',
        'S': '231', 'T': '231', 'W': '232', 'X': '232', 'Y': '233', 'Z': '233'
    },
    '科': {
        'A': '221', 'B': '221', 'C': '221', 'D': '221', 'E': '221', 'F': '221', 'G': '221', 'H': '222', 'I': '222',
        'J': '222', 'K': '222', 'L': '223', 'M': '223', 'N': '223', 'O': '223', 'P': '223', 'Q': '223', 'R': '223',
        'S': '224', 'T': '224', 'W': '225', 'X': '225', 'Y': '226', 'Z': '226'
    },
    '科学': {
        'A': '19', 'B': '19', 'C': '19', 'D': '19', 'E': '19', 'F': '19', 'G': '19', 'H': '19', 'I': '19', 'J': '19',
        'K': '19', 'L': '20', 'M': '20', 'N': '20', 'O': '20', 'P': '20', 'Q': '20', 'R': '20', 'S': '20', 'T': '20',
        'W': '21', 'X': '21', 'Y': '21', 'Z': '21'
    },
    '克': {
        'A': '251', 'B': '251', 'C': '251', 'D': '251', 'E': '251', 'F': '251', 'G': '251', 'H': '252', 'I': '252',
        'J': '252', 'K': '252', 'L': '253', 'M': '253', 'N': '253', 'O': '253', 'P': '253', 'Q': '253', 'R': '253',
        'S': '254', 'T': '254', 'W': '255', 'X': '255', 'Y': '256', 'Z': '257'
    },
    '孔': {
        'A': '275', 'B': '275', 'C': '275', 'D': '275', 'E': '275', 'F': '275', 'G': '275', 'H': '275', 'I': '275',
        'J': '275', 'K': '275', 'L': '276', 'M': '276', 'N': '276', 'O': '276', 'P': '276', 'Q': '276', 'R': '276',
        'S': '276', 'T': '276', 'W': '277', 'X': '277', 'Y': '277', 'Z': '277'
    },
    '库': {
        'A': '315', 'B': '315', 'C': '315', 'D': '315', 'E': '315', 'F': '315', 'G': '315', 'H': '315', 'I': '315',
        'J': '315', 'K': '315', 'L': '316', 'M': '316', 'N': '316', 'O': '316', 'P': '316', 'Q': '316', 'R': '316',
        'S': '316', 'T': '316', 'W': '317', 'X': '317', 'Y': '317', 'Z': '317'
    },
    '拉': {
        'A': '111', 'B': '111', 'C': '111', 'D': '111', 'E': '111', 'F': '111', 'G': '111', 'H': '111', 'I': '111',
        'J': '111', 'K': '111', 'L': '112', 'M': '112', 'N': '112', 'O': '112', 'P': '112', 'Q': '112', 'R': '112',
        'S': '112', 'T': '112', 'W': '113', 'X': '113', 'Y': '113', 'Z': '113'
    },
    '兰': {
        'A': '141', 'B': '141', 'C': '141', 'D': '141', 'E': '141', 'F': '141', 'G': '141', 'H': '141', 'I': '141',
        'J': '141', 'K': '141', 'L': '142', 'M': '142', 'N': '142', 'O': '142', 'P': '142', 'Q': '142', 'R': '142',
        'S': '142', 'T': '142', 'W': '143', 'X': '143', 'Y': '143', 'Z': '143'
    },
    '雷': {
        'A': '212', 'B': '212', 'C': '212', 'D': '212', 'E': '212', 'F': '212', 'G': '212', 'H': '212', 'I': '212',
        'J': '212', 'K': '212', 'L': '213', 'M': '213', 'N': '213', 'O': '213', 'P': '213', 'Q': '213', 'R': '213',
        'S': '213', 'T': '213', 'W': '214', 'X': '214', 'Y': '214', 'Z': '214'
    },
    '黎': {
        'A': '241', 'B': '241', 'C': '241', 'D': '241', 'E': '241', 'F': '241', 'G': '241', 'H': '241', 'I': '241',
        'J': '241', 'K': '241', 'L': '242', 'M': '242', 'N': '242', 'O': '242', 'P': '242', 'Q': '242', 'R': '242',
        'S': '242', 'T': '242', 'W': '243', 'X': '243', 'Y': '243', 'Z': '243'
    },
    '李': {
        'A': '255', 'B': '256', 'C': '257', 'D': '258', 'E': '259', 'F': '261', 'G': '262', 'H': '263', 'J': '264',
        'K': '265', 'L': '266', 'M': '267', 'N': '268', 'O': '269', 'P': '271', 'Q': '272', 'R': '273', 'S': '274',
        'T': '275', 'W': '276', 'X': '277', 'Y': '278', 'Z': '279'
    },
    '梁': {
        'A': '382', 'B': '382', 'C': '382', 'D': '382', 'E': '382', 'F': '382', 'G': '382', 'H': '382', 'I': '382',
        'J': '382', 'K': '382', 'L': '383', 'M': '383', 'N': '383', 'O': '383', 'P': '383', 'Q': '383', 'R': '383',
        'S': '383', 'T': '383', 'W': '384', 'X': '384', 'Y': '384', 'Z': '384'
    },
    '粮食部': {
        'A': '36', 'B': '36', 'C': '36', 'D': '36', 'E': '36', 'F': '36', 'G': '36', 'H': '36', 'I': '36', 'J': '36',
        'K': '37', 'L': '37', 'M': '37', 'N': '37', 'O': '37', 'P': '37', 'Q': '37', 'R': '37', 'S': '37', 'T': '37',
        'W': '38', 'X': '38', 'Y': '38', 'Z': '38'
    },
    '辽宁': {
        'A': '42', 'B': '42', 'C': '42', 'D': '42', 'E': '42', 'F': '42', 'G': '42', 'H': '42', 'I': '42', 'J': '42',
        'K': '42', 'L': '43', 'M': '43', 'N': '43', 'O': '43', 'P': '43', 'Q': '43', 'R': '43', 'S': '43', 'T': '43',
        'W': '44', 'X': '44', 'Y': '44', 'Z': '44'
    },
    '列': {
        'A': '471', 'B': '471', 'C': '471', 'D': '471', 'E': '471', 'F': '471', 'G': '471', 'H': '472', 'I': '472',
        'J': '472', 'K': '472', 'L': '473', 'M': '473', 'N': '473', 'O': '473', 'P': '473', 'Q': '473', 'R': '473',
        'S': '474', 'T': '474', 'W': '475', 'X': '475', 'Y': '476', 'Z': '476'
    },
    '林': {
        'A': '591', 'B': '591', 'C': '591', 'D': '591', 'E': '591', 'F': '591', 'G': '591', 'H': '591', 'I': '591',
        'J': '591', 'K': '591', 'L': '592', 'M': '592', 'N': '592', 'O': '592', 'P': '592', 'Q': '592', 'R': '592',
        'S': '592', 'T': '592', 'W': '593', 'X': '593', 'Y': '593', 'Z': '593'
    },
    '林业部': {
        'A': '51', 'B': '51', 'C': '51', 'D': '51', 'E': '52', 'F': '52', 'G': '52', 'H': '53', 'I': '53', 'J': '53',
        'K': '53', 'L': '54', 'M': '54', 'N': '54', 'O': '55', 'P': '55', 'Q': '55', 'R': '55', 'S': '56', 'T': '56',
        'W': '57', 'X': '57', 'Y': '58', 'Z': '59'
    },
    '凌': {
        'A': '623', 'B': '623', 'C': '623', 'D': '623', 'E': '623', 'F': '623', 'G': '623', 'H': '623', 'I': '623',
        'J': '623', 'K': '623', 'L': '624', 'M': '624', 'N': '624', 'O': '624', 'P': '624', 'Q': '624', 'R': '624',
        'S': '624', 'T': '624', 'W': '625', 'X': '625', 'Y': '625', 'Z': '625'
    },
    '刘': {
        'A': '652', 'B': '652', 'C': '652', 'D': '652', 'E': '653', 'F': '653', 'G': '653', 'H': '654', 'I': '654',
        'J': '654', 'K': '654', 'L': '655', 'M': '655', 'N': '655', 'O': '656', 'P': '656', 'Q': '656', 'R': '656',
        'S': '657', 'T': '657', 'W': '658', 'X': '658', 'Y': '659', 'Z': '661'
    },
    '卢': {
        'A': '733', 'B': '733', 'C': '733', 'D': '733', 'E': '733', 'F': '733', 'G': '733', 'H': '733', 'I': '733',
        'J': '733', 'K': '733', 'L': '734', 'M': '734', 'N': '734', 'O': '734', 'P': '734', 'Q': '734', 'R': '734',
        'S': '734', 'T': '734', 'W': '735', 'X': '735', 'Y': '735', 'Z': '735'
    },
    '鲁': {
        'A': '744', 'B': '744', 'C': '744', 'D': '744', 'E': '744', 'F': '744', 'G': '744', 'H': '744', 'I': '744',
        'J': '744', 'K': '744', 'L': '745', 'M': '745', 'N': '745', 'O': '745', 'P': '745', 'Q': '745', 'R': '745',
        'S': '745', 'T': '745', 'W': '746', 'X': '746', 'Y': '746', 'Z': '746'
    },
    '陆': {
        'A': '753', 'B': '753', 'C': '753', 'D': '753', 'E': '753', 'F': '753', 'G': '753', 'H': '753', 'I': '753',
        'J': '753', 'K': '753', 'L': '754', 'M': '754', 'N': '754', 'O': '754', 'P': '754', 'Q': '754', 'R': '754',
        'S': '754', 'T': '754', 'W': '755', 'X': '755', 'Y': '755', 'Z': '755'
    },
    '路': {
        'A': '756', 'B': '756', 'C': '756', 'D': '756', 'E': '756', 'F': '756', 'G': '756', 'H': '756', 'I': '756',
        'J': '756', 'K': '756', 'L': '757', 'M': '757', 'N': '757', 'O': '757', 'P': '757', 'Q': '757', 'R': '757',
        'S': '757', 'T': '757', 'W': '758', 'X': '758', 'Y': '758', 'Z': '758'
    },
    '罗': {
        'A': '793', 'B': '793', 'C': '793', 'D': '793', 'E': '793', 'F': '793', 'G': '793', 'H': '794', 'I': '794',
        'J': '794', 'K': '794', 'L': '795', 'M': '795', 'N': '795', 'O': '795', 'P': '795', 'Q': '795', 'R': '795',
        'S': '796', 'T': '796', 'W': '797', 'X': '797', 'Y': '798', 'Z': '798'
    },
    '洛': {
        'A': '821', 'B': '821', 'C': '821', 'D': '821', 'E': '821', 'F': '821', 'G': '821', 'H': '821', 'I': '821',
        'J': '821', 'K': '821', 'L': '822', 'M': '822', 'N': '822', 'O': '822', 'P': '822', 'Q': '822', 'R': '822',
        'S': '822', 'T': '822', 'W': '823', 'X': '823', 'Y': '823', 'Z': '823'
    },
    '骆': {
        'A': '817', 'B': '817', 'C': '817', 'D': '817', 'E': '817', 'F': '817', 'G': '817', 'H': '817', 'I': '817',
        'J': '817', 'K': '817', 'L': '818', 'M': '818', 'N': '818', 'O': '818', 'P': '818', 'Q': '818', 'R': '818',
        'S': '818', 'T': '818', 'W': '819', 'X': '819', 'Y': '819', 'Z': '819'
    },
    '吕': {
        'A': '833', 'B': '833', 'C': '833', 'D': '833', 'E': '833', 'F': '833', 'G': '833', 'H': '833', 'I': '833',
        'J': '833', 'K': '833', 'L': '834', 'M': '834', 'N': '834', 'O': '834', 'P': '834', 'Q': '834', 'R': '834',
        'S': '834', 'T': '834', 'W': '835', 'X': '835', 'Y': '835', 'Z': '835'
    },
    '马': {
        'A': '124', 'B': '124', 'C': '124', 'D': '124', 'E': '124', 'F': '124', 'G': '124', 'H': '125', 'I': '125',
        'J': '125', 'K': '125', 'L': '126', 'M': '126', 'N': '126', 'O': '126', 'P': '126', 'Q': '126', 'R': '126',
        'S': '127', 'T': '127', 'W': '128', 'X': '128', 'Y': '129', 'Z': '129'
    },
    '麦': {
        'A': '145', 'B': '145', 'C': '145', 'D': '145', 'E': '145', 'F': '145', 'G': '145', 'H': '145', 'I': '145',
        'J': '145', 'K': '145', 'L': '146', 'M': '146', 'N': '146', 'O': '146', 'P': '146', 'Q': '146', 'R': '146',
        'S': '146', 'T': '146', 'W': '147', 'X': '147', 'Y': '147', 'Z': '147'
    },
    '毛': {
        'A': '192', 'B': '192', 'C': '192', 'D': '192', 'E': '192', 'F': '192', 'G': '192', 'H': '192', 'I': '192',
        'J': '192', 'K': '192', 'L': '193', 'M': '193', 'N': '193', 'O': '193', 'P': '193', 'Q': '193', 'R': '193',
        'S': '193', 'T': '193', 'W': '194', 'X': '194', 'Y': '194', 'Z': '194'
    },
    '梅': {
        'A': '222', 'B': '222', 'C': '222', 'D': '222', 'E': '222', 'F': '222', 'G': '222', 'H': '222', 'I': '222',
        'J': '222', 'K': '222', 'L': '223', 'M': '223', 'N': '223', 'O': '223', 'P': '223', 'Q': '223', 'R': '223',
        'S': '223', 'T': '223', 'W': '224', 'X': '224', 'Y': '224', 'Z': '224'
    },
    '美': {
        'A': '231', 'B': '231', 'C': '231', 'D': '231', 'E': '231', 'F': '231', 'G': '231', 'H': '231', 'I': '231',
        'J': '231', 'K': '231', 'L': '232', 'M': '232', 'N': '232', 'O': '232', 'P': '232', 'Q': '232', 'R': '232',
        'S': '232', 'T': '232', 'W': '233', 'X': '233', 'Y': '233', 'Z': '233'
    },
    '孟': {
        'A': '265', 'B': '265', 'C': '265', 'D': '265', 'E': '265', 'F': '265', 'G': '265', 'H': '265', 'I': '265',
        'J': '265', 'K': '265', 'L': '266', 'M': '266', 'N': '266', 'O': '266', 'P': '266', 'Q': '266', 'R': '266',
        'S': '266', 'T': '266', 'W': '267', 'X': '267', 'Y': '267', 'Z': '267'
    },
    '米': {
        'A': '281', 'B': '281', 'C': '281', 'D': '281', 'E': '281', 'F': '281', 'G': '281', 'H': '281', 'I': '281',
        'J': '281', 'K': '281', 'L': '282', 'M': '282', 'N': '282', 'O': '282', 'P': '282', 'Q': '282', 'R': '282',
        'S': '282', 'T': '282', 'W': '283', 'X': '283', 'Y': '283', 'Z': '283'
    },
    '莫': {
        'A': '391', 'B': '391', 'C': '391', 'D': '391', 'E': '391', 'F': '391', 'G': '391', 'H': '391', 'I': '391',
        'J': '391', 'K': '391', 'L': '392', 'M': '392', 'N': '392', 'O': '392', 'P': '392', 'Q': '392', 'R': '392',
        'S': '392', 'T': '392', 'W': '393', 'X': '393', 'Y': '393', 'Z': '393'
    },
    '穆': {
        'A': '431', 'B': '431', 'C': '431', 'D': '431', 'E': '431', 'F': '431', 'G': '431', 'H': '431', 'I': '431',
        'J': '431', 'K': '431', 'L': '432', 'M': '432', 'N': '432', 'O': '432', 'P': '432', 'Q': '432', 'R': '432',
        'S': '432', 'T': '432', 'W': '433', 'X': '433', 'Y': '433', 'Z': '433'
    },
    '那': {
        'A': '111', 'B': '111', 'C': '111', 'D': '111', 'E': '111', 'F': '111', 'G': '111', 'H': '111', 'I': '111',
        'J': '111', 'K': '111', 'L': '112', 'M': '112', 'N': '112', 'O': '112', 'P': '112', 'Q': '112', 'R': '112',
        'S': '112', 'T': '112', 'W': '113', 'X': '113', 'Y': '113', 'Z': '113'
    },
    '纳': {
        'A': '121', 'B': '121', 'C': '121', 'D': '121', 'E': '121', 'F': '121', 'G': '121', 'H': '121', 'I': '121',
        'J': '121', 'K': '121', 'L': '122', 'M': '122', 'N': '122', 'O': '122', 'P': '122', 'Q': '122', 'R': '122',
        'S': '122', 'T': '122', 'W': '123', 'X': '123', 'Y': '123', 'Z': '123'
    },
    '南京': {
        'A': '15', 'B': '15', 'C': '15', 'D': '15', 'E': '15', 'F': '15', 'G': '15', 'H': '16', 'I': '16', 'J': '16',
        'K': '16', 'L': '17', 'M': '17', 'N': '17', 'O': '17', 'P': '17', 'Q': '17', 'R': '17', 'S': '18', 'T': '18',
        'W': '19', 'X': '19', 'Y': '21', 'Z': '21'
    },
    '尼': {
        'A': '281', 'B': '281', 'C': '281', 'D': '281', 'E': '281', 'F': '281', 'G': '281', 'H': '281', 'I': '281',
        'J': '281', 'K': '281', 'L': '282', 'M': '282', 'N': '282', 'O': '282', 'P': '282', 'Q': '282', 'R': '282',
        'S': '282', 'T': '282', 'W': '283', 'X': '283', 'Y': '283', 'Z': '283'
    },
    '倪': {
        'A': '284', 'B': '284', 'C': '284', 'D': '284', 'E': '284', 'F': '284', 'G': '284', 'H': '284', 'I': '284',
        'J': '284', 'K': '284', 'L': '285', 'M': '285', 'N': '285', 'O': '285', 'P': '285', 'Q': '285', 'R': '285',
        'S': '285', 'T': '285', 'W': '286', 'X': '286', 'Y': '286', 'Z': '286'
    },
    '聂': {
        'A': '334', 'B': '334', 'C': '334', 'D': '334', 'E': '334', 'F': '334', 'G': '334', 'H': '334', 'I': '334',
        'J': '334', 'K': '334', 'L': '335', 'M': '335', 'N': '335', 'O': '335', 'P': '335', 'Q': '335', 'R': '335',
        'S': '335', 'T': '335', 'W': '336', 'X': '336', 'Y': '336', 'Z': '336'
    },
    '涅': {
        'A': '337', 'B': '337', 'C': '337', 'D': '337', 'E': '337', 'F': '337', 'G': '337', 'H': '337', 'I': '337',
        'J': '337', 'K': '337', 'L': '338', 'M': '338', 'N': '338', 'O': '338', 'P': '338', 'Q': '338', 'R': '338',
        'S': '338', 'T': '338', 'W': '339', 'X': '339', 'Y': '339', 'Z': '339'
    },
    '牛': {
        'A': '361', 'B': '361', 'C': '361', 'D': '361', 'E': '361', 'F': '361', 'G': '361', 'H': '361', 'I': '361',
        'J': '361', 'K': '361', 'L': '362', 'M': '362', 'N': '362', 'O': '362', 'P': '362', 'Q': '362', 'R': '362',
        'S': '362', 'T': '362', 'W': '363', 'X': '363', 'Y': '363', 'Z': '363'
    },
    '农': {
        'A': '531', 'B': '531', 'C': '531', 'D': '531', 'E': '531', 'F': '531', 'G': '531', 'H': '531', 'I': '531',
        'J': '531', 'K': '531', 'L': '532', 'M': '532', 'N': '532', 'O': '532', 'P': '532', 'Q': '532', 'R': '532',
        'S': '532', 'T': '532', 'W': '533', 'X': '533', 'Y': '533', 'Z': '533'
    },
    '农垦部': {
        'A': '37', 'B': '37', 'C': '37', 'D': '37', 'E': '37', 'F': '37', 'G': '37', 'H': '37', 'I': '37', 'J': '37',
        'K': '37', 'L': '38', 'M': '38', 'N': '38', 'O': '38', 'P': '38', 'Q': '38', 'R': '38', 'S': '38', 'T': '38',
        'W': '39', 'X': '39', 'Y': '39', 'Z': '39'
    },
    '农业': {
        'A': '51', 'B': '51', 'C': '51', 'D': '51', 'E': '51', 'F': '51', 'G': '51', 'H': '51', 'I': '51', 'J': '51',
        'K': '51', 'L': '52', 'M': '52', 'N': '52', 'O': '52', 'P': '52', 'Q': '52', 'R': '52', 'S': '52', 'T': '52',
        'W': '53', 'X': '53', 'Y': '53', 'Z': '53'
    },
    '农业部': {
        'A': '41', 'B': '41', 'C': '41', 'D': '41', 'E': '42', 'F': '42', 'G': '42', 'H': '43', 'I': '43', 'J': '43',
        'K': '43', 'L': '44', 'M': '44', 'N': '44', 'O': '45', 'P': '45', 'Q': '45', 'R': '45', 'S': '46', 'T': '46',
        'W': '47', 'X': '47', 'Y': '48', 'Z': '49'
    },
    '诺': {
        'A': '553', 'B': '553', 'C': '553', 'D': '553', 'E': '553', 'F': '553', 'G': '553', 'H': '553', 'I': '553',
        'J': '553', 'K': '553', 'L': '554', 'M': '554', 'N': '554', 'O': '554', 'P': '554', 'Q': '554', 'R': '554',
        'S': '554', 'T': '554', 'W': '555', 'X': '555', 'Y': '555', 'Z': '555'
    },
    '潘': {
        'A': '131', 'B': '131', 'C': '131', 'D': '131', 'E': '131', 'F': '131', 'G': '131', 'H': '131', 'I': '131',
        'J': '131', 'K': '131', 'L': '132', 'M': '132', 'N': '132', 'O': '132', 'P': '132', 'Q': '132', 'R': '132',
        'S': '132', 'T': '132', 'W': '133', 'X': '133', 'Y': '133', 'Z': '133'
    },
    '庞': {
        'A': '163', 'B': '163', 'C': '163', 'D': '163', 'E': '163', 'F': '163', 'G': '163', 'H': '163', 'I': '163',
        'J': '163', 'K': '163', 'L': '164', 'M': '164', 'N': '164', 'O': '164', 'P': '164', 'Q': '164', 'R': '164',
        'S': '164', 'T': '164', 'W': '165', 'X': '165', 'Y': '165', 'Z': '165'
    },
    '裴': {
        'A': '194', 'B': '194', 'C': '194', 'D': '194', 'E': '194', 'F': '194', 'G': '194', 'H': '194', 'I': '194',
        'J': '194', 'K': '194', 'L': '195', 'M': '195', 'N': '195', 'O': '195', 'P': '195', 'Q': '195', 'R': '195',
        'S': '195', 'T': '195', 'W': '196', 'X': '196', 'Y': '196', 'Z': '196'
    },
    '彭': {
        'A': '235', 'B': '235', 'C': '235', 'D': '235', 'E': '235', 'F': '235', 'G': '235', 'H': '235', 'I': '235',
        'J': '235', 'K': '235', 'L': '236', 'M': '236', 'N': '236', 'O': '236', 'P': '236', 'Q': '236', 'R': '236',
        'S': '236', 'T': '236', 'W': '237', 'X': '237', 'Y': '237', 'Z': '237'
    },
    '普': {
        'A': '431', 'B': '431', 'C': '431', 'D': '431', 'E': '431', 'F': '431', 'G': '431', 'H': '431', 'I': '431',
        'J': '431', 'K': '431', 'L': '432', 'M': '432', 'N': '432', 'O': '432', 'P': '432', 'Q': '432', 'R': '432',
        'S': '432', 'T': '432', 'W': '433', 'X': '433', 'Y': '433', 'Z': '433'
    },
    '齐': {
        'A': '121', 'B': '121', 'C': '121', 'D': '121', 'E': '121', 'F': '121', 'G': '121', 'H': '121', 'I': '121',
        'J': '121', 'K': '121', 'L': '122', 'M': '122', 'N': '122', 'O': '122', 'P': '122', 'Q': '122', 'R': '122',
        'S': '122', 'T': '122', 'W': '123', 'X': '123', 'Y': '123', 'Z': '123'
    },
    '钱': {
        'A': '191', 'B': '191', 'C': '191', 'D': '191', 'E': '191', 'F': '191', 'G': '191', 'H': '191', 'I': '191',
        'J': '191', 'K': '191', 'L': '192', 'M': '192', 'N': '192', 'O': '192', 'P': '192', 'Q': '192', 'R': '192',
        'S': '192', 'T': '192', 'W': '193', 'X': '193', 'Y': '193', 'Z': '193'
    },
    '乔': {
        'A': '261', 'B': '261', 'C': '261', 'D': '261', 'E': '261', 'F': '261', 'G': '261', 'H': '261', 'I': '261',
        'J': '261', 'K': '261', 'L': '262', 'M': '262', 'N': '262', 'O': '262', 'P': '262', 'Q': '262', 'R': '262',
        'S': '262', 'T': '262', 'W': '263', 'X': '263', 'Y': '263', 'Z': '263'
    },
    '切': {
        'A': '285', 'B': '285', 'C': '285', 'D': '285', 'E': '285', 'F': '285', 'G': '285', 'H': '285', 'I': '285',
        'J': '285', 'K': '285', 'L': '286', 'M': '286', 'N': '286', 'O': '286', 'P': '286', 'Q': '286', 'R': '286',
        'S': '286', 'T': '286', 'W': '287', 'X': '287', 'Y': '287', 'Z': '287'
    },
    '秦': {
        'A': '321', 'B': '321', 'C': '321', 'D': '321', 'E': '321', 'F': '321', 'G': '321', 'H': '321', 'I': '321',
        'J': '321', 'K': '321', 'L': '322', 'M': '322', 'N': '322', 'O': '322', 'P': '322', 'Q': '322', 'R': '322',
        'S': '322', 'T': '322', 'W': '323', 'X': '323', 'Y': '323', 'Z': '323'
    },
    '青海': {
        'A': '37', 'B': '37', 'C': '37', 'D': '37', 'E': '37', 'F': '37', 'G': '37', 'H': '37', 'I': '37', 'J': '37',
        'K': '37', 'L': '38', 'M': '38', 'N': '38', 'O': '38', 'P': '38', 'Q': '38', 'R': '38', 'S': '38', 'T': '38',
        'W': '39', 'X': '39', 'Y': '39', 'Z': '39'
    },
    '轻工业部': {
        'A': '34', 'B': '34', 'C': '34', 'D': '34', 'E': '34', 'F': '34', 'G': '34', 'H': '34', 'I': '34', 'J': '34',
        'K': '34', 'L': '35', 'M': '35', 'N': '35', 'O': '35', 'P': '35', 'Q': '35', 'R': '35', 'S': '35', 'T': '35',
        'W': '36', 'X': '36', 'Y': '36', 'Z': '36'
    },
    '邱': {
        'A': '441', 'B': '441', 'C': '441', 'D': '441', 'E': '441', 'F': '441', 'G': '441', 'H': '441', 'I': '441',
        'J': '441', 'K': '441', 'L': '442', 'M': '442', 'N': '442', 'O': '442', 'P': '442', 'Q': '442', 'R': '442',
        'S': '442', 'T': '442', 'W': '443', 'X': '443', 'Y': '443', 'Z': '443'
    },
    '裘': {
        'A': '451', 'B': '451', 'C': '451', 'D': '451', 'E': '451', 'F': '451', 'G': '451', 'H': '451', 'I': '451',
        'J': '451', 'K': '451', 'L': '452', 'M': '452', 'N': '452', 'O': '452', 'P': '452', 'Q': '452', 'R': '452',
        'S': '452', 'T': '452', 'W': '453', 'X': '453', 'Y': '453', 'Z': '453'
    },
    '全国': {
        'A': '51', 'B': '51', 'C': '51', 'D': '51', 'E': '51', 'F': '51', 'G': '51', 'H': '52', 'I': '52', 'J': '52',
        'K': '52', 'L': '53', 'M': '53', 'N': '53', 'O': '53', 'P': '53', 'Q': '53', 'R': '53', 'S': '54', 'T': '54',
        'W': '55', 'X': '55', 'Y': '56', 'Z': '56'
    },
    '群众': {
        'A': '61', 'B': '61', 'C': '61', 'D': '61', 'E': '61', 'F': '61', 'G': '61', 'H': '61', 'I': '61', 'J': '61',
        'K': '61', 'L': '62', 'M': '62', 'N': '62', 'O': '62', 'P': '62', 'Q': '62', 'R': '62', 'S': '62', 'T': '62',
        'W': '63', 'X': '63', 'Y': '63', 'Z': '63'
    },
    '燃料化学工业部': {
        'A': '11', 'B': '11', 'C': '11', 'D': '11', 'E': '11', 'F': '11', 'G': '11', 'H': '11', 'I': '11', 'J': '11',
        'K': '11', 'L': '12', 'M': '12', 'N': '12', 'O': '12', 'P': '12', 'Q': '12', 'R': '12', 'S': '12', 'T': '12',
        'W': '13', 'X': '13', 'Y': '13', 'Z': '13'
    },
    '人民': {
        'A': '16', 'B': '16', 'C': '16', 'D': '16', 'E': '16', 'F': '16', 'G': '16', 'H': '17', 'I': '17', 'J': '17',
        'K': '17', 'L': '18', 'M': '18', 'N': '18', 'O': '18', 'P': '18', 'Q': '18', 'R': '18', 'S': '19', 'T': '19',
        'W': '21', 'X': '21', 'Y': '22', 'Z': '22'
    },
    '任': {
        'A': '222', 'B': '222', 'C': '222', 'D': '222', 'E': '222', 'F': '222', 'G': '222', 'H': '222', 'I': '222',
        'J': '222', 'K': '222', 'L': '223', 'M': '223', 'N': '223', 'O': '223', 'P': '223', 'Q': '223', 'R': '223',
        'S': '223', 'T': '223', 'W': '224', 'X': '224', 'Y': '224', 'Z': '224'
    },
    '日': {
        'A': '245', 'B': '245', 'C': '245', 'D': '245', 'E': '245', 'F': '245', 'G': '245', 'H': '245', 'I': '245',
        'J': '245', 'K': '245', 'L': '246', 'M': '246', 'N': '246', 'O': '246', 'P': '246', 'Q': '246', 'R': '246',
        'S': '246', 'T': '246', 'W': '247', 'X': '247', 'Y': '247', 'Z': '247'
    },
    '茹': {
        'A': '281', 'B': '281', 'C': '281', 'D': '281', 'E': '281', 'F': '281', 'G': '281', 'H': '281', 'I': '281',
        'J': '281', 'K': '281', 'L': '282', 'M': '282', 'N': '282', 'O': '282', 'P': '282', 'Q': '282', 'R': '282',
        'S': '282', 'T': '282', 'W': '283', 'X': '283', 'Y': '283', 'Z': '283'
    },
    '萨': {
        'A': '105', 'B': '105', 'C': '105', 'D': '105', 'E': '105', 'F': '105', 'G': '105', 'H': '105', 'I': '105',
        'J': '105', 'K': '105', 'L': '106', 'M': '106', 'N': '106', 'O': '106', 'P': '106', 'Q': '106', 'R': '106',
        'S': '106', 'T': '106', 'W': '107', 'X': '107', 'Y': '107', 'Z': '107'
    },
    '塞': {
        'A': '111', 'B': '111', 'C': '111', 'D': '111', 'E': '111', 'F': '111', 'G': '111', 'H': '111', 'I': '111',
        'J': '111', 'K': '111', 'L': '112', 'M': '112', 'N': '112', 'O': '112', 'P': '112', 'Q': '112', 'R': '112',
        'S': '112', 'T': '112', 'W': '113', 'X': '113', 'Y': '113', 'Z': '113'
    },
    '森林': {
        'A': '15', 'B': '15', 'C': '15', 'D': '15', 'E': '15', 'F': '15', 'G': '15', 'H': '15', 'I': '15', 'J': '15',
        'K': '15', 'L': '16', 'M': '16', 'N': '16', 'O': '16', 'P': '16', 'Q': '16', 'R': '16', 'S': '16', 'T': '16',
        'W': '17', 'X': '17', 'Y': '17', 'Z': '17'
    },
    '沙': {
        'A': '173', 'B': '173', 'C': '173', 'D': '173', 'E': '173', 'F': '173', 'G': '173', 'H': '173', 'I': '173',
        'J': '173', 'K': '173', 'L': '174', 'M': '174', 'N': '174', 'O': '174', 'P': '174', 'Q': '174', 'R': '174',
        'S': '174', 'T': '174', 'W': '175', 'X': '175', 'Y': '175', 'Z': '175'
    },
    '山东': {
        'A': '20', 'B': '20', 'C': '20', 'D': '20', 'E': '20', 'F': '20', 'G': '20', 'H': '20', 'I': '20', 'J': '20',
        'K': '20', 'L': '21', 'M': '21', 'N': '21', 'O': '21', 'P': '21', 'Q': '21', 'R': '21', 'S': '21', 'T': '21',
        'W': '22', 'X': '22', 'Y': '22', 'Z': '22'
    },
    '山西': {
        'A': '23', 'B': '23', 'C': '23', 'D': '23', 'E': '23', 'F': '23', 'G': '23', 'H': '23', 'I': '23', 'J': '23',
        'K': '23', 'L': '24', 'M': '24', 'N': '24', 'O': '24', 'P': '24', 'Q': '24', 'R': '24', 'S': '24', 'T': '24',
        'W': '25', 'X': '25', 'Y': '25', 'Z': '25'
    },
    '陕西': {
        'A': '26', 'B': '26', 'C': '26', 'D': '26', 'E': '26', 'F': '26', 'G': '26', 'H': '26', 'I': '26', 'J': '26',
        'K': '26', 'L': '27', 'M': '27', 'N': '27', 'O': '27', 'P': '27', 'Q': '27', 'R': '27', 'S': '27', 'T': '27',
        'W': '28', 'X': '28', 'Y': '28', 'Z': '28'
    },
    '上海市': {
        'A': '31', 'B': '31', 'C': '31', 'D': '31', 'E': '34', 'F': '31', 'G': '31', 'H': '32', 'I': '32', 'J': '32',
        'K': '32', 'L': '33', 'M': '33', 'N': '33', 'O': '33', 'P': '33', 'Q': '33', 'R': '33', 'S': '34', 'T': '34',
        'W': '35', 'X': '35', 'Y': '36', 'Z': '36'
    },
    '上海': {
        'A': '37', 'B': '37', 'C': '37', 'D': '37', 'E': '37', 'F': '37', 'G': '37', 'H': '38', 'I': '38', 'J': '38',
        'K': '38', 'L': '39', 'M': '39', 'N': '39', 'O': '39', 'P': '39', 'Q': '39', 'R': '39', 'S': '40', 'T': '40',
        'W': '41', 'X': '41', 'Y': '42', 'Z': '42'
    },
    '尚': {
        'A': '422', 'B': '422', 'C': '422', 'D': '422', 'E': '422', 'F': '422', 'G': '422', 'H': '422', 'I': '422',
        'J': '422', 'K': '422', 'L': '423', 'M': '423', 'N': '423', 'O': '423', 'P': '423', 'Q': '423', 'R': '423',
        'S': '423', 'T': '423', 'W': '424', 'X': '424', 'Y': '424', 'Z': '424'
    },
    '沈阳': {
        'A': '48', 'B': '48', 'C': '48', 'D': '48', 'E': '48', 'F': '48', 'G': '48', 'H': '49', 'I': '49', 'J': '49',
        'K': '49', 'L': '50', 'N': '50', 'O': '50', 'P': '50', 'Q': '50', 'R': '50', 'S': '51', 'T': '51', 'W': '52',
        'X': '52', 'Y': '53', 'Z': '53', 'M': '50'
    },
    '沈': {
        'A': '531', 'B': '531', 'C': '531', 'E': '531', 'F': '531', 'G': '531', 'H': '531', 'I': '531', 'J': '531',
        'K': '531', 'L': '532', 'M': '532', 'N': '532', 'O': '532', 'P': '532', 'Q': '532', 'R': '532', 'S': '532',
        'T': '532', 'W': '533', 'X': '533', 'Y': '533', 'Z': '533', 'D': '531'
    },
    '盛': {
        'A': '554', 'B': '554', 'C': '554', 'D': '554', 'E': '554', 'F': '554', 'G': '554', 'H': '554', 'I': '554',
        'J': '554', 'K': '554', 'L': '555', 'M': '555', 'N': '555', 'O': '555', 'P': '555', 'Q': '555', 'R': '555',
        'S': '555', 'T': '555', 'W': '556', 'X': '556', 'Y': '556', 'Z': '556'
    },
    '施': {
        'A': '564', 'B': '564', 'C': '564', 'D': '564', 'E': '564', 'F': '564', 'G': '564', 'H': '564', 'I': '564',
        'J': '564', 'K': '564', 'L': '565', 'M': '565', 'N': '565', 'O': '565', 'P': '565', 'Q': '565', 'R': '565',
        'S': '565', 'T': '565', 'W': '566', 'X': '566', 'Y': '566', 'Z': '566'
    },
    '石': {
        'A': '591', 'B': '591', 'C': '591', 'D': '591', 'E': '591', 'F': '591', 'G': '591', 'H': '591', 'I': '591',
        'J': '591', 'K': '591', 'L': '592', 'M': '592', 'N': '592', 'O': '592', 'P': '592', 'Q': '592', 'R': '592',
        'S': '592', 'T': '592', 'W': '593', 'X': '593', 'Y': '593', 'Z': '593'
    },
    '史': {
        'A': '606', 'B': '606', 'C': '606', 'D': '606', 'E': '606', 'F': '606', 'G': '606', 'H': '606', 'I': '607',
        'J': '607', 'K': '607', 'L': '607', 'M': '607', 'N': '607', 'O': '607', 'P': '607', 'Q': '607', 'R': '607',
        'S': '607', 'T': '607', 'W': '608', 'X': '608', 'Y': '608', 'Z': '608'
    },
    '世界': {
        'A': '62', 'B': '62', 'C': '62', 'D': '62', 'E': '62', 'F': '62', 'G': '62', 'H': '62', 'I': '63', 'J': '63',
        'K': '63', 'L': '63', 'M': '63', 'N': '63', 'O': '63', 'P': '63', 'Q': '63', 'R': '63', 'S': '63', 'T': '63',
        'W': '64', 'X': '64', 'Y': '64', 'Z': '64'
    },
    '舒': {
        'A': '671', 'B': '671', 'C': '671', 'D': '671', 'E': '671', 'F': '671', 'G': '671', 'H': '671', 'I': '671',
        'J': '671', 'K': '671', 'L': '672', 'M': '672', 'N': '672', 'O': '672', 'P': '672', 'Q': '672', 'R': '672',
        'S': '672', 'T': '672', 'W': '673', 'X': '673', 'Y': '673', 'Z': '673'
    },
    '水利部': {
        'A': '74', 'B': '74', 'C': '74', 'D': '74', 'E': '74', 'F': '74', 'G': '74', 'H': '75', 'I': '75', 'J': '75',
        'K': '75', 'L': '76', 'M': '76', 'N': '76', 'O': '76', 'P': '76', 'Q': '76', 'R': '76', 'S': '77', 'T': '77',
        'W': '78', 'X': '78', 'Y': '79', 'Z': '79'
    },
    '斯': {
        'A': '821', 'B': '821', 'C': '821', 'D': '821', 'E': '821', 'F': '821', 'G': '821', 'H': '822', 'I': '822',
        'J': '822', 'K': '822', 'L': '823', 'M': '823', 'N': '823', 'O': '823', 'P': '823', 'Q': '823', 'R': '823',
        'S': '824', 'T': '824', 'W': '825', 'X': '825', 'Y': '826', 'Z': '826'
    },
    '四川': {
        'A': '84', 'B': '84', 'C': '84', 'D': '84', 'E': '84', 'F': '84', 'G': '84', 'H': '84', 'I': '84', 'J': '84',
        'K': '84', 'L': '85', 'M': '85', 'N': '85', 'O': '85', 'P': '85', 'Q': '85', 'R': '85', 'S': '85', 'T': '85',
        'W': '86', 'X': '86', 'Y': '86', 'Z': '86'
    },
    '宋': {
        'A': '881', 'B': '881', 'C': '881', 'D': '881', 'E': '881', 'F': '881', 'G': '881', 'H': '881', 'I': '881',
        'J': '881', 'K': '881', 'L': '882', 'M': '882', 'N': '882', 'O': '882', 'P': '882', 'Q': '882', 'R': '882',
        'S': '882', 'T': '882', 'W': '883', 'X': '883', 'Y': '883', 'Z': '883'
    },
    '苏联': {
        'A': '90', 'B': '90', 'C': '90', 'D': '90', 'E': '90', 'F': '90', 'G': '90', 'H': '90', 'I': '90', 'J': '90',
        'K': '90', 'L': '91', 'M': '91', 'N': '91', 'O': '91', 'P': '91', 'Q': '91', 'R': '91', 'S': '91', 'T': '91',
        'W': '92', 'X': '92', 'Y': '92', 'Z': '92'
    },
    '苏': {
        'A': '921', 'B': '921', 'C': '921', 'D': '921', 'E': '921', 'F': '921', 'G': '921', 'H': '921', 'I': '921',
        'J': '921', 'K': '921', 'L': '922', 'M': '922', 'N': '922', 'O': '922', 'P': '922', 'Q': '922', 'R': '922',
        'S': '922', 'T': '922', 'W': '923', 'X': '923', 'Y': '923', 'Z': '923'
    },
    '孙': {
        'A': '966', 'B': '966', 'C': '966', 'D': '966', 'E': '966', 'F': '966', 'G': '966', 'H': '967', 'I': '967',
        'J': '967', 'K': '967', 'L': '968', 'M': '968', 'N': '968', 'O': '968', 'P': '968', 'Q': '968', 'R': '968',
        'S': '969', 'T': '969', 'W': '971', 'X': '971', 'Y': '972', 'Z': '972'
    },
    '索': {
        'A': '991', 'B': '991', 'C': '991', 'D': '991', 'E': '991', 'F': '991', 'G': '991', 'H': '991', 'I': '991',
        'J': '991', 'K': '991', 'L': '992', 'M': '992', 'N': '992', 'O': '992', 'P': '992', 'Q': '992', 'R': '992',
        'S': '992', 'T': '992', 'W': '993', 'X': '993', 'Y': '993', 'Z': '993'
    },
    '塔': {
        'A': '121', 'B': '121', 'C': '121', 'D': '121', 'E': '121', 'F': '121', 'G': '121', 'H': '121', 'I': '121',
        'J': '121', 'K': '121', 'L': '122', 'M': '122', 'N': '122', 'O': '122', 'P': '122', 'Q': '122', 'R': '122',
        'S': '122', 'T': '122', 'W': '123', 'X': '123', 'Y': '123', 'Z': '123'
    },
    '谭': {
        'A': '177', 'B': '177', 'C': '177', 'D': '177', 'E': '177', 'F': '177', 'G': '177', 'H': '177', 'I': '177',
        'J': '177', 'K': '177', 'L': '178', 'M': '178', 'N': '178', 'O': '178', 'P': '178', 'Q': '178', 'R': '178',
        'S': '178', 'T': '178', 'W': '179', 'X': '179', 'Y': '179', 'Z': '179'
    },
    '汤': {
        'A': '211', 'B': '211', 'C': '211', 'D': '211', 'E': '211', 'F': '211', 'G': '211', 'H': '211', 'I': '211',
        'J': '211', 'K': '211', 'L': '212', 'M': '212', 'N': '212', 'O': '212', 'P': '212', 'Q': '212', 'R': '212',
        'S': '212', 'T': '212', 'W': '213', 'X': '213', 'Y': '213', 'Z': '213'
    },
    '唐': {
        'A': '215', 'B': '215', 'C': '215', 'D': '215', 'E': '215', 'F': '215', 'G': '215', 'H': '215', 'I': '215',
        'J': '215', 'K': '215', 'L': '216', 'M': '216', 'N': '216', 'O': '216', 'P': '216', 'Q': '216', 'R': '216',
        'S': '216', 'T': '216', 'W': '217', 'X': '217', 'Y': '217', 'Z': '217'
    },
    '陶': {
        'A': '241', 'B': '241', 'C': '241', 'D': '241', 'E': '241', 'F': '241', 'G': '241', 'H': '241', 'I': '241',
        'J': '241', 'K': '241', 'L': '242', 'M': '242', 'N': '242', 'O': '242', 'P': '242', 'Q': '242', 'R': '242',
        'S': '242', 'T': '242', 'W': '243', 'X': '243', 'Y': '243', 'Z': '243'
    },
    '特': {
        'A': '253', 'B': '253', 'C': '253', 'D': '253', 'E': '253', 'F': '253', 'G': '253', 'H': '253', 'I': '253',
        'J': '253', 'K': '253', 'L': '254', 'M': '254', 'N': '254', 'O': '254', 'P': '254', 'Q': '254', 'R': '254',
        'S': '254', 'T': '254', 'W': '255', 'X': '255', 'Y': '255', 'Z': '255'
    },
    '滕': {
        'A': '261', 'B': '261', 'C': '261', 'D': '261', 'E': '261', 'F': '261', 'G': '261', 'H': '261', 'I': '261',
        'J': '261', 'K': '261', 'L': '262', 'M': '262', 'N': '262', 'O': '262', 'P': '262', 'Q': '262', 'R': '262',
        'S': '262', 'T': '262', 'W': '263', 'X': '263', 'Y': '263', 'Z': '263'
    },
    '体育': {
        'A': '29', 'B': '29', 'C': '29', 'D': '29', 'E': '29', 'F': '29', 'G': '29', 'H': '31', 'I': '31', 'J': '31',
        'K': '31', 'L': '32', 'M': '32', 'N': '32', 'O': '32', 'P': '32', 'Q': '32', 'R': '32', 'S': '33', 'T': '33',
        'W': '34', 'X': '34', 'Y': '35', 'Z': '35'
    },
    '天津市': {
        'A': '36', 'B': '36', 'C': '36', 'D': '36', 'E': '36', 'F': '36', 'G': '36', 'H': '37', 'I': '37', 'J': '37',
        'K': '37', 'L': '38', 'M': '38', 'N': '38', 'O': '38', 'P': '38', 'Q': '38', 'R': '38', 'S': '39', 'T': '39',
        'W': '41', 'X': '41', 'Y': '42', 'Z': '42'
    },
    '天津': {
        'A': '43', 'B': '43', 'C': '43', 'D': '43', 'E': '43', 'F': '43', 'G': '43', 'H': '43', 'I': '43', 'J': '43',
        'K': '43', 'L': '44', 'M': '44', 'N': '44', 'O': '44', 'P': '44', 'Q': '44', 'R': '44', 'S': '44', 'T': '44',
        'W': '45', 'X': '45', 'Y': '45', 'Z': '45'
    },
    '田': {
        'A': '454', 'B': '454', 'C': '454', 'D': '454', 'E': '454', 'F': '454', 'G': '454', 'H': '454', 'I': '454',
        'J': '454', 'K': '454', 'L': '455', 'M': '455', 'N': '455', 'O': '455', 'P': '455', 'Q': '455', 'R': '455',
        'S': '455', 'T': '455', 'W': '456', 'X': '456', 'Y': '456', 'Z': '456'
    },
    '铁道部': {
        'A': '51', 'B': '51', 'C': '51', 'D': '51', 'E': '51', 'F': '51', 'G': '51', 'H': '51', 'I': '51', 'J': '51',
        'K': '51', 'L': '52', 'M': '52', 'N': '52', 'O': '52', 'P': '52', 'Q': '52', 'R': '52', 'S': '52', 'T': '52',
        'W': '53', 'X': '53', 'Y': '53', 'Z': '53'
    },
    '托': {
        'A': '631', 'B': '631', 'C': '631', 'D': '631', 'E': '631', 'F': '631', 'G': '631', 'H': '631', 'I': '631',
        'J': '631', 'K': '631', 'L': '632', 'M': '632', 'N': '632', 'O': '632', 'P': '632', 'Q': '632', 'R': '632',
        'S': '632', 'T': '632', 'W': '633', 'X': '633', 'Y': '633', 'Z': '633'
    },
    '洼': {
        'A': '111', 'B': '111', 'C': '111', 'D': '111', 'E': '111', 'F': '111', 'G': '111', 'H': '111', 'I': '111',
        'J': '111', 'K': '111', 'L': '112', 'M': '112', 'N': '112', 'O': '112', 'P': '112', 'Q': '112', 'R': '112',
        'S': '112', 'T': '112', 'W': '113', 'X': '113', 'Y': '113', 'Z': '113'
    },
    '瓦': {
        'A': '121', 'B': '121', 'C': '121', 'D': '121', 'E': '121', 'F': '121', 'G': '121', 'H': '121', 'I': '121',
        'J': '121', 'K': '121', 'L': '122', 'M': '122', 'N': '122', 'O': '122', 'P': '122', 'Q': '122', 'R': '122',
        'S': '122', 'T': '122', 'W': '123', 'X': '123', 'Y': '123', 'Z': '123'
    },
    '外交部': {
        'A': '13', 'B': '13', 'C': '13', 'D': '13', 'E': '13', 'F': '13', 'G': '13', 'H': '13', 'I': '13', 'J': '13',
        'K': '13', 'L': '14', 'M': '14', 'N': '14', 'O': '14', 'P': '14', 'Q': '14', 'R': '14', 'S': '14', 'T': '14',
        'W': '15', 'X': '15', 'Y': '15', 'Z': '15'
    },
    '万': {
        'A': '174', 'B': '174', 'C': '174', 'D': '174', 'E': '174', 'F': '174', 'G': '174', 'H': '174', 'I': '174',
        'J': '174', 'K': '174', 'L': '175', 'M': '175', 'N': '175', 'O': '175', 'P': '175', 'Q': '175', 'R': '175',
        'S': '175', 'T': '175', 'W': '176', 'X': '176', 'Y': '176', 'Z': '176'
    },
    '汪': {
        'A': '181', 'B': '181', 'C': '181', 'D': '181', 'E': '181', 'F': '181', 'G': '181', 'H': '181', 'I': '181',
        'J': '181', 'K': '181', 'L': '182', 'M': '182', 'N': '182', 'O': '182', 'P': '182', 'Q': '182', 'R': '182',
        'S': '182', 'T': '182', 'W': '183', 'X': '183', 'Y': '183', 'Z': '183'
    },
    '王': {
        'A': '185', 'B': '186', 'C': '187', 'D': '188', 'E': '189', 'F': '191', 'G': '192', 'H': '193', 'J': '194',
        'K': '195', 'L': '196', 'M': '197', 'N': '198', 'O': '199', 'P': '211', 'Q': '212', 'R': '213', 'S': '214',
        'T': '215', 'W': '216', 'X': '217', 'Y': '218', 'Z': '219'
    },
    '威': {
        'A': '233', 'B': '233', 'C': '233', 'D': '233', 'E': '233', 'F': '233', 'G': '233', 'H': '233', 'I': '233',
        'J': '233', 'K': '233', 'L': '234', 'M': '234', 'N': '234', 'O': '234', 'P': '234', 'Q': '234', 'R': '234',
        'S': '234', 'T': '234', 'W': '235', 'X': '235', 'Y': '235', 'Z': '235'
    },
    '韦': {
        'A': '243', 'B': '243', 'C': '243', 'D': '243', 'E': '243', 'F': '243', 'G': '243', 'H': '243', 'I': '243',
        'J': '243', 'K': '243', 'L': '244', 'M': '244', 'N': '244', 'O': '244', 'P': '244', 'Q': '244', 'R': '244',
        'S': '244', 'T': '244', 'W': '245', 'X': '245', 'Y': '245', 'Z': '245'
    },
    '维': {
        'A': '246', 'B': '246', 'C': '246', 'D': '246', 'E': '246', 'F': '246', 'G': '246', 'H': '246', 'I': '246',
        'J': '246', 'K': '246', 'L': '247', 'M': '247', 'N': '247', 'O': '247', 'P': '247', 'Q': '247', 'R': '247',
        'S': '247', 'T': '247', 'W': '248', 'X': '248', 'Y': '248', 'Z': '248'
    },
    '卫生部': {
        'A': '27', 'B': '27', 'C': '27', 'D': '27', 'E': '27', 'F': '27', 'G': '27', 'H': '27', 'I': '27', 'J': '27',
        'K': '27', 'L': '28', 'M': '28', 'N': '28', 'O': '28', 'P': '28', 'Q': '28', 'R': '28', 'S': '28', 'T': '28',
        'W': '29', 'X': '29', 'Y': '29', 'Z': '29'
    },
    '魏': {
        'A': '292', 'B': '292', 'C': '292', 'D': '292', 'E': '292', 'F': '292', 'G': '292', 'H': '292', 'I': '292',
        'J': '292', 'K': '292', 'L': '293', 'M': '293', 'N': '293', 'O': '293', 'P': '293', 'Q': '293', 'R': '293',
        'S': '293', 'T': '293', 'W': '294', 'X': '294', 'Y': '294', 'Z': '294'
    },
    '温': {
        'A': '315', 'B': '315', 'C': '315', 'D': '315', 'E': '315', 'F': '315', 'G': '315', 'H': '315', 'I': '315',
        'J': '315', 'K': '315', 'L': '316', 'M': '316', 'N': '316', 'O': '316', 'P': '316', 'Q': '316', 'R': '316',
        'S': '316', 'T': '316', 'W': '317', 'X': '317', 'Y': '317', 'Z': '317'
    },
    '文化部': {
        'A': '32', 'B': '32', 'C': '32', 'D': '32', 'E': '32', 'F': '32', 'H': '32', 'I': '32', 'J': '32', 'K': '32',
        'L': '33', 'M': '33', 'N': '33', 'O': '33', 'P': '33', 'Q': '33', 'R': '33', 'S': '33', 'T': '33', 'W': '34',
        'X': '34', 'Y': '34', 'Z': '34', 'G': '32'
    },
    '文': {
        'A': '341', 'B': '341', 'C': '341', 'D': '341', 'E': '341', 'F': '341', 'G': '341', 'H': '341', 'I': '341',
        'J': '341', 'K': '341', 'L': '342', 'M': '342', 'N': '342', 'O': '342', 'P': '342', 'Q': '342', 'R': '342',
        'S': '342', 'T': '342', 'W': '343', 'X': '343', 'Y': '343', 'Z': '343'
    },
    '沃': {
        'A': '372', 'B': '372', 'C': '372', 'D': '372', 'E': '372', 'F': '372', 'G': '372', 'H': '372', 'I': '372',
        'J': '372', 'K': '372', 'L': '373', 'M': '373', 'N': '373', 'O': '373', 'P': '373', 'Q': '373', 'R': '373',
        'S': '373', 'T': '373', 'W': '374', 'X': '374', 'Y': '374', 'Z': '374'
    },
    '乌': {
        'A': '381', 'B': '381', 'C': '381', 'D': '381', 'E': '381', 'F': '381', 'G': '381', 'H': '381', 'I': '381',
        'J': '381', 'K': '381', 'L': '382', 'M': '382', 'N': '382', 'O': '382', 'P': '382', 'Q': '382', 'R': '382',
        'S': '382', 'T': '382', 'W': '383', 'X': '383', 'Y': '383', 'Z': '383'
    },
    '吴': {
        'A': '391', 'B': '391', 'C': '391', 'D': '391', 'E': '392', 'F': '392', 'G': '392', 'H': '393', 'I': '393',
        'J': '393', 'K': '393', 'L': '394', 'M': '394', 'N': '394', 'O': '395', 'P': '395', 'Q': '395', 'R': '395',
        'S': '396', 'T': '396', 'W': '397', 'X': '397', 'Y': '398', 'Z': '399'
    },
    '武汉': {
        'A': '42', 'B': '42', 'C': '42', 'D': '42', 'E': '42', 'F': '42', 'G': '42', 'H': '42', 'I': '42', 'J': '42',
        'K': '42', 'L': '43', 'M': '43', 'N': '43', 'O': '43', 'P': '43', 'Q': '43', 'R': '43', 'S': '43', 'T': '43',
        'W': '44', 'X': '44', 'Y': '44', 'Z': '44'
    },
    '武': {
        'A': '441', 'B': '441', 'C': '441', 'D': '441', 'E': '441', 'F': '441', 'G': '441', 'H': '441', 'I': '441',
        'J': '441', 'K': '441', 'L': '442', 'M': '442', 'N': '442', 'O': '442', 'P': '442', 'Q': '442', 'R': '442',
        'S': '442', 'T': '442', 'W': '443', 'X': '443', 'Y': '443', 'Z': '443'
    },
    '西安': {
        'A': '11', 'B': '11', 'C': '11', 'D': '11', 'E': '11', 'F': '11', 'G': '11', 'H': '12', 'I': '12', 'J': '12',
        'K': '12', 'L': '13', 'M': '13', 'N': '13', 'O': '13', 'P': '13', 'Q': '13', 'R': '13', 'S': '14', 'T': '14',
        'W': '15', 'X': '15', 'Y': '16', 'Z': '16'
    },
    '西北': {
        'A': '17', 'B': '17', 'C': '17', 'D': '17', 'E': '17', 'F': '17', 'G': '17', 'H': '17', 'I': '17', 'J': '17',
        'K': '17', 'L': '18', 'M': '18', 'N': '18', 'O': '18', 'P': '18', 'Q': '18', 'R': '18', 'S': '18', 'T': '18',
        'W': '19', 'X': '19', 'Y': '19', 'Z': '19'
    },
    '希': {
        'A': '222', 'B': '222', 'C': '222', 'D': '222', 'E': '222', 'F': '222', 'G': '222', 'H': '222', 'I': '222',
        'J': '222', 'K': '222', 'L': '223', 'M': '223', 'N': '223', 'O': '223', 'P': '223', 'Q': '223', 'R': '223',
        'S': '223', 'T': '223', 'W': '224', 'X': '224', 'Y': '224', 'Z': '224'
    },
    '席': {
        'A': '245', 'B': '245', 'C': '245', 'D': '245', 'E': '245', 'F': '245', 'G': '245', 'H': '245', 'I': '245',
        'J': '245', 'K': '245', 'L': '246', 'M': '246', 'N': '246', 'O': '246', 'P': '246', 'Q': '246', 'R': '246',
        'S': '246', 'T': '246', 'W': '247', 'X': '247', 'Y': '247', 'Z': '247'
    },
    '夏': {
        'A': '291', 'B': '291', 'C': '291', 'D': '291', 'E': '291', 'F': '291', 'G': '291', 'H': '291', 'I': '291',
        'J': '291', 'K': '291', 'L': '292', 'M': '292', 'N': '292', 'O': '292', 'P': '292', 'Q': '292', 'R': '292',
        'S': '292', 'T': '292', 'W': '293', 'X': '293', 'Y': '293', 'Z': '293'
    },
    '萧': {
        'A': '381', 'B': '381', 'C': '381', 'D': '381', 'E': '381', 'F': '381', 'G': '381', 'H': '381', 'I': '381',
        'J': '381', 'K': '381', 'L': '382', 'M': '382', 'N': '382', 'O': '382', 'P': '382', 'Q': '382', 'R': '382',
        'S': '382', 'T': '382', 'W': '383', 'X': '383', 'Y': '383', 'Z': '383'
    },
    '肖': {
        'A': '411', 'B': '411', 'C': '411', 'D': '411', 'E': '411', 'F': '411', 'G': '411', 'H': '411', 'I': '411',
        'J': '411', 'K': '411', 'L': '412', 'M': '412', 'N': '412', 'O': '412', 'P': '412', 'Q': '412', 'R': '412',
        'S': '412', 'T': '412', 'W': '413', 'X': '413', 'Y': '413', 'Z': '413'
    },
    '谢': {
        'A': '435', 'B': '435', 'C': '435', 'D': '435', 'E': '435', 'F': '435', 'G': '435', 'H': '436', 'I': '436',
        'J': '436', 'K': '436', 'L': '437', 'M': '437', 'N': '437', 'O': '437', 'P': '437', 'Q': '437', 'R': '437',
        'S': '438', 'T': '438', 'W': '439', 'X': '439', 'Y': '441', 'Z': '441'
    },
    '新疆': {
        'A': '45', 'B': '45', 'C': '45', 'D': '45', 'E': '45', 'F': '45', 'G': '45', 'H': '45', 'I': '45', 'J': '45',
        'K': '45', 'L': '46', 'M': '46', 'N': '46', 'O': '46', 'P': '46', 'Q': '46', 'R': '46', 'S': '46', 'T': '46',
        'W': '47', 'X': '47', 'Y': '47', 'Z': '47'
    },
    '新': {
        'A': '471', 'B': '471', 'C': '471', 'D': '471', 'E': '471', 'F': '471', 'G': '471', 'H': '471', 'I': '471',
        'J': '471', 'K': '471', 'L': '472', 'M': '472', 'N': '472', 'O': '472', 'P': '472', 'Q': '472', 'R': '472',
        'S': '472', 'T': '472', 'W': '473', 'X': '473', 'Y': '473', 'Z': '473'
    },
    '辛': {
        'A': '474', 'B': '474', 'C': '474', 'D': '474', 'E': '474', 'F': '474', 'G': '474', 'H': '474', 'I': '474',
        'J': '474', 'K': '474', 'L': '475', 'M': '475', 'N': '475', 'O': '475', 'P': '475', 'Q': '475', 'R': '475',
        'S': '475', 'T': '475', 'W': '476', 'X': '476', 'Y': '476', 'Z': '476'
    },
    '邢': {
        'A': '496', 'B': '496', 'C': '496', 'D': '496', 'E': '496', 'F': '496', 'G': '496', 'H': '496', 'I': '496',
        'J': '496', 'K': '496', 'L': '497', 'M': '497', 'N': '497', 'O': '497', 'P': '497', 'Q': '497', 'R': '497',
        'S': '497', 'T': '497', 'W': '498', 'X': '498', 'Y': '498', 'Z': '498'
    },
    '熊': {
        'A': '531', 'B': '531', 'C': '531', 'D': '531', 'E': '531', 'F': '531', 'G': '531', 'H': '531', 'I': '531',
        'J': '531', 'K': '531', 'L': '532', 'M': '532', 'N': '532', 'O': '532', 'P': '532', 'Q': '532', 'R': '532',
        'S': '532', 'T': '532', 'W': '533', 'X': '533', 'Y': '533', 'Z': '533'
    },
    '徐': {
        'A': '561', 'B': '561', 'C': '561', 'D': '561', 'E': '561', 'F': '561', 'G': '561', 'H': '562', 'I': '562',
        'J': '562', 'K': '562', 'L': '563', 'M': '563', 'N': '563', 'O': '563', 'P': '563', 'Q': '563', 'R': '563',
        'S': '564', 'T': '564', 'W': '565', 'X': '565', 'Y': '566', 'Z': '566'
    },
    '许': {
        'A': '571', 'B': '571', 'C': '571', 'D': '571', 'E': '571', 'F': '571', 'G': '571', 'H': '571', 'I': '571',
        'J': '571', 'K': '571', 'L': '572', 'M': '572', 'N': '572', 'O': '572', 'P': '572', 'Q': '572', 'R': '572',
        'S': '572', 'T': '572', 'W': '573', 'X': '573', 'Y': '573', 'Z': '573'
    },
    '薛': {
        'A': '621', 'B': '621', 'C': '621', 'D': '621', 'E': '621', 'F': '621', 'G': '621', 'H': '621', 'I': '621',
        'J': '621', 'K': '621', 'L': '622', 'M': '622', 'N': '622', 'O': '622', 'P': '622', 'Q': '622', 'R': '622',
        'S': '622', 'T': '622', 'W': '623', 'X': '623', 'Y': '623', 'Z': '623'
    },
    '雅': {
        'A': '121', 'B': '121', 'C': '121', 'D': '121', 'E': '121', 'F': '121', 'G': '121', 'H': '121', 'I': '121',
        'J': '121', 'K': '121', 'L': '122', 'M': '122', 'N': '122', 'O': '122', 'P': '122', 'Q': '122', 'R': '122',
        'S': '122', 'T': '122', 'W': '123', 'X': '123', 'Y': '123', 'Z': '123'
    },
    '亚洲': {
        'A': '13', 'B': '13', 'C': '13', 'D': '13', 'E': '13', 'F': '13', 'G': '13', 'H': '13', 'I': '13', 'J': '13',
        'K': '13', 'L': '14', 'M': '14', 'N': '14', 'O': '14', 'P': '14', 'Q': '14', 'R': '14', 'S': '14', 'T': '14',
        'W': '15', 'X': '15', 'Y': '15', 'Z': '15'
    },
    '严': {
        'A': '165', 'B': '165', 'C': '165', 'D': '165', 'E': '165', 'F': '165', 'G': '165', 'H': '165', 'I': '165',
        'J': '165', 'K': '165', 'L': '166', 'M': '166', 'N': '166', 'O': '166', 'P': '166', 'Q': '166', 'R': '166',
        'S': '166', 'T': '166', 'W': '167', 'X': '167', 'Y': '167', 'Z': '167'
    },
    '杨': {
        'A': '221', 'B': '221', 'C': '221', 'D': '221', 'E': '222', 'F': '222', 'G': '222', 'H': '223', 'I': '223',
        'J': '223', 'K': '223', 'L': '224', 'M': '224', 'N': '224', 'O': '225', 'P': '225', 'Q': '225', 'R': '225',
        'S': '226', 'T': '226', 'W': '227', 'X': '227', 'Y': '228', 'Z': '229'
    },
    '姚': {
        'A': '256', 'B': '256', 'C': '256', 'D': '256', 'E': '256', 'F': '256', 'G': '256', 'H': '256', 'I': '256',
        'J': '256', 'K': '256', 'L': '257', 'M': '257', 'N': '257', 'O': '257', 'P': '257', 'Q': '257', 'R': '257',
        'S': '257', 'T': '257', 'W': '258', 'X': '258', 'Y': '258', 'Z': '258'
    },
    '耶': {
        'A': '281', 'B': '281', 'C': '281', 'D': '281', 'E': '281', 'F': '281', 'G': '281', 'H': '281', 'I': '281',
        'J': '281', 'K': '281', 'L': '282', 'M': '282', 'N': '282', 'O': '282', 'P': '282', 'Q': '282', 'R': '282',
        'S': '282', 'T': '282', 'W': '283', 'X': '283', 'Y': '283', 'Z': '283'
    },
    '治金工业部': {
        'A': '29', 'B': '29', 'C': '29', 'D': '29', 'E': '29', 'F': '29', 'G': '29', 'H': '29', 'I': '29', 'J': '29',
        'K': '29', 'L': '31', 'M': '31', 'N': '31', 'O': '31', 'P': '31', 'Q': '31', 'R': '31', 'S': '31', 'T': '31',
        'W': '32', 'X': '32', 'Y': '32', 'Z': '32'
    },
    '叶': {
        'A': '325', 'B': '325', 'C': '325', 'D': '325', 'E': '325', 'F': '325', 'G': '325', 'H': '325', 'I': '325',
        'J': '325', 'K': '325', 'L': '326', 'M': '326', 'N': '326', 'O': '326', 'P': '326', 'Q': '326', 'R': '326',
        'S': '326', 'T': '326', 'W': '327', 'X': '327', 'Y': '327', 'Z': '327'
    },
    '伊': {
        'A': '341', 'B': '341', 'C': '341', 'D': '341', 'E': '341', 'F': '341', 'G': '341', 'H': '341', 'I': '341',
        'J': '341', 'K': '341', 'L': '342', 'M': '342', 'N': '342', 'O': '342', 'P': '342', 'Q': '342', 'R': '342',
        'S': '342', 'T': '342', 'W': '343', 'X': '343', 'Y': '343', 'Z': '343'
    },
    '依': {
        'A': '344', 'B': '344', 'C': '344', 'D': '344', 'E': '344', 'F': '344', 'G': '344', 'H': '344', 'I': '344',
        'J': '344', 'K': '344', 'L': '345', 'M': '345', 'N': '345', 'O': '345', 'P': '345', 'Q': '345', 'R': '345',
        'S': '345', 'T': '345', 'W': '346', 'X': '346', 'Y': '346', 'Z': '346'
    },
    '殷': {
        'A': '417', 'B': '417', 'C': '417', 'D': '417', 'E': '417', 'F': '417', 'G': '417', 'H': '417', 'I': '417',
        'J': '417', 'K': '417', 'L': '418', 'M': '418', 'N': '418', 'O': '418', 'P': '418', 'Q': '418', 'R': '418',
        'S': '418', 'T': '418', 'W': '419', 'X': '419', 'Y': '419', 'Z': '419'
    },
    '尹': {
        'A': '441', 'B': '441', 'C': '441', 'D': '441', 'E': '441', 'F': '441', 'G': '441', 'H': '441', 'I': '441',
        'J': '441', 'K': '441', 'L': '442', 'M': '442', 'N': '442', 'O': '442', 'P': '442', 'Q': '442', 'R': '442',
        'S': '442', 'T': '442', 'W': '443', 'X': '443', 'Y': '443', 'Z': '443'
    },
    '应': {
        'A': '461', 'B': '461', 'C': '461', 'D': '461', 'E': '461', 'F': '461', 'G': '461', 'H': '461', 'I': '461',
        'J': '461', 'K': '461', 'L': '462', 'M': '462', 'N': '462', 'O': '462', 'P': '462', 'Q': '462', 'R': '462',
        'S': '462', 'T': '462', 'W': '463', 'X': '463', 'Y': '463', 'Z': '463'
    },
    '尤': {
        'A': '542', 'B': '542', 'C': '542', 'D': '542', 'E': '542', 'F': '542', 'G': '542', 'H': '542', 'I': '542',
        'J': '542', 'K': '542', 'L': '543', 'M': '543', 'N': '543', 'O': '543', 'P': '543', 'Q': '543', 'R': '543',
        'S': '543', 'T': '543', 'W': '544', 'X': '544', 'Y': '544', 'Z': '544'
    },
    '余': {
        'A': '585', 'B': '585', 'C': '585', 'D': '585', 'E': '585', 'F': '585', 'G': '585', 'H': '585', 'I': '585',
        'J': '585', 'K': '585', 'L': '586', 'M': '586', 'N': '586', 'O': '586', 'P': '586', 'Q': '586', 'R': '586',
        'S': '586', 'T': '586', 'W': '587', 'X': '587', 'Y': '587', 'Z': '587'
    },
    '俞': {
        'A': '588', 'B': '588', 'C': '588', 'D': '588', 'E': '588', 'F': '588', 'G': '588', 'H': '588', 'I': '588',
        'J': '588', 'K': '588', 'L': '589', 'M': '589', 'N': '589', 'O': '589', 'P': '589', 'Q': '589', 'R': '589',
        'S': '589', 'T': '589', 'W': '591', 'X': '591', 'Y': '591', 'Z': '591'
    },
    '于': {
        'A': '592', 'B': '592', 'C': '592', 'D': '592', 'E': '592', 'F': '592', 'G': '592', 'H': '592', 'I': '592',
        'J': '592', 'K': '592', 'L': '593', 'M': '593', 'N': '593', 'O': '593', 'P': '593', 'Q': '593', 'R': '593',
        'S': '593', 'T': '593', 'W': '594', 'X': '594', 'Y': '594', 'Z': '594'
    },
    '袁': {
        'A': '677', 'B': '677', 'C': '677', 'D': '677', 'E': '677', 'F': '677', 'G': '677', 'H': '677', 'I': '677',
        'J': '677', 'K': '677', 'L': '678', 'M': '678', 'N': '678', 'O': '678', 'P': '678', 'Q': '678', 'R': '678',
        'S': '678', 'T': '678', 'W': '679', 'X': '679', 'Y': '679', 'Z': '679'
    },
    '约': {
        'A': '721', 'B': '721', 'C': '721', 'D': '721', 'E': '721', 'F': '721', 'G': '721', 'H': '721', 'I': '721',
        'J': '721', 'K': '721', 'L': '722', 'M': '722', 'N': '722', 'O': '722', 'P': '722', 'Q': '722', 'R': '722',
        'S': '722', 'T': '722', 'W': '723', 'X': '723', 'Y': '723', 'Z': '723'
    },
    '云南': {
        'A': '75', 'B': '75', 'C': '75', 'D': '75', 'E': '75', 'F': '75', 'G': '75', 'H': '75', 'I': '75', 'J': '75',
        'K': '75', 'L': '76', 'M': '76', 'N': '76', 'O': '76', 'P': '76', 'Q': '76', 'R': '76', 'S': '76', 'T': '76',
        'W': '77', 'X': '77', 'Y': '77', 'Z': '77'
    },
    '曾': {
        'A': '157', 'B': '157', 'C': '157', 'D': '157', 'E': '157', 'F': '157', 'G': '157', 'H': '157', 'I': '157',
        'J': '157', 'K': '157', 'L': '158', 'M': '158', 'N': '158', 'O': '158', 'P': '158', 'Q': '158', 'R': '158',
        'S': '158', 'T': '158', 'W': '159', 'X': '159', 'Y': '159', 'Z': '159'
    },
    '查': {
        'A': '171', 'B': '171', 'C': '171', 'D': '171', 'E': '171', 'F': '171', 'G': '171', 'H': '171', 'I': '171',
        'J': '171', 'K': '171', 'L': '172', 'M': '172', 'N': '172', 'O': '172', 'P': '172', 'Q': '172', 'R': '172',
        'S': '172', 'T': '172', 'W': '173', 'X': '173', 'Y': '173', 'Z': '173'
    },
    '扎': {
        'A': '181', 'B': '181', 'C': '181', 'D': '181', 'E': '181', 'F': '181', 'G': '181', 'H': '181', 'I': '181',
        'J': '181', 'K': '181', 'L': '182', 'M': '182', 'N': '182', 'O': '182', 'P': '182', 'Q': '182', 'R': '182',
        'S': '182', 'T': '182', 'W': '183', 'X': '183', 'Y': '183', 'Z': '183'
    },
    '詹': {
        'A': '213', 'B': '213', 'C': '213', 'D': '213', 'E': '213', 'F': '213', 'G': '213', 'H': '213', 'I': '213',
        'J': '213', 'K': '213', 'L': '214', 'M': '214', 'N': '214', 'O': '214', 'P': '214', 'Q': '214', 'R': '214',
        'S': '214', 'T': '214', 'W': '215', 'X': '215', 'Y': '215', 'Z': '215'
    },
    '张': {
        'A': '235', 'B': '236', 'C': '237', 'D': '238', 'E': '239', 'F': '241', 'G': '242', 'H': '243', 'J': '244',
        'K': '245', 'L': '246', 'M': '247', 'N': '248', 'O': '249', 'P': '251', 'Q': '252', 'R': '253', 'S': '254',
        'T': '255', 'W': '256', 'X': '257', 'Y': '258', 'Z': '259'
    },
    '章': {
        'A': '261', 'B': '261', 'C': '261', 'D': '261', 'E': '261', 'F': '261', 'G': '261', 'H': '261', 'I': '261',
        'J': '261', 'K': '261', 'L': '262', 'M': '262', 'N': '262', 'O': '262', 'P': '262', 'Q': '262', 'R': '262',
        'S': '262', 'T': '262', 'W': '263', 'X': '263', 'Y': '263', 'Z': '263'
    },
    '赵': {
        'A': '295', 'B': '296', 'C': '297', 'D': '298', 'E': '299', 'F': '301', 'G': '302', 'H': '303', 'J': '304',
        'K': '305', 'L': '306', 'M': '307', 'N': '308', 'O': '309', 'P': '311', 'Q': '312', 'R': '313', 'S': '314',
        'T': '315', 'W': '316', 'X': '317', 'Y': '318', 'Z': '319'
    },
    '浙江': {
        'A': '34', 'B': '34', 'C': '34', 'D': '34', 'E': '34', 'F': '34', 'G': '34', 'H': '34', 'I': '34', 'J': '34',
        'K': '34', 'L': '35', 'M': '35', 'N': '35', 'O': '35', 'P': '35', 'Q': '35', 'R': '35', 'S': '35', 'T': '35',
        'W': '36', 'X': '36', 'Y': '36', 'Z': '36'
    },
    '郑': {
        'A': '421', 'B': '421', 'C': '421', 'D': '421', 'E': '421', 'F': '421', 'G': '421', 'H': '421', 'I': '421',
        'J': '421', 'K': '421', 'L': '422', 'M': '422', 'N': '422', 'O': '422', 'P': '422', 'Q': '422', 'R': '422',
        'S': '422', 'T': '422', 'W': '423', 'X': '423', 'Y': '423', 'Z': '423'
    },
    '中共': {
        'A': '49', 'B': '49', 'C': '49', 'D': '49', 'E': '49', 'F': '49', 'G': '49', 'H': '50', 'I': '50', 'J': '50',
        'K': '50', 'L': '51', 'M': '51', 'N': '51', 'O': '51', 'P': '51', 'Q': '51', 'R': '51', 'S': '52', 'T': '52',
        'W': '53', 'X': '53', 'Y': '54', 'Z': '54'
    },
    '中国科学院': {
        'A': '55', 'B': '55', 'C': '55', 'D': '55', 'E': '56', 'F': '56', 'G': '56', 'H': '57', 'I': '57', 'J': '57',
        'K': '57', 'L': '58', 'M': '58', 'N': '58', 'O': '59', 'P': '59', 'Q': '59', 'R': '59', 'S': '60', 'T': '60',
        'W': '61', 'X': '61', 'Y': '62', 'Z': '63'
    },
    '中国': {
        'A': '64', 'B': '64', 'C': '64', 'D': '64', 'E': '64', 'F': '64', 'G': '64', 'H': '65', 'I': '65', 'J': '65',
        'K': '65', 'L': '66', 'M': '66', 'N': '66', 'O': '66', 'P': '66', 'Q': '66', 'R': '66', 'S': '67', 'T': '67',
        'W': '68', 'X': '68', 'Y': '69', 'Z': '69'
    },
    '中国农业科学院': {
        'A': '70', 'B': '70', 'C': '70', 'D': '70', 'E': '70', 'F': '70', 'G': '70', 'H': '71', 'I': '71', 'J': '71',
        'K': '71', 'L': '71', 'M': '71', 'N': '72', 'O': '72', 'P': '72', 'Q': '72', 'R': '72', 'S': '72', 'T': '72',
        'W': '72', 'X': '72', 'Y': '73', 'Z': '73'
    },
    '中': {
        'A': '751', 'B': '751', 'C': '751', 'D': '751', 'E': '751', 'F': '751', 'G': '751', 'H': '751', 'I': '751',
        'J': '751', 'K': '751', 'L': '752', 'M': '752', 'N': '752', 'O': '752', 'P': '752', 'Q': '752', 'R': '752',
        'S': '752', 'T': '752', 'W': '753', 'X': '753', 'Y': '753', 'Z': '753'
    },
    '周': {
        'A': '772', 'B': '772', 'C': '772', 'D': '772', 'E': '772', 'F': '772', 'G': '772', 'H': '773', 'I': '773',
        'J': '773', 'K': '773', 'L': '774', 'M': '774', 'N': '774', 'O': '774', 'P': '774', 'Q': '774', 'R': '774',
        'S': '775', 'T': '775', 'W': '776', 'X': '776', 'Y': '777', 'Z': '777'
    },
    '朱': {
        'A': '796', 'B': '796', 'C': '796', 'D': '796', 'E': '796', 'F': '796', 'G': '796', 'H': '797', 'I': '797',
        'J': '797', 'K': '797', 'L': '798', 'M': '798', 'N': '798', 'O': '798', 'P': '798', 'Q': '798', 'R': '798',
        'S': '799', 'T': '799', 'W': '801', 'X': '801', 'Y': '802', 'Z': '802'
    },
    '兹': {
        'A': '901', 'B': '901', 'C': '901', 'D': '901', 'E': '901', 'F': '901', 'G': '901', 'H': '901', 'I': '901',
        'J': '901', 'K': '901', 'L': '902', 'M': '902', 'N': '902', 'O': '902', 'P': '902', 'Q': '902', 'R': '902',
        'S': '902', 'T': '902', 'W': '903', 'X': '903', 'Y': '903', 'Z': '903'
    },
    '迮': '981', '孜': '905', '咨': '906', '淄': '907', '籽': '917', '梓': '916', '紫': '915', '訾': '908', '自': '921',
    '字': '922', '宗': '926', '综': '928', '踪': '927', '总': '931', '纵': '933', '邹': '935', '陬': '936', '走': '941',
    '奏': '942', '租': '943', '足': '945', '族': '944', '组': '949', '祖': '948', '钻': '953', '钻4': '957', '纂': '955',
    '嘴': '961', '最': '962', '罪': '964', '醉': '963', '尊': '966', '遵': '967', '撙': '969', '嘬': '971', '昨': '972',
    '左': '976', '佐': '977', '作': '973', '坐': '984', '座': '983', '做': '982', '啊': '121', '哀': '131', '埃': '132',
    '挨': '134', '矮': '136', '爱': '144', '安徽': '15', '桉': '155', '氨': '156', '庵': '157', '鞍': '154', '俺': '161',
    '岸': '164', '暗': '165', '肮': '171', '昂': '173', '盎': '175', '凹': '181', '敖': '183', '袄': '188', '拗': '368',
    '澳': '197', '八': '117', '芭': '118', '拔': '121', '跋': '641', '把': '125', '坝': '131', '壩': '131', '霸': '132',
    '灞': '133', '掰': '141', '百': '151', '柏': '152', '摆': '153', '败': '157', '拜': '156', '扳': '162', '班': '161',
    '般': '164', '搬': '163', '阪': '173', '坂': '172', '板': '171', '版': '174', '办': '182', '半': '181', '伴': '183',
    '邦': '191', '帮': '192', '榜': '211', '蚌': '448', '棒': '216', '傍': '215', '胞': '224', '褒': '225', '薄': '624',
    '宝': '234', '保': '233', '葆': '235', '堡': '443', '报': '254', '抱': '255', '豹': '256', '暴': '258', '爆': '257',
    '杯': '273', '卑': '274', '碑': '272', '北': '411', '孛': '629', '备': '418', '背': '271', '倍': '416', '被': '417',
    '奔': '431', '贲': '432', '本': '434', '笨': '438', '崩': '441', '绷': '443', '甭': '442', '泵': '447', '逼': '461',
    '鼻': '462', '妣': '471', '笔': '472', '俾': '473', '币': '485', '必': '478', '庇': '481', '畀': '484', '碧': '479',
    '薜': '483', '壁': '482', '边': '511', '编': '512', '扁': '515', '卞': '521', '变': '523', '便': '295', '遍': '524',
    '辩': '522', '标': '531', '彪': '532', '骠': '332', '镖': '538', '表': '536', '鳖': '541', '宾': '554', '彬': '553',
    '斌': '552', '滨': '551', '膑': '561', '冰': '572', '兵': '571', '丙': '576', '邴': '579', '秉': '575', '饼': '577',
    '炳': '578', '并': '573', '病': '581', '玻': '597', '剥': '598', '菠': '599', '伯': '625', '博': '627', '渤': '626',
    '簸': '643', '卜': '653', '逋': '651', '补': '654', '捕': '655', '不': '668', '步': '667', '擦': '111', '猜': '114',
    '才': '122', '材': '123', '财': '121', '财政部': '12', '采': '126', '彩': '127', '菜': '134', '参': '181', '残': '145',
    '蚕': '144', '灿': '148', '仓': '153', '苍': '154', '沧': '155', '藏': '129', '操': '161', '草': '168', '测': '171',
    '测量': '17', '策': '172', '岑': '183', '曾c': '185', '蹭': '188', '叉': '213', '茶': '196', '查c': '195', '察': '197',
    '诧': '214', '差': '222', '拆': '221', '柴': '224', '豺': '225', '瘥': '228', '掺': '231', '禅': '235', '蝉': '234',
    '产': '241', '忏': '247', '昌': '251', '晿': '216', '常': '272', '厂': '282', '场': '281', '畅': '283', '倡': '287',
    '唱': '286', '钞': '292', '超': '291', '晁': '294', '巢': '296', '朝': '285', '吵': '298', '车': '311', '扯': '313',
    '彻': '315', '撤': '316', '琛': '321', '尘': '355', '辰': '353', '沉': '354', '茞': '226', '晨': '352', '谌': '351',
    '碜': '361', '衬': '363', '趁': '364', '称': '371', '成': '381', '成都': '38', '诚': '385', '承': '387', '城': '386',
    '乘': '388', '逞': '397', '秤': '399', '吃': '411', '蚩': '412', '池': '421', '驰': '424', '迟': '422', '持': '423',
    '齿': '431', '斥': '437', '赤': '436', '冲': '451', '充': '452', '虫': '463', '崇': '462', '宠': '467', '铳': '468',
    '仇': '493', '愁': '494', '丑': '481', '臭': '483', '出': '486', '初': '485', '樗': '487', '除': '491', '厨': '493',
    '锄': '492', '雏': '494', '储': '514', '楚': '511', '褚': '512', '处': '513', '畜': '581', '触': '522', '揣': '531',
    '川': '541', '穿': '542', '传': '856', '船': '545', '舛': '547', '喘': '548', '串': '549', '窗': '551', '床': '554',
    '闯': '557', '创': '558', '吹': '561', '垂': '563', '春': '571', '椿': '572', '纯': '574', '淳': '575', '醇': '576',
    '蠢': '579', '戳': '581', '绰': '583', '疵': '591', '词': '595', '茨': '596', '辞': '594', '慈': '593', '磁': '597',
    '此': '614', '次': '616', '赐': '617', '聪': '621', '从': '631', '丛': '632', '凑': '637', '粗': '641', '徂': '642',
    '促': '644', '醋': '645', '汆': '651', '篡': '656', '爨': '657', '催': '664', '摧': '665', '璀': '669', '脆': '672',
    '翠': '671', '村': '681', '存': '683', '忖': '685', '寸': '687', '撮': '691', '嵯': '694', '脞': '696', '错': '697',
    '哒': '112', '笪': '115', '答': '111', '打': '117', '大': '118', '呆': '122', '逮': '123', '傣': '124', '代': '128',
    '岱': '131', '带': '129', '待': '121', '黛': '132', '丹': '141', '单': '284', '单于': '233', '胆': '147', '旦': '154',
    '但': '151', '淡': '155', '弹': '184', '蛋': '156', '氮': '152', '当': '161', '党': '163', '砀': '167', '宕': '168',
    '荡': '165', '档': '166', '刀': '171', '导': '173', '岛': '174', '道': '177', '稻': '178', '得': '184', '地': '281',
    '地图': '25', '灯': '191', '登': '192', '氐': '222', '堤': '221', '镝': '233', '迪': '228', '荻': '231', '涤': '232',
    '笛': '229', '邸': '394', '抵': '242', '底': '241', '帝': '392', '第': '391', '第八': '37', '第二': '31', '第九': '38',
    '第六': '35', '第七': '36', '第三': '32', '第十': '39', '第四': '33', '第五': '34', '第一': '29', '蒂': '393', '滇': '411',
    '槙': '412', '巅': '413', '典': '415', '点': '416', '电': '421', '淀': '423', '奠': '422', '刁': '431', '貂': '432',
    '钓': '436', '调': '475', '跌': '441', '迭': '444', '蝶': '443', '顶': '457', '鼎': '458', '定': '461', '丢': '468',
    '东': '471', '东北': '47', '冬': '472', '懂': '478', '动': '481', '洞': '482', '都': '521', '兜': '491', '抖': '495',
    '斗': '494', '豆': '512', '窦': '511', '督': '522', '嘟': '523', '毒': '526', '独': '525', '读': '527', '笃': '532',
    '堵': '531', '度': '544', '渡': '545', '端': '551', '端木': '552', '短': '554', '锻': '559', '堆': '571', '队': '582',
    '对': '581', '对外贸易部': '58', '兑': '583', '碓': '584', '敦': '591', '顿': '597', '夺': '622', '铎': '621', '朵': '625',
    '躲': '626', '堕': '632', '惰': '631', '俄': '113', '额': '114', '厄': '123', '恶': '121', '鄂': '122', '恩': '131',
    '恩格斯': '12', '儿': '133', '而': '134', '尔': '141', '耳': '142', '珥': '143', '二': '151', '佴': '136', '贰': '152',
    '发': '125', '乏': '112', '伐': '113', '阀': '114', '帆': '133', '番': '134', '蕃': '138', '藩': '134', '翻': '132',
    '凡': '139', '繁': '141', '反': '151', '返': '152', '犯': '162', '饭': '159', '泛': '158', '梵': '161', '芳': '174',
    '防': '182', '房': '181', '仿': '193', '访': '192', '纺': '191', '纺织工业部': '19', '放': '196', '飞': '215', '非': '214',
    '肥': '218', '淝': '219', '匪': '224', '斐': '223', '肺': '238', '废': '237', '沸': '239', '分': '252', '芬': '251',
    '纷': '253', '汾': '261', '焚': '262', '粉': '268', '奋': '271', '愤': '272', '丰': '281', '风': '283', '枫': '287',
    '封': '284', '疯': '289', '峰': '285', '烽': '288', '蜂': '286', '逢': '294', '讽': '298', '凤': '312', '奉': '311',
    '否': '324', '夫': '326', '肤': '328', '敷': '327', '扶': '414', '芙': '417', '佛': '321', '孚': '415', '茀': '416',
    '服': '413', '浮': '412', '福': '391', '抚': '433', '甫': '431', '辅': '434', '腐': '432', '付': '464', '妇': '463',
    '阜': '458', '赴': '459', '复': '451', '副': '462', '腹': '461', '伽': '276', '嘎': '111', '尕': '112', '该': '121',
    '改': '128', '概': '134', '甘': '191', '柑': '193', '敢': '211', '感': '212', '橄': '213', '干': '192', '绀': '216',
    '淦': '217', '赣': '218', '冈': '222', '刚': '223', '纲': '224', '钢': '221', '罡': '225', '岗': '228', '港': '229',
    '杠': '233', '皋': '251', '高等教育部': '24', '杲': '257', '搞': '256', '稿': '258', '藁': '259', '告': '261', '郜': '262',
    '圪': '276', '哥': '274', '歌': '275', '革': '287', '鬲': '289', '隔': '288', '个': '317', '各': '316', '给': '321',
    '根': '323', '跟': '324', '庚': '598', '耕': '331', '更': '342', '工': '357', '弓': '362', '公': '351', '公安部': '35',
    '公孙': '352', '功': '358', '攻': '364', '供': '363', '宫': '356', '恭': '359', '巩': '365', '汞': '366', '拱': '367',
    '共': '391', '贡': '392', '勾': '412', '沟': '415', '钩': '413', '缑': '411', '篝': '414', '苟': '417', '狗': '419',
    '枸': '418', '构': '423', '购': '422', '够': '421', '孤': '578', '姑': '432', '辜': '431', '古': '444', '骨': '438',
    '鼓': '445', '固': '465', '故': '464', '瓜': '471', '刮': '472', '寡': '474', '挂': '476', '怪': '481', '观': '489',
    '官': '488', '冠': '497', '馆': '493', '管': '493', '贯': '496', '灌': '498', '罐': '499', '光': '521', '广': '621',
    '逛': '627', '归': '631', '龟': '633', '规': '632', '硅': '634', '轨': '641', '鬼': '643', '癸': '642', '贵': '681',
    '贵阳': '65', '桂': '682', '辊': '692', '滚': '691', '棍': '695', '呙': '331', '锅': '715', '国家': '72', '虢': '755',
    '果': '761', '过': '765', '蛤': '135', '咳': '141', '还': '764', '孩': '143', '亥': '152', '害': '151', '酣': '162',
    '憨': '161', '邯': '169', '函': '171', '晗': '172', '涵': '168', '寒': '167', '罕': '182', '喊': '181', '汉': '184',
    '汗': '186', '旱': '188', '捍': '185', '菡': '189', '焊': '187', '憾': '192', '瀚': '191', '夯': '211', '杭': '221',
    '杭州': '22', '航': '222', '蒿': '231', '毫': '234', '豪': '233', '好': '239', '号': '244', '昊': '245', '浩': '243',
    '喝': '251', '禾': '338', '合': '331', '合肥': '33', '和': '333', '郃': '339', '河': '321', '荷': '332', '核': '337',
    '鹤': '347', '黑': '371', '痕': '373', '很': '374', '亨': '381', '恒': '384', '桁': '386', '横': '388', '衡': '383',
    '蘅': '385', '轰': '392', '哄': '414', '烘': '391', '弘': '399', '红': '397', '宏': '398', '虹': '412', '鸿': '411',
    '讧': '416', '喉': '426', '猴': '427', '吼': '428', '后': '432', '厚': '431', '乎': '444', '呼': '441', '呼和浩特': '44',
    '呼延': '442', '忽': '445', '滹': '443', '湖': '571', '虎': '591', '浒': '592', '互': '598', '户': '595', '护': '597',
    '沪': '596', '扈': '599', '鄠': '601', '花': '617', '华': '721', '华中': '72', '滑': '722', '化': '751', '画': '752',
    '话': '753', '桦': '723', '怀': '755', '淮': '754', '槐': '756', '坏': '758', '欢': '761', '环': '766', '桓': '765',
    '缓': '771', '幻': '774', '宦': '775', '换': '776', '焕': '773', '荒': '781', '皇': '855', '皇甫': '854', '磺': '856',
    '恍': '861', '晃': '864', '灰': '872', '恢': '873', '珲': '912', '辉': '871', '徽': '874', '回': '878', '悔': '881',
    '毁': '882', '汇': '888', '会': '887', '绘': '884', '晦': '886', '惠': '885', '慧': '899', '蕙': '890', '昏': '911',
    '浑': '916', '魂': '915', '混': '917', '豁': '921', '活': '923', '火': '925', '伙': '926', '货': '934', '机': '131',
    '矶': '137', '鸡': '141', '积': '136', '姬': '133', '基': '134', '嵇': '132', '箕': '139', '畿': '142', '激': '135',
    '及': '216', '汲': '222', '极': '217', '急': '221', '戢': '219', '集': '214', '楫': '215', '籍': '218', '己': '233',
    '计': '251', '技': '254', '际': '255', '济': '231', '济南': '23', '既': '257', '寄': '253', '寂': '256', '绩': '258',
    '暨': '252', '夹': '291', '佳': '278', '迦': '277', '家': '275', '嘉': '274', '郏': '292', '甲': '298', '榎': '299',
    '价': '317', '架': '315', '稼': '316', '尖': '329', '坚': '324', '间': '325', '艰': '327', '监': '328', '菅': '326',
    '柬': '336', '俭': '341', '检': '338', '减': '339', '简': '337', '翦': '335', '蹇': '342', '见': '383', '建': '381',
    '建筑材料工业部': '35', '荐': '385', '剑': '384', '健': '382', '渐': '386', '谏': '388', '鉴': '387', '箭': '389', '将': '523',
    '讲': '514', '匠': '524', '降': '521', '绛': '522', '酱': '525', '交': '551', '胶': '553', '焦': '552', '角': '561',
    '矫': '562', '徼': '563', '较': '572', '教': '571', '教育部': '57', '阶': '583', '接': '581', '揭': '582', '嗟': '851',
    '街': '585', '节': '597', '劫': '601', '洁': '598', '结': '584', '颉': '599', '解': '442', '介': '625', '芥': '627',
    '界': '626', '借': '624', '堺': '628', '今': '638', '津': '637', '襟': '639', '锦': '651', '谨': '652', '进': '668',
    '近': '667', '劲': '669', '京': '683', '泾': '686', '经': '681', '经济': '68', '荆': '682', '惊': '687', '晶': '684',
    '精': '685', '井': '712', '景': '711', '璟': '714', '警': '713', '净': '726', '竞': '725', '竟': '723', '靓': '398',
    '敬': '721', '靖': '722', '静': '724', '镜': '727', '扃': '732', '炯': '734', '窘': '735', '纠': '742', '鸠': '743',
    '究': '741', '九': '745', '久': '746', '玖': '748', '酒': '747', '旧': '751', '救': '754', '就': '755', '鹫': '753',
    '居': '761', '驹': '764', '琚': '763', '雎': '765', '鞠': '762', '局': '782', '菊': '781', '橘': '783', '举': '791',
    '巨': '811', '句': '817', '拒': '816', '具': '812', '俱': '815', '剧': '813', '聚': '814', '捐': '831', '涓': '832',
    '卷': '837', '隽': '843', '绢': '841', '鄄': '842', '决': '854', '觉': '853', '绝': '855', '倔': '868', '厥': '856',
    '军': '871', '均': '873', '君': '875', '菌': '874', '俊': '883', '郡': '885', '峻': '882', '浚': '884', '骏': '881',
    '咖': '112', '喀': '111', '开': '131', '恺': '137', '忾': '145', '刊': '152', '勘': '153', '堪': '151', '坎': '155',
    '看': '158', '阚': '183', '慷': '166', '扛': '168', '亢': '171', '伉': '174', '抗': '172', '炕': '173', '靠': '187',
    '颗': '234', '壳': '275', '可': '243', '渴': '244', '客': '258', '氪': '259', '肯': '263', '垦': '264', '坑': '271',
    '空': '273', '恐': '278', '控': '281', '抠': '283', '口': '285', '扣': '287', '寇': '286', '枯': '311', '堀': '312',
    '苦': '314', '酷': '318', '夸': '325', '挎': '326', '跨': '327', '蒯': '332', '块': '335', '快': '334', '郐': '337',
    '宽': '341', '款': '343', '匡': '351', '狂': '353', '邝': '356', '旷': '358', '况': '357', '矿': '355', '亏': '364',
    '岿': '366', '窥': '365', '奎': '371', '葵': '373', '魁': '374', '夔': '372', '傀': '381', '溃': '384', '愧': '383',
    '坤': '392', '昆': '391', '昆明': '39', '堃': '412', '鲲': '393', '捆': '411', '困': '414', '扩': '415', '括': '417',
    '阔': '416', '廓': '418', '拉萨': '11', '剌': '115', '喇': '117', '腊': '123', '蜡': '121', '辣': '122', '来': '132',
    '莱': '131', '赖': '136', '濑': '137', '兰州': '14', '岚': '146', '蓝': '144', '澜': '147', '篮': '145', '览': '151',
    '懒': '152', '烂': '155', '滥': '156', '啷': '161', '郎': '162', '狼': '163', '廊': '164', '朗': '166', '浪': '168',
    '捞': '171', '劳': '181', '劳动部': '18', '牢': '182', '老': '185', '涝': '188', '酪': '187', '乐': '726', '了': '452',
    '勒': '211', '垒': '223', '磊': '221', '蕾': '222', '肋': '226', '类': '225', '累': '215', '冷': '231', '狸': '248',
    '离': '245', '梨': '244', '犁': '246', '漓': '247', '礼': '283', '里': '281', '理': '282', '醴': '284', '力': '295',
    '历': '297', '厉': '298', '立': '296', '丽': '311', '励': '317', '沥': '299', '枥': '319', '郦': '314', '莉': '312',
    '栗': '294', '笠': '316', '粒': '318', '痢': '315', '俩': '327', '连': '331', '莲': '335', '联': '332', '廉': '333',
    '镰': '334', '脸': '344', '练': '346', '炼': '345', '恋': '349', '链': '347', '良': '386', '凉': '385', '粮': '381',
    '粱': '387', '两': '393', '亮': '397', '谅': '396', '量': '395', '撩': '411', '辽': '441', '聊': '442', '嘹': '443',
    '竂': '453', '蓼': '451', '料': '456', '廖': '455', '列宁': '3', '烈': '477', '猎': '479', '裂': '478', '拎': '621',
    '临': '594', '琳': '595', '磷': '596', '麟': '597', '凛': '614', '吝': '617', '蔺': '616', '灵': '627', '泠': '629',
    '铃': '626', '零': '628', '岭': '642', '领': '641', '令': '645', '令狐': '646', '溜': '651', '浏': '665', '留': '662',
    '流': '663', '琉': '664', '柳': '671', '六': '674', '龙': '681', '泷': '683', '聋': '684', '隆': '682', '陇': '691',
    '垄': '692', '娄': '714', '蒌': '718', '楼': '715', '搂': '711', '漏': '722', '噜': '731', '芦': '736', '庐': '738',
    '炉': '737', '卤': '747', '鹿': '762', '逯': '759', '禄': '761', '碌': '766', '潞': '767', '璐': '764', '麓': '765',
    '露': '763', '栾': '771', '滦': '772', '卵': '776', '乱': '778', '抡': '781', '仑': '784', '伦': '783', '轮': '785',
    '论': '786', '逻': '799', '螺': '811', '裸': '815', '落': '824', '雒': '825', '驴': '831', '闾': '832', '侣': '838',
    '捋': '791', '旅': '836', '屡': '837', '律': '844', '绿': '845', '氯': '846', '掠': '853', '略': '855', '妈': '121',
    '麻': '123', '马克思': '1', '玛': '131', '码': '132', '蚂': '136', '骂': '135', '埋': '141', '买': '143', '迈': '148',
    '脉': '149', '颟': '161', '蛮': '162', '馒': '164', '瞒': '163', '满': '165', '曼': '167', '漫': '168', '慢': '169',
    '芒': '174', '忙': '173', '莽': '178', '猫': '191', '毛泽东': '5', '矛': '196', '茆': '197', '茅': '195', '卯': '211',
    '峁': '212', '茂': '213', '冒': '217', '贸': '214', '貌': '215', '么': '218', '眉': '226', '煤': '221', '煤炭工业部': '22',
    '酶': '225', '每': '234', '抺': '388', '妹': '236', '媚': '237', '魅': '239', '门': '244', '闷': '243', '焖': '247',
    '萌': '255', '蒙': '261', '盟': '254', '猛': '262', '梦': '268', '眯': '272', '弥': '274', '迷': '276', '糜': '275',
    '弭': '284', '泌': '293', '秘': '294', '密': '291', '蜜': '292', '眠': '312', '绵': '313', '棉': '311', '免': '317',
    '沔': '318', '勉': '315', '缅': '316', '面': '324', '喵': '329', '苗': '331', '描': '332', '渺': '335', '邈': '336',
    '妙': '342', '乜': '340', '灭': '345', '蔑': '346', '民': '351', '岷': '352', '闵': '355', '闽': '357', '敏': '356',
    '名': '362', '明': '361', '鸣': '364', '茗': '792', '铭': '363', '酩': '368', '命': '369', '谬': '371', '摸': '381',
    '模': '421', '摩': '384', '磨': '385', '魔': '386', '末': '397', '茉': '396', '墨': '394', '默': '395', '牟': '411',
    '谋': '412', '缪': '341', '某': '415', '母': '424', '牡': '426', '亩': '425', '姆': '423', '木': '436', '目': '439',
    '沐': '441', '牧': '437', '幕': '438', '慕': '434', '慕容': '435', '拿': '114', '哪': '116', '呐': '125', '娜': '124',
    '乃': '132', '奶': '131', '奈': '135', '耐': '134', '南': '221', '南昌': '14', '南宁': '22', '难': '229', '楠': '223',
    '赧': '226', '囊': '231', '孬': '241', '挠': '153', '铙': '243', '恼': '246', '脑': '245', '瑙': '247', '闹': '248',
    '讷': '251', '馁': '257', '内': '271', '内蒙': '26', '内务部': '27', '嫩': '549', '能': '275', '妮': '288', '泥': '287',
    '拟': '294', '你': '293', '逆': '298', '匿': '297', '溺': '296', '拈': '311', '年': '313', '捻': '317', '碾': '316',
    '念': '321', '娘': '323', '酿': '325', '鸟': '327', '尿': '329', '捏': '333', '您': '346', '宁': '351', '宁夏': '35',
    '拧': '355', '凝': '352', '佞': '357', '纽': '366', '钮': '365', '弄': '695', '奴': '541', '努': '544', '怒': '546',
    '暖': '547', '虐': '566', '挪': '551', '懦': '556', '女': '561', '沤': '126', '欧': '113', '欧阳': '114', '偶': '121',
    '藕': '122', '葩': '111', '爬': '114', '琶': '113', '帕': '117', '怕': '118', '拍': '121', '排': '122', '牌': '123',
    '派': '127', '攀': '135', '盘': '141', '磐': '142', '判': '146', '泮': '147', '盼': '145', '滂': '161', '逄': '166',
    '胖': '172', '抛': '173', '刨': '174', '跑': '178', '泡': '181', '炮': '182', '胚': '192', '陪': '198', '培': '197',
    '沛': '222', '佩': '221', '配': '223', '喷': '227', '盆': '228', '烹': '232', '朋': '238', '蓬': '242', '鹏': '241',
    '澎': '231', '膨': '239', '捧': '247', '碰': '248', '丕': '253', '批': '251', '邳': '254', '坯': '191', '披': '252',
    '劈': '282', '皮': '261', '枇': '263', '毗': '264', '琵': '262', '匹': '281', '辟': '286', '僻': '287', '偏': '292',
    '篇': '291', '胼': '296', '谝': '311', '片': '313', '骗': '314', '瓢': '325', '票': '331', '僄': '313', '漂': '328',
    '撇': '336', '拼': '241', '贫': '343', '频': '345', '品': '351', '聘': '354', '乒': '361', '平': '363', '评': '364',
    '坪': '368', '苹': '365', '屏': '367', '萍': '366', '蘋': '344', '坡': '371', '泼': '372', '婆': '375', '鄱': '376',
    '叵': '381', '迫': '384', '珀': '628', '破': '383', '粕': '387', '魄': '385', '剖': '391', '抔': '393', '掊': '395',
    '扑': '411', '葡': '422', '蒲': '421', '璞': '425', '濮': '423', '朴': '434', '浦': '435', '普通': '43', '溥': '436',
    '铺': '412', '瀑': '424', '曝': '444', '七': '113', '妻': '117', '栖': '116', '戚': '112', '期': '114', '欺': '115',
    '漆': '111', '亓': '134', '祁': '124', '岐': '127', '其': '125', '奇': '126', '淇': '135', '骑': '129', '琦': '133',
    '綦': '132', '旗': '128', '蕲': '131', '乞': '145', '岂': '144', '企': '143', '启': '142', '起': '141', '气': '154',
    '弃': '157', '汽': '153', '契': '155', '砌': '158', '槭': '159', '器': '156', '掐': '171', '拤': '172', '洽': '176',
    '恰': '175', '髂': '128', '千': '182', '芊': '186', '迁': '184', '牵': '185', '铅': '183', '谦': '181', '前': '194',
    '钳': '196', '乾': '195', '潜': '197', '黔': '198', '浅': '216', '遣': '217', '欠': '221', '倩': '223', '歉': '222',
    '羌': '232', '枪': '231', '腔': '233', '强': '237', '蔷': '238', '抢': '245', '炝': '248', '悄': '251', '敲': '252',
    '荞': '268', '桥': '264', '谯': '265', '樵': '266', '巧': '273', '峭': '276', '翘': '267', '茄': '288', '且': '289',
    '郄': '293', '怯': '291', '窃': '277', '惬': '292', '钦': '312', '侵': '313', '亲': '311', '芹': '328', '琴': '325',
    '禽': '327', '勤': '326', '寝': '335', '沁': '336', '青': '391', '轻': '361', '卿': '393', '清': '392', '情': '412',
    '晴': '411', '顷': '417', '请': '416', '庆': '421', '磬': '422', '罄': '423', '邛': '435', '穷': '433', '琼': '434',
    '丘': '444', '秋': '445', '萩': '446', '求': '455', '酋': '457', '球': '456', '区': '463', '曲': '461', '驱': '465',
    '屈': '462', '趋': '464', '渠': '472', '瞿': '471', '蘧': '473', '衢': '474', '取': '481', '去': '485', '趣': '486',
    '圈': '491', '权': '562', '全': '561', '泉': '563', '拳': '564', '犬': '571', '劝': '574', '券': '575', '缺': '581',
    '阙': '582', '瘸': '583', '却': '585', '雀': '586', '确': '584', '逡': '595', '裙': '632', '群': '631', '然': '132',
    '燃': '131', '冉': '135', '染': '136', '壤': '143', '攘': '141', '让': '145', '饶': '151', '桡': '242', '绕': '154',
    '惹': '156', '热': '158', '人': '221', '壬': '226', '仁': '225', '忍': '231', '稔': '232', '认': '234', '韧': '236',
    '妊': '235', '扔': '241', '仍': '243', '戎': '253', '肜': '257', '茸': '265', '荣': '252', '绒': '256', '容': '251',
    '溶': '255', '融': '254', '冗': '264', '柔': '271', '肉': '277', '宍': '272', '如': '284', '儒': '285', '汝': '291',
    '乳': '292', '辱': '293', '入': '296', '溽': '297', '阮': '311', '软': '312', '蕤': '316', '蕊': '317', '芮': '322',
    '锐': '323', '瑞': '321', '睿': '324', '闰': '332', '润': '331', '若': '337', '弱': '336', '箬': '338', '撒': '101',
    '洒': '103', '腮': '114', '赛': '117', '三': '121', '伞': '123', '散': '125', '桑': '126', '嗓': '128', '丧': '129',
    '骚': '131', '臊': '138', '扫': '134', '色': '192', '涩': '143', '瑟': '142', '森': '171', '僧': '172', '杀': '177',
    '刹': '216', '砂': '178', '莎': '176', '煞': '188', '裟': '181', '啥': '185', '傻': '186', '厦': '295', '筛': '191',
    '晒': '194', '山': '251', '杉': '254', '删': '252', '衫': '253', '闪': '282', '陕': '281', '汕': '286', '扇': '287',
    '善': '285', '滝': '685', '覃': '182', '梶': '254', '喔': '111', '臽': '752', '巷': '227', '行': '511', '芎': '431',
    '柚': '471', '攒': '117', '粘': '216', '长': '272', '长春': '26', '长沙': '27', '重': '769', '商业部': '30', '商': '301',
    '伤': '302', '垧': '307', '上': '421', '烧': '426', '韶': '431', '芍': '432', '少': '434', '邵': '435', '召': '436',
    '绍': '437', '奢': '441', '佘': '443', '舌': '444', '折': '332', '舍': '448', '摄': '451', '社': '452', '射': '453',
    '设': '454', '涉': '456', '申': '461', '伸': '462', '深': '463', '身': '464', '棽': '465', '神': '471', '审': '534',
    '慎': '538', '甚': '539', '渗': '541', '肾': '542', '生': '545', '声': '546', '升': '547', '笙': '548', '枡': '549',
    '绳': '551', '省': '552', '胜': '557', '圣': '558', '剩': '558', '师': '567', '失': '568', '诗': '569', '湿': '571',
    '石家庄': '58', '石油化学工业部': '59', '什': '594', '时': '595', '十': '596', '食': '597', '实': '598', '拾': '599', '辻': '601',
    '识': '602', '使': '609', '始': '611', '室': '612', '矢': '613', '世': '641', '市': '642', '试': '643', '士': '644',
    '式': '645', '适': '646', '势': '647', '柿': '648', '是': '649', '释': '651', '仕': '652', '侍': '653', '匙': '654',
    '视': '656', '收': '657', '熟': '682', '手': '661', '守': '662', '首都': '66', '寿': '664', '兽': '665', '受': '666',
    '首': '667', '瘦': '668', '书': '674', '枢': '675', '疏': '676', '蔬': '677', '菽': '678', '输': '679', '姝': '681',
    '淑': '683', '叔': '684', '暑': '686', '蜀': '687', '黍': '688', '属': '689', '署': '691', '数': '693', '树': '694',
    '术': '695', '束': '696', '恕': '697', '竖': '698', '刷': '706', '衰': '708', '帅': '709', '率': '711', '拴': '713',
    '双': '717', '霜': '718', '爽': '721', '谁': '722', '水产部': '73', '水': '791', '税': '795', '睡': '796', '顺': '801',
    '舜': '802', '说': '805', '塑': '929', '硕': '807', '铄': '808', '司': '827', '司马': '828', '司徒': '829', '思': '831',
    '丝': '832', '私': '833', '死': '839', '四': '861', '寺': '862', '汜': '863', '饲': '864', '似': '865', '姒': '866',
    '松': '871', '嵩': '872', '悚': '876', '耸': '877', '送': '884', '颂': '885', '搜': '891', '嗽': '892', '酥': '924',
    '俗': '926', '宿': '927', '素': '928', '肃': '931', '粟': '932', '速': '933', '酸': '941', '痠': '942', '算': '944',
    '蒜': '945', '虽': '946', '睢': '947', '眭': '948', '隋': '951', '绥': '952', '遂': '953', '随': '954', '髓': '955',
    '岁': '956', '碎': '957', '穗': '958', '隧': '959', '燧': '961', '荪': '973', '损': '976', '笋': '977', '梭': '981',
    '缩': '982', '锁': '994', '蓑': '995', '所': '996', '他': '111', '她': '112', '它': '113', '踏': '114', '沓': '127',
    '榻': '128', '胎': '135', '台北': '14', '台湾': '15', '台': '151', '抬': '152', '邰': '153', '太原': '16', '太': '161',
    '泰': '162', '态': '163', '钛': '164', '贪': '171', '谈': '181', '檀': '183', '澹': '185', '坦': '191', '毯': '192',
    '探': '196', '炭': '197', '碳': '198', '堂': '218', '棠': '219', '糖': '221', '倘': '226', '躺': '227', '烫': '231',
    '涛': '234', '韬': '235', '桃': '244', '洮': '245', '淘': '246', '逃': '247', '梼': '248', '讨': '251', '套': '252',
    '藤': '264', '腾': '265', '梯': '271', '剔': '272', '提': '276', '题': '277', '荑': '278', '体': '28', '倜': '351',
    '惕': '352', '逖': '353', '天': '451', '添': '452', '填': '457', '恬': '458', '甜': '459', '舔': '465', '掭': '469',
    '挑': '481', '条': '474', '窕': '482', '眺': '484', '跳': '485', '贴': '491', '帖': '492', '铁': '531', '萜': '533',
    '听': '535', '厅': '536', '烃': '537', '亭': '541', '廷': '542', '庭': '543', '挺': '547', '通': '551', '同': '553',
    '童': '554', '佟': '555', '桐': '556', '铜': '557', '彤': '558', '仝': '559', '统': '566', '筒': '567', '痛': '571',
    '偷': '575', '头': '576', '投': '577', '透': '579', '突': '581', '凸': '582', '屠': '584', '图': '585', '涂': '586',
    '土': '591', '吐': '592', '兔': '594', '团': '611', '湍': '612', '推': '614', '颓': '615', '腿': '617', '退': '618',
    '蜕': '619', '吞': '621', '屯': '623', '豚': '624', '氽': '626', '脱': '634', '拖': '635', '陀': '637', '驼': '638',
    '妥': '645', '椭': '646', '庹': '647', '拓': '648', '挖': '114', '娃': '118', '祙': '126', '外': '151', '湾': '153',
    '豌': '154', '完': '161', '丸': '162', '玩': '163', '皖': '166', '宛': '167', '晚': '168', '菀': '654', '婉': '171',
    '亡': '221', '往': '222', '网': '223', '望': '228', '旺': '229', '隈': '232', '危': '236', '微': '237', '薇': '238',
    '巍': '239', '围': '242', '唯': '249', '惟': '251', '苇': '253', '伟': '255', '尾': '256', '隗': '257', '委': '258',
    '炜': '259', '猥': '261', '卫': '291', '为': '295', '渭': '296', '蔚': '297', '慰': '298', '尉': '299', '味': '301',
    '未': '302', '位': '303', '闻': '344', '雯': '345', '纹': '346', '稳': '351', '紊': '352', '问': '355', '汶': '356',
    '翁': '361', '瓮': '362', '窝': '365', '涡': '366', '倭': '367', '我': '369', '握': '375', '卧': '376', '渥': '377',
    '乌鲁木齐': '38', '巫': '384', '邬': '385', '屋': '386', '无': '411', '梧': '412', '毋': '413', '吾': '414', '伍': '444',
    '五': '445', '午': '446', '舞': '447', '仵': '448', '妩': '449', '物资管理部': '46', '物': '461', '务': '462', '悟': '463',
    '误': '464', '雾': '465', '西宁': '21', '西藏': '22', '西': '221', '奚': '225', '昔': '226', '郗': '227', '茜': '228',
    '玺': '229', '息': '231', '稀': '232', '犀': '233', '惜': '234', '晞': '235', '牺': '236', '夕': '237', '嘻': '238',
    '习': '248', '锡': '249', '袭': '250', '喜': '256', '铣': '257', '洗': '331', '徙': '259', '细': '267', '戏': '268',
    '矽': '269', '系': '266', '虾': '276', '侠': '281', '霞': '282', '暇': '283', '狭': '284', '夏候': '294', '下': '296',
    '先': '311', '鲜': '312', '纤': '313', '仙': '314', '贤': '321', '咸': '322', '闲': '323', '弦': '324', '显': '332',
    '险': '333', '现': '338', '献': '339', '宪': '341', '线': '342', '限': '343', '县': '344', '湘': '351', '襄': '352',
    '乡': '353', '香': '354', '祥': '361', '详': '362', '翔': '363', '想': '366', '响': '367', '享': '368', '向': '373',
    '项': '374', '相': '375', '橡': '376', '象': '377', '消': '384', '霄': '385', '潇': '386', '销': '387', '淆': '391',
    '小': '394', '晓': '396', '笑': '414', '孝': '415', '歇': '421', '楱': '422', '协': '425', '斜': '426', '谐': '427',
    '写': '433', '泄': '443', '心': '477', '欣': '478', '忻': '479', '鑫': '480', '昕': '481', '馨': '482', '寻': '646',
    '信': '484', '芯': '485', '炘': '486', '兴': '491', '星': '492', '形': '499', '荥': '512', '刑': '513', '醒': '517',
    '幸': '518', '性': '519', '杏': '521', '兄': '525', '匈': '526', '凶': '527', '雄': '534', '修': '541', '休': '542',
    '羞': '543', '朽': '547', '秀': '548', '袖': '549', '胥': '554', '虚': '555', '须': '556', '顼': '557', '煦': '574',
    '栩': '575', '绪': '582', '旭': '583', '叙': '584', '絮': '585', '序': '586', '续': '587', '宣': '591', '轩': '592',
    '玄': '596', '旋': '597', '选': '611', '渲': '614', '炫': '615', '削': '624', '学': '627', '穴': '628', '雪': '631',
    '血': '633', '勋': '635', '熏': '636', '荀': '641', '恂': '642', '驯': '643', '旬': '644', '郇': '645', '循': '647',
    '训': '651', '逊': '652', '汛': '653', '巽': '654', '迅': '655', '鸭': '111', '压': '112', '牙': '115', '涯': '116',
    '芽': '117', '氩': '124', '痖': '125', '亚': '151', '讶': '152', '燕': '196', '烟': '156', '鄢': '157', '湮': '158',
    '焉': '159', '姻': '161', '淹': '162', '延': '168', '阎': '169', '闫': '169', '颜': '171', '言': '172', '盐': '173',
    '岩': '174', '沿': '175', '研': '176', '炎': '177', '眼': '181', '演': '182', '兗': '183', '郾': '184', '偃': '185',
    '掩': '186', '晏': '191', '雁': '192', '砚': '193', '彦': '194', '艳': '195', '央': '214', '秧': '215', '阳': '231',
    '羊': '232', '扬': '233', '养': '241', '氧': '242', '仰': '243', '样': '245', '怏': '246', '腰': '251', '幺': '277',
    '要': '276', '尧': '259', '遥': '261', '瑶': '262', '窑': '263', '咬': '271', '药': '274', '耀': '275', '椰': '284',
    '琊': '287', '爷': '288', '冶': '321', '野': '322', '夜': '328', '业': '329', '液': '331', '也': '332', '烨': '333',
    '衣': '347', '医': '349', '漪': '351', '宜': '361', '益': '395', '沂': '363', '怡': '364', '疑': '365', '移': '366',
    '仪': '367', '遗': '368', '颐': '369', '贻': '370', '懿': '371', '以': '377', '已': '378', '倚': '379', '乙': '381',
    '蚁': '382', '裔': '385', '易': '386', '意': '387', '毅': '388', '艺': '389', '义': '391', '羿': '392', '刈': '393',
    '异': '394', '逸': '396', '翼': '397', '忆': '398', '佚': '399', '奕': '401', '谊': '402', '亦': '403', '礒': '404',
    '亿': '405', '翊': '406', '浥': '407', '弋': '408', '音': '421', '因': '422', '阴': '423', '茵': '424', '银川': '43',
    '银': '431', '寅': '432', '吟': '433', '引': '444', '隐': '445', '饮': '446', '印': '451', '荫': '452', '英': '464',
    '樱': '465', '莺': '466', '鹰': '467', '瑛': '468', '萦': '474', '迎': '475', '营': '476', '莹': '477', '盈': '478',
    '赢': '479', '影': '491', '颖': '492', '硬': '496', '映': '497', '拥': '511', '庸': '512', '雍': '513', '顒': '521',
    '永': '523', '勇': '524', '咏': '525', '用': '531', '优': '533', '攸': '534', '幽': '534', '邮电部': '54', '邮': '541',
    '游': '545', '由': '546', '油': '547', '铀': '548', '猷': '549', '友': '561', '有': '562', '酉': '563', '佑': '571',
    '幼': '572', '诱': '573', '右': '574', '宥': '575', '迂': '583', '於': '584', '虞': '595', '渝': '596', '榆': '597',
    '鱼': '599', '愚': '611', '瑜': '612', '舆': '613', '渔': '614', '隅': '615', '禹': '621', '雨': '622', '语': '623',
    '宇': '624', '与': '626', '羽': '627', '予': '628', '庾': '629', '玉': '637', '裕': '638', '喻': '639', '豫': '641',
    '峪': '643', '欲': '644', '郁': '645', '愈': '646', '御': '647', '遇': '648', '驭': '649', '预': '651', '毓': '652',
    '堉': '653', '昱': '655', '誉': '656', '域': '657', '渊': '671', '鸳': '672', '原': '681', '元': '682', '援': '683',
    '园': '684', '圆': '685', '源': '686', '垣': '687', '猿': '688', '远': '698', '愿': '711', '苑': '712', '院': '713',
    '怨': '714', '曰': '724', '岳': '725', '越': '727', '月': '728', '悦': '729', '跃': '731', '粤': '732', '缊': '741',
    '晕': '742', '云': '771', '芸': '772', '耘': '773', '筠': '774', '郧': '775', '允': '781', '陨': '782', '恽': '791',
    '运': '792', '员': '793', '贠': '793', '酝': '794', '蕴': '795', '韵': '796', '': '101', '杂': '103', '栽': '105',
    '灾': '106', '宰': '107', '载': '108', '再': '111', '在': '112', '簪': '114', '咱': '116', '昝': '118', '暂': '121',
    '赞': '122', '臧': '125', '脏': '126', '葬': '128', '糟': '132', '凿': '134', '早': '135', '枣': '136', '藻': '137',
    '造': '141', '灶': '142', '燥': '143', '择': '146', '责': '147', '则': '148', '泽': '149', '仄': '153', '贼': '155',
    '怎': '156', '增': '161', '憎': '162', '赠': '166', '札': '184', '轧': '185', '眨': '191', '炸': '194', '榨': '195',
    '乍': '196', '柞': '197', '斋': '201', '摘': '202', '翟': '203', '宅': '204', '窄': '206', '祭': '207', '债': '208',
    '寨': '209', '占': '217', '展': '223', '崭': '224', '战': '227', '湛': '228', '站': '229', '栈': '231', '樟': '264',
    '彰': '265', '漳': '266', '掌': '271', '仉': '273', '苌': '274', '丈': '276', '仗': '277', '障': '278', '涨': '279',
    '昭': '286', '招': '287', '钊': '288', '着': '291', '找': '292', '爪': '293', '沼': '294', '照': '321', '肇': '322',
    '兆': '323', '遮': '328', '哲': '331', '辄': '333', '者': '337', '锗': '338', '浙': '361', '柘': '362', '这': '363',
    '甄': '367', '真': '368', '珍': '369', '贞': '371', '臻': '372', '祯': '373', '箴': '374', '针': '375', '榛': '376',
    '诊': '383', '枕': '384', '镇': '391', '掁': '392', '震': '393', '阵': '394', '争': '401', '蒸': '402', '征': '403',
    '峥': '404', '铮': '405', '整': '414', '拯': '415', '郑洲': '42', '正': '424', '政': '425', '证': '426', '支': '431',
    '芝': '432', '知': '433', '汁': '434', '脂': '435', '枝': '436', '之': '437', '蜘': '438', '吱': '441', '织': '439',
    '植': '445', '直': '446', '殖': '447', '跖': '448', '职': '449', '执': '451', '止': '457', '芷': '458', '纸': '459',
    '旨': '461', '指': '462', '只': '463', '质': '471', '志': '472', '制': '473', '致': '474', '至': '475', '稚': '476',
    '治': '477', '智': '478', '郅': '479', '陟': '481', '中华': '74', '中央': '75', '忠': '754', '终': '755', '钟': '756',
    '种': '767', '肿': '763', '冢': '764', '仲': '766', '众': '768', '舟': '778', '州': '779', '盩': '780', '洲': '781',
    '轴': '783', '肘': '785', '昼': '787', '宙': '788', '骤': '789', '诸': '803', '诸葛': '804', '珠': '805', '猪': '806',
    '株': '807', '铢': '808', '邾': '810', '竺': '814', '竹': '815', '逐': '816', '主': '823', '嘱': '824', '渚': '825',
    '祝': '831', '住': '832', '铸': '833', '助': '834', '筑': '835', '注': '836', '抓': '844', '拽': '847', '专': '851',
    '砖': '852', '转': '854', '撰': '857', '篆': '858', '庄': '861', '装': '862', '壮': '866', '状': '867', '追': '871',
    '锥': '872', '惴': '875', '坠': '876', '谆': '881', '准': '883', '拙': '886', '捉': '887', '卓': '888', '茁': '892',
    '酌': '893', '琢': '894', '浊': '895', '资': '904', '尉迟': '642', '宇文': '625', '一': '348', '壹': '348', '筱': '395',
    '篠': '395', '斯大林': '4', '子': '914', '簌': '934'
}


def fun_spli_name(stri_name):
    surn_name = stri_name
    part = dict_fetc_code.get(surn_name, False)
    while not part:
        surn_name = surn_name[:-1]
        part = dict_fetc_code.get(surn_name, False)
    last_name = stri_name.replace(surn_name, '')
    return surn_name, last_name


def fun_take_code(famy_name, last_porn):
    part = dict_fetc_code.get(famy_name, False)
    if type(part) == dict:
        code = part[last_porn]
    else:
        code = part
    return code
