"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const integration_1 = require("./integration");
const route_1 = require("./route");
/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.webSocketApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_c = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _c !== void 0 ? _c : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * @internal
     */
    _addIntegration(scope, config) {
        const { configHash, integration: existingIntegration } = this._integrationCache.getIntegration(scope, config);
        if (existingIntegration) {
            return existingIntegration;
        }
        const integration = new integration_1.WebSocketIntegration(scope, `WebSocketIntegration-${configHash}`, {
            webSocketApi: this,
            integrationType: config.type,
            integrationUri: config.uri,
        });
        this._integrationCache.saveIntegration(scope, config, integration);
        return integration;
    }
    /**
     * (experimental) Add a new route.
     *
     * @experimental
     */
    addRoute(routeKey, options) {
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApi", version: "2.0.0-alpha.6" };
//# sourceMappingURL=data:application/json;base64,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