"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterMapping = exports.MappingValue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
;
/**
 * (experimental) Represents a Mapping Value.
 *
 * @experimental
 */
class MappingValue {
    /**
     * @experimental
     */
    constructor(value) {
        this.value = value;
    }
    /**
     * (experimental) Creates a header mapping value.
     *
     * @experimental
     */
    static requestHeader(name) { return new MappingValue(`$request.header.${name}`); }
    /**
     * (experimental) Creates a query string mapping value.
     *
     * @experimental
     */
    static requestQueryString(name) { return new MappingValue(`$request.querystring.${name}`); }
    /**
     * (experimental) Creates a request body mapping value.
     *
     * @experimental
     */
    static requestBody(name) { return new MappingValue(`$request.body.${name}`); }
    /**
     * (experimental) Creates a request path mapping value.
     *
     * @experimental
     */
    static requestPath() { return new MappingValue('$request.path'); }
    /**
     * (experimental) Creates a request path parameter mapping value.
     *
     * @experimental
     */
    static requestPathParam(name) { return new MappingValue(`$request.path.${name}`); }
    /**
     * (experimental) Creates a context variable mapping value.
     *
     * @experimental
     */
    static contextVariable(variableName) { return new MappingValue(`$context.${variableName}`); }
    /**
     * (experimental) Creates a stage variable mapping value.
     *
     * @experimental
     */
    static stageVariable(variableName) { return new MappingValue(`$stageVariables.${variableName}`); }
    /**
     * (experimental) Creates a custom mapping value.
     *
     * @experimental
     */
    static custom(value) { return new MappingValue(value); }
}
exports.MappingValue = MappingValue;
_a = JSII_RTTI_SYMBOL_1;
MappingValue[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.MappingValue", version: "2.0.0-alpha.6" };
/**
 * (experimental) Creates an empty mapping value.
 *
 * @experimental
 */
MappingValue.NONE = new MappingValue('');
/**
 * (experimental) Represents a Parameter Mapping.
 *
 * @experimental
 */
class ParameterMapping {
    /**
     * @experimental
     */
    constructor() {
        this.mappings = {};
    }
    /**
     * (experimental) Creates a mapping to append a header.
     *
     * @experimental
     */
    appendHeader(name, value) {
        this.mappings[`append:header.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to overwrite a header.
     *
     * @experimental
     */
    overwriteHeader(name, value) {
        this.mappings[`overwrite:header.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to remove a header.
     *
     * @experimental
     */
    removeHeader(name) {
        this.mappings[`remove:header.${name}`] = '';
        return this;
    }
    /**
     * (experimental) Creates a mapping to append a query string.
     *
     * @experimental
     */
    appendQueryString(name, value) {
        this.mappings[`append:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to overwrite a querystring.
     *
     * @experimental
     */
    overwriteQueryString(name, value) {
        this.mappings[`overwrite:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to remove a querystring.
     *
     * @experimental
     */
    removeQueryString(name) {
        this.mappings[`remove:querystring.${name}`] = '';
        return this;
    }
    /**
     * (experimental) Creates a mapping to overwrite a path.
     *
     * @experimental
     */
    overwritePath(value) {
        this.mappings['overwrite:path'] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a custom mapping.
     *
     * @experimental
     */
    custom(key, value) {
        this.mappings[key] = value;
        return this;
    }
}
exports.ParameterMapping = ParameterMapping;
_b = JSII_RTTI_SYMBOL_1;
ParameterMapping[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ParameterMapping", version: "2.0.0-alpha.6" };
//# sourceMappingURL=data:application/json;base64,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