"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["ANY"] = "ANY";
    HttpMethod["DELETE"] = "DELETE";
    HttpMethod["GET"] = "GET";
    HttpMethod["HEAD"] = "HEAD";
    HttpMethod["OPTIONS"] = "OPTIONS";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
class HttpRouteKey {
    constructor(key, path) {
        this.key = key;
        this.path = path;
    }
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path, method) {
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('A route path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(`${method !== null && method !== void 0 ? method : HttpMethod.ANY} ${path}`, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteKey", version: "2.0.0-alpha.6" };
/**
 * (experimental) The catch-all route of the API, i.e., when no other routes match.
 *
 * @experimental
 */
HttpRouteKey.DEFAULT = new HttpRouteKey('$default');
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        const config = props.integration.bind({
            route: this,
            scope: this,
        });
        const integration = props.httpApi._addIntegration(this, config);
        const authBindResult = props.authorizer ? props.authorizer.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        }) : undefined;
        if (authBindResult && !(authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error('authorizationType should either be JWT, CUSTOM, or NONE');
        }
        let authorizationScopes = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationScopes;
        if (authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${integration.integrationId}`,
            authorizerId: authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizerId,
            authorizationType: (_c = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationType) !== null && _c !== void 0 ? _c : 'NONE',
            authorizationScopes,
        };
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRoute", version: "2.0.0-alpha.6" };
//# sourceMappingURL=data:application/json;base64,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