# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ogscm', 'ogscm.app', 'ogscm.building_blocks', 'ogscm.recipes']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'hpccm>=20.10.0,<21.0.0',
 'packaging>=20.4,<21.0',
 'requests>=2.24.0,<3.0.0']

entry_points = \
{'console_scripts': ['ogscm = ogscm.cli:main']}

setup_kwargs = {
    'name': 'ogscm',
    'version': '2.0.1',
    'description': 'OGS Container Maker',
    'long_description': "# OGS Container Maker\n\n[![PyPI version](https://badge.fury.io/py/ogscm.svg)](https://badge.fury.io/py/ogscm)\n\n## General usage\n\n### Installation\n\n```bash\nvirtualenv ~/.venv/ogs-container-maker\nsource ~/.venv/ogs-container-maker/bin/activate\npip install ogscm\n```\n\n### Generate container definition\n\nOGS Container Maker has builtin recipes. You need to specify the recipes to use as command arguments. Each of recipes adds options to the tool. Typically you want to start with a compiler. Add the `compiler.py` recipe and the `--help`-flag to get more options:\n\n```bash\n$ ogscm compiler.py --help\n...\ncompiler.py:\n  --compiler COMPILER   The compiler to use. Possible options: off, gcc,\n                        clang (default: gcc)\n  --compiler_version COMPILER_VERSION\n                        Compiler version. (default: )\n  --iwyy                Install include-what-you-use (requires clang\n                        compiler) (default: False)\n```\n\nAfter specifying the compiler recipe (and optionally setting a non-default compiler and version) you may want to add the `ogs.py` recipe:\n\n```bash\n$ ogscm compiler.py ogs.py --help\n...\nogs.py:\n  --pm {system,conan,off}\n                        Package manager to install third-party dependencies\n                        (default: conan)\n  --ogs OGS             OGS repo on gitlab.opengeosys.org in the form\n                        'user/repo@branch' OR 'user/repo@@commit' to\n                        checkout a specific commit OR a path to a local\n                        subdirectory to the git cloned OGS sources OR 'off'\n                        to disable OGS building OR 'clean' to disable OGS\n                        and all its dev dependencies (default:\n                        ogs/ogs@master)\n  --cmake_args CMAKE_ARGS\n                        CMake argument set has to be quoted and **must**\n                        start with a space. e.g. --cmake_args '\n                        -DFIRST=TRUE -DFOO=BAR' (default: )\n...\n```\n\nTo generate a Dockerfile with the default parameters:\n\n```bash\n$ ogscm compiler.py ogs.py\nEvaluating compiler.py\nEvaluating ogs.py\nCreated definition _out/docker/gcc/default/ogs-d18c786e/conan/Dockerfile\n```\n\nWith some options (and the `mpi.py`-recipe):\n\n```bash\n$ ogscm compiler.py mpi.py ogs.py --base_image 'centos:8' --ompi 4.0.5 --cmake_args ' -DOGS_BUILD_PROCESSES=LiquidFlow'\nEvaluating compiler.py\nEvaluating mpi.py\nEvaluating ogs.py\nCreated definition _out/docker/gcc/10/openmpi/4.0.5/ogs-d18c786e/conan/cmake-702517b3/Dockerfile\n```\n\n### Build image\n\nAdd the `--build`-flag.\n\nConvert Docker image to Singularity image:\n\nAdd the `--convert`-flag (requires Singularity 3.x).\n\n### Run\n\n```bash\ndocker run --it --rm ogs-ompi-2.1.3\n# in container:\nogs --version\n```\n\n```bash\nsingularity shell ogs-ompi-2.1.3.sif\n# in container:\nogs --version\n# OR directly run from host\nsingularity exec ogs-ompi-2.1.3.sif ogs local/path/to/square_1e0.prj\n```\n\n## All options\n\nAll options for current builtin recipes:\n\n```\n$ ogscm compiler.py mpi.py ogs.py --base_image 'centos:8' --help\nEvaluating compiler.py\nEvaluating mpi.py\nEvaluating ogs.py\nusage: ogscm [-h] [--version] [--out OUT] [--file FILE] [--sif_file SIF_FILE] [--print] [--format {docker,singularity}]\n             [--base_image BASE_IMAGE] [--build] [--build_args BUILD_ARGS] [--upload] [--registry REGISTRY] [--tag TAG]\n             [--convert] [--runtime-only] [--clean] [--deploy [DEPLOY]] [--pip [package [package ...]]]\n             [--packages [packages [packages ...]]] [--compiler COMPILER] [--compiler_version COMPILER_VERSION]\n             [--iwyy] [--ompi OMPI] [--mpi_benchmarks] [--pm {system,conan,off}] [--ogs OGS] [--cmake_args CMAKE_ARGS]\n             [--ccache] [--parallel PARALLEL] [--gui] [--docs] [--cvode] [--cppcheck] [--gcovr] [--tfel] [--insitu]\n             [--dev]\n             recipe [recipe ...]\n\npositional arguments:\n  recipe\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --version             show program's version number and exit\n  --out OUT             Output directory (default: _out)\n  --file FILE           Overwrite output recipe file name (default: )\n  --sif_file SIF_FILE   Overwrite output singularity image file name (default: )\n  --print, -P           Print the definition to stdout (default: False)\n\nGeneral image config:\n  --format {docker,singularity}\n  --base_image BASE_IMAGE\n                        The base image. (centos:8 is supported too) (default: ubuntu:20.04)\n\nImage build options:\n  --build, -B           Build the images from the definition files (default: False)\n  --build_args BUILD_ARGS\n                        Arguments to the build command. Have to be quoted and **must** start with a space. E.g.\n                        --build_args ' --no-cache' (default: )\n  --upload, -U          Upload Docker image to registry (default: False)\n  --registry REGISTRY   The docker registry the image is tagged and uploaded to. (default:\n                        registry.opengeosys.org/ogs/ogs)\n  --tag TAG             The full docker image tag. Overwrites --registry. (default: )\n  --convert, -C         Convert Docker image to Singularity image (default: False)\n  --runtime-only, -R    Generate multi-stage Dockerfiles for small runtime images (default: False)\n\nMaintenance:\n  --clean               Cleans up generated files in default directories. (default: False)\n\nImage deployment:\n  --deploy [DEPLOY], -D [DEPLOY]\n                        Deploys to all configured hosts (in config/deploy_hosts.yml) with no additional arguments or to\n                        the specified host. Implies --build and --convert arguments. (default: )\n\nPackages to install:\n  --pip [package [package ...]]\n                        Install additional Python packages (default: [])\n  --packages [packages [packages ...]]\n                        Install additional OS packages (default: [])\n\ncompiler.py:\n  --compiler COMPILER   The compiler to use. Possible options: off, gcc, clang (default: gcc)\n  --compiler_version COMPILER_VERSION\n                        Compiler version. (default: )\n  --iwyy                Install include-what-you-use (requires clang compiler) (default: False)\n\nmpi.py:\n  --ompi OMPI           OpenMPI version, e.g. 2.1.1, 2.1.5, 3.0.1, 3.1.2 (default: 4.0.5)\n  --mpi_benchmarks      Installs OSU MPI benchmarks as scif app and mpi_bw, mpi_ring,mpi_hello (default: False)\n\nogs.py:\n  --pm {system,conan,off}\n                        Package manager to install third-party dependencies (default: conan)\n  --ogs OGS             OGS repo on gitlab.opengeosys.org in the form 'user/repo@branch' OR 'user/repo@@commit' to\n                        checkout a specific commit OR a path to a local subdirectory to the git cloned OGS sources OR\n                        'off' to disable OGS building OR 'clean' to disable OGS and all its dev dependencies (default:\n                        ogs/ogs@master)\n  --cmake_args CMAKE_ARGS\n                        CMake argument set has to be quoted and **must** start with a space. e.g. --cmake_args '\n                        -DFIRST=TRUE -DFOO=BAR' (default: )\n  --ccache              Enables ccache build caching. (default: False)\n  --parallel PARALLEL, -j PARALLEL\n                        The number of cores to use for compilation. (default: 4)\n  --gui                 Builds the GUI (Data Explorer) (default: False)\n  --docs                Setup documentation requirements (Doxygen) (default: False)\n  --cvode               Install and configure with cvode (default: False)\n  --cppcheck            Install cppcheck (default: False)\n  --gcovr               Install gcovr (default: False)\n  --tfel                Install tfel (default: False)\n  --insitu              Builds with insitu capabilities (default: False)\n  --dev                 Installs development tools (vim, gdb) (default: False)\n```\n\n## Advanced usage\n\n### Build OGS from local git repo\n\nYou can use the ogs-container-maker to build multiple container images from your current source code at once. The following commands will build (`-B`-parameter) 4 docker container (using one serial and 3 MPI-enabled configurations), convert them to Singularity image files (`-C`) and strip everything out but the runtime-requirements (`-R`). You can find the images in `_out/images`.\n\n```\nvirtualenv .venv\nsource .venv/bin/activate\npip install ogscm\nogscm compiler.py ogs.py -B -C -R --ogs [path to ogs sources] --pm system\n```\n\n### Deploy image files\n\n- Requires `rsync`\n- Rename the file `config/deploy_hosts_example.yml` to `config/deploy_hosts.yml`\n- `host` has to be a SSH host to which you have passwordless access\n- Deploy to the host with `... -D myhost`\n\n\n## PyPi Publication\n\n- Bump version in `pyproject.py` and `version.py`\n- Create tag\n- Push to GitLab (`git push --tags`)\n",
    'author': 'Lars Bilke',
    'author_email': 'lars.bilke@ufz.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.opengeosys.org/ogs/container-maker',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
