from core.streams import StreamClient

import cv2
import time
import asyncio
from core.clients import RealTimeClient
from core.clients import Service


class FaceMaskStreamClient(StreamClient):
	def __init__(self, fps, batch_size, sampling_rate, token):
		self.fps = fps
		self.frames = []
		self.json = ""
		self.syncid = -1
		self.batch_size = batch_size
		self.sampling_rate = sampling_rate
		self.sample_length = int(fps / sampling_rate)
		self.delay_sec = 1 / self.fps
		self.vid = cv2.VideoCapture(0, cv2.CAP_DSHOW)
		self.token = token
		self.client = RealTimeClient(Service.FACE_MASK, self.on_receive, batch_size, self.on_network_status_change, self.token)
		self.response_jsons = []
		self.createTasks()

	async def show_stream(self):
		# on message receive from websocket, we parse json response and show stream using cv2
		while True:
			# print("######################################################show stream")
			if len(self.response_jsons) == 0:
				# if no responses then keep waiting for some message to be received
				print("waiting inside show stream")
				print(len(self.response_jsons))
				await asyncio.sleep(1)
				continue
			# print("#############################  have content  #############################")
			print(len(self.response_jsons))
			# take out one of the response from beginning and apply the result to the frames
			response = self.response_jsons.pop(0)
			# syncid is used to maintain between sent and received frames
			self.syncid = self.syncid + self.batch_size
			syncids = response["sync"]
			if self.syncid != syncids[-1]:
				# if syncid sent and received for a particular response is not same then acheive sync
				print("##########################not in sync:###################################")
				print(self.syncid)
				print(syncids[-1])
				if self.syncid > syncids[-1]:
					# discarding results
					while self.syncid != syncids[-1]:
						syncids = response["sync"]
						self.response_jsons.pop(0)
				else:
					# discarding frames
					while self.syncid != syncids[-1]:
						self.frames.pop()
						self.syncid = self.syncid + 1
				continue
			else:
				# when in sync move further
				print("############### in sync ###########################")
				try:
					for result in response['results']:
						for i in range(self.sample_length):
							frame = self.frames.pop(0)
							start = time.time()
							print("RESSSS",result,type(result))
							if result["has_mask"]  != []:
								color = (0, 255, 0)    #indicates mask is on
								coords = result["has_mask"][0]
								start_point = (coords[0],coords[1])
								end_point = (coords[2],coords[3])
								print("Has mask")
							else:
								color = (0, 0, 255)    #indicates mask is off
								coords = result["has_no_mask"][0]
								start_point = (coords[0],coords[1])
								end_point = (coords[2],coords[3])
								print("Has no mask")
							thickness = 1
							# creating face rectangles using cv2
							cv2.imshow('outputstream', cv2.rectangle(
								frame,
								start_point,
								end_point, color, thickness
							))
							cv2.waitKey(1)  
							time_spent = time.time() - start
							rem_time = max(self.delay_sec - time_spent, 0)
							await asyncio.sleep(rem_time)
				except Exception as e:
					print(e)

