# Generated by Django 3.1.5 on 2021-02-04 01:44

import controlled_vocabulary.models
from django.db import migrations, models
import django.db.models.deletion
import ead.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('controlled_vocabulary', '0004_remove_controlledvocabulary_test'),
    ]

    operations = [
        migrations.CreateModel(
            name='DAOSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('base', models.CharField(blank=True, max_length=128)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('coverage', models.CharField(blank=True, choices=[('part', 'Part'), ('whole', 'Whole')], max_length=5)),
                ('descriptivenote', models.TextField(blank=True)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DIdPhysDescStructured',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('unittype_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('quantity_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('unittype_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('quantity_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('unittype_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('quantity_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('unittype_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('unittype_identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('unittype_rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('unittype_source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('coverage', models.CharField(blank=True, choices=[('part', 'Part'), ('whole', 'Whole')], max_length=5)),
                ('descriptivenote', models.TextField(blank=True)),
                ('physdescstructuredtype', models.CharField(choices=[('carrier', 'Carrier'), ('materialtype', 'Material type'), ('otherphysdescstructuredtype', 'Other'), ('spaceoccupied', 'Space occupied')], max_length=27)),
                ('otherphysdescstructuredtype', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('quantity_approximate', models.BooleanField(blank=True, null=True)),
                ('quantity', models.IntegerField(blank=True, null=True)),
                ('unittype', models.CharField(max_length=64)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EAD',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('control_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('filedesc_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('editionstmt_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('notestmt_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('publicationstmt_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('seriesstmt_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('titlestmt_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('maintenanceagency_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('agencycode_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('maintenanceagency_descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('maintenancehistory_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('maintenancestatus_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('publicationstatus_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('recordid_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('sources_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('archdesc_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('did_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('did_head_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relations_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('control_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('filedesc_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('editionstmt_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('notestmt_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('publicationstmt_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('seriesstmt_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('titlestmt_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('maintenanceagency_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('agencycode_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('maintenanceagency_descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('maintenancehistory_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('maintenancestatus_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('publicationstatus_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('recordid_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('sources_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('archdesc_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('did_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('did_head_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('relations_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('base', models.CharField(blank=True, max_length=128)),
                ('maintenanceagency_countrycode', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('control_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('filedesc_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('editionstmt_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('notestmt_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('publicationstmt_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('seriesstmt_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('titlestmt_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('maintenanceagency_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('agencycode_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('maintenanceagency_descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('maintenancehistory_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('maintenancestatus_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('publicationstatus_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('recordid_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('sources_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('archdesc_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('did_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('relations_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('control_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('filedesc_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('editionstmt_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('notestmt_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('publicationstmt_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('seriesstmt_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('titlestmt_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('maintenanceagency_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('agencycode_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('maintenanceagency_descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('maintenancehistory_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('maintenancestatus_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('publicationstatus_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('recordid_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('sources_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('archdesc_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('did_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('did_head_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('relations_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('agencycode_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('sources_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('archdesc_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('relations_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('relatedencoding', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('editionstmt', models.TextField(blank=True)),
                ('publicationstmt', models.TextField(blank=True)),
                ('seriesstmt', models.TextField(blank=True)),
                ('agencycode', models.CharField(blank=True, max_length=32)),
                ('maintenanceagency_descriptivenote', models.TextField(blank=True)),
                ('maintenancestatus_value', models.CharField(choices=[('revised', 'Revised'), ('deleted', 'Deleted'), ('new', 'New'), ('deletedsplit', 'Deleted split'), ('deletedmerged', 'Deleted merged'), ('deletedreplaced', 'Deleted replaced'), ('cancelled', 'Cancelled'), ('derived', 'Derived')], max_length=15)),
                ('maintenancestatus', models.CharField(blank=True, max_length=64)),
                ('publicationstatus_value', models.CharField(blank=True, choices=[('inprocess', 'In process'), ('approved', 'Approved'), ('published', 'Published')], max_length=9)),
                ('publicationstatus', models.CharField(blank=True, max_length=64)),
                ('recordid_instanceurl', models.CharField(blank=True, max_length=512)),
                ('recordid', models.CharField(max_length=64, unique=True)),
                ('sources_base', models.CharField(blank=True, max_length=128)),
                ('control_base', models.CharField(blank=True, max_length=128)),
                ('control_countryencoding', models.CharField(blank=True, choices=[('iso3166-1', 'ISO 3166-1'), ('othercountryencoding', 'Other Country Encoding')], max_length=20)),
                ('control_dateencoding', models.CharField(blank=True, choices=[('iso8601', 'ISO 8601'), ('otherdateencoding', 'Other Date Encoding')], max_length=17)),
                ('control_langencoding', models.CharField(blank=True, choices=[('iso639-1', 'ISO 639-1'), ('iso639-2b', 'ISO 639-2b'), ('iso639-3', 'ISO 639-3'), ('otherlangencoding', 'Other Language Encoding')], max_length=17)),
                ('control_relatedencoding', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('control_repositoryencoding', models.CharField(blank=True, choices=[('iso15511', 'ISO 15511'), ('otherrepositoryencoding', 'Other Repository Encoding')], max_length=23)),
                ('control_scriptencoding', models.CharField(blank=True, choices=[('iso15924', 'ISO 15924'), ('otherscriptencoding', 'Other Script Encoding')], max_length=19)),
                ('did_head', models.TextField(blank=True)),
                ('did_head_althead', models.CharField(blank=True, max_length=64)),
                ('relations_base', models.CharField(blank=True, max_length=128)),
                ('archdesc_base', models.CharField(blank=True, max_length=128)),
                ('archdesc_level', models.CharField(choices=[('class', 'Class'), ('collection', 'Collection'), ('file', 'File'), ('fonds', 'Fonds'), ('item', 'Item'), ('otherlevel', 'Other level'), ('recordgrp', 'Record group'), ('series', 'Series'), ('subfonds', 'Sub-fonds'), ('subgrp', 'Sub-group'), ('subseries', 'Sub-series')], max_length=10)),
                ('archdesc_otherlevel', models.CharField(blank=True, max_length=32)),
                ('archdesc_relatedencoding', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('agencycode_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('agencycode_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('archdesc_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('archdesc_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('control_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('control_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('did_head_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('did_head_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('did_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('did_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('editionstmt_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('editionstmt_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('filedesc_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('filedesc_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenanceagency_descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenanceagency_descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('maintenanceagency_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenanceagency_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('maintenancehistory_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenancehistory_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('maintenancestatus_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenancestatus_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('notestmt_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('notestmt_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('publicationstatus_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('publicationstatus_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('publicationstmt_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('publicationstmt_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('recordid_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('recordid_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('relations_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('relations_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('seriesstmt_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('seriesstmt_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('sources_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('sources_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('titlestmt_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('titlestmt_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LangMaterial',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('descriptivenote', models.TextField(blank=True)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LanguageSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote', models.TextField(blank=True)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('langmaterial', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.langmaterial')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Origination',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OriginationCorpName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('origination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='corpname_set', to='ead.origination')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OriginationFamName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('origination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='famname_set', to='ead.origination')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OriginationName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('origination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='name_set', to='ead.origination')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OriginationPersName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('origination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='persname_set', to='ead.origination')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysDescSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('coverage', models.CharField(blank=True, choices=[('part', 'Part'), ('whole', 'Whole')], max_length=5)),
                ('descriptivenote', models.TextField(blank=True)),
                ('parallel', models.BooleanField(blank=True, null=True)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysDescSetPhysDescStructured',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('unittype_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('quantity_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('unittype_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('quantity_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('unittype_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('quantity_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('unittype_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('unittype_identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('unittype_rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('unittype_source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('coverage', models.CharField(blank=True, choices=[('part', 'Part'), ('whole', 'Whole')], max_length=5)),
                ('descriptivenote', models.TextField(blank=True)),
                ('physdescstructuredtype', models.CharField(choices=[('carrier', 'Carrier'), ('materialtype', 'Material type'), ('otherphysdescstructuredtype', 'Other'), ('spaceoccupied', 'Space occupied')], max_length=27)),
                ('otherphysdescstructuredtype', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('quantity_approximate', models.BooleanField(blank=True, null=True)),
                ('quantity', models.IntegerField(blank=True, null=True)),
                ('unittype', models.CharField(max_length=64)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='physdescstructured_set', to='ead.physdescset')),
                ('quantity_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('quantity_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('unittype_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('unittype_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Relation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('geogname_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('dateset_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('objectxmlwrap_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('arcrole', models.CharField(blank=True, max_length=512)),
                ('geogname_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('dateset_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('objectxmlwrap_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('geogname_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('geogname_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('dateset_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('objectxmlwrap_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('geogname_identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('lastdatetimeverified', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('linkrole', models.CharField(blank=True, max_length=512)),
                ('linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('geogname_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('dateset_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('geogname_normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('geogname_relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('geogname_rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('geogname_source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote', models.TextField(blank=True)),
                ('objectxmlwrap', models.TextField(blank=True)),
                ('otherrelationtype', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('relationtype', models.CharField(choices=[('cpfrelation', 'CPF'), ('functionrelation', 'Function'), ('resourcerelation', 'Resource'), ('otherrelationtype', 'Other')], max_length=17)),
                ('geogname', models.TextField(blank=True)),
                ('dateset_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('dateset_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('geogname_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('geogname_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('objectxmlwrap_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('objectxmlwrap_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('relations', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Repository',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('address_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('address_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('address_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('address_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RepositoryCorpName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='corpname_set', to='ead.repository')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RepositoryFamName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='famname_set', to='ead.repository')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RepositoryName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='name_set', to='ead.repository')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RepositoryPersName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('relator', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('assembled_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='persname_set', to='ead.repository')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('objectxmlwrap_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('objectxmlwrap_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('objectxmlwrap_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('lastdatetimeverified', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('linkrole', models.CharField(blank=True, max_length=512)),
                ('linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('descriptivenote', models.TextField(blank=True)),
                ('objectxmlwrap', models.TextField(blank=True)),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('objectxmlwrap_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('objectxmlwrap_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('sources', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnitDateStructured',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('dateset_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('dateset_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('dateset_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('dateset_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('calendar', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('certainty', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('era', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('datechar', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('unitdatetype', models.CharField(blank=True, choices=[('bulk', 'Bulk'), ('inclusive', 'Inclusive')], max_length=9)),
                ('dateset_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('dateset_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UseRestrict',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('userestrict', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnitTitle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('unittitle', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnitId',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('countrycode', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('unitid', models.TextField()),
                ('repositorycode', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnitDateStructuredDateSingle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('datesingle', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='datesingle_set', to='ead.unitdatestructured')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnitDateStructuredDateRange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fromdate_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('todate_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('fromdate_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('todate_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('fromdate_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('todate_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('fromdate_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('todate_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('fromdate_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate', models.TextField(blank=True)),
                ('todate', models.TextField(blank=True)),
                ('fromdate_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('fromdate_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='daterange_set', to='ead.unitdatestructured')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('todate_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('todate_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnitDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('normal', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('calendar', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('certainty', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('era', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('datechar', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('unitdatetype', models.CharField(blank=True, choices=[('bulk', 'Bulk'), ('inclusive', 'Inclusive')], max_length=9)),
                ('unitdate', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TitleProper',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('titleproper', models.TextField()),
                ('render', models.CharField(blank=True, choices=[('altrender', 'Alternative rendering'), ('bold', 'Bold'), ('bolddoublequote', 'Bold double quote'), ('bolditalic', 'Bold italic'), ('boldsinglequote', 'Bold single quote'), ('boldsmcaps', 'Bold small caps'), ('boldunderline', 'Bold underline'), ('doublequote', 'Double quote'), ('italic', 'Italic'), ('nonproport', 'Non-proportional'), ('singlequote', 'Single quote'), ('smcaps', 'Small caps'), ('sub', 'Subscript'), ('super', 'Superscript'), ('underline', 'Underline')], max_length=15)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('titlestmt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Subtitle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('subtitle', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('titlestmt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Sponsor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('sponsor', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('titlestmt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SourceEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('transliteration', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('sourceentry', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.source')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SeparatedMaterial',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('separatedmaterial', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ScopeContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('scopecontent', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RightsDeclaration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('citation_actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('abbr_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('citation_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('citation_arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('abbr_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('citation_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('citation_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('abbr_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('citation_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('citation_href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('citation_lastdatetimeverified', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('citation_linkrole', models.CharField(blank=True, max_length=512)),
                ('citation_linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('citation_show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('abbr', models.CharField(blank=True, max_length=64)),
                ('abbr_expan', models.CharField(blank=True, max_length=512)),
                ('citation', models.TextField()),
                ('descriptivenote', models.TextField(blank=True)),
                ('abbr_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('abbr_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('citation_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('citation_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Representation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('linkrole', models.CharField(blank=True, max_length=512)),
                ('linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('representation', models.TextField(blank=True)),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RepositoryAddressLine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('addressline', models.TextField()),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='addressline_set', to='ead.repository')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RelationEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('transliteration', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('relationentry', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('relation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.relation')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RelationDateSingle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('datesingle', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='datesingle_set', to='ead.relation')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RelationDateRange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fromdate_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('todate_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('fromdate_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('todate_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('fromdate_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('todate_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('fromdate_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('todate_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('fromdate_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate', models.TextField(blank=True)),
                ('todate', models.TextField(blank=True)),
                ('fromdate_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('fromdate_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='daterange_set', to='ead.relation')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('todate_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('todate_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RelatedMaterial',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('relatedmaterial', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProcessInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('processinfo', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PreferCite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('prefercite', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysTech',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('phystech', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysLoc',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('physloc', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parents', models.ManyToManyField(blank=True, related_name='child_physlocs', to='ead.PhysLoc')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysDescSetPhysDescStructuredPhysFacet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('physfacet', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('physdescstructured', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='physfacet_set', to='ead.physdescsetphysdescstructured')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysDescSetPhyDescStructuredDimensions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('unit', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('dimensions', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('physdescstructured', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dimensions_set', to='ead.physdescsetphysdescstructured')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PhysDesc',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('physdesc', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OtherRecordID',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('otherrecordid', models.CharField(max_length=512)),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OtherFindAid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('otherfindaid', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OtherAgencyCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('otheragencycode', models.CharField(max_length=32)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenanceagency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OriginalsLoc',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('originalsloc', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ODD',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('odd', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MaterialSpec',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('materialspec', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MaintenanceEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('agent_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('agenttype_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('eventdatetime_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('eventtype_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('agent_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('agenttype_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('eventdatetime_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('eventtype_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('agent_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('agenttype_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('eventdatetime_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('eventtype_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('agent_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('agenttype_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('eventdatetime_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('eventtype_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('agent', models.CharField(max_length=128)),
                ('agenttype_value', models.CharField(choices=[('human', 'Human'), ('machine', 'Machine'), ('unknown', 'Unknown')], max_length=7)),
                ('agenttype', models.CharField(blank=True, max_length=32)),
                ('eventdatetime_standarddatetime', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('eventdatetime', models.CharField(blank=True, max_length=128)),
                ('eventtype_value', models.CharField(choices=[('cancelled', 'Cancelled'), ('created', 'Created'), ('deleted', 'Deleted'), ('derived', 'Derived'), ('revised', 'Revised'), ('unknown', 'Unknown'), ('updated', 'Updated')], max_length=9)),
                ('eventtype', models.CharField(blank=True, max_length=32)),
                ('agent_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('agent_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('agenttype_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('agenttype_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('eventdatetime_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('eventdatetime_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('eventtype_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('eventtype_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenancehistory', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LocalTypeDeclaration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('citation_actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('abbr_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('citation_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('citation_arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('abbr_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('citation_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('citation_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('abbr_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('citation_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('citation_href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('citation_lastdatetimeverified', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('citation_linkrole', models.CharField(blank=True, max_length=512)),
                ('citation_linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('citation_show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('abbr', models.CharField(blank=True, max_length=64)),
                ('abbr_expan', models.CharField(blank=True, max_length=512)),
                ('citation', models.TextField()),
                ('descriptivenote', models.TextField(blank=True)),
                ('abbr_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('abbr_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('citation_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('citation_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LocalControl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('daterange_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('fromdate_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('todate_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('datesingle_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('term_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('daterange_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('fromdate_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('todate_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('datesingle_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('term_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('term_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('daterange_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('fromdate_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('todate_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('datesingle_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('term_identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('term_lastdatetimeverified', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('daterange_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('fromdate_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('todate_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('datesingle_localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('fromdate_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('datesingle_notafter', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('fromdate_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('datesingle_notbefore', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('term_rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('term_source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('fromdate_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('todate_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('datesingle_standarddate', models.CharField(blank=True, max_length=32, validators=[ead.validators.validate_token])),
                ('term_transliteration', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('term', models.CharField(blank=True, max_length=64)),
                ('fromdate', models.TextField(blank=True)),
                ('todate', models.TextField(blank=True)),
                ('datesingle', models.TextField(blank=True)),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('daterange_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('daterange_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('datesingle_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('datesingle_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('fromdate_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('fromdate_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('term_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('term_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('todate_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('todate_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LegalStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('legalstatus', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LanguageSetScript',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('script_el', models.CharField(blank=True, max_length=32)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('languageset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='script_set', to='ead.languageset')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('scriptcode', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LanguageSetLanguage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('language', models.CharField(blank=True, max_length=32)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('langcode', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='language_set', to='ead.languageset')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LanguageDeclaration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('script_el_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('language_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('script_el_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('language_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('script_el_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('language_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('script_el_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('language_label', models.CharField(blank=True, max_length=128)),
                ('script_el_label', models.CharField(blank=True, max_length=128)),
                ('descriptivenote', models.TextField(blank=True)),
                ('language', models.CharField(blank=True, max_length=32)),
                ('script_el', models.CharField(blank=True, max_length=32)),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('language_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('language_langcode', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('language_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('script_el_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script_el_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('script_el_scriptcode', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LangMaterialLanguage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('language', models.CharField(blank=True, max_length=32)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('langcode', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='language_set', to='ead.langmaterial')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Index',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('index', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FilePlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('fileplan', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EventDescription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('eventdescription', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenanceevent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.maintenanceevent')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DIdPhysDescStructuredPhysFacet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('physfacet', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('physdescstructured', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='physfacet_set', to='ead.didphysdescstructured')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DIdPhysDescStructuredDimensions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('unit', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('dimensions', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('physdescstructured', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dimensions_set', to='ead.didphysdescstructured')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='didphysdescstructured',
            name='parent',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='physdescstructured_set', to='ead.ead'),
        ),
        migrations.AddField(
            model_name='didphysdescstructured',
            name='quantity_lang',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2']),
        ),
        migrations.AddField(
            model_name='didphysdescstructured',
            name='quantity_script',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924']),
        ),
        migrations.AddField(
            model_name='didphysdescstructured',
            name='script',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924']),
        ),
        migrations.AddField(
            model_name='didphysdescstructured',
            name='unittype_lang',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2']),
        ),
        migrations.AddField(
            model_name='didphysdescstructured',
            name='unittype_script',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924']),
        ),
        migrations.CreateModel(
            name='DIdNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('didnote', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DIdDAO',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('linkrole', models.CharField(blank=True, max_length=512)),
                ('linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('coverage', models.CharField(blank=True, choices=[('part', 'Part'), ('whole', 'Whole')], max_length=5)),
                ('xpointer', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('descriptivenote', models.TextField(blank=True)),
                ('daotype', models.CharField(choices=[('borndigital', 'Born digital'), ('derived', 'Derived'), ('unknown', 'Unknown'), ('otherdaotype', 'Other')], max_length=12)),
                ('otherdaotype', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dao_set', to='ead.ead')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DAOSetDAO',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('linkrole', models.CharField(blank=True, max_length=512)),
                ('linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('coverage', models.CharField(blank=True, choices=[('part', 'Part'), ('whole', 'Whole')], max_length=5)),
                ('xpointer', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('descriptivenote', models.TextField(blank=True)),
                ('daotype', models.CharField(choices=[('borndigital', 'Born digital'), ('derived', 'Derived'), ('unknown', 'Unknown'), ('otherdaotype', 'Other')], max_length=12)),
                ('otherdaotype', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dao_set', to='ead.daoset')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='daoset',
            name='did',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead'),
        ),
        migrations.AddField(
            model_name='daoset',
            name='lang',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2']),
        ),
        migrations.AddField(
            model_name='daoset',
            name='script',
            field=controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924']),
        ),
        migrations.CreateModel(
            name='CustodHist',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('custodhist', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ConventionDeclaration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('citation_actuate', models.CharField(blank=True, choices=[('none', 'None'), ('onload', 'onload'), ('onrequest', 'onrequest'), ('other', 'Other')], max_length=9)),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('abbr_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('citation_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('descriptivenote_altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('citation_arcrole', models.CharField(blank=True, max_length=512)),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('abbr_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('citation_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('descriptivenote_audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('citation_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('descriptivenote_encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('abbr_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('citation_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('descriptivenote_ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('citation_href', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('citation_lastdatetimeverified', models.CharField(blank=True, max_length=25, validators=[ead.validators.validate_date_time])),
                ('citation_linkrole', models.CharField(blank=True, max_length=512)),
                ('citation_linktitle', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('citation_show', models.CharField(blank=True, choices=[('embed', 'Embed'), ('new', 'New'), ('none', 'None'), ('other', 'Other'), ('replace', 'Replace')], max_length=7)),
                ('abbr', models.CharField(blank=True, max_length=64)),
                ('abbr_expan', models.CharField(blank=True, max_length=512)),
                ('citation', models.TextField()),
                ('descriptivenote', models.TextField(blank=True)),
                ('abbr_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('abbr_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('citation_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('citation_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('descriptivenote_lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('descriptivenote_script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ControlNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('controlnote', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('notestmt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ControlAccess',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('controlaccess', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Container',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('container', models.TextField()),
                ('containerid', models.CharField(blank=True, max_length=128)),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('parents', models.ManyToManyField(blank=True, related_name='child_containers', to='ead.Container')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BiogHist',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('bioghist', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Bibliography',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('bibliography', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('author', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
                ('titlestmt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Arrangement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('arrangement', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Appraisal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('appraisal', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AltFormAvail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('altformavail', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AgencyName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('agencyname', models.TextField()),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('maintenanceagency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AcqInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('acqinfo', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Accruals',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('accruals', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AccessRestrict',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('accessrestrict', models.TextField()),
                ('archdesc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Abstract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('label', models.CharField(blank=True, max_length=128)),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('abstract', models.TextField()),
                ('did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ead.ead')),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RepositoryPersNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.repositorypersname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='RepositoryNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.repositoryname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='RepositoryFamNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.repositoryfamname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='RepositoryCorpNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.repositorycorpname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='OriginationPersNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.originationpersname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='OriginationNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.originationname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='OriginationFamNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.originationfamname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
        migrations.CreateModel(
            name='OriginationCorpNamePart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('altrender', models.CharField(blank=True, max_length=128, validators=[ead.validators.validate_token])),
                ('audience', models.CharField(blank=True, choices=[('external', 'External'), ('internal', 'Internal')], max_length=8)),
                ('encodinganalog', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('ead_id', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_id])),
                ('identifier', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('localtype', models.CharField(blank=True, max_length=512, validators=[ead.validators.validate_token])),
                ('rules', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_nmtoken])),
                ('source', models.CharField(blank=True, max_length=64, validators=[ead.validators.validate_token])),
                ('part', models.TextField()),
                ('order', models.PositiveSmallIntegerField()),
                ('plain_name', models.TextField(blank=True)),
                ('lang', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso639-2'])),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='part_set', to='ead.originationcorpname')),
                ('script', controlled_vocabulary.models.ControlledTermField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='controlled_vocabulary.controlledterm', vocabularies=['iso15924'])),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('name', 'order')},
            },
        ),
    ]
