# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['minimal_activitypub']

package_data = \
{'': ['*']}

install_requires = \
['Brotli>=1.0.9,<2.0.0',
 'aiodns>=3.0.0,<4.0.0',
 'aiohttp>=3.8.1,<4.0.0',
 'arrow>=1.2.1,<2.0.0',
 'charset-normalizer>=2.1.1,<3.0.0']

setup_kwargs = {
    'name': 'minimal-activitypub',
    'version': '0.4.1',
    'description': 'Minimal inplementation of ActivityPub Interface',
    'long_description': 'Minimal-ActivityPub\n===================\n\n|Repo| |CI| |Downloads|\n\n|Safety| |pip-audit| |Interrogate|\n\n|Codestyle| |Version| |Wheel|\n\n|AGPL|\n\n\nMinimal-ActivityPub is a minimal Python implementation of the ActivityPub rest API used by\n`Mastodon <https://joinmastodon.org/>`_,\n`Pleroma <https://pleroma.social/>`_,\nand others. This implementation makes use of asyncio where appropriate. It is intended to be used as a library by other\napplications. No standalone functionality is provided.\n\nMinimal refers to the fact that only API calls I need for my other projects;\n`MastodonAmnesia <https://codeberg.org/MarvinsMastodonTools/mastodonamnesia>`_ and\n`TootBot <https://codeberg.org/MarvinsMastodonTools/tootbot>`_ are implemented.\n\n**DO NOT** expect a full or complete implementation of all `ActivityPub API <https://activitypub.rocks/>`_ functionality.\n\nAPI Methods Currently Implemented\n==================================\n\nClient to Server Methods\n----------------------------------\n- get_auth_token\n- verify_credentials\n- determine_instance_type\n- get_account_statuses\n- delete_status\n- post_status\n- post_media\n- undo_reblog\n- undo_favourite\n\nServer to Server Methods\n----------------------------------\nNo API methods for server to server communications have been implemented.\n\nUsage\n==================================\nMinimal-ActivityPub is available on `PyPi <https://pypi.org/>`_ as `minimal-activitypub` and can be added to an\napplication the same as any other python library.\n\nAdd `minimal-activitypub` as a requirement to your project and/or install using pip::\n\n    pip install minimal-activitypub\n\nWorkflow overview\n----------------------------------\nIn general you need the authenticate to an ActivityPub server instance. To do so you require an `access_token`, so generally\nyou\'ll want to use the method ``get_auth_token`` when setting up the initial connection.\n\nAfter that I think it is a good idea to verify the credentials using the ``verify_credentials`` method and determine the\nserver type using the ``determine_instance_type`` method.\n\nAfter that you use which ever method(s) that are needed for your use case.\n\n.. Todo: Add individual explanation for each method.\n\nExample for ``get_auth_token(...)``\n-----------------------------------------\nTo get an Auth Token (also referred to as an access token) your code needs to be able to login to the Fediverse instance.\nIn this API implementation we do so using the user_name (email for Mastodon instances) and the user\'s password.\nNeither of these values is being stored after an auth token has been obtained.\n\n.. code-block:: python\n\n    async def example(instance, user_name, password):\n        async with aiohttp.ClientSession() as session:\n            access_token = await ActivityPub.get_auth_token(\n                instance_url=instance,\n                username=user_name,\n                password=password,\n                session=session,\n        )\n\nExample for ``verify_credentials(...)``\n-----------------------------------------\n``verify_credentials(...)`` ensures that the access_token is valid and returns information about the user that the\naccess_token has been created for. It is good practice to check the validity of the access_token with this method call\nbefore any further interaction with the Fediverse instance.\n\n.. code-block:: python\n\n    async def example(instance, access_token):\n        async with aiohttp.ClientSession() as session:\n            instance = ActivityPub(\n                instance=instance,\n                access_token=access_token,\n                session=session,\n            )\n            user_info = await instance.verify_credentials()\n            account_id = user_info["id"]\n            user_name = user_info["username"]\n\nExample for ``determine_instance_type()``\n-----------------------------------------\n``determine_instance_type()`` checks what type of server we are interacting with. At this time minimal-activitypub only\ncheck for Pleroma and otherwise defaults to Mastodon.\nThis method updates the instance variable ``is_instance_pleroma`` to ``True`` if the Fediverse server is\nrunning Pleroma\n\n.. code-block:: python\n\n    async def example(instance, access_token):\n        async with aiohttp.ClientSession() as session:\n            instance = ActivityPub(\n                instance=instance,\n                access_token=access_token,\n                session=session,\n            )\n            await instance.determine_instance_type()\n\nExample for ``get_account_statuses(...)``\n-----------------------------------------\n``get_account_statuses(...)`` retrieves a list of the most recent toots posted by the account identified by its id.\nThis method updates the instance variables ``pagination_max_id`` and ``pagination_min_id`` with the values for ``min_id``\nand ``max_id`` returned by the server in the http response header.\nThese values can be used to paginate forward and backwards through the history of toots.\n\n.. code-block:: python\n\n    async def example(account_id):\n        async with aiohttp.ClientSession() as session:\n            instance = ActivityPub(\n                instance=instance,\n                access_token=access_token,\n                session=session,\n            )\n            toots = await instance.get_account_statuses(account_id=account_id)\n\n            # retrieving the next set of toots\n            if instance.pagination_max_id:\n                toots = await instance.get_account_statuses(\n                    account_id=account_id,\n                    max_id=instance.pagination_max_id,\n                )\n\nExample for ``delete_status(...)``\n-----------------------------------------\n``delete_status(...)`` deletes a toot / post / status identified by its id.\nThis method returns the deleted toot / post / status.\n\n.. code-block:: python\n\n    async def example(toot_id):\n        async with aiohttp.ClientSession() as session:\n            instance = ActivityPub(\n                instance=instance,\n                access_token=access_token,\n                session=session,\n            )\n            deleted_toot = await instance.delete_status(status_id=toot_id)\n\nExample for ``post_status(...)``\n-----------------------------------------\n``post_status(...)`` creates a toot / post / status identified.\nThis method returns the created toot / post / status.\n\n.. code-block:: python\n\n    async def example(status_text: str):\n        async with aiohttp.ClientSession() as session:\n            instance = ActivityPub(\n                instance=instance,\n                access_token=access_token,\n                session=session,\n            )\n\n            toot = await instance.post_status(\n                status=status_text,\n            )\n\nExample for ``post_media(...)``\n-----------------------------------------\n``post_media(...)`` sends an image or video to the server. This needs to be done to be able to attach an image or\nvideo to a toot / post / status\nThis method returns a dictionary containing details for this media on server, such a `id`, `url` etc.\n\n.. code-block:: python\n\n    async def example(media_path: str):\n        async with aiohttp.ClientSession() as session:\n            instance = ActivityPub(\n                instance=instance,\n                access_token=access_token,\n                session=session,\n            )\n\n            mime_type = magic.from_file(media_path, mime=True)\n            async with aiofiles.open(file=media_path, mode="rb") as upload:\n                media = await instance.post_media(\n                    file=upload,\n                    mime_type=mime_type,\n                )\n\n            media_ids = [media[\'id\'], ]\n            toot = await instance.post_status(\n                status="Test status with media attached",\n                media_ids=media_ids,\n            )\n\nContributing\n==================================\nIssues and pull requests are welcome.\n\nMinimal-ActivityPub is using `pre-commit <https://pre-commit.com/>`_ and `Poetry <https://python-poetry.org/>`_.\nPlease install and use both pre-commit and Poetry if you\'d like to contribute.\n\nTo make sure you have all required python modules installed with Poetry is as easy as ``poetry install`` in the root of the\nproject directory\n\nLicensing\n==================================\nMinimal-ActivityPub is licences under licensed under the `GNU Affero General Public License v3.0 <http://www.gnu.org/licenses/agpl-3.0.html>`_\n\nSupporting Minimal-ActivityPub\n==================================\n\nThere are a number of ways you can support Minimal-ActivityPub:\n\n- Create an issue with problems or ideas you have with/for Minimal-ActivityPub\n- You can `buy me a coffee <https://www.buymeacoffee.com/marvin8>`_.\n- You can send me small change in Monero to the address below:\n\nMonero donation address:\n----------------------------------\n`8ADQkCya3orL178dADn4bnKuF1JuVGEG97HPRgmXgmZ2cZFSkWU9M2v7BssEGeTRNN2V5p6bSyHa83nrdu1XffDX3cnjKVu`\n\n\n.. |AGPL| image:: https://www.gnu.org/graphics/agplv3-with-text-162x68.png\n    :alt: AGLP 3 or later\n    :target:  https://codeberg.org/MarvinsMastodonTools/minimal-activitypub/src/branch/main/LICENSE.md\n\n.. |Repo| image:: https://img.shields.io/badge/repo-Codeberg.org-blue\n    :alt: Repo at Codeberg.org\n    :target: https://codeberg.org/MarvinsMastodonTools/minimal-activitypub\n\n.. |Downloads| image:: https://pepy.tech/badge/minimal-activitypub\n    :alt: Download count\n    :target: https://pepy.tech/project/minimal-activitypub\n\n.. |Codestyle| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :alt: Code style: black\n    :target: https://github.com/psf/black\n\n.. |Safety| image:: https://img.shields.io/badge/Safety--DB-checked-green\n    :alt: Checked against PyUp Safety DB\n    :target: https://pyup.io/safety/\n\n.. |pip-audit| image:: https://img.shields.io/badge/pip--audit-checked-green\n    :alt: Checked with pip-audit\n    :target: https://pypi.org/project/pip-audit/\n\n.. |Version| image:: https://img.shields.io/pypi/pyversions/minimal-activitypub\n    :alt: PyPI - Python Version\n\n.. |Wheel| image:: https://img.shields.io/pypi/wheel/minimal-activitypub\n    :alt: PyPI - Wheel\n\n.. |CI| image:: https://ci.codeberg.org/api/badges/MarvinsMastodonTools/minimal-activitypub/status.svg\n    :alt: CI / Woodpecker\n    :target: https://ci.codeberg.org/MarvinsMastodonTools/minimal-activitypub\n\n.. |Interrogate| image:: https://codeberg.org/MarvinsMastodonTools/minimal-activitypub/raw/branch/main/interrogate_badge.svg\n    :alt: Doc-string coverage\n    :target: https://interrogate.readthedocs.io/en/latest/\n',
    'author': 'marvin8',
    'author_email': 'marvin8@tuta.io',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://codeberg.org/MarvinsMastodonTools/mastodonamnesia',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
