# coding: utf-8

"""
    AYLIEN News API

    The AYLIEN News API is the most powerful way of sourcing, searching and syndicating analyzed and enriched news content. It is accessed by sending HTTP requests to our server, which returns information to your client.   # noqa: E501

    The version of the OpenAPI document: 5.1.1
    Contact: support@aylien.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aylien_news_api.api_client import ApiClient
from aylien_news_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def advanced_list_stories(self, unknown_base_type, **kwargs):  # noqa: E501
        """List Stories  # noqa: E501

        The stories endpoint is used to return stories based on the json query you set in your request body. The News API crawler gathers articles in near real-time and stores information about them, or metadata. Below you can see all of the query parameters, and JSON schema for the body, which you can use to narrow down your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.advanced_list_stories(unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param unknown_base_type: /stories body schema to perform an advanced search with logical operators and nested objects.  (required)
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param sort_by: This parameter is used for changing the order column of the results. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_by: str
        :param sort_direction: This parameter is used for changing the order direction of the result. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_direction: str
        :param cursor: This parameter is used for finding a specific page. You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results). 
        :type cursor: str
        :param per_page: This parameter is used for specifying number of items in each page You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results) 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Stories
        """
        kwargs['_return_http_data_only'] = True
        return self.advanced_list_stories_with_http_info(unknown_base_type, **kwargs)  # noqa: E501

    def advanced_list_stories_with_http_info(self, unknown_base_type, **kwargs):  # noqa: E501
        """List Stories  # noqa: E501

        The stories endpoint is used to return stories based on the json query you set in your request body. The News API crawler gathers articles in near real-time and stores information about them, or metadata. Below you can see all of the query parameters, and JSON schema for the body, which you can use to narrow down your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.advanced_list_stories_with_http_info(unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param unknown_base_type: /stories body schema to perform an advanced search with logical operators and nested objects.  (required)
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param sort_by: This parameter is used for changing the order column of the results. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_by: str
        :param sort_direction: This parameter is used for changing the order direction of the result. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_direction: str
        :param cursor: This parameter is used for finding a specific page. You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results). 
        :type cursor: str
        :param per_page: This parameter is used for specifying number of items in each page You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results) 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Stories, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'unknown_base_type',
            'published_at_start',
            'published_at_end',
            '_return',
            'sort_by',
            'sort_direction',
            'cursor',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method advanced_list_stories" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'unknown_base_type' is set
        if self.api_client.client_side_validation and ('unknown_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['unknown_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unknown_base_type` when calling `advanced_list_stories`")  # noqa: E501

        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `advanced_list_stories`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `advanced_list_stories`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if '_return' in local_var_params and local_var_params['_return'] is not None:  # noqa: E501
            query_params.append(('return[]', local_var_params['_return']))  # noqa: E501
            collection_formats['return[]'] = 'multi'  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
        if 'sort_direction' in local_var_params and local_var_params['sort_direction'] is not None:  # noqa: E501
            query_params.append(('sort_direction', local_var_params['sort_direction']))  # noqa: E501
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/stories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_autocompletes(self, type, term, **kwargs):  # noqa: E501
        """List autocompletes  # noqa: E501

        The autocompletes endpoint a string of characters provided to it, and then returns suggested terms that are the most likely full words or strings. The terms returned by the News API are based on parameters the type parameters you can see below. For example, if you provide the autocompletes endpoint with the term `New York C` and select the type `dbpedia_resources`, the API will return links to the DBpedia resources `New_York_City`, `New_York_City_Subway`, `New_York_City_Police_Department`, and so on.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_autocompletes(type, term, async_req=True)
        >>> result = thread.get()

        :param type: This parameter is used for defining the type of autocompletes.  (required)
        :type type: str
        :param term: This parameter is used for finding autocomplete objects that contain the specified value.  (required)
        :type term: str
        :param language: This parameter is used for autocompletes whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: str
        :param per_page: This parameter is used for specifying number of items in each page. 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Autocompletes
        """
        kwargs['_return_http_data_only'] = True
        return self.list_autocompletes_with_http_info(type, term, **kwargs)  # noqa: E501

    def list_autocompletes_with_http_info(self, type, term, **kwargs):  # noqa: E501
        """List autocompletes  # noqa: E501

        The autocompletes endpoint a string of characters provided to it, and then returns suggested terms that are the most likely full words or strings. The terms returned by the News API are based on parameters the type parameters you can see below. For example, if you provide the autocompletes endpoint with the term `New York C` and select the type `dbpedia_resources`, the API will return links to the DBpedia resources `New_York_City`, `New_York_City_Subway`, `New_York_City_Police_Department`, and so on.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_autocompletes_with_http_info(type, term, async_req=True)
        >>> result = thread.get()

        :param type: This parameter is used for defining the type of autocompletes.  (required)
        :type type: str
        :param term: This parameter is used for finding autocomplete objects that contain the specified value.  (required)
        :type term: str
        :param language: This parameter is used for autocompletes whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: str
        :param per_page: This parameter is used for specifying number of items in each page. 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Autocompletes, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'type',
            'term',
            'language',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_autocompletes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `list_autocompletes`")  # noqa: E501
        # verify the required parameter 'term' is set
        if self.api_client.client_side_validation and ('term' not in local_var_params or  # noqa: E501
                                                        local_var_params['term'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `term` when calling `list_autocompletes`")  # noqa: E501

        if self.api_client.client_side_validation and ('term' in local_var_params and  # noqa: E501
                                                        len(local_var_params['term']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `term` when calling `list_autocompletes`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_autocompletes`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_autocompletes`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'term' in local_var_params and local_var_params['term'] is not None:  # noqa: E501
            query_params.append(('term', local_var_params['term']))  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language', local_var_params['language']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/autocompletes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Autocompletes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_clusters(self, **kwargs):  # noqa: E501
        """List Clusters  # noqa: E501

        The clusters endpoint is used to return clusters based on parameters you set in your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_clusters(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding clusters by cluster id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding clusters by cluster id. 
        :type not_id: list[int]
        :param story_count_min: This parameter is used for finding clusters with more than or equal to a specific amount of stories associated with them. 
        :type story_count_min: int
        :param story_count_max: This parameter is used for finding clusters with less than or equal to a specific amount of stories associated with them. 
        :type story_count_max: int
        :param time_start: This parameter is used for finding clusters whose creation time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type time_start: str
        :param time_end: This parameter is used for finding clusters whose creation time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type time_end: str
        :param earliest_story_start: This parameter is used for finding clusters whose publication date of its earliest story is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type earliest_story_start: str
        :param earliest_story_end: This parameter is used for finding clusters whose publication date of its earliest story is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type earliest_story_end: str
        :param latest_story_start: This parameter is used for finding clusters whose publication date of its latest story is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type latest_story_start: str
        :param latest_story_end: This parameter is used for finding clusters whose publication date of its latest story is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type latest_story_end: str
        :param location_country: This parameter is used for finding clusters belonging to a specific country. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type location_country: list[str]
        :param not_location_country: This parameter is used for excluding clusters belonging to a specific country. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_location_country: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param sort_by: This parameter is used for changing the order column of the results. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_by: str
        :param sort_direction: This parameter is used for changing the order direction of the result. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_direction: str
        :param cursor: This parameter is used for finding a specific page. You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results). 
        :type cursor: str
        :param per_page: This parameter is used for specifying number of items in each page You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results) 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Clusters
        """
        kwargs['_return_http_data_only'] = True
        return self.list_clusters_with_http_info(**kwargs)  # noqa: E501

    def list_clusters_with_http_info(self, **kwargs):  # noqa: E501
        """List Clusters  # noqa: E501

        The clusters endpoint is used to return clusters based on parameters you set in your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_clusters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding clusters by cluster id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding clusters by cluster id. 
        :type not_id: list[int]
        :param story_count_min: This parameter is used for finding clusters with more than or equal to a specific amount of stories associated with them. 
        :type story_count_min: int
        :param story_count_max: This parameter is used for finding clusters with less than or equal to a specific amount of stories associated with them. 
        :type story_count_max: int
        :param time_start: This parameter is used for finding clusters whose creation time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type time_start: str
        :param time_end: This parameter is used for finding clusters whose creation time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type time_end: str
        :param earliest_story_start: This parameter is used for finding clusters whose publication date of its earliest story is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type earliest_story_start: str
        :param earliest_story_end: This parameter is used for finding clusters whose publication date of its earliest story is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type earliest_story_end: str
        :param latest_story_start: This parameter is used for finding clusters whose publication date of its latest story is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type latest_story_start: str
        :param latest_story_end: This parameter is used for finding clusters whose publication date of its latest story is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type latest_story_end: str
        :param location_country: This parameter is used for finding clusters belonging to a specific country. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type location_country: list[str]
        :param not_location_country: This parameter is used for excluding clusters belonging to a specific country. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_location_country: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param sort_by: This parameter is used for changing the order column of the results. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_by: str
        :param sort_direction: This parameter is used for changing the order direction of the result. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_direction: str
        :param cursor: This parameter is used for finding a specific page. You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results). 
        :type cursor: str
        :param per_page: This parameter is used for specifying number of items in each page You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results) 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Clusters, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'not_id',
            'story_count_min',
            'story_count_max',
            'time_start',
            'time_end',
            'earliest_story_start',
            'earliest_story_end',
            'latest_story_start',
            'latest_story_end',
            'location_country',
            'not_location_country',
            '_return',
            'sort_by',
            'sort_direction',
            'cursor',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_clusters" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'story_count_min' in local_var_params and local_var_params['story_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `story_count_min` when calling `list_clusters`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'story_count_max' in local_var_params and local_var_params['story_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `story_count_max` when calling `list_clusters`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_clusters`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_clusters`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'story_count_min' in local_var_params and local_var_params['story_count_min'] is not None:  # noqa: E501
            query_params.append(('story_count.min', local_var_params['story_count_min']))  # noqa: E501
        if 'story_count_max' in local_var_params and local_var_params['story_count_max'] is not None:  # noqa: E501
            query_params.append(('story_count.max', local_var_params['story_count_max']))  # noqa: E501
        if 'time_start' in local_var_params and local_var_params['time_start'] is not None:  # noqa: E501
            query_params.append(('time.start', local_var_params['time_start']))  # noqa: E501
        if 'time_end' in local_var_params and local_var_params['time_end'] is not None:  # noqa: E501
            query_params.append(('time.end', local_var_params['time_end']))  # noqa: E501
        if 'earliest_story_start' in local_var_params and local_var_params['earliest_story_start'] is not None:  # noqa: E501
            query_params.append(('earliest_story.start', local_var_params['earliest_story_start']))  # noqa: E501
        if 'earliest_story_end' in local_var_params and local_var_params['earliest_story_end'] is not None:  # noqa: E501
            query_params.append(('earliest_story.end', local_var_params['earliest_story_end']))  # noqa: E501
        if 'latest_story_start' in local_var_params and local_var_params['latest_story_start'] is not None:  # noqa: E501
            query_params.append(('latest_story.start', local_var_params['latest_story_start']))  # noqa: E501
        if 'latest_story_end' in local_var_params and local_var_params['latest_story_end'] is not None:  # noqa: E501
            query_params.append(('latest_story.end', local_var_params['latest_story_end']))  # noqa: E501
        if 'location_country' in local_var_params and local_var_params['location_country'] is not None:  # noqa: E501
            query_params.append(('location.country', local_var_params['location_country']))  # noqa: E501
            collection_formats['location.country'] = 'multi'  # noqa: E501
        if 'not_location_country' in local_var_params and local_var_params['not_location_country'] is not None:  # noqa: E501
            query_params.append(('!location.country', local_var_params['not_location_country']))  # noqa: E501
            collection_formats['!location.country'] = 'multi'  # noqa: E501
        if '_return' in local_var_params and local_var_params['_return'] is not None:  # noqa: E501
            query_params.append(('return[]', local_var_params['_return']))  # noqa: E501
            collection_formats['return[]'] = 'multi'  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
        if 'sort_direction' in local_var_params and local_var_params['sort_direction'] is not None:  # noqa: E501
            query_params.append(('sort_direction', local_var_params['sort_direction']))  # noqa: E501
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Clusters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_histograms(self, **kwargs):  # noqa: E501
        """List histograms  # noqa: E501

        For the numerical metadata that the News API gathers (such as word counts or social shares for example), you can use the histograms endpoint to access and display this information. As this endpoint does not return actual stories, the results you are given will not count towards your story allowance provided by your subscription, so you can effectively query this endpoint free of charge.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_histograms(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param interval_start: This parameter is used for setting the start data point of histogram intervals. 
        :type interval_start: int
        :param interval_end: This parameter is used for setting the end data point of histogram intervals. 
        :type interval_end: int
        :param interval_width: This parameter is used for setting the width of histogram intervals. 
        :type interval_width: int
        :param field: This parameter is used for specifying the y-axis variable for the histogram. 
        :type field: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Histograms
        """
        kwargs['_return_http_data_only'] = True
        return self.list_histograms_with_http_info(**kwargs)  # noqa: E501

    def list_histograms_with_http_info(self, **kwargs):  # noqa: E501
        """List histograms  # noqa: E501

        For the numerical metadata that the News API gathers (such as word counts or social shares for example), you can use the histograms endpoint to access and display this information. As this endpoint does not return actual stories, the results you are given will not count towards your story allowance provided by your subscription, so you can effectively query this endpoint free of charge.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_histograms_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param interval_start: This parameter is used for setting the start data point of histogram intervals. 
        :type interval_start: int
        :param interval_end: This parameter is used for setting the end data point of histogram intervals. 
        :type interval_end: int
        :param interval_width: This parameter is used for setting the width of histogram intervals. 
        :type interval_width: int
        :param field: This parameter is used for specifying the y-axis variable for the histogram. 
        :type field: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Histograms, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'not_id',
            'title',
            'body',
            'text',
            'translations_en_title',
            'translations_en_body',
            'translations_en_text',
            'links_permalink',
            'not_links_permalink',
            'language',
            'not_language',
            'published_at_start',
            'published_at_end',
            'categories_taxonomy',
            'categories_confident',
            'categories_id',
            'not_categories_id',
            'categories_label',
            'not_categories_label',
            'categories_level',
            'not_categories_level',
            'entities_id',
            'not_entities_id',
            'entities_links_wikipedia',
            'not_entities_links_wikipedia',
            'entities_links_wikidata',
            'not_entities_links_wikidata',
            'entities_types',
            'not_entities_types',
            'entities_stock_tickers',
            'entities_body_stock_tickers',
            'entities_surface_forms_text',
            'not_entities_surface_forms_text',
            'entities_title_surface_forms_text',
            'not_entities_title_surface_forms_text',
            'entities_body_surface_forms_text',
            'not_entities_body_surface_forms_text',
            'sentiment_title_polarity',
            'not_sentiment_title_polarity',
            'sentiment_body_polarity',
            'not_sentiment_body_polarity',
            'media_images_count_min',
            'media_images_count_max',
            'media_images_width_min',
            'media_images_width_max',
            'media_images_height_min',
            'media_images_height_max',
            'media_images_content_length_min',
            'media_images_content_length_max',
            'media_images_format',
            'not_media_images_format',
            'media_videos_count_min',
            'media_videos_count_max',
            'author_id',
            'not_author_id',
            'author_name',
            'not_author_name',
            'source_id',
            'not_source_id',
            'source_name',
            'not_source_name',
            'source_domain',
            'not_source_domain',
            'source_locations_country',
            'not_source_locations_country',
            'source_locations_state',
            'not_source_locations_state',
            'source_locations_city',
            'not_source_locations_city',
            'source_scopes_country',
            'not_source_scopes_country',
            'source_scopes_state',
            'not_source_scopes_state',
            'source_scopes_city',
            'not_source_scopes_city',
            'source_scopes_level',
            'not_source_scopes_level',
            'source_links_in_count_min',
            'source_links_in_count_max',
            'source_rankings_alexa_rank_min',
            'source_rankings_alexa_rank_max',
            'source_rankings_alexa_country',
            'social_shares_count_facebook_min',
            'social_shares_count_facebook_max',
            'social_shares_count_google_plus_min',
            'social_shares_count_google_plus_max',
            'social_shares_count_linkedin_min',
            'social_shares_count_linkedin_max',
            'social_shares_count_reddit_min',
            'social_shares_count_reddit_max',
            'clusters',
            'aql',
            'aql_default_field',
            'query',
            'interval_start',
            'interval_end',
            'interval_width',
            'field'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_histograms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_min` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_max` when calling `list_histograms`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'body' in local_var_params and local_var_params['body'] is not None:  # noqa: E501
            query_params.append(('body', local_var_params['body']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'translations_en_title' in local_var_params and local_var_params['translations_en_title'] is not None:  # noqa: E501
            query_params.append(('translations.en.title', local_var_params['translations_en_title']))  # noqa: E501
        if 'translations_en_body' in local_var_params and local_var_params['translations_en_body'] is not None:  # noqa: E501
            query_params.append(('translations.en.body', local_var_params['translations_en_body']))  # noqa: E501
        if 'translations_en_text' in local_var_params and local_var_params['translations_en_text'] is not None:  # noqa: E501
            query_params.append(('translations.en.text', local_var_params['translations_en_text']))  # noqa: E501
        if 'links_permalink' in local_var_params and local_var_params['links_permalink'] is not None:  # noqa: E501
            query_params.append(('links.permalink[]', local_var_params['links_permalink']))  # noqa: E501
            collection_formats['links.permalink[]'] = 'multi'  # noqa: E501
        if 'not_links_permalink' in local_var_params and local_var_params['not_links_permalink'] is not None:  # noqa: E501
            query_params.append(('!links.permalink[]', local_var_params['not_links_permalink']))  # noqa: E501
            collection_formats['!links.permalink[]'] = 'multi'  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language[]', local_var_params['language']))  # noqa: E501
            collection_formats['language[]'] = 'multi'  # noqa: E501
        if 'not_language' in local_var_params and local_var_params['not_language'] is not None:  # noqa: E501
            query_params.append(('!language[]', local_var_params['not_language']))  # noqa: E501
            collection_formats['!language[]'] = 'multi'  # noqa: E501
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if 'categories_taxonomy' in local_var_params and local_var_params['categories_taxonomy'] is not None:  # noqa: E501
            query_params.append(('categories.taxonomy', local_var_params['categories_taxonomy']))  # noqa: E501
        if 'categories_confident' in local_var_params and local_var_params['categories_confident'] is not None:  # noqa: E501
            query_params.append(('categories.confident', local_var_params['categories_confident']))  # noqa: E501
        if 'categories_id' in local_var_params and local_var_params['categories_id'] is not None:  # noqa: E501
            query_params.append(('categories.id[]', local_var_params['categories_id']))  # noqa: E501
            collection_formats['categories.id[]'] = 'multi'  # noqa: E501
        if 'not_categories_id' in local_var_params and local_var_params['not_categories_id'] is not None:  # noqa: E501
            query_params.append(('!categories.id[]', local_var_params['not_categories_id']))  # noqa: E501
            collection_formats['!categories.id[]'] = 'multi'  # noqa: E501
        if 'categories_label' in local_var_params and local_var_params['categories_label'] is not None:  # noqa: E501
            query_params.append(('categories.label[]', local_var_params['categories_label']))  # noqa: E501
            collection_formats['categories.label[]'] = 'multi'  # noqa: E501
        if 'not_categories_label' in local_var_params and local_var_params['not_categories_label'] is not None:  # noqa: E501
            query_params.append(('!categories.label[]', local_var_params['not_categories_label']))  # noqa: E501
            collection_formats['!categories.label[]'] = 'multi'  # noqa: E501
        if 'categories_level' in local_var_params and local_var_params['categories_level'] is not None:  # noqa: E501
            query_params.append(('categories.level[]', local_var_params['categories_level']))  # noqa: E501
            collection_formats['categories.level[]'] = 'multi'  # noqa: E501
        if 'not_categories_level' in local_var_params and local_var_params['not_categories_level'] is not None:  # noqa: E501
            query_params.append(('!categories.level[]', local_var_params['not_categories_level']))  # noqa: E501
            collection_formats['!categories.level[]'] = 'multi'  # noqa: E501
        if 'entities_id' in local_var_params and local_var_params['entities_id'] is not None:  # noqa: E501
            query_params.append(('entities.id[]', local_var_params['entities_id']))  # noqa: E501
            collection_formats['entities.id[]'] = 'multi'  # noqa: E501
        if 'not_entities_id' in local_var_params and local_var_params['not_entities_id'] is not None:  # noqa: E501
            query_params.append(('!entities.id[]', local_var_params['not_entities_id']))  # noqa: E501
            collection_formats['!entities.id[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikipedia' in local_var_params and local_var_params['entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikipedia[]', local_var_params['entities_links_wikipedia']))  # noqa: E501
            collection_formats['entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikipedia' in local_var_params and local_var_params['not_entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikipedia[]', local_var_params['not_entities_links_wikipedia']))  # noqa: E501
            collection_formats['!entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikidata' in local_var_params and local_var_params['entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikidata[]', local_var_params['entities_links_wikidata']))  # noqa: E501
            collection_formats['entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikidata' in local_var_params and local_var_params['not_entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikidata[]', local_var_params['not_entities_links_wikidata']))  # noqa: E501
            collection_formats['!entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'entities_types' in local_var_params and local_var_params['entities_types'] is not None:  # noqa: E501
            query_params.append(('entities.types[]', local_var_params['entities_types']))  # noqa: E501
            collection_formats['entities.types[]'] = 'multi'  # noqa: E501
        if 'not_entities_types' in local_var_params and local_var_params['not_entities_types'] is not None:  # noqa: E501
            query_params.append(('!entities.types[]', local_var_params['not_entities_types']))  # noqa: E501
            collection_formats['!entities.types[]'] = 'multi'  # noqa: E501
        if 'entities_stock_tickers' in local_var_params and local_var_params['entities_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('entities.stock_tickers[]', local_var_params['entities_stock_tickers']))  # noqa: E501
            collection_formats['entities.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_body_stock_tickers' in local_var_params and local_var_params['entities_body_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('!entities.body.stock_tickers[]', local_var_params['entities_body_stock_tickers']))  # noqa: E501
            collection_formats['!entities.body.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_surface_forms_text' in local_var_params and local_var_params['entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.surface_forms.text[]', local_var_params['entities_surface_forms_text']))  # noqa: E501
            collection_formats['entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_surface_forms_text' in local_var_params and local_var_params['not_entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.surface_forms.text[]', local_var_params['not_entities_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_title_surface_forms_text' in local_var_params and local_var_params['entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.title.surface_forms.text[]', local_var_params['entities_title_surface_forms_text']))  # noqa: E501
        if 'not_entities_title_surface_forms_text' in local_var_params and local_var_params['not_entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.title.surface_forms.text[]', local_var_params['not_entities_title_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.title.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_body_surface_forms_text' in local_var_params and local_var_params['entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.body.surface_forms.text[]', local_var_params['entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_body_surface_forms_text' in local_var_params and local_var_params['not_entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.body.surface_forms.text[]', local_var_params['not_entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'sentiment_title_polarity' in local_var_params and local_var_params['sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.title.polarity', local_var_params['sentiment_title_polarity']))  # noqa: E501
        if 'not_sentiment_title_polarity' in local_var_params and local_var_params['not_sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.title.polarity', local_var_params['not_sentiment_title_polarity']))  # noqa: E501
        if 'sentiment_body_polarity' in local_var_params and local_var_params['sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.body.polarity', local_var_params['sentiment_body_polarity']))  # noqa: E501
        if 'not_sentiment_body_polarity' in local_var_params and local_var_params['not_sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.body.polarity', local_var_params['not_sentiment_body_polarity']))  # noqa: E501
        if 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] is not None:  # noqa: E501
            query_params.append(('media.images.count.min', local_var_params['media_images_count_min']))  # noqa: E501
        if 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] is not None:  # noqa: E501
            query_params.append(('media.images.count.max', local_var_params['media_images_count_max']))  # noqa: E501
        if 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] is not None:  # noqa: E501
            query_params.append(('media.images.width.min', local_var_params['media_images_width_min']))  # noqa: E501
        if 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] is not None:  # noqa: E501
            query_params.append(('media.images.width.max', local_var_params['media_images_width_max']))  # noqa: E501
        if 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] is not None:  # noqa: E501
            query_params.append(('media.images.height.min', local_var_params['media_images_height_min']))  # noqa: E501
        if 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] is not None:  # noqa: E501
            query_params.append(('media.images.height.max', local_var_params['media_images_height_max']))  # noqa: E501
        if 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.min', local_var_params['media_images_content_length_min']))  # noqa: E501
        if 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.max', local_var_params['media_images_content_length_max']))  # noqa: E501
        if 'media_images_format' in local_var_params and local_var_params['media_images_format'] is not None:  # noqa: E501
            query_params.append(('media.images.format[]', local_var_params['media_images_format']))  # noqa: E501
            collection_formats['media.images.format[]'] = 'multi'  # noqa: E501
        if 'not_media_images_format' in local_var_params and local_var_params['not_media_images_format'] is not None:  # noqa: E501
            query_params.append(('!media.images.format[]', local_var_params['not_media_images_format']))  # noqa: E501
            collection_formats['!media.images.format[]'] = 'multi'  # noqa: E501
        if 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.min', local_var_params['media_videos_count_min']))  # noqa: E501
        if 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.max', local_var_params['media_videos_count_max']))  # noqa: E501
        if 'author_id' in local_var_params and local_var_params['author_id'] is not None:  # noqa: E501
            query_params.append(('author.id[]', local_var_params['author_id']))  # noqa: E501
            collection_formats['author.id[]'] = 'multi'  # noqa: E501
        if 'not_author_id' in local_var_params and local_var_params['not_author_id'] is not None:  # noqa: E501
            query_params.append(('!author.id[]', local_var_params['not_author_id']))  # noqa: E501
            collection_formats['!author.id[]'] = 'multi'  # noqa: E501
        if 'author_name' in local_var_params and local_var_params['author_name'] is not None:  # noqa: E501
            query_params.append(('author.name', local_var_params['author_name']))  # noqa: E501
        if 'not_author_name' in local_var_params and local_var_params['not_author_name'] is not None:  # noqa: E501
            query_params.append(('!author.name', local_var_params['not_author_name']))  # noqa: E501
        if 'source_id' in local_var_params and local_var_params['source_id'] is not None:  # noqa: E501
            query_params.append(('source.id[]', local_var_params['source_id']))  # noqa: E501
            collection_formats['source.id[]'] = 'multi'  # noqa: E501
        if 'not_source_id' in local_var_params and local_var_params['not_source_id'] is not None:  # noqa: E501
            query_params.append(('!source.id[]', local_var_params['not_source_id']))  # noqa: E501
            collection_formats['!source.id[]'] = 'multi'  # noqa: E501
        if 'source_name' in local_var_params and local_var_params['source_name'] is not None:  # noqa: E501
            query_params.append(('source.name[]', local_var_params['source_name']))  # noqa: E501
            collection_formats['source.name[]'] = 'multi'  # noqa: E501
        if 'not_source_name' in local_var_params and local_var_params['not_source_name'] is not None:  # noqa: E501
            query_params.append(('!source.name[]', local_var_params['not_source_name']))  # noqa: E501
            collection_formats['!source.name[]'] = 'multi'  # noqa: E501
        if 'source_domain' in local_var_params and local_var_params['source_domain'] is not None:  # noqa: E501
            query_params.append(('source.domain[]', local_var_params['source_domain']))  # noqa: E501
            collection_formats['source.domain[]'] = 'multi'  # noqa: E501
        if 'not_source_domain' in local_var_params and local_var_params['not_source_domain'] is not None:  # noqa: E501
            query_params.append(('!source.domain[]', local_var_params['not_source_domain']))  # noqa: E501
            collection_formats['!source.domain[]'] = 'multi'  # noqa: E501
        if 'source_locations_country' in local_var_params and local_var_params['source_locations_country'] is not None:  # noqa: E501
            query_params.append(('source.locations.country[]', local_var_params['source_locations_country']))  # noqa: E501
            collection_formats['source.locations.country[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_country' in local_var_params and local_var_params['not_source_locations_country'] is not None:  # noqa: E501
            query_params.append(('!source.locations.country[]', local_var_params['not_source_locations_country']))  # noqa: E501
            collection_formats['!source.locations.country[]'] = 'multi'  # noqa: E501
        if 'source_locations_state' in local_var_params and local_var_params['source_locations_state'] is not None:  # noqa: E501
            query_params.append(('source.locations.state[]', local_var_params['source_locations_state']))  # noqa: E501
            collection_formats['source.locations.state[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_state' in local_var_params and local_var_params['not_source_locations_state'] is not None:  # noqa: E501
            query_params.append(('!source.locations.state[]', local_var_params['not_source_locations_state']))  # noqa: E501
            collection_formats['!source.locations.state[]'] = 'multi'  # noqa: E501
        if 'source_locations_city' in local_var_params and local_var_params['source_locations_city'] is not None:  # noqa: E501
            query_params.append(('source.locations.city[]', local_var_params['source_locations_city']))  # noqa: E501
            collection_formats['source.locations.city[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_city' in local_var_params and local_var_params['not_source_locations_city'] is not None:  # noqa: E501
            query_params.append(('!source.locations.city[]', local_var_params['not_source_locations_city']))  # noqa: E501
            collection_formats['!source.locations.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_country' in local_var_params and local_var_params['source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('source.scopes.country[]', local_var_params['source_scopes_country']))  # noqa: E501
            collection_formats['source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_country' in local_var_params and local_var_params['not_source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.country[]', local_var_params['not_source_scopes_country']))  # noqa: E501
            collection_formats['!source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'source_scopes_state' in local_var_params and local_var_params['source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('source.scopes.state[]', local_var_params['source_scopes_state']))  # noqa: E501
            collection_formats['source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_state' in local_var_params and local_var_params['not_source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.state[]', local_var_params['not_source_scopes_state']))  # noqa: E501
            collection_formats['!source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'source_scopes_city' in local_var_params and local_var_params['source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('source.scopes.city[]', local_var_params['source_scopes_city']))  # noqa: E501
            collection_formats['source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_city' in local_var_params and local_var_params['not_source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.city[]', local_var_params['not_source_scopes_city']))  # noqa: E501
            collection_formats['!source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_level' in local_var_params and local_var_params['source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('source.scopes.level[]', local_var_params['source_scopes_level']))  # noqa: E501
            collection_formats['source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_level' in local_var_params and local_var_params['not_source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.level[]', local_var_params['not_source_scopes_level']))  # noqa: E501
            collection_formats['!source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.min', local_var_params['source_links_in_count_min']))  # noqa: E501
        if 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.max', local_var_params['source_links_in_count_max']))  # noqa: E501
        if 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.min', local_var_params['source_rankings_alexa_rank_min']))  # noqa: E501
        if 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.max', local_var_params['source_rankings_alexa_rank_max']))  # noqa: E501
        if 'source_rankings_alexa_country' in local_var_params and local_var_params['source_rankings_alexa_country'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.country[]', local_var_params['source_rankings_alexa_country']))  # noqa: E501
            collection_formats['source.rankings.alexa.country[]'] = 'multi'  # noqa: E501
        if 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.min', local_var_params['social_shares_count_facebook_min']))  # noqa: E501
        if 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.max', local_var_params['social_shares_count_facebook_max']))  # noqa: E501
        if 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.min', local_var_params['social_shares_count_google_plus_min']))  # noqa: E501
        if 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.max', local_var_params['social_shares_count_google_plus_max']))  # noqa: E501
        if 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.min', local_var_params['social_shares_count_linkedin_min']))  # noqa: E501
        if 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.max', local_var_params['social_shares_count_linkedin_max']))  # noqa: E501
        if 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.min', local_var_params['social_shares_count_reddit_min']))  # noqa: E501
        if 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.max', local_var_params['social_shares_count_reddit_max']))  # noqa: E501
        if 'clusters' in local_var_params and local_var_params['clusters'] is not None:  # noqa: E501
            query_params.append(('clusters[]', local_var_params['clusters']))  # noqa: E501
            collection_formats['clusters[]'] = 'multi'  # noqa: E501
        if 'aql' in local_var_params and local_var_params['aql'] is not None:  # noqa: E501
            query_params.append(('aql', local_var_params['aql']))  # noqa: E501
        if 'aql_default_field' in local_var_params and local_var_params['aql_default_field'] is not None:  # noqa: E501
            query_params.append(('aql_default_field', local_var_params['aql_default_field']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'interval_start' in local_var_params and local_var_params['interval_start'] is not None:  # noqa: E501
            query_params.append(('interval.start', local_var_params['interval_start']))  # noqa: E501
        if 'interval_end' in local_var_params and local_var_params['interval_end'] is not None:  # noqa: E501
            query_params.append(('interval.end', local_var_params['interval_end']))  # noqa: E501
        if 'interval_width' in local_var_params and local_var_params['interval_width'] is not None:  # noqa: E501
            query_params.append(('interval.width', local_var_params['interval_width']))  # noqa: E501
        if 'field' in local_var_params and local_var_params['field'] is not None:  # noqa: E501
            query_params.append(('field', local_var_params['field']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/histograms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Histograms',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_related_stories_get(self, **kwargs):  # noqa: E501
        """list_related_stories_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_related_stories_get(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param story_id: A story id
        :type story_id: int
        :param story_url: An article or webpage
        :type story_url: str
        :param story_title: Title of the article
        :type story_title: str
        :param story_body: Body of the article
        :type story_body: str
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param boost_by: This parameter is used for boosting the result by the specified value. 
        :type boost_by: str
        :param story_language: This parameter is used for setting the language of the story. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type story_language: str
        :param per_page: This parameter is used for specifying number of items in each page. 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelatedStories
        """
        kwargs['_return_http_data_only'] = True
        return self.list_related_stories_get_with_http_info(**kwargs)  # noqa: E501

    def list_related_stories_get_with_http_info(self, **kwargs):  # noqa: E501
        """list_related_stories_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_related_stories_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param story_id: A story id
        :type story_id: int
        :param story_url: An article or webpage
        :type story_url: str
        :param story_title: Title of the article
        :type story_title: str
        :param story_body: Body of the article
        :type story_body: str
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param boost_by: This parameter is used for boosting the result by the specified value. 
        :type boost_by: str
        :param story_language: This parameter is used for setting the language of the story. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type story_language: str
        :param per_page: This parameter is used for specifying number of items in each page. 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelatedStories, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'not_id',
            'title',
            'body',
            'text',
            'translations_en_title',
            'translations_en_body',
            'translations_en_text',
            'links_permalink',
            'not_links_permalink',
            'language',
            'not_language',
            'published_at_start',
            'published_at_end',
            'categories_taxonomy',
            'categories_confident',
            'categories_id',
            'not_categories_id',
            'categories_label',
            'not_categories_label',
            'categories_level',
            'not_categories_level',
            'entities_id',
            'not_entities_id',
            'entities_links_wikipedia',
            'not_entities_links_wikipedia',
            'entities_links_wikidata',
            'not_entities_links_wikidata',
            'entities_types',
            'not_entities_types',
            'entities_stock_tickers',
            'entities_body_stock_tickers',
            'entities_surface_forms_text',
            'not_entities_surface_forms_text',
            'entities_title_surface_forms_text',
            'not_entities_title_surface_forms_text',
            'entities_body_surface_forms_text',
            'not_entities_body_surface_forms_text',
            'sentiment_title_polarity',
            'not_sentiment_title_polarity',
            'sentiment_body_polarity',
            'not_sentiment_body_polarity',
            'media_images_count_min',
            'media_images_count_max',
            'media_images_width_min',
            'media_images_width_max',
            'media_images_height_min',
            'media_images_height_max',
            'media_images_content_length_min',
            'media_images_content_length_max',
            'media_images_format',
            'not_media_images_format',
            'media_videos_count_min',
            'media_videos_count_max',
            'author_id',
            'not_author_id',
            'author_name',
            'not_author_name',
            'source_id',
            'not_source_id',
            'source_name',
            'not_source_name',
            'source_domain',
            'not_source_domain',
            'source_locations_country',
            'not_source_locations_country',
            'source_locations_state',
            'not_source_locations_state',
            'source_locations_city',
            'not_source_locations_city',
            'source_scopes_country',
            'not_source_scopes_country',
            'source_scopes_state',
            'not_source_scopes_state',
            'source_scopes_city',
            'not_source_scopes_city',
            'source_scopes_level',
            'not_source_scopes_level',
            'source_links_in_count_min',
            'source_links_in_count_max',
            'source_rankings_alexa_rank_min',
            'source_rankings_alexa_rank_max',
            'source_rankings_alexa_country',
            'social_shares_count_facebook_min',
            'social_shares_count_facebook_max',
            'social_shares_count_google_plus_min',
            'social_shares_count_google_plus_max',
            'social_shares_count_linkedin_min',
            'social_shares_count_linkedin_max',
            'social_shares_count_reddit_min',
            'social_shares_count_reddit_max',
            'clusters',
            '_return',
            'story_id',
            'story_url',
            'story_title',
            'story_body',
            'aql',
            'aql_default_field',
            'query',
            'boost_by',
            'story_language',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_related_stories_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_min` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_max` when calling `list_related_stories_get`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_related_stories_get`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_related_stories_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'body' in local_var_params and local_var_params['body'] is not None:  # noqa: E501
            query_params.append(('body', local_var_params['body']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'translations_en_title' in local_var_params and local_var_params['translations_en_title'] is not None:  # noqa: E501
            query_params.append(('translations.en.title', local_var_params['translations_en_title']))  # noqa: E501
        if 'translations_en_body' in local_var_params and local_var_params['translations_en_body'] is not None:  # noqa: E501
            query_params.append(('translations.en.body', local_var_params['translations_en_body']))  # noqa: E501
        if 'translations_en_text' in local_var_params and local_var_params['translations_en_text'] is not None:  # noqa: E501
            query_params.append(('translations.en.text', local_var_params['translations_en_text']))  # noqa: E501
        if 'links_permalink' in local_var_params and local_var_params['links_permalink'] is not None:  # noqa: E501
            query_params.append(('links.permalink[]', local_var_params['links_permalink']))  # noqa: E501
            collection_formats['links.permalink[]'] = 'multi'  # noqa: E501
        if 'not_links_permalink' in local_var_params and local_var_params['not_links_permalink'] is not None:  # noqa: E501
            query_params.append(('!links.permalink[]', local_var_params['not_links_permalink']))  # noqa: E501
            collection_formats['!links.permalink[]'] = 'multi'  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language[]', local_var_params['language']))  # noqa: E501
            collection_formats['language[]'] = 'multi'  # noqa: E501
        if 'not_language' in local_var_params and local_var_params['not_language'] is not None:  # noqa: E501
            query_params.append(('!language[]', local_var_params['not_language']))  # noqa: E501
            collection_formats['!language[]'] = 'multi'  # noqa: E501
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if 'categories_taxonomy' in local_var_params and local_var_params['categories_taxonomy'] is not None:  # noqa: E501
            query_params.append(('categories.taxonomy', local_var_params['categories_taxonomy']))  # noqa: E501
        if 'categories_confident' in local_var_params and local_var_params['categories_confident'] is not None:  # noqa: E501
            query_params.append(('categories.confident', local_var_params['categories_confident']))  # noqa: E501
        if 'categories_id' in local_var_params and local_var_params['categories_id'] is not None:  # noqa: E501
            query_params.append(('categories.id[]', local_var_params['categories_id']))  # noqa: E501
            collection_formats['categories.id[]'] = 'multi'  # noqa: E501
        if 'not_categories_id' in local_var_params and local_var_params['not_categories_id'] is not None:  # noqa: E501
            query_params.append(('!categories.id[]', local_var_params['not_categories_id']))  # noqa: E501
            collection_formats['!categories.id[]'] = 'multi'  # noqa: E501
        if 'categories_label' in local_var_params and local_var_params['categories_label'] is not None:  # noqa: E501
            query_params.append(('categories.label[]', local_var_params['categories_label']))  # noqa: E501
            collection_formats['categories.label[]'] = 'multi'  # noqa: E501
        if 'not_categories_label' in local_var_params and local_var_params['not_categories_label'] is not None:  # noqa: E501
            query_params.append(('!categories.label[]', local_var_params['not_categories_label']))  # noqa: E501
            collection_formats['!categories.label[]'] = 'multi'  # noqa: E501
        if 'categories_level' in local_var_params and local_var_params['categories_level'] is not None:  # noqa: E501
            query_params.append(('categories.level[]', local_var_params['categories_level']))  # noqa: E501
            collection_formats['categories.level[]'] = 'multi'  # noqa: E501
        if 'not_categories_level' in local_var_params and local_var_params['not_categories_level'] is not None:  # noqa: E501
            query_params.append(('!categories.level[]', local_var_params['not_categories_level']))  # noqa: E501
            collection_formats['!categories.level[]'] = 'multi'  # noqa: E501
        if 'entities_id' in local_var_params and local_var_params['entities_id'] is not None:  # noqa: E501
            query_params.append(('entities.id[]', local_var_params['entities_id']))  # noqa: E501
            collection_formats['entities.id[]'] = 'multi'  # noqa: E501
        if 'not_entities_id' in local_var_params and local_var_params['not_entities_id'] is not None:  # noqa: E501
            query_params.append(('!entities.id[]', local_var_params['not_entities_id']))  # noqa: E501
            collection_formats['!entities.id[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikipedia' in local_var_params and local_var_params['entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikipedia[]', local_var_params['entities_links_wikipedia']))  # noqa: E501
            collection_formats['entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikipedia' in local_var_params and local_var_params['not_entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikipedia[]', local_var_params['not_entities_links_wikipedia']))  # noqa: E501
            collection_formats['!entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikidata' in local_var_params and local_var_params['entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikidata[]', local_var_params['entities_links_wikidata']))  # noqa: E501
            collection_formats['entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikidata' in local_var_params and local_var_params['not_entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikidata[]', local_var_params['not_entities_links_wikidata']))  # noqa: E501
            collection_formats['!entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'entities_types' in local_var_params and local_var_params['entities_types'] is not None:  # noqa: E501
            query_params.append(('entities.types[]', local_var_params['entities_types']))  # noqa: E501
            collection_formats['entities.types[]'] = 'multi'  # noqa: E501
        if 'not_entities_types' in local_var_params and local_var_params['not_entities_types'] is not None:  # noqa: E501
            query_params.append(('!entities.types[]', local_var_params['not_entities_types']))  # noqa: E501
            collection_formats['!entities.types[]'] = 'multi'  # noqa: E501
        if 'entities_stock_tickers' in local_var_params and local_var_params['entities_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('entities.stock_tickers[]', local_var_params['entities_stock_tickers']))  # noqa: E501
            collection_formats['entities.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_body_stock_tickers' in local_var_params and local_var_params['entities_body_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('!entities.body.stock_tickers[]', local_var_params['entities_body_stock_tickers']))  # noqa: E501
            collection_formats['!entities.body.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_surface_forms_text' in local_var_params and local_var_params['entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.surface_forms.text[]', local_var_params['entities_surface_forms_text']))  # noqa: E501
            collection_formats['entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_surface_forms_text' in local_var_params and local_var_params['not_entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.surface_forms.text[]', local_var_params['not_entities_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_title_surface_forms_text' in local_var_params and local_var_params['entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.title.surface_forms.text[]', local_var_params['entities_title_surface_forms_text']))  # noqa: E501
        if 'not_entities_title_surface_forms_text' in local_var_params and local_var_params['not_entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.title.surface_forms.text[]', local_var_params['not_entities_title_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.title.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_body_surface_forms_text' in local_var_params and local_var_params['entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.body.surface_forms.text[]', local_var_params['entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_body_surface_forms_text' in local_var_params and local_var_params['not_entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.body.surface_forms.text[]', local_var_params['not_entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'sentiment_title_polarity' in local_var_params and local_var_params['sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.title.polarity', local_var_params['sentiment_title_polarity']))  # noqa: E501
        if 'not_sentiment_title_polarity' in local_var_params and local_var_params['not_sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.title.polarity', local_var_params['not_sentiment_title_polarity']))  # noqa: E501
        if 'sentiment_body_polarity' in local_var_params and local_var_params['sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.body.polarity', local_var_params['sentiment_body_polarity']))  # noqa: E501
        if 'not_sentiment_body_polarity' in local_var_params and local_var_params['not_sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.body.polarity', local_var_params['not_sentiment_body_polarity']))  # noqa: E501
        if 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] is not None:  # noqa: E501
            query_params.append(('media.images.count.min', local_var_params['media_images_count_min']))  # noqa: E501
        if 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] is not None:  # noqa: E501
            query_params.append(('media.images.count.max', local_var_params['media_images_count_max']))  # noqa: E501
        if 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] is not None:  # noqa: E501
            query_params.append(('media.images.width.min', local_var_params['media_images_width_min']))  # noqa: E501
        if 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] is not None:  # noqa: E501
            query_params.append(('media.images.width.max', local_var_params['media_images_width_max']))  # noqa: E501
        if 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] is not None:  # noqa: E501
            query_params.append(('media.images.height.min', local_var_params['media_images_height_min']))  # noqa: E501
        if 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] is not None:  # noqa: E501
            query_params.append(('media.images.height.max', local_var_params['media_images_height_max']))  # noqa: E501
        if 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.min', local_var_params['media_images_content_length_min']))  # noqa: E501
        if 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.max', local_var_params['media_images_content_length_max']))  # noqa: E501
        if 'media_images_format' in local_var_params and local_var_params['media_images_format'] is not None:  # noqa: E501
            query_params.append(('media.images.format[]', local_var_params['media_images_format']))  # noqa: E501
            collection_formats['media.images.format[]'] = 'multi'  # noqa: E501
        if 'not_media_images_format' in local_var_params and local_var_params['not_media_images_format'] is not None:  # noqa: E501
            query_params.append(('!media.images.format[]', local_var_params['not_media_images_format']))  # noqa: E501
            collection_formats['!media.images.format[]'] = 'multi'  # noqa: E501
        if 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.min', local_var_params['media_videos_count_min']))  # noqa: E501
        if 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.max', local_var_params['media_videos_count_max']))  # noqa: E501
        if 'author_id' in local_var_params and local_var_params['author_id'] is not None:  # noqa: E501
            query_params.append(('author.id[]', local_var_params['author_id']))  # noqa: E501
            collection_formats['author.id[]'] = 'multi'  # noqa: E501
        if 'not_author_id' in local_var_params and local_var_params['not_author_id'] is not None:  # noqa: E501
            query_params.append(('!author.id[]', local_var_params['not_author_id']))  # noqa: E501
            collection_formats['!author.id[]'] = 'multi'  # noqa: E501
        if 'author_name' in local_var_params and local_var_params['author_name'] is not None:  # noqa: E501
            query_params.append(('author.name', local_var_params['author_name']))  # noqa: E501
        if 'not_author_name' in local_var_params and local_var_params['not_author_name'] is not None:  # noqa: E501
            query_params.append(('!author.name', local_var_params['not_author_name']))  # noqa: E501
        if 'source_id' in local_var_params and local_var_params['source_id'] is not None:  # noqa: E501
            query_params.append(('source.id[]', local_var_params['source_id']))  # noqa: E501
            collection_formats['source.id[]'] = 'multi'  # noqa: E501
        if 'not_source_id' in local_var_params and local_var_params['not_source_id'] is not None:  # noqa: E501
            query_params.append(('!source.id[]', local_var_params['not_source_id']))  # noqa: E501
            collection_formats['!source.id[]'] = 'multi'  # noqa: E501
        if 'source_name' in local_var_params and local_var_params['source_name'] is not None:  # noqa: E501
            query_params.append(('source.name[]', local_var_params['source_name']))  # noqa: E501
            collection_formats['source.name[]'] = 'multi'  # noqa: E501
        if 'not_source_name' in local_var_params and local_var_params['not_source_name'] is not None:  # noqa: E501
            query_params.append(('!source.name[]', local_var_params['not_source_name']))  # noqa: E501
            collection_formats['!source.name[]'] = 'multi'  # noqa: E501
        if 'source_domain' in local_var_params and local_var_params['source_domain'] is not None:  # noqa: E501
            query_params.append(('source.domain[]', local_var_params['source_domain']))  # noqa: E501
            collection_formats['source.domain[]'] = 'multi'  # noqa: E501
        if 'not_source_domain' in local_var_params and local_var_params['not_source_domain'] is not None:  # noqa: E501
            query_params.append(('!source.domain[]', local_var_params['not_source_domain']))  # noqa: E501
            collection_formats['!source.domain[]'] = 'multi'  # noqa: E501
        if 'source_locations_country' in local_var_params and local_var_params['source_locations_country'] is not None:  # noqa: E501
            query_params.append(('source.locations.country[]', local_var_params['source_locations_country']))  # noqa: E501
            collection_formats['source.locations.country[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_country' in local_var_params and local_var_params['not_source_locations_country'] is not None:  # noqa: E501
            query_params.append(('!source.locations.country[]', local_var_params['not_source_locations_country']))  # noqa: E501
            collection_formats['!source.locations.country[]'] = 'multi'  # noqa: E501
        if 'source_locations_state' in local_var_params and local_var_params['source_locations_state'] is not None:  # noqa: E501
            query_params.append(('source.locations.state[]', local_var_params['source_locations_state']))  # noqa: E501
            collection_formats['source.locations.state[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_state' in local_var_params and local_var_params['not_source_locations_state'] is not None:  # noqa: E501
            query_params.append(('!source.locations.state[]', local_var_params['not_source_locations_state']))  # noqa: E501
            collection_formats['!source.locations.state[]'] = 'multi'  # noqa: E501
        if 'source_locations_city' in local_var_params and local_var_params['source_locations_city'] is not None:  # noqa: E501
            query_params.append(('source.locations.city[]', local_var_params['source_locations_city']))  # noqa: E501
            collection_formats['source.locations.city[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_city' in local_var_params and local_var_params['not_source_locations_city'] is not None:  # noqa: E501
            query_params.append(('!source.locations.city[]', local_var_params['not_source_locations_city']))  # noqa: E501
            collection_formats['!source.locations.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_country' in local_var_params and local_var_params['source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('source.scopes.country[]', local_var_params['source_scopes_country']))  # noqa: E501
            collection_formats['source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_country' in local_var_params and local_var_params['not_source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.country[]', local_var_params['not_source_scopes_country']))  # noqa: E501
            collection_formats['!source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'source_scopes_state' in local_var_params and local_var_params['source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('source.scopes.state[]', local_var_params['source_scopes_state']))  # noqa: E501
            collection_formats['source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_state' in local_var_params and local_var_params['not_source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.state[]', local_var_params['not_source_scopes_state']))  # noqa: E501
            collection_formats['!source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'source_scopes_city' in local_var_params and local_var_params['source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('source.scopes.city[]', local_var_params['source_scopes_city']))  # noqa: E501
            collection_formats['source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_city' in local_var_params and local_var_params['not_source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.city[]', local_var_params['not_source_scopes_city']))  # noqa: E501
            collection_formats['!source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_level' in local_var_params and local_var_params['source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('source.scopes.level[]', local_var_params['source_scopes_level']))  # noqa: E501
            collection_formats['source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_level' in local_var_params and local_var_params['not_source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.level[]', local_var_params['not_source_scopes_level']))  # noqa: E501
            collection_formats['!source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.min', local_var_params['source_links_in_count_min']))  # noqa: E501
        if 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.max', local_var_params['source_links_in_count_max']))  # noqa: E501
        if 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.min', local_var_params['source_rankings_alexa_rank_min']))  # noqa: E501
        if 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.max', local_var_params['source_rankings_alexa_rank_max']))  # noqa: E501
        if 'source_rankings_alexa_country' in local_var_params and local_var_params['source_rankings_alexa_country'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.country[]', local_var_params['source_rankings_alexa_country']))  # noqa: E501
            collection_formats['source.rankings.alexa.country[]'] = 'multi'  # noqa: E501
        if 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.min', local_var_params['social_shares_count_facebook_min']))  # noqa: E501
        if 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.max', local_var_params['social_shares_count_facebook_max']))  # noqa: E501
        if 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.min', local_var_params['social_shares_count_google_plus_min']))  # noqa: E501
        if 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.max', local_var_params['social_shares_count_google_plus_max']))  # noqa: E501
        if 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.min', local_var_params['social_shares_count_linkedin_min']))  # noqa: E501
        if 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.max', local_var_params['social_shares_count_linkedin_max']))  # noqa: E501
        if 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.min', local_var_params['social_shares_count_reddit_min']))  # noqa: E501
        if 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.max', local_var_params['social_shares_count_reddit_max']))  # noqa: E501
        if 'clusters' in local_var_params and local_var_params['clusters'] is not None:  # noqa: E501
            query_params.append(('clusters[]', local_var_params['clusters']))  # noqa: E501
            collection_formats['clusters[]'] = 'multi'  # noqa: E501
        if '_return' in local_var_params and local_var_params['_return'] is not None:  # noqa: E501
            query_params.append(('return[]', local_var_params['_return']))  # noqa: E501
            collection_formats['return[]'] = 'multi'  # noqa: E501
        if 'story_id' in local_var_params and local_var_params['story_id'] is not None:  # noqa: E501
            query_params.append(('story_id', local_var_params['story_id']))  # noqa: E501
        if 'story_url' in local_var_params and local_var_params['story_url'] is not None:  # noqa: E501
            query_params.append(('story_url', local_var_params['story_url']))  # noqa: E501
        if 'story_title' in local_var_params and local_var_params['story_title'] is not None:  # noqa: E501
            query_params.append(('story_title', local_var_params['story_title']))  # noqa: E501
        if 'story_body' in local_var_params and local_var_params['story_body'] is not None:  # noqa: E501
            query_params.append(('story_body', local_var_params['story_body']))  # noqa: E501
        if 'aql' in local_var_params and local_var_params['aql'] is not None:  # noqa: E501
            query_params.append(('aql', local_var_params['aql']))  # noqa: E501
        if 'aql_default_field' in local_var_params and local_var_params['aql_default_field'] is not None:  # noqa: E501
            query_params.append(('aql_default_field', local_var_params['aql_default_field']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'boost_by' in local_var_params and local_var_params['boost_by'] is not None:  # noqa: E501
            query_params.append(('boost_by', local_var_params['boost_by']))  # noqa: E501
        if 'story_language' in local_var_params and local_var_params['story_language'] is not None:  # noqa: E501
            query_params.append(('story_language', local_var_params['story_language']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/related_stories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RelatedStories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_related_stories_post(self, **kwargs):  # noqa: E501
        """list_related_stories_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_related_stories_post(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param story_id: A story id
        :type story_id: int
        :param story_url: An article or webpage
        :type story_url: str
        :param story_title: Title of the article
        :type story_title: str
        :param story_body: Body of the article
        :type story_body: str
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param boost_by: This parameter is used for boosting the result by the specified value. 
        :type boost_by: str
        :param story_language: This parameter is used for setting the language of the story. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type story_language: str
        :param per_page: This parameter is used for specifying number of items in each page. 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelatedStories
        """
        kwargs['_return_http_data_only'] = True
        return self.list_related_stories_post_with_http_info(**kwargs)  # noqa: E501

    def list_related_stories_post_with_http_info(self, **kwargs):  # noqa: E501
        """list_related_stories_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_related_stories_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param story_id: A story id
        :type story_id: int
        :param story_url: An article or webpage
        :type story_url: str
        :param story_title: Title of the article
        :type story_title: str
        :param story_body: Body of the article
        :type story_body: str
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param boost_by: This parameter is used for boosting the result by the specified value. 
        :type boost_by: str
        :param story_language: This parameter is used for setting the language of the story. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type story_language: str
        :param per_page: This parameter is used for specifying number of items in each page. 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelatedStories, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'not_id',
            'title',
            'body',
            'text',
            'translations_en_title',
            'translations_en_body',
            'translations_en_text',
            'links_permalink',
            'not_links_permalink',
            'language',
            'not_language',
            'published_at_start',
            'published_at_end',
            'categories_taxonomy',
            'categories_confident',
            'categories_id',
            'not_categories_id',
            'categories_label',
            'not_categories_label',
            'categories_level',
            'not_categories_level',
            'entities_id',
            'not_entities_id',
            'entities_links_wikipedia',
            'not_entities_links_wikipedia',
            'entities_links_wikidata',
            'not_entities_links_wikidata',
            'entities_types',
            'not_entities_types',
            'entities_stock_tickers',
            'entities_body_stock_tickers',
            'entities_surface_forms_text',
            'not_entities_surface_forms_text',
            'entities_title_surface_forms_text',
            'not_entities_title_surface_forms_text',
            'entities_body_surface_forms_text',
            'not_entities_body_surface_forms_text',
            'sentiment_title_polarity',
            'not_sentiment_title_polarity',
            'sentiment_body_polarity',
            'not_sentiment_body_polarity',
            'media_images_count_min',
            'media_images_count_max',
            'media_images_width_min',
            'media_images_width_max',
            'media_images_height_min',
            'media_images_height_max',
            'media_images_content_length_min',
            'media_images_content_length_max',
            'media_images_format',
            'not_media_images_format',
            'media_videos_count_min',
            'media_videos_count_max',
            'author_id',
            'not_author_id',
            'author_name',
            'not_author_name',
            'source_id',
            'not_source_id',
            'source_name',
            'not_source_name',
            'source_domain',
            'not_source_domain',
            'source_locations_country',
            'not_source_locations_country',
            'source_locations_state',
            'not_source_locations_state',
            'source_locations_city',
            'not_source_locations_city',
            'source_scopes_country',
            'not_source_scopes_country',
            'source_scopes_state',
            'not_source_scopes_state',
            'source_scopes_city',
            'not_source_scopes_city',
            'source_scopes_level',
            'not_source_scopes_level',
            'source_links_in_count_min',
            'source_links_in_count_max',
            'source_rankings_alexa_rank_min',
            'source_rankings_alexa_rank_max',
            'source_rankings_alexa_country',
            'social_shares_count_facebook_min',
            'social_shares_count_facebook_max',
            'social_shares_count_google_plus_min',
            'social_shares_count_google_plus_max',
            'social_shares_count_linkedin_min',
            'social_shares_count_linkedin_max',
            'social_shares_count_reddit_min',
            'social_shares_count_reddit_max',
            'clusters',
            '_return',
            'story_id',
            'story_url',
            'story_title',
            'story_body',
            'aql',
            'aql_default_field',
            'query',
            'boost_by',
            'story_language',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_related_stories_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_min` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_max` when calling `list_related_stories_post`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_related_stories_post`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_related_stories_post`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'body' in local_var_params and local_var_params['body'] is not None:  # noqa: E501
            query_params.append(('body', local_var_params['body']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'translations_en_title' in local_var_params and local_var_params['translations_en_title'] is not None:  # noqa: E501
            query_params.append(('translations.en.title', local_var_params['translations_en_title']))  # noqa: E501
        if 'translations_en_body' in local_var_params and local_var_params['translations_en_body'] is not None:  # noqa: E501
            query_params.append(('translations.en.body', local_var_params['translations_en_body']))  # noqa: E501
        if 'translations_en_text' in local_var_params and local_var_params['translations_en_text'] is not None:  # noqa: E501
            query_params.append(('translations.en.text', local_var_params['translations_en_text']))  # noqa: E501
        if 'links_permalink' in local_var_params and local_var_params['links_permalink'] is not None:  # noqa: E501
            query_params.append(('links.permalink[]', local_var_params['links_permalink']))  # noqa: E501
            collection_formats['links.permalink[]'] = 'multi'  # noqa: E501
        if 'not_links_permalink' in local_var_params and local_var_params['not_links_permalink'] is not None:  # noqa: E501
            query_params.append(('!links.permalink[]', local_var_params['not_links_permalink']))  # noqa: E501
            collection_formats['!links.permalink[]'] = 'multi'  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language[]', local_var_params['language']))  # noqa: E501
            collection_formats['language[]'] = 'multi'  # noqa: E501
        if 'not_language' in local_var_params and local_var_params['not_language'] is not None:  # noqa: E501
            query_params.append(('!language[]', local_var_params['not_language']))  # noqa: E501
            collection_formats['!language[]'] = 'multi'  # noqa: E501
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if 'categories_taxonomy' in local_var_params and local_var_params['categories_taxonomy'] is not None:  # noqa: E501
            query_params.append(('categories.taxonomy', local_var_params['categories_taxonomy']))  # noqa: E501
        if 'categories_confident' in local_var_params and local_var_params['categories_confident'] is not None:  # noqa: E501
            query_params.append(('categories.confident', local_var_params['categories_confident']))  # noqa: E501
        if 'categories_id' in local_var_params and local_var_params['categories_id'] is not None:  # noqa: E501
            query_params.append(('categories.id[]', local_var_params['categories_id']))  # noqa: E501
            collection_formats['categories.id[]'] = 'multi'  # noqa: E501
        if 'not_categories_id' in local_var_params and local_var_params['not_categories_id'] is not None:  # noqa: E501
            query_params.append(('!categories.id[]', local_var_params['not_categories_id']))  # noqa: E501
            collection_formats['!categories.id[]'] = 'multi'  # noqa: E501
        if 'categories_label' in local_var_params and local_var_params['categories_label'] is not None:  # noqa: E501
            query_params.append(('categories.label[]', local_var_params['categories_label']))  # noqa: E501
            collection_formats['categories.label[]'] = 'multi'  # noqa: E501
        if 'not_categories_label' in local_var_params and local_var_params['not_categories_label'] is not None:  # noqa: E501
            query_params.append(('!categories.label[]', local_var_params['not_categories_label']))  # noqa: E501
            collection_formats['!categories.label[]'] = 'multi'  # noqa: E501
        if 'categories_level' in local_var_params and local_var_params['categories_level'] is not None:  # noqa: E501
            query_params.append(('categories.level[]', local_var_params['categories_level']))  # noqa: E501
            collection_formats['categories.level[]'] = 'multi'  # noqa: E501
        if 'not_categories_level' in local_var_params and local_var_params['not_categories_level'] is not None:  # noqa: E501
            query_params.append(('!categories.level[]', local_var_params['not_categories_level']))  # noqa: E501
            collection_formats['!categories.level[]'] = 'multi'  # noqa: E501
        if 'entities_id' in local_var_params and local_var_params['entities_id'] is not None:  # noqa: E501
            query_params.append(('entities.id[]', local_var_params['entities_id']))  # noqa: E501
            collection_formats['entities.id[]'] = 'multi'  # noqa: E501
        if 'not_entities_id' in local_var_params and local_var_params['not_entities_id'] is not None:  # noqa: E501
            query_params.append(('!entities.id[]', local_var_params['not_entities_id']))  # noqa: E501
            collection_formats['!entities.id[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikipedia' in local_var_params and local_var_params['entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikipedia[]', local_var_params['entities_links_wikipedia']))  # noqa: E501
            collection_formats['entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikipedia' in local_var_params and local_var_params['not_entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikipedia[]', local_var_params['not_entities_links_wikipedia']))  # noqa: E501
            collection_formats['!entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikidata' in local_var_params and local_var_params['entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikidata[]', local_var_params['entities_links_wikidata']))  # noqa: E501
            collection_formats['entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikidata' in local_var_params and local_var_params['not_entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikidata[]', local_var_params['not_entities_links_wikidata']))  # noqa: E501
            collection_formats['!entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'entities_types' in local_var_params and local_var_params['entities_types'] is not None:  # noqa: E501
            query_params.append(('entities.types[]', local_var_params['entities_types']))  # noqa: E501
            collection_formats['entities.types[]'] = 'multi'  # noqa: E501
        if 'not_entities_types' in local_var_params and local_var_params['not_entities_types'] is not None:  # noqa: E501
            query_params.append(('!entities.types[]', local_var_params['not_entities_types']))  # noqa: E501
            collection_formats['!entities.types[]'] = 'multi'  # noqa: E501
        if 'entities_stock_tickers' in local_var_params and local_var_params['entities_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('entities.stock_tickers[]', local_var_params['entities_stock_tickers']))  # noqa: E501
            collection_formats['entities.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_body_stock_tickers' in local_var_params and local_var_params['entities_body_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('!entities.body.stock_tickers[]', local_var_params['entities_body_stock_tickers']))  # noqa: E501
            collection_formats['!entities.body.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_surface_forms_text' in local_var_params and local_var_params['entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.surface_forms.text[]', local_var_params['entities_surface_forms_text']))  # noqa: E501
            collection_formats['entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_surface_forms_text' in local_var_params and local_var_params['not_entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.surface_forms.text[]', local_var_params['not_entities_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_title_surface_forms_text' in local_var_params and local_var_params['entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.title.surface_forms.text[]', local_var_params['entities_title_surface_forms_text']))  # noqa: E501
        if 'not_entities_title_surface_forms_text' in local_var_params and local_var_params['not_entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.title.surface_forms.text[]', local_var_params['not_entities_title_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.title.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_body_surface_forms_text' in local_var_params and local_var_params['entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.body.surface_forms.text[]', local_var_params['entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_body_surface_forms_text' in local_var_params and local_var_params['not_entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.body.surface_forms.text[]', local_var_params['not_entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'sentiment_title_polarity' in local_var_params and local_var_params['sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.title.polarity', local_var_params['sentiment_title_polarity']))  # noqa: E501
        if 'not_sentiment_title_polarity' in local_var_params and local_var_params['not_sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.title.polarity', local_var_params['not_sentiment_title_polarity']))  # noqa: E501
        if 'sentiment_body_polarity' in local_var_params and local_var_params['sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.body.polarity', local_var_params['sentiment_body_polarity']))  # noqa: E501
        if 'not_sentiment_body_polarity' in local_var_params and local_var_params['not_sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.body.polarity', local_var_params['not_sentiment_body_polarity']))  # noqa: E501
        if 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] is not None:  # noqa: E501
            query_params.append(('media.images.count.min', local_var_params['media_images_count_min']))  # noqa: E501
        if 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] is not None:  # noqa: E501
            query_params.append(('media.images.count.max', local_var_params['media_images_count_max']))  # noqa: E501
        if 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] is not None:  # noqa: E501
            query_params.append(('media.images.width.min', local_var_params['media_images_width_min']))  # noqa: E501
        if 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] is not None:  # noqa: E501
            query_params.append(('media.images.width.max', local_var_params['media_images_width_max']))  # noqa: E501
        if 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] is not None:  # noqa: E501
            query_params.append(('media.images.height.min', local_var_params['media_images_height_min']))  # noqa: E501
        if 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] is not None:  # noqa: E501
            query_params.append(('media.images.height.max', local_var_params['media_images_height_max']))  # noqa: E501
        if 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.min', local_var_params['media_images_content_length_min']))  # noqa: E501
        if 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.max', local_var_params['media_images_content_length_max']))  # noqa: E501
        if 'media_images_format' in local_var_params and local_var_params['media_images_format'] is not None:  # noqa: E501
            query_params.append(('media.images.format[]', local_var_params['media_images_format']))  # noqa: E501
            collection_formats['media.images.format[]'] = 'multi'  # noqa: E501
        if 'not_media_images_format' in local_var_params and local_var_params['not_media_images_format'] is not None:  # noqa: E501
            query_params.append(('!media.images.format[]', local_var_params['not_media_images_format']))  # noqa: E501
            collection_formats['!media.images.format[]'] = 'multi'  # noqa: E501
        if 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.min', local_var_params['media_videos_count_min']))  # noqa: E501
        if 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.max', local_var_params['media_videos_count_max']))  # noqa: E501
        if 'author_id' in local_var_params and local_var_params['author_id'] is not None:  # noqa: E501
            query_params.append(('author.id[]', local_var_params['author_id']))  # noqa: E501
            collection_formats['author.id[]'] = 'multi'  # noqa: E501
        if 'not_author_id' in local_var_params and local_var_params['not_author_id'] is not None:  # noqa: E501
            query_params.append(('!author.id[]', local_var_params['not_author_id']))  # noqa: E501
            collection_formats['!author.id[]'] = 'multi'  # noqa: E501
        if 'author_name' in local_var_params and local_var_params['author_name'] is not None:  # noqa: E501
            query_params.append(('author.name', local_var_params['author_name']))  # noqa: E501
        if 'not_author_name' in local_var_params and local_var_params['not_author_name'] is not None:  # noqa: E501
            query_params.append(('!author.name', local_var_params['not_author_name']))  # noqa: E501
        if 'source_id' in local_var_params and local_var_params['source_id'] is not None:  # noqa: E501
            query_params.append(('source.id[]', local_var_params['source_id']))  # noqa: E501
            collection_formats['source.id[]'] = 'multi'  # noqa: E501
        if 'not_source_id' in local_var_params and local_var_params['not_source_id'] is not None:  # noqa: E501
            query_params.append(('!source.id[]', local_var_params['not_source_id']))  # noqa: E501
            collection_formats['!source.id[]'] = 'multi'  # noqa: E501
        if 'source_name' in local_var_params and local_var_params['source_name'] is not None:  # noqa: E501
            query_params.append(('source.name[]', local_var_params['source_name']))  # noqa: E501
            collection_formats['source.name[]'] = 'multi'  # noqa: E501
        if 'not_source_name' in local_var_params and local_var_params['not_source_name'] is not None:  # noqa: E501
            query_params.append(('!source.name[]', local_var_params['not_source_name']))  # noqa: E501
            collection_formats['!source.name[]'] = 'multi'  # noqa: E501
        if 'source_domain' in local_var_params and local_var_params['source_domain'] is not None:  # noqa: E501
            query_params.append(('source.domain[]', local_var_params['source_domain']))  # noqa: E501
            collection_formats['source.domain[]'] = 'multi'  # noqa: E501
        if 'not_source_domain' in local_var_params and local_var_params['not_source_domain'] is not None:  # noqa: E501
            query_params.append(('!source.domain[]', local_var_params['not_source_domain']))  # noqa: E501
            collection_formats['!source.domain[]'] = 'multi'  # noqa: E501
        if 'source_locations_country' in local_var_params and local_var_params['source_locations_country'] is not None:  # noqa: E501
            query_params.append(('source.locations.country[]', local_var_params['source_locations_country']))  # noqa: E501
            collection_formats['source.locations.country[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_country' in local_var_params and local_var_params['not_source_locations_country'] is not None:  # noqa: E501
            query_params.append(('!source.locations.country[]', local_var_params['not_source_locations_country']))  # noqa: E501
            collection_formats['!source.locations.country[]'] = 'multi'  # noqa: E501
        if 'source_locations_state' in local_var_params and local_var_params['source_locations_state'] is not None:  # noqa: E501
            query_params.append(('source.locations.state[]', local_var_params['source_locations_state']))  # noqa: E501
            collection_formats['source.locations.state[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_state' in local_var_params and local_var_params['not_source_locations_state'] is not None:  # noqa: E501
            query_params.append(('!source.locations.state[]', local_var_params['not_source_locations_state']))  # noqa: E501
            collection_formats['!source.locations.state[]'] = 'multi'  # noqa: E501
        if 'source_locations_city' in local_var_params and local_var_params['source_locations_city'] is not None:  # noqa: E501
            query_params.append(('source.locations.city[]', local_var_params['source_locations_city']))  # noqa: E501
            collection_formats['source.locations.city[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_city' in local_var_params and local_var_params['not_source_locations_city'] is not None:  # noqa: E501
            query_params.append(('!source.locations.city[]', local_var_params['not_source_locations_city']))  # noqa: E501
            collection_formats['!source.locations.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_country' in local_var_params and local_var_params['source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('source.scopes.country[]', local_var_params['source_scopes_country']))  # noqa: E501
            collection_formats['source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_country' in local_var_params and local_var_params['not_source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.country[]', local_var_params['not_source_scopes_country']))  # noqa: E501
            collection_formats['!source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'source_scopes_state' in local_var_params and local_var_params['source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('source.scopes.state[]', local_var_params['source_scopes_state']))  # noqa: E501
            collection_formats['source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_state' in local_var_params and local_var_params['not_source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.state[]', local_var_params['not_source_scopes_state']))  # noqa: E501
            collection_formats['!source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'source_scopes_city' in local_var_params and local_var_params['source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('source.scopes.city[]', local_var_params['source_scopes_city']))  # noqa: E501
            collection_formats['source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_city' in local_var_params and local_var_params['not_source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.city[]', local_var_params['not_source_scopes_city']))  # noqa: E501
            collection_formats['!source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_level' in local_var_params and local_var_params['source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('source.scopes.level[]', local_var_params['source_scopes_level']))  # noqa: E501
            collection_formats['source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_level' in local_var_params and local_var_params['not_source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.level[]', local_var_params['not_source_scopes_level']))  # noqa: E501
            collection_formats['!source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.min', local_var_params['source_links_in_count_min']))  # noqa: E501
        if 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.max', local_var_params['source_links_in_count_max']))  # noqa: E501
        if 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.min', local_var_params['source_rankings_alexa_rank_min']))  # noqa: E501
        if 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.max', local_var_params['source_rankings_alexa_rank_max']))  # noqa: E501
        if 'source_rankings_alexa_country' in local_var_params and local_var_params['source_rankings_alexa_country'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.country[]', local_var_params['source_rankings_alexa_country']))  # noqa: E501
            collection_formats['source.rankings.alexa.country[]'] = 'multi'  # noqa: E501
        if 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.min', local_var_params['social_shares_count_facebook_min']))  # noqa: E501
        if 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.max', local_var_params['social_shares_count_facebook_max']))  # noqa: E501
        if 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.min', local_var_params['social_shares_count_google_plus_min']))  # noqa: E501
        if 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.max', local_var_params['social_shares_count_google_plus_max']))  # noqa: E501
        if 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.min', local_var_params['social_shares_count_linkedin_min']))  # noqa: E501
        if 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.max', local_var_params['social_shares_count_linkedin_max']))  # noqa: E501
        if 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.min', local_var_params['social_shares_count_reddit_min']))  # noqa: E501
        if 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.max', local_var_params['social_shares_count_reddit_max']))  # noqa: E501
        if 'clusters' in local_var_params and local_var_params['clusters'] is not None:  # noqa: E501
            query_params.append(('clusters[]', local_var_params['clusters']))  # noqa: E501
            collection_formats['clusters[]'] = 'multi'  # noqa: E501
        if '_return' in local_var_params and local_var_params['_return'] is not None:  # noqa: E501
            query_params.append(('return[]', local_var_params['_return']))  # noqa: E501
            collection_formats['return[]'] = 'multi'  # noqa: E501
        if 'story_id' in local_var_params and local_var_params['story_id'] is not None:  # noqa: E501
            query_params.append(('story_id', local_var_params['story_id']))  # noqa: E501
        if 'story_url' in local_var_params and local_var_params['story_url'] is not None:  # noqa: E501
            query_params.append(('story_url', local_var_params['story_url']))  # noqa: E501
        if 'story_title' in local_var_params and local_var_params['story_title'] is not None:  # noqa: E501
            query_params.append(('story_title', local_var_params['story_title']))  # noqa: E501
        if 'story_body' in local_var_params and local_var_params['story_body'] is not None:  # noqa: E501
            query_params.append(('story_body', local_var_params['story_body']))  # noqa: E501
        if 'aql' in local_var_params and local_var_params['aql'] is not None:  # noqa: E501
            query_params.append(('aql', local_var_params['aql']))  # noqa: E501
        if 'aql_default_field' in local_var_params and local_var_params['aql_default_field'] is not None:  # noqa: E501
            query_params.append(('aql_default_field', local_var_params['aql_default_field']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'boost_by' in local_var_params and local_var_params['boost_by'] is not None:  # noqa: E501
            query_params.append(('boost_by', local_var_params['boost_by']))  # noqa: E501
        if 'story_language' in local_var_params and local_var_params['story_language'] is not None:  # noqa: E501
            query_params.append(('story_language', local_var_params['story_language']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/related_stories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RelatedStories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_stories(self, **kwargs):  # noqa: E501
        """List Stories  # noqa: E501

        The stories endpoint is used to return stories based on parameters you set in your query. The News API crawler gathers articles in near real-time and stores information about them, or metadata. Below you can see all of the query parameters, which you can use to narrow down your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_stories(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param sort_by: This parameter is used for changing the order column of the results. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_by: str
        :param sort_direction: This parameter is used for changing the order direction of the result. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_direction: str
        :param cursor: This parameter is used for finding a specific page. You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results). 
        :type cursor: str
        :param per_page: This parameter is used for specifying number of items in each page You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results) 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Stories
        """
        kwargs['_return_http_data_only'] = True
        return self.list_stories_with_http_info(**kwargs)  # noqa: E501

    def list_stories_with_http_info(self, **kwargs):  # noqa: E501
        """List Stories  # noqa: E501

        The stories endpoint is used to return stories based on parameters you set in your query. The News API crawler gathers articles in near real-time and stores information about them, or metadata. Below you can see all of the query parameters, which you can use to narrow down your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_stories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param _return: This parameter is used for specifying return fields.
        :type _return: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param sort_by: This parameter is used for changing the order column of the results. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_by: str
        :param sort_direction: This parameter is used for changing the order direction of the result. You can read about sorting results [here](https://newsapi.aylien.com/docs/sorting-results). 
        :type sort_direction: str
        :param cursor: This parameter is used for finding a specific page. You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results). 
        :type cursor: str
        :param per_page: This parameter is used for specifying number of items in each page You can read more about pagination of results [here](https://newsapi.aylien.com/docs/pagination-of-results) 
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Stories, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'not_id',
            'title',
            'body',
            'text',
            'translations_en_title',
            'translations_en_body',
            'translations_en_text',
            'language',
            'not_language',
            'links_permalink',
            'not_links_permalink',
            'published_at_start',
            'published_at_end',
            'categories_taxonomy',
            'categories_confident',
            'categories_id',
            'not_categories_id',
            'categories_label',
            'not_categories_label',
            'categories_level',
            'not_categories_level',
            'entities_id',
            'not_entities_id',
            'entities_links_wikipedia',
            'not_entities_links_wikipedia',
            'entities_links_wikidata',
            'not_entities_links_wikidata',
            'entities_types',
            'not_entities_types',
            'entities_stock_tickers',
            'entities_body_stock_tickers',
            'entities_surface_forms_text',
            'not_entities_surface_forms_text',
            'entities_title_surface_forms_text',
            'not_entities_title_surface_forms_text',
            'entities_body_surface_forms_text',
            'not_entities_body_surface_forms_text',
            'sentiment_title_polarity',
            'not_sentiment_title_polarity',
            'sentiment_body_polarity',
            'not_sentiment_body_polarity',
            'media_images_count_min',
            'media_images_count_max',
            'media_images_width_min',
            'media_images_width_max',
            'media_images_height_min',
            'media_images_height_max',
            'media_images_content_length_min',
            'media_images_content_length_max',
            'media_images_format',
            'not_media_images_format',
            'media_videos_count_min',
            'media_videos_count_max',
            'author_id',
            'not_author_id',
            'author_name',
            'not_author_name',
            'source_id',
            'not_source_id',
            'source_name',
            'not_source_name',
            'source_domain',
            'not_source_domain',
            'source_locations_country',
            'not_source_locations_country',
            'source_locations_state',
            'not_source_locations_state',
            'source_locations_city',
            'not_source_locations_city',
            'source_scopes_country',
            'not_source_scopes_country',
            'source_scopes_state',
            'not_source_scopes_state',
            'source_scopes_city',
            'not_source_scopes_city',
            'source_scopes_level',
            'not_source_scopes_level',
            'source_links_in_count_min',
            'source_links_in_count_max',
            'source_rankings_alexa_rank_min',
            'source_rankings_alexa_rank_max',
            'source_rankings_alexa_country',
            'social_shares_count_facebook_min',
            'social_shares_count_facebook_max',
            'social_shares_count_google_plus_min',
            'social_shares_count_google_plus_max',
            'social_shares_count_linkedin_min',
            'social_shares_count_linkedin_max',
            'social_shares_count_reddit_min',
            'social_shares_count_reddit_max',
            'clusters',
            '_return',
            'aql',
            'aql_default_field',
            'query',
            'sort_by',
            'sort_direction',
            'cursor',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stories" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_min` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_max` when calling `list_stories`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_stories`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'per_page' in local_var_params and local_var_params['per_page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `per_page` when calling `list_stories`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'body' in local_var_params and local_var_params['body'] is not None:  # noqa: E501
            query_params.append(('body', local_var_params['body']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'translations_en_title' in local_var_params and local_var_params['translations_en_title'] is not None:  # noqa: E501
            query_params.append(('translations.en.title', local_var_params['translations_en_title']))  # noqa: E501
        if 'translations_en_body' in local_var_params and local_var_params['translations_en_body'] is not None:  # noqa: E501
            query_params.append(('translations.en.body', local_var_params['translations_en_body']))  # noqa: E501
        if 'translations_en_text' in local_var_params and local_var_params['translations_en_text'] is not None:  # noqa: E501
            query_params.append(('translations.en.text', local_var_params['translations_en_text']))  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language[]', local_var_params['language']))  # noqa: E501
            collection_formats['language[]'] = 'multi'  # noqa: E501
        if 'not_language' in local_var_params and local_var_params['not_language'] is not None:  # noqa: E501
            query_params.append(('!language[]', local_var_params['not_language']))  # noqa: E501
            collection_formats['!language[]'] = 'multi'  # noqa: E501
        if 'links_permalink' in local_var_params and local_var_params['links_permalink'] is not None:  # noqa: E501
            query_params.append(('links.permalink[]', local_var_params['links_permalink']))  # noqa: E501
            collection_formats['links.permalink[]'] = 'multi'  # noqa: E501
        if 'not_links_permalink' in local_var_params and local_var_params['not_links_permalink'] is not None:  # noqa: E501
            query_params.append(('!links.permalink[]', local_var_params['not_links_permalink']))  # noqa: E501
            collection_formats['!links.permalink[]'] = 'multi'  # noqa: E501
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if 'categories_taxonomy' in local_var_params and local_var_params['categories_taxonomy'] is not None:  # noqa: E501
            query_params.append(('categories.taxonomy', local_var_params['categories_taxonomy']))  # noqa: E501
        if 'categories_confident' in local_var_params and local_var_params['categories_confident'] is not None:  # noqa: E501
            query_params.append(('categories.confident', local_var_params['categories_confident']))  # noqa: E501
        if 'categories_id' in local_var_params and local_var_params['categories_id'] is not None:  # noqa: E501
            query_params.append(('categories.id[]', local_var_params['categories_id']))  # noqa: E501
            collection_formats['categories.id[]'] = 'multi'  # noqa: E501
        if 'not_categories_id' in local_var_params and local_var_params['not_categories_id'] is not None:  # noqa: E501
            query_params.append(('!categories.id[]', local_var_params['not_categories_id']))  # noqa: E501
            collection_formats['!categories.id[]'] = 'multi'  # noqa: E501
        if 'categories_label' in local_var_params and local_var_params['categories_label'] is not None:  # noqa: E501
            query_params.append(('categories.label[]', local_var_params['categories_label']))  # noqa: E501
            collection_formats['categories.label[]'] = 'multi'  # noqa: E501
        if 'not_categories_label' in local_var_params and local_var_params['not_categories_label'] is not None:  # noqa: E501
            query_params.append(('!categories.label[]', local_var_params['not_categories_label']))  # noqa: E501
            collection_formats['!categories.label[]'] = 'multi'  # noqa: E501
        if 'categories_level' in local_var_params and local_var_params['categories_level'] is not None:  # noqa: E501
            query_params.append(('categories.level[]', local_var_params['categories_level']))  # noqa: E501
            collection_formats['categories.level[]'] = 'multi'  # noqa: E501
        if 'not_categories_level' in local_var_params and local_var_params['not_categories_level'] is not None:  # noqa: E501
            query_params.append(('!categories.level[]', local_var_params['not_categories_level']))  # noqa: E501
            collection_formats['!categories.level[]'] = 'multi'  # noqa: E501
        if 'entities_id' in local_var_params and local_var_params['entities_id'] is not None:  # noqa: E501
            query_params.append(('entities.id[]', local_var_params['entities_id']))  # noqa: E501
            collection_formats['entities.id[]'] = 'multi'  # noqa: E501
        if 'not_entities_id' in local_var_params and local_var_params['not_entities_id'] is not None:  # noqa: E501
            query_params.append(('!entities.id[]', local_var_params['not_entities_id']))  # noqa: E501
            collection_formats['!entities.id[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikipedia' in local_var_params and local_var_params['entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikipedia[]', local_var_params['entities_links_wikipedia']))  # noqa: E501
            collection_formats['entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikipedia' in local_var_params and local_var_params['not_entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikipedia[]', local_var_params['not_entities_links_wikipedia']))  # noqa: E501
            collection_formats['!entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikidata' in local_var_params and local_var_params['entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikidata[]', local_var_params['entities_links_wikidata']))  # noqa: E501
            collection_formats['entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikidata' in local_var_params and local_var_params['not_entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikidata[]', local_var_params['not_entities_links_wikidata']))  # noqa: E501
            collection_formats['!entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'entities_types' in local_var_params and local_var_params['entities_types'] is not None:  # noqa: E501
            query_params.append(('entities.types[]', local_var_params['entities_types']))  # noqa: E501
            collection_formats['entities.types[]'] = 'multi'  # noqa: E501
        if 'not_entities_types' in local_var_params and local_var_params['not_entities_types'] is not None:  # noqa: E501
            query_params.append(('!entities.types[]', local_var_params['not_entities_types']))  # noqa: E501
            collection_formats['!entities.types[]'] = 'multi'  # noqa: E501
        if 'entities_stock_tickers' in local_var_params and local_var_params['entities_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('entities.stock_tickers[]', local_var_params['entities_stock_tickers']))  # noqa: E501
            collection_formats['entities.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_body_stock_tickers' in local_var_params and local_var_params['entities_body_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('!entities.body.stock_tickers[]', local_var_params['entities_body_stock_tickers']))  # noqa: E501
            collection_formats['!entities.body.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_surface_forms_text' in local_var_params and local_var_params['entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.surface_forms.text[]', local_var_params['entities_surface_forms_text']))  # noqa: E501
            collection_formats['entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_surface_forms_text' in local_var_params and local_var_params['not_entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.surface_forms.text[]', local_var_params['not_entities_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_title_surface_forms_text' in local_var_params and local_var_params['entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.title.surface_forms.text[]', local_var_params['entities_title_surface_forms_text']))  # noqa: E501
        if 'not_entities_title_surface_forms_text' in local_var_params and local_var_params['not_entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.title.surface_forms.text[]', local_var_params['not_entities_title_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.title.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_body_surface_forms_text' in local_var_params and local_var_params['entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.body.surface_forms.text[]', local_var_params['entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_body_surface_forms_text' in local_var_params and local_var_params['not_entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.body.surface_forms.text[]', local_var_params['not_entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'sentiment_title_polarity' in local_var_params and local_var_params['sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.title.polarity', local_var_params['sentiment_title_polarity']))  # noqa: E501
        if 'not_sentiment_title_polarity' in local_var_params and local_var_params['not_sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.title.polarity', local_var_params['not_sentiment_title_polarity']))  # noqa: E501
        if 'sentiment_body_polarity' in local_var_params and local_var_params['sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.body.polarity', local_var_params['sentiment_body_polarity']))  # noqa: E501
        if 'not_sentiment_body_polarity' in local_var_params and local_var_params['not_sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.body.polarity', local_var_params['not_sentiment_body_polarity']))  # noqa: E501
        if 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] is not None:  # noqa: E501
            query_params.append(('media.images.count.min', local_var_params['media_images_count_min']))  # noqa: E501
        if 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] is not None:  # noqa: E501
            query_params.append(('media.images.count.max', local_var_params['media_images_count_max']))  # noqa: E501
        if 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] is not None:  # noqa: E501
            query_params.append(('media.images.width.min', local_var_params['media_images_width_min']))  # noqa: E501
        if 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] is not None:  # noqa: E501
            query_params.append(('media.images.width.max', local_var_params['media_images_width_max']))  # noqa: E501
        if 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] is not None:  # noqa: E501
            query_params.append(('media.images.height.min', local_var_params['media_images_height_min']))  # noqa: E501
        if 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] is not None:  # noqa: E501
            query_params.append(('media.images.height.max', local_var_params['media_images_height_max']))  # noqa: E501
        if 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.min', local_var_params['media_images_content_length_min']))  # noqa: E501
        if 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.max', local_var_params['media_images_content_length_max']))  # noqa: E501
        if 'media_images_format' in local_var_params and local_var_params['media_images_format'] is not None:  # noqa: E501
            query_params.append(('media.images.format[]', local_var_params['media_images_format']))  # noqa: E501
            collection_formats['media.images.format[]'] = 'multi'  # noqa: E501
        if 'not_media_images_format' in local_var_params and local_var_params['not_media_images_format'] is not None:  # noqa: E501
            query_params.append(('!media.images.format[]', local_var_params['not_media_images_format']))  # noqa: E501
            collection_formats['!media.images.format[]'] = 'multi'  # noqa: E501
        if 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.min', local_var_params['media_videos_count_min']))  # noqa: E501
        if 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.max', local_var_params['media_videos_count_max']))  # noqa: E501
        if 'author_id' in local_var_params and local_var_params['author_id'] is not None:  # noqa: E501
            query_params.append(('author.id[]', local_var_params['author_id']))  # noqa: E501
            collection_formats['author.id[]'] = 'multi'  # noqa: E501
        if 'not_author_id' in local_var_params and local_var_params['not_author_id'] is not None:  # noqa: E501
            query_params.append(('!author.id[]', local_var_params['not_author_id']))  # noqa: E501
            collection_formats['!author.id[]'] = 'multi'  # noqa: E501
        if 'author_name' in local_var_params and local_var_params['author_name'] is not None:  # noqa: E501
            query_params.append(('author.name', local_var_params['author_name']))  # noqa: E501
        if 'not_author_name' in local_var_params and local_var_params['not_author_name'] is not None:  # noqa: E501
            query_params.append(('!author.name', local_var_params['not_author_name']))  # noqa: E501
        if 'source_id' in local_var_params and local_var_params['source_id'] is not None:  # noqa: E501
            query_params.append(('source.id[]', local_var_params['source_id']))  # noqa: E501
            collection_formats['source.id[]'] = 'multi'  # noqa: E501
        if 'not_source_id' in local_var_params and local_var_params['not_source_id'] is not None:  # noqa: E501
            query_params.append(('!source.id[]', local_var_params['not_source_id']))  # noqa: E501
            collection_formats['!source.id[]'] = 'multi'  # noqa: E501
        if 'source_name' in local_var_params and local_var_params['source_name'] is not None:  # noqa: E501
            query_params.append(('source.name[]', local_var_params['source_name']))  # noqa: E501
            collection_formats['source.name[]'] = 'multi'  # noqa: E501
        if 'not_source_name' in local_var_params and local_var_params['not_source_name'] is not None:  # noqa: E501
            query_params.append(('!source.name[]', local_var_params['not_source_name']))  # noqa: E501
            collection_formats['!source.name[]'] = 'multi'  # noqa: E501
        if 'source_domain' in local_var_params and local_var_params['source_domain'] is not None:  # noqa: E501
            query_params.append(('source.domain[]', local_var_params['source_domain']))  # noqa: E501
            collection_formats['source.domain[]'] = 'multi'  # noqa: E501
        if 'not_source_domain' in local_var_params and local_var_params['not_source_domain'] is not None:  # noqa: E501
            query_params.append(('!source.domain[]', local_var_params['not_source_domain']))  # noqa: E501
            collection_formats['!source.domain[]'] = 'multi'  # noqa: E501
        if 'source_locations_country' in local_var_params and local_var_params['source_locations_country'] is not None:  # noqa: E501
            query_params.append(('source.locations.country[]', local_var_params['source_locations_country']))  # noqa: E501
            collection_formats['source.locations.country[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_country' in local_var_params and local_var_params['not_source_locations_country'] is not None:  # noqa: E501
            query_params.append(('!source.locations.country[]', local_var_params['not_source_locations_country']))  # noqa: E501
            collection_formats['!source.locations.country[]'] = 'multi'  # noqa: E501
        if 'source_locations_state' in local_var_params and local_var_params['source_locations_state'] is not None:  # noqa: E501
            query_params.append(('source.locations.state[]', local_var_params['source_locations_state']))  # noqa: E501
            collection_formats['source.locations.state[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_state' in local_var_params and local_var_params['not_source_locations_state'] is not None:  # noqa: E501
            query_params.append(('!source.locations.state[]', local_var_params['not_source_locations_state']))  # noqa: E501
            collection_formats['!source.locations.state[]'] = 'multi'  # noqa: E501
        if 'source_locations_city' in local_var_params and local_var_params['source_locations_city'] is not None:  # noqa: E501
            query_params.append(('source.locations.city[]', local_var_params['source_locations_city']))  # noqa: E501
            collection_formats['source.locations.city[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_city' in local_var_params and local_var_params['not_source_locations_city'] is not None:  # noqa: E501
            query_params.append(('!source.locations.city[]', local_var_params['not_source_locations_city']))  # noqa: E501
            collection_formats['!source.locations.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_country' in local_var_params and local_var_params['source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('source.scopes.country[]', local_var_params['source_scopes_country']))  # noqa: E501
            collection_formats['source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_country' in local_var_params and local_var_params['not_source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.country[]', local_var_params['not_source_scopes_country']))  # noqa: E501
            collection_formats['!source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'source_scopes_state' in local_var_params and local_var_params['source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('source.scopes.state[]', local_var_params['source_scopes_state']))  # noqa: E501
            collection_formats['source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_state' in local_var_params and local_var_params['not_source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.state[]', local_var_params['not_source_scopes_state']))  # noqa: E501
            collection_formats['!source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'source_scopes_city' in local_var_params and local_var_params['source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('source.scopes.city[]', local_var_params['source_scopes_city']))  # noqa: E501
            collection_formats['source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_city' in local_var_params and local_var_params['not_source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.city[]', local_var_params['not_source_scopes_city']))  # noqa: E501
            collection_formats['!source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_level' in local_var_params and local_var_params['source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('source.scopes.level[]', local_var_params['source_scopes_level']))  # noqa: E501
            collection_formats['source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_level' in local_var_params and local_var_params['not_source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.level[]', local_var_params['not_source_scopes_level']))  # noqa: E501
            collection_formats['!source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.min', local_var_params['source_links_in_count_min']))  # noqa: E501
        if 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.max', local_var_params['source_links_in_count_max']))  # noqa: E501
        if 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.min', local_var_params['source_rankings_alexa_rank_min']))  # noqa: E501
        if 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.max', local_var_params['source_rankings_alexa_rank_max']))  # noqa: E501
        if 'source_rankings_alexa_country' in local_var_params and local_var_params['source_rankings_alexa_country'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.country[]', local_var_params['source_rankings_alexa_country']))  # noqa: E501
            collection_formats['source.rankings.alexa.country[]'] = 'multi'  # noqa: E501
        if 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.min', local_var_params['social_shares_count_facebook_min']))  # noqa: E501
        if 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.max', local_var_params['social_shares_count_facebook_max']))  # noqa: E501
        if 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.min', local_var_params['social_shares_count_google_plus_min']))  # noqa: E501
        if 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.max', local_var_params['social_shares_count_google_plus_max']))  # noqa: E501
        if 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.min', local_var_params['social_shares_count_linkedin_min']))  # noqa: E501
        if 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.max', local_var_params['social_shares_count_linkedin_max']))  # noqa: E501
        if 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.min', local_var_params['social_shares_count_reddit_min']))  # noqa: E501
        if 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.max', local_var_params['social_shares_count_reddit_max']))  # noqa: E501
        if 'clusters' in local_var_params and local_var_params['clusters'] is not None:  # noqa: E501
            query_params.append(('clusters[]', local_var_params['clusters']))  # noqa: E501
            collection_formats['clusters[]'] = 'multi'  # noqa: E501
        if '_return' in local_var_params and local_var_params['_return'] is not None:  # noqa: E501
            query_params.append(('return[]', local_var_params['_return']))  # noqa: E501
            collection_formats['return[]'] = 'multi'  # noqa: E501
        if 'aql' in local_var_params and local_var_params['aql'] is not None:  # noqa: E501
            query_params.append(('aql', local_var_params['aql']))  # noqa: E501
        if 'aql_default_field' in local_var_params and local_var_params['aql_default_field'] is not None:  # noqa: E501
            query_params.append(('aql_default_field', local_var_params['aql_default_field']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
        if 'sort_direction' in local_var_params and local_var_params['sort_direction'] is not None:  # noqa: E501
            query_params.append(('sort_direction', local_var_params['sort_direction']))  # noqa: E501
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/stories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_time_series(self, **kwargs):  # noqa: E501
        """List time series  # noqa: E501

        The time series endpoint allows you to track information contained in stories over time. This information can be anything from mentions of a topic or entities, sentiment about a topic, or the volume of stories published by a source, to name but a few. The full list of parameters is given below. Using the [Date Math Syntax](https://newsapi.aylien.com/docs/working-with-dates), you can easily set your query to return information from any time period, from the current point in time to when the News API started collecting stories. The returned information can be rounded to a time also specified by you, for example by setting the results into hourly, daily, or weekly data points.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_time_series(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param published_at_start: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param period: The size of each date range is expressed as an interval to be added to the lower bound. It supports Date Math Syntax. Valid options are `+` following an integer number greater than 0 and one of the Date Math keywords. e.g. `+1DAY`, `+2MINUTES` and `+1MONTH`. Here are [Supported keywords](https://newsapi.aylien.com/docs/working-with-dates#date-math). 
        :type period: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TimeSeriesList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_time_series_with_http_info(**kwargs)  # noqa: E501

    def list_time_series_with_http_info(self, **kwargs):  # noqa: E501
        """List time series  # noqa: E501

        The time series endpoint allows you to track information contained in stories over time. This information can be anything from mentions of a topic or entities, sentiment about a topic, or the volume of stories published by a source, to name but a few. The full list of parameters is given below. Using the [Date Math Syntax](https://newsapi.aylien.com/docs/working-with-dates), you can easily set your query to return information from any time period, from the current point in time to when the News API started collecting stories. The returned information can be rounded to a time also specified by you, for example by setting the results into hourly, daily, or weekly data points.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_time_series_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param published_at_start: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param period: The size of each date range is expressed as an interval to be added to the lower bound. It supports Date Math Syntax. Valid options are `+` following an integer number greater than 0 and one of the Date Math keywords. e.g. `+1DAY`, `+2MINUTES` and `+1MONTH`. Here are [Supported keywords](https://newsapi.aylien.com/docs/working-with-dates#date-math). 
        :type period: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TimeSeriesList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'not_id',
            'title',
            'body',
            'text',
            'translations_en_title',
            'translations_en_body',
            'translations_en_text',
            'language',
            'not_language',
            'categories_taxonomy',
            'categories_confident',
            'categories_id',
            'not_categories_id',
            'categories_label',
            'not_categories_label',
            'categories_level',
            'not_categories_level',
            'entities_id',
            'not_entities_id',
            'entities_links_wikipedia',
            'not_entities_links_wikipedia',
            'entities_links_wikidata',
            'not_entities_links_wikidata',
            'entities_types',
            'not_entities_types',
            'entities_stock_tickers',
            'entities_body_stock_tickers',
            'entities_surface_forms_text',
            'not_entities_surface_forms_text',
            'entities_title_surface_forms_text',
            'not_entities_title_surface_forms_text',
            'entities_body_surface_forms_text',
            'not_entities_body_surface_forms_text',
            'sentiment_title_polarity',
            'not_sentiment_title_polarity',
            'sentiment_body_polarity',
            'not_sentiment_body_polarity',
            'media_images_count_min',
            'media_images_count_max',
            'media_images_width_min',
            'media_images_width_max',
            'media_images_height_min',
            'media_images_height_max',
            'media_images_content_length_min',
            'media_images_content_length_max',
            'media_images_format',
            'not_media_images_format',
            'media_videos_count_min',
            'media_videos_count_max',
            'author_id',
            'not_author_id',
            'author_name',
            'not_author_name',
            'source_id',
            'not_source_id',
            'source_name',
            'not_source_name',
            'source_domain',
            'not_source_domain',
            'source_locations_country',
            'not_source_locations_country',
            'source_locations_state',
            'not_source_locations_state',
            'source_locations_city',
            'not_source_locations_city',
            'source_scopes_country',
            'not_source_scopes_country',
            'source_scopes_state',
            'not_source_scopes_state',
            'source_scopes_city',
            'not_source_scopes_city',
            'source_scopes_level',
            'not_source_scopes_level',
            'source_links_in_count_min',
            'source_links_in_count_max',
            'source_rankings_alexa_rank_min',
            'source_rankings_alexa_rank_max',
            'source_rankings_alexa_country',
            'social_shares_count_facebook_min',
            'social_shares_count_facebook_max',
            'social_shares_count_google_plus_min',
            'social_shares_count_google_plus_max',
            'social_shares_count_linkedin_min',
            'social_shares_count_linkedin_max',
            'social_shares_count_reddit_min',
            'social_shares_count_reddit_max',
            'clusters',
            'aql',
            'aql_default_field',
            'query',
            'published_at_start',
            'published_at_end',
            'period'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_time_series" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_min` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_max` when calling `list_time_series`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'body' in local_var_params and local_var_params['body'] is not None:  # noqa: E501
            query_params.append(('body', local_var_params['body']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'translations_en_title' in local_var_params and local_var_params['translations_en_title'] is not None:  # noqa: E501
            query_params.append(('translations.en.title', local_var_params['translations_en_title']))  # noqa: E501
        if 'translations_en_body' in local_var_params and local_var_params['translations_en_body'] is not None:  # noqa: E501
            query_params.append(('translations.en.body', local_var_params['translations_en_body']))  # noqa: E501
        if 'translations_en_text' in local_var_params and local_var_params['translations_en_text'] is not None:  # noqa: E501
            query_params.append(('translations.en.text', local_var_params['translations_en_text']))  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language[]', local_var_params['language']))  # noqa: E501
            collection_formats['language[]'] = 'multi'  # noqa: E501
        if 'not_language' in local_var_params and local_var_params['not_language'] is not None:  # noqa: E501
            query_params.append(('!language[]', local_var_params['not_language']))  # noqa: E501
            collection_formats['!language[]'] = 'multi'  # noqa: E501
        if 'categories_taxonomy' in local_var_params and local_var_params['categories_taxonomy'] is not None:  # noqa: E501
            query_params.append(('categories.taxonomy', local_var_params['categories_taxonomy']))  # noqa: E501
        if 'categories_confident' in local_var_params and local_var_params['categories_confident'] is not None:  # noqa: E501
            query_params.append(('categories.confident', local_var_params['categories_confident']))  # noqa: E501
        if 'categories_id' in local_var_params and local_var_params['categories_id'] is not None:  # noqa: E501
            query_params.append(('categories.id[]', local_var_params['categories_id']))  # noqa: E501
            collection_formats['categories.id[]'] = 'multi'  # noqa: E501
        if 'not_categories_id' in local_var_params and local_var_params['not_categories_id'] is not None:  # noqa: E501
            query_params.append(('!categories.id[]', local_var_params['not_categories_id']))  # noqa: E501
            collection_formats['!categories.id[]'] = 'multi'  # noqa: E501
        if 'categories_label' in local_var_params and local_var_params['categories_label'] is not None:  # noqa: E501
            query_params.append(('categories.label[]', local_var_params['categories_label']))  # noqa: E501
            collection_formats['categories.label[]'] = 'multi'  # noqa: E501
        if 'not_categories_label' in local_var_params and local_var_params['not_categories_label'] is not None:  # noqa: E501
            query_params.append(('!categories.label[]', local_var_params['not_categories_label']))  # noqa: E501
            collection_formats['!categories.label[]'] = 'multi'  # noqa: E501
        if 'categories_level' in local_var_params and local_var_params['categories_level'] is not None:  # noqa: E501
            query_params.append(('categories.level[]', local_var_params['categories_level']))  # noqa: E501
            collection_formats['categories.level[]'] = 'multi'  # noqa: E501
        if 'not_categories_level' in local_var_params and local_var_params['not_categories_level'] is not None:  # noqa: E501
            query_params.append(('!categories.level[]', local_var_params['not_categories_level']))  # noqa: E501
            collection_formats['!categories.level[]'] = 'multi'  # noqa: E501
        if 'entities_id' in local_var_params and local_var_params['entities_id'] is not None:  # noqa: E501
            query_params.append(('entities.id[]', local_var_params['entities_id']))  # noqa: E501
            collection_formats['entities.id[]'] = 'multi'  # noqa: E501
        if 'not_entities_id' in local_var_params and local_var_params['not_entities_id'] is not None:  # noqa: E501
            query_params.append(('!entities.id[]', local_var_params['not_entities_id']))  # noqa: E501
            collection_formats['!entities.id[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikipedia' in local_var_params and local_var_params['entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikipedia[]', local_var_params['entities_links_wikipedia']))  # noqa: E501
            collection_formats['entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikipedia' in local_var_params and local_var_params['not_entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikipedia[]', local_var_params['not_entities_links_wikipedia']))  # noqa: E501
            collection_formats['!entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikidata' in local_var_params and local_var_params['entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikidata[]', local_var_params['entities_links_wikidata']))  # noqa: E501
            collection_formats['entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikidata' in local_var_params and local_var_params['not_entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikidata[]', local_var_params['not_entities_links_wikidata']))  # noqa: E501
            collection_formats['!entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'entities_types' in local_var_params and local_var_params['entities_types'] is not None:  # noqa: E501
            query_params.append(('entities.types[]', local_var_params['entities_types']))  # noqa: E501
            collection_formats['entities.types[]'] = 'multi'  # noqa: E501
        if 'not_entities_types' in local_var_params and local_var_params['not_entities_types'] is not None:  # noqa: E501
            query_params.append(('!entities.types[]', local_var_params['not_entities_types']))  # noqa: E501
            collection_formats['!entities.types[]'] = 'multi'  # noqa: E501
        if 'entities_stock_tickers' in local_var_params and local_var_params['entities_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('entities.stock_tickers[]', local_var_params['entities_stock_tickers']))  # noqa: E501
            collection_formats['entities.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_body_stock_tickers' in local_var_params and local_var_params['entities_body_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('!entities.body.stock_tickers[]', local_var_params['entities_body_stock_tickers']))  # noqa: E501
            collection_formats['!entities.body.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_surface_forms_text' in local_var_params and local_var_params['entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.surface_forms.text[]', local_var_params['entities_surface_forms_text']))  # noqa: E501
            collection_formats['entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_surface_forms_text' in local_var_params and local_var_params['not_entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.surface_forms.text[]', local_var_params['not_entities_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_title_surface_forms_text' in local_var_params and local_var_params['entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.title.surface_forms.text[]', local_var_params['entities_title_surface_forms_text']))  # noqa: E501
        if 'not_entities_title_surface_forms_text' in local_var_params and local_var_params['not_entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.title.surface_forms.text[]', local_var_params['not_entities_title_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.title.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_body_surface_forms_text' in local_var_params and local_var_params['entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.body.surface_forms.text[]', local_var_params['entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_body_surface_forms_text' in local_var_params and local_var_params['not_entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.body.surface_forms.text[]', local_var_params['not_entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'sentiment_title_polarity' in local_var_params and local_var_params['sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.title.polarity', local_var_params['sentiment_title_polarity']))  # noqa: E501
        if 'not_sentiment_title_polarity' in local_var_params and local_var_params['not_sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.title.polarity', local_var_params['not_sentiment_title_polarity']))  # noqa: E501
        if 'sentiment_body_polarity' in local_var_params and local_var_params['sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.body.polarity', local_var_params['sentiment_body_polarity']))  # noqa: E501
        if 'not_sentiment_body_polarity' in local_var_params and local_var_params['not_sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.body.polarity', local_var_params['not_sentiment_body_polarity']))  # noqa: E501
        if 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] is not None:  # noqa: E501
            query_params.append(('media.images.count.min', local_var_params['media_images_count_min']))  # noqa: E501
        if 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] is not None:  # noqa: E501
            query_params.append(('media.images.count.max', local_var_params['media_images_count_max']))  # noqa: E501
        if 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] is not None:  # noqa: E501
            query_params.append(('media.images.width.min', local_var_params['media_images_width_min']))  # noqa: E501
        if 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] is not None:  # noqa: E501
            query_params.append(('media.images.width.max', local_var_params['media_images_width_max']))  # noqa: E501
        if 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] is not None:  # noqa: E501
            query_params.append(('media.images.height.min', local_var_params['media_images_height_min']))  # noqa: E501
        if 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] is not None:  # noqa: E501
            query_params.append(('media.images.height.max', local_var_params['media_images_height_max']))  # noqa: E501
        if 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.min', local_var_params['media_images_content_length_min']))  # noqa: E501
        if 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.max', local_var_params['media_images_content_length_max']))  # noqa: E501
        if 'media_images_format' in local_var_params and local_var_params['media_images_format'] is not None:  # noqa: E501
            query_params.append(('media.images.format[]', local_var_params['media_images_format']))  # noqa: E501
            collection_formats['media.images.format[]'] = 'multi'  # noqa: E501
        if 'not_media_images_format' in local_var_params and local_var_params['not_media_images_format'] is not None:  # noqa: E501
            query_params.append(('!media.images.format[]', local_var_params['not_media_images_format']))  # noqa: E501
            collection_formats['!media.images.format[]'] = 'multi'  # noqa: E501
        if 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.min', local_var_params['media_videos_count_min']))  # noqa: E501
        if 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.max', local_var_params['media_videos_count_max']))  # noqa: E501
        if 'author_id' in local_var_params and local_var_params['author_id'] is not None:  # noqa: E501
            query_params.append(('author.id[]', local_var_params['author_id']))  # noqa: E501
            collection_formats['author.id[]'] = 'multi'  # noqa: E501
        if 'not_author_id' in local_var_params and local_var_params['not_author_id'] is not None:  # noqa: E501
            query_params.append(('!author.id[]', local_var_params['not_author_id']))  # noqa: E501
            collection_formats['!author.id[]'] = 'multi'  # noqa: E501
        if 'author_name' in local_var_params and local_var_params['author_name'] is not None:  # noqa: E501
            query_params.append(('author.name', local_var_params['author_name']))  # noqa: E501
        if 'not_author_name' in local_var_params and local_var_params['not_author_name'] is not None:  # noqa: E501
            query_params.append(('!author.name', local_var_params['not_author_name']))  # noqa: E501
        if 'source_id' in local_var_params and local_var_params['source_id'] is not None:  # noqa: E501
            query_params.append(('source.id[]', local_var_params['source_id']))  # noqa: E501
            collection_formats['source.id[]'] = 'multi'  # noqa: E501
        if 'not_source_id' in local_var_params and local_var_params['not_source_id'] is not None:  # noqa: E501
            query_params.append(('!source.id[]', local_var_params['not_source_id']))  # noqa: E501
            collection_formats['!source.id[]'] = 'multi'  # noqa: E501
        if 'source_name' in local_var_params and local_var_params['source_name'] is not None:  # noqa: E501
            query_params.append(('source.name[]', local_var_params['source_name']))  # noqa: E501
            collection_formats['source.name[]'] = 'multi'  # noqa: E501
        if 'not_source_name' in local_var_params and local_var_params['not_source_name'] is not None:  # noqa: E501
            query_params.append(('!source.name[]', local_var_params['not_source_name']))  # noqa: E501
            collection_formats['!source.name[]'] = 'multi'  # noqa: E501
        if 'source_domain' in local_var_params and local_var_params['source_domain'] is not None:  # noqa: E501
            query_params.append(('source.domain[]', local_var_params['source_domain']))  # noqa: E501
            collection_formats['source.domain[]'] = 'multi'  # noqa: E501
        if 'not_source_domain' in local_var_params and local_var_params['not_source_domain'] is not None:  # noqa: E501
            query_params.append(('!source.domain[]', local_var_params['not_source_domain']))  # noqa: E501
            collection_formats['!source.domain[]'] = 'multi'  # noqa: E501
        if 'source_locations_country' in local_var_params and local_var_params['source_locations_country'] is not None:  # noqa: E501
            query_params.append(('source.locations.country[]', local_var_params['source_locations_country']))  # noqa: E501
            collection_formats['source.locations.country[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_country' in local_var_params and local_var_params['not_source_locations_country'] is not None:  # noqa: E501
            query_params.append(('!source.locations.country[]', local_var_params['not_source_locations_country']))  # noqa: E501
            collection_formats['!source.locations.country[]'] = 'multi'  # noqa: E501
        if 'source_locations_state' in local_var_params and local_var_params['source_locations_state'] is not None:  # noqa: E501
            query_params.append(('source.locations.state[]', local_var_params['source_locations_state']))  # noqa: E501
            collection_formats['source.locations.state[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_state' in local_var_params and local_var_params['not_source_locations_state'] is not None:  # noqa: E501
            query_params.append(('!source.locations.state[]', local_var_params['not_source_locations_state']))  # noqa: E501
            collection_formats['!source.locations.state[]'] = 'multi'  # noqa: E501
        if 'source_locations_city' in local_var_params and local_var_params['source_locations_city'] is not None:  # noqa: E501
            query_params.append(('source.locations.city[]', local_var_params['source_locations_city']))  # noqa: E501
            collection_formats['source.locations.city[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_city' in local_var_params and local_var_params['not_source_locations_city'] is not None:  # noqa: E501
            query_params.append(('!source.locations.city[]', local_var_params['not_source_locations_city']))  # noqa: E501
            collection_formats['!source.locations.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_country' in local_var_params and local_var_params['source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('source.scopes.country[]', local_var_params['source_scopes_country']))  # noqa: E501
            collection_formats['source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_country' in local_var_params and local_var_params['not_source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.country[]', local_var_params['not_source_scopes_country']))  # noqa: E501
            collection_formats['!source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'source_scopes_state' in local_var_params and local_var_params['source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('source.scopes.state[]', local_var_params['source_scopes_state']))  # noqa: E501
            collection_formats['source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_state' in local_var_params and local_var_params['not_source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.state[]', local_var_params['not_source_scopes_state']))  # noqa: E501
            collection_formats['!source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'source_scopes_city' in local_var_params and local_var_params['source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('source.scopes.city[]', local_var_params['source_scopes_city']))  # noqa: E501
            collection_formats['source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_city' in local_var_params and local_var_params['not_source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.city[]', local_var_params['not_source_scopes_city']))  # noqa: E501
            collection_formats['!source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_level' in local_var_params and local_var_params['source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('source.scopes.level[]', local_var_params['source_scopes_level']))  # noqa: E501
            collection_formats['source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_level' in local_var_params and local_var_params['not_source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.level[]', local_var_params['not_source_scopes_level']))  # noqa: E501
            collection_formats['!source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.min', local_var_params['source_links_in_count_min']))  # noqa: E501
        if 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.max', local_var_params['source_links_in_count_max']))  # noqa: E501
        if 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.min', local_var_params['source_rankings_alexa_rank_min']))  # noqa: E501
        if 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.max', local_var_params['source_rankings_alexa_rank_max']))  # noqa: E501
        if 'source_rankings_alexa_country' in local_var_params and local_var_params['source_rankings_alexa_country'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.country[]', local_var_params['source_rankings_alexa_country']))  # noqa: E501
            collection_formats['source.rankings.alexa.country[]'] = 'multi'  # noqa: E501
        if 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.min', local_var_params['social_shares_count_facebook_min']))  # noqa: E501
        if 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.max', local_var_params['social_shares_count_facebook_max']))  # noqa: E501
        if 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.min', local_var_params['social_shares_count_google_plus_min']))  # noqa: E501
        if 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.max', local_var_params['social_shares_count_google_plus_max']))  # noqa: E501
        if 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.min', local_var_params['social_shares_count_linkedin_min']))  # noqa: E501
        if 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.max', local_var_params['social_shares_count_linkedin_max']))  # noqa: E501
        if 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.min', local_var_params['social_shares_count_reddit_min']))  # noqa: E501
        if 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.max', local_var_params['social_shares_count_reddit_max']))  # noqa: E501
        if 'clusters' in local_var_params and local_var_params['clusters'] is not None:  # noqa: E501
            query_params.append(('clusters[]', local_var_params['clusters']))  # noqa: E501
            collection_formats['clusters[]'] = 'multi'  # noqa: E501
        if 'aql' in local_var_params and local_var_params['aql'] is not None:  # noqa: E501
            query_params.append(('aql', local_var_params['aql']))  # noqa: E501
        if 'aql_default_field' in local_var_params and local_var_params['aql_default_field'] is not None:  # noqa: E501
            query_params.append(('aql_default_field', local_var_params['aql_default_field']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if 'period' in local_var_params and local_var_params['period'] is not None:  # noqa: E501
            query_params.append(('period', local_var_params['period']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/time_series', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeriesList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_trends(self, field, **kwargs):  # noqa: E501
        """List trends  # noqa: E501

        The trends endpoint allows you to identify the most-mentioned entities, concepts and keywords relevant to your query. For example, this endpoint allows you to set parameters like a time period, a subject category, or an entity, and your request will return the most mentioned entities or keywords that are mentioned in relation to your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_trends(field, async_req=True)
        >>> result = thread.get()

        :param field: This parameter is used to specify the trend field.  (required)
        :type field: str
        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Trends
        """
        kwargs['_return_http_data_only'] = True
        return self.list_trends_with_http_info(field, **kwargs)  # noqa: E501

    def list_trends_with_http_info(self, field, **kwargs):  # noqa: E501
        """List trends  # noqa: E501

        The trends endpoint allows you to identify the most-mentioned entities, concepts and keywords relevant to your query. For example, this endpoint allows you to set parameters like a time period, a subject category, or an entity, and your request will return the most mentioned entities or keywords that are mentioned in relation to your query.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_trends_with_http_info(field, async_req=True)
        >>> result = thread.get()

        :param field: This parameter is used to specify the trend field.  (required)
        :type field: str
        :param id: This parameter is used for finding stories by story id. 
        :type id: list[int]
        :param not_id: This parameter is used for excluding stories by story id. 
        :type not_id: list[int]
        :param title: This parameter is used for finding stories whose title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type title: str
        :param body: This parameter is used for finding stories whose body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type body: str
        :param text: This parameter is used for finding stories whose title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type text: str
        :param translations_en_title: This parameter is used for finding stories whose translation title contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_title: str
        :param translations_en_body: This parameter is used for finding stories whose translation body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_body: str
        :param translations_en_text: This parameter is used for finding stories whose translation title or body contains a specific keyword. It supports [boolean operators](https://newsapi.aylien.com/docs/boolean-operators). 
        :type translations_en_text: str
        :param links_permalink: This parameter is used to find stories based on their url. 
        :type links_permalink: list[str]
        :param not_links_permalink: This parameter is used to exclude stories based on their url. 
        :type not_links_permalink: list[str]
        :param language: This parameter is used for finding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type language: list[str]
        :param not_language: This parameter is used for excluding stories whose language is the specified value. It supports [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language codes. 
        :type not_language: list[str]
        :param published_at_start: This parameter is used for finding stories whose published at time is greater than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_start: str
        :param published_at_end: This parameter is used for finding stories whose published at time is less than the specified value. [Here](https://newsapi.aylien.com/docs/working-with-dates) you can find more information about how [to work with dates](https://newsapi.aylien.com/docs/working-with-dates). 
        :type published_at_end: str
        :param categories_taxonomy: This parameter is used for defining the type of the taxonomy for the rest of the categories queries. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_taxonomy: str
        :param categories_confident: This parameter is used for finding stories whose categories are confident. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_confident: bool
        :param categories_id: This parameter is used for finding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_id: list[str]
        :param not_categories_id: This parameter is used for excluding stories by categories id. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_id: list[str]
        :param categories_label: This parameter is used for finding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_label: list[str]
        :param not_categories_label: This parameter is used for excluding stories by categories label. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_label: list[str]
        :param categories_level: This parameter is used for finding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type categories_level: list[int]
        :param not_categories_level: This parameter is used for excluding stories by categories level. You can read more about working with categories [here](https://newsapi.aylien.com/docs/working-with-categories). 
        :type not_categories_level: list[int]
        :param entities_id: This parameter is used to find stories based on the specified entities `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_id: list[str]
        :param not_entities_id: This parameter is used to exclude stories based on the specified entity's `id`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_id: list[str]
        :param entities_links_wikipedia: This parameter is used to find stories based on the specified entities wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikipedia: list[str]
        :param not_entities_links_wikipedia: This parameter is used to exclude stories based on the specified entity's Wikipedia URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikipedia: list[str]
        :param entities_links_wikidata: This parameter is used to find stories based on the specified entities wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_links_wikidata: list[str]
        :param not_entities_links_wikidata: This parameter is used to exclude stories based on the specified entity's Wikidata URL. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_links_wikidata: list[str]
        :param entities_types: This parameter is used to find stories based on the specified entities `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_types: list[str]
        :param not_entities_types: This parameter is used to exclude stories based on the specified entity's `types`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_types: list[str]
        :param entities_stock_tickers: This parameter is used to find stories based on the specified entities `stock_tickers`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_stock_tickers: list[str]
        :param entities_body_stock_tickers: This parameter is used to exclude stories based on the specified entity's `stock_tickers` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_stock_tickers: list[str]
        :param entities_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_surface_forms_text: list[str]
        :param not_entities_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form`. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_surface_forms_text: list[str]
        :param entities_title_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_title_surface_forms_text: str
        :param not_entities_title_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in story titles. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_title_surface_forms_text: list[str]
        :param entities_body_surface_forms_text: This parameter is used to find stories based on the specified entities `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type entities_body_surface_forms_text: list[str]
        :param not_entities_body_surface_forms_text: This parameter is used to exclude stories based on the specified entity's `surface_form` in the body of stories. You can read more about working with entities [here](https://newsapi.aylien.com/docs/working-with-entities). 
        :type not_entities_body_surface_forms_text: list[str]
        :param sentiment_title_polarity: This parameter is used for finding stories whose title sentiment is the specified value. 
        :type sentiment_title_polarity: str
        :param not_sentiment_title_polarity: This parameter is used for excluding stories whose title sentiment is the specified value. 
        :type not_sentiment_title_polarity: str
        :param sentiment_body_polarity: This parameter is used for finding stories whose body sentiment is the specified value. 
        :type sentiment_body_polarity: str
        :param not_sentiment_body_polarity: This parameter is used for excluding stories whose body sentiment is the specified value. 
        :type not_sentiment_body_polarity: str
        :param media_images_count_min: This parameter is used for finding stories whose number of images is greater than or equal to the specified value. 
        :type media_images_count_min: int
        :param media_images_count_max: This parameter is used for finding stories whose number of images is less than or equal to the specified value. 
        :type media_images_count_max: int
        :param media_images_width_min: This parameter is used for finding stories whose width of images are greater than or equal to the specified value. 
        :type media_images_width_min: int
        :param media_images_width_max: This parameter is used for finding stories whose width of images are less than or equal to the specified value. 
        :type media_images_width_max: int
        :param media_images_height_min: This parameter is used for finding stories whose height of images are greater than or equal to the specified value. 
        :type media_images_height_min: int
        :param media_images_height_max: This parameter is used for finding stories whose height of images are less than or equal to the specified value. 
        :type media_images_height_max: int
        :param media_images_content_length_min: This parameter is used for finding stories whose images content length are greater than or equal to the specified value. 
        :type media_images_content_length_min: int
        :param media_images_content_length_max: This parameter is used for finding stories whose images content length are less than or equal to the specified value. 
        :type media_images_content_length_max: int
        :param media_images_format: This parameter is used for finding stories whose images format are the specified value. 
        :type media_images_format: list[str]
        :param not_media_images_format: This parameter is used for excluding stories whose images format are the specified value. 
        :type not_media_images_format: list[str]
        :param media_videos_count_min: This parameter is used for finding stories whose number of videos is greater than or equal to the specified value. 
        :type media_videos_count_min: int
        :param media_videos_count_max: This parameter is used for finding stories whose number of videos is less than or equal to the specified value. 
        :type media_videos_count_max: int
        :param author_id: This parameter is used for finding stories whose author id is the specified value. 
        :type author_id: list[int]
        :param not_author_id: This parameter is used for excluding stories whose author id is the specified value. 
        :type not_author_id: list[int]
        :param author_name: This parameter is used for finding stories whose author full name contains the specified value. 
        :type author_name: str
        :param not_author_name: This parameter is used for excluding stories whose author full name contains the specified value. 
        :type not_author_name: str
        :param source_id: This parameter is used for finding stories whose source id is the specified value. 
        :type source_id: list[int]
        :param not_source_id: This parameter is used for excluding stories whose source id is the specified value. 
        :type not_source_id: list[int]
        :param source_name: This parameter is used for finding stories whose source name contains the specified value. 
        :type source_name: list[str]
        :param not_source_name: This parameter is used for excluding stories whose source name contains the specified value. 
        :type not_source_name: list[str]
        :param source_domain: This parameter is used for finding stories whose source domain is the specified value. 
        :type source_domain: list[str]
        :param not_source_domain: This parameter is used for excluding stories whose source domain is the specified value. 
        :type not_source_domain: list[str]
        :param source_locations_country: This parameter is used for finding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_country: list[str]
        :param not_source_locations_country: This parameter is used for excluding stories whose source country is the specified value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_country: list[str]
        :param source_locations_state: This parameter is used for finding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_state: list[str]
        :param not_source_locations_state: This parameter is used for excluding stories whose source state/province is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_state: list[str]
        :param source_locations_city: This parameter is used for finding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_locations_city: list[str]
        :param not_source_locations_city: This parameter is used for excluding stories whose source city is the specified value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_locations_city: list[str]
        :param source_scopes_country: This parameter is used for finding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_country: list[str]
        :param not_source_scopes_country: This parameter is used for excluding stories whose source scopes is the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_country: list[str]
        :param source_scopes_state: This parameter is used for finding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_state: list[str]
        :param not_source_scopes_state: This parameter is used for excluding stories whose source scopes is the specified state/province value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_state: list[str]
        :param source_scopes_city: This parameter is used for finding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_city: list[str]
        :param not_source_scopes_city: This parameter is used for excluding stories whose source scopes is the specified city value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_city: list[str]
        :param source_scopes_level: This parameter is used for finding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type source_scopes_level: list[str]
        :param not_source_scopes_level: This parameter is used for excluding stories whose source scopes is the specified level value. [Here](https://newsapi.aylien.com/docs/working-with-locations) you can find more information about how [to work with locations](https://newsapi.aylien.com/docs/working-with-locations). 
        :type not_source_scopes_level: list[str]
        :param source_links_in_count_min: This parameter is used for finding stories from sources whose Links in count is greater than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_min: int
        :param source_links_in_count_max: This parameter is used for finding stories from sources whose Links in count is less than or equal to the specified value. You can read more about working with Links in count [here](https://newsapi.aylien.com/docs/working-with-links-in-count). 
        :type source_links_in_count_max: int
        :param source_rankings_alexa_rank_min: This parameter is used for finding stories from sources whose Alexa rank is greater than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_min: int
        :param source_rankings_alexa_rank_max: This parameter is used for finding stories from sources whose Alexa rank is less than or equal to the specified value. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_rank_max: int
        :param source_rankings_alexa_country: This parameter is used for finding stories from sources whose Alexa rank is in the specified country value. It supports [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. You can read more about working with Alexa ranks [here](https://newsapi.aylien.com/docs/working-with-alexa-ranks). 
        :type source_rankings_alexa_country: list[str]
        :param social_shares_count_facebook_min: This parameter is used for finding stories whose Facebook social shares count is greater than or equal to the specified value. 
        :type social_shares_count_facebook_min: int
        :param social_shares_count_facebook_max: This parameter is used for finding stories whose Facebook social shares count is less than or equal to the specified value. 
        :type social_shares_count_facebook_max: int
        :param social_shares_count_google_plus_min: This parameter is used for finding stories whose Google+ social shares count is greater than or equal to the specified value. 
        :type social_shares_count_google_plus_min: int
        :param social_shares_count_google_plus_max: This parameter is used for finding stories whose Google+ social shares count is less than or equal to the specified value. 
        :type social_shares_count_google_plus_max: int
        :param social_shares_count_linkedin_min: This parameter is used for finding stories whose LinkedIn social shares count is greater than or equal to the specified value. 
        :type social_shares_count_linkedin_min: int
        :param social_shares_count_linkedin_max: This parameter is used for finding stories whose LinkedIn social shares count is less than or equal to the specified value. 
        :type social_shares_count_linkedin_max: int
        :param social_shares_count_reddit_min: This parameter is used for finding stories whose Reddit social shares count is greater than or equal to the specified value. 
        :type social_shares_count_reddit_min: int
        :param social_shares_count_reddit_max: This parameter is used for finding stories whose Reddit social shares count is less than or equal to the specified value. 
        :type social_shares_count_reddit_max: int
        :param clusters: This parameter is used for finding stories with belonging to one of clusters in a specific set of clusters You can read more about working with clustering [here](https://newsapi.aylien.com/docs/working-with-clustering). 
        :type clusters: list[str]
        :param aql: This parameter is used to supply a query in AYLIEN Query Language. 
        :type aql: str
        :param aql_default_field: This parameter is used to supply an optional default field name used in the AQL query. 
        :type aql_default_field: str
        :param query: This parameter is used to make an advanced query using $and, $or, $not logical operators and $eq for exact match, $text for a text search and $lt, $gt, $lte, $gte for range queries. value must be a json string. 
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Trends, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'field',
            'id',
            'not_id',
            'title',
            'body',
            'text',
            'translations_en_title',
            'translations_en_body',
            'translations_en_text',
            'links_permalink',
            'not_links_permalink',
            'language',
            'not_language',
            'published_at_start',
            'published_at_end',
            'categories_taxonomy',
            'categories_confident',
            'categories_id',
            'not_categories_id',
            'categories_label',
            'not_categories_label',
            'categories_level',
            'not_categories_level',
            'entities_id',
            'not_entities_id',
            'entities_links_wikipedia',
            'not_entities_links_wikipedia',
            'entities_links_wikidata',
            'not_entities_links_wikidata',
            'entities_types',
            'not_entities_types',
            'entities_stock_tickers',
            'entities_body_stock_tickers',
            'entities_surface_forms_text',
            'not_entities_surface_forms_text',
            'entities_title_surface_forms_text',
            'not_entities_title_surface_forms_text',
            'entities_body_surface_forms_text',
            'not_entities_body_surface_forms_text',
            'sentiment_title_polarity',
            'not_sentiment_title_polarity',
            'sentiment_body_polarity',
            'not_sentiment_body_polarity',
            'media_images_count_min',
            'media_images_count_max',
            'media_images_width_min',
            'media_images_width_max',
            'media_images_height_min',
            'media_images_height_max',
            'media_images_content_length_min',
            'media_images_content_length_max',
            'media_images_format',
            'not_media_images_format',
            'media_videos_count_min',
            'media_videos_count_max',
            'author_id',
            'not_author_id',
            'author_name',
            'not_author_name',
            'source_id',
            'not_source_id',
            'source_name',
            'not_source_name',
            'source_domain',
            'not_source_domain',
            'source_locations_country',
            'not_source_locations_country',
            'source_locations_state',
            'not_source_locations_state',
            'source_locations_city',
            'not_source_locations_city',
            'source_scopes_country',
            'not_source_scopes_country',
            'source_scopes_state',
            'not_source_scopes_state',
            'source_scopes_city',
            'not_source_scopes_city',
            'source_scopes_level',
            'not_source_scopes_level',
            'source_links_in_count_min',
            'source_links_in_count_max',
            'source_rankings_alexa_rank_min',
            'source_rankings_alexa_rank_max',
            'source_rankings_alexa_country',
            'social_shares_count_facebook_min',
            'social_shares_count_facebook_max',
            'social_shares_count_google_plus_min',
            'social_shares_count_google_plus_max',
            'social_shares_count_linkedin_min',
            'social_shares_count_linkedin_max',
            'social_shares_count_reddit_min',
            'social_shares_count_reddit_max',
            'clusters',
            'aql',
            'aql_default_field',
            'query'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_trends" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'field' is set
        if self.api_client.client_side_validation and ('field' not in local_var_params or  # noqa: E501
                                                        local_var_params['field'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `field` when calling `list_trends`")  # noqa: E501

        if self.api_client.client_side_validation and 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_count_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_width_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_height_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_images_content_length_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `media_videos_count_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_links_in_count_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_rankings_alexa_rank_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_facebook_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_google_plus_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_linkedin_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_min` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `social_shares_count_reddit_max` when calling `list_trends`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id[]', local_var_params['id']))  # noqa: E501
            collection_formats['id[]'] = 'multi'  # noqa: E501
        if 'not_id' in local_var_params and local_var_params['not_id'] is not None:  # noqa: E501
            query_params.append(('!id[]', local_var_params['not_id']))  # noqa: E501
            collection_formats['!id[]'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'body' in local_var_params and local_var_params['body'] is not None:  # noqa: E501
            query_params.append(('body', local_var_params['body']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'translations_en_title' in local_var_params and local_var_params['translations_en_title'] is not None:  # noqa: E501
            query_params.append(('translations.en.title', local_var_params['translations_en_title']))  # noqa: E501
        if 'translations_en_body' in local_var_params and local_var_params['translations_en_body'] is not None:  # noqa: E501
            query_params.append(('translations.en.body', local_var_params['translations_en_body']))  # noqa: E501
        if 'translations_en_text' in local_var_params and local_var_params['translations_en_text'] is not None:  # noqa: E501
            query_params.append(('translations.en.text', local_var_params['translations_en_text']))  # noqa: E501
        if 'links_permalink' in local_var_params and local_var_params['links_permalink'] is not None:  # noqa: E501
            query_params.append(('links.permalink[]', local_var_params['links_permalink']))  # noqa: E501
            collection_formats['links.permalink[]'] = 'multi'  # noqa: E501
        if 'not_links_permalink' in local_var_params and local_var_params['not_links_permalink'] is not None:  # noqa: E501
            query_params.append(('!links.permalink[]', local_var_params['not_links_permalink']))  # noqa: E501
            collection_formats['!links.permalink[]'] = 'multi'  # noqa: E501
        if 'language' in local_var_params and local_var_params['language'] is not None:  # noqa: E501
            query_params.append(('language[]', local_var_params['language']))  # noqa: E501
            collection_formats['language[]'] = 'multi'  # noqa: E501
        if 'not_language' in local_var_params and local_var_params['not_language'] is not None:  # noqa: E501
            query_params.append(('!language[]', local_var_params['not_language']))  # noqa: E501
            collection_formats['!language[]'] = 'multi'  # noqa: E501
        if 'published_at_start' in local_var_params and local_var_params['published_at_start'] is not None:  # noqa: E501
            query_params.append(('published_at.start', local_var_params['published_at_start']))  # noqa: E501
        if 'published_at_end' in local_var_params and local_var_params['published_at_end'] is not None:  # noqa: E501
            query_params.append(('published_at.end', local_var_params['published_at_end']))  # noqa: E501
        if 'categories_taxonomy' in local_var_params and local_var_params['categories_taxonomy'] is not None:  # noqa: E501
            query_params.append(('categories.taxonomy', local_var_params['categories_taxonomy']))  # noqa: E501
        if 'categories_confident' in local_var_params and local_var_params['categories_confident'] is not None:  # noqa: E501
            query_params.append(('categories.confident', local_var_params['categories_confident']))  # noqa: E501
        if 'categories_id' in local_var_params and local_var_params['categories_id'] is not None:  # noqa: E501
            query_params.append(('categories.id[]', local_var_params['categories_id']))  # noqa: E501
            collection_formats['categories.id[]'] = 'multi'  # noqa: E501
        if 'not_categories_id' in local_var_params and local_var_params['not_categories_id'] is not None:  # noqa: E501
            query_params.append(('!categories.id[]', local_var_params['not_categories_id']))  # noqa: E501
            collection_formats['!categories.id[]'] = 'multi'  # noqa: E501
        if 'categories_label' in local_var_params and local_var_params['categories_label'] is not None:  # noqa: E501
            query_params.append(('categories.label[]', local_var_params['categories_label']))  # noqa: E501
            collection_formats['categories.label[]'] = 'multi'  # noqa: E501
        if 'not_categories_label' in local_var_params and local_var_params['not_categories_label'] is not None:  # noqa: E501
            query_params.append(('!categories.label[]', local_var_params['not_categories_label']))  # noqa: E501
            collection_formats['!categories.label[]'] = 'multi'  # noqa: E501
        if 'categories_level' in local_var_params and local_var_params['categories_level'] is not None:  # noqa: E501
            query_params.append(('categories.level[]', local_var_params['categories_level']))  # noqa: E501
            collection_formats['categories.level[]'] = 'multi'  # noqa: E501
        if 'not_categories_level' in local_var_params and local_var_params['not_categories_level'] is not None:  # noqa: E501
            query_params.append(('!categories.level[]', local_var_params['not_categories_level']))  # noqa: E501
            collection_formats['!categories.level[]'] = 'multi'  # noqa: E501
        if 'entities_id' in local_var_params and local_var_params['entities_id'] is not None:  # noqa: E501
            query_params.append(('entities.id[]', local_var_params['entities_id']))  # noqa: E501
            collection_formats['entities.id[]'] = 'multi'  # noqa: E501
        if 'not_entities_id' in local_var_params and local_var_params['not_entities_id'] is not None:  # noqa: E501
            query_params.append(('!entities.id[]', local_var_params['not_entities_id']))  # noqa: E501
            collection_formats['!entities.id[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikipedia' in local_var_params and local_var_params['entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikipedia[]', local_var_params['entities_links_wikipedia']))  # noqa: E501
            collection_formats['entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikipedia' in local_var_params and local_var_params['not_entities_links_wikipedia'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikipedia[]', local_var_params['not_entities_links_wikipedia']))  # noqa: E501
            collection_formats['!entities.links.wikipedia[]'] = 'multi'  # noqa: E501
        if 'entities_links_wikidata' in local_var_params and local_var_params['entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('entities.links.wikidata[]', local_var_params['entities_links_wikidata']))  # noqa: E501
            collection_formats['entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'not_entities_links_wikidata' in local_var_params and local_var_params['not_entities_links_wikidata'] is not None:  # noqa: E501
            query_params.append(('!entities.links.wikidata[]', local_var_params['not_entities_links_wikidata']))  # noqa: E501
            collection_formats['!entities.links.wikidata[]'] = 'multi'  # noqa: E501
        if 'entities_types' in local_var_params and local_var_params['entities_types'] is not None:  # noqa: E501
            query_params.append(('entities.types[]', local_var_params['entities_types']))  # noqa: E501
            collection_formats['entities.types[]'] = 'multi'  # noqa: E501
        if 'not_entities_types' in local_var_params and local_var_params['not_entities_types'] is not None:  # noqa: E501
            query_params.append(('!entities.types[]', local_var_params['not_entities_types']))  # noqa: E501
            collection_formats['!entities.types[]'] = 'multi'  # noqa: E501
        if 'entities_stock_tickers' in local_var_params and local_var_params['entities_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('entities.stock_tickers[]', local_var_params['entities_stock_tickers']))  # noqa: E501
            collection_formats['entities.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_body_stock_tickers' in local_var_params and local_var_params['entities_body_stock_tickers'] is not None:  # noqa: E501
            query_params.append(('!entities.body.stock_tickers[]', local_var_params['entities_body_stock_tickers']))  # noqa: E501
            collection_formats['!entities.body.stock_tickers[]'] = 'multi'  # noqa: E501
        if 'entities_surface_forms_text' in local_var_params and local_var_params['entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.surface_forms.text[]', local_var_params['entities_surface_forms_text']))  # noqa: E501
            collection_formats['entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_surface_forms_text' in local_var_params and local_var_params['not_entities_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.surface_forms.text[]', local_var_params['not_entities_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_title_surface_forms_text' in local_var_params and local_var_params['entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.title.surface_forms.text[]', local_var_params['entities_title_surface_forms_text']))  # noqa: E501
        if 'not_entities_title_surface_forms_text' in local_var_params and local_var_params['not_entities_title_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.title.surface_forms.text[]', local_var_params['not_entities_title_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.title.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'entities_body_surface_forms_text' in local_var_params and local_var_params['entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('entities.body.surface_forms.text[]', local_var_params['entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'not_entities_body_surface_forms_text' in local_var_params and local_var_params['not_entities_body_surface_forms_text'] is not None:  # noqa: E501
            query_params.append(('!entities.body.surface_forms.text[]', local_var_params['not_entities_body_surface_forms_text']))  # noqa: E501
            collection_formats['!entities.body.surface_forms.text[]'] = 'multi'  # noqa: E501
        if 'sentiment_title_polarity' in local_var_params and local_var_params['sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.title.polarity', local_var_params['sentiment_title_polarity']))  # noqa: E501
        if 'not_sentiment_title_polarity' in local_var_params and local_var_params['not_sentiment_title_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.title.polarity', local_var_params['not_sentiment_title_polarity']))  # noqa: E501
        if 'sentiment_body_polarity' in local_var_params and local_var_params['sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('sentiment.body.polarity', local_var_params['sentiment_body_polarity']))  # noqa: E501
        if 'not_sentiment_body_polarity' in local_var_params and local_var_params['not_sentiment_body_polarity'] is not None:  # noqa: E501
            query_params.append(('!sentiment.body.polarity', local_var_params['not_sentiment_body_polarity']))  # noqa: E501
        if 'media_images_count_min' in local_var_params and local_var_params['media_images_count_min'] is not None:  # noqa: E501
            query_params.append(('media.images.count.min', local_var_params['media_images_count_min']))  # noqa: E501
        if 'media_images_count_max' in local_var_params and local_var_params['media_images_count_max'] is not None:  # noqa: E501
            query_params.append(('media.images.count.max', local_var_params['media_images_count_max']))  # noqa: E501
        if 'media_images_width_min' in local_var_params and local_var_params['media_images_width_min'] is not None:  # noqa: E501
            query_params.append(('media.images.width.min', local_var_params['media_images_width_min']))  # noqa: E501
        if 'media_images_width_max' in local_var_params and local_var_params['media_images_width_max'] is not None:  # noqa: E501
            query_params.append(('media.images.width.max', local_var_params['media_images_width_max']))  # noqa: E501
        if 'media_images_height_min' in local_var_params and local_var_params['media_images_height_min'] is not None:  # noqa: E501
            query_params.append(('media.images.height.min', local_var_params['media_images_height_min']))  # noqa: E501
        if 'media_images_height_max' in local_var_params and local_var_params['media_images_height_max'] is not None:  # noqa: E501
            query_params.append(('media.images.height.max', local_var_params['media_images_height_max']))  # noqa: E501
        if 'media_images_content_length_min' in local_var_params and local_var_params['media_images_content_length_min'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.min', local_var_params['media_images_content_length_min']))  # noqa: E501
        if 'media_images_content_length_max' in local_var_params and local_var_params['media_images_content_length_max'] is not None:  # noqa: E501
            query_params.append(('media.images.content_length.max', local_var_params['media_images_content_length_max']))  # noqa: E501
        if 'media_images_format' in local_var_params and local_var_params['media_images_format'] is not None:  # noqa: E501
            query_params.append(('media.images.format[]', local_var_params['media_images_format']))  # noqa: E501
            collection_formats['media.images.format[]'] = 'multi'  # noqa: E501
        if 'not_media_images_format' in local_var_params and local_var_params['not_media_images_format'] is not None:  # noqa: E501
            query_params.append(('!media.images.format[]', local_var_params['not_media_images_format']))  # noqa: E501
            collection_formats['!media.images.format[]'] = 'multi'  # noqa: E501
        if 'media_videos_count_min' in local_var_params and local_var_params['media_videos_count_min'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.min', local_var_params['media_videos_count_min']))  # noqa: E501
        if 'media_videos_count_max' in local_var_params and local_var_params['media_videos_count_max'] is not None:  # noqa: E501
            query_params.append(('media.videos.count.max', local_var_params['media_videos_count_max']))  # noqa: E501
        if 'author_id' in local_var_params and local_var_params['author_id'] is not None:  # noqa: E501
            query_params.append(('author.id[]', local_var_params['author_id']))  # noqa: E501
            collection_formats['author.id[]'] = 'multi'  # noqa: E501
        if 'not_author_id' in local_var_params and local_var_params['not_author_id'] is not None:  # noqa: E501
            query_params.append(('!author.id[]', local_var_params['not_author_id']))  # noqa: E501
            collection_formats['!author.id[]'] = 'multi'  # noqa: E501
        if 'author_name' in local_var_params and local_var_params['author_name'] is not None:  # noqa: E501
            query_params.append(('author.name', local_var_params['author_name']))  # noqa: E501
        if 'not_author_name' in local_var_params and local_var_params['not_author_name'] is not None:  # noqa: E501
            query_params.append(('!author.name', local_var_params['not_author_name']))  # noqa: E501
        if 'source_id' in local_var_params and local_var_params['source_id'] is not None:  # noqa: E501
            query_params.append(('source.id[]', local_var_params['source_id']))  # noqa: E501
            collection_formats['source.id[]'] = 'multi'  # noqa: E501
        if 'not_source_id' in local_var_params and local_var_params['not_source_id'] is not None:  # noqa: E501
            query_params.append(('!source.id[]', local_var_params['not_source_id']))  # noqa: E501
            collection_formats['!source.id[]'] = 'multi'  # noqa: E501
        if 'source_name' in local_var_params and local_var_params['source_name'] is not None:  # noqa: E501
            query_params.append(('source.name[]', local_var_params['source_name']))  # noqa: E501
            collection_formats['source.name[]'] = 'multi'  # noqa: E501
        if 'not_source_name' in local_var_params and local_var_params['not_source_name'] is not None:  # noqa: E501
            query_params.append(('!source.name[]', local_var_params['not_source_name']))  # noqa: E501
            collection_formats['!source.name[]'] = 'multi'  # noqa: E501
        if 'source_domain' in local_var_params and local_var_params['source_domain'] is not None:  # noqa: E501
            query_params.append(('source.domain[]', local_var_params['source_domain']))  # noqa: E501
            collection_formats['source.domain[]'] = 'multi'  # noqa: E501
        if 'not_source_domain' in local_var_params and local_var_params['not_source_domain'] is not None:  # noqa: E501
            query_params.append(('!source.domain[]', local_var_params['not_source_domain']))  # noqa: E501
            collection_formats['!source.domain[]'] = 'multi'  # noqa: E501
        if 'source_locations_country' in local_var_params and local_var_params['source_locations_country'] is not None:  # noqa: E501
            query_params.append(('source.locations.country[]', local_var_params['source_locations_country']))  # noqa: E501
            collection_formats['source.locations.country[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_country' in local_var_params and local_var_params['not_source_locations_country'] is not None:  # noqa: E501
            query_params.append(('!source.locations.country[]', local_var_params['not_source_locations_country']))  # noqa: E501
            collection_formats['!source.locations.country[]'] = 'multi'  # noqa: E501
        if 'source_locations_state' in local_var_params and local_var_params['source_locations_state'] is not None:  # noqa: E501
            query_params.append(('source.locations.state[]', local_var_params['source_locations_state']))  # noqa: E501
            collection_formats['source.locations.state[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_state' in local_var_params and local_var_params['not_source_locations_state'] is not None:  # noqa: E501
            query_params.append(('!source.locations.state[]', local_var_params['not_source_locations_state']))  # noqa: E501
            collection_formats['!source.locations.state[]'] = 'multi'  # noqa: E501
        if 'source_locations_city' in local_var_params and local_var_params['source_locations_city'] is not None:  # noqa: E501
            query_params.append(('source.locations.city[]', local_var_params['source_locations_city']))  # noqa: E501
            collection_formats['source.locations.city[]'] = 'multi'  # noqa: E501
        if 'not_source_locations_city' in local_var_params and local_var_params['not_source_locations_city'] is not None:  # noqa: E501
            query_params.append(('!source.locations.city[]', local_var_params['not_source_locations_city']))  # noqa: E501
            collection_formats['!source.locations.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_country' in local_var_params and local_var_params['source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('source.scopes.country[]', local_var_params['source_scopes_country']))  # noqa: E501
            collection_formats['source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_country' in local_var_params and local_var_params['not_source_scopes_country'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.country[]', local_var_params['not_source_scopes_country']))  # noqa: E501
            collection_formats['!source.scopes.country[]'] = 'multi'  # noqa: E501
        if 'source_scopes_state' in local_var_params and local_var_params['source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('source.scopes.state[]', local_var_params['source_scopes_state']))  # noqa: E501
            collection_formats['source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_state' in local_var_params and local_var_params['not_source_scopes_state'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.state[]', local_var_params['not_source_scopes_state']))  # noqa: E501
            collection_formats['!source.scopes.state[]'] = 'multi'  # noqa: E501
        if 'source_scopes_city' in local_var_params and local_var_params['source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('source.scopes.city[]', local_var_params['source_scopes_city']))  # noqa: E501
            collection_formats['source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_city' in local_var_params and local_var_params['not_source_scopes_city'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.city[]', local_var_params['not_source_scopes_city']))  # noqa: E501
            collection_formats['!source.scopes.city[]'] = 'multi'  # noqa: E501
        if 'source_scopes_level' in local_var_params and local_var_params['source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('source.scopes.level[]', local_var_params['source_scopes_level']))  # noqa: E501
            collection_formats['source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'not_source_scopes_level' in local_var_params and local_var_params['not_source_scopes_level'] is not None:  # noqa: E501
            query_params.append(('!source.scopes.level[]', local_var_params['not_source_scopes_level']))  # noqa: E501
            collection_formats['!source.scopes.level[]'] = 'multi'  # noqa: E501
        if 'source_links_in_count_min' in local_var_params and local_var_params['source_links_in_count_min'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.min', local_var_params['source_links_in_count_min']))  # noqa: E501
        if 'source_links_in_count_max' in local_var_params and local_var_params['source_links_in_count_max'] is not None:  # noqa: E501
            query_params.append(('source.links_in_count.max', local_var_params['source_links_in_count_max']))  # noqa: E501
        if 'source_rankings_alexa_rank_min' in local_var_params and local_var_params['source_rankings_alexa_rank_min'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.min', local_var_params['source_rankings_alexa_rank_min']))  # noqa: E501
        if 'source_rankings_alexa_rank_max' in local_var_params and local_var_params['source_rankings_alexa_rank_max'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.rank.max', local_var_params['source_rankings_alexa_rank_max']))  # noqa: E501
        if 'source_rankings_alexa_country' in local_var_params and local_var_params['source_rankings_alexa_country'] is not None:  # noqa: E501
            query_params.append(('source.rankings.alexa.country[]', local_var_params['source_rankings_alexa_country']))  # noqa: E501
            collection_formats['source.rankings.alexa.country[]'] = 'multi'  # noqa: E501
        if 'social_shares_count_facebook_min' in local_var_params and local_var_params['social_shares_count_facebook_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.min', local_var_params['social_shares_count_facebook_min']))  # noqa: E501
        if 'social_shares_count_facebook_max' in local_var_params and local_var_params['social_shares_count_facebook_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.facebook.max', local_var_params['social_shares_count_facebook_max']))  # noqa: E501
        if 'social_shares_count_google_plus_min' in local_var_params and local_var_params['social_shares_count_google_plus_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.min', local_var_params['social_shares_count_google_plus_min']))  # noqa: E501
        if 'social_shares_count_google_plus_max' in local_var_params and local_var_params['social_shares_count_google_plus_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.google_plus.max', local_var_params['social_shares_count_google_plus_max']))  # noqa: E501
        if 'social_shares_count_linkedin_min' in local_var_params and local_var_params['social_shares_count_linkedin_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.min', local_var_params['social_shares_count_linkedin_min']))  # noqa: E501
        if 'social_shares_count_linkedin_max' in local_var_params and local_var_params['social_shares_count_linkedin_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.linkedin.max', local_var_params['social_shares_count_linkedin_max']))  # noqa: E501
        if 'social_shares_count_reddit_min' in local_var_params and local_var_params['social_shares_count_reddit_min'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.min', local_var_params['social_shares_count_reddit_min']))  # noqa: E501
        if 'social_shares_count_reddit_max' in local_var_params and local_var_params['social_shares_count_reddit_max'] is not None:  # noqa: E501
            query_params.append(('social_shares_count.reddit.max', local_var_params['social_shares_count_reddit_max']))  # noqa: E501
        if 'clusters' in local_var_params and local_var_params['clusters'] is not None:  # noqa: E501
            query_params.append(('clusters[]', local_var_params['clusters']))  # noqa: E501
            collection_formats['clusters[]'] = 'multi'  # noqa: E501
        if 'aql' in local_var_params and local_var_params['aql'] is not None:  # noqa: E501
            query_params.append(('aql', local_var_params['aql']))  # noqa: E501
        if 'aql_default_field' in local_var_params and local_var_params['aql_default_field'] is not None:  # noqa: E501
            query_params.append(('aql_default_field', local_var_params['aql_default_field']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'field' in local_var_params and local_var_params['field'] is not None:  # noqa: E501
            query_params.append(('field', local_var_params['field']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_id', 'app_key']  # noqa: E501

        return self.api_client.call_api(
            '/trends', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Trends',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
