# Yoti Python Sandbox SDK

Welcome to the Yoti Python Sandbox SDK. This repo contains the tools you need to test your Python back-end integration.

## Requirements

### Python version
Please refer to [Travis](https://travis-ci.com/getyoti/yoti-python-sdk-sandbox) to see all compatible Python versions.

Please email [sdksupport@yoti.com](mailto:sdksupport@yoti.com) if you require a version which is not listed here.

## Installing the Sandbox

To import the Yoti Sandbox SDK inside your project, you can use your favourite dependency management system.
If you are using pip, you can use the following command to set the Yoti Sandbox SDK as a dependency:

```shell
pip install yoti-sandbox
```

## Configuration

* `CLIENT_SDK_ID` is the SDK identifier generated by Yoti Hub in the Key tab when you create your app.

* `/path/to/your-pem-file.pem` is the path to the application pem file. It can be downloaded only once from the Keys tab in your Yoti Hub.

Please do not open the pem file as this might corrupt the key and you will need to create a new application.

## Profile Token Creation

```python
import json

from yoti_python_sandbox import SandboxClientBuilder
from yoti_python_sandbox import SandboxAgeVerificationBuilder
from yoti_python_sandbox import YotiTokenRequestBuilder

sdk_id = "CLIENT_SDK_ID"
pem_file_location = "/path/to/your-pem-file.pem"

client = (SandboxClientBuilder()
          .for_application(sdk_id)
          .with_pem_file(pem_file_location)
          .build())

age_verification = (SandboxAgeVerificationBuilder()
                    .with_date_of_birth("1989-01-02")
                    .with_age_over(18)
                    .build())

token_request = (YotiTokenRequestBuilder()
                 .with_remember_me_id("some_remember_me_id")
                 .with_given_names("Some Given Names")
                 .with_family_name("Some Family Name")
                 .with_full_name("Some Full Name")
                 .with_date_of_birth("1989-01-02")
                 .with_age_verification(age_verification)
                 .with_gender("Some Gender")
                 .with_phone_number("Some Phone Number")
                 .with_nationality("Some Nationality")
                 .with_postal_address("Some Postal Address")
                 .with_structured_postal_address(json.dumps({ "building_number": 1, "address_line1": "Some Address" }))
                 .with_base64_selfie("Some Base64 Encoded Selfie")
                 .with_email_address("Some Email Address")
                 .with_document_details("PASSPORT USA 1234abc")
                 .build())

token_response = client.setup_sharing_profile(token_request)

# Use the share_token to get Activity Details like normal
share_token = token_response.token
```

## Additional Information

For more information about the Yoti Sandbox, please visit https://developers.yoti.com/yoti/sandbox-app