"""Build output from Latex using Python and Jinja2 templating

Purpose:
latexbuild is a low-footprint build engine that simplifies
collaboration on Latex-driven projects.

This Module:
Imports useful functions and classes from other
modules and provides user-friendly function interfaces for
building PDF and HTML files from latex jinja2 templates
"""

#######################################################################
# Import useful functions from lower modules into main
#######################################################################
from .build import LatexBuild
from .jinja2_extension import render_latex_template

#######################################################################
# Define helper functions to demonstrate usage of LatexBuild
#######################################################################
def build_pdf(path_jinja2, template_name, path_outfile, template_kwargs=None):
    '''Helper function for building a pdf from a latex jinja2 template

    :param path_jinja2: the root directory for latex jinja2 templates
    :param template_name: the relative path, to path_jinja2, to the desired
        jinja2 Latex template
    :param path_outfile: the full path to the desired final output file
        Must contain the same file extension as files generated by
        cmd_wo_infile, otherwise the process will fail
    :param template_kwargs: a dictionary of key/values for jinja2 variables
    '''
    latex_template_object = LatexBuild(
            path_jinja2,
            template_name,
            template_kwargs,
            )
    return latex_template_object.build_pdf(path_outfile)

def build_html(path_jinja2, template_name, path_outfile, template_kwargs=None):
    '''Helper function for building an html from a latex jinja2 template

    :param path_jinja2: the root directory for latex jinja2 templates
    :param template_name: the relative path, to path_jinja2, to the desired
        jinja2 Latex template
    :param path_outfile: the full path to the desired final output file
        Must contain the same file extension as files generated by
        cmd_wo_infile, otherwise the process will fail
    :param template_kwargs: a dictionary of key/values for jinja2 variables
    '''
    latex_template_object = LatexBuild(
            path_jinja2,
            template_name,
            template_kwargs,
            )
    return latex_template_object.build_html(path_outfile)
