# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EventSourceMappingArgs', 'EventSourceMapping']

@pulumi.input_type
class EventSourceMappingArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[str],
                 batch_size: Optional[pulumi.Input[int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[bool]] = None,
                 destination_config: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 filter_criteria: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None,
                 parallelization_factor: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_event_source: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]] = None,
                 starting_position: Optional[pulumi.Input[str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[float]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a EventSourceMapping resource.
        :param pulumi.Input[str] function_name: The name of the Lambda function.
        :param pulumi.Input[int] batch_size: The maximum number of items to retrieve in a single batch.
        :param pulumi.Input[bool] bisect_batch_on_function_error: (Streams) If the function returns an error, split the batch in two and retry.
        :param pulumi.Input['EventSourceMappingDestinationConfigArgs'] destination_config: (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
        :param pulumi.Input[bool] enabled: Disables the event source mapping to pause polling and invocation.
        :param pulumi.Input[str] event_source_arn: The Amazon Resource Name (ARN) of the event source.
        :param pulumi.Input['EventSourceMappingFilterCriteriaArgs'] filter_criteria: The filter criteria to control event filtering.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]] function_response_types: (Streams) A list of response types supported by the function.
        :param pulumi.Input[int] maximum_batching_window_in_seconds: (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
        :param pulumi.Input[int] maximum_record_age_in_seconds: (Streams) The maximum age of a record that Lambda sends to a function for processing.
        :param pulumi.Input[int] maximum_retry_attempts: (Streams) The maximum number of times to retry when the function returns an error.
        :param pulumi.Input[int] parallelization_factor: (Streams) The number of batches to process from each shard concurrently.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queues: (ActiveMQ) A list of ActiveMQ queues.
        :param pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs'] self_managed_event_source: Self-managed event source endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]] source_access_configurations: A list of SourceAccessConfiguration.
        :param pulumi.Input[str] starting_position: The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
        :param pulumi.Input[float] starting_position_timestamp: With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: (Kafka) A list of Kafka topics.
        :param pulumi.Input[int] tumbling_window_in_seconds: (Streams) Tumbling window (non-overlapping time window) duration to perform aggregations.
        """
        pulumi.set(__self__, "function_name", function_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if bisect_batch_on_function_error is not None:
            pulumi.set(__self__, "bisect_batch_on_function_error", bisect_batch_on_function_error)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_source_arn is not None:
            pulumi.set(__self__, "event_source_arn", event_source_arn)
        if filter_criteria is not None:
            pulumi.set(__self__, "filter_criteria", filter_criteria)
        if function_response_types is not None:
            pulumi.set(__self__, "function_response_types", function_response_types)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if self_managed_event_source is not None:
            pulumi.set(__self__, "self_managed_event_source", self_managed_event_source)
        if source_access_configurations is not None:
            pulumi.set(__self__, "source_access_configurations", source_access_configurations)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if starting_position_timestamp is not None:
            pulumi.set(__self__, "starting_position_timestamp", starting_position_timestamp)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if tumbling_window_in_seconds is not None:
            pulumi.set(__self__, "tumbling_window_in_seconds", tumbling_window_in_seconds)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of items to retrieve in a single batch.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> Optional[pulumi.Input[bool]]:
        """
        (Streams) If the function returns an error, split the batch in two and retry.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @bisect_batch_on_function_error.setter
    def bisect_batch_on_function_error(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bisect_batch_on_function_error", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]:
        """
        (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables the event source mapping to pause polling and invocation.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the event source.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]:
        """
        The filter criteria to control event filtering.
        """
        return pulumi.get(self, "filter_criteria")

    @filter_criteria.setter
    def filter_criteria(self, value: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]):
        pulumi.set(self, "filter_criteria", value)

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]]:
        """
        (Streams) A list of response types supported by the function.
        """
        return pulumi.get(self, "function_response_types")

    @function_response_types.setter
    def function_response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]]):
        pulumi.set(self, "function_response_types", value)

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @maximum_batching_window_in_seconds.setter
    def maximum_batching_window_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_batching_window_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Streams) The maximum age of a record that Lambda sends to a function for processing.
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @maximum_record_age_in_seconds.setter
    def maximum_record_age_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_record_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        (Streams) The maximum number of times to retry when the function returns an error.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_retry_attempts", value)

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[pulumi.Input[int]]:
        """
        (Streams) The number of batches to process from each shard concurrently.
        """
        return pulumi.get(self, "parallelization_factor")

    @parallelization_factor.setter
    def parallelization_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelization_factor", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (ActiveMQ) A list of ActiveMQ queues.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "queues", value)

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]:
        """
        Self-managed event source endpoints.
        """
        return pulumi.get(self, "self_managed_event_source")

    @self_managed_event_source.setter
    def self_managed_event_source(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]):
        pulumi.set(self, "self_managed_event_source", value)

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]:
        """
        A list of SourceAccessConfiguration.
        """
        return pulumi.get(self, "source_access_configurations")

    @source_access_configurations.setter
    def source_access_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]):
        pulumi.set(self, "source_access_configurations", value)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[pulumi.Input[str]]:
        """
        The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
        """
        return pulumi.get(self, "starting_position")

    @starting_position.setter
    def starting_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "starting_position", value)

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> Optional[pulumi.Input[float]]:
        """
        With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @starting_position_timestamp.setter
    def starting_position_timestamp(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "starting_position_timestamp", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Kafka) A list of Kafka topics.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Streams) Tumbling window (non-overlapping time window) duration to perform aggregations.
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

    @tumbling_window_in_seconds.setter
    def tumbling_window_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tumbling_window_in_seconds", value)


class EventSourceMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[bool]] = None,
                 destination_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingDestinationConfigArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 filter_criteria: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingFilterCriteriaArgs']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None,
                 parallelization_factor: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_event_source: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedEventSourceArgs']]] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventSourceMappingSourceAccessConfigurationArgs']]]]] = None,
                 starting_position: Optional[pulumi.Input[str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[float]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lambda::EventSourceMapping

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] batch_size: The maximum number of items to retrieve in a single batch.
        :param pulumi.Input[bool] bisect_batch_on_function_error: (Streams) If the function returns an error, split the batch in two and retry.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingDestinationConfigArgs']] destination_config: (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
        :param pulumi.Input[bool] enabled: Disables the event source mapping to pause polling and invocation.
        :param pulumi.Input[str] event_source_arn: The Amazon Resource Name (ARN) of the event source.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingFilterCriteriaArgs']] filter_criteria: The filter criteria to control event filtering.
        :param pulumi.Input[str] function_name: The name of the Lambda function.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]] function_response_types: (Streams) A list of response types supported by the function.
        :param pulumi.Input[int] maximum_batching_window_in_seconds: (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
        :param pulumi.Input[int] maximum_record_age_in_seconds: (Streams) The maximum age of a record that Lambda sends to a function for processing.
        :param pulumi.Input[int] maximum_retry_attempts: (Streams) The maximum number of times to retry when the function returns an error.
        :param pulumi.Input[int] parallelization_factor: (Streams) The number of batches to process from each shard concurrently.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queues: (ActiveMQ) A list of ActiveMQ queues.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedEventSourceArgs']] self_managed_event_source: Self-managed event source endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventSourceMappingSourceAccessConfigurationArgs']]]] source_access_configurations: A list of SourceAccessConfiguration.
        :param pulumi.Input[str] starting_position: The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
        :param pulumi.Input[float] starting_position_timestamp: With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: (Kafka) A list of Kafka topics.
        :param pulumi.Input[int] tumbling_window_in_seconds: (Streams) Tumbling window (non-overlapping time window) duration to perform aggregations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventSourceMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lambda::EventSourceMapping

        :param str resource_name: The name of the resource.
        :param EventSourceMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventSourceMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[bool]] = None,
                 destination_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingDestinationConfigArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 filter_criteria: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingFilterCriteriaArgs']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None,
                 parallelization_factor: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_event_source: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedEventSourceArgs']]] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventSourceMappingSourceAccessConfigurationArgs']]]]] = None,
                 starting_position: Optional[pulumi.Input[str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[float]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventSourceMappingArgs.__new__(EventSourceMappingArgs)

            __props__.__dict__["batch_size"] = batch_size
            __props__.__dict__["bisect_batch_on_function_error"] = bisect_batch_on_function_error
            __props__.__dict__["destination_config"] = destination_config
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_source_arn"] = event_source_arn
            __props__.__dict__["filter_criteria"] = filter_criteria
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["function_response_types"] = function_response_types
            __props__.__dict__["maximum_batching_window_in_seconds"] = maximum_batching_window_in_seconds
            __props__.__dict__["maximum_record_age_in_seconds"] = maximum_record_age_in_seconds
            __props__.__dict__["maximum_retry_attempts"] = maximum_retry_attempts
            __props__.__dict__["parallelization_factor"] = parallelization_factor
            __props__.__dict__["queues"] = queues
            __props__.__dict__["self_managed_event_source"] = self_managed_event_source
            __props__.__dict__["source_access_configurations"] = source_access_configurations
            __props__.__dict__["starting_position"] = starting_position
            __props__.__dict__["starting_position_timestamp"] = starting_position_timestamp
            __props__.__dict__["topics"] = topics
            __props__.__dict__["tumbling_window_in_seconds"] = tumbling_window_in_seconds
        super(EventSourceMapping, __self__).__init__(
            'aws-native:lambda:EventSourceMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EventSourceMapping':
        """
        Get an existing EventSourceMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventSourceMappingArgs.__new__(EventSourceMappingArgs)

        __props__.__dict__["batch_size"] = None
        __props__.__dict__["bisect_batch_on_function_error"] = None
        __props__.__dict__["destination_config"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["event_source_arn"] = None
        __props__.__dict__["filter_criteria"] = None
        __props__.__dict__["function_name"] = None
        __props__.__dict__["function_response_types"] = None
        __props__.__dict__["maximum_batching_window_in_seconds"] = None
        __props__.__dict__["maximum_record_age_in_seconds"] = None
        __props__.__dict__["maximum_retry_attempts"] = None
        __props__.__dict__["parallelization_factor"] = None
        __props__.__dict__["queues"] = None
        __props__.__dict__["self_managed_event_source"] = None
        __props__.__dict__["source_access_configurations"] = None
        __props__.__dict__["starting_position"] = None
        __props__.__dict__["starting_position_timestamp"] = None
        __props__.__dict__["topics"] = None
        __props__.__dict__["tumbling_window_in_seconds"] = None
        return EventSourceMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of items to retrieve in a single batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> pulumi.Output[Optional[bool]]:
        """
        (Streams) If the function returns an error, split the batch in two and retry.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingDestinationConfig']]:
        """
        (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables the event source mapping to pause polling and invocation.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the event source.
        """
        return pulumi.get(self, "event_source_arn")

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> pulumi.Output[Optional['outputs.EventSourceMappingFilterCriteria']]:
        """
        The filter criteria to control event filtering.
        """
        return pulumi.get(self, "filter_criteria")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        The name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> pulumi.Output[Optional[Sequence['EventSourceMappingFunctionResponseTypesItem']]]:
        """
        (Streams) A list of response types supported by the function.
        """
        return pulumi.get(self, "function_response_types")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Streams) The maximum age of a record that Lambda sends to a function for processing.
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> pulumi.Output[Optional[int]]:
        """
        (Streams) The maximum number of times to retry when the function returns an error.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> pulumi.Output[Optional[int]]:
        """
        (Streams) The number of batches to process from each shard concurrently.
        """
        return pulumi.get(self, "parallelization_factor")

    @property
    @pulumi.getter
    def queues(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (ActiveMQ) A list of ActiveMQ queues.
        """
        return pulumi.get(self, "queues")

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> pulumi.Output[Optional['outputs.EventSourceMappingSelfManagedEventSource']]:
        """
        Self-managed event source endpoints.
        """
        return pulumi.get(self, "self_managed_event_source")

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.EventSourceMappingSourceAccessConfiguration']]]:
        """
        A list of SourceAccessConfiguration.
        """
        return pulumi.get(self, "source_access_configurations")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> pulumi.Output[Optional[str]]:
        """
        The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> pulumi.Output[Optional[float]]:
        """
        With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Kafka) A list of Kafka topics.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Streams) Tumbling window (non-overlapping time window) duration to perform aggregations.
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

