# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectorResult',
    'AwaitableGetConnectorResult',
    'get_connector',
    'get_connector_output',
]

@pulumi.output_type
class GetConnectorResult:
    def __init__(__self__, capacity=None, connector_arn=None):
        if capacity and not isinstance(capacity, dict):
            raise TypeError("Expected argument 'capacity' to be a dict")
        pulumi.set(__self__, "capacity", capacity)
        if connector_arn and not isinstance(connector_arn, str):
            raise TypeError("Expected argument 'connector_arn' to be a str")
        pulumi.set(__self__, "connector_arn", connector_arn)

    @property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.ConnectorCapacity']:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> Optional[str]:
        """
        Amazon Resource Name for the created Connector.
        """
        return pulumi.get(self, "connector_arn")


class AwaitableGetConnectorResult(GetConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorResult(
            capacity=self.capacity,
            connector_arn=self.connector_arn)


def get_connector(connector_arn: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorResult:
    """
    Resource Type definition for AWS::KafkaConnect::Connector


    :param str connector_arn: Amazon Resource Name for the created Connector.
    """
    __args__ = dict()
    __args__['connectorArn'] = connector_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:kafkaconnect:getConnector', __args__, opts=opts, typ=GetConnectorResult).value

    return AwaitableGetConnectorResult(
        capacity=__ret__.capacity,
        connector_arn=__ret__.connector_arn)


@_utilities.lift_output_func(get_connector)
def get_connector_output(connector_arn: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectorResult]:
    """
    Resource Type definition for AWS::KafkaConnect::Connector


    :param str connector_arn: Amazon Resource Name for the created Connector.
    """
    ...
