"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroAppsS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cf = require("aws-cdk-lib/aws-cloudfront");
const cforigins = require("aws-cdk-lib/aws-cloudfront-origins");
const s3 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * Create a new MicroApps S3 Bucket.
 */
class MicroAppsS3 extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { removalPolicy, assetNameRoot, assetNameSuffix } = props;
        // Use Auto-Delete S3Bucket if removal policy is DESTROY
        const s3AutoDeleteItems = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        //
        // S3 Bucket for Logging - Usable by many stacks
        //
        this._bucketLogs = new s3.Bucket(this, 'logs', {
            bucketName: props.bucketLogsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        //
        // S3 Buckets for Apps
        //
        this._bucketApps = new s3.Bucket(this, 'apps', {
            bucketName: props.bucketAppsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        this._bucketAppsStaging = new s3.Bucket(this, 'staging', {
            bucketName: props.bucketAppsStagingName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        // Create S3 Origin Identity
        this._bucketAppsOAI = new cf.OriginAccessIdentity(this, 'oai', {
            comment: assetNameRoot !== undefined ? `${assetNameRoot}${assetNameSuffix}` : undefined,
        });
        if (removalPolicy !== undefined) {
            this._bucketAppsOAI.applyRemovalPolicy(removalPolicy);
        }
        // Add Origin for CloudFront
        this._bucketAppsOrigin = new cforigins.S3Origin(this._bucketApps, {
            originAccessIdentity: this.bucketAppsOAI,
        });
    }
    get bucketApps() {
        return this._bucketApps;
    }
    get bucketAppsOAI() {
        return this._bucketAppsOAI;
    }
    get bucketAppsOrigin() {
        return this._bucketAppsOrigin;
    }
    get bucketAppsStaging() {
        return this._bucketAppsStaging;
    }
    get bucketLogs() {
        return this._bucketLogs;
    }
}
exports.MicroAppsS3 = MicroAppsS3;
_a = JSII_RTTI_SYMBOL_1;
MicroAppsS3[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroAppsS3", version: "0.2.10" };
//# sourceMappingURL=data:application/json;base64,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