import * as apigwy from '@aws-cdk/aws-apigatewayv2-alpha';
import { RemovalPolicy } from 'aws-cdk-lib';
import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as r53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
/**
 * Properties to initialize an instance of `MicroAppsAPIGwy`.
 */
export interface MicroAppsAPIGwyProps {
    /**
     * RemovalPolicy override for child resources
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * CloudFront edge domain name
     *
     * @example apps.pwrdrvr.com
     * @default auto-assigned
     */
    readonly domainNameEdge?: string;
    /**
     * API Gateway origin domain name
     *
     * @example apps-origin.pwrdrvr.com
     * @default auto-assigned
     */
    readonly domainNameOrigin?: string;
    /**
     * Optional asset name root
     *
     * @example microapps
     * @default - resource names auto assigned
     */
    readonly assetNameRoot?: string;
    /**
     * Optional asset name suffix
     *
     * @example -dev-pr-12
     * @default none
     */
    readonly assetNameSuffix?: string;
    /**
     * Optional local region ACM certificate to use for API Gateway
     * Note: required when using a custom domain
     *
     * @default none
     */
    readonly certOrigin?: acm.ICertificate;
    /**
     * Route53 zone in which to create optional `domainNameEdge` record
     */
    readonly r53Zone?: r53.IHostedZone;
    /**
     * Path prefix on the root of the API Gateway Stage
     *
     * @example dev/
     * @default none
     */
    readonly rootPathPrefix?: string;
}
/**
 * Represents a MicroApps API Gateway
 */
export interface IMicroAppsAPIGwy {
    /**
     * Domain Name applied to API Gateway origin
     */
    readonly dnAppsOrigin?: apigwy.IDomainName;
    /**
     * API Gateway
     */
    readonly httpApi: apigwy.HttpApi;
}
/**
 * Create a new MicroApps API Gateway HTTP API endpoint.
 */
export declare class MicroAppsAPIGwy extends Construct implements IMicroAppsAPIGwy {
    private _dnAppsOrigin;
    get dnAppsOrigin(): apigwy.IDomainName | undefined;
    private _httpApi;
    get httpApi(): apigwy.HttpApi;
    constructor(scope: Construct, id: string, props?: MicroAppsAPIGwyProps);
}
//# sourceMappingURL=MicroAppsAPIGwy.d.ts.map