"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroApps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const MicroAppsAPIGwy_1 = require("./MicroAppsAPIGwy");
const MicroAppsCF_1 = require("./MicroAppsCF");
const MicroAppsS3_1 = require("./MicroAppsS3");
const MicroAppsSvcs_1 = require("./MicroAppsSvcs");
const ReverseDomain_1 = require("./utils/ReverseDomain");
/**
 * Create a new MicroApps "turnkey" construct for simple
 * deployments and for initial evaulation of the MicroApps framework.
 *
 * Use this construct to create a working entire stack.
 *
 * Do not use this construct when adding MicroApps to an existing
 * CloudFront, API Gateway, S3 Bucket, etc. or where access
 * to all features of the AWS Resources are needed (e.g. to
 * add additional Behaviors to the CloudFront distribution, set authorizors
 * on API Gateway, etc.).
 *
 *  @see {@link https://github.com/pwrdrvr/microapps-core/blob/main/packages/cdk/lib/MicroApps.ts | example usage in a CDK Stack }
 */
class MicroApps extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { domainNameEdge, domainNameOrigin, assetNameRoot, assetNameSuffix, r53Zone, certEdge, appEnv = 'dev', certOrigin, removalPolicy, s3PolicyBypassAROAs, s3PolicyBypassPrincipalARNs, s3StrictBucketPolicy, rootPathPrefix, createAPIPathRoute = true, } = props;
        this._s3 = new MicroAppsS3_1.MicroAppsS3(this, 's3', {
            removalPolicy,
            bucketLogsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-logs` : undefined,
            bucketAppsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}` : undefined,
            bucketAppsStagingName: domainNameEdge
                ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-staging`
                : undefined,
            assetNameRoot,
            assetNameSuffix,
        });
        this._apigwy = new MicroAppsAPIGwy_1.MicroAppsAPIGwy(this, 'api', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            r53Zone,
            certOrigin,
            rootPathPrefix,
        });
        this._cf = new MicroAppsCF_1.MicroAppsCF(this, 'cft', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            httpApi: this._apigwy.httpApi,
            r53Zone,
            certEdge,
            bucketAppsOrigin: this._s3.bucketAppsOrigin,
            bucketLogs: this._s3.bucketLogs,
            rootPathPrefix,
            createAPIPathRoute,
        });
        this._svcs = new MicroAppsSvcs_1.MicroAppsSvcs(this, 'svcs', {
            httpApi: this.apigwy.httpApi,
            removalPolicy,
            bucketApps: this._s3.bucketApps,
            bucketAppsOAI: this._s3.bucketAppsOAI,
            bucketAppsStaging: this._s3.bucketAppsStaging,
            assetNameRoot,
            assetNameSuffix,
            appEnv,
            s3PolicyBypassAROAs,
            s3PolicyBypassPrincipalARNs,
            s3StrictBucketPolicy,
            rootPathPrefix,
        });
    }
    get cf() {
        return this._cf;
    }
    get s3() {
        return this._s3;
    }
    get apigwy() {
        return this._apigwy;
    }
    get svcs() {
        return this._svcs;
    }
}
exports.MicroApps = MicroApps;
_a = JSII_RTTI_SYMBOL_1;
MicroApps[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroApps", version: "0.2.10" };
//# sourceMappingURL=data:application/json;base64,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