# Pure Storage FlashBlade REST 1.12 Python SDK Documentation
Pure Storage FlashBlade REST 1.12 Python SDK. Compatible with REST API versions 1.0 - 1.12. Developed by [Pure Storage, Inc](http://www.purestorage.com/). Documentations can be found at [purity-fb.readthedocs.io](http://purity-fb.readthedocs.io/).

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.12
- Package version: 1.12.1
- Build package: io.swagger.codegen.languages.PythonClientCodegen

For more information, please visit [http://www.purestorage.com](http://www.purestorage.com)

## Release Notes

### Package version 1.12.1
- This release of the purity_fb Python REST SDK accompanies the 3.2.0 release of Purity//FB.

#### Fixes
- Added 1.12 as a supported version for purity_fb.

### Package version 1.12.0
- This release of the purity_fb Python REST SDK accompanies the 3.2.0 release of Purity//FB.

#### New SDK Features
- Active Directory
- End User License Agreement (EULA)
- Object Store Access Policies
- API Clients/OAuth Support
- Object Virtual Style Hosting
- Supported Time Zones
- Instantaneous Hot UID/GID Performance Stats

Be sure to visit the [Purity//FB REST API 1.x Release Notes](https://support.purestorage.com/FlashBlade/Purity_FB/PurityFB_REST_API/01_Purity_FB_REST_API_Release_Notes) for complete descriptions and other relevant information for these features.

#### Improvements
- Added the parameter `ids` to the functions `update_lifecycle_rules` and `delete_lifecycle_rules` to manage lifecycle rules via GUIDs. When managing via GUIDs, either `bucket_names` or `bucket_ids` must be specified.

#### Fixes
- Added the parameter `names` to the function `create_link_aggregation_groups`.
- Replaced the parameter `promotion_status` with `requested_promotion_state` for the FileSystemPatch model.
- Removed the parameter `total` from the functions `list_file_systems`, `list_file_system_snapshots`, `list_file_system_replica_link_transfer`, `list_file_system_snapshots`, `list_file_system_snapshots_transfer`, and `list_keytabs`.
- Removed the parameter `total_only` from the function `list_keytabs`.
- Removed the parameters `name` and `id` from the PolicyPatch model.

### Package version 1.11.0
- This release of the purity_fb Python REST SDK accompanies the 3.1.1 release of Purity//FB.

#### New SDK Features
- Public key for SSH access
- Adding and removing NFS export rules
- File System Access Control configuration options to control NFSv3/v4.1 and SMB clients behavior for accessing the files and directories permissions

#### Improvements
- Added the property `total` to the Clients Performance response.
- Added the parameter `destroy_snapshots` to the function `update_policies`. This parameter must be set to `true` in order to remove rules that have snapshots created. Setting this parameter to `true` is an acknowledgement that some of the snapshots managed by this policy will be destroyed.

#### Fixes
- Added the property `rules` to the PolicyPatch model.


### Package version 1.10.0
- This release of the purity_fb Python REST SDK accompanies the 3.1.0 release of Purity//FB.
  
#### New SDK Features
- Welcome Banner
- Object Lifecycle Rules
- RBAC Roles
- Syslog Servers
- Import S3 Access Keys

#### Fixes
- Removed the parameter `ids` for the function `list_object_store_access_keys`.
  This optional parameter was mistakenly added in a previous version, but was not supported.


## Requirements

* __Python 2.7 or Python 3.4-3.6__
* certifi
* python-dateutil
* six >= 1.10
* urllib3 >= 1.15


## Installation & Usage
### pip install

There are two ways to use pip to install.

The first is the easiest, i.e., using pypi:

```sh
pip install purity_fb
```

The second is to install from Github:



```sh
pip install git+https://github.com/purestorage/purity_fb_python_client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/purestorage/purity_fb_python_client.git`)

Then import the package:
```python
import purity_fb
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import purity_fb
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from purity_fb import PurityFb, FileSystem, FileSystemSnapshot, SnapshotSuffix, rest

# create PurityFb object for a certain array
fb = PurityFb("10.255.8.20")
# this is required for versions before Purity//FB 2.1.3 because they only supports self-signed
# certificates. in later versions, this may be unnecessary if you have imported a certificate.
fb.disable_verify_ssl()
try:
    fb.login("T-e7e551be-fe5d-4669-baf5-670cd8ea0560")

    ## manage file systems
    fs_obj = FileSystem(name="myfs", provisioned=50000)
    # create a file system named myfs
    fb.file_systems.create_file_systems(fs_obj)
    # list all existing file systems
    fb.file_systems.list_file_systems()
    # destroy the file system myfs
    fb.file_systems.update_file_systems(name="myfs", attributes=FileSystem(destroyed=True))
    # eradicate the file system myfs
    fb.file_systems.delete_file_systems(name="myfs")

    ## manage file system snapshots
    fb.file_system_snapshots.create_file_system_snapshots(sources=["myfs"], suffix=SnapshotSuffix("mysnap"))
    fb.file_system_snapshots.list_file_system_snapshots()
    # destroy the file system snapshot myfs.mysnap
    fb.file_system_snapshots.update_file_system_snapshots(name="myfs.mysnap", attributes=FileSystemSnapshot(destroyed=True))
    # eradicate the file system snapshot myfs.mysnap
    fb.file_system_snapshots.delete_file_system_snapshots(name="myfs.mysnap")

    fb.logout()
except rest.ApiException as e:
    print("Exception: %s\n" % e)
```

## Documentation for PurityFb

A *PurityFb* object represents a FlashBlade device.

```class purity_fb.PurityFb(host, version=None, api_token=None)```

### *host*
The argument *host* is required, which is the IP address or host name of the device.
### *version*
The optional argument *version* is the REST version number that the client wants to target at.
If absent, the latest version is chosen.
### *api_token*
The optional argument *api_token* will be used to log into the array if specified.


### Methods


Following are generic methods for all versions.

Method | Parameters | Description
------------- | ------------- | -------------
*disable_verify_ssl* | none | Disable certificate verification for SSL. **This method must be executed before any other calls.**|
*list_versions* | none | List all available REST versions of the array. Public, authentication not required. |
*login* | *api_token* | Login to the REST server with a specified *api-token*. **This method must be executed successfully before making any function calls to any APIs.** | 
*logout* | n/a | Logout from the REST server |


Note: Purity//FB 2.2 and later versions do support configuring certificates for REST server. However, when a certificate is not configured, a user is required to call *disable_verify_ssl* before making any other function calls.
Once SSL verification is disabled, there will be warnings like the following:


```python
/opt/local/Library/Frameworks/Python.framework/Versions/3.6/lib/python3.6/site-packages/urllib3-1.20-py3.6.egg/urllib3/connectionpool.py:852: InsecureRequestWarning: Unverified HTTPS request is being made. Adding certificate verification is strongly advised. See: https://urllib3.readthedocs.io/en/latest/advanced-usage.html#ssl-warnings
  InsecureRequestWarning)
```
These warnings could be disabled using [urllib3.disable_warnings](http://urllib3.readthedocs.io/en/latest/reference/index.html#urllib3.disable_warnings).


### **Endpoint Properties**

Once *login* succeeds, different endpoints could be accessed through the following read-only properties of *PurityFb* objects.


#### **Non-version Endpoints**

First, there are general endpoints that are not specific to versions, including *api_version*
and *authentication*.

Property | Type | Descripstion
------------ | ------------- | -------------
*api_version* | [**VersionApi**](docs/VersionApi.md)  | Public APIs for querying supported REST versions. |
*authentication* | [**AuthenticationApi**](docs/AuthenticationApi.md)  | Login/logout APIs. |


#### **Versioned Endpoints**

Second, there are versioned endpoints that are secured by authentication and could be different from version to version.
One can specify the *version* parameter when creating a *PurityFb* object to choose APIs for a specific REST version.
If *version* is not specified, by default, the most recent REST version available on the server is chosen.


#### Call with HTTP information
Every method of each endpoint returns an object representing the body of the response from the server.
If other information such as response status code or response header is needed, the corresponding method 
```XXX_with_http_info()``` can be used. 
  
For example,

```python
fb = purity_fb.PurityFb("10.255.3.20")
fb.disable_verify_ssl()
fb.login("T-1eeb15b4-1288-49b2-b0cc-5a7c9e5d524f")
data = fb.file_systems.create_file_systems(FileSystem(name="myfs"))
```

Here *response_data* has type [FileSystemResponse](docs/FileSystemResponse.md). 
And if call with HTTP information, both the response status and header will be returned as well.

```(data, status, header) = fb.file_systems.create_file_systems_with_http_info(FileSystem(name="myfs"))```

### Request Timeout Configuration


#### Global Request Timeout

The property *PurityFb.request_timeout* allows one to get or update the global request timeout used by default for
all API calls. The default *request_timeout* is 10 seconds for connection, and 30 seconds for read.


Property | Type | Descripstion
------------ | ------------- | -------------
*request_timeout* | [**urllib3.Timeout**](http://urllib3.readthedocs.io/en/latest/reference/urllib3.util.html) | Set or get the global request timeout for accessing the device. |


For example, ```fb.request_timeout = urllib3.Timeout(connect=8.0, read=20.0)```. This updates all API call to have 8 seconds connection
timeout and 20 seconds read timeout by default.


#### One-time-only Request Timeout


All APIs support the keyword parameter *_request_timeout* 
(of type [**urllib3.Timeout**](http://urllib3.readthedocs.io/en/latest/reference/urllib3.util.html) ) 
to specify request timeout for a specific API call.

For example, 

```fb.file_systems.create_file_systems(FileSystem(name="myfs"), _request_timeout=urllib3.Timeout(connect=5.0, read=15.0))}} ```


### Retries

The property *PurityFb.request_retry* allows one to get or update the global retry setting used by default for
all API calls. The default *request_retry* is 5 retries per call.


Property | Type | Descripstion
------------ | ------------- | -------------
*request_retry* | [**urllib3.Retry**](http://urllib3.readthedocs.io/en/latest/reference/urllib3.util.html) | Set or get the global request timeout for accessing the device. |


For example, ```fb.request_retry = urllib3.Retry(total=20, connect=15, read=15)```. This updates all API call to have 
at most 20 retries in total, among which at most 15 connection retries and at most 15 read retries.


## Documentation for API Endpoints

All URIs are relative to *https://purity_fb_server/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActiveDirectoryApi* | [**create_active_directory**](docs/ActiveDirectoryApi.md#create_active_directory) | **POST** /1.12/active-directory | 
*ActiveDirectoryApi* | [**delete_active_directory**](docs/ActiveDirectoryApi.md#delete_active_directory) | **DELETE** /1.12/active-directory | 
*ActiveDirectoryApi* | [**list_active_directory**](docs/ActiveDirectoryApi.md#list_active_directory) | **GET** /1.12/active-directory | 
*ActiveDirectoryApi* | [**test_active_directory**](docs/ActiveDirectoryApi.md#test_active_directory) | **GET** /1.12/active-directory/test | 
*ActiveDirectoryApi* | [**update_active_directory**](docs/ActiveDirectoryApi.md#update_active_directory) | **PATCH** /1.12/active-directory | 
*AdminsApi* | [**list_admins**](docs/AdminsApi.md#list_admins) | **GET** /1.12/admins | 
*AdminsApi* | [**update_admins**](docs/AdminsApi.md#update_admins) | **PATCH** /1.12/admins | 
*AdminsCacheApi* | [**delete_admin_cache**](docs/AdminsCacheApi.md#delete_admin_cache) | **DELETE** /1.12/admins/cache | 
*AdminsCacheApi* | [**list_admin_cache**](docs/AdminsCacheApi.md#list_admin_cache) | **GET** /1.12/admins/cache | 
*AlertWatchersApi* | [**create_alert_watchers**](docs/AlertWatchersApi.md#create_alert_watchers) | **POST** /1.12/alert-watchers | 
*AlertWatchersApi* | [**delete_alert_watchers**](docs/AlertWatchersApi.md#delete_alert_watchers) | **DELETE** /1.12/alert-watchers | 
*AlertWatchersApi* | [**list_alert_watchers**](docs/AlertWatchersApi.md#list_alert_watchers) | **GET** /1.12/alert-watchers | 
*AlertWatchersApi* | [**test_alert_watchers**](docs/AlertWatchersApi.md#test_alert_watchers) | **GET** /1.12/alert-watchers/test | 
*AlertWatchersApi* | [**update_alert_watchers**](docs/AlertWatchersApi.md#update_alert_watchers) | **PATCH** /1.12/alert-watchers | 
*AlertsApi* | [**list_alerts**](docs/AlertsApi.md#list_alerts) | **GET** /1.12/alerts | 
*AlertsApi* | [**update_alerts**](docs/AlertsApi.md#update_alerts) | **PATCH** /1.12/alerts | 
*ApiClientsApi* | [**create_api_clients**](docs/ApiClientsApi.md#create_api_clients) | **POST** /1.12/api-clients | 
*ApiClientsApi* | [**delete_api_clients**](docs/ApiClientsApi.md#delete_api_clients) | **DELETE** /1.12/api-clients | 
*ApiClientsApi* | [**list_api_clients**](docs/ApiClientsApi.md#list_api_clients) | **GET** /1.12/api-clients | 
*ApiClientsApi* | [**update_api_clients**](docs/ApiClientsApi.md#update_api_clients) | **PATCH** /1.12/api-clients | 
*ArrayConnectionsApi* | [**create_array_connections**](docs/ArrayConnectionsApi.md#create_array_connections) | **POST** /1.12/array-connections | 
*ArrayConnectionsApi* | [**create_array_connections_connection_keys**](docs/ArrayConnectionsApi.md#create_array_connections_connection_keys) | **POST** /1.12/array-connections/connection-key | 
*ArrayConnectionsApi* | [**delete_array_connections**](docs/ArrayConnectionsApi.md#delete_array_connections) | **DELETE** /1.12/array-connections | 
*ArrayConnectionsApi* | [**list_array_connections**](docs/ArrayConnectionsApi.md#list_array_connections) | **GET** /1.12/array-connections | 
*ArrayConnectionsApi* | [**list_array_connections_connection_keys**](docs/ArrayConnectionsApi.md#list_array_connections_connection_keys) | **GET** /1.12/array-connections/connection-key | 
*ArrayConnectionsApi* | [**list_array_connections_paths**](docs/ArrayConnectionsApi.md#list_array_connections_paths) | **GET** /1.12/array-connections/path | 
*ArrayConnectionsApi* | [**list_array_connections_performance_replication**](docs/ArrayConnectionsApi.md#list_array_connections_performance_replication) | **GET** /1.12/array-connections/performance/replication | 
*ArrayConnectionsApi* | [**update_array_connections**](docs/ArrayConnectionsApi.md#update_array_connections) | **PATCH** /1.12/array-connections | 
*ArraysApi* | [**list_arrays**](docs/ArraysApi.md#list_arrays) | **GET** /1.12/arrays | 
*ArraysApi* | [**list_arrays_http_specific_performance**](docs/ArraysApi.md#list_arrays_http_specific_performance) | **GET** /1.12/arrays/http-specific-performance | 
*ArraysApi* | [**list_arrays_nfs_specific_performance**](docs/ArraysApi.md#list_arrays_nfs_specific_performance) | **GET** /1.12/arrays/nfs-specific-performance | 
*ArraysApi* | [**list_arrays_performance**](docs/ArraysApi.md#list_arrays_performance) | **GET** /1.12/arrays/performance | 
*ArraysApi* | [**list_arrays_performance_replication**](docs/ArraysApi.md#list_arrays_performance_replication) | **GET** /1.12/arrays/performance/replication | 
*ArraysApi* | [**list_arrays_s3_specific_performance**](docs/ArraysApi.md#list_arrays_s3_specific_performance) | **GET** /1.12/arrays/s3-specific-performance | 
*ArraysApi* | [**list_arrays_space**](docs/ArraysApi.md#list_arrays_space) | **GET** /1.12/arrays/space | 
*ArraysApi* | [**list_clients_performance**](docs/ArraysApi.md#list_clients_performance) | **GET** /1.12/arrays/clients/performance | 
*ArraysApi* | [**list_eulas**](docs/ArraysApi.md#list_eulas) | **GET** /1.12/arrays/eula | 
*ArraysApi* | [**list_supported_time_zones**](docs/ArraysApi.md#list_supported_time_zones) | **GET** /1.12/arrays/supported-time-zones | 
*ArraysApi* | [**update_arrays**](docs/ArraysApi.md#update_arrays) | **PATCH** /1.12/arrays | 
*ArraysApi* | [**update_eulas**](docs/ArraysApi.md#update_eulas) | **PATCH** /1.12/arrays/eula | 
*AuditsApi* | [**list_audits**](docs/AuditsApi.md#list_audits) | **GET** /1.12/audits | 
*AuthenticationApi* | [**login**](docs/AuthenticationApi.md#login) | **POST** /login | 
*AuthenticationApi* | [**logout**](docs/AuthenticationApi.md#logout) | **POST** /logout | 
*BladeApi* | [**list_blades**](docs/BladeApi.md#list_blades) | **GET** /1.12/blades | 
*BucketReplicaLinksApi* | [**create_bucket_replica_links**](docs/BucketReplicaLinksApi.md#create_bucket_replica_links) | **POST** /1.12/bucket-replica-links | 
*BucketReplicaLinksApi* | [**delete_bucket_replica_links**](docs/BucketReplicaLinksApi.md#delete_bucket_replica_links) | **DELETE** /1.12/bucket-replica-links | 
*BucketReplicaLinksApi* | [**list_bucket_replica_links**](docs/BucketReplicaLinksApi.md#list_bucket_replica_links) | **GET** /1.12/bucket-replica-links | 
*BucketReplicaLinksApi* | [**update_bucket_replica_links**](docs/BucketReplicaLinksApi.md#update_bucket_replica_links) | **PATCH** /1.12/bucket-replica-links | 
*BucketsApi* | [**create_buckets**](docs/BucketsApi.md#create_buckets) | **POST** /1.12/buckets | 
*BucketsApi* | [**delete_buckets**](docs/BucketsApi.md#delete_buckets) | **DELETE** /1.12/buckets | 
*BucketsApi* | [**list_buckets**](docs/BucketsApi.md#list_buckets) | **GET** /1.12/buckets | 
*BucketsApi* | [**list_buckets_performance**](docs/BucketsApi.md#list_buckets_performance) | **GET** /1.12/buckets/performance | 
*BucketsApi* | [**list_buckets_s3_specific_performance**](docs/BucketsApi.md#list_buckets_s3_specific_performance) | **GET** /1.12/buckets/s3-specific-performance | 
*BucketsApi* | [**update_buckets**](docs/BucketsApi.md#update_buckets) | **PATCH** /1.12/buckets | 
*CertificateGroupsApi* | [**add_certificate_group_certificates**](docs/CertificateGroupsApi.md#add_certificate_group_certificates) | **POST** /1.12/certificate-groups/certificates | 
*CertificateGroupsApi* | [**create_certificate_groups**](docs/CertificateGroupsApi.md#create_certificate_groups) | **POST** /1.12/certificate-groups | 
*CertificateGroupsApi* | [**delete_certificate_groups**](docs/CertificateGroupsApi.md#delete_certificate_groups) | **DELETE** /1.12/certificate-groups | 
*CertificateGroupsApi* | [**list_certificate_group_certificates**](docs/CertificateGroupsApi.md#list_certificate_group_certificates) | **GET** /1.12/certificate-groups/certificates | 
*CertificateGroupsApi* | [**list_certificate_group_uses**](docs/CertificateGroupsApi.md#list_certificate_group_uses) | **GET** /1.12/certificate-groups/uses | 
*CertificateGroupsApi* | [**list_certificate_groups**](docs/CertificateGroupsApi.md#list_certificate_groups) | **GET** /1.12/certificate-groups | 
*CertificateGroupsApi* | [**remove_certificate_group_certificates**](docs/CertificateGroupsApi.md#remove_certificate_group_certificates) | **DELETE** /1.12/certificate-groups/certificates | 
*CertificatesApi* | [**add_certificate_certificate_groups**](docs/CertificatesApi.md#add_certificate_certificate_groups) | **POST** /1.12/certificates/certificate-groups | 
*CertificatesApi* | [**create_certificates**](docs/CertificatesApi.md#create_certificates) | **POST** /1.12/certificates | 
*CertificatesApi* | [**delete_certificates**](docs/CertificatesApi.md#delete_certificates) | **DELETE** /1.12/certificates | 
*CertificatesApi* | [**list_certificate_certificate_groups**](docs/CertificatesApi.md#list_certificate_certificate_groups) | **GET** /1.12/certificates/certificate-groups | 
*CertificatesApi* | [**list_certificate_uses**](docs/CertificatesApi.md#list_certificate_uses) | **GET** /1.12/certificates/uses | 
*CertificatesApi* | [**list_certificates**](docs/CertificatesApi.md#list_certificates) | **GET** /1.12/certificates | 
*CertificatesApi* | [**remove_certificate_certificate_groups**](docs/CertificatesApi.md#remove_certificate_certificate_groups) | **DELETE** /1.12/certificates/certificate-groups | 
*CertificatesApi* | [**update_certificates**](docs/CertificatesApi.md#update_certificates) | **PATCH** /1.12/certificates | 
*DirectoryServicesApi* | [**list_directory_services**](docs/DirectoryServicesApi.md#list_directory_services) | **GET** /1.12/directory-services | 
*DirectoryServicesApi* | [**list_directory_services_roles**](docs/DirectoryServicesApi.md#list_directory_services_roles) | **GET** /1.12/directory-services/roles | 
*DirectoryServicesApi* | [**test_directory_services**](docs/DirectoryServicesApi.md#test_directory_services) | **GET** /1.12/directory-services/test | 
*DirectoryServicesApi* | [**test_directory_services_with_changes**](docs/DirectoryServicesApi.md#test_directory_services_with_changes) | **PATCH** /1.12/directory-services/test | 
*DirectoryServicesApi* | [**update_directory_services**](docs/DirectoryServicesApi.md#update_directory_services) | **PATCH** /1.12/directory-services | 
*DirectoryServicesApi* | [**update_directory_services_roles**](docs/DirectoryServicesApi.md#update_directory_services_roles) | **PATCH** /1.12/directory-services/roles | 
*DnsApi* | [**list_dns**](docs/DnsApi.md#list_dns) | **GET** /1.12/dns | 
*DnsApi* | [**update_dns**](docs/DnsApi.md#update_dns) | **PATCH** /1.12/dns | 
*FileSystemReplicaLinksApi* | [**create_file_system_replica_link_policies**](docs/FileSystemReplicaLinksApi.md#create_file_system_replica_link_policies) | **POST** /1.12/file-system-replica-links/policies | 
*FileSystemReplicaLinksApi* | [**create_file_system_replica_links**](docs/FileSystemReplicaLinksApi.md#create_file_system_replica_links) | **POST** /1.12/file-system-replica-links | 
*FileSystemReplicaLinksApi* | [**delete_file_system_replica_link_policies**](docs/FileSystemReplicaLinksApi.md#delete_file_system_replica_link_policies) | **DELETE** /1.12/file-system-replica-links/policies | 
*FileSystemReplicaLinksApi* | [**list_file_system_replica_link_policies**](docs/FileSystemReplicaLinksApi.md#list_file_system_replica_link_policies) | **GET** /1.12/file-system-replica-links/policies | 
*FileSystemReplicaLinksApi* | [**list_file_system_replica_link_transfer**](docs/FileSystemReplicaLinksApi.md#list_file_system_replica_link_transfer) | **GET** /1.12/file-system-replica-links/transfer | 
*FileSystemReplicaLinksApi* | [**list_file_system_replica_links**](docs/FileSystemReplicaLinksApi.md#list_file_system_replica_links) | **GET** /1.12/file-system-replica-links | 
*FileSystemSnapshotsApi* | [**create_file_system_snapshots**](docs/FileSystemSnapshotsApi.md#create_file_system_snapshots) | **POST** /1.12/file-system-snapshots | 
*FileSystemSnapshotsApi* | [**delete_file_system_snapshots**](docs/FileSystemSnapshotsApi.md#delete_file_system_snapshots) | **DELETE** /1.12/file-system-snapshots | 
*FileSystemSnapshotsApi* | [**delete_file_system_snapshots_transfer**](docs/FileSystemSnapshotsApi.md#delete_file_system_snapshots_transfer) | **DELETE** /1.12/file-system-snapshots/transfer | 
*FileSystemSnapshotsApi* | [**delete_filesystem_snapshot_policies**](docs/FileSystemSnapshotsApi.md#delete_filesystem_snapshot_policies) | **DELETE** /1.12/file-system-snapshots/policies | 
*FileSystemSnapshotsApi* | [**list_file_system_snapshots**](docs/FileSystemSnapshotsApi.md#list_file_system_snapshots) | **GET** /1.12/file-system-snapshots | 
*FileSystemSnapshotsApi* | [**list_file_system_snapshots_transfer**](docs/FileSystemSnapshotsApi.md#list_file_system_snapshots_transfer) | **GET** /1.12/file-system-snapshots/transfer | 
*FileSystemSnapshotsApi* | [**list_filesystem_snapshot_policies**](docs/FileSystemSnapshotsApi.md#list_filesystem_snapshot_policies) | **GET** /1.12/file-system-snapshots/policies | 
*FileSystemSnapshotsApi* | [**update_file_system_snapshots**](docs/FileSystemSnapshotsApi.md#update_file_system_snapshots) | **PATCH** /1.12/file-system-snapshots | 
*FileSystemsApi* | [**create_file_systems**](docs/FileSystemsApi.md#create_file_systems) | **POST** /1.12/file-systems | 
*FileSystemsApi* | [**create_filesystem_policies**](docs/FileSystemsApi.md#create_filesystem_policies) | **POST** /1.12/file-systems/policies | 
*FileSystemsApi* | [**delete_file_systems**](docs/FileSystemsApi.md#delete_file_systems) | **DELETE** /1.12/file-systems | 
*FileSystemsApi* | [**delete_filesystem_policies**](docs/FileSystemsApi.md#delete_filesystem_policies) | **DELETE** /1.12/file-systems/policies | 
*FileSystemsApi* | [**list_file_systems**](docs/FileSystemsApi.md#list_file_systems) | **GET** /1.12/file-systems | 
*FileSystemsApi* | [**list_file_systems_groups_performance**](docs/FileSystemsApi.md#list_file_systems_groups_performance) | **GET** /1.12/file-systems/groups/performance | 
*FileSystemsApi* | [**list_file_systems_performance**](docs/FileSystemsApi.md#list_file_systems_performance) | **GET** /1.12/file-systems/performance | 
*FileSystemsApi* | [**list_file_systems_users_performance**](docs/FileSystemsApi.md#list_file_systems_users_performance) | **GET** /1.12/file-systems/users/performance | 
*FileSystemsApi* | [**list_filesystem_policies**](docs/FileSystemsApi.md#list_filesystem_policies) | **GET** /1.12/file-systems/policies | 
*FileSystemsApi* | [**update_file_systems**](docs/FileSystemsApi.md#update_file_systems) | **PATCH** /1.12/file-systems | 
*HardwareApi* | [**list_hardware**](docs/HardwareApi.md#list_hardware) | **GET** /1.12/hardware | 
*HardwareApi* | [**update_hardware**](docs/HardwareApi.md#update_hardware) | **PATCH** /1.12/hardware | 
*HardwareConnectorsApi* | [**list_hardware_connectors**](docs/HardwareConnectorsApi.md#list_hardware_connectors) | **GET** /1.12/hardware-connectors | 
*HardwareConnectorsApi* | [**update_hardware_connectors**](docs/HardwareConnectorsApi.md#update_hardware_connectors) | **PATCH** /1.12/hardware-connectors | 
*KeytabsApi* | [**create_keytabs**](docs/KeytabsApi.md#create_keytabs) | **POST** /1.12/keytabs | 
*KeytabsApi* | [**delete_keytabs**](docs/KeytabsApi.md#delete_keytabs) | **DELETE** /1.12/keytabs | 
*KeytabsApi* | [**download_keytab_file**](docs/KeytabsApi.md#download_keytab_file) | **GET** /1.12/keytabs/download | 
*KeytabsApi* | [**list_keytabs**](docs/KeytabsApi.md#list_keytabs) | **GET** /1.12/keytabs | 
*KeytabsApi* | [**upload_keytab_file**](docs/KeytabsApi.md#upload_keytab_file) | **POST** /1.12/keytabs/upload | 
*LifecycleRulesApi* | [**create_lifecycle_rules**](docs/LifecycleRulesApi.md#create_lifecycle_rules) | **POST** /1.12/lifecycle-rules | 
*LifecycleRulesApi* | [**delete_lifecycle_rules**](docs/LifecycleRulesApi.md#delete_lifecycle_rules) | **DELETE** /1.12/lifecycle-rules | 
*LifecycleRulesApi* | [**list_lifecycle_rules**](docs/LifecycleRulesApi.md#list_lifecycle_rules) | **GET** /1.12/lifecycle-rules | 
*LifecycleRulesApi* | [**update_lifecycle_rules**](docs/LifecycleRulesApi.md#update_lifecycle_rules) | **PATCH** /1.12/lifecycle-rules | 
*LinkAggregationGroupsApi* | [**create_link_aggregation_groups**](docs/LinkAggregationGroupsApi.md#create_link_aggregation_groups) | **POST** /1.12/link-aggregation-groups | 
*LinkAggregationGroupsApi* | [**delete_link_aggregation_groups**](docs/LinkAggregationGroupsApi.md#delete_link_aggregation_groups) | **DELETE** /1.12/link-aggregation-groups | 
*LinkAggregationGroupsApi* | [**list_link_aggregation_groups**](docs/LinkAggregationGroupsApi.md#list_link_aggregation_groups) | **GET** /1.12/link-aggregation-groups | 
*LinkAggregationGroupsApi* | [**update_link_aggregation_groups**](docs/LinkAggregationGroupsApi.md#update_link_aggregation_groups) | **PATCH** /1.12/link-aggregation-groups | 
*LoginBannerApi* | [**list_login_banner**](docs/LoginBannerApi.md#list_login_banner) | **GET** /login-banner | 
*LogsApi* | [**list_logs**](docs/LogsApi.md#list_logs) | **GET** /1.12/logs | 
*NetworkInterfacesApi* | [**create_network_interfaces**](docs/NetworkInterfacesApi.md#create_network_interfaces) | **POST** /1.12/network-interfaces | 
*NetworkInterfacesApi* | [**delete_network_interfaces**](docs/NetworkInterfacesApi.md#delete_network_interfaces) | **DELETE** /1.12/network-interfaces | 
*NetworkInterfacesApi* | [**list_network_interfaces**](docs/NetworkInterfacesApi.md#list_network_interfaces) | **GET** /1.12/network-interfaces | 
*NetworkInterfacesApi* | [**update_network_interfaces**](docs/NetworkInterfacesApi.md#update_network_interfaces) | **PATCH** /1.12/network-interfaces | 
*ObjectStoreAccessKeysApi* | [**create_object_store_access_keys**](docs/ObjectStoreAccessKeysApi.md#create_object_store_access_keys) | **POST** /1.12/object-store-access-keys | 
*ObjectStoreAccessKeysApi* | [**delete_object_store_access_keys**](docs/ObjectStoreAccessKeysApi.md#delete_object_store_access_keys) | **DELETE** /1.12/object-store-access-keys | 
*ObjectStoreAccessKeysApi* | [**list_object_store_access_keys**](docs/ObjectStoreAccessKeysApi.md#list_object_store_access_keys) | **GET** /1.12/object-store-access-keys | 
*ObjectStoreAccessKeysApi* | [**update_object_store_access_keys**](docs/ObjectStoreAccessKeysApi.md#update_object_store_access_keys) | **PATCH** /1.12/object-store-access-keys | 
*ObjectStoreAccessPoliciesApi* | [**add_object_store_access_policies_object_store_users**](docs/ObjectStoreAccessPoliciesApi.md#add_object_store_access_policies_object_store_users) | **POST** /1.12/object-store-access-policies/object-store-users | 
*ObjectStoreAccessPoliciesApi* | [**list_object_store_access_policies**](docs/ObjectStoreAccessPoliciesApi.md#list_object_store_access_policies) | **GET** /1.12/object-store-access-policies | 
*ObjectStoreAccessPoliciesApi* | [**list_object_store_access_policies_object_store_users**](docs/ObjectStoreAccessPoliciesApi.md#list_object_store_access_policies_object_store_users) | **GET** /1.12/object-store-access-policies/object-store-users | 
*ObjectStoreAccessPoliciesApi* | [**remove_object_store_access_policies_object_store_users**](docs/ObjectStoreAccessPoliciesApi.md#remove_object_store_access_policies_object_store_users) | **DELETE** /1.12/object-store-access-policies/object-store-users | 
*ObjectStoreAccountsApi* | [**create_object_store_accounts**](docs/ObjectStoreAccountsApi.md#create_object_store_accounts) | **POST** /1.12/object-store-accounts | 
*ObjectStoreAccountsApi* | [**delete_object_store_accounts**](docs/ObjectStoreAccountsApi.md#delete_object_store_accounts) | **DELETE** /1.12/object-store-accounts | 
*ObjectStoreAccountsApi* | [**list_object_store_accounts**](docs/ObjectStoreAccountsApi.md#list_object_store_accounts) | **GET** /1.12/object-store-accounts | 
*ObjectStoreRemoteCredentialsApi* | [**create_object_store_remote_credentials**](docs/ObjectStoreRemoteCredentialsApi.md#create_object_store_remote_credentials) | **POST** /1.12/object-store-remote-credentials | 
*ObjectStoreRemoteCredentialsApi* | [**delete_object_store_remote_credentials**](docs/ObjectStoreRemoteCredentialsApi.md#delete_object_store_remote_credentials) | **DELETE** /1.12/object-store-remote-credentials | 
*ObjectStoreRemoteCredentialsApi* | [**list_object_store_remote_credentials**](docs/ObjectStoreRemoteCredentialsApi.md#list_object_store_remote_credentials) | **GET** /1.12/object-store-remote-credentials | 
*ObjectStoreRemoteCredentialsApi* | [**update_object_store_remote_credentials**](docs/ObjectStoreRemoteCredentialsApi.md#update_object_store_remote_credentials) | **PATCH** /1.12/object-store-remote-credentials | 
*ObjectStoreUsersApi* | [**add_object_store_users_object_store_access_policies**](docs/ObjectStoreUsersApi.md#add_object_store_users_object_store_access_policies) | **POST** /1.12/object-store-users/object-store-access-policies | 
*ObjectStoreUsersApi* | [**create_object_store_users**](docs/ObjectStoreUsersApi.md#create_object_store_users) | **POST** /1.12/object-store-users | 
*ObjectStoreUsersApi* | [**delete_object_store_users**](docs/ObjectStoreUsersApi.md#delete_object_store_users) | **DELETE** /1.12/object-store-users | 
*ObjectStoreUsersApi* | [**list_object_store_users**](docs/ObjectStoreUsersApi.md#list_object_store_users) | **GET** /1.12/object-store-users | 
*ObjectStoreUsersApi* | [**list_object_store_users_object_store_access_policies**](docs/ObjectStoreUsersApi.md#list_object_store_users_object_store_access_policies) | **GET** /1.12/object-store-users/object-store-access-policies | 
*ObjectStoreUsersApi* | [**remove_object_store_users_object_store_access_policies**](docs/ObjectStoreUsersApi.md#remove_object_store_users_object_store_access_policies) | **DELETE** /1.12/object-store-users/object-store-access-policies | 
*ObjectStoreVirtualHostsApi* | [**create_object_store_virtual_hosts**](docs/ObjectStoreVirtualHostsApi.md#create_object_store_virtual_hosts) | **POST** /1.12/object-store-virtual-hosts | 
*ObjectStoreVirtualHostsApi* | [**delete_object_store_virtual_hosts**](docs/ObjectStoreVirtualHostsApi.md#delete_object_store_virtual_hosts) | **DELETE** /1.12/object-store-virtual-hosts | 
*ObjectStoreVirtualHostsApi* | [**list_object_store_virtual_hosts**](docs/ObjectStoreVirtualHostsApi.md#list_object_store_virtual_hosts) | **GET** /1.12/object-store-virtual-hosts | 
*PoliciesApi* | [**create_policies**](docs/PoliciesApi.md#create_policies) | **POST** /1.12/policies | 
*PoliciesApi* | [**create_policy_file_system_replica_links**](docs/PoliciesApi.md#create_policy_file_system_replica_links) | **POST** /1.12/policies/file-system-replica-links | 
*PoliciesApi* | [**create_policy_filesystems**](docs/PoliciesApi.md#create_policy_filesystems) | **POST** /1.12/policies/file-systems | 
*PoliciesApi* | [**delete_policies**](docs/PoliciesApi.md#delete_policies) | **DELETE** /1.12/policies | 
*PoliciesApi* | [**delete_policy_file_system_replica_links**](docs/PoliciesApi.md#delete_policy_file_system_replica_links) | **DELETE** /1.12/policies/file-system-replica-links | 
*PoliciesApi* | [**delete_policy_filesystem_snapshots**](docs/PoliciesApi.md#delete_policy_filesystem_snapshots) | **DELETE** /1.12/policies/file-system-snapshots | 
*PoliciesApi* | [**delete_policy_filesystems**](docs/PoliciesApi.md#delete_policy_filesystems) | **DELETE** /1.12/policies/file-systems | 
*PoliciesApi* | [**list_policies**](docs/PoliciesApi.md#list_policies) | **GET** /1.12/policies | 
*PoliciesApi* | [**list_policy_file_system_replica_links**](docs/PoliciesApi.md#list_policy_file_system_replica_links) | **GET** /1.12/policies/file-system-replica-links | 
*PoliciesApi* | [**list_policy_filesystem_snapshots**](docs/PoliciesApi.md#list_policy_filesystem_snapshots) | **GET** /1.12/policies/file-system-snapshots | 
*PoliciesApi* | [**list_policy_filesystems**](docs/PoliciesApi.md#list_policy_filesystems) | **GET** /1.12/policies/file-systems | 
*PoliciesApi* | [**list_policy_members**](docs/PoliciesApi.md#list_policy_members) | **GET** /1.12/policies/members | 
*PoliciesApi* | [**update_policies**](docs/PoliciesApi.md#update_policies) | **PATCH** /1.12/policies | 
*QuotasGroupsApi* | [**create_group_quotas**](docs/QuotasGroupsApi.md#create_group_quotas) | **POST** /1.12/quotas/groups | 
*QuotasGroupsApi* | [**delete_group_quotas**](docs/QuotasGroupsApi.md#delete_group_quotas) | **DELETE** /1.12/quotas/groups | 
*QuotasGroupsApi* | [**list_group_quotas**](docs/QuotasGroupsApi.md#list_group_quotas) | **GET** /1.12/quotas/groups | 
*QuotasGroupsApi* | [**update_group_quotas**](docs/QuotasGroupsApi.md#update_group_quotas) | **PATCH** /1.12/quotas/groups | 
*QuotasSettingsApi* | [**list_quotas_settings**](docs/QuotasSettingsApi.md#list_quotas_settings) | **GET** /1.12/quotas/settings | 
*QuotasSettingsApi* | [**update_quotas_settings**](docs/QuotasSettingsApi.md#update_quotas_settings) | **PATCH** /1.12/quotas/settings | 
*QuotasUsersApi* | [**create_user_quotas**](docs/QuotasUsersApi.md#create_user_quotas) | **POST** /1.12/quotas/users | 
*QuotasUsersApi* | [**delete_user_quotas**](docs/QuotasUsersApi.md#delete_user_quotas) | **DELETE** /1.12/quotas/users | 
*QuotasUsersApi* | [**list_user_quotas**](docs/QuotasUsersApi.md#list_user_quotas) | **GET** /1.12/quotas/users | 
*QuotasUsersApi* | [**update_user_quotas**](docs/QuotasUsersApi.md#update_user_quotas) | **PATCH** /1.12/quotas/users | 
*RolesApi* | [**list_roles**](docs/RolesApi.md#list_roles) | **GET** /1.12/roles | 
*SmtpApi* | [**list_smtp**](docs/SmtpApi.md#list_smtp) | **GET** /1.12/smtp | 
*SmtpApi* | [**update_smtp**](docs/SmtpApi.md#update_smtp) | **PATCH** /1.12/smtp | 
*SnmpAgentsApi* | [**list_snmp_agents**](docs/SnmpAgentsApi.md#list_snmp_agents) | **GET** /1.12/snmp-agents | 
*SnmpAgentsApi* | [**list_snmp_agents_mib**](docs/SnmpAgentsApi.md#list_snmp_agents_mib) | **GET** /1.12/snmp-agents/mib | 
*SnmpAgentsApi* | [**update_snmp_agents**](docs/SnmpAgentsApi.md#update_snmp_agents) | **PATCH** /1.12/snmp-agents | 
*SnmpManagersApi* | [**create_snmp_managers**](docs/SnmpManagersApi.md#create_snmp_managers) | **POST** /1.12/snmp-managers | 
*SnmpManagersApi* | [**delete_snmp_managers**](docs/SnmpManagersApi.md#delete_snmp_managers) | **DELETE** /1.12/snmp-managers | 
*SnmpManagersApi* | [**list_snmp_managers**](docs/SnmpManagersApi.md#list_snmp_managers) | **GET** /1.12/snmp-managers | 
*SnmpManagersApi* | [**test_snmp_managers**](docs/SnmpManagersApi.md#test_snmp_managers) | **GET** /1.12/snmp-managers/test | 
*SnmpManagersApi* | [**update_snmp_managers**](docs/SnmpManagersApi.md#update_snmp_managers) | **PATCH** /1.12/snmp-managers | 
*SubnetsApi* | [**create_subnets**](docs/SubnetsApi.md#create_subnets) | **POST** /1.12/subnets | 
*SubnetsApi* | [**delete_subnets**](docs/SubnetsApi.md#delete_subnets) | **DELETE** /1.12/subnets | 
*SubnetsApi* | [**list_subnets**](docs/SubnetsApi.md#list_subnets) | **GET** /1.12/subnets | 
*SubnetsApi* | [**update_subnets**](docs/SubnetsApi.md#update_subnets) | **PATCH** /1.12/subnets | 
*SupportApi* | [**list_support**](docs/SupportApi.md#list_support) | **GET** /1.12/support | 
*SupportApi* | [**test_support**](docs/SupportApi.md#test_support) | **GET** /1.12/support/test | 
*SupportApi* | [**update_support**](docs/SupportApi.md#update_support) | **PATCH** /1.12/support | 
*SyslogApi* | [**create_syslog_servers**](docs/SyslogApi.md#create_syslog_servers) | **POST** /1.12/syslog-servers | 
*SyslogApi* | [**delete_syslog_servers**](docs/SyslogApi.md#delete_syslog_servers) | **DELETE** /1.12/syslog-servers | 
*SyslogApi* | [**list_syslog_servers**](docs/SyslogApi.md#list_syslog_servers) | **GET** /1.12/syslog-servers | 
*SyslogApi* | [**list_syslog_settings**](docs/SyslogApi.md#list_syslog_settings) | **GET** /1.12/syslog-servers/settings | 
*SyslogApi* | [**test_syslog_config**](docs/SyslogApi.md#test_syslog_config) | **GET** /1.12/syslog-servers/test | 
*SyslogApi* | [**update_syslog_servers**](docs/SyslogApi.md#update_syslog_servers) | **PATCH** /1.12/syslog-servers | 
*SyslogApi* | [**update_syslog_settings**](docs/SyslogApi.md#update_syslog_settings) | **PATCH** /1.12/syslog-servers/settings | 
*TargetsApi* | [**create_targets**](docs/TargetsApi.md#create_targets) | **POST** /1.12/targets | 
*TargetsApi* | [**delete_targets**](docs/TargetsApi.md#delete_targets) | **DELETE** /1.12/targets | 
*TargetsApi* | [**list_targets**](docs/TargetsApi.md#list_targets) | **GET** /1.12/targets | 
*TargetsApi* | [**list_targets_performance_replication**](docs/TargetsApi.md#list_targets_performance_replication) | **GET** /1.12/targets/performance/replication | 
*TargetsApi* | [**update_targets**](docs/TargetsApi.md#update_targets) | **PATCH** /1.12/targets | 
*UsageGroupsApi* | [**list_group_usage**](docs/UsageGroupsApi.md#list_group_usage) | **GET** /1.12/usage/groups | 
*UsageUsersApi* | [**list_user_usage**](docs/UsageUsersApi.md#list_user_usage) | **GET** /1.12/usage/users | 
*VersionApi* | [**list_versions**](docs/VersionApi.md#list_versions) | **GET** /api_version | 


## Documentation For Models

 - [ActiveDirectory](docs/ActiveDirectory.md)
 - [ActiveDirectoryPatch](docs/ActiveDirectoryPatch.md)
 - [ActiveDirectoryPost](docs/ActiveDirectoryPost.md)
 - [ActiveDirectoryResponse](docs/ActiveDirectoryResponse.md)
 - [Admin](docs/Admin.md)
 - [AdminApiToken](docs/AdminApiToken.md)
 - [AdminCache](docs/AdminCache.md)
 - [AdminCacheResponse](docs/AdminCacheResponse.md)
 - [AdminResponse](docs/AdminResponse.md)
 - [Alert](docs/Alert.md)
 - [AlertResponse](docs/AlertResponse.md)
 - [AlertWatcher](docs/AlertWatcher.md)
 - [AlertWatcherPost](docs/AlertWatcherPost.md)
 - [AlertWatcherResponse](docs/AlertWatcherResponse.md)
 - [AlertWatcherTest](docs/AlertWatcherTest.md)
 - [AlertWatcherTestResponse](docs/AlertWatcherTestResponse.md)
 - [ApiClientPatch](docs/ApiClientPatch.md)
 - [ApiClientPost](docs/ApiClientPost.md)
 - [ApiClientResp](docs/ApiClientResp.md)
 - [ApiClientsResponse](docs/ApiClientsResponse.md)
 - [ArrayConnection](docs/ArrayConnection.md)
 - [ArrayConnectionKey](docs/ArrayConnectionKey.md)
 - [ArrayConnectionKeyResponse](docs/ArrayConnectionKeyResponse.md)
 - [ArrayConnectionPath](docs/ArrayConnectionPath.md)
 - [ArrayConnectionPathResponse](docs/ArrayConnectionPathResponse.md)
 - [ArrayConnectionPost](docs/ArrayConnectionPost.md)
 - [ArrayConnectionResponse](docs/ArrayConnectionResponse.md)
 - [ArrayHttpPerformance](docs/ArrayHttpPerformance.md)
 - [ArrayHttpPerformanceResponse](docs/ArrayHttpPerformanceResponse.md)
 - [ArrayNfsPerformance](docs/ArrayNfsPerformance.md)
 - [ArrayNfsPerformanceResponse](docs/ArrayNfsPerformanceResponse.md)
 - [ArrayPerformance](docs/ArrayPerformance.md)
 - [ArrayPerformanceReplicationResponse](docs/ArrayPerformanceReplicationResponse.md)
 - [ArrayPerformanceResponse](docs/ArrayPerformanceResponse.md)
 - [ArrayResponse](docs/ArrayResponse.md)
 - [ArrayS3Performance](docs/ArrayS3Performance.md)
 - [ArrayS3PerformanceResponse](docs/ArrayS3PerformanceResponse.md)
 - [ArraySpace](docs/ArraySpace.md)
 - [ArraySpaceResponse](docs/ArraySpaceResponse.md)
 - [Audit](docs/Audit.md)
 - [AuditResponse](docs/AuditResponse.md)
 - [BaseObjectType](docs/BaseObjectType.md)
 - [Blade](docs/Blade.md)
 - [BladeResponse](docs/BladeResponse.md)
 - [Bucket](docs/Bucket.md)
 - [BucketPatch](docs/BucketPatch.md)
 - [BucketPerformance](docs/BucketPerformance.md)
 - [BucketPerformanceResponse](docs/BucketPerformanceResponse.md)
 - [BucketPost](docs/BucketPost.md)
 - [BucketReplicaLink](docs/BucketReplicaLink.md)
 - [BucketReplicaLinkPost](docs/BucketReplicaLinkPost.md)
 - [BucketReplicaLinkResponse](docs/BucketReplicaLinkResponse.md)
 - [BucketResponse](docs/BucketResponse.md)
 - [BucketS3Performance](docs/BucketS3Performance.md)
 - [BucketS3PerformanceResponse](docs/BucketS3PerformanceResponse.md)
 - [BuiltIn](docs/BuiltIn.md)
 - [BuiltInWithId](docs/BuiltInWithId.md)
 - [Certificate](docs/Certificate.md)
 - [CertificateGroup](docs/CertificateGroup.md)
 - [CertificateGroupResponse](docs/CertificateGroupResponse.md)
 - [CertificateGroupUse](docs/CertificateGroupUse.md)
 - [CertificateGroupUseResponse](docs/CertificateGroupUseResponse.md)
 - [CertificatePost](docs/CertificatePost.md)
 - [CertificateResponse](docs/CertificateResponse.md)
 - [CertificateUse](docs/CertificateUse.md)
 - [CertificateUseResponse](docs/CertificateUseResponse.md)
 - [ClientPerformance](docs/ClientPerformance.md)
 - [ClientPerformanceResponse](docs/ClientPerformanceResponse.md)
 - [Direction](docs/Direction.md)
 - [DirectoryService](docs/DirectoryService.md)
 - [DirectoryServiceResponse](docs/DirectoryServiceResponse.md)
 - [DirectoryServiceRole](docs/DirectoryServiceRole.md)
 - [DirectoryServiceRolesResponse](docs/DirectoryServiceRolesResponse.md)
 - [DirectoryserviceManagement](docs/DirectoryserviceManagement.md)
 - [DirectoryserviceNfs](docs/DirectoryserviceNfs.md)
 - [DirectoryserviceSmb](docs/DirectoryserviceSmb.md)
 - [Dns](docs/Dns.md)
 - [DnsResponse](docs/DnsResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Eula](docs/Eula.md)
 - [EulaResponse](docs/EulaResponse.md)
 - [EulaSignature](docs/EulaSignature.md)
 - [FileSystem](docs/FileSystem.md)
 - [FileSystemGroupPerformance](docs/FileSystemGroupPerformance.md)
 - [FileSystemGroupPerformanceResponse](docs/FileSystemGroupPerformanceResponse.md)
 - [FileSystemPatch](docs/FileSystemPatch.md)
 - [FileSystemPerformance](docs/FileSystemPerformance.md)
 - [FileSystemPerformanceResponse](docs/FileSystemPerformanceResponse.md)
 - [FileSystemReplicaLink](docs/FileSystemReplicaLink.md)
 - [FileSystemReplicaLinkResponse](docs/FileSystemReplicaLinkResponse.md)
 - [FileSystemResponse](docs/FileSystemResponse.md)
 - [FileSystemSnapshot](docs/FileSystemSnapshot.md)
 - [FileSystemSnapshotResponse](docs/FileSystemSnapshotResponse.md)
 - [FileSystemSnapshotTransferResponse](docs/FileSystemSnapshotTransferResponse.md)
 - [FileSystemSnapshotsTransfer](docs/FileSystemSnapshotsTransfer.md)
 - [FileSystemUserPerformance](docs/FileSystemUserPerformance.md)
 - [FileSystemUserPerformanceResponse](docs/FileSystemUserPerformanceResponse.md)
 - [FilesystemgroupperformanceGroup](docs/FilesystemgroupperformanceGroup.md)
 - [FilesystemuserperformanceUser](docs/FilesystemuserperformanceUser.md)
 - [FixedReference](docs/FixedReference.md)
 - [FixedReferenceNoResourceType](docs/FixedReferenceNoResourceType.md)
 - [FixedReferenceWithId](docs/FixedReferenceWithId.md)
 - [FixedReferenceWithRemote](docs/FixedReferenceWithRemote.md)
 - [Hardware](docs/Hardware.md)
 - [HardwareConnector](docs/HardwareConnector.md)
 - [HardwareConnectorResponse](docs/HardwareConnectorResponse.md)
 - [HardwareResponse](docs/HardwareResponse.md)
 - [Keytab](docs/Keytab.md)
 - [KeytabDownloadUploadResponse](docs/KeytabDownloadUploadResponse.md)
 - [KeytabPost](docs/KeytabPost.md)
 - [KeytabResponse](docs/KeytabResponse.md)
 - [LifecycleRule](docs/LifecycleRule.md)
 - [LifecycleRulePatch](docs/LifecycleRulePatch.md)
 - [LifecycleRulePost](docs/LifecycleRulePost.md)
 - [LifecycleRuleResponse](docs/LifecycleRuleResponse.md)
 - [LinkAggregationGroup](docs/LinkAggregationGroup.md)
 - [LinkAggregationGroupPatch](docs/LinkAggregationGroupPatch.md)
 - [LinkAggregationGroupResponse](docs/LinkAggregationGroupResponse.md)
 - [LocationReference](docs/LocationReference.md)
 - [LogDownloadResponse](docs/LogDownloadResponse.md)
 - [LoginBannerResponse](docs/LoginBannerResponse.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [Member](docs/Member.md)
 - [MemberLink](docs/MemberLink.md)
 - [MemberResponse](docs/MemberResponse.md)
 - [MultiProtocolRule](docs/MultiProtocolRule.md)
 - [NetworkInterface](docs/NetworkInterface.md)
 - [NetworkInterfaceResponse](docs/NetworkInterfaceResponse.md)
 - [NfsRule](docs/NfsRule.md)
 - [NfsRulePatch](docs/NfsRulePatch.md)
 - [ObjectResponse](docs/ObjectResponse.md)
 - [ObjectStoreAccessKey](docs/ObjectStoreAccessKey.md)
 - [ObjectStoreAccessKeyPost](docs/ObjectStoreAccessKeyPost.md)
 - [ObjectStoreAccessKeyResponse](docs/ObjectStoreAccessKeyResponse.md)
 - [ObjectStoreAccessPolicy](docs/ObjectStoreAccessPolicy.md)
 - [ObjectStoreAccessPolicyObjectStoreUser](docs/ObjectStoreAccessPolicyObjectStoreUser.md)
 - [ObjectStoreAccessPolicyObjectStoreUserResponse](docs/ObjectStoreAccessPolicyObjectStoreUserResponse.md)
 - [ObjectStoreAccessPolicyResponse](docs/ObjectStoreAccessPolicyResponse.md)
 - [ObjectStoreAccount](docs/ObjectStoreAccount.md)
 - [ObjectStoreAccountResponse](docs/ObjectStoreAccountResponse.md)
 - [ObjectStoreRemoteCredentials](docs/ObjectStoreRemoteCredentials.md)
 - [ObjectStoreRemoteCredentialsResponse](docs/ObjectStoreRemoteCredentialsResponse.md)
 - [ObjectStoreUser](docs/ObjectStoreUser.md)
 - [ObjectStoreUserObjectStoreAccessPolicy](docs/ObjectStoreUserObjectStoreAccessPolicy.md)
 - [ObjectStoreUserObjectStoreAccessPolicyResponse](docs/ObjectStoreUserObjectStoreAccessPolicyResponse.md)
 - [ObjectStoreUserResponse](docs/ObjectStoreUserResponse.md)
 - [ObjectStoreVirtualHost](docs/ObjectStoreVirtualHost.md)
 - [ObjectStoreVirtualHostResponse](docs/ObjectStoreVirtualHostResponse.md)
 - [PaginationInfo](docs/PaginationInfo.md)
 - [PerformanceReplication](docs/PerformanceReplication.md)
 - [PerformanceReplicationResponse](docs/PerformanceReplicationResponse.md)
 - [Permission](docs/Permission.md)
 - [Policy](docs/Policy.md)
 - [PolicyMember](docs/PolicyMember.md)
 - [PolicyMemberResponse](docs/PolicyMemberResponse.md)
 - [PolicyMemberWithRemote](docs/PolicyMemberWithRemote.md)
 - [PolicyMemberWithRemoteResponse](docs/PolicyMemberWithRemoteResponse.md)
 - [PolicyObjects](docs/PolicyObjects.md)
 - [PolicyObjectsResponse](docs/PolicyObjectsResponse.md)
 - [PolicyPatch](docs/PolicyPatch.md)
 - [PolicyReference](docs/PolicyReference.md)
 - [PolicyReferenceWithId](docs/PolicyReferenceWithId.md)
 - [PolicyResponse](docs/PolicyResponse.md)
 - [PolicyRule](docs/PolicyRule.md)
 - [ProtocolRule](docs/ProtocolRule.md)
 - [PureArray](docs/PureArray.md)
 - [PureError](docs/PureError.md)
 - [PureObject](docs/PureObject.md)
 - [QuotasGroup](docs/QuotasGroup.md)
 - [QuotasGroupResponse](docs/QuotasGroupResponse.md)
 - [QuotasSetting](docs/QuotasSetting.md)
 - [QuotasSettingResponse](docs/QuotasSettingResponse.md)
 - [QuotasUser](docs/QuotasUser.md)
 - [QuotasUserResponse](docs/QuotasUserResponse.md)
 - [QuotasgroupGroup](docs/QuotasgroupGroup.md)
 - [QuotasuserUser](docs/QuotasuserUser.md)
 - [Reference](docs/Reference.md)
 - [ReferenceName](docs/ReferenceName.md)
 - [RelationshipPerformanceReplication](docs/RelationshipPerformanceReplication.md)
 - [RelationshipPerformanceReplicationResponse](docs/RelationshipPerformanceReplicationResponse.md)
 - [ReplicaLinkBuiltIn](docs/ReplicaLinkBuiltIn.md)
 - [ReplicationPerformance](docs/ReplicationPerformance.md)
 - [Resource](docs/Resource.md)
 - [ResourceRule](docs/ResourceRule.md)
 - [ResourceType](docs/ResourceType.md)
 - [Role](docs/Role.md)
 - [RoleResponse](docs/RoleResponse.md)
 - [SmbRule](docs/SmbRule.md)
 - [Smtp](docs/Smtp.md)
 - [SmtpResponse](docs/SmtpResponse.md)
 - [SnapshotSuffix](docs/SnapshotSuffix.md)
 - [SnmpAgent](docs/SnmpAgent.md)
 - [SnmpAgentMib](docs/SnmpAgentMib.md)
 - [SnmpAgentMibResponse](docs/SnmpAgentMibResponse.md)
 - [SnmpAgentResponse](docs/SnmpAgentResponse.md)
 - [SnmpManager](docs/SnmpManager.md)
 - [SnmpManagerPost](docs/SnmpManagerPost.md)
 - [SnmpManagerResponse](docs/SnmpManagerResponse.md)
 - [SnmpManagerTest](docs/SnmpManagerTest.md)
 - [SnmpManagerTestResponse](docs/SnmpManagerTestResponse.md)
 - [SnmpV2c](docs/SnmpV2c.md)
 - [SnmpV3](docs/SnmpV3.md)
 - [Space](docs/Space.md)
 - [Subnet](docs/Subnet.md)
 - [SubnetResponse](docs/SubnetResponse.md)
 - [Support](docs/Support.md)
 - [SupportRemoteAssistPaths](docs/SupportRemoteAssistPaths.md)
 - [SupportResponse](docs/SupportResponse.md)
 - [SupportedTimeZone](docs/SupportedTimeZone.md)
 - [SupportedTimeZoneResponse](docs/SupportedTimeZoneResponse.md)
 - [SyslogServer](docs/SyslogServer.md)
 - [SyslogServerPostOrPatch](docs/SyslogServerPostOrPatch.md)
 - [SyslogServerResponse](docs/SyslogServerResponse.md)
 - [SyslogServerSetting](docs/SyslogServerSetting.md)
 - [SyslogServerSettingPatch](docs/SyslogServerSettingPatch.md)
 - [SyslogServerSettingResponse](docs/SyslogServerSettingResponse.md)
 - [SyslogServerTest](docs/SyslogServerTest.md)
 - [SyslogServerTestResponse](docs/SyslogServerTestResponse.md)
 - [Target](docs/Target.md)
 - [TargetPost](docs/TargetPost.md)
 - [TargetResponse](docs/TargetResponse.md)
 - [TestResult](docs/TestResult.md)
 - [TestResultResponse](docs/TestResultResponse.md)
 - [VersionResponse](docs/VersionResponse.md)


## Documentation For Authorization


## ApiTokenQueryParam

- **Type**: API key
- **API key parameter name**: api-token
- **Location**: URL query string

## AuthTokenHeader

- **Type**: API key
- **API key parameter name**: x-auth-token
- **Location**: HTTP header


## Author

info@purestorage.com

