"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * Resource Policy for SecretsManager Secrets
 *
 * Policies define the operations that are allowed on this resource.
 *
 * You almost never need to define this construct directly.
 *
 * All AWS resources that support resource policies have a method called
 * `addToResourcePolicy()`, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 *
 * Prefer to use `addToResourcePolicy()` instead.
 */
class ResourcePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new iam.PolicyDocument();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_ResourcePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        new secretsmanager_generated_1.CfnResourcePolicy(this, 'Resource', {
            resourcePolicy: this.document,
            secretId: props.secret.secretArn,
        });
    }
}
exports.ResourcePolicy = ResourcePolicy;
_a = JSII_RTTI_SYMBOL_1;
ResourcePolicy[_a] = { fqn: "@aws-cdk/aws-secretsmanager.ResourcePolicy", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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