import { Stack } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
/**
 * A utility class that have common functions.
 */
export declare class Utils {
    /**
     * Will append the suffix to the given name if the name do not contain the suffix
     * @param name - a string
     * @param suffixes - the string to append
     * @returns the name with the suffix appended if necessary delimited by a hyphen
     */
    static appendIfNecessary(name: string, ...suffixes: string[]): string;
    /**
     * Will wrap the given string using the given delimiter.
     * @param str - the string to wrap
     * @param delimiter - the delimiter to use
     * @returns the wrapped string
     */
    static wrap(str: string, delimiter: string): string;
    /**
     * Will check if the given string starts with the given prefix.
     * @param str - a string
     * @param s - the prefix to check
     */
    static startsWith(str: string, s: string): boolean;
    /**
     * Will check if the given string ends with the given suffix.
     * @param str - a string
     * @param s - suffix to check
     */
    static endsWith(str: string, s: string): boolean;
    /**
     * Will check if the given object is empty
     * @param value
     */
    static isEmpty(value?: any): boolean;
    /**
     * Will convert the given string to lower case and transform any spaces to hyphens
     * @param str - a string
     */
    static kebabCase(str: string): string;
    /**
     * Splits a given Github URL and extracts the owner and repo name
     * @param url
     */
    static parseGithubUrl(url: string): any;
    /**
     * A utility function that will print the content of a CDK stack.
     * @warning This function is only used for debugging purpose.
     * @param stack - a valid stack
     */
    static prettyPrintStack(stack: Stack, persist?: boolean, path?: string): void;
    /**
     * Will disable the CDK NAG rule for the given construct and its children.
     * @param scope - the scope to disable the rule for
     * @param ruleId - the rule id to disable
     * @param reason - reason for disabling the rule.
     */
    static suppressNagRule(scope: IConstruct, ruleId: string, reason?: string): void;
}
//# sourceMappingURL=utils.d.ts.map