# Generated by Django 3.0.11 on 2021-02-08 16:14

from django.db import migrations


def create_submit_translation_permission(apps, schema_editor):
    ContentType = apps.get_model("contenttypes.ContentType")
    Permission = apps.get_model("auth.Permission")
    Group = apps.get_model("auth.Group")

    # Add a fake content type to hang the 'Can submit translations' permission off.
    # The fact that this doesn't correspond to an actual defined model shouldn't matter, I hope...
    wagtailadmin_optin_translation, created = ContentType.objects.get_or_create(
        app_label="wagtail_localize_panel",
        model="optin_translation",
    )

    wagtailadmin_localize_panel, created = ContentType.objects.get_or_create(
        app_label="wagtail_localize_panel",
        model="localize_panel",
    )


    # Create admin permission
    optin_translation_perm, created = Permission.objects.get_or_create(
        content_type=wagtailadmin_optin_translation,
        codename="optin_translation",
        name="Receive email on new translations",
    )
    view_localize_panel_perm, created = Permission.objects.get_or_create(
        content_type=wagtailadmin_localize_panel,
        codename="view_localize_panel",
        name="View the localize panel on the admin",
    )
    


def remove_submit_translation_permission(apps, schema_editor):
    ContentType = apps.get_model("contenttypes.ContentType")
    Permission = apps.get_model("auth.Permission")
    wagtailadmin_optin_translation = ContentType.objects.get(
        app_label="wagtail_localize_panel",
        model="optin_translation",
    )
    wagtailadmin_localize_panel = ContentType.objects.get(
        app_label="wagtail_localize_panel",
        model="localize_panel",
    )
    # This cascades to Group
    Permission.objects.filter(
        content_type=wagtailadmin_optin_translation,
        codename="optin_translation",
    ).delete()
    Permission.objects.filter(
        content_type=wagtailadmin_localize_panel,
        codename="view_localize_panel",
    ).delete()
    wagtailadmin_optin_translation.delete()
    wagtailadmin_localize_panel.delete()


class Migration(migrations.Migration):

    dependencies = [
        ("wagtail_localize_panel", "0001_add_permission")
    ]

    operations = [
        migrations.RunPython(
            create_submit_translation_permission, remove_submit_translation_permission
        ),
    ]
