(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main"],{

/***/ "./src/$$_lazy_route_resource lazy recursive":
/*!**********************************************************!*\
  !*** ./src/$$_lazy_route_resource lazy namespace object ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./dag-detail/dag-detail.module": [
		"./src/app/dag/dag-detail/dag-detail.module.ts",
		"default~dag-dag-module~dag-detail-dag-detail-module"
	],
	"./dag/dag.module": [
		"./src/app/dag/dag.module.ts",
		"default~dag-dag-module~dag-detail-dag-detail-module",
		"dag-dag-module"
	],
	"./report/report.module": [
		"./src/app/report/report.module.ts",
		"report-report-module"
	],
	"./skynet/skynet.module": [
		"./src/app/skynet/skynet.module.ts",
		"skynet-skynet-module"
	],
	"./task-detail/task-detail.module": [
		"./src/app/task/task-detail/task-detail.module.ts",
		"default~task-detail-task-detail-module~task-task-module"
	],
	"./task/task.module": [
		"./src/app/task/task.module.ts",
		"default~task-detail-task-detail-module~task-task-module",
		"task-task-module"
	]
};
function webpackAsyncContext(req) {
	var ids = map[req];
	if(!ids) {
		return Promise.resolve().then(function() {
			var e = new Error("Cannot find module '" + req + "'");
			e.code = 'MODULE_NOT_FOUND';
			throw e;
		});
	}
	return Promise.all(ids.slice(1).map(__webpack_require__.e)).then(function() {
		var id = ids[0];
		return __webpack_require__(id);
	});
}
webpackAsyncContext.keys = function webpackAsyncContextKeys() {
	return Object.keys(map);
};
webpackAsyncContext.id = "./src/$$_lazy_route_resource lazy recursive";
module.exports = webpackAsyncContext;

/***/ }),

/***/ "./src/app/_helpers/auth.gaurd.ts":
/*!****************************************!*\
  !*** ./src/app/_helpers/auth.gaurd.ts ***!
  \****************************************/
/*! exports provided: AuthGuard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuthGuard", function() { return AuthGuard; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");



var AuthGuard = /** @class */ (function () {
    function AuthGuard(router) {
        this.router = router;
    }
    AuthGuard.prototype.canActivate = function (route, state) {
        if (localStorage.getItem('token')) {
            // authorised so return true
            return true;
        }
        // not logged in so redirect to login page with the return url
        this.router.navigate(['/login'], { queryParams: { returnUrl: state.url } });
        return false;
    };
    AuthGuard = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({ providedIn: 'root' }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"]])
    ], AuthGuard);
    return AuthGuard;
}());



/***/ }),

/***/ "./src/app/_helpers/error.interceptor.ts":
/*!***********************************************!*\
  !*** ./src/app/_helpers/error.interceptor.ts ***!
  \***********************************************/
/*! exports provided: ErrorInterceptor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ErrorInterceptor", function() { return ErrorInterceptor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");





var ErrorInterceptor = /** @class */ (function () {
    function ErrorInterceptor(router) {
        this.router = router;
    }
    ErrorInterceptor.prototype.intercept = function (request, next) {
        var _this = this;
        return next.handle(request).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["catchError"])(function (err) {
            if (err.status === 401) {
                localStorage.removeItem('token');
                _this.router.navigate(['/login'], {
                    queryParams: {
                        returnUrl: _this.router.routerState.snapshot.url
                    }
                });
            }
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_2__["throwError"])(err);
        }));
    };
    ErrorInterceptor = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]])
    ], ErrorInterceptor);
    return ErrorInterceptor;
}());



/***/ }),

/***/ "./src/app/_helpers/jwt.intercepter.ts":
/*!*********************************************!*\
  !*** ./src/app/_helpers/jwt.intercepter.ts ***!
  \*********************************************/
/*! exports provided: JwtInterceptor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JwtInterceptor", function() { return JwtInterceptor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");


var JwtInterceptor = /** @class */ (function () {
    function JwtInterceptor() {
    }
    JwtInterceptor.prototype.intercept = function (request, next) {
        var token = localStorage.getItem('token');
        if (token) {
            request = request.clone({
                setHeaders: {
                    Authorization: token
                }
            });
        }
        return next.handle(request);
    };
    JwtInterceptor = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])()
    ], JwtInterceptor);
    return JwtInterceptor;
}());



/***/ }),

/***/ "./src/app/animations.ts":
/*!*******************************!*\
  !*** ./src/app/animations.ts ***!
  \*******************************/
/*! exports provided: slideInAnimation */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "slideInAnimation", function() { return slideInAnimation; });
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/animations */ "./node_modules/@angular/animations/fesm5/animations.js");

// Routable animations
var slideInAnimation = Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["trigger"])('routeAnimation', [
    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('heroes <=> hero', [
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ position: 'relative' }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter, :leave', [
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                position: 'absolute',
                top: 0,
                left: 0,
                width: '100%'
            })
        ]),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', [
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '-100%' })
        ]),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':leave', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animateChild"])()),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["group"])([
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':leave', [
                Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('300ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '100%' }))
            ]),
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', [
                Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('300ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '0%' }))
            ])
        ]),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animateChild"])()),
    ])
]);


/***/ }),

/***/ "./src/app/app-routing.module.ts":
/*!***************************************!*\
  !*** ./src/app/app-routing.module.ts ***!
  \***************************************/
/*! exports provided: AppRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppRoutingModule", function() { return AppRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _project_project_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./project/project.component */ "./src/app/project/project.component.ts");
/* harmony import */ var _computer_computer_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./computer/computer.component */ "./src/app/computer/computer.component.ts");
/* harmony import */ var _log_log_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./log/log.component */ "./src/app/log/log.component.ts");
/* harmony import */ var _helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_helpers/auth.gaurd */ "./src/app/_helpers/auth.gaurd.ts");
/* harmony import */ var _login_login_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./login/login.component */ "./src/app/login/login.component.ts");
/* harmony import */ var _model_model_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./model/model.component */ "./src/app/model/model.component.ts");
/* harmony import */ var _auxiliary_auxiliary_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./auxiliary/auxiliary.component */ "./src/app/auxiliary/auxiliary.component.ts");










var routes = [
    {
        path: '',
        redirectTo: '/projects',
        pathMatch: 'full',
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'login', component: _login_login_component__WEBPACK_IMPORTED_MODULE_7__["LoginComponent"]
    },
    {
        path: 'projects',
        component: _project_project_component__WEBPACK_IMPORTED_MODULE_3__["ProjectComponent"],
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'computers',
        component: _computer_computer_component__WEBPACK_IMPORTED_MODULE_4__["ComputerComponent"],
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'tasks',
        loadChildren: './task/task.module#TaskModule',
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'models',
        component: _model_model_component__WEBPACK_IMPORTED_MODULE_8__["ModelComponent"],
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'skynet',
        loadChildren: './skynet/skynet.module#SkynetModule',
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'dags',
        loadChildren: './dag/dag.module#DagModule',
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'logs',
        component: _log_log_component__WEBPACK_IMPORTED_MODULE_5__["LogComponent"],
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'reports',
        loadChildren: './report/report.module#ReportModule',
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
    {
        path: 'auxiliary',
        component: _auxiliary_auxiliary_component__WEBPACK_IMPORTED_MODULE_9__["AuxiliaryComponent"],
        canActivate: [_helpers_auth_gaurd__WEBPACK_IMPORTED_MODULE_6__["AuthGuard"]]
    },
];
var AppRoutingModule = /** @class */ (function () {
    function AppRoutingModule() {
    }
    AppRoutingModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forRoot(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], AppRoutingModule);
    return AppRoutingModule;
}());



/***/ }),

/***/ "./src/app/app-settings.ts":
/*!*********************************!*\
  !*** ./src/app/app-settings.ts ***!
  \*********************************/
/*! exports provided: AppSettings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppSettings", function() { return AppSettings; });
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../environments/environment */ "./src/environments/environment.ts");

var AppSettings = /** @class */ (function () {
    function AppSettings() {
    }
    Object.defineProperty(AppSettings, "API_ENDPOINT", {
        get: function () {
            var port = parseInt(window.location.port);
            if (Number.isNaN(port)) {
                port = 80;
            }
            if (!_environments_environment__WEBPACK_IMPORTED_MODULE_0__["environment"].production) {
                port += 1;
            }
            return "http://" + window.location.hostname + ":" + port + "/api/";
        },
        enumerable: true,
        configurable: true
    });
    AppSettings.status_colors = {
        'not_ran': 'gray',
        'queued': 'lightblue',
        'in_progress': 'lime',
        'failed': '#e83217',
        'stopped': '#cb88ea',
        'skipped': 'orange',
        'success': 'green'
    };
    AppSettings.log_colors = {
        'debug': 'gray',
        'info': 'lightblue',
        'warning': 'lightyellow',
        'error': 'red'
    };
    return AppSettings;
}());



/***/ }),

/***/ "./src/app/app.component.css":
/*!***********************************!*\
  !*** ./src/app/app.component.css ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "/* AppComponent's private CSS styles */\nh1 {\n  font-size: 1.2em;\n  color: #999;\n  margin-bottom: 0;\n}\nh2 {\n  font-size: 2em;\n  margin-top: 0;\n  padding-top: 0;\n}\nnav a {\n  padding: 5px 10px;\n  text-decoration: none;\n  margin-top: 10px;\n  display: inline-block;\n  background-color: #eee;\n  border-radius: 4px;\n}\nnav a:visited, a:link {\n  color: #607D8B;\n}\nnav a:hover {\n  color: #039be5;\n  background-color: #CFD8DC;\n}\nnav a.active {\n  color: #039be5;\n}\n.text-center {\n    text-align:center;\n}\n\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvYXBwLmNvbXBvbmVudC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsc0NBQXNDO0FBQ3RDO0VBQ0UsZ0JBQWdCO0VBQ2hCLFdBQVc7RUFDWCxnQkFBZ0I7QUFDbEI7QUFDQTtFQUNFLGNBQWM7RUFDZCxhQUFhO0VBQ2IsY0FBYztBQUNoQjtBQUNBO0VBQ0UsaUJBQWlCO0VBQ2pCLHFCQUFxQjtFQUNyQixnQkFBZ0I7RUFDaEIscUJBQXFCO0VBQ3JCLHNCQUFzQjtFQUN0QixrQkFBa0I7QUFDcEI7QUFDQTtFQUNFLGNBQWM7QUFDaEI7QUFDQTtFQUNFLGNBQWM7RUFDZCx5QkFBeUI7QUFDM0I7QUFDQTtFQUNFLGNBQWM7QUFDaEI7QUFFQTtJQUNJLGlCQUFpQjtBQUNyQiIsImZpbGUiOiJzcmMvYXBwL2FwcC5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLyogQXBwQ29tcG9uZW50J3MgcHJpdmF0ZSBDU1Mgc3R5bGVzICovXG5oMSB7XG4gIGZvbnQtc2l6ZTogMS4yZW07XG4gIGNvbG9yOiAjOTk5O1xuICBtYXJnaW4tYm90dG9tOiAwO1xufVxuaDIge1xuICBmb250LXNpemU6IDJlbTtcbiAgbWFyZ2luLXRvcDogMDtcbiAgcGFkZGluZy10b3A6IDA7XG59XG5uYXYgYSB7XG4gIHBhZGRpbmc6IDVweCAxMHB4O1xuICB0ZXh0LWRlY29yYXRpb246IG5vbmU7XG4gIG1hcmdpbi10b3A6IDEwcHg7XG4gIGRpc3BsYXk6IGlubGluZS1ibG9jaztcbiAgYmFja2dyb3VuZC1jb2xvcjogI2VlZTtcbiAgYm9yZGVyLXJhZGl1czogNHB4O1xufVxubmF2IGE6dmlzaXRlZCwgYTpsaW5rIHtcbiAgY29sb3I6ICM2MDdEOEI7XG59XG5uYXYgYTpob3ZlciB7XG4gIGNvbG9yOiAjMDM5YmU1O1xuICBiYWNrZ3JvdW5kLWNvbG9yOiAjQ0ZEOERDO1xufVxubmF2IGEuYWN0aXZlIHtcbiAgY29sb3I6ICMwMzliZTU7XG59XG5cbi50ZXh0LWNlbnRlciB7XG4gICAgdGV4dC1hbGlnbjpjZW50ZXI7XG59XG5cbiJdfQ== */"

/***/ }),

/***/ "./src/app/app.component.html":
/*!************************************!*\
  !*** ./src/app/app.component.html ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script src=\"../assets/visjs/vis.min.js\"></script>\n<link href=\"../assets/visjs/vis.min.css\" rel=\"stylesheet\" type=\"text/css\" />\n\n\n\n<p></p>\n\n<nav>\n  <a routerLink=\"/projects\" routerLinkActive=\"active\">Projects</a>\n  <a routerLink=\"/skynet/space\" routerLinkActive=\"active\">Skynet</a>\n  <a routerLink=\"/dags\" routerLinkActive=\"active\">Dags</a>\n  <a routerLink=\"/tasks\" routerLinkActive=\"active\">Tasks</a>\n  <a routerLink=\"/models\" routerLinkActive=\"active\">Models</a>\n  <a routerLink=\"/reports/list\" routerLinkActive=\"active\">Reports</a>\n  <a routerLink=\"/logs\" routerLinkActive=\"active\">Logs</a>\n  <a routerLink=\"/computers\" routerLinkActive=\"active\">Computers</a>\n  <a routerLink=\"/auxiliary\" routerLinkActive=\"active\">Auxiliary</a>\n</nav>\n\n<router-outlet #routerOutlet=\"outlet\"></router-outlet>"

/***/ }),

/***/ "./src/app/app.component.ts":
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/*! exports provided: AppComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppComponent", function() { return AppComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _animations__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./animations */ "./src/app/animations.ts");



var AppComponent = /** @class */ (function () {
    function AppComponent() {
        this.title = 'ML comp dashboard';
    }
    AppComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-root',
            template: __webpack_require__(/*! ./app.component.html */ "./src/app/app.component.html"),
            animations: [_animations__WEBPACK_IMPORTED_MODULE_2__["slideInAnimation"]],
            styles: [__webpack_require__(/*! ./app.component.css */ "./src/app/app.component.css")]
        })
    ], AppComponent);
    return AppComponent;
}());



/***/ }),

/***/ "./src/app/app.module.ts":
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/*! exports provided: AppModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppModule", function() { return AppModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared.module */ "./src/app/shared.module.ts");
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app-routing.module */ "./src/app/app-routing.module.ts");
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./app.component */ "./src/app/app.component.ts");
/* harmony import */ var _project_project_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./project/project.component */ "./src/app/project/project.component.ts");
/* harmony import */ var _computer_computer_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./computer/computer.component */ "./src/app/computer/computer.component.ts");
/* harmony import */ var _messages_messages_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./messages/messages.component */ "./src/app/messages/messages.component.ts");
/* harmony import */ var _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/platform-browser/animations */ "./node_modules/@angular/platform-browser/fesm5/animations.js");
/* harmony import */ var _login_login_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./login/login.component */ "./src/app/login/login.component.ts");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _helpers_jwt_intercepter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./_helpers/jwt.intercepter */ "./src/app/_helpers/jwt.intercepter.ts");
/* harmony import */ var _helpers_error_interceptor__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./_helpers/error.interceptor */ "./src/app/_helpers/error.interceptor.ts");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm5/http.js");
/* harmony import */ var _model_model_start_dialog_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./model/model-start-dialog.component */ "./src/app/model/model-start-dialog.component.ts");
/* harmony import */ var _model_model_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./model/model.component */ "./src/app/model/model.component.ts");
/* harmony import */ var _model_model_add_dialog_component__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./model/model-add-dialog.component */ "./src/app/model/model-add-dialog.component.ts");
/* harmony import */ var _project_project_add_dialog__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./project/project-add-dialog */ "./src/app/project/project-add-dialog.ts");
/* harmony import */ var _report_reports_report_add_dialog__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./report/reports/report-add-dialog */ "./src/app/report/reports/report-add-dialog.ts");
/* harmony import */ var _report_layouts_layout_add_dialog__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./report/layouts/layout-add-dialog */ "./src/app/report/layouts/layout-add-dialog.ts");
/* harmony import */ var _auxiliary_auxiliary_component__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./auxiliary/auxiliary.component */ "./src/app/auxiliary/auxiliary.component.ts");
/* harmony import */ var _task_task_table_task_info_dialog_component__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./task/task-table/task-info-dialog.component */ "./src/app/task/task-table/task-info-dialog.component.ts");
/* harmony import */ var _report_report_detail_report_update_dialog_component__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./report/report-detail/report-update-dialog.component */ "./src/app/report/report-detail/report-update-dialog.component.ts");
/* harmony import */ var _computer_sync_dialog__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./computer/sync-dialog */ "./src/app/computer/sync-dialog.ts");
/* harmony import */ var _auxiliary_supervisor_supervisor_component__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./auxiliary/supervisor/supervisor.component */ "./src/app/auxiliary/supervisor/supervisor.component.ts");

























var AppModule = /** @class */ (function () {
    function AppModule() {
    }
    AppModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _app_routing_module__WEBPACK_IMPORTED_MODULE_3__["AppRoutingModule"],
                _shared_module__WEBPACK_IMPORTED_MODULE_2__["SharedModule"],
                _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_8__["BrowserAnimationsModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_10__["ReactiveFormsModule"]
            ],
            declarations: [
                _app_component__WEBPACK_IMPORTED_MODULE_4__["AppComponent"],
                _project_project_component__WEBPACK_IMPORTED_MODULE_5__["ProjectComponent"],
                _project_project_add_dialog__WEBPACK_IMPORTED_MODULE_17__["ProjectAddDialogComponent"],
                _report_reports_report_add_dialog__WEBPACK_IMPORTED_MODULE_18__["ReportAddDialogComponent"],
                _report_layouts_layout_add_dialog__WEBPACK_IMPORTED_MODULE_19__["LayoutAddDialogComponent"],
                _model_model_add_dialog_component__WEBPACK_IMPORTED_MODULE_16__["ModelAddDialogComponent"],
                _model_model_start_dialog_component__WEBPACK_IMPORTED_MODULE_14__["ModelStartDialogComponent"],
                _task_task_table_task_info_dialog_component__WEBPACK_IMPORTED_MODULE_21__["TaskInfoDialogComponent"],
                _report_report_detail_report_update_dialog_component__WEBPACK_IMPORTED_MODULE_22__["ReportUpdateDialogComponent"],
                _messages_messages_component__WEBPACK_IMPORTED_MODULE_7__["MessagesComponent"],
                _computer_computer_component__WEBPACK_IMPORTED_MODULE_6__["ComputerComponent"],
                _model_model_component__WEBPACK_IMPORTED_MODULE_15__["ModelComponent"],
                _login_login_component__WEBPACK_IMPORTED_MODULE_9__["LoginComponent"],
                _auxiliary_auxiliary_component__WEBPACK_IMPORTED_MODULE_20__["AuxiliaryComponent"],
                _computer_sync_dialog__WEBPACK_IMPORTED_MODULE_23__["SyncDialogComponent"],
                _auxiliary_supervisor_supervisor_component__WEBPACK_IMPORTED_MODULE_24__["AuxiliarySupervisorComponent"]
            ],
            entryComponents: [
                _project_project_add_dialog__WEBPACK_IMPORTED_MODULE_17__["ProjectAddDialogComponent"],
                _model_model_add_dialog_component__WEBPACK_IMPORTED_MODULE_16__["ModelAddDialogComponent"],
                _model_model_start_dialog_component__WEBPACK_IMPORTED_MODULE_14__["ModelStartDialogComponent"],
                _report_reports_report_add_dialog__WEBPACK_IMPORTED_MODULE_18__["ReportAddDialogComponent"],
                _report_layouts_layout_add_dialog__WEBPACK_IMPORTED_MODULE_19__["LayoutAddDialogComponent"],
                _task_task_table_task_info_dialog_component__WEBPACK_IMPORTED_MODULE_21__["TaskInfoDialogComponent"],
                _report_report_detail_report_update_dialog_component__WEBPACK_IMPORTED_MODULE_22__["ReportUpdateDialogComponent"],
                _computer_sync_dialog__WEBPACK_IMPORTED_MODULE_23__["SyncDialogComponent"]
            ],
            providers: [
                {
                    provide: _angular_common_http__WEBPACK_IMPORTED_MODULE_13__["HTTP_INTERCEPTORS"],
                    useClass: _helpers_jwt_intercepter__WEBPACK_IMPORTED_MODULE_11__["JwtInterceptor"],
                    multi: true
                },
                {
                    provide: _angular_common_http__WEBPACK_IMPORTED_MODULE_13__["HTTP_INTERCEPTORS"],
                    useClass: _helpers_error_interceptor__WEBPACK_IMPORTED_MODULE_12__["ErrorInterceptor"],
                    multi: true
                }
            ],
            bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_4__["AppComponent"]]
        })
    ], AppModule);
    return AppModule;
}());



/***/ }),

/***/ "./src/app/auxiliary/auxiliary.component.css":
/*!***************************************************!*\
  !*** ./src/app/auxiliary/auxiliary.component.css ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2F1eGlsaWFyeS9hdXhpbGlhcnkuY29tcG9uZW50LmNzcyJ9 */"

/***/ }),

/***/ "./src/app/auxiliary/auxiliary.component.html":
/*!****************************************************!*\
  !*** ./src/app/auxiliary/auxiliary.component.html ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<app-auxiliary-supervisor [data]=\"data.supervisor\" *ngIf=\"data\">\n\n</app-auxiliary-supervisor>\n\n"

/***/ }),

/***/ "./src/app/auxiliary/auxiliary.component.ts":
/*!**************************************************!*\
  !*** ./src/app/auxiliary/auxiliary.component.ts ***!
  \**************************************************/
/*! exports provided: AuxiliaryComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliaryComponent", function() { return AuxiliaryComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _auxiliary_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./auxiliary.service */ "./src/app/auxiliary/auxiliary.service.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers */ "./src/app/helpers.ts");




var AuxiliaryComponent = /** @class */ (function () {
    function AuxiliaryComponent(service) {
        this.service = service;
    }
    AuxiliaryComponent.prototype.load = function () {
        var _this = this;
        this.service.get_obj({}).subscribe(function (data) {
            _this.data = _helpers__WEBPACK_IMPORTED_MODULE_3__["Helpers"].update_object(_this.data, data, [
                'supervisor.computers.name',
                'supervisor.parent_tasks_stats.id'
            ]);
        });
    };
    AuxiliaryComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.load();
        this.interval = setInterval(function () { return _this.load(); }, 3000);
    };
    AuxiliaryComponent.prototype.ngOnDestroy = function () {
        clearInterval(this.interval);
    };
    AuxiliaryComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-auxiliary',
            template: __webpack_require__(/*! ./auxiliary.component.html */ "./src/app/auxiliary/auxiliary.component.html"),
            styles: [__webpack_require__(/*! ./auxiliary.component.css */ "./src/app/auxiliary/auxiliary.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_auxiliary_service__WEBPACK_IMPORTED_MODULE_2__["AuxiliaryService"]])
    ], AuxiliaryComponent);
    return AuxiliaryComponent;
}());



/***/ }),

/***/ "./src/app/auxiliary/auxiliary.service.ts":
/*!************************************************!*\
  !*** ./src/app/auxiliary/auxiliary.service.ts ***!
  \************************************************/
/*! exports provided: AuxiliaryService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliaryService", function() { return AuxiliaryService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");



var AuxiliaryService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](AuxiliaryService, _super);
    function AuxiliaryService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.single_part = 'auxiliary';
        return _this;
    }
    AuxiliaryService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], AuxiliaryService);
    return AuxiliaryService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/auxiliary/supervisor/supervisor.component.css":
/*!***************************************************************!*\
  !*** ./src/app/auxiliary/supervisor/supervisor.component.css ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "a {\n    color: blue !important;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvYXV4aWxpYXJ5L3N1cGVydmlzb3Ivc3VwZXJ2aXNvci5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0lBQ0ksc0JBQXNCO0FBQzFCIiwiZmlsZSI6InNyYy9hcHAvYXV4aWxpYXJ5L3N1cGVydmlzb3Ivc3VwZXJ2aXNvci5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiYSB7XG4gICAgY29sb3I6IGJsdWUgIWltcG9ydGFudDtcbn0iXX0= */"

/***/ }),

/***/ "./src/app/auxiliary/supervisor/supervisor.component.html":
/*!****************************************************************!*\
  !*** ./src/app/auxiliary/supervisor/supervisor.component.html ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<h3>Supervisor</h3>\n\nLast processed: {{data.time| date:\"MM.dd H:mm:ss\"}}\n\nDuration: {{data.duration| number:'.2'}} seconds\n\n<h5>Queues:</h5>\n\n<ul *ngFor=\"let queue of data.queues\">\n    <li>{{queue}}</li>\n</ul>\n\n<h5>Computers:</h5>\n\n<ul *ngFor=\"let computer of data.computers\">\n    <li>\n        {{computer.name}}\n        <a *ngIf=\"!computer.expanded\" (click)=\"computer.expanded=true\">more</a>\n        <a *ngIf=\"computer.expanded\" (click)=\"computer.expanded=false\">less</a>\n\n        <div *ngIf=\"computer.expanded\">\n            <div>\n                Cpu free: {{computer.cpu}} ,\n                total {{computer.cpu_total}}\n            </div>\n\n            <div>\n                Memory free: {{computer.memory}} ,\n                total {{computer.memory_total}}\n            </div>\n\n            <div>\n                Gpu:\n                <ul *ngFor=\"let task_taken of computer.gpu; let i = index\">\n                    <li>\n                        {{i}}\n                        <span *ngIf=\"!task_taken\">free</span>\n                        <span *ngIf=\"task_taken\">taken by\n                            <a routerLink=\n                                       \"/tasks/task-detail/{{task_taken}}/logs\">\n                                {{task_taken}}\n                            </a>\n                        </span>\n                    </li>\n                </ul>\n            </div>\n\n            <div>\n                Used master ports:\n\n                {{computer.ports}}\n            </div>\n\n        </div>\n    </li>\n</ul>\n\n<h5>Parent tasks:</h5>\n\n\n<ul *ngFor=\"let parent_task of data.parent_tasks_stats\">\n    <li>\n        <a routerLink=\"/tasks/task-detail/{{parent_task.id}}/logs\">\n            {{parent_task.id}}\n        </a>\n\n        {{parent_task.name}}\n        <a *ngIf=\"!parent_task.expanded\" (click)=\"parent_task.expanded=true\">more</a>\n        <a *ngIf=\"parent_task.expanded\" (click)=\"parent_task.expanded=false\">less</a>\n\n        <div *ngIf=\"parent_task.expanded\">\n\n            <div>\n                Started: {{parent_task.started| date:\"MM.dd H:mm:ss\"}}\n            </div>\n\n            <div>\n                Statuses:\n\n                <ul *ngFor=\"let status of parent_task.statuses;\">\n                    <li>\n                        {{status.name}} - {{status.count}}\n                    </li>\n                </ul>\n\n            </div>\n\n        </div>\n    </li>\n</ul>\n\n<h5>Not ran tasks:</h5>\n\n<ul *ngFor=\"let task of data.not_ran_tasks\">\n    <li>\n        <a routerLink=\"/tasks/task-detail/{{task.id}}/logs\">\n            {{task.id}}\n        </a> {{task.name}}, dep_statuses: {{task.dep_status}}\n    </li>\n</ul>\n\n<h5>Process tasks:</h5>\n\n<ul *ngFor=\"let task of data.process_tasks\">\n    <li>\n        <a routerLink=\"/tasks/task-detail/{{task.id}}/logs\">\n            {{task.id}}\n        </a> {{task.name}}\n\n        <div *ngIf=\"task.not_valid\">\n            not_valid: {{task.not_valid}}\n        </div>\n\n        <ul *ngFor=\"let comp of task.computers\" style=\"padding-left: 20px\">\n            <li>\n                {{comp.name}}\n                <span *ngIf=\"comp.error\">{{comp.error}}</span>\n                <span *ngIf=\"!comp.error\">valid</span>\n            </li>\n        </ul>\n\n        <div *ngIf=\"task.to_send\">\n            To send: {{task.to_send}}\n        </div>\n\n    </li>\n</ul>"

/***/ }),

/***/ "./src/app/auxiliary/supervisor/supervisor.component.ts":
/*!**************************************************************!*\
  !*** ./src/app/auxiliary/supervisor/supervisor.component.ts ***!
  \**************************************************************/
/*! exports provided: AuxiliarySupervisorComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliarySupervisorComponent", function() { return AuxiliarySupervisorComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");



var AuxiliarySupervisorComponent = /** @class */ (function () {
    function AuxiliarySupervisorComponent() {
    }
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _models__WEBPACK_IMPORTED_MODULE_2__["AuxiliarySupervisor"])
    ], AuxiliarySupervisorComponent.prototype, "data", void 0);
    AuxiliarySupervisorComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-auxiliary-supervisor',
            template: __webpack_require__(/*! ./supervisor.component.html */ "./src/app/auxiliary/supervisor/supervisor.component.html"),
            styles: [__webpack_require__(/*! ./supervisor.component.css */ "./src/app/auxiliary/supervisor/supervisor.component.css")]
        })
    ], AuxiliarySupervisorComponent);
    return AuxiliarySupervisorComponent;
}());



/***/ }),

/***/ "./src/app/base.service.ts":
/*!*********************************!*\
  !*** ./src/app/base.service.ts ***!
  \*********************************/
/*! exports provided: BaseService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BaseService", function() { return BaseService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm5/http.js");
/* harmony import */ var _message_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./message.service */ "./src/app/message.service.ts");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./models */ "./src/app/models.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");








var BaseService = /** @class */ (function () {
    function BaseService(http, messageService) {
        this.http = http;
        this.messageService = messageService;
    }
    BaseService.prototype.get_paginator = function (filter) {
        var _this = this;
        var message = this.constructor.name + ".get_paginator";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_2__["AppSettings"].API_ENDPOINT + this.collection_part;
        return this.http.post(url, filter).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["tap"])(function (_) { return _this.log(message); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_6__["PaginatorRes"]())));
    };
    BaseService.prototype.get_obj = function (filter) {
        var _this = this;
        var message = this.constructor.name + ".get_obj";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_2__["AppSettings"].API_ENDPOINT + this.single_part;
        return this.http.post(url, filter).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["tap"])(function (_) { return _this.log(message); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["catchError"])(this.handleError(message, null)));
    };
    /**
     * Handle Http operation that failed.
     * Let the app continue.
     * @param operation - name of the operation that failed
     * @param result - optional value to return as the observable result
     */
    BaseService.prototype.handleError = function (operation, result) {
        var _this = this;
        if (operation === void 0) { operation = 'operation'; }
        return function (error) {
            console.error(error); // log to console instead
            _this.log(operation + " failed: " + error.message);
            // Let the app keep running by returning an empty result.
            var res = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, error.error, result);
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_5__["of"])(res);
        };
    };
    /** Log a DagService message with the MessageService */
    BaseService.prototype.log = function (message) {
        this.messageService.add("" + message);
    };
    BaseService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpClient"],
            _message_service__WEBPACK_IMPORTED_MODULE_4__["MessageService"]])
    ], BaseService);
    return BaseService;
}());



/***/ }),

/***/ "./src/app/computer/computer.component.css":
/*!*************************************************!*\
  !*** ./src/app/computer/computer.component.css ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table.mat-table {\n  width: 100%;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\ntd, th {\n  min-width: 90px;\n  text-align: center;\n}\n\n.mat-column-userId {\n  flex: 0 0 100px;\n}\n\ntd.usage_history, th.usage_history {\n  width: 55%;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n    margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\n.circle-green {\n    background: green;\n    width: 14px;\n    height: 14px;\n    border-radius: 50%;\n    display: inline-block;\n    vertical-align: middle;\n}\n\n.circle-red {\n    background: red;\n    width: 14px;\n    height: 14px;\n    border-radius: 50%;\n    display: inline-block;\n    vertical-align: middle;\n}\n\n.circle-gray {\n    background: gray;\n    width: 14px;\n    height: 14px;\n    border-radius: 50%;\n    display: inline-block;\n    vertical-align: middle;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvY29tcHV0ZXIvY29tcHV0ZXIuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLFdBQVc7QUFDYjs7QUFFQTtFQUNFLGVBQWU7RUFDZixXQUFXO0FBQ2I7O0FBRUE7RUFDRSxlQUFlO0VBQ2Ysa0JBQWtCO0FBQ3BCOztBQUVBO0VBQ0UsZUFBZTtBQUNqQjs7QUFFQTtFQUNFLFVBQVU7QUFDWjs7QUFFQTtFQUNFLFlBQVk7RUFDWixzQkFBc0I7RUFDdEIsa0JBQWtCO0lBQ2hCLDRCQUE0QjtBQUNoQzs7QUFFQTtFQUNFLDZCQUE2QjtBQUMvQjs7QUFFQTtJQUNJLGlCQUFpQjtJQUNqQixXQUFXO0lBQ1gsWUFBWTtJQUNaLGtCQUFrQjtJQUNsQixxQkFBcUI7SUFDckIsc0JBQXNCO0FBQzFCOztBQUVBO0lBQ0ksZUFBZTtJQUNmLFdBQVc7SUFDWCxZQUFZO0lBQ1osa0JBQWtCO0lBQ2xCLHFCQUFxQjtJQUNyQixzQkFBc0I7QUFDMUI7O0FBRUE7SUFDSSxnQkFBZ0I7SUFDaEIsV0FBVztJQUNYLFlBQVk7SUFDWixrQkFBa0I7SUFDbEIscUJBQXFCO0lBQ3JCLHNCQUFzQjtBQUMxQiIsImZpbGUiOiJzcmMvYXBwL2NvbXB1dGVyL2NvbXB1dGVyLmNvbXBvbmVudC5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyJ0YWJsZS5tYXQtdGFibGUge1xuICB3aWR0aDogMTAwJTtcbn1cblxuLm1hdC1mb3JtLWZpZWxkIHtcbiAgZm9udC1zaXplOiAxNHB4O1xuICB3aWR0aDogMTAwJTtcbn1cblxudGQsIHRoIHtcbiAgbWluLXdpZHRoOiA5MHB4O1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG59XG5cbi5tYXQtY29sdW1uLXVzZXJJZCB7XG4gIGZsZXg6IDAgMCAxMDBweDtcbn1cblxudGQudXNhZ2VfaGlzdG9yeSwgdGgudXNhZ2VfaGlzdG9yeSB7XG4gIHdpZHRoOiA1NSU7XG59XG5cbjo6bmctZGVlcCAubWF0LXNvcnQtaGVhZGVyLWNvbnRhaW5lcntcbiAgZGlzcGxheTpmbGV4O1xuICBqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyO1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgbWFyZ2luLWxlZnQ6IDEycHggIWltcG9ydGFudDtcbn1cblxuLm1hdC1oZWFkZXItY2VsbHtcbiAgdGV4dC1hbGlnbjogY2VudGVyICFpbXBvcnRhbnQ7XG59XG5cbi5jaXJjbGUtZ3JlZW4ge1xuICAgIGJhY2tncm91bmQ6IGdyZWVuO1xuICAgIHdpZHRoOiAxNHB4O1xuICAgIGhlaWdodDogMTRweDtcbiAgICBib3JkZXItcmFkaXVzOiA1MCU7XG4gICAgZGlzcGxheTogaW5saW5lLWJsb2NrO1xuICAgIHZlcnRpY2FsLWFsaWduOiBtaWRkbGU7XG59XG5cbi5jaXJjbGUtcmVkIHtcbiAgICBiYWNrZ3JvdW5kOiByZWQ7XG4gICAgd2lkdGg6IDE0cHg7XG4gICAgaGVpZ2h0OiAxNHB4O1xuICAgIGJvcmRlci1yYWRpdXM6IDUwJTtcbiAgICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gICAgdmVydGljYWwtYWxpZ246IG1pZGRsZTtcbn1cblxuLmNpcmNsZS1ncmF5IHtcbiAgICBiYWNrZ3JvdW5kOiBncmF5O1xuICAgIHdpZHRoOiAxNHB4O1xuICAgIGhlaWdodDogMTRweDtcbiAgICBib3JkZXItcmFkaXVzOiA1MCU7XG4gICAgZGlzcGxheTogaW5saW5lLWJsb2NrO1xuICAgIHZlcnRpY2FsLWFsaWduOiBtaWRkbGU7XG59Il19 */"

/***/ }),

/***/ "./src/app/computer/computer.component.html":
/*!**************************************************!*\
  !*** ./src/app/computer/computer.component.html ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"mat-elevation-z8\">\n    <table mat-table [dataSource]=\"dataSource\" matSort>\n\n        <ng-container matColumnDef=\"main\">\n            <th mat-header-cell *matHeaderCellDef class=\"name\">\n                Current stats\n\n                <button mat-raised-button\n                        style=\"height: 25px;\n                        margin-left: 10px;\n                        vertical-align: middle\"\n                        (click)=\"sync()\">\n                    Sync\n                </button>\n\n            </th>\n            <td mat-cell *matCellDef=\"let element\" class=\"name\"\n                style=\"vertical-align: top\">\n                <mat-grid-list rowHeight=\"50px\" cols=\"8\">\n                    <mat-grid-tile\n                            [colspan]=\"1\"\n                            [rowspan]=\"4\">\n                        <div style=\"width: 100%\">\n                            <div>{{element.name}}</div>\n                        </div>\n                    </mat-grid-tile>\n\n                    <mat-grid-tile\n                            [colspan]=\"1\"\n                            [rowspan]=\"4\">\n                        <div style=\"width: 100%\">\n                            <div>\n                                Cpu:\n                            </div>\n                            <div class=\"flex-wrapper\">\n                                <div class=\"single-chart\">\n                                    <svg\n                                            [matTooltip]=\n                                                    \"element.usage.cpu+'%'\"\n                                            viewBox=\"0 0 36 36\"\n                                            [attr.class]=\"'circular-chart '+\n                                            color(element.usage.cpu)\">\n                                        <path class=\"circle-bg\"\n                                              d=\"M18 2.0845\n                          a 15.9155 15.9155 0 0 1 0 31.831\n                          a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                        />\n\n                                        <path class=\"circle\"\n                                              [attr.stroke-dasharray]=\n                                                      \"element.usage.cpu+\n                                                      ', 100'\"\n                                              d=\"M18 2.0845\n                          a 15.9155 15.9155 0 0 1 0 31.831\n                          a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                        />\n\n                                        <text\n                                                x=\"18\"\n                                                y=\"20.35\"\n                                                class=\"percentage\">\n                                            {{element.cpu}}\n                                        </text>\n\n                                    </svg>\n                                </div>\n\n                            </div>\n                        </div>\n                    </mat-grid-tile>\n\n\n                    <mat-grid-tile\n                            [colspan]=\"1\"\n                            [rowspan]=\"4\">\n                        <div style=\"width: 100%\">\n                            <div>\n                                Memory:\n                            </div>\n                            <div class=\"flex-wrapper\">\n                                <div class=\"single-chart\">\n                                    <svg\n                                            [matTooltip]=\n                                                    \"element.usage.memory+'%'\"\n                                            viewBox=\"0 0 36 36\"\n                                            [attr.class]=\"'circular-chart '+\n                                            color(element.usage.memory)\">\n                                        <path class=\"circle-bg\"\n                                              d=\"M18 2.0845\n                  a 15.9155 15.9155 0 0 1 0 31.831\n                  a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                        />\n                                        <path class=\"circle\"\n                                              [attr.stroke-dasharray]=\n                                                      \"element.usage.memory+\n                                                      ', 100'\"\n                                              d=\"M18 2.0845\n                  a 15.9155 15.9155 0 0 1 0 31.831\n                  a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                        />\n                                        <text\n                                                x=\"18\"\n                                                y=\"20.35\"\n                                                class=\"percentage\">\n                                            {{element.memory}}\n                                        </text>\n                                    </svg>\n                                </div>\n\n                            </div>\n                        </div>\n                    </mat-grid-tile>\n\n                    <mat-grid-tile\n                            [colspan]=\"1\"\n                            [rowspan]=\"4\">\n                        <div style=\"width: 100%\">\n                            <div>\n                                Disk:\n                            </div>\n                            <div class=\"flex-wrapper\">\n                                <div class=\"single-chart\">\n                                    <svg\n                                            [matTooltip]=\n                                                    \"element.usage.disk+'%'\"\n                                            viewBox=\"0 0 36 36\"\n                                            [attr.class]=\"'circular-chart '+\n                                            color(element.usage.disk)\">\n                                        <path class=\"circle-bg\"\n                                              d=\"M18 2.0845\n                  a 15.9155 15.9155 0 0 1 0 31.831\n                  a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                        />\n                                        <path class=\"circle\"\n                                              [attr.stroke-dasharray]=\n                                                      \"element.usage.disk+\n                                                      ', 100'\"\n                                              d=\"M18 2.0845\n                  a 15.9155 15.9155 0 0 1 0 31.831\n                  a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                        />\n                                        <text\n                                                x=\"18\"\n                                                y=\"20.35\"\n                                                class=\"percentage\">\n                                            {{element.disk}}\n                                        </text>\n                                    </svg>\n                                </div>\n\n                            </div>\n                        </div>\n                    </mat-grid-tile>\n\n                    <mat-grid-tile\n                            *ngFor=\"let gpu of element.usage.gpu; index as i\"\n                            [colspan]=\"1\"\n                            [rowspan]=\"4\">\n                        <div style=\"width: 100%\">\n                            <div>Gpu {{i}}</div>\n                            <div class=\"single-chart\" matTooltip=\"load\">\n                                <svg\n                                        viewBox=\"0 0 36 36\"\n                                        [attr.class]=\"'circular-chart '+\n                                        color(gpu.load)\">\n                                    <path class=\"circle-bg\"\n                                          d=\"M18 2.0845\n                                      a 15.9155 15.9155 0 0 1 0 31.831\n                                      a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                    />\n                                    <path class=\"circle\"\n                                          [attr.stroke-dasharray]=\n                                                  \"gpu.load+', 100'\"\n                                          d=\"M18 2.0845\n                                      a 15.9155 15.9155 0 0 1 0 31.831\n                                      a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                    />\n                                    <text x=\"18\" y=\"20.35\" class=\"percentage\">\n                                        {{gpu.load}}%\n                                    </text>\n                                </svg>\n                            </div>\n                            <div class=\"single-chart\" matTooltip=\"memory\">\n                                <svg viewBox=\"0 0 36 36\"\n                                     [attr.class]=\"'circular-chart '+\n                                     color(gpu.memory)\">\n                                    <path class=\"circle-bg\"\n                                          d=\"M18 2.0845\n                                      a 15.9155 15.9155 0 0 1 0 31.831\n                                      a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                    />\n                                    <path class=\"circle\"\n                                          [attr.stroke-dasharray]=\n                                                  \"gpu.memory+', 100'\"\n                                          d=\"M18 2.0845\n                                      a 15.9155 15.9155 0 0 1 0 31.831\n                                      a 15.9155 15.9155 0 0 1 0 -31.831\"\n                                    />\n                                    <text x=\"18\" y=\"20.35\" class=\"percentage\">\n                                        {{gpu.memory}}%\n                                    </text>\n                                </svg>\n                            </div>\n                        </div>\n\n\n                    </mat-grid-tile>\n                </mat-grid-list>\n\n                <table>\n                    <td style=\"text-align: left\">Dockers:</td>\n                </table>\n\n                <table>\n                    <th></th>\n                    <th></th>\n                    <th style=\"width: 70px;min-width: 70px\"></th>\n                    <th style=\"width: 70px;min-width: 70px\"></th>\n                    <tr *ngFor=\"let docker of element.dockers\">\n                        <td>\n                            <span style=\"vertical-align: middle\">{{docker.name}}\n                                &nbsp;</span>\n                            <span\n                                    [matTooltip]=\"docker_status_tip(docker)\"\n                                    [className]=\"docker_status(docker)\">\n\n                            </span>\n                        </td>\n\n                        <td>{{long_date_format(docker.last_activity)}}</td>\n\n                        <td style=\"width: 70px;min-width: 70px\">\n                            <span style=\"vertical-align: middle\">{{docker.in_progress}}\n                                &nbsp;</span>\n                            <span\n                                    matTooltip=\"in_progress\"\n                                    [className]=\"'circle-green'\">\n\n                            </span>\n                        </td>\n\n                        <td style=\"width: 70px;min-width: 70px\">\n                            <span style=\"vertical-align: middle\">{{docker.free}}\n                                &nbsp;</span>\n                            <span\n                                    matTooltip=\"free\"\n                                    [className]=\"'circle-gray'\">\n\n                            </span>\n                        </td>\n\n                        <td>\n                            {{element.sync_status}}\n                            {{element.sync_date |  date:\"MM.dd H:mm:ss\"}}\n\n                            <button mat-raised-button\n                                    style=\"height: 25px;\n                        margin-left: 10px;\n                        vertical-align: middle\"\n                                    (click)=\"sync(element.name)\">\n                                Sync\n                            </button>\n\n                        </td>\n                    </tr>\n                </table>\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"usage_history\">\n            <th mat-header-cell *matHeaderCellDef class=\"usage_history\">\n                Stat history &nbsp; &nbsp;&nbsp;\n                <mat-button-toggle-group\n                        [value]=\"pressed\"\n                        (change)=\"pressed_changed($event)\"\n                        appearance=\"legacy\"\n                        style=\"height: 30px\">\n                    <mat-button-toggle value=\"min15\">\n                        <mat-icon>15 min</mat-icon>\n                    </mat-button-toggle>\n                    <mat-button-toggle value=\"hour1\">\n                        <mat-icon>1 hour</mat-icon>\n                    </mat-button-toggle>\n                    <mat-button-toggle value=\"hour3\">\n                        <mat-icon>3 hour</mat-icon>\n                    </mat-button-toggle>\n                    <mat-button-toggle value=\"hour6\">\n                        <mat-icon>6 hour</mat-icon>\n                    </mat-button-toggle>\n                    <mat-button-toggle value=\"day1\">\n                        <mat-icon>1 day</mat-icon>\n                    </mat-button-toggle>\n                    <mat-button-toggle value=\"day3\">\n                        <mat-icon>3 day</mat-icon>\n                    </mat-button-toggle>\n                </mat-button-toggle-group>\n            </th>\n            <td mat-cell *matCellDef=\"let element\" class=\"usage_history\">\n                <div [attr.id]=\"'usage_history_'+element.name\"></div>\n\n            </td>\n        </ng-container>\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row *matRowDef=\"let row; columns: displayed_columns;\"></tr>\n    </table>\n\n    <mat-paginator\n            [pageSizeOptions]=\"[15, 30, 50, 100]\"\n            [length]=\"total\"\n            [pageSize]=\"15\">\n\n    </mat-paginator>\n</div>\n\n\n"

/***/ }),

/***/ "./src/app/computer/computer.component.ts":
/*!************************************************!*\
  !*** ./src/app/computer/computer.component.ts ***!
  \************************************************/
/*! exports provided: ComputerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComputerComponent", function() { return ComputerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _dynamicresource_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dynamicresource.service */ "./src/app/dynamicresource.service.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../helpers */ "./src/app/helpers.ts");
/* harmony import */ var _computer_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./computer.service */ "./src/app/computer/computer.service.ts");
/* harmony import */ var _sync_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sync-dialog */ "./src/app/computer/sync-dialog.ts");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/dialog */ "./node_modules/@angular/material/esm5/dialog.es5.js");










var ComputerComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ComputerComponent, _super);
    function ComputerComponent(service, location, resource_service, sync_dialog) {
        var _this = _super.call(this, service, location) || this;
        _this.service = service;
        _this.location = location;
        _this.resource_service = resource_service;
        _this.sync_dialog = sync_dialog;
        _this.displayed_columns = [
            'main',
            'usage_history'
        ];
        _this.last_time = {};
        _this.pressed = 'min15';
        _this.intervals = {
            min15: 15 * 60,
            hour1: 60 * 60,
            hour3: 60 * 60 * 3,
            hour6: 60 * 60 * 6,
            day1: 60 * 60 * 24,
            day3: 60 * 60 * 24 * 3,
        };
        _this.id_column = 'name';
        return _this;
    }
    ComputerComponent.prototype.pressed_changed = function (event) {
        this.last_time = {};
        this.pressed = event.value;
        for (var _i = 0, _a = this.dataSource.data; _i < _a.length; _i++) {
            var c = _a[_i];
            var id = 'usage_history_' + c.name;
            window['Plotly'].purge(id);
        }
        this.change.emit();
    };
    ;
    ComputerComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_3__["ComputerFilter"]();
        res.paginator = _super.prototype.get_filter.call(this);
        res.usage_min_time = new Date(Date.now() -
            this.intervals[this.pressed] * 1000);
        for (var key in this.last_time) {
            if (this.last_time[key] > res.usage_min_time) {
                res.usage_min_time = this.last_time[key];
            }
        }
        return res;
    };
    ComputerComponent.prototype.ngAfterViewInit = function () {
        var _this = this;
        var self = this;
        this.data_updated.subscribe(function (res) {
            if (!res || !res.data) {
                return;
            }
            var data = res.data;
            _this.resource_service.load('plotly').then(function () {
                setTimeout(function () {
                    var rendered = true;
                    for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                        var computer = data_1[_i];
                        var id = 'usage_history_' + computer.name;
                        var element = document.getElementById(id);
                        if (!element) {
                            rendered = false;
                            break;
                        }
                        var series = [];
                        for (var _a = 0, _b = computer.usage_history.mean; _a < _b.length; _a++) {
                            var item = _b[_a];
                            var x = computer.usage_history.time.map(function (x) { return new Date(Date.parse(x)); });
                            var last = self.last_time[computer.name];
                            if (last && last >= x[x.length - 1]) {
                                continue;
                            }
                            series.push({
                                x: x,
                                y: item.value,
                                type: 'scatter',
                                name: item.name,
                                visible: item.name == 'disk' ?
                                    'legendonly' : true
                            });
                        }
                        if (series.length > 0) {
                            var x1 = series[0].x[series[0].x.length - 1];
                            var parsed = Date.parse(x1);
                            self.last_time[computer.name] = new Date(parsed);
                        }
                        if (series.length > 0) {
                            if (element.childNodes.length > 0) {
                                var keys = Array(series.length).keys();
                                var indices = Array.from(keys);
                                var y = { 'y': [], 'x': [] };
                                for (var _c = 0, series_1 = series; _c < series_1.length; _c++) {
                                    var s = series_1[_c];
                                    y['y'].push(s.y);
                                    y['x'].push(s.x);
                                }
                                window['Plotly'].extendTraces(id, y, indices);
                            }
                            else {
                                window['Plotly'].newPlot(id, series, {}, { showSendToCloud: true });
                            }
                        }
                    }
                }, 100);
            });
        });
    };
    ComputerComponent.prototype.color = function (value) {
        if (value <= 33) {
            return 'green';
        }
        if (value <= 75) {
            return 'orange';
        }
        return 'red';
    };
    ComputerComponent.prototype.docker_status = function (docker) {
        // @ts-ignore
        if (_helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(docker.last_activity) >= new Date(Date.now() - 15000)) {
            return 'circle-green';
        }
        return 'circle-red';
    };
    ComputerComponent.prototype.docker_status_tip = function (docker) {
        if (_helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(docker.last_activity) >= new Date(Date.now() - 15000)) {
            return 'online';
        }
        return 'offline';
    };
    ComputerComponent.prototype.long_date_format = function (time) {
        return _helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].format_date_time(_helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(time));
    };
    ComputerComponent.prototype.sync = function (name) {
        var _this = this;
        if (name === void 0) { name = null; }
        this.service.sync_start().subscribe(function (x) {
            var dialog = _this.sync_dialog.open(_sync_dialog__WEBPACK_IMPORTED_MODULE_8__["SyncDialogComponent"], {
                width: '500px', height: '500px',
                data: x
            });
            dialog.afterClosed().subscribe(function (res) {
                res['computer'] = name;
                _this.service.sync_end(res).subscribe(function (x) { });
            });
        });
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])('table'),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Object)
    ], ComputerComponent.prototype, "table", void 0);
    ComputerComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-computer',
            template: __webpack_require__(/*! ./computer.component.html */ "./src/app/computer/computer.component.html"),
            styles: [__webpack_require__(/*! ./computer.component.css */ "./src/app/computer/computer.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_computer_service__WEBPACK_IMPORTED_MODULE_7__["ComputerService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_4__["Location"],
            _dynamicresource_service__WEBPACK_IMPORTED_MODULE_5__["DynamicresourceService"],
            _angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__["MatDialog"]])
    ], ComputerComponent);
    return ComputerComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_2__["Paginator"]));



/***/ }),

/***/ "./src/app/computer/computer.service.ts":
/*!**********************************************!*\
  !*** ./src/app/computer/computer.service.ts ***!
  \**********************************************/
/*! exports provided: ComputerService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComputerService", function() { return ComputerService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");






var ComputerService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ComputerService, _super);
    function ComputerService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'computers';
        _this.single_part = 'computer';
        return _this;
    }
    ComputerService.prototype.sync_start = function () {
        var _this = this;
        var message = this.constructor.name + ".sync_start";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + 'computer_sync_start';
        return this.http.post(url, {}).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["tap"])(function (_) { return _this.log(message); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["SyncStart"]())));
    };
    ComputerService.prototype.sync_end = function (filter) {
        var _this = this;
        var message = this.constructor.name + ".sync_end";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + 'computer_sync_end';
        return this.http.post(url, filter).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["tap"])(function (_) { return _this.log(message); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["SyncProject"]())));
    };
    ComputerService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], ComputerService);
    return ComputerService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/computer/sync-dialog.html":
/*!*******************************************!*\
  !*** ./src/app/computer/sync-dialog.html ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<mat-form-field style=\"width: 150px\">\n    <mat-label>Project</mat-label>\n    <mat-select\n            (ngModelChange)=\"data.project=$event;\"\n            [(ngModel)]=\"data.project\">\n        <mat-option *ngFor=\"let project of data.projects\" [value]=\"project\">\n            {{project.name}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<div mat-dialog-content *ngIf=\"data.project\">\n  <mat-form-field style=\"width: 450px\">\n    <mat-label>Sync folders</mat-label>\n      <textarea\n              matInput\n              [(ngModel)]=\"data.project.sync_folders\"\n              style=\"height:120px\">\n\n      </textarea>\n  </mat-form-field>\n</div>\n\n\n<div mat-dialog-content *ngIf=\"data.project\">\n  <mat-form-field style=\"width: 450px\">\n    <mat-label>Ignore folders</mat-label>\n      <textarea\n              matInput\n              [(ngModel)]=\"data.project.ignore_folders\"\n              style=\"height:120px\">\n\n      </textarea>\n  </mat-form-field>\n</div>\n\n<div mat-dialog-actions>\n  <button mat-button (click)=\"onNoClick()\">Cancel</button>\n  <button mat-button [mat-dialog-close]=\"data.project\" cdkFocusInitial>Ok</button>\n</div>"

/***/ }),

/***/ "./src/app/computer/sync-dialog.ts":
/*!*****************************************!*\
  !*** ./src/app/computer/sync-dialog.ts ***!
  \*****************************************/
/*! exports provided: SyncDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SyncDialogComponent", function() { return SyncDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");




var SyncDialogComponent = /** @class */ (function () {
    function SyncDialogComponent(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
        if (data.projects && data.projects.length > 0) {
            data.project = data.projects[0];
        }
        for (var _i = 0, _a = data.projects; _i < _a.length; _i++) {
            var p = _a[_i];
            if (!p.sync_folders) {
                p.sync_folders = '[\ndata,\nmodels\n]';
            }
            if (!p.ignore_folders) {
                p.ignore_folders = '[\n\n]';
            }
        }
    }
    SyncDialogComponent.prototype.onNoClick = function () {
        this.dialogRef.close();
    };
    SyncDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'sync-dialog',
            template: __webpack_require__(/*! ./sync-dialog.html */ "./src/app/computer/sync-dialog.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"],
            _models__WEBPACK_IMPORTED_MODULE_3__["SyncStart"]])
    ], SyncDialogComponent);
    return SyncDialogComponent;
}());



/***/ }),

/***/ "./src/app/dag/dag.service.ts":
/*!************************************!*\
  !*** ./src/app/dag/dag.service.ts ***!
  \************************************/
/*! exports provided: DagService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DagService", function() { return DagService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");






var DagService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](DagService, _super);
    function DagService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'dags';
        _this.single_part = 'dag';
        return _this;
    }
    DagService.prototype.stop = function (id) {
        var message = this.constructor.name + ".stop";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/stop';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["DagStopResult"]())));
    };
    DagService.prototype.toogle_report = function (id, report, report_full) {
        var message = this.constructor.name + ".toogle_report";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT +
            this.single_part +
            '/toogle_report';
        return this.http.post(url, {
            'id': id,
            'report': report,
            'remove': report_full
        }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["ToogleReportResult"]())));
    };
    DagService.prototype.remove = function (id) {
        var message = this.constructor.name + ".remove";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/remove';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.remove_imgs = function (id) {
        var message = this.constructor.name + ".remove_imgs";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + 'remove_imgs';
        return this.http.post(url, { 'dag': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.remove_files = function (id) {
        var message = this.constructor.name + ".remove_files";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + 'remove_files';
        return this.http.post(url, { 'dag': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.start = function (id) {
        var message = this.constructor.name + ".start";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/start';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.restart = function (data) {
        var message = this.constructor.name + ".restart";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/restart';
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.tag_add = function (dag, tag) {
        var message = this.constructor.name + ".tag_add";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/tag_add';
        return this.http.post(url, {
            'dag': dag,
            'tag': tag
        }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.tag_remove = function (dag, tag) {
        var message = this.constructor.name + ".tag_remove";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/tag_remove';
        return this.http.post(url, {
            'dag': dag,
            'tag': tag
        }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["BaseResult"]())));
    };
    DagService.prototype.tags = function (data) {
        var message = this.constructor.name + ".tags";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/tags';
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["TagResult"]())));
    };
    DagService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], DagService);
    return DagService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/dag/dags/dag-restart-dialog.html":
/*!**************************************************!*\
  !*** ./src/app/dag/dags/dag-restart-dialog.html ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div mat-dialog-content>\n    <mat-form-field style=\"width: 500px\">\n        <mat-label>File changes</mat-label>\n        <textarea\n                #textarea\n                matInput\n                [(ngModel)]=\"data.file_changes\"\n                (keyup)=\"key_up($event)\"\n                (keydown)=\"key_down($event)\"\n                style=\"height:400px;width: 500px\">\n\n      </textarea>\n    </mat-form-field>\n</div>\n\n<pre style=\"color: red\" *ngIf=\"error\">\n    Error:\n\n    {{error}}\n</pre>\n\n<div mat-dialog-actions>\n  <button mat-button (click)=\"onNoClick()\">Cancel</button>\n    <button mat-button (click)=\"on_ok_click()\" cdkFocusInitial>Ok</button>\n</div>\n\n"

/***/ }),

/***/ "./src/app/dag/dags/dag-restart-dialog.ts":
/*!************************************************!*\
  !*** ./src/app/dag/dags/dag-restart-dialog.ts ***!
  \************************************************/
/*! exports provided: DagRestartDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DagRestartDialogComponent", function() { return DagRestartDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");
/* harmony import */ var _dag_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dag.service */ "./src/app/dag/dag.service.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../helpers */ "./src/app/helpers.ts");






var DagRestartDialogComponent = /** @class */ (function () {
    function DagRestartDialogComponent(dialogRef, data, service) {
        this.dialogRef = dialogRef;
        this.data = data;
        this.service = service;
    }
    DagRestartDialogComponent.prototype.onNoClick = function () {
        this.dialogRef.close();
    };
    DagRestartDialogComponent.prototype.on_ok_click = function () {
        var _this = this;
        this.service.restart(this.data).subscribe(function (res) {
            if (res.success) {
                _this.dialogRef.close();
            }
            else {
                _this.error = res.error;
            }
        });
    };
    DagRestartDialogComponent.prototype.key_down = function (event) {
        var content = _helpers__WEBPACK_IMPORTED_MODULE_5__["Helpers"].handle_textarea_down_key(event, this.textarea.nativeElement);
        if (content) {
            this.data.file_changes = content;
        }
    };
    DagRestartDialogComponent.prototype.key_up = function (event) {
        this.data.file_changes = event.target.value;
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])('textarea'),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Object)
    ], DagRestartDialogComponent.prototype, "textarea", void 0);
    DagRestartDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'dag-restart-dialog',
            template: __webpack_require__(/*! ./dag-restart-dialog.html */ "./src/app/dag/dags/dag-restart-dialog.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"],
            _models__WEBPACK_IMPORTED_MODULE_3__["DagRestart"],
            _dag_service__WEBPACK_IMPORTED_MODULE_4__["DagService"]])
    ], DagRestartDialogComponent);
    return DagRestartDialogComponent;
}());



/***/ }),

/***/ "./src/app/dag/dags/dags.component.css":
/*!*********************************************!*\
  !*** ./src/app/dag/dags/dags.component.css ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 100%;\n  min-width: 1580px;\n}\n\ntd, th {\n  width: 10%;\n\n}\n\n.checkbox-section {\n  display: flex;\n  align-content: center;\n  align-items: center;\n  height: 60px;\n}\n\n.checkbox-margin {\n  margin: 0 10px;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\ntd{\n  text-align: center;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n.checkbox-section {\n  display: flex;\n  align-content: center;\n  align-items: center;\n  height: 60px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvZGFnL2RhZ3MvZGFncy5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsV0FBVztFQUNYLGlCQUFpQjtBQUNuQjs7QUFFQTtFQUNFLFVBQVU7O0FBRVo7O0FBRUE7RUFDRSxhQUFhO0VBQ2IscUJBQXFCO0VBQ3JCLG1CQUFtQjtFQUNuQixZQUFZO0FBQ2Q7O0FBRUE7RUFDRSxjQUFjO0FBQ2hCOztBQUVBO0VBQ0UsZUFBZTtFQUNmLFdBQVc7QUFDYjs7QUFFQTtFQUNFLGtCQUFrQjtBQUNwQjs7QUFFQTtFQUNFLFlBQVk7RUFDWixzQkFBc0I7RUFDdEIsa0JBQWtCO0VBQ2xCLDRCQUE0QjtBQUM5Qjs7QUFFQTtFQUNFLDZCQUE2QjtBQUMvQjs7QUFFQTtFQUNFLGVBQWU7QUFDakI7O0FBRUE7RUFDRSxhQUFhO0VBQ2IscUJBQXFCO0VBQ3JCLG1CQUFtQjtFQUNuQixZQUFZO0FBQ2QiLCJmaWxlIjoic3JjL2FwcC9kYWcvZGFncy9kYWdzLmNvbXBvbmVudC5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyJ0YWJsZSB7XG4gIHdpZHRoOiAxMDAlO1xuICBtaW4td2lkdGg6IDE1ODBweDtcbn1cblxudGQsIHRoIHtcbiAgd2lkdGg6IDEwJTtcblxufVxuXG4uY2hlY2tib3gtc2VjdGlvbiB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGFsaWduLWNvbnRlbnQ6IGNlbnRlcjtcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgaGVpZ2h0OiA2MHB4O1xufVxuXG4uY2hlY2tib3gtbWFyZ2luIHtcbiAgbWFyZ2luOiAwIDEwcHg7XG59XG5cbi5tYXQtZm9ybS1maWVsZCB7XG4gIGZvbnQtc2l6ZTogMTRweDtcbiAgd2lkdGg6IDEwMCU7XG59XG5cbnRke1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG59XG5cbjo6bmctZGVlcCAubWF0LXNvcnQtaGVhZGVyLWNvbnRhaW5lcntcbiAgZGlzcGxheTpmbGV4O1xuICBqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyO1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gIG1hcmdpbi1sZWZ0OiAxMnB4ICFpbXBvcnRhbnQ7XG59XG5cbi5tYXQtaGVhZGVyLWNlbGx7XG4gIHRleHQtYWxpZ246IGNlbnRlciAhaW1wb3J0YW50O1xufVxuXG5tYXQtaWNvbntcbiAgY3Vyc29yOiBwb2ludGVyO1xufVxuXG4uY2hlY2tib3gtc2VjdGlvbiB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGFsaWduLWNvbnRlbnQ6IGNlbnRlcjtcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgaGVpZ2h0OiA2MHB4O1xufSJdfQ== */"

/***/ }),

/***/ "./src/app/dag/dags/dags.component.html":
/*!**********************************************!*\
  !*** ./src/app/dag/dags/dags.component.html ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<button mat-raised-button style=\"margin-top: 15px\"\n        (click)=\"filter_hidden=!filter_hidden\">\n    Filters {{filter_applied_text}}\n</button>\n\n<div [hidden]=\"filter_hidden\">\n    <mat-form-field style=\"width: 150px\">\n        <mat-label>Project</mat-label>\n        <mat-select (ngModelChange)=\"project=$event; onchange()\"\n                    [ngModel]=\"project\">\n            <mat-option *ngFor=\"let project of projects\" [value]=\"project.id\">\n                {{project.name}}\n            </mat-option>\n        </mat-select>\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 150px\">\n        <input matInput (keyup)=\"name=$event.target.value;onchange()\"\n               placeholder=\"Name\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 100px\">\n        <input matInput (keyup)=\"id_min=$event.target.value;onchange()\"\n               placeholder=\"Id min\" type=\"number\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 100px\">\n        <input matInput (keyup)=\"id_max=$event.target.value;onchange()\"\n               placeholder=\"Id max\" type=\"number\">\n    </mat-form-field>\n\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"created min\"\n               [ngModel]=\"created_min\"\n               (ngModelChange)=\"created_min = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"created max\"\n               [ngModel]=\"created_max\"\n               (ngModelChange)=\"created_max = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"last activity min\"\n               [ngModel]=\"last_activity_min\"\n               (ngModelChange)=\"last_activity_min = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"last activity max\"\n               [ngModel]=\"last_activity_max\"\n               (ngModelChange)=\"last_activity_max = $event;onchange()\">\n    </mat-form-field>\n\n    <section class=\"checkbox-section\">\n        <mat-checkbox [(ngModel)]=\"not_ran\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">Not ran\n        </mat-checkbox>\n        <mat-checkbox [(ngModel)]=\"queued\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">Queued\n        </mat-checkbox>\n        <mat-checkbox [(ngModel)]=\"in_progress\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">In progress\n        </mat-checkbox>\n        <mat-checkbox [(ngModel)]=\"failed\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">Failed\n        </mat-checkbox>\n        <mat-checkbox [(ngModel)]=\"stopped\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">Stopped\n        </mat-checkbox>\n        <mat-checkbox [(ngModel)]=\"skipped\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">Skipped\n        </mat-checkbox>\n        <mat-checkbox [(ngModel)]=\"finished\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">Finished\n        </mat-checkbox>\n    </section>\n\n    <mat-form-field\n            class=\"example-chip-list\"\n            (click)=\"update_filter_all_tags()\"\n            (keyup)=\"update_filter_all_tags($event)\">\n        <mat-chip-list #chipFilterRelated>\n            <mat-chip\n                    *ngFor=\"let tag of filter_tags\"\n                    [selectable]=\"false\"\n                    [removable]=\"true\"\n                    (removed)=\"filter_remove_tag(tag)\">\n                {{tag}}\n\n\n                <mat-icon matChipRemove\n                          svgIcon=\"delete\"></mat-icon>\n            </mat-chip>\n\n            <input\n                    placeholder=\"Tags\"\n                    [matAutocomplete]=\"autoFilterRelated\"\n                    [matChipInputFor]=\"chipFilterRelated\"\n                    [matChipInputSeparatorKeyCodes]=\"separatorKeysCodes\"\n                    (matChipInputTokenEnd)=\"filter_tag_add($event)\">\n        </mat-chip-list>\n\n        <mat-autocomplete #autoFilterRelated=\"matAutocomplete\"\n                          (optionSelected)=\"filter_tag_selected($event)\">\n            <mat-option *ngFor=\"let tag of filter_all_tags\"\n                        [value]=\"tag\">\n                {{tag}}\n            </mat-option>\n        </mat-autocomplete>\n\n    </mat-form-field>\n\n</div>\n\n<div class=\"mat-elevation-z8\">\n    <table mat-table [dataSource]=\"dataSource\" matSort>\n\n        <ng-container matColumnDef=\"project\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Project\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.project.name}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"id\">\n            <th mat-header-cell *matHeaderCellDef style=\"width: 18px\"\n                mat-sort-header> Id\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"width: 18px\">\n                {{element.id}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"name\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Name\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <a class=\"col-1-4\"\n                   routerLink=\"/dags/dag-detail/{{element.id}}/tasks\">\n                    {{element.name}}\n                </a>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"task_count\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 18px\"> Tasks\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"width: 18px\">\n                {{element.task_count}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"created\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"min-width: 100px\"> Created\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 100px\">\n                {{element.created| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"started\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"min-width: 100px\"> Started\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 100px\">\n                {{element.started| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"last_activity\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"min-width: 100px\"> Last activity\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 100px\">\n                {{element.last_activity| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n\n        <ng-container matColumnDef=\"duration\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Duration\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.duration}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"img_file\">\n            <th mat-header-cell *matHeaderCellDef style=\"min-width: 200px\">\n                Img/File size\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 200px\">\n                Image,  {{size(element.img_size)}}\n                <mat-icon svgIcon=\"remove\" matTooltip=\"Remove\"\n                          (click)=\"remove_imgs(element)\">\n                </mat-icon>\n\n                File, {{size(element.file_size)}}\n\n                <mat-icon svgIcon=\"remove\" matTooltip=\"Remove\"\n                          (click)=\"remove_files(element)\"\n                          [class.transparent]=\"has_unfinished(element)\">\n                </mat-icon>\n\n            </td>\n        </ng-container>\n\n\n        <ng-container matColumnDef=\"tags\">\n            <th mat-header-cell *matHeaderCellDef style=\"min-width: 120px\">\n                Tags\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 120px\">\n                <mat-form-field\n                        (click)=\"update_tags()\"\n                        (keyup)=\"update_tags($event)\"\n                        class=\"example-chip-list\">\n                    <mat-chip-list #chipList>\n                        <mat-chip\n                                *ngFor=\"let tag of element.tags\"\n                                [selectable]=\"false\"\n                                [removable]=\"true\"\n                                (removed)=\"remove_tag(element, tag)\">\n                            {{tag}}\n                            <mat-icon matChipRemove\n                                      svgIcon=\"delete\"></mat-icon>\n                        </mat-chip>\n\n                        <input\n                                placeholder=\"\"\n                                [matAutocomplete]=\"auto\"\n                                [matChipInputFor]=\"chipList\"\n                                [matChipInputSeparatorKeyCodes]=\"separatorKeysCodes\"\n                                (matChipInputTokenEnd)=\"tag_add(element, $event)\">\n                    </mat-chip-list>\n\n                    <mat-autocomplete #auto=\"matAutocomplete\"\n                                      (optionSelected)=\"tag_selected(element, $event)\">\n                        <mat-option *ngFor=\"let tag of tags\" [value]=\"tag\">\n                            {{tag}}\n                        </mat-option>\n                    </mat-autocomplete>\n\n                </mat-form-field>\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"task_status\">\n            <th mat-header-cell *matHeaderCellDef style=\"text-align: center\">\n                Task status\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                <svg height=\"40\" width=\"220px\" style=\"display: block;\">\n                    <g matTooltip=\"{{status.name}}\"\n                       [attr.transform]=\n                               \"'translate('+(16+i*30).toString()+','+'20)'\"\n                       *ngFor=\"let status of element.task_statuses;\n                        let i = index\">\n\n                        <text fill=\"black\" text-anchor=\"middle\"\n                              vertical-align=\"middle\"\n                              font-size=\"10\"\n                              y=\"3\">{{status.count > 0 ? status.count : ''}}\n                        </text>\n\n                        <circle [attr.stroke-width]=\"status.count>0?2:1\"\n                                (click)=\"status_click(element, status)\"\n                                [attr.stroke]=\n                                        \"color_for_task_status(status.name,\n                                        status.count)\"\n                                fill-opacity=\"0\" r=\"12.5\"\n                                style=\"cursor: pointer; opacity: 1;\"></circle>\n                    </g>\n\n                </svg>\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"links\">\n            <th mat-header-cell *matHeaderCellDef\n                style=\"text-align: center; width: 17%;\">\n                Links\n            </th>\n            <td mat-cell *matCellDef=\"let element\"\n                style=\"padding-left: 1%;min-width: 120px\">\n\n                <mat-icon\n                        svgIcon=\"report\"\n                        matTooltip=\"Report\"\n                        [class.transparent]=\"is_report_transparent(element)\"\n                        [class.transparent-active]=\n                                \"is_report_transparent_active(element)\"\n                        [routerLink]=\"report_link(element)\"\n                        (click)=\"report_click(element)\">\n                </mat-icon>\n\n                <mat-icon svgIcon=\"config\" matTooltip=\"Config\"\n                          routerLink=\"/dags/dag-detail/{{element.id}}/config\">\n                </mat-icon>\n\n                <mat-icon svgIcon=\"code\" matTooltip=\"Code\"\n                          routerLink=\"/dags/dag-detail/{{element.id}}/code\">\n\n                </mat-icon>\n\n                <mat-icon svgIcon=\"graph\" matTooltip=\"Graph\"\n                          routerLink=\"/dags/dag-detail/{{element.id}}/graph\">\n                </mat-icon>\n\n                <mat-icon svgIcon=\"start\"\n                          matTooltip=\"Start\"\n                          (click)=\"start(element)\"\n                          [class.transparent]=\n                                  \"!can_start(element)\">\n                </mat-icon>\n\n                <mat-icon svgIcon=\"stop\"\n                          matTooltip=\"Stop\"\n                          (click)=\"stop(element)\"\n                          [class.transparent]=\"!has_unfinished(element)\">\n                </mat-icon>\n\n                <mat-icon svgIcon=\"restart\"\n                          matTooltip=\"Restart\"\n                          (click)=\"restart(element)\">\n                </mat-icon>\n\n                <mat-icon\n                        svgIcon=\"remove\"\n                        matTooltip=\"Remove\"\n                        (click)=\"remove(element)\">\n                </mat-icon>\n\n            </td>\n        </ng-container>\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row\n            *matRowDef=\"let row; columns: displayed_columns;\"\n            [style.background]=\"selected==row ?\n            'lightblue' : ''\"\n            (click)=\"onSelected(row)\"></tr>\n    </table>\n\n    <mat-paginator [pageSizeOptions]=\"[default_page_size, 30, 100]\"\n                   [length]=\"total\"\n                   [pageSize]=\"default_page_size\">\n\n    </mat-paginator>\n\n</div>\n\n"

/***/ }),

/***/ "./src/app/dag/dags/dags.component.ts":
/*!********************************************!*\
  !*** ./src/app/dag/dags/dags.component.ts ***!
  \********************************************/
/*! exports provided: DagsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DagsComponent", function() { return DagsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");
/* harmony import */ var _dag_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dag.service */ "./src/app/dag/dag.service.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/platform-browser */ "./node_modules/@angular/platform-browser/fesm5/platform-browser.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../helpers */ "./src/app/helpers.ts");
/* harmony import */ var _dialog_dialog_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../dialog/dialog.component */ "./src/app/dialog/dialog.component.ts");
/* harmony import */ var _dag_restart_dialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./dag-restart-dialog */ "./src/app/dag/dags/dag-restart-dialog.ts");
/* harmony import */ var _angular_cdk_keycodes__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/cdk/keycodes */ "./node_modules/@angular/cdk/esm5/keycodes.es5.js");














var DagsComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](DagsComponent, _super);
    function DagsComponent(service, location, router, route, iconRegistry, sanitizer, dialog) {
        var _this = _super.call(this, service, location) || this;
        _this.service = service;
        _this.location = location;
        _this.router = router;
        _this.route = route;
        _this.dialog = dialog;
        _this.displayed_columns = [
            'project',
            'id',
            'name',
            'task_count',
            'created',
            'started',
            'last_activity',
            'duration',
            'task_status',
            'links',
            'tags',
            'img_file'
        ];
        _this.filter_hidden = true;
        _this.separatorKeysCodes = [_angular_cdk_keycodes__WEBPACK_IMPORTED_MODULE_13__["ENTER"], _angular_cdk_keycodes__WEBPACK_IMPORTED_MODULE_13__["COMMA"]];
        _this.tags = [];
        _this.filter_all_tags = [];
        _this.filter_tags = [];
        iconRegistry.addSvgIcon('config', sanitizer.bypassSecurityTrustResourceUrl('assets/img/config.svg'));
        iconRegistry.addSvgIcon('start', sanitizer.bypassSecurityTrustResourceUrl('assets/img/play-button.svg'));
        iconRegistry.addSvgIcon('stop', sanitizer.bypassSecurityTrustResourceUrl('assets/img/stop.svg'));
        iconRegistry.addSvgIcon('code', sanitizer.bypassSecurityTrustResourceUrl('assets/img/programming-code.svg'));
        iconRegistry.addSvgIcon('delete', sanitizer.bypassSecurityTrustResourceUrl('assets/img/delete.svg'));
        iconRegistry.addSvgIcon('graph', sanitizer.bypassSecurityTrustResourceUrl('assets/img/network.svg'));
        iconRegistry.addSvgIcon('report', sanitizer.bypassSecurityTrustResourceUrl('assets/img/report.svg'));
        iconRegistry.addSvgIcon('remove', sanitizer.bypassSecurityTrustResourceUrl('assets/img/trash.svg'));
        iconRegistry.addSvgIcon('start', sanitizer.bypassSecurityTrustResourceUrl('assets/img/play-button.svg'));
        iconRegistry.addSvgIcon('restart', sanitizer.bypassSecurityTrustResourceUrl('assets/img/restart.svg'));
        return _this;
    }
    DagsComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_2__["DagFilter"]();
        res.paginator = _super.prototype.get_filter.call(this);
        res.name = this.name;
        if (this.project != -1) {
            res.project = this.project;
        }
        res.report = this.report;
        res.status = {
            'not_ran': this.not_ran,
            'queued': this.queued,
            'in_progress': this.in_progress,
            'failed': this.failed,
            'stopped': this.stopped,
            'skipped': this.skipped,
            'finished': this.finished
        };
        res.created_min = _helpers__WEBPACK_IMPORTED_MODULE_10__["Helpers"].parse_time(this.created_min);
        res.created_max = _helpers__WEBPACK_IMPORTED_MODULE_10__["Helpers"].parse_time(this.created_max);
        res.last_activity_min = _helpers__WEBPACK_IMPORTED_MODULE_10__["Helpers"].parse_time(this.last_activity_min);
        res.last_activity_max = _helpers__WEBPACK_IMPORTED_MODULE_10__["Helpers"].parse_time(this.last_activity_max);
        res.id_min = this.id_min;
        res.id_max = this.id_max;
        res.tags = this.filter_tags;
        return res;
    };
    DagsComponent.prototype.update_tags = function (event) {
        var _this = this;
        if (event === void 0) { event = null; }
        var name = '';
        if (event) {
            name = event.target.value;
        }
        this.service.tags({ 'name': name }).subscribe(function (x) {
            _this.tags = x.tags;
        });
    };
    DagsComponent.prototype.update_filter_all_tags = function (event) {
        var _this = this;
        if (event === void 0) { event = null; }
        var name = '';
        if (event) {
            name = event.target.value;
        }
        this.service.tags({ 'name': name }).subscribe(function (x) {
            _this.filter_all_tags = x.tags;
        });
    };
    DagsComponent.prototype._ngOnInit = function () {
        var _this = this;
        var self = this;
        this.route.queryParams
            .subscribe(function (params) {
            if (params['project']) {
                _this.project = parseInt(params['project']);
            }
            self.onchange();
        });
        this.data_updated.subscribe(function (res) {
            if (!res || !res.projects) {
                return;
            }
            self.tags = res.tags;
            self.projects = res.projects;
            self.projects.splice(0, 0, { 'id': -1, 'name': 'None' });
        });
    };
    DagsComponent.prototype.color_for_task_status = function (name, count) {
        return count > 0 ? _app_settings__WEBPACK_IMPORTED_MODULE_8__["AppSettings"].status_colors[name] : 'gainsboro';
    };
    DagsComponent.prototype.status_click = function (dag, status) {
        this.router.navigate(["/dags/dag-detail/" + dag.id + "/tasks"], { queryParams: { status: status.name } });
    };
    DagsComponent.prototype.start = function (element) {
        var _this = this;
        if (!this.can_start(element)) {
            return;
        }
        this.service.start(element.id).subscribe(function (data) {
            _this.change.emit();
        });
    };
    DagsComponent.prototype.stop = function (element) {
        if (element.success) {
            return;
        }
        if (!this.has_unfinished(element)) {
            return;
        }
        this.service.stop(element.id).subscribe(function (data) {
            if (data.dag) {
                element.task_statuses = data.dag.task_statuses;
            }
        });
    };
    DagsComponent.prototype.can_start = function (element) {
        if (this.has_unfinished(element)) {
            return false;
        }
        return element.task_statuses[3].count +
            element.task_statuses[4].count +
            element.task_statuses[5].count > 0;
    };
    DagsComponent.prototype.has_unfinished = function (element) {
        return element.task_statuses[0].count +
            element.task_statuses[1].count +
            element.task_statuses[2].count > 0;
    };
    DagsComponent.prototype.remove = function (element) {
        var _this = this;
        var self = this;
        if (!element.finished) {
            this.service.stop(element.id).subscribe(function (data) {
                var dialogRef = _this.dialog.open(_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_11__["DialogComponent"], {
                    width: '550px', height: '200px',
                    data: {
                        'message': 'The all content will be deleted. ' +
                            'Do you want to continue?'
                    }
                });
                dialogRef.afterClosed().subscribe(function (result) {
                    if (result) {
                        _this.service.remove(element.id).subscribe(function (res) {
                            self.change.emit();
                        });
                    }
                });
            });
            return;
        }
        var dialogRef = this.dialog.open(_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_11__["DialogComponent"], {
            width: '550px', height: '200px',
            data: {
                'message': 'The all content will be deleted. ' +
                    'Do you want to continue?'
            }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.remove(element.id).subscribe(function (res) {
                    self.change.emit();
                });
            }
        });
    };
    DagsComponent.prototype.remove_imgs = function (element) {
        this.service.remove_imgs(element.id).subscribe(function (data) {
            element.img_size = 0;
        });
    };
    DagsComponent.prototype.remove_files = function (element) {
        if (this.has_unfinished(element)) {
            return;
        }
        this.service.remove_files(element.id).subscribe(function (data) {
            element.file_size = 0;
        });
    };
    DagsComponent.prototype.size = function (s) {
        return _helpers__WEBPACK_IMPORTED_MODULE_10__["Helpers"].size(s);
    };
    DagsComponent.prototype.onchange = function () {
        this.change.emit();
        var filter = this.get_filter();
        var count = 0;
        if (this.name)
            count += 1;
        if (this.project && this.project != -1)
            count += 1;
        if (this.created_min)
            count += 1;
        if (this.created_max)
            count += 1;
        if (this.last_activity_min)
            count += 1;
        if (this.last_activity_max)
            count += 1;
        for (var _i = 0, _a = Object.getOwnPropertyNames(filter.status); _i < _a.length; _i++) {
            var k = _a[_i];
            count += filter.status[k] == true ? 1 : 0;
        }
        this.filter_applied_text = count > 0 ? "(" + count + " applied)" : '';
    };
    DagsComponent.prototype.is_report_transparent = function (element) {
        if (this.report) {
            return false;
        }
        return !element.report;
    };
    DagsComponent.prototype.is_report_transparent_active = function (element) {
        if (!this.report) {
            return false;
        }
        return !element.report_full;
    };
    DagsComponent.prototype.report_click = function (element) {
        if (this.report) {
            this.service.toogle_report(element.id, this.report, element.report_full).subscribe(function (data) {
                element.report_full = data.report_full;
            });
            return;
        }
    };
    DagsComponent.prototype.report_link = function (element) {
        if (this.report) {
            return null;
        }
        return "/reports/report-detail/" + element.report;
    };
    DagsComponent.prototype.restart = function (element) {
        this.dialog.open(_dag_restart_dialog__WEBPACK_IMPORTED_MODULE_12__["DagRestartDialogComponent"], {
            width: '550px', height: '600px',
            data: {
                'dag': element.id,
                'file_changes': ''
            }
        });
    };
    DagsComponent.prototype.onSelected = function (row) {
        if (!this.use_select) {
            return;
        }
        this.selected = row;
    };
    DagsComponent.prototype.remove_tag = function (dag, tag) {
        var _this = this;
        this.service.tag_remove(dag.id, tag).subscribe(function (res) {
            _this.change.emit();
        });
    };
    DagsComponent.prototype.tag_add = function (dag, event) {
        var _this = this;
        var input = event.input;
        var value = event.value;
        // Add our fruit
        if ((value || '').trim()) {
            value = value.trim();
            this.service.tag_add(dag.id, value).subscribe(function (res) {
                _this.change.emit();
            });
        }
        // Reset the input value
        if (input) {
            input.value = '';
        }
    };
    DagsComponent.prototype.tag_selected = function (dag, event) {
        var _this = this;
        this.service.tag_add(dag.id, event.option.viewValue).subscribe(function (res) {
            _this.change.emit();
        });
    };
    DagsComponent.prototype.filter_remove_tag = function (tag) {
        var index = this.filter_tags.indexOf(tag);
        this.filter_tags.splice(index, 1);
        this.change.emit();
    };
    DagsComponent.prototype.filter_tag_add = function (event) {
        var input = event.input;
        var value = event.value;
        // Add our fruit
        if ((value || '').trim()) {
            value = value.trim();
            this.filter_tags.push(value);
        }
        // Reset the input value
        if (input) {
            input.value = '';
        }
        this.change.emit();
    };
    DagsComponent.prototype.filter_tag_selected = function (event) {
        this.filter_tags.push(event.option.viewValue);
        this.change.emit();
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], DagsComponent.prototype, "report", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Boolean)
    ], DagsComponent.prototype, "use_select", void 0);
    DagsComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-dags',
            template: __webpack_require__(/*! ./dags.component.html */ "./src/app/dag/dags/dags.component.html"),
            styles: [__webpack_require__(/*! ./dags.component.css */ "./src/app/dag/dags/dags.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_dag_service__WEBPACK_IMPORTED_MODULE_3__["DagService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_4__["Location"],
            _angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"],
            _angular_router__WEBPACK_IMPORTED_MODULE_5__["ActivatedRoute"],
            _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatIconRegistry"],
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_6__["DomSanitizer"],
            _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDialog"]])
    ], DagsComponent);
    return DagsComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_9__["Paginator"]));



/***/ }),

/***/ "./src/app/dialog/dialog.component.html":
/*!**********************************************!*\
  !*** ./src/app/dialog/dialog.component.html ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<h1 mat-dialog-title>{{data.message}}</h1>\n<div mat-dialog-actions>\n  <button mat-button (click)=\"onNoClick()\">No Thanks</button>\n  <button mat-button [mat-dialog-close]=\"true\">Ok</button>\n</div>"

/***/ }),

/***/ "./src/app/dialog/dialog.component.ts":
/*!********************************************!*\
  !*** ./src/app/dialog/dialog.component.ts ***!
  \********************************************/
/*! exports provided: DialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DialogComponent", function() { return DialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");



var DialogComponent = /** @class */ (function () {
    function DialogComponent(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
    }
    DialogComponent.prototype.onNoClick = function () {
        this.dialogRef.close();
    };
    DialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-dialog',
            template: __webpack_require__(/*! ./dialog.component.html */ "./src/app/dialog/dialog.component.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"], Object])
    ], DialogComponent);
    return DialogComponent;
}());



/***/ }),

/***/ "./src/app/dynamicresource.service.ts":
/*!********************************************!*\
  !*** ./src/app/dynamicresource.service.ts ***!
  \********************************************/
/*! exports provided: ResourceStore, DynamicresourceService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ResourceStore", function() { return ResourceStore; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DynamicresourceService", function() { return DynamicresourceService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");


var ResourceStore = [
    { name: 'vis.min.js', src: 'assets/visjs/vis.min.js', type: 'js' },
    { name: 'vis.min.css', src: 'assets/visjs/vis.min.css', type: 'css' },
    { name: 'prettify', src: 'assets/prettify/prettify.js', type: 'js' },
    { name: 'prettify-yaml', src: 'assets/prettify/lang-yaml.js', type: 'js' },
    { name: 'prettify-css', src: 'assets/prettify/prettify.css', type: 'css' },
    { name: 'plotly', src: 'assets/plotly.min.js', type: 'js' }
];
var DynamicresourceService = /** @class */ (function () {
    function DynamicresourceService() {
        var _this = this;
        this.resources = {};
        ResourceStore.forEach(function (resource) {
            _this.resources[resource.name] = {
                loaded: false,
                src: resource.src,
                type: resource.type
            };
        });
    }
    DynamicresourceService.prototype.load = function () {
        var _this = this;
        var resources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            resources[_i] = arguments[_i];
        }
        var promises = [];
        resources.forEach(function (resource) {
            return promises.push(_this.loadResource(resource));
        });
        return Promise.all(promises);
    };
    DynamicresourceService.prototype.loadResource = function (name) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (!_this.resources[name].loaded) {
                //load resource
                var type = _this.resources[name].type;
                var resource_1 = document.createElement(type == 'js' ?
                    'script' :
                    'link');
                if (type == 'js') {
                    resource_1.type = 'text/javascript';
                    resource_1.async = true;
                    resource_1.src = _this.resources[name].src;
                }
                else {
                    resource_1.type = 'text/css';
                    resource_1.rel = 'stylesheet';
                    resource_1.href = _this.resources[name].src;
                }
                if (resource_1.readyState) { //IE
                    resource_1.onreadystatechange = function () {
                        if (resource_1.readyState === "loaded" ||
                            resource_1.readyState === "complete") {
                            resource_1.onreadystatechange = null;
                            _this.resources[name].loaded = true;
                            resolve({
                                resource: name,
                                loaded: true,
                                status: 'Loaded'
                            });
                        }
                    };
                }
                else { //Others
                    resource_1.onload = function () {
                        _this.resources[name].loaded = true;
                        resolve({
                            resource: name,
                            loaded: true,
                            status: 'Loaded'
                        });
                    };
                }
                resource_1.onerror = function (error) { return resolve({
                    resource: name,
                    loaded: false,
                    status: 'Loaded'
                }); };
                document.getElementsByTagName('head')[0].appendChild(resource_1);
            }
            else {
                resolve({
                    resource: name,
                    loaded: true,
                    status: 'Already Loaded'
                });
            }
        });
    };
    DynamicresourceService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({ providedIn: 'root' }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [])
    ], DynamicresourceService);
    return DynamicresourceService;
}());



/***/ }),

/***/ "./src/app/helpers.ts":
/*!****************************!*\
  !*** ./src/app/helpers.ts ***!
  \****************************/
/*! exports provided: Helpers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return Helpers; });
var Helpers = /** @class */ (function () {
    function Helpers() {
    }
    Helpers.unique = function (array, key) {
        var els = [];
        for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
            var item = array_1[_i];
            if (els.indexOf(item[key]) == -1) {
                els.push(item[key]);
            }
        }
        return els;
    };
    Helpers.size = function (s) {
        if (s == 0) {
            return '0';
        }
        if (s < Math.pow(2, 10)) {
            return s + " byte";
        }
        if (s < Math.pow(2, 20)) {
            return Math.floor(s / 1024) + " kbyte";
        }
        if (s < Math.pow(2, 30)) {
            return Math.floor(s / Math.pow(2, 20)) + " mbyte";
        }
        return (s / Math.pow(2, 30)).toFixed(2) + " gbyte";
    };
    Helpers.format_date_time = function (date, year, month_numeric) {
        if (year === void 0) { year = false; }
        if (month_numeric === void 0) { month_numeric = false; }
        var monthNames = [
            "January",
            "February",
            "March",
            "April",
            "May",
            "June",
            "July",
            "August",
            "September",
            "October",
            "November",
            "December"
        ];
        var d = new Date(date), month = d.getMonth(), day = '' + d.getDate();
        if (day.length < 2)
            day = '0' + day;
        var parts = [];
        if (year) {
            parts.push(d.getFullYear());
        }
        if (month_numeric) {
            var month_str = String(month);
            if (month_str.length == 1)
                month_str = '0' + month_str;
            parts.push(month_str);
        }
        else {
            parts.push(monthNames[month]);
        }
        parts.push(day);
        return parts.join('.') + ' ' +
            date.toTimeString().slice(0, 8);
    };
    Helpers.parse_time = function (time) {
        return new Date(Date.parse(time));
    };
    Helpers.clone = function (item) {
        return JSON.parse(JSON.stringify(item));
    };
    Helpers.array_to_dict = function (array, key_column) {
        var normalizedObject = {};
        for (var i = 0; i < array.length; i++) {
            var key = 'id' + array[i][key_column].toString();
            normalizedObject[key] = array[i];
        }
        return normalizedObject;
    };
    Helpers.update_object_array = function (d1, d2, ids) {
        if (ids === void 0) { ids = []; }
        var id = null;
        for (var _i = 0, ids_1 = ids; _i < ids_1.length; _i++) {
            var e = ids_1[_i];
            if (e.indexOf('.') == -1) {
                id = e;
                break;
            }
        }
        if (!id) {
            return d2;
        }
        ids.splice(ids.indexOf(id), 1);
        var res_d = Helpers.array_to_dict(d2, id);
        var target_d = Helpers.array_to_dict(d1, id);
        var names = Object.getOwnPropertyNames(res_d);
        for (var _a = 0, names_1 = names; _a < names_1.length; _a++) {
            var k = names_1[_a];
            if (k in target_d) {
                Helpers.update_object(target_d[k], res_d[k], ids);
                delete res_d[k];
                delete target_d[k];
            }
        }
        for (var k in target_d) {
            var index = d1.indexOf(target_d[k]);
            d1.splice(index, 1);
        }
        for (var k in res_d) {
            d1.push(res_d[k]);
        }
        d1 = d1.sort(function (a, b) { return a[id] > b[id]
            ? -1 : 1; });
        return d1;
    };
    Helpers.update_object_dict = function (d1, d2, ids) {
        for (var name_1 in d2) {
            if (!(name_1 in d1)) {
                d1[name_1] = d2[name_1];
            }
            if (JSON.stringify(d1[name_1]) != JSON.stringify(d2[name_1])) {
                var ids_name = [];
                for (var _i = 0, ids_2 = ids; _i < ids_2.length; _i++) {
                    var id = ids_2[_i];
                    if (id.startsWith(name_1 + '.')) {
                        var id_name = id.slice(name_1.length + 1);
                        ids_name.push(id_name);
                    }
                }
                d1[name_1] = Helpers.update_object(d1[name_1], d2[name_1], ids_name);
            }
        }
        for (var _a = 0, d1_1 = d1; _a < d1_1.length; _a++) {
            var name_2 = d1_1[_a];
            if (!(name_2 in d2)) {
                delete d1[name_2];
            }
        }
    };
    Helpers.update_object = function (d1, d2, ids) {
        if (ids === void 0) { ids = []; }
        if (!d1) {
            return d2;
        }
        var type = typeof (d1);
        if (!d2 || typeof (d2) != type) {
            return d2;
        }
        if (Array.isArray(d1)) {
            return Helpers.update_object_array(d1, d2, ids);
        }
        else if (type == 'object') {
            Helpers.update_object_dict(d1, d2, ids);
        }
        else {
            return d2;
        }
        return d1;
    };
    Helpers.handle_textarea_down_key = function (event, element) {
        var content = event.target.value;
        var start = event.target.selectionStart;
        if (event.key == 'Tab' && !event.ctrlKey) {
            event.preventDefault();
            var selection = content.substring(start, event.target.selectionEnd);
            var lines = selection.split(/\r?\n/);
            for (var i = 0; i < lines.length; i++) {
                if (!event.shiftKey) {
                    lines[i] = "  " + lines[i];
                }
                else {
                    for (var j = 0; j < 2; j++) {
                        if (lines[i].length > 0 && lines[i][0] == ' ') {
                            lines[i] = lines[i].slice(1);
                        }
                    }
                }
            }
            selection = lines.reduce(function (a, c) { return a + '\r\n' + c; });
            content = content.substring(0, start) +
                selection + content.substring(event.target.selectionEnd);
            if (!event.shiftKey) {
                start = start + 2;
            }
            element.value = content;
            element.selectionStart = start;
            element.selectionEnd = start;
            return content;
        }
    };
    return Helpers;
}());



/***/ }),

/***/ "./src/app/log/log.component.css":
/*!***************************************!*\
  !*** ./src/app/log/log.component.css ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 100%;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\ntd{\n  text-align: center;\n}\n\n.checkbox-section {\n  display: flex;\n  align-content: center;\n  align-items: center;\n  height: 60px;\n}\n\n.checkbox-margin {\n  margin: 0 10px;\n}\n\ntable.filter{\n    width: 30%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvbG9nL2xvZy5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsV0FBVztBQUNiOztBQUVBO0VBQ0UsZUFBZTtFQUNmLFdBQVc7QUFDYjs7QUFFQTtFQUNFLGVBQWU7QUFDakI7O0FBRUE7RUFDRSxZQUFZO0VBQ1osc0JBQXNCO0VBQ3RCLGtCQUFrQjtFQUNsQiw0QkFBNEI7QUFDOUI7O0FBRUE7RUFDRSw2QkFBNkI7QUFDL0I7O0FBRUE7RUFDRSxrQkFBa0I7QUFDcEI7O0FBR0E7RUFDRSxhQUFhO0VBQ2IscUJBQXFCO0VBQ3JCLG1CQUFtQjtFQUNuQixZQUFZO0FBQ2Q7O0FBRUE7RUFDRSxjQUFjO0FBQ2hCOztBQUVBO0lBQ0ksVUFBVTtBQUNkIiwiZmlsZSI6InNyYy9hcHAvbG9nL2xvZy5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsidGFibGUge1xuICB3aWR0aDogMTAwJTtcbn1cblxuLm1hdC1mb3JtLWZpZWxkIHtcbiAgZm9udC1zaXplOiAxNHB4O1xuICB3aWR0aDogMTAwJTtcbn1cblxubWF0LWljb257XG4gIGN1cnNvcjogcG9pbnRlcjtcbn1cblxuOjpuZy1kZWVwIC5tYXQtc29ydC1oZWFkZXItY29udGFpbmVye1xuICBkaXNwbGF5OmZsZXg7XG4gIGp1c3RpZnktY29udGVudDpjZW50ZXI7XG4gIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgbWFyZ2luLWxlZnQ6IDEycHggIWltcG9ydGFudDtcbn1cblxuLm1hdC1oZWFkZXItY2VsbHtcbiAgdGV4dC1hbGlnbjogY2VudGVyICFpbXBvcnRhbnQ7XG59XG5cbnRke1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG59XG5cblxuLmNoZWNrYm94LXNlY3Rpb24ge1xuICBkaXNwbGF5OiBmbGV4O1xuICBhbGlnbi1jb250ZW50OiBjZW50ZXI7XG4gIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gIGhlaWdodDogNjBweDtcbn1cblxuLmNoZWNrYm94LW1hcmdpbiB7XG4gIG1hcmdpbjogMCAxMHB4O1xufVxuXG50YWJsZS5maWx0ZXJ7XG4gICAgd2lkdGg6IDMwJTtcbn0iXX0= */"

/***/ }),

/***/ "./src/app/log/log.component.html":
/*!****************************************!*\
  !*** ./src/app/log/log.component.html ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<table class=\"filter\">\n    <td>\n        <mat-card>\n            <mat-card-content>\n                <section class=\"checkbox-section\">\n\n                    <label class=\"checkbox-margin\">\n                        Level:\n                    </label>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"debug\"\n                            (change)=\"change.emit()\">\n                        Debug\n                    </mat-checkbox>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"info\"\n                            (change)=\"change.emit()\">\n                        Info\n                    </mat-checkbox>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"warning\"\n                            (change)=\"change.emit()\">\n                        Warning\n                    </mat-checkbox>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"error\"\n                            (change)=\"change.emit()\">\n                        Error\n                    </mat-checkbox>\n\n                </section>\n\n                <section class=\"checkbox-section\">\n                    <label class=\"checkbox-margin\">Component:</label>\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"api\"\n                            (change)=\"change.emit()\">\n                        API\n                    </mat-checkbox>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"supervisor\"\n                            (change)=\"change.emit()\">\n                        Supervisor\n                    </mat-checkbox>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"worker_supervisor\"\n                            (change)=\"change.emit()\">\n                        Worker-Supervisor\n                    </mat-checkbox>\n\n                    <mat-checkbox\n                            class=\"checkbox-margin\"\n                            [(ngModel)]=\"worker\"\n                            (change)=\"change.emit()\">\n                        Worker\n                    </mat-checkbox>\n                </section>\n\n            </mat-card-content>\n        </mat-card>\n    </td>\n\n    <td>\n        <mat-card>\n            <mat-card-content>\n\n                <mat-form-field>\n                    <input\n                            matInput\n                            (keyup)=\"apply_task_name($event.target.value)\"\n                            placeholder=\"Task name\">\n                </mat-form-field>\n\n                <mat-form-field>\n                    <input matInput\n                           (keyup)=\"apply_step_name($event.target.value)\"\n                           placeholder=\"Step name\">\n                </mat-form-field>\n\n            </mat-card-content>\n        </mat-card>\n    </td>\n\n    <td>\n                <mat-card>\n            <mat-card-content>\n\n                <mat-form-field>\n                    <input matInput\n                           (keyup)=\"apply_message($event.target.value)\"\n                           placeholder=\"Message\">\n                </mat-form-field>\n\n            </mat-card-content>\n        </mat-card>\n    </td>\n</table>\n\n\n<div class=\"mat-elevation-z8\">\n    <table mat-table [dataSource]=\"dataSource\" matSort>\n        <ng-container matColumnDef=\"time\">\n            <th mat-header-cell\n                *matHeaderCellDef\n                mat-sort-header style=\"width: 100px\">\n                Time\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.time| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"component\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Component\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.component}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"module\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Module\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.module}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"line\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Line\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.line}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"level\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Level\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.level}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"task\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Task\n            </th>\n\n            <td mat-cell\n                style=\"max-width: 500px\"\n                *matCellDef=\"let element\">\n                <a\n                        [routerLink]=\n                                \"'/tasks/task-detail/'+\n                                element.task.id.toString()+'/logs'\"\n                        *ngIf=\"element.task\">\n                    {{element.task.name}} ({{element.task.id}})\n                </a>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"step\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Step\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <span *ngIf=\"element.task\">\n                    {{element.step ? element.step.name : ''}}\n                </span>\n            </td>\n        </ng-container>\n\n\n        <ng-container matColumnDef=\"computer\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Computer\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <span *ngIf=\"element.computer\">\n                    {{element.computer}}\n                </span>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"message\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Message\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <div *ngFor=\"let l of element.message\">\n                    <span>{{l}}</span>\n                    <br/>\n                </div>\n            </td>\n        </ng-container>\n\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row *matRowDef=\"let row; columns: displayed_columns;\"></tr>\n    </table>\n\n    <mat-paginator\n            [pageSizeOptions]=\"[default_page_size, 30, 50, 100]\"\n            [length]=\"total\"\n            [pageSize]=\"default_page_size\">\n    </mat-paginator>\n\n</div>\n\n"

/***/ }),

/***/ "./src/app/log/log.component.ts":
/*!**************************************!*\
  !*** ./src/app/log/log.component.ts ***!
  \**************************************/
/*! exports provided: LogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogComponent", function() { return LogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _log_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./log.service */ "./src/app/log/log.service.ts");







var LogComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](LogComponent, _super);
    function LogComponent(service, location, router, route) {
        var _this = _super.call(this, service, location) || this;
        _this.service = service;
        _this.location = location;
        _this.router = router;
        _this.route = route;
        _this.displayed_columns = [
            'time',
            'task',
            'component',
            'step',
            'module',
            'line',
            'level',
            'computer',
            'message'
        ];
        _this.debug = true;
        _this.info = true;
        _this.warning = true;
        _this.error = true;
        _this.api = true;
        _this.supervisor = true;
        _this.worker = true;
        _this.worker_supervisor = true;
        _this.task_name = '';
        _this.step_name = '';
        _this.message = '';
        return _this;
    }
    LogComponent.prototype._ngOnInit = function () {
        var _this = this;
        this.route.queryParams
            .subscribe(function (params) {
            if (params['dag'])
                _this.dag = parseInt(params['dag']);
            if (params['task'])
                _this.task = parseInt(params['task']);
            if (params['computer'])
                _this.computer = params['computer'];
        });
        if (this.init_level) {
            this.debug = this.init_level == 'debug';
            this.info = this.init_level == 'info';
            this.warning = this.init_level == 'warning';
            this.error = this.init_level == 'error';
        }
    };
    LogComponent.prototype.apply_task_name = function (value) {
        this.task_name = value;
        this.change.emit();
    };
    LogComponent.prototype.apply_step_name = function (value) {
        this.step_name = value;
        this.change.emit();
    };
    LogComponent.prototype.apply_message = function (value) {
        this.message = value;
        this.change.emit();
    };
    LogComponent.prototype.get_components = function () {
        var components = [];
        if (this.api) {
            components.push(0);
        }
        if (this.supervisor) {
            components.push(1);
        }
        if (this.worker) {
            components.push(2);
        }
        if (this.worker_supervisor) {
            components.push(3);
        }
        return components;
    };
    LogComponent.prototype.get_levels = function () {
        var levels = [];
        if (this.debug) {
            levels.push(10);
        }
        if (this.info) {
            levels.push(20);
        }
        if (this.warning) {
            levels.push(30);
        }
        if (this.error) {
            levels.push(40);
        }
        return levels;
    };
    LogComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_3__["LogFilter"]();
        res.dag = this.dag;
        res.task = this.task;
        res.task_name = this.task_name;
        res.components = this.get_components();
        res.computer = this.computer;
        res.levels = this.get_levels();
        res.step_name = this.step_name;
        res.paginator = _super.prototype.get_filter.call(this);
        res.step = this.step;
        res.message = this.message;
        return res;
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], LogComponent.prototype, "task", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], LogComponent.prototype, "step", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", String)
    ], LogComponent.prototype, "init_level", void 0);
    LogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-log',
            template: __webpack_require__(/*! ./log.component.html */ "./src/app/log/log.component.html"),
            styles: [__webpack_require__(/*! ./log.component.css */ "./src/app/log/log.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_log_service__WEBPACK_IMPORTED_MODULE_6__["LogService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_4__["Location"],
            _angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"],
            _angular_router__WEBPACK_IMPORTED_MODULE_5__["ActivatedRoute"]])
    ], LogComponent);
    return LogComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_2__["Paginator"]));



/***/ }),

/***/ "./src/app/log/log.service.ts":
/*!************************************!*\
  !*** ./src/app/log/log.service.ts ***!
  \************************************/
/*! exports provided: LogService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogService", function() { return LogService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");



var LogService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](LogService, _super);
    function LogService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'logs';
        _this.single_part = 'log';
        return _this;
    }
    LogService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], LogService);
    return LogService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/login/login.component.html":
/*!********************************************!*\
  !*** ./src/app/login/login.component.html ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<h2>Authentication</h2>\n<form [formGroup]=\"loginForm\" (ngSubmit)=\"onSubmit()\">\n    <div class=\"form-group\">\n        <label for=\"token\">Token</label>\n        <input type=\"text\" formControlName=\"token\" class=\"form-control\"\n               [ngClass]=\"{ 'is-invalid': submitted && f.token.errors }\"/>\n        <div\n                *ngIf=\"submitted && invalid\"\n                class=\"invalid-feedback\"\n                style=\"color:red\">\n            <div>Invalid token</div>\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <button [disabled]=\"loading\" class=\"btn btn-primary\">Login</button>\n        <img *ngIf=\"loading\"\n             src=\"data:image/gif;base64,R0lGODlhEAAQAPIAAP///wAAAMLCwkJCQgAAAGJiYoKCgpKSkiH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAEAAQAAADMwi63P4wyklrE2MIOggZnAdOmGYJRbExwroUmcG2LmDEwnHQLVsYOd2mBzkYDAdKa+dIAAAh+QQJCgAAACwAAAAAEAAQAAADNAi63P5OjCEgG4QMu7DmikRxQlFUYDEZIGBMRVsaqHwctXXf7WEYB4Ag1xjihkMZsiUkKhIAIfkECQoAAAAsAAAAABAAEAAAAzYIujIjK8pByJDMlFYvBoVjHA70GU7xSUJhmKtwHPAKzLO9HMaoKwJZ7Rf8AYPDDzKpZBqfvwQAIfkECQoAAAAsAAAAABAAEAAAAzMIumIlK8oyhpHsnFZfhYumCYUhDAQxRIdhHBGqRoKw0R8DYlJd8z0fMDgsGo/IpHI5TAAAIfkECQoAAAAsAAAAABAAEAAAAzIIunInK0rnZBTwGPNMgQwmdsNgXGJUlIWEuR5oWUIpz8pAEAMe6TwfwyYsGo/IpFKSAAAh+QQJCgAAACwAAAAAEAAQAAADMwi6IMKQORfjdOe82p4wGccc4CEuQradylesojEMBgsUc2G7sDX3lQGBMLAJibufbSlKAAAh+QQJCgAAACwAAAAAEAAQAAADMgi63P7wCRHZnFVdmgHu2nFwlWCI3WGc3TSWhUFGxTAUkGCbtgENBMJAEJsxgMLWzpEAACH5BAkKAAAALAAAAAAQABAAAAMyCLrc/jDKSatlQtScKdceCAjDII7HcQ4EMTCpyrCuUBjCYRgHVtqlAiB1YhiCnlsRkAAAOwAAAAAAAAAAAA==\"/>\n    </div>\n</form>"

/***/ }),

/***/ "./src/app/login/login.component.ts":
/*!******************************************!*\
  !*** ./src/app/login/login.component.ts ***!
  \******************************************/
/*! exports provided: LoginComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginComponent", function() { return LoginComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm5/http.js");
/* harmony import */ var _message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../message.service */ "./src/app/message.service.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");







var LoginComponent = /** @class */ (function () {
    function LoginComponent(formBuilder, route, router, http, messageService) {
        this.formBuilder = formBuilder;
        this.route = route;
        this.router = router;
        this.http = http;
        this.messageService = messageService;
        this.loading = false;
        this.submitted = false;
        // redirect to home if already logged in
        if (localStorage.getItem('token')) {
            this.router.navigate(['/']);
        }
    }
    LoginComponent.prototype.ngOnInit = function () {
        this.loginForm = this.formBuilder.group({
            token: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__["Validators"].required]
        });
        // get return url from route parameters or default to '/'
        this.returnUrl = this.route.snapshot.queryParams['returnUrl'] || '/';
    };
    Object.defineProperty(LoginComponent.prototype, "f", {
        // convenience getter for easy access to form fields
        get: function () {
            return this.loginForm.controls;
        },
        enumerable: true,
        configurable: true
    });
    LoginComponent.prototype.onSubmit = function () {
        var _this = this;
        this.submitted = true;
        // stop here if form is invalid
        if (this.loginForm.invalid) {
            return;
        }
        this.loading = true;
        var token = this.f.token.value;
        this.http.post(_app_settings__WEBPACK_IMPORTED_MODULE_6__["AppSettings"].API_ENDPOINT + "token", { 'token': token }).subscribe(function (data) {
            localStorage.setItem('token', token);
            _this.invalid = false;
            _this.router.navigate([_this.returnUrl]);
        }, function (error) {
            _this.messageService.add(error);
            _this.loading = false;
            _this.invalid = true;
        });
    };
    LoginComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({ template: __webpack_require__(/*! ./login.component.html */ "./src/app/login/login.component.html") }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormBuilder"],
            _angular_router__WEBPACK_IMPORTED_MODULE_2__["ActivatedRoute"],
            _angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"],
            _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClient"],
            _message_service__WEBPACK_IMPORTED_MODULE_5__["MessageService"]])
    ], LoginComponent);
    return LoginComponent;
}());



/***/ }),

/***/ "./src/app/message.service.ts":
/*!************************************!*\
  !*** ./src/app/message.service.ts ***!
  \************************************/
/*! exports provided: MessageService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessageService", function() { return MessageService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");


var MessageService = /** @class */ (function () {
    function MessageService() {
        this.messages = [];
    }
    MessageService.prototype.add = function (message) {
        this.messages.push(message);
    };
    MessageService.prototype.clear = function () {
        this.messages = [];
    };
    MessageService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({ providedIn: 'root' })
    ], MessageService);
    return MessageService;
}());



/***/ }),

/***/ "./src/app/messages/messages.component.css":
/*!*************************************************!*\
  !*** ./src/app/messages/messages.component.css ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "/* MessagesComponent's private CSS styles */\nh2 {\n  color: red;\n  font-family: Arial, Helvetica, sans-serif;\n  font-weight: lighter;\n}\nbody {\n  margin: 2em;\n}\nbody, input[text], button {\n  color: crimson;\n  font-family: Cambria, Georgia;\n}\nbutton.clear {\n  font-family: Arial;\n  background-color: #eee;\n  border: none;\n  padding: 5px 10px;\n  border-radius: 4px;\n  cursor: pointer;\n  cursor: hand;\n}\nbutton:hover {\n  background-color: #cfd8dc;\n}\nbutton:disabled {\n  background-color: #eee;\n  color: #aaa;\n  cursor: auto;\n}\nbutton.clear {\n  color: #888;\n  margin-bottom: 12px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvbWVzc2FnZXMvbWVzc2FnZXMuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwyQ0FBMkM7QUFDM0M7RUFDRSxVQUFVO0VBQ1YseUNBQXlDO0VBQ3pDLG9CQUFvQjtBQUN0QjtBQUNBO0VBQ0UsV0FBVztBQUNiO0FBQ0E7RUFDRSxjQUFjO0VBQ2QsNkJBQTZCO0FBQy9CO0FBRUE7RUFDRSxrQkFBa0I7RUFDbEIsc0JBQXNCO0VBQ3RCLFlBQVk7RUFDWixpQkFBaUI7RUFDakIsa0JBQWtCO0VBQ2xCLGVBQWU7RUFDZixZQUFZO0FBQ2Q7QUFDQTtFQUNFLHlCQUF5QjtBQUMzQjtBQUNBO0VBQ0Usc0JBQXNCO0VBQ3RCLFdBQVc7RUFDWCxZQUFZO0FBQ2Q7QUFDQTtFQUNFLFdBQVc7RUFDWCxtQkFBbUI7QUFDckIiLCJmaWxlIjoic3JjL2FwcC9tZXNzYWdlcy9tZXNzYWdlcy5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLyogTWVzc2FnZXNDb21wb25lbnQncyBwcml2YXRlIENTUyBzdHlsZXMgKi9cbmgyIHtcbiAgY29sb3I6IHJlZDtcbiAgZm9udC1mYW1pbHk6IEFyaWFsLCBIZWx2ZXRpY2EsIHNhbnMtc2VyaWY7XG4gIGZvbnQtd2VpZ2h0OiBsaWdodGVyO1xufVxuYm9keSB7XG4gIG1hcmdpbjogMmVtO1xufVxuYm9keSwgaW5wdXRbdGV4dF0sIGJ1dHRvbiB7XG4gIGNvbG9yOiBjcmltc29uO1xuICBmb250LWZhbWlseTogQ2FtYnJpYSwgR2VvcmdpYTtcbn1cblxuYnV0dG9uLmNsZWFyIHtcbiAgZm9udC1mYW1pbHk6IEFyaWFsO1xuICBiYWNrZ3JvdW5kLWNvbG9yOiAjZWVlO1xuICBib3JkZXI6IG5vbmU7XG4gIHBhZGRpbmc6IDVweCAxMHB4O1xuICBib3JkZXItcmFkaXVzOiA0cHg7XG4gIGN1cnNvcjogcG9pbnRlcjtcbiAgY3Vyc29yOiBoYW5kO1xufVxuYnV0dG9uOmhvdmVyIHtcbiAgYmFja2dyb3VuZC1jb2xvcjogI2NmZDhkYztcbn1cbmJ1dHRvbjpkaXNhYmxlZCB7XG4gIGJhY2tncm91bmQtY29sb3I6ICNlZWU7XG4gIGNvbG9yOiAjYWFhO1xuICBjdXJzb3I6IGF1dG87XG59XG5idXR0b24uY2xlYXIge1xuICBjb2xvcjogIzg4ODtcbiAgbWFyZ2luLWJvdHRvbTogMTJweDtcbn1cbiJdfQ== */"

/***/ }),

/***/ "./src/app/messages/messages.component.html":
/*!**************************************************!*\
  !*** ./src/app/messages/messages.component.html ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div *ngIf=\"messageService.messages.length\">\n\n  <h2>Messages</h2>\n  <button class=\"clear\"\n          (click)=\"messageService.clear()\">clear</button>\n  <div *ngFor='let message of messageService.messages'> {{message}} </div>\n\n</div>\n"

/***/ }),

/***/ "./src/app/messages/messages.component.ts":
/*!************************************************!*\
  !*** ./src/app/messages/messages.component.ts ***!
  \************************************************/
/*! exports provided: MessagesComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessagesComponent", function() { return MessagesComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _message_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../message.service */ "./src/app/message.service.ts");



var MessagesComponent = /** @class */ (function () {
    function MessagesComponent(messageService) {
        this.messageService = messageService;
    }
    MessagesComponent.prototype.ngOnInit = function () {
    };
    MessagesComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-messages',
            template: __webpack_require__(/*! ./messages.component.html */ "./src/app/messages/messages.component.html"),
            styles: [__webpack_require__(/*! ./messages.component.css */ "./src/app/messages/messages.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_message_service__WEBPACK_IMPORTED_MODULE_2__["MessageService"]])
    ], MessagesComponent);
    return MessagesComponent;
}());



/***/ }),

/***/ "./src/app/model/model-add-dialog.component.ts":
/*!*****************************************************!*\
  !*** ./src/app/model/model-add-dialog.component.ts ***!
  \*****************************************************/
/*! exports provided: ModelAddDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ModelAddDialogComponent", function() { return ModelAddDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _model_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./model.service */ "./src/app/model/model.service.ts");




var ModelAddDialogComponent = /** @class */ (function () {
    function ModelAddDialogComponent(dialogRef, data, service) {
        this.dialogRef = dialogRef;
        this.data = data;
        this.service = service;
    }
    ModelAddDialogComponent.prototype.on_ok_click = function () {
        var _this = this;
        this.service.add(this.data).subscribe(function (res) {
            _this.error = res.error;
            if (res.success) {
                _this.dialogRef.close();
            }
        });
    };
    ModelAddDialogComponent.prototype.on_cancel_click = function () {
        this.dialogRef.close();
    };
    ModelAddDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'model-add-dialog',
            template: __webpack_require__(/*! ./model-add-dialog.html */ "./src/app/model/model-add-dialog.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"], Object, _model_service__WEBPACK_IMPORTED_MODULE_3__["ModelService"]])
    ], ModelAddDialogComponent);
    return ModelAddDialogComponent;
}());



/***/ }),

/***/ "./src/app/model/model-add-dialog.html":
/*!*********************************************!*\
  !*** ./src/app/model/model-add-dialog.html ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div mat-dialog-content>\n    <mat-form-field>\n        <mat-label>Name</mat-label>\n        <input matInput [(ngModel)]=\"data.name\">\n    </mat-form-field>\n</div>\n\n<div mat-dialog-content>\n    <mat-form-field>\n        <mat-label>File</mat-label>\n        <input matInput [(ngModel)]=\"data.file\">\n    </mat-form-field>\n</div>\n\n<mat-form-field style=\"width: 150px\">\n    <mat-label>Project</mat-label>\n    <mat-select\n            (ngModelChange)=\"data.project=$event;\"\n            [(ngModel)]=\"data.project\">\n        <mat-option *ngFor=\"let project of data.projects\" [value]=\"project.id\">\n            {{project.name}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<div mat-dialog-content>\n    <mat-form-field>\n        <mat-label>Fold</mat-label>\n        <input matInput [(ngModel)]=\"data.fold\">\n    </mat-form-field>\n</div>\n\n\n<pre style=\"color: red\" *ngIf=\"error\">\n    Error:\n\n    {{error}}\n</pre>\n\n<div mat-dialog-actions>\n    <button mat-button (click)=\"on_cancel_click()\">Cancel</button>\n    <button mat-button\n            (click)=\"on_ok_click()\"\n            cdkFocusInitial>\n        Ok\n    </button>\n</div>"

/***/ }),

/***/ "./src/app/model/model-start-dialog.component.ts":
/*!*******************************************************!*\
  !*** ./src/app/model/model-start-dialog.component.ts ***!
  \*******************************************************/
/*! exports provided: ModelStartDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ModelStartDialogComponent", function() { return ModelStartDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _model_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model.service */ "./src/app/model/model.service.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../helpers */ "./src/app/helpers.ts");






var ModelStartDialogComponent = /** @class */ (function () {
    function ModelStartDialogComponent(dialogRef, data, service) {
        this.dialogRef = dialogRef;
        this.data = data;
        this.service = service;
    }
    ModelStartDialogComponent.prototype.on_ok_click = function (close) {
        var _this = this;
        if (close === void 0) { close = true; }
        if (this.data && this.data.pipe && this.data.pipe.versions) {
            var version = this.data.pipe.versions[0];
            if (version.name == 'last') {
                version.name = _helpers__WEBPACK_IMPORTED_MODULE_5__["Helpers"].format_date_time(new Date(), true, true);
            }
        }
        this.service.start_end(this.data).subscribe(function (res) {
            _this.error = res.error;
            if (res.success) {
                if (close) {
                    _this.dialogRef.close();
                }
                else {
                    _this.success = true;
                }
            }
        });
    };
    ModelStartDialogComponent.prototype.on_cancel_click = function () {
        this.dialogRef.close();
    };
    ModelStartDialogComponent.prototype.dag_changed = function () {
        var dag = this.data.dag;
        if (!dag) {
            return;
        }
        for (var _i = 0, _a = dag.pipes; _i < _a.length; _i++) {
            var pipe = _a[_i];
            if (!pipe.versions ||
                pipe.versions.length == 0) {
                pipe.versions = [
                    { 'name': 'last', 'equations': '' }
                ];
            }
        }
        if (dag.pipes.length >= 1) {
            this.data.pipe = dag.pipes[0];
            this.data.pipe.version = this.data.pipe.versions[0];
        }
    };
    ModelStartDialogComponent.prototype.pipe_changed = function () {
        var pipe = this.data.pipe;
        if (!pipe || !pipe.versions || pipe.versions.length == 0) {
            return;
        }
        pipe.version = pipe.versions[0];
    };
    ModelStartDialogComponent.prototype.ngOnInit = function () {
        var _this = this;
        var self = this;
        this.service.start_begin(this.data).subscribe(function (res) {
            _this.error = res.error;
            if (_this.error) {
                return;
            }
            _this.data = {
                'model_id': self.data.model_id,
                'dags': res.dags
            };
            if (res.dag) {
                for (var _i = 0, _a = _this.data.dags; _i < _a.length; _i++) {
                    var d = _a[_i];
                    if (d.id == res.dag.id) {
                        _this.data.dag = d;
                        break;
                    }
                }
            }
            _this.dag_changed();
        });
    };
    ModelStartDialogComponent.prototype.key_down = function (event) {
        if (!this.data.pipe || !this.data.pipe.version) {
            return;
        }
        this.success = false;
        if (event.ctrlKey && event.key != 'v') {
            return;
        }
        var version = this.data.pipe.version;
        if (version.name != 'last') {
            var new_version = {
                'name': 'last',
                'equations': event.target.value
            };
            this.data.pipe.version = new_version;
            if (this.data.pipe.versions[0].name == 'last') {
                this.data.pipe.versions[0] = new_version;
            }
            else {
                this.data.pipe.versions.splice(0, 0, new_version);
            }
        }
        var content = _helpers__WEBPACK_IMPORTED_MODULE_5__["Helpers"].handle_textarea_down_key(event, this.textarea.nativeElement);
        if (content) {
            this.data.pipe.version.equations = content;
        }
    };
    ModelStartDialogComponent.prototype.move_up = function (event) {
        event.preventDefault();
        event.stopPropagation();
        if (!this.data.pipe || !this.data.pipe.version) {
            return;
        }
        var index = this.data.pipe.versions.indexOf(this.data.pipe.version);
        if (index == 0) {
            return;
        }
        this.data.pipe.version = this.data.pipe.versions[index - 1];
    };
    ModelStartDialogComponent.prototype.move_down = function (event) {
        event.preventDefault();
        event.stopPropagation();
        if (!this.data.pipe || !this.data.pipe.version) {
            return;
        }
        var index = this.data.pipe.versions.indexOf(this.data.pipe.version);
        if (index >= this.data.pipe.versions.length - 1) {
            return;
        }
        this.data.pipe.version = this.data.pipe.versions[index + 1];
    };
    ModelStartDialogComponent.prototype.is_up_transparent = function () {
        if (!this.data.pipe || !this.data.pipe.version) {
            return true;
        }
        var index = this.data.pipe.versions.indexOf(this.data.pipe.version);
        return index <= 0;
    };
    ModelStartDialogComponent.prototype.is_down_transparent = function () {
        if (!this.data.pipe || !this.data.pipe.version) {
            return true;
        }
        var index = this.data.pipe.versions.indexOf(this.data.pipe.version);
        return index >= this.data.pipe.versions.length - 1;
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])('textarea'),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Object)
    ], ModelStartDialogComponent.prototype, "textarea", void 0);
    ModelStartDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'model-start-dialog',
            template: __webpack_require__(/*! ./model-start-dialog.html */ "./src/app/model/model-start-dialog.html"),
            styles: [__webpack_require__(/*! ./model-start-dialog.css */ "./src/app/model/model-start-dialog.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"],
            _models__WEBPACK_IMPORTED_MODULE_3__["ModelStartData"],
            _model_service__WEBPACK_IMPORTED_MODULE_4__["ModelService"]])
    ], ModelStartDialogComponent);
    return ModelStartDialogComponent;
}());



/***/ }),

/***/ "./src/app/model/model-start-dialog.css":
/*!**********************************************!*\
  !*** ./src/app/model/model-start-dialog.css ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\n.positionCameras ul, .positionCameras li {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n    vertical-align:top;\n}\n.positionCameras li.cameraLeft, .positionCameras li.cameraIcon, .positionCameras li.cameraRight {\n    width: 25px;\n    height: 25px;\n    cursor: pointer;\n    background: #cccccc;\n    margin: 5px;\n    border-radius: 5px;\n    border: 1px solid #aaaaaa;\n    box-shadow: 1px 2px 15px #cccccc;\n    text-align:center;\n    line-height:20px;\n}\n.positionCameras li.cameraLeft:before {\n    content:\"\";\n    display:inline-block;\n    width: 0;\n    height: 0;\n    vertical-align:middle;\n    border-style: solid;\n    border-width: 0 5px 10px 5px;\n    border-color: transparent transparent #007bff transparent;\n}\n.positionCameras li.cameraIcon {\n    cursor: default;\n}\n.positionCameras li.cameraRight:before {\n    content:'';\n    display:inline-block;\n    vertical-align:middle;\n    width: 0;\n    height: 0;\n    border-style: solid;\n    border-width: 8.7px 5px 0 5px;\n    border-color: #007bff transparent transparent transparent;\n}\n.cameraIcon:before {\n    content:'';\n    display:inline-block;\n    vertical-align:middle;\n    height:10px;\n    width:10px;\n    border-radius:100%;\n    box-shadow:0 0 0 3px gray, inset -1px -1px 0 3px black;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/model/model-start-dialog.html":
/*!***********************************************!*\
  !*** ./src/app/model/model-start-dialog.html ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<mat-form-field style=\"width: 150px\">\n    <mat-label>Dag</mat-label>\n    <mat-select\n            (ngModelChange)=\"data.dag=$event; dag_changed()\"\n            [(ngModel)]=\"data.dag\">\n        <mat-option *ngFor=\"let dag of data.dags\" [value]=\"dag\">\n            {{dag.name}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<mat-form-field style=\"width: 150px\" *ngIf=\"data.dag\">\n    <mat-label>Pipe</mat-label>\n    <mat-select\n            (ngModelChange)=\"data.pipe=$event; pipe_changed()\"\n            [(ngModel)]=\"data.pipe\">\n        <mat-option *ngFor=\"let pipe of data.dag.pipes\" [value]=\"pipe\">\n            {{pipe.name}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<mat-form-field style=\"width: 200px\" *ngIf=\"data.pipe && data.pipe.versions\">\n    <mat-label>Versions</mat-label>\n\n    <mat-select\n            (ngModelChange)=\"data.pipe.version=$event;\"\n            [(ngModel)]=\"data.pipe.version\">\n        <mat-option\n                *ngFor=\"let version of data.pipe.versions\"\n                [value]=\"version\">\n            {{version.name}}\n        </mat-option>\n    </mat-select>\n\n    <mat-icon class=\"positionCameras\" matSuffix>\n        <ul>\n            <li title='Move Up' class=\"cameraLeft\"\n                (click)=\"move_up($event)\"\n                [class.transparent]='is_up_transparent()'></li>\n            <li title=\"Move Down\" class=\"cameraRight\"\n                (click)=\"move_down($event)\"\n                [class.transparent]='is_down_transparent()'></li>\n        </ul>\n    </mat-icon>\n\n</mat-form-field>\n\n<div mat-dialog-content *ngIf=\"data.pipe && data.pipe.version\">\n    <mat-form-field style=\"width: 1000px\">\n        <mat-label>Additional info</mat-label>\n        <textarea\n                #textarea\n                matInput\n                [(ngModel)]=\"data.pipe.version.equations\"\n                (keydown)=\"key_down($event)\"\n                style=\"height:550px;width: 1000px\">\n\n      </textarea>\n    </mat-form-field>\n</div>\n\n<pre style=\"color: red\" *ngIf=\"error\">\n    {{error}}\n</pre>\n\n<div style=\"color: green\" *ngIf=\"success\">Success</div>\n\n<div mat-dialog-actions>\n    <button mat-button (click)=\"on_cancel_click()\">Cancel</button>\n\n    <button mat-button\n            (click)=\"on_ok_click()\"\n            cdkFocusInitial>\n        Ok\n    </button>\n\n    <button mat-button\n            (click)=\"on_ok_click(false)\">\n        Ok(don't close)\n    </button>\n</div>"

/***/ }),

/***/ "./src/app/model/model.component.css":
/*!*******************************************!*\
  !*** ./src/app/model/model.component.css ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 70%;\n  min-width: 1200px;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\ntd, th {\n  width: 10%;\n\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\ntd{\n  text-align: center;\n}\n\n.checkbox-section {\n  display: flex;\n  align-content: center;\n  align-items: center;\n  height: 60px;\n}\n\n.checkbox-margin {\n  margin: 0 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvbW9kZWwvbW9kZWwuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLFVBQVU7RUFDVixpQkFBaUI7QUFDbkI7O0FBRUE7RUFDRSxlQUFlO0VBQ2YsV0FBVztBQUNiOztBQUVBO0VBQ0UsVUFBVTs7QUFFWjs7QUFFQTtFQUNFLGVBQWU7QUFDakI7O0FBRUE7RUFDRSxZQUFZO0VBQ1osc0JBQXNCO0VBQ3RCLGtCQUFrQjtFQUNsQiw0QkFBNEI7QUFDOUI7O0FBRUE7RUFDRSw2QkFBNkI7QUFDL0I7O0FBRUE7RUFDRSxrQkFBa0I7QUFDcEI7O0FBRUE7RUFDRSxhQUFhO0VBQ2IscUJBQXFCO0VBQ3JCLG1CQUFtQjtFQUNuQixZQUFZO0FBQ2Q7O0FBRUE7RUFDRSxjQUFjO0FBQ2hCIiwiZmlsZSI6InNyYy9hcHAvbW9kZWwvbW9kZWwuY29tcG9uZW50LmNzcyIsInNvdXJjZXNDb250ZW50IjpbInRhYmxlIHtcbiAgd2lkdGg6IDcwJTtcbiAgbWluLXdpZHRoOiAxMjAwcHg7XG59XG5cbi5tYXQtZm9ybS1maWVsZCB7XG4gIGZvbnQtc2l6ZTogMTRweDtcbiAgd2lkdGg6IDEwMCU7XG59XG5cbnRkLCB0aCB7XG4gIHdpZHRoOiAxMCU7XG5cbn1cblxubWF0LWljb257XG4gIGN1cnNvcjogcG9pbnRlcjtcbn1cblxuOjpuZy1kZWVwIC5tYXQtc29ydC1oZWFkZXItY29udGFpbmVye1xuICBkaXNwbGF5OmZsZXg7XG4gIGp1c3RpZnktY29udGVudDpjZW50ZXI7XG4gIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgbWFyZ2luLWxlZnQ6IDEycHggIWltcG9ydGFudDtcbn1cblxuLm1hdC1oZWFkZXItY2VsbHtcbiAgdGV4dC1hbGlnbjogY2VudGVyICFpbXBvcnRhbnQ7XG59XG5cbnRke1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG59XG5cbi5jaGVja2JveC1zZWN0aW9uIHtcbiAgZGlzcGxheTogZmxleDtcbiAgYWxpZ24tY29udGVudDogY2VudGVyO1xuICBhbGlnbi1pdGVtczogY2VudGVyO1xuICBoZWlnaHQ6IDYwcHg7XG59XG5cbi5jaGVja2JveC1tYXJnaW4ge1xuICBtYXJnaW46IDAgMTBweDtcbn0iXX0= */"

/***/ }),

/***/ "./src/app/model/model.component.html":
/*!********************************************!*\
  !*** ./src/app/model/model.component.html ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<button mat-raised-button\n        style=\"margin-top: 15px\"\n        (click)=\"add()\">\n    Add\n</button>\n\n\n<button mat-raised-button style=\"margin-top: 15px\"\n        (click)=\"filter_hidden=!filter_hidden\">\n    Filters {{filter_applied_text}}\n</button>\n\n<div [hidden]=\"filter_hidden\">\n    <mat-form-field style=\"width: 150px\">\n        <mat-label>Project</mat-label>\n        <mat-select (ngModelChange)=\"project=$event; onchange()\"\n                    [ngModel]=\"project\">\n            <mat-option\n                    *ngFor=\"let project of projects\"\n                    [value]=\"project.id\">\n                {{project.name}}\n            </mat-option>\n        </mat-select>\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 150px\">\n        <input matInput (keyup)=\"name=$event.target.value;onchange()\"\n               placeholder=\"Name\">\n    </mat-form-field>\n\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"created min\"\n               [ngModel]=\"created_min\"\n               (ngModelChange)=\"created_min = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"created max\"\n               [ngModel]=\"created_max\"\n               (ngModelChange)=\"created_max = $event;onchange()\">\n    </mat-form-field>\n\n</div>\n\n<div class=\"mat-elevation-z8\">\n    <table mat-table [dataSource]=\"dataSource\" matSort>\n\n        <ng-container matColumnDef=\"id\">\n            <th mat-header-cell\n                *matHeaderCellDef mat-sort-header\n                style=\"width: 5%\">\n                Id\n            </th>\n\n            <td mat-cell\n                *matCellDef=\"let element\"\n                style=\"width: 5%\">\n                {{element.id}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"name\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header> Name</th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.name}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"project\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>Project</th>\n            <td mat-cell *matCellDef=\"let element\">\n                \n                <span *ngIf=\"element.project_rel\">\n                    {{element.project_rel.name}}\n                </span>\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"score_local\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Score local\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.score_local|number:'.5'}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"score_public\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>Score\n                public\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.score_public|number:'.5'}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"created\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>Created</th>\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 100px\">\n                {{element.created| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"dag\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>Dag</th>\n            <td mat-cell *matCellDef=\"let element\">\n                <a\n                        routerLink=\"/dags/dag-detail/{{element.dag}}\"\n                        *ngIf=\"element.dag_rel\">\n                    {{element.dag_rel.name}}\n                </a>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"links\">\n            <th mat-header-cell *matHeaderCellDef\n                style=\"text-align: center; width: 14%;\">\n                Links\n            </th>\n            <td mat-cell *matCellDef=\"let element\"\n                style=\"padding-left: 1%;min-width: 120px\">\n                <mat-icon svgIcon=\"start\" matTooltip=\"Start\"\n                          (click)=\"start(element)\">\n                </mat-icon>\n\n                <mat-icon svgIcon=\"remove\" matTooltip=\"Remove\"\n                          (click)=\"remove(element)\">\n                </mat-icon>\n            </td>\n        </ng-container>\n\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row *matRowDef=\"let row; columns: displayed_columns;\"></tr>\n    </table>\n\n    <mat-paginator [pageSizeOptions]=\"[default_page_size, 30, 100]\" [length]=\"total\"\n                   [pageSize]=\"default_page_size\"></mat-paginator>\n\n</div>\n\n"

/***/ }),

/***/ "./src/app/model/model.component.ts":
/*!******************************************!*\
  !*** ./src/app/model/model.component.ts ***!
  \******************************************/
/*! exports provided: ModelComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ModelComponent", function() { return ModelComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _model_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./model.service */ "./src/app/model/model.service.ts");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../helpers */ "./src/app/helpers.ts");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/platform-browser */ "./node_modules/@angular/platform-browser/fesm5/platform-browser.js");
/* harmony import */ var _model_start_dialog_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./model-start-dialog.component */ "./src/app/model/model-start-dialog.component.ts");
/* harmony import */ var _model_add_dialog_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./model-add-dialog.component */ "./src/app/model/model-add-dialog.component.ts");
/* harmony import */ var _dialog_dialog_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../dialog/dialog.component */ "./src/app/dialog/dialog.component.ts");













var ModelComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ModelComponent, _super);
    function ModelComponent(service, location, router, route, iconRegistry, sanitizer, start_dialog, model_add_dialog, dialog) {
        var _this = _super.call(this, service, location) || this;
        _this.service = service;
        _this.location = location;
        _this.router = router;
        _this.route = route;
        _this.start_dialog = start_dialog;
        _this.model_add_dialog = model_add_dialog;
        _this.dialog = dialog;
        _this.displayed_columns = [
            'project',
            'dag',
            'id',
            'name',
            'created',
            'score_local',
            'score_public',
            'links'
        ];
        _this.filter_hidden = true;
        iconRegistry.addSvgIcon('edit', sanitizer.bypassSecurityTrustResourceUrl('assets/img/edit.svg'));
        iconRegistry.addSvgIcon('start', sanitizer.bypassSecurityTrustResourceUrl('assets/img/play-button.svg'));
        iconRegistry.addSvgIcon('remove', sanitizer.bypassSecurityTrustResourceUrl('assets/img/trash.svg'));
        return _this;
    }
    ModelComponent.prototype._ngOnInit = function () {
        var self = this;
        this.data_updated.subscribe(function (res) {
            if (!res || !res.projects) {
                return;
            }
            self.projects = res.projects;
            self.projects.splice(0, 0, { 'id': -1, 'name': 'None' });
        });
    };
    ModelComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_3__["ModelFilter"]();
        res.paginator = _super.prototype.get_filter.call(this);
        res.paginator.sort_column = 'created';
        res.name = this.name;
        if (this.project != -1) {
            res.project = this.project;
        }
        res.created_min = _helpers__WEBPACK_IMPORTED_MODULE_8__["Helpers"].parse_time(this.created_min);
        res.created_max = _helpers__WEBPACK_IMPORTED_MODULE_8__["Helpers"].parse_time(this.created_max);
        return res;
    };
    ModelComponent.prototype.onchange = function () {
        this.change.emit();
        var count = 0;
        if (this.name)
            count += 1;
        if (this.project && this.project != -1)
            count += 1;
        if (this.created_min)
            count += 1;
        if (this.created_max)
            count += 1;
        this.filter_applied_text = count > 0 ? "(" + count + " applied)" : '';
    };
    ModelComponent.prototype.remove = function (element) {
        var _this = this;
        var self = this;
        var dialogRef = this.dialog.open(_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_12__["DialogComponent"], {
            width: '550px', height: '200px',
            data: {
                'message': 'The all content will be deleted. ' +
                    'Do you want to continue?'
            }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.remove(element.id).subscribe(function (res) {
                    self.change.emit();
                });
            }
        });
    };
    ModelComponent.prototype.start = function (element) {
        var _this = this;
        var config = {
            width: '1050px', height: '800px',
            data: {
                'model_id': element.id
            }
        };
        var dialog = this.start_dialog.open(_model_start_dialog_component__WEBPACK_IMPORTED_MODULE_10__["ModelStartDialogComponent"], config);
        dialog.afterClosed().subscribe(function (res) { return _this.change.emit(); });
    };
    ModelComponent.prototype.add = function () {
        var _this = this;
        var dialog = this.model_add_dialog.open(_model_add_dialog_component__WEBPACK_IMPORTED_MODULE_11__["ModelAddDialogComponent"], {
            width: '500px', height: '400px',
            data: {
                'projects': this.projects.filter(function (x) { return x.name != 'None'; }),
                'equations': '',
                'name': '',
                'file': ''
            }
        });
        dialog.afterClosed().subscribe(function (res) { return _this.change.emit(); });
    };
    ModelComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-model',
            template: __webpack_require__(/*! ./model.component.html */ "./src/app/model/model.component.html"),
            styles: [__webpack_require__(/*! ./model.component.css */ "./src/app/model/model.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_model_service__WEBPACK_IMPORTED_MODULE_6__["ModelService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_4__["Location"],
            _angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"],
            _angular_router__WEBPACK_IMPORTED_MODULE_5__["ActivatedRoute"],
            _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatIconRegistry"],
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_9__["DomSanitizer"],
            _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDialog"],
            _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDialog"],
            _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDialog"]])
    ], ModelComponent);
    return ModelComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_2__["Paginator"]));



/***/ }),

/***/ "./src/app/model/model.service.ts":
/*!****************************************!*\
  !*** ./src/app/model/model.service.ts ***!
  \****************************************/
/*! exports provided: ModelService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ModelService", function() { return ModelService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");






var ModelService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ModelService, _super);
    function ModelService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'models';
        _this.single_part = 'model';
        return _this;
    }
    ModelService.prototype.add = function (data) {
        var message = this.constructor.name + ".add";
        var info = {
            'name': data.name,
            'task': data.task,
            'equations': data.equations,
            'project': data.project,
            'file': data.file,
            'fold': data.fold
        };
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/add';
        return this.http.post(url, info).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ModelService.prototype.start_begin = function (data) {
        var message = this.constructor.name + ".start_begin";
        var info = {
            'model_id': data.model_id
        };
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/start_begin';
        return this.http.post(url, info).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["ModelStartData"]())));
    };
    ModelService.prototype.start_end = function (data) {
        var message = this.constructor.name + ".start_end";
        var info = {
            'dag': data.dag.id,
            'pipe': data.pipe,
            'model_id': data.model_id
        };
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/start_end';
        return this.http.post(url, info).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ModelService.prototype.remove = function (id) {
        var message = this.constructor.name + ".remove";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/remove';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ModelService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], ModelService);
    return ModelService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/models.ts":
/*!***************************!*\
  !*** ./src/app/models.ts ***!
  \***************************/
/*! exports provided: BaseResult, UpdateCodeResult, Project, NameCount, Dag, Task, PaginatorRes, Data, CodeNode, CodeResult, Gpu, Usage, ComputerUsage, Computer, SyncProject, SyncStart, Step, Log, Graph, PaginatorFilter, ComputerFilter, LogFilter, ProjectFilter, DagFilter, TaskFilter, ReportsFilter, ToogleReportResult, Status, DagStopResult, ReportItem, Metric, Report, StepNode, StepNodeResult, Img, Series, SeriesItem, ImgAttr, ImgClassify, Model, ModelFilter, ReportUpdateData, ModelStartData, Layout, AuxiliarySupervisorComputer, AuxiliarySupervisorParentTask, AuxiliarySupervisorNotRanTask, AuxiliarySupervisorProcessTask, AuxiliarySupervisor, Auxiliary, TaskInfo, Memory, MemoryFilter, Space, SpaceAdd, SpaceFilter, SpaceRun, DagRestart, TagResult, NamesResult */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BaseResult", function() { return BaseResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdateCodeResult", function() { return UpdateCodeResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Project", function() { return Project; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NameCount", function() { return NameCount; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Dag", function() { return Dag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Task", function() { return Task; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PaginatorRes", function() { return PaginatorRes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Data", function() { return Data; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CodeNode", function() { return CodeNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CodeResult", function() { return CodeResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Gpu", function() { return Gpu; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Usage", function() { return Usage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComputerUsage", function() { return ComputerUsage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Computer", function() { return Computer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SyncProject", function() { return SyncProject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SyncStart", function() { return SyncStart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Step", function() { return Step; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Log", function() { return Log; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Graph", function() { return Graph; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PaginatorFilter", function() { return PaginatorFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComputerFilter", function() { return ComputerFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogFilter", function() { return LogFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProjectFilter", function() { return ProjectFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DagFilter", function() { return DagFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskFilter", function() { return TaskFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportsFilter", function() { return ReportsFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ToogleReportResult", function() { return ToogleReportResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Status", function() { return Status; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DagStopResult", function() { return DagStopResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportItem", function() { return ReportItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Metric", function() { return Metric; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Report", function() { return Report; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepNode", function() { return StepNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepNodeResult", function() { return StepNodeResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Img", function() { return Img; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Series", function() { return Series; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SeriesItem", function() { return SeriesItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ImgAttr", function() { return ImgAttr; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ImgClassify", function() { return ImgClassify; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return Model; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ModelFilter", function() { return ModelFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportUpdateData", function() { return ReportUpdateData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ModelStartData", function() { return ModelStartData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Layout", function() { return Layout; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliarySupervisorComputer", function() { return AuxiliarySupervisorComputer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliarySupervisorParentTask", function() { return AuxiliarySupervisorParentTask; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliarySupervisorNotRanTask", function() { return AuxiliarySupervisorNotRanTask; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliarySupervisorProcessTask", function() { return AuxiliarySupervisorProcessTask; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AuxiliarySupervisor", function() { return AuxiliarySupervisor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Auxiliary", function() { return Auxiliary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskInfo", function() { return TaskInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Memory", function() { return Memory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MemoryFilter", function() { return MemoryFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Space", function() { return Space; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpaceAdd", function() { return SpaceAdd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpaceFilter", function() { return SpaceFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpaceRun", function() { return SpaceRun; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DagRestart", function() { return DagRestart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TagResult", function() { return TagResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NamesResult", function() { return NamesResult; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

var BaseResult = /** @class */ (function () {
    function BaseResult() {
    }
    return BaseResult;
}());

var UpdateCodeResult = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](UpdateCodeResult, _super);
    function UpdateCodeResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return UpdateCodeResult;
}(BaseResult));

var Project = /** @class */ (function () {
    function Project() {
    }
    return Project;
}());

var NameCount = /** @class */ (function () {
    function NameCount() {
    }
    return NameCount;
}());

var Dag = /** @class */ (function () {
    function Dag() {
    }
    return Dag;
}());

var Task = /** @class */ (function () {
    function Task() {
    }
    return Task;
}());

var PaginatorRes = /** @class */ (function () {
    function PaginatorRes() {
        this.data = [];
        this.total = 0;
    }
    return PaginatorRes;
}());

var Data = /** @class */ (function () {
    function Data() {
    }
    return Data;
}());

var CodeNode = /** @class */ (function () {
    function CodeNode() {
    }
    return CodeNode;
}());

var CodeResult = /** @class */ (function () {
    function CodeResult() {
    }
    return CodeResult;
}());

var Gpu = /** @class */ (function () {
    function Gpu() {
    }
    return Gpu;
}());

var Usage = /** @class */ (function () {
    function Usage() {
    }
    return Usage;
}());

var ComputerUsage = /** @class */ (function () {
    function ComputerUsage() {
    }
    return ComputerUsage;
}());

var Computer = /** @class */ (function () {
    function Computer() {
    }
    return Computer;
}());

var SyncProject = /** @class */ (function () {
    function SyncProject() {
    }
    return SyncProject;
}());

var SyncStart = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](SyncStart, _super);
    function SyncStart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return SyncStart;
}(BaseResult));

var Step = /** @class */ (function () {
    function Step() {
    }
    return Step;
}());

var Log = /** @class */ (function () {
    function Log() {
    }
    return Log;
}());

var Graph = /** @class */ (function () {
    function Graph() {
    }
    return Graph;
}());

var PaginatorFilter = /** @class */ (function () {
    function PaginatorFilter() {
    }
    return PaginatorFilter;
}());

var ComputerFilter = /** @class */ (function () {
    function ComputerFilter() {
    }
    return ComputerFilter;
}());

var LogFilter = /** @class */ (function () {
    function LogFilter() {
    }
    return LogFilter;
}());

var ProjectFilter = /** @class */ (function () {
    function ProjectFilter() {
    }
    return ProjectFilter;
}());

var DagFilter = /** @class */ (function () {
    function DagFilter() {
    }
    return DagFilter;
}());

var TaskFilter = /** @class */ (function () {
    function TaskFilter() {
    }
    return TaskFilter;
}());

var ReportsFilter = /** @class */ (function () {
    function ReportsFilter() {
    }
    return ReportsFilter;
}());

var ToogleReportResult = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ToogleReportResult, _super);
    function ToogleReportResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ToogleReportResult;
}(BaseResult));

var Status = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Status, _super);
    function Status() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return Status;
}(BaseResult));

var DagStopResult = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](DagStopResult, _super);
    function DagStopResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return DagStopResult;
}(BaseResult));

var ReportItem = /** @class */ (function () {
    function ReportItem() {
    }
    return ReportItem;
}());

var Metric = /** @class */ (function () {
    function Metric() {
    }
    return Metric;
}());

var Report = /** @class */ (function () {
    function Report() {
    }
    return Report;
}());

var StepNode = /** @class */ (function () {
    function StepNode() {
    }
    return StepNode;
}());

var StepNodeResult = /** @class */ (function () {
    function StepNodeResult() {
    }
    return StepNodeResult;
}());

var Img = /** @class */ (function () {
    function Img() {
    }
    return Img;
}());

var Series = /** @class */ (function () {
    function Series() {
    }
    return Series;
}());

var SeriesItem = /** @class */ (function () {
    function SeriesItem() {
    }
    return SeriesItem;
}());

var ImgAttr = /** @class */ (function () {
    function ImgAttr() {
    }
    return ImgAttr;
}());

var ImgClassify = /** @class */ (function () {
    function ImgClassify() {
    }
    return ImgClassify;
}());

var Model = /** @class */ (function () {
    function Model() {
    }
    return Model;
}());

var ModelFilter = /** @class */ (function () {
    function ModelFilter() {
    }
    return ModelFilter;
}());

var ReportUpdateData = /** @class */ (function () {
    function ReportUpdateData() {
    }
    return ReportUpdateData;
}());

var ModelStartData = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ModelStartData, _super);
    function ModelStartData() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ModelStartData;
}(BaseResult));

var Layout = /** @class */ (function () {
    function Layout() {
    }
    return Layout;
}());

var AuxiliarySupervisorComputer = /** @class */ (function () {
    function AuxiliarySupervisorComputer() {
    }
    return AuxiliarySupervisorComputer;
}());

var AuxiliarySupervisorParentTask = /** @class */ (function () {
    function AuxiliarySupervisorParentTask() {
    }
    return AuxiliarySupervisorParentTask;
}());

var AuxiliarySupervisorNotRanTask = /** @class */ (function () {
    function AuxiliarySupervisorNotRanTask() {
    }
    return AuxiliarySupervisorNotRanTask;
}());

var AuxiliarySupervisorProcessTask = /** @class */ (function () {
    function AuxiliarySupervisorProcessTask() {
    }
    return AuxiliarySupervisorProcessTask;
}());

var AuxiliarySupervisor = /** @class */ (function () {
    function AuxiliarySupervisor() {
    }
    return AuxiliarySupervisor;
}());

var Auxiliary = /** @class */ (function () {
    function Auxiliary() {
    }
    return Auxiliary;
}());

var TaskInfo = /** @class */ (function () {
    function TaskInfo() {
    }
    return TaskInfo;
}());

var Memory = /** @class */ (function () {
    function Memory() {
    }
    return Memory;
}());

var MemoryFilter = /** @class */ (function () {
    function MemoryFilter() {
    }
    return MemoryFilter;
}());

var Space = /** @class */ (function () {
    function Space() {
    }
    return Space;
}());

var SpaceAdd = /** @class */ (function () {
    function SpaceAdd() {
    }
    return SpaceAdd;
}());

var SpaceFilter = /** @class */ (function () {
    function SpaceFilter() {
    }
    return SpaceFilter;
}());

var SpaceRun = /** @class */ (function () {
    function SpaceRun() {
    }
    return SpaceRun;
}());

var DagRestart = /** @class */ (function () {
    function DagRestart() {
    }
    return DagRestart;
}());

var TagResult = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TagResult, _super);
    function TagResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return TagResult;
}(BaseResult));

var NamesResult = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](NamesResult, _super);
    function NamesResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return NamesResult;
}(BaseResult));



/***/ }),

/***/ "./src/app/paginator.ts":
/*!******************************!*\
  !*** ./src/app/paginator.ts ***!
  \******************************/
/*! exports provided: Paginator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Paginator", function() { return Paginator; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./models */ "./src/app/models.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./helpers */ "./src/app/helpers.ts");










var Paginator = /** @class */ (function () {
    function Paginator(service, location, filter_params, filter_key, enable_interval, init) {
        if (filter_params === void 0) { filter_params = null; }
        if (filter_key === void 0) { filter_key = null; }
        if (enable_interval === void 0) { enable_interval = true; }
        if (init === void 0) { init = true; }
        this.service = service;
        this.location = location;
        this.filter_params = filter_params;
        this.filter_key = filter_key;
        this.enable_interval = enable_interval;
        this.init = init;
        this.dataSource = new _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatTableDataSource"]();
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.data_updated = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.displayed_columns = [];
        this.default_page_size = 10;
        this.isLoading_results = false;
        this.id_column = 'id';
    }
    Paginator.prototype._ngOnInit = function () {
    };
    Paginator.prototype.get_filter = function (paginator, sort) {
        if (paginator === void 0) { paginator = null; }
        if (sort === void 0) { sort = null; }
        var _a;
        if (!paginator) {
            paginator = this.paginator;
        }
        if (!sort) {
            sort = this.sort;
        }
        var res = new _models__WEBPACK_IMPORTED_MODULE_5__["PaginatorFilter"]();
        res.page_number = paginator ? paginator.pageIndex : 0;
        res.page_size = paginator ?
            paginator.pageSize || this.default_page_size : 15;
        res.page_size = parseInt(res.page_size.toString());
        if (sort) {
            res.sort_column = sort.active ? sort.active : '';
            res.sort_descending = sort.direction ?
                sort.direction == 'desc' : true;
        }
        if (this.filter_key) {
            var final = (_a = {}, _a[this.filter_key] = res, _a);
            if (this.filter_params) {
                final = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, final, this.filter_params());
            }
            return final;
        }
        return res;
    };
    Paginator.prototype.ngOnInit = function () {
        var _this = this;
        if (!this.init) {
            return;
        }
        this._ngOnInit();
        // If the user changes the sort order, reset back to the first page.
        if (this.sort) {
            this.sort.sortChange.subscribe(function () {
                if (_this.paginator) {
                    _this.paginator.pageIndex = 0;
                }
            });
        }
        var m = Object(rxjs__WEBPACK_IMPORTED_MODULE_3__["merge"])(this.change);
        if (this.sort) {
            m = Object(rxjs__WEBPACK_IMPORTED_MODULE_3__["merge"])(m, this.sort.sortChange);
        }
        if (this.paginator) {
            m = Object(rxjs__WEBPACK_IMPORTED_MODULE_3__["merge"])(m, this.paginator.page);
        }
        m.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["startWith"])({}), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () {
            _this.isLoading_results = true;
            var filter = _this.get_filter();
            if (!filter) {
                return Object(rxjs__WEBPACK_IMPORTED_MODULE_3__["of"])(new _models__WEBPACK_IMPORTED_MODULE_5__["PaginatorRes"]());
            }
            if (_this.previous_filter) {
                var keys = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, Object.keys(_this.previous_filter), Object.keys(filter));
                for (var i in keys) {
                    var k = keys[i];
                    if (JSON.stringify(_this.previous_filter[k])
                        != JSON.stringify(filter[k])
                        && k != 'paginator') {
                        _this.paginator.pageIndex = 0;
                        if (filter.paginator) {
                            filter.paginator.page_number = 0;
                        }
                        else {
                            filter.page_number = 0;
                        }
                    }
                }
            }
            _this.previous_filter = filter;
            return _this.service.get_paginator(filter);
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (res) {
            // Flip flag to show that loading has finished.
            _this.isLoading_results = false;
            return res;
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(function () {
            _this.isLoading_results = false;
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_3__["of"])(new _models__WEBPACK_IMPORTED_MODULE_5__["PaginatorRes"]());
        })).subscribe(function (res) {
            if (!res || !res.data) {
                return;
            }
            _this.dataSource.data = _helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].update_object(_this.dataSource.data, res.data, [_this.id_column]);
            _this.total = res.total;
            _this.data_updated.emit(res);
        });
        if (this.enable_interval) {
            this.interval = setInterval(function () { return _this.change.emit('event'); }, 3000);
        }
    };
    Paginator.prototype.ngOnDestroy = function () {
        if (this.enable_interval) {
            clearInterval(this.interval);
        }
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatPaginator"]),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatPaginator"])
    ], Paginator.prototype, "paginator", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSort"]),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSort"])
    ], Paginator.prototype, "sort", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], Paginator.prototype, "default_page_size", void 0);
    return Paginator;
}());



/***/ }),

/***/ "./src/app/project/project-add-dialog.html":
/*!*************************************************!*\
  !*** ./src/app/project/project-add-dialog.html ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div mat-dialog-content>\n  <mat-form-field>\n    <mat-label>Name</mat-label>\n    <input matInput [(ngModel)]=\"data.name\">\n  </mat-form-field>\n</div>\n\n<div mat-dialog-content>\n  <mat-form-field style=\"width: 450px\">\n    <mat-label>Class names</mat-label>\n      <textarea\n              matInput\n              [(ngModel)]=\"data.class_names\"\n              style=\"height:120px\">\n\n      </textarea>\n  </mat-form-field>\n</div>\n\n<div mat-dialog-content>\n  <mat-form-field style=\"width: 450px\">\n    <mat-label>Sync folders</mat-label>\n      <textarea\n              matInput\n              [(ngModel)]=\"data.sync_folders\"\n              style=\"height:120px\">\n\n      </textarea>\n  </mat-form-field>\n</div>\n\n<div mat-dialog-content>\n  <mat-form-field style=\"width: 450px\">\n    <mat-label>Ignore folders</mat-label>\n      <textarea\n              matInput\n              [(ngModel)]=\"data.ignore_folders\"\n              style=\"height:120px\">\n\n      </textarea>\n  </mat-form-field>\n</div>\n\n<div mat-dialog-actions>\n  <button mat-button (click)=\"onNoClick()\">Cancel</button>\n  <button mat-button [mat-dialog-close]=\"data\" cdkFocusInitial>Ok</button>\n</div>"

/***/ }),

/***/ "./src/app/project/project-add-dialog.ts":
/*!***********************************************!*\
  !*** ./src/app/project/project-add-dialog.ts ***!
  \***********************************************/
/*! exports provided: ProjectAddDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProjectAddDialogComponent", function() { return ProjectAddDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");



var ProjectAddDialogComponent = /** @class */ (function () {
    function ProjectAddDialogComponent(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
        if (!data.class_names) {
            data.class_names = 'default: [\n\n]';
        }
        if (!data.sync_folders) {
            data.sync_folders = '[\ndata,\nmodels\n]';
        }
        if (!data.ignore_folders) {
            data.ignore_folders = '[\n\n]';
        }
    }
    ProjectAddDialogComponent.prototype.onNoClick = function () {
        this.dialogRef.close();
    };
    ProjectAddDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'project-add-dialog',
            template: __webpack_require__(/*! ./project-add-dialog.html */ "./src/app/project/project-add-dialog.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"], Object])
    ], ProjectAddDialogComponent);
    return ProjectAddDialogComponent;
}());



/***/ }),

/***/ "./src/app/project/project.component.css":
/*!***********************************************!*\
  !*** ./src/app/project/project.component.css ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 80%;\n  min-width: 1120px;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\ntd{\n  text-align: center;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvcHJvamVjdC9wcm9qZWN0LmNvbXBvbmVudC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxVQUFVO0VBQ1YsaUJBQWlCO0FBQ25COztBQUVBO0VBQ0UsZUFBZTtFQUNmLFdBQVc7QUFDYjs7QUFFQTtFQUNFLGtCQUFrQjtBQUNwQjs7QUFFQTtFQUNFLFlBQVk7RUFDWixzQkFBc0I7RUFDdEIsa0JBQWtCO0VBQ2xCLDRCQUE0QjtBQUM5Qjs7QUFFQTtFQUNFLDZCQUE2QjtBQUMvQjs7QUFFQTtFQUNFLGVBQWU7QUFDakIiLCJmaWxlIjoic3JjL2FwcC9wcm9qZWN0L3Byb2plY3QuY29tcG9uZW50LmNzcyIsInNvdXJjZXNDb250ZW50IjpbInRhYmxlIHtcbiAgd2lkdGg6IDgwJTtcbiAgbWluLXdpZHRoOiAxMTIwcHg7XG59XG5cbi5tYXQtZm9ybS1maWVsZCB7XG4gIGZvbnQtc2l6ZTogMTRweDtcbiAgd2lkdGg6IDEwMCU7XG59XG5cbnRke1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG59XG5cbjo6bmctZGVlcCAubWF0LXNvcnQtaGVhZGVyLWNvbnRhaW5lcntcbiAgZGlzcGxheTpmbGV4O1xuICBqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyO1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gIG1hcmdpbi1sZWZ0OiAxMnB4ICFpbXBvcnRhbnQ7XG59XG5cbi5tYXQtaGVhZGVyLWNlbGx7XG4gIHRleHQtYWxpZ246IGNlbnRlciAhaW1wb3J0YW50O1xufVxuXG5tYXQtaWNvbntcbiAgY3Vyc29yOiBwb2ludGVyO1xufVxuXG4iXX0= */"

/***/ }),

/***/ "./src/app/project/project.component.html":
/*!************************************************!*\
  !*** ./src/app/project/project.component.html ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<button mat-raised-button\n        style=\"margin-top: 15px\"\n        (click)=\"add()\">\n    Add\n</button>\n\n<button mat-raised-button\n        style=\"margin-top: 15px\"\n        [disabled]=\"selected==null\"\n        (click)=\"edit()\">\n    Edit\n</button>\n\n<mat-form-field>\n    <input matInput (keyup)=\"filter_name($event.target.value)\"\n           placeholder=\"Name\">\n</mat-form-field>\n\n<div class=\"mat-elevation-z8\">\n    <table mat-table [dataSource]=\"dataSource\" matSort>\n\n        <ng-container matColumnDef=\"name\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Name\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <a class=\"col-1-4\" routerLink=\"/dags\"\n                   [queryParams]=\"{ project: element.id }\">\n                    {{element.name}}\n                </a>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"dag_count\">\n            <th mat-header-cell *matHeaderCellDef>\n                Dags\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.dag_count}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"last_activity\">\n            <th mat-header-cell *matHeaderCellDef>\n                Last activity\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.last_activity| date:'medium'}}\n            </td>\n        </ng-container>\n\n\n        <ng-container matColumnDef=\"img_size\">\n            <th mat-header-cell *matHeaderCellDef>\n                Image size\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <mat-icon svgIcon=\"remove\"\n                          matTooltip=\"Remove\"\n                          (click)=\"remove_imgs(element)\">\n\n                </mat-icon>\n\n                {{size(element.img_size)}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"file_size\">\n            <th mat-header-cell *matHeaderCellDef>\n                File size\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <mat-icon svgIcon=\"remove\" matTooltip=\"Remove\"\n                          (click)=\"remove_files(element)\">\n\n                </mat-icon>\n\n                {{size(element.file_size)}}\n\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"stop_all_dags\">\n            <th mat-header-cell *matHeaderCellDef\n                style=\"text-align: center;\">\n                Stop all DAGs\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\"\n                style=\"min-width: 120px\">\n                <mat-icon svgIcon=\"stop\" matTooltip=\"Stop all DAGs\"\n                          (click)=\"stop_all_dags(element)\"></mat-icon>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"remove_all_dags\">\n            <th mat-header-cell *matHeaderCellDef\n                style=\"text-align: center;\">\n                Remove all DAGs\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\"\n                style=\"min-width: 120px\">\n                <mat-icon svgIcon=\"remove\" matTooltip=\"Remove all DAGs\"\n                          (click)=\"remove_all_dags(element)\"></mat-icon>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"remove\">\n            <th mat-header-cell *matHeaderCellDef\n                style=\"text-align: center;\">\n                Remove project\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\"\n                style=\"min-width: 120px\">\n                <mat-icon svgIcon=\"remove\" matTooltip=\"Remove\"\n                          (click)=\"remove(element)\"></mat-icon>\n            </td>\n        </ng-container>\n\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row\n            *matRowDef=\"let row; columns: displayed_columns;\"\n            (click)=\"selected=row\"\n            [style.background]=\"selected==row ? 'lightblue' : ''\"\n        ></tr>\n    </table>\n\n    <mat-paginator [pageSizeOptions]=\"[default_page_size, 30, 50, 100]\"\n                   [length]=\"total\"\n                   [pageSize]=\"default_page_size\">\n    </mat-paginator>\n</div>\n"

/***/ }),

/***/ "./src/app/project/project.component.ts":
/*!**********************************************!*\
  !*** ./src/app/project/project.component.ts ***!
  \**********************************************/
/*! exports provided: ProjectComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProjectComponent", function() { return ProjectComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/platform-browser */ "./node_modules/@angular/platform-browser/fesm5/platform-browser.js");
/* harmony import */ var _dialog_dialog_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../dialog/dialog.component */ "./src/app/dialog/dialog.component.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../helpers */ "./src/app/helpers.ts");
/* harmony import */ var _project_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./project.service */ "./src/app/project/project.service.ts");
/* harmony import */ var _project_add_dialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./project-add-dialog */ "./src/app/project/project-add-dialog.ts");











var ProjectComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ProjectComponent, _super);
    function ProjectComponent(service, location, iconRegistry, sanitizer, dialog) {
        var _this = _super.call(this, service, location) || this;
        _this.service = service;
        _this.location = location;
        _this.dialog = dialog;
        _this.displayed_columns = [
            'name',
            'dag_count',
            'last_activity',
            'img_size',
            'file_size',
            'stop_all_dags',
            'remove_all_dags',
            'remove'
        ];
        iconRegistry.addSvgIcon('remove', sanitizer.bypassSecurityTrustResourceUrl('assets/img/trash.svg'));
        iconRegistry.addSvgIcon('stop', sanitizer.bypassSecurityTrustResourceUrl('assets/img/stop.svg'));
        return _this;
    }
    ProjectComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_3__["ProjectFilter"]();
        res.paginator = _super.prototype.get_filter.call(this);
        res.name = this.name;
        return res;
    };
    ProjectComponent.prototype.filter_name = function (name) {
        this.name = name;
        this.change.emit();
    };
    ProjectComponent.prototype.remove = function (element) {
        var _this = this;
        var dialogRef = this.dialog.open(_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_7__["DialogComponent"], {
            width: '550px', height: '200px',
            data: {
                'message': 'The all content will be deleted. ' +
                    'Do you want to continue?'
            }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.remove(element.id).subscribe(function (data) {
                    _this.change.emit();
                });
            }
        });
    };
    ProjectComponent.prototype.size = function (s) {
        return _helpers__WEBPACK_IMPORTED_MODULE_8__["Helpers"].size(s);
    };
    ProjectComponent.prototype.remove_imgs = function (element) {
        this.service.remove_imgs(element.id).subscribe(function (data) {
            element.img_size = 0;
        });
    };
    ProjectComponent.prototype.remove_files = function (element) {
        this.service.remove_files(element.id).subscribe(function (data) {
            element.file_size = 0;
        });
    };
    ProjectComponent.prototype.stop_all_dags = function (element) {
        var _this = this;
        var dialogRef = this.dialog.open(_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_7__["DialogComponent"], {
            width: '550px', height: '200px',
            data: {
                'message': 'The all content will be stopped. ' +
                    'Do you want to continue?'
            }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.stop_all_dags(element.id).subscribe(function (data) {
                });
            }
        });
    };
    ProjectComponent.prototype.remove_all_dags = function (element) {
        var _this = this;
        var dialogRef = this.dialog.open(_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_7__["DialogComponent"], {
            width: '550px', height: '200px',
            data: {
                'message': 'The all content will be removed. ' +
                    'Do you want to continue?'
            }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.remove_all_dags(element.id).subscribe(function (data) {
                });
            }
        });
    };
    ProjectComponent.prototype.add = function () {
        var _this = this;
        var dialogRef = this.dialog.open(_project_add_dialog__WEBPACK_IMPORTED_MODULE_10__["ProjectAddDialogComponent"], {
            width: '600px', height: '700px',
            data: { 'name': '' }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.add(result).subscribe(function (_) {
                    _this.change.emit();
                });
            }
        });
    };
    ProjectComponent.prototype.edit = function () {
        var _this = this;
        var dialogRef = this.dialog.open(_project_add_dialog__WEBPACK_IMPORTED_MODULE_10__["ProjectAddDialogComponent"], {
            width: '600px', height: '700px',
            data: _helpers__WEBPACK_IMPORTED_MODULE_8__["Helpers"].clone(this.selected)
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.service.edit(result).subscribe(function (_) {
                    _this.change.emit();
                });
            }
        });
    };
    ProjectComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-project',
            template: __webpack_require__(/*! ./project.component.html */ "./src/app/project/project.component.html"),
            styles: [__webpack_require__(/*! ./project.component.css */ "./src/app/project/project.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_project_service__WEBPACK_IMPORTED_MODULE_9__["ProjectService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_4__["Location"],
            _angular_material__WEBPACK_IMPORTED_MODULE_5__["MatIconRegistry"],
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_6__["DomSanitizer"],
            _angular_material__WEBPACK_IMPORTED_MODULE_5__["MatDialog"]])
    ], ProjectComponent);
    return ProjectComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_2__["Paginator"]));



/***/ }),

/***/ "./src/app/project/project.service.ts":
/*!********************************************!*\
  !*** ./src/app/project/project.service.ts ***!
  \********************************************/
/*! exports provided: ProjectService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProjectService", function() { return ProjectService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");






var ProjectService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ProjectService, _super);
    function ProjectService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'projects';
        _this.single_part = 'project';
        return _this;
    }
    ProjectService.prototype.remove = function (id) {
        var message = this.constructor.name + ".remove";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/remove';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService.prototype.remove_imgs = function (id) {
        var message = this.constructor.name + ".remove_imgs";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + 'remove_imgs';
        return this.http.post(url, { 'project': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService.prototype.remove_files = function (id) {
        var message = this.constructor.name + ".remove_files";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + 'remove_files';
        return this.http.post(url, { 'project': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService.prototype.add = function (data) {
        var message = this.constructor.name + ".add";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/add';
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService.prototype.edit = function (data) {
        var message = this.constructor.name + ".edit";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/edit';
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService.prototype.stop_all_dags = function (id) {
        var message = this.constructor.name + ".stop_all_dags";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/stop_all_dags';
        return this.http.post(url, { 'project': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService.prototype.remove_all_dags = function (id) {
        var message = this.constructor.name + ".remove_all_dags";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/remove_all_dags';
        return this.http.post(url, { 'project': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ProjectService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], ProjectService);
    return ProjectService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/report/layouts/layout-add-dialog.html":
/*!*******************************************************!*\
  !*** ./src/app/report/layouts/layout-add-dialog.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div mat-dialog-content>\n  <mat-form-field>\n    <mat-label>Name</mat-label>\n    <input matInput [(ngModel)]=\"data.name\">\n  </mat-form-field>\n</div>\n\n<div mat-dialog-actions>\n  <button mat-button (click)=\"onNoClick()\">Cancel</button>\n  <button mat-button [mat-dialog-close]=\"data\" cdkFocusInitial>Ok</button>\n</div>"

/***/ }),

/***/ "./src/app/report/layouts/layout-add-dialog.ts":
/*!*****************************************************!*\
  !*** ./src/app/report/layouts/layout-add-dialog.ts ***!
  \*****************************************************/
/*! exports provided: LayoutAddDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LayoutAddDialogComponent", function() { return LayoutAddDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");



var LayoutAddDialogComponent = /** @class */ (function () {
    function LayoutAddDialogComponent(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
    }
    LayoutAddDialogComponent.prototype.onNoClick = function () {
        this.dialogRef.close();
    };
    LayoutAddDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'layout-add-dialog',
            template: __webpack_require__(/*! ./layout-add-dialog.html */ "./src/app/report/layouts/layout-add-dialog.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"], Object])
    ], LayoutAddDialogComponent);
    return LayoutAddDialogComponent;
}());



/***/ }),

/***/ "./src/app/report/report-detail/report-update-dialog.component.html":
/*!**************************************************************************!*\
  !*** ./src/app/report/report-detail/report-update-dialog.component.html ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<mat-form-field style=\"width: 150px\">\n    <mat-label>Layout</mat-label>\n    <mat-select\n            (ngModelChange)=\"data.layout=$event;\"\n            [(ngModel)]=\"data.layout\">\n        <mat-option *ngFor=\"let layout of data.layouts\" [value]=\"layout\">\n            {{layout}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<div mat-dialog-actions>\n  <button mat-button (click)=\"on_no_click()\">Cancel</button>\n  <button mat-button [mat-dialog-close]=\"data\" cdkFocusInitial>Ok</button>\n</div>"

/***/ }),

/***/ "./src/app/report/report-detail/report-update-dialog.component.ts":
/*!************************************************************************!*\
  !*** ./src/app/report/report-detail/report-update-dialog.component.ts ***!
  \************************************************************************/
/*! exports provided: ReportUpdateDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportUpdateDialogComponent", function() { return ReportUpdateDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");




var ReportUpdateDialogComponent = /** @class */ (function () {
    function ReportUpdateDialogComponent(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
        if (data.layouts.length > 0) {
            data.layout = data.layouts[0];
        }
    }
    ReportUpdateDialogComponent.prototype.on_no_click = function () {
        this.dialogRef.close();
    };
    ReportUpdateDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'report-update-dialog',
            template: __webpack_require__(/*! ./report-update-dialog.component.html */ "./src/app/report/report-detail/report-update-dialog.component.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"],
            _models__WEBPACK_IMPORTED_MODULE_3__["ReportUpdateData"]])
    ], ReportUpdateDialogComponent);
    return ReportUpdateDialogComponent;
}());



/***/ }),

/***/ "./src/app/report/report.service.ts":
/*!******************************************!*\
  !*** ./src/app/report/report.service.ts ***!
  \******************************************/
/*! exports provided: ReportService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportService", function() { return ReportService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");






var ReportService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ReportService, _super);
    function ReportService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'reports';
        _this.single_part = 'report';
        _this.data_updated = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        return _this;
    }
    ReportService.prototype.add_start = function () {
        var message = this.constructor.name + ".add_start";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/add_start';
        return this.http.post(url, {}).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ReportService.prototype.add_end = function (data) {
        var message = this.constructor.name + ".add_end";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT + this.single_part + '/add_end';
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["BaseResult"]())));
    };
    ReportService.prototype.update_layout_start = function (id) {
        var message = this.constructor.name + ".update_layout_start";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT +
            this.single_part +
            '/update_layout_start';
        var data = { 'id': id };
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["ReportUpdateData"]())));
    };
    ReportService.prototype.update_layout_end = function (id, layout) {
        var message = this.constructor.name + ".update_layout_end";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_4__["AppSettings"].API_ENDPOINT +
            this.single_part +
            '/update_layout_end';
        var data = { 'id': id, 'layout': layout };
        return this.http.post(url, data).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_3__["Report"]())));
    };
    ReportService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], ReportService);
    return ReportService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/report/reports/report-add-dialog.html":
/*!*******************************************************!*\
  !*** ./src/app/report/reports/report-add-dialog.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div mat-dialog-content>\n  <mat-form-field>\n    <mat-label>Name</mat-label>\n    <input matInput [(ngModel)]=\"data.name\">\n  </mat-form-field>\n</div>\n\n<mat-form-field style=\"width: 150px\">\n    <mat-label>Project</mat-label>\n    <mat-select\n            [(ngModel)]=\"data.project\">\n        <mat-option\n                *ngFor=\"let project of data.projects\"\n                [value]=\"project.id\">\n            {{project.name}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<mat-form-field style=\"width: 150px\">\n    <mat-label>Layout</mat-label>\n    <mat-select\n            [(ngModel)]=\"data.layout\">\n        <mat-option\n                *ngFor=\"let layout of data.layouts\"\n                [value]=\"layout.name\">\n            {{layout.name}}\n        </mat-option>\n    </mat-select>\n</mat-form-field>\n\n<div mat-dialog-actions>\n  <button mat-button (click)=\"onNoClick()\">Cancel</button>\n  <button mat-button [mat-dialog-close]=\"data\" cdkFocusInitial>Ok</button>\n</div>"

/***/ }),

/***/ "./src/app/report/reports/report-add-dialog.ts":
/*!*****************************************************!*\
  !*** ./src/app/report/reports/report-add-dialog.ts ***!
  \*****************************************************/
/*! exports provided: ReportAddDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportAddDialogComponent", function() { return ReportAddDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");



var ReportAddDialogComponent = /** @class */ (function () {
    function ReportAddDialogComponent(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
        if (data.projects.length > 0) {
            data.project = data.projects[0].id;
        }
        if (data.layouts.length > 0) {
            data.layout = data.layouts[0].name;
        }
    }
    ReportAddDialogComponent.prototype.onNoClick = function () {
        this.dialogRef.close();
    };
    ReportAddDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'report-add-dialog',
            template: __webpack_require__(/*! ./report-add-dialog.html */ "./src/app/report/reports/report-add-dialog.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](1, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialogRef"], Object])
    ], ReportAddDialogComponent);
    return ReportAddDialogComponent;
}());



/***/ }),

/***/ "./src/app/report/reports/reports.component.css":
/*!******************************************************!*\
  !*** ./src/app/report/reports/reports.component.css ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 50%;\n  min-width: 800px;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\ntd{\n  text-align: center;\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvcmVwb3J0L3JlcG9ydHMvcmVwb3J0cy5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsVUFBVTtFQUNWLGdCQUFnQjtBQUNsQjs7QUFFQTtFQUNFLDZCQUE2QjtBQUMvQjs7QUFFQTtFQUNFLGtCQUFrQjtBQUNwQjs7QUFFQTtFQUNFLGVBQWU7QUFDakI7O0FBRUE7RUFDRSxZQUFZO0VBQ1osc0JBQXNCO0VBQ3RCLGtCQUFrQjtFQUNsQiw0QkFBNEI7QUFDOUIiLCJmaWxlIjoic3JjL2FwcC9yZXBvcnQvcmVwb3J0cy9yZXBvcnRzLmNvbXBvbmVudC5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyJ0YWJsZSB7XG4gIHdpZHRoOiA1MCU7XG4gIG1pbi13aWR0aDogODAwcHg7XG59XG5cbi5tYXQtaGVhZGVyLWNlbGx7XG4gIHRleHQtYWxpZ246IGNlbnRlciAhaW1wb3J0YW50O1xufVxuXG50ZHtcbiAgdGV4dC1hbGlnbjogY2VudGVyO1xufVxuXG5tYXQtaWNvbntcbiAgY3Vyc29yOiBwb2ludGVyO1xufVxuXG46Om5nLWRlZXAgLm1hdC1zb3J0LWhlYWRlci1jb250YWluZXJ7XG4gIGRpc3BsYXk6ZmxleDtcbiAganVzdGlmeS1jb250ZW50OmNlbnRlcjtcbiAgdGV4dC1hbGlnbjogY2VudGVyO1xuICBtYXJnaW4tbGVmdDogMTJweCAhaW1wb3J0YW50O1xufVxuIl19 */"

/***/ }),

/***/ "./src/app/report/reports/reports.component.html":
/*!*******************************************************!*\
  !*** ./src/app/report/reports/reports.component.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"mat-elevation-z8\">\n    <button mat-raised-button style=\"margin-top: 15px\"\n            (click)=\"add()\">\n        Add\n    </button>\n\n    <table mat-table [dataSource]=\"dataSource\" matSort>\n\n        <ng-container matColumnDef=\"id\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 10%\"> Id\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.id}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"name\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 20%\"> Name\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                <a class=\"col-1-4\"\n                   routerLink=\"/reports/report-detail/{{element.id}}\">\n                    {{element.name}}\n                </a>\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"time\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 15%\"> Time\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.time| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n\n        <ng-container matColumnDef=\"tasks\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 10%\"> Tasks\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.tasks}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"tasks_not_finished\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 10%\"> Tasks not finished\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.tasks_not_finished}}\n            </td>\n        </ng-container>\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row *matRowDef=\"let row; columns: displayed_columns;\"></tr>\n    </table>\n\n    <mat-paginator [pageSizeOptions]=\"[default_page_size, 30, 100]\" [length]=\"total\"\n                   [pageSize]=\"default_page_size\"></mat-paginator>\n\n</div>\n\n\n"

/***/ }),

/***/ "./src/app/report/reports/reports.component.ts":
/*!*****************************************************!*\
  !*** ./src/app/report/reports/reports.component.ts ***!
  \*****************************************************/
/*! exports provided: ReportsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReportsComponent", function() { return ReportsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");
/* harmony import */ var _report_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../report.service */ "./src/app/report/report.service.ts");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _report_add_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./report-add-dialog */ "./src/app/report/reports/report-add-dialog.ts");








var ReportsComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ReportsComponent, _super);
    function ReportsComponent(service, location, dialog) {
        var _this = _super.call(this, service, location) || this;
        _this.service = service;
        _this.location = location;
        _this.dialog = dialog;
        _this.displayed_columns = [
            "id",
            "name",
            "time",
            "tasks",
            "tasks_not_finished"
        ];
        return _this;
    }
    ReportsComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_4__["ReportsFilter"]();
        res.paginator = _super.prototype.get_filter.call(this);
        res.task = this.task;
        res.dag = this.dag;
        return res;
    };
    ReportsComponent.prototype.add = function () {
        var _this = this;
        this.service.add_start().subscribe(function (res) {
            var dialogRef = _this.dialog.open(_report_add_dialog__WEBPACK_IMPORTED_MODULE_7__["ReportAddDialogComponent"], {
                width: '600px', height: '300px',
                data: res
            });
            dialogRef.afterClosed().subscribe(function (result) {
                if (result) {
                    _this.service.add_end(result).subscribe(function (_) {
                        _this.change.emit();
                    });
                }
            });
        });
    };
    ReportsComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-reports',
            template: __webpack_require__(/*! ./reports.component.html */ "./src/app/report/reports/reports.component.html"),
            styles: [__webpack_require__(/*! ./reports.component.css */ "./src/app/report/reports/reports.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_report_service__WEBPACK_IMPORTED_MODULE_5__["ReportService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_3__["Location"],
            _angular_material__WEBPACK_IMPORTED_MODULE_6__["MatDialog"]])
    ], ReportsComponent);
    return ReportsComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_2__["Paginator"]));



/***/ }),

/***/ "./src/app/shared.module.ts":
/*!**********************************!*\
  !*** ./src/app/shared.module.ts ***!
  \**********************************/
/*! exports provided: SharedModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SharedModule", function() { return SharedModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm5/http.js");
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/paginator */ "./node_modules/@angular/material/esm5/paginator.es5.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/cdk/tree */ "./node_modules/@angular/cdk/esm5/tree.es5.js");
/* harmony import */ var _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/cdk/a11y */ "./node_modules/@angular/cdk/esm5/a11y.es5.js");
/* harmony import */ var _angular_cdk_stepper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/cdk/stepper */ "./node_modules/@angular/cdk/esm5/stepper.es5.js");
/* harmony import */ var _angular_cdk_table__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/cdk/table */ "./node_modules/@angular/cdk/esm5/table.es5.js");
/* harmony import */ var _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/cdk/drag-drop */ "./node_modules/@angular/cdk/esm5/drag-drop.es5.js");
/* harmony import */ var _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/cdk/portal */ "./node_modules/@angular/cdk/esm5/portal.es5.js");
/* harmony import */ var _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/cdk/scrolling */ "./node_modules/@angular/cdk/esm5/scrolling.es5.js");
/* harmony import */ var _log_log_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./log/log.component */ "./src/app/log/log.component.ts");
/* harmony import */ var _dag_dags_dags_component__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./dag/dags/dags.component */ "./src/app/dag/dags/dags.component.ts");
/* harmony import */ var _task_tasks_tasks_component__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./task/tasks/tasks.component */ "./src/app/task/tasks/tasks.component.ts");
/* harmony import */ var _report_reports_reports_component__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./report/reports/reports.component */ "./src/app/report/reports/reports.component.ts");
/* harmony import */ var _dialog_dialog_component__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./dialog/dialog.component */ "./src/app/dialog/dialog.component.ts");
/* harmony import */ var _task_task_table_task_table_component__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./task/task-table/task-table.component */ "./src/app/task/task-table/task-table.component.ts");






















var SharedModule = /** @class */ (function () {
    function SharedModule() {
    }
    SharedModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatIconModule"],
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClientModule"],
                _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__["MatPaginatorModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterModule"],
                _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_8__["CdkTreeModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTreeModule"],
                _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_9__["A11yModule"],
                _angular_cdk_stepper__WEBPACK_IMPORTED_MODULE_10__["CdkStepperModule"],
                _angular_cdk_table__WEBPACK_IMPORTED_MODULE_11__["CdkTableModule"],
                _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_8__["CdkTreeModule"],
                _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_12__["DragDropModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatAutocompleteModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatBadgeModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatBottomSheetModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatButtonModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatButtonToggleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatCardModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatCheckboxModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatChipsModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatStepperModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDatepickerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDialogModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDividerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatExpansionModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatGridListModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatIconModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatInputModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatListModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatMenuModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatNativeDateModule"],
                _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__["MatPaginatorModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatProgressBarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatProgressSpinnerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatRadioModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatRippleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSelectModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSidenavModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSliderModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSlideToggleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSnackBarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSortModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTableModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTabsModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatToolbarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTooltipModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTreeModule"],
                _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_13__["PortalModule"],
                _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_14__["ScrollingModule"]
            ],
            declarations: [
                _log_log_component__WEBPACK_IMPORTED_MODULE_15__["LogComponent"],
                _dag_dags_dags_component__WEBPACK_IMPORTED_MODULE_16__["DagsComponent"],
                _task_tasks_tasks_component__WEBPACK_IMPORTED_MODULE_17__["TasksComponent"],
                _task_task_table_task_table_component__WEBPACK_IMPORTED_MODULE_20__["TaskTableComponent"],
                _report_reports_reports_component__WEBPACK_IMPORTED_MODULE_18__["ReportsComponent"],
                _dialog_dialog_component__WEBPACK_IMPORTED_MODULE_19__["DialogComponent"]
            ],
            exports: [
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatIconModule"],
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClientModule"],
                _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__["MatPaginatorModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterModule"],
                _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_8__["CdkTreeModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTreeModule"],
                _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_9__["A11yModule"],
                _angular_cdk_stepper__WEBPACK_IMPORTED_MODULE_10__["CdkStepperModule"],
                _angular_cdk_table__WEBPACK_IMPORTED_MODULE_11__["CdkTableModule"],
                _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_8__["CdkTreeModule"],
                _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_12__["DragDropModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatAutocompleteModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatBadgeModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatBottomSheetModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatButtonModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatButtonToggleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatCardModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatCheckboxModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatChipsModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatStepperModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDatepickerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDialogModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatDividerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatExpansionModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatGridListModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatIconModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatInputModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatListModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatMenuModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatNativeDateModule"],
                _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__["MatPaginatorModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatProgressBarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatProgressSpinnerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatRadioModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatRippleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSelectModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSidenavModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSliderModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSlideToggleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSnackBarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatSortModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTableModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTabsModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatToolbarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTooltipModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_7__["MatTreeModule"],
                _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_13__["PortalModule"],
                _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_14__["ScrollingModule"],
                _log_log_component__WEBPACK_IMPORTED_MODULE_15__["LogComponent"],
                _dag_dags_dags_component__WEBPACK_IMPORTED_MODULE_16__["DagsComponent"],
                _task_tasks_tasks_component__WEBPACK_IMPORTED_MODULE_17__["TasksComponent"],
                _task_task_table_task_table_component__WEBPACK_IMPORTED_MODULE_20__["TaskTableComponent"],
                _report_reports_reports_component__WEBPACK_IMPORTED_MODULE_18__["ReportsComponent"],
                _dialog_dialog_component__WEBPACK_IMPORTED_MODULE_19__["DialogComponent"]
            ],
            entryComponents: [_dialog_dialog_component__WEBPACK_IMPORTED_MODULE_19__["DialogComponent"]],
        })
    ], SharedModule);
    return SharedModule;
}());



/***/ }),

/***/ "./src/app/task/task-table/task-info-dialog.component.html":
/*!*****************************************************************!*\
  !*** ./src/app/task/task-table/task-info-dialog.component.html ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div>\n    Pid: {{data.pid}}\n</div>\n\n<div>\n    Worker index: {{data.worker_index}}\n</div>\n\n<div>\n    GPU assigned: {{data.gpu_assigned}}\n</div>\n\n<div>\n    Celery id: {{data.celery_id}}\n</div>\n\n\n<div>\n    Additional info:\n\n    <div style=\"padding: 10px; background: lightskyblue; border: 1px\">\n        <pre>{{data.additional_info}}</pre>\n    </div>\n\n\n</div>\n\n<div>\n    Result:\n\n    <div style=\"padding: 10px; background: lightskyblue; border: 1px\">\n        <pre>{{data.result}}</pre>\n    </div>\n\n\n</div>"

/***/ }),

/***/ "./src/app/task/task-table/task-info-dialog.component.ts":
/*!***************************************************************!*\
  !*** ./src/app/task/task-table/task-info-dialog.component.ts ***!
  \***************************************************************/
/*! exports provided: TaskInfoDialogComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskInfoDialogComponent", function() { return TaskInfoDialogComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _task_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../task.service */ "./src/app/task/task.service.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");





var TaskInfoDialogComponent = /** @class */ (function () {
    function TaskInfoDialogComponent(data, service) {
        var _this = this;
        this.data = data;
        this.service = service;
        this.service.info(data.id).subscribe(function (res) {
            _this.data = res;
        });
    }
    TaskInfoDialogComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'task-info-dialog.component.css',
            template: __webpack_require__(/*! ./task-info-dialog.component.html */ "./src/app/task/task-table/task-info-dialog.component.html"),
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__param"](0, Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MAT_DIALOG_DATA"])),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_models__WEBPACK_IMPORTED_MODULE_4__["TaskInfo"],
            _task_service__WEBPACK_IMPORTED_MODULE_3__["TaskService"]])
    ], TaskInfoDialogComponent);
    return TaskInfoDialogComponent;
}());



/***/ }),

/***/ "./src/app/task/task-table/task-table.component.css":
/*!**********************************************************!*\
  !*** ./src/app/task/task-table/task-table.component.css ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 100%;\n  min-width: 1580px;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\ntd{\n  text-align: center;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n.checkbox-section {\n  display: flex;\n  align-content: center;\n  align-items: center;\n  height: 60px;\n}\n\n.checkbox-margin {\n  margin: 0 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvdGFzay90YXNrLXRhYmxlL3Rhc2stdGFibGUuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLFdBQVc7RUFDWCxpQkFBaUI7QUFDbkI7O0FBRUE7RUFDRSxlQUFlO0VBQ2YsV0FBVztBQUNiOztBQUVBO0VBQ0Usa0JBQWtCO0FBQ3BCOztBQUVBO0VBQ0UsWUFBWTtFQUNaLHNCQUFzQjtFQUN0QixrQkFBa0I7RUFDbEIsNEJBQTRCO0FBQzlCOztBQUVBO0VBQ0UsNkJBQTZCO0FBQy9COztBQUVBO0VBQ0UsZUFBZTtBQUNqQjs7QUFFQTtFQUNFLGFBQWE7RUFDYixxQkFBcUI7RUFDckIsbUJBQW1CO0VBQ25CLFlBQVk7QUFDZDs7QUFFQTtFQUNFLGNBQWM7QUFDaEIiLCJmaWxlIjoic3JjL2FwcC90YXNrL3Rhc2stdGFibGUvdGFzay10YWJsZS5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsidGFibGUge1xuICB3aWR0aDogMTAwJTtcbiAgbWluLXdpZHRoOiAxNTgwcHg7XG59XG5cbi5tYXQtZm9ybS1maWVsZCB7XG4gIGZvbnQtc2l6ZTogMTRweDtcbiAgd2lkdGg6IDEwMCU7XG59XG5cbnRke1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG59XG5cbjo6bmctZGVlcCAubWF0LXNvcnQtaGVhZGVyLWNvbnRhaW5lcntcbiAgZGlzcGxheTpmbGV4O1xuICBqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyO1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gIG1hcmdpbi1sZWZ0OiAxMnB4ICFpbXBvcnRhbnQ7XG59XG5cbi5tYXQtaGVhZGVyLWNlbGx7XG4gIHRleHQtYWxpZ246IGNlbnRlciAhaW1wb3J0YW50O1xufVxuXG5tYXQtaWNvbntcbiAgY3Vyc29yOiBwb2ludGVyO1xufVxuXG4uY2hlY2tib3gtc2VjdGlvbiB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGFsaWduLWNvbnRlbnQ6IGNlbnRlcjtcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgaGVpZ2h0OiA2MHB4O1xufVxuXG4uY2hlY2tib3gtbWFyZ2luIHtcbiAgbWFyZ2luOiAwIDEwcHg7XG59Il19 */"

/***/ }),

/***/ "./src/app/task/task-table/task-table.component.html":
/*!***********************************************************!*\
  !*** ./src/app/task/task-table/task-table.component.html ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"mat-elevation-z8\">\n    <table mat-table [dataSource]=\"paginator.dataSource\" matSort>\n\n        <ng-container matColumnDef=\"project\">\n            <th mat-header-cell\n                *matHeaderCellDef\n                mat-sort-header\n                style=\"width: 3%\">\n                Project\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.dag_rel.project.name}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"id\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"width: 3%\"> Id\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.id}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"name\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header\n                style=\"min-width: 100px\"> Name\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                <a class=\"col-1-4\"\n                   routerLink=\"/tasks/task-detail/{{element.id}}/logs\">\n                    {{element.name}}\n                </a>\n\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"created\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Created\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.dag_rel.created| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"started\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Started\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.started| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"last_activity\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Last activity\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.last_activity| date:\"MM.dd H:mm:ss\"}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"duration\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Duration\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.duration}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"status\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Status\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\"\n                [style.color]=\"status_color(element.status)\">\n                {{element.status}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"executor\">\n            <th mat-header-cell *matHeaderCellDef mat-sort-header>\n                Executor\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.executor}}\n            </td>\n        </ng-container>\n\n\n        <ng-container matColumnDef=\"dag\">\n            <th mat-header-cell *matHeaderCellDef>\n                Dag\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <a class=\"col-1-4\"\n                   routerLink=\"/dags/dag-detail/{{element.dag_rel.id}}/tasks\">\n                    {{element.dag_rel.name}}({{element.dag_rel.id}})\n                </a>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"computer\">\n            <th mat-header-cell *matHeaderCellDef>\n                Computer/assigned\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.computer}}/{{element.computer_assigned}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"requirements\">\n            <th mat-header-cell *matHeaderCellDef style=\"width: 100px\">\n                Requirements\n            </th>\n            <td mat-cell *matCellDef=\"let element\">\n                <svg height=\"40\" width=\"100px\" style=\"display: block;\">\n                    <g matTooltip=\"gpu\" transform=\"translate(20, 20)\">\n\n                        <text fill=\"black\" text-anchor=\"middle\"\n                              vertical-align=\"middle\" font-size=\"10\"\n                              y=\"3\">{{element.gpu > 0 ? element.gpu : ''}}\n                        </text>\n\n                        <circle [attr.stroke-width]=\"element.gpu>0?2:1\"\n                                [attr.stroke]=\n                                        \"element.gpu>0?'green':'gainsboro'\"\n                                fill-opacity=\"0\" r=\"12.5\">\n                        </circle>\n                    </g>\n\n                    <g matTooltip=\"cpu\" transform=\"translate(50, 20)\">\n\n                        <text fill=\"black\" text-anchor=\"middle\"\n                              vertical-align=\"middle\" font-size=\"10\"\n                              y=\"3\">{{element.cpu > 1 ? element.cpu : ''}}\n                        </text>\n\n                        <circle [attr.stroke-width]=\"element.cpu>1?2:1\"\n                                [attr.stroke]=\n                                        \"element.cpu>1?'OrangeRed':'gainsboro'\"\n                                fill-opacity=\"0\" r=\"12.5\"></circle>\n                    </g>\n\n                    <g matTooltip=\"memory\" transform=\"translate(80, 20)\">\n\n                        <text fill=\"black\" text-anchor=\"middle\"\n                              vertical-align=\"middle\" font-size=\"10\"\n                              y=\"3\">\n                            {{element.memory > 0.1 ? element.memory : ''}}\n                        </text>\n\n                        <circle [attr.stroke-width]=\"element.memory>0.1?2:1\"\n                                [attr.stroke]=\n                                        \"element.memory>0.1?'blue':'gainsboro'\"\n                                fill-opacity=\"0\" r=\"12.5\"></circle>\n                    </g>\n                </svg>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"steps\">\n\n            <th mat-header-cell *matHeaderCellDef style=\"width: 60px\">\n                Steps\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                <span *ngIf=\"element.current_step\">\n                    {{element.current_step}}\n                </span>\n\n                <span *ngIf=\"element.steps>0\">\n                    /{{element.steps}}\n                </span>\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"progress\">\n\n            <th mat-header-cell *matHeaderCellDef style=\"width: 220px\">\n                Progress\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n               {{get_progress(element)}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"score\">\n            <th mat-header-cell *matHeaderCellDef>\n                Score\n            </th>\n\n            <td mat-cell *matCellDef=\"let element\">\n                {{element.score| number:'.5'}}\n            </td>\n        </ng-container>\n\n        <ng-container matColumnDef=\"links\">\n            <th mat-header-cell *matHeaderCellDef style=\"width: 60px\">\n                Links\n            </th>\n            <td mat-cell *matCellDef=\"let element\" style=\"min-width: 100px\">\n                <div>\n                    <mat-icon\n                            *ngIf=\"show_links\"\n                            svgIcon=\"report\"\n                            matTooltip=\"Report\"\n                            [class.transparent]=\n                                    \"is_report_transparent(element)\"\n                            [class.transparent-active]=\n                                    \"is_report_transparent_active(element)\"\n                            [routerLink]=\"router_link(element)\"\n                            (click)=\"report_click(element)\">\n                    </mat-icon>\n\n                    <mat-icon\n                            svgIcon=\"info\"\n                            matTooltip=\"Additional Info\"\n                            (click)=\"info(element)\">\n                    </mat-icon>\n\n                    <mat-icon\n                            *ngIf=\"show_links\"\n                            svgIcon=\"stop\"\n                            matTooltip=\"Stop\"\n                            (click)=\"stop(element)\"\n                            [class.transparent]=\"!unfinished(element)\">\n                    </mat-icon>\n\n                    <mat-icon\n                            *ngIf=\"show_links\"\n                            svgIcon=\"model\"\n                            matTooltip=\"Create model\"\n                            (click)=\"model(element)\">\n                    </mat-icon>\n\n                </div>\n\n            </td>\n        </ng-container>\n\n        <tr mat-header-row *matHeaderRowDef=\"displayed_columns\"></tr>\n        <tr mat-row *matRowDef=\"let row; columns: displayed_columns;\"></tr>\n    </table>\n\n\n    <mat-paginator\n            [pageSizeOptions]=\"[10, 30, 100]\"\n            [length]=\"paginator.total\"\n            [pageSize]=\"10\">\n    </mat-paginator>\n</div>\n"

/***/ }),

/***/ "./src/app/task/task-table/task-table.component.ts":
/*!*********************************************************!*\
  !*** ./src/app/task/task-table/task-table.component.ts ***!
  \*********************************************************/
/*! exports provided: TaskTableComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskTableComponent", function() { return TaskTableComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var _task_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../task.service */ "./src/app/task/task.service.ts");
/* harmony import */ var _report_report_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../report/report.service */ "./src/app/report/report.service.ts");
/* harmony import */ var _model_model_add_dialog_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../model/model-add-dialog.component */ "./src/app/model/model-add-dialog.component.ts");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/platform-browser */ "./node_modules/@angular/platform-browser/fesm5/platform-browser.js");
/* harmony import */ var _task_info_dialog_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./task-info-dialog.component */ "./src/app/task/task-table/task-info-dialog.component.ts");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../paginator */ "./src/app/paginator.ts");










var TaskTableComponent = /** @class */ (function () {
    function TaskTableComponent(service, report_service, model_add_dialog, task_info_dialog, iconRegistry, sanitizer) {
        this.service = service;
        this.report_service = report_service;
        this.model_add_dialog = model_add_dialog;
        this.task_info_dialog = task_info_dialog;
        this.show_links = true;
        this.displayed_columns = [
            'project',
            'dag',
            'id',
            'name',
            'status',
            'created',
            'started',
            'last_activity',
            'duration',
            'computer',
            'requirements',
            'steps',
            'progress',
            'score',
            'links'
        ];
        iconRegistry.addSvgIcon('stop', sanitizer.bypassSecurityTrustResourceUrl('assets/img/stop.svg'));
        iconRegistry.addSvgIcon('report', sanitizer.bypassSecurityTrustResourceUrl('assets/img/report.svg'));
        iconRegistry.addSvgIcon('model', sanitizer.bypassSecurityTrustResourceUrl('assets/img/model.svg'));
        iconRegistry.addSvgIcon('info', sanitizer.bypassSecurityTrustResourceUrl('assets/img/info.svg'));
    }
    TaskTableComponent.prototype.status_color = function (status) {
        return _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].status_colors[status];
    };
    TaskTableComponent.prototype.stop = function (task) {
        this.service.stop(task.id).subscribe(function (data) {
        });
    };
    TaskTableComponent.prototype.unfinished = function (element) {
        return [
            'not_ran',
            'in_progress',
            'queued'
        ].indexOf(element.status) != -1;
    };
    TaskTableComponent.prototype.is_report_transparent = function (element) {
        if (this.report) {
            return false;
        }
        return !element.report;
    };
    TaskTableComponent.prototype.is_report_transparent_active = function (element) {
        if (!this.report) {
            return false;
        }
        return !element.report_full;
    };
    TaskTableComponent.prototype.report_click = function (element) {
        var self = this;
        if (this.report) {
            this.service.toogle_report(element.id, this.report, element.report_full).subscribe(function (data) {
                element.report_full = data.report_full;
                self.report_service.data_updated.emit();
            });
            return;
        }
    };
    TaskTableComponent.prototype.model = function (element) {
        this.model_add_dialog.open(_model_model_add_dialog_component__WEBPACK_IMPORTED_MODULE_6__["ModelAddDialogComponent"], {
            width: '500px', height: '400px',
            data: {
                'project': element.dag_rel.project.id,
                'projects': this.projects,
                'task': element.id,
                'file': 'best_full',
                'fold': 0
            }
        });
    };
    TaskTableComponent.prototype.info = function (element) {
        this.task_info_dialog.open(_task_info_dialog_component__WEBPACK_IMPORTED_MODULE_8__["TaskInfoDialogComponent"], {
            width: '600px', height: '700px',
            data: {
                'id': element.id
            }
        });
    };
    TaskTableComponent.prototype.router_link = function (element) {
        if (this.report) {
            return null;
        }
        return "/reports/report-detail/" + element.report;
    };
    TaskTableComponent.prototype.ngOnInit = function () {
        this.paginator.paginator = this.paginator_view;
        this.paginator.sort = this.sort_view;
        this.paginator.init = true;
        this.paginator.ngOnInit();
    };
    TaskTableComponent.prototype.pad = function (num, size) {
        var s = num + "";
        while (s.length < size)
            s = "0" + s;
        return s;
    };
    TaskTableComponent.prototype.get_progress = function (element) {
        if (!element.loader_name) {
            return '';
        }
        var duration_minutes = this.pad(Math.floor(element.epoch_duration / 60).toString(), 2);
        var duration_seconds = this.pad(Math.floor(element.epoch_duration % 60).toString(), 2);
        var epoch_time_remaining_minutes = this.pad(Math.floor(element.epoch_time_remaining / 60).toString(), 2);
        var epoch_time_remaining_seconds = this.pad(Math.floor(element.epoch_time_remaining % 60).toString(), 2);
        var res = element.loader_name + ": \n        " + element.batch_index + "/" + element.batch_total + " \n        " + duration_minutes + ":" + duration_seconds + "/\n        " + epoch_time_remaining_minutes + ":" + epoch_time_remaining_seconds;
        if (element.loss != null) {
            res += ", loss=" + element.loss;
        }
        return res;
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _paginator__WEBPACK_IMPORTED_MODULE_9__["Paginator"])
    ], TaskTableComponent.prototype, "paginator", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], TaskTableComponent.prototype, "report", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Boolean)
    ], TaskTableComponent.prototype, "show_links", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Array)
    ], TaskTableComponent.prototype, "projects", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatPaginator"]),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatPaginator"])
    ], TaskTableComponent.prototype, "paginator_view", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])(_angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSort"]),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSort"])
    ], TaskTableComponent.prototype, "sort_view", void 0);
    TaskTableComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-task-table',
            template: __webpack_require__(/*! ./task-table.component.html */ "./src/app/task/task-table/task-table.component.html"),
            styles: [__webpack_require__(/*! ./task-table.component.css */ "./src/app/task/task-table/task-table.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_task_service__WEBPACK_IMPORTED_MODULE_4__["TaskService"],
            _report_report_service__WEBPACK_IMPORTED_MODULE_5__["ReportService"],
            _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialog"],
            _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatDialog"],
            _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatIconRegistry"],
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_7__["DomSanitizer"]])
    ], TaskTableComponent);
    return TaskTableComponent;
}());



/***/ }),

/***/ "./src/app/task/task.service.ts":
/*!**************************************!*\
  !*** ./src/app/task/task.service.ts ***!
  \**************************************/
/*! exports provided: TaskService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskService", function() { return TaskService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _base_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base.service */ "./src/app/base.service.ts");
/* harmony import */ var _app_settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../app-settings */ "./src/app/app-settings.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../models */ "./src/app/models.ts");






var TaskService = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TaskService, _super);
    function TaskService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collection_part = 'tasks';
        _this.single_part = 'task';
        return _this;
    }
    TaskService.prototype.stop = function (id) {
        var message = this.constructor.name + ".stop";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/stop';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["Status"]())));
    };
    TaskService.prototype.toogle_report = function (id, report, report_full) {
        var message = this.constructor.name + ".toogle_report";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT +
            this.single_part +
            '/toogle_report';
        return this.http.post(url, {
            'id': id,
            'report': report,
            'remove': report_full
        }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["ToogleReportResult"]())));
    };
    TaskService.prototype.steps = function (id) {
        var message = this.constructor.name + ".steps";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/steps';
        return this.http.post(url, id).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["StepNodeResult"]())));
    };
    TaskService.prototype.info = function (id) {
        var message = this.constructor.name + ".info";
        var url = _app_settings__WEBPACK_IMPORTED_MODULE_3__["AppSettings"].API_ENDPOINT + this.single_part + '/info';
        return this.http.post(url, { 'id': id }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(this.handleError(message, new _models__WEBPACK_IMPORTED_MODULE_5__["TaskInfo"]())));
    };
    TaskService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        })
    ], TaskService);
    return TaskService;
}(_base_service__WEBPACK_IMPORTED_MODULE_2__["BaseService"]));



/***/ }),

/***/ "./src/app/task/tasks/tasks.component.css":
/*!************************************************!*\
  !*** ./src/app/task/tasks/tasks.component.css ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\n  width: 100%;\n  min-width: 1580px;\n}\n\n.mat-form-field {\n  font-size: 14px;\n  width: 100%;\n}\n\ntd{\n  text-align: center;\n}\n\n::ng-deep .mat-sort-header-container{\n  display:flex;\n  justify-content:center;\n  text-align: center;\n  margin-left: 12px !important;\n}\n\n.mat-header-cell{\n  text-align: center !important;\n}\n\nmat-icon{\n  cursor: pointer;\n}\n\n.checkbox-section {\n  display: flex;\n  align-content: center;\n  align-items: center;\n  height: 60px;\n}\n\n.checkbox-margin {\n  margin: 0 10px;\n}\n\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvdGFzay90YXNrcy90YXNrcy5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsV0FBVztFQUNYLGlCQUFpQjtBQUNuQjs7QUFFQTtFQUNFLGVBQWU7RUFDZixXQUFXO0FBQ2I7O0FBRUE7RUFDRSxrQkFBa0I7QUFDcEI7O0FBRUE7RUFDRSxZQUFZO0VBQ1osc0JBQXNCO0VBQ3RCLGtCQUFrQjtFQUNsQiw0QkFBNEI7QUFDOUI7O0FBRUE7RUFDRSw2QkFBNkI7QUFDL0I7O0FBRUE7RUFDRSxlQUFlO0FBQ2pCOztBQUVBO0VBQ0UsYUFBYTtFQUNiLHFCQUFxQjtFQUNyQixtQkFBbUI7RUFDbkIsWUFBWTtBQUNkOztBQUVBO0VBQ0UsY0FBYztBQUNoQiIsImZpbGUiOiJzcmMvYXBwL3Rhc2svdGFza3MvdGFza3MuY29tcG9uZW50LmNzcyIsInNvdXJjZXNDb250ZW50IjpbInRhYmxlIHtcbiAgd2lkdGg6IDEwMCU7XG4gIG1pbi13aWR0aDogMTU4MHB4O1xufVxuXG4ubWF0LWZvcm0tZmllbGQge1xuICBmb250LXNpemU6IDE0cHg7XG4gIHdpZHRoOiAxMDAlO1xufVxuXG50ZHtcbiAgdGV4dC1hbGlnbjogY2VudGVyO1xufVxuXG46Om5nLWRlZXAgLm1hdC1zb3J0LWhlYWRlci1jb250YWluZXJ7XG4gIGRpc3BsYXk6ZmxleDtcbiAganVzdGlmeS1jb250ZW50OmNlbnRlcjtcbiAgdGV4dC1hbGlnbjogY2VudGVyO1xuICBtYXJnaW4tbGVmdDogMTJweCAhaW1wb3J0YW50O1xufVxuXG4ubWF0LWhlYWRlci1jZWxse1xuICB0ZXh0LWFsaWduOiBjZW50ZXIgIWltcG9ydGFudDtcbn1cblxubWF0LWljb257XG4gIGN1cnNvcjogcG9pbnRlcjtcbn1cblxuLmNoZWNrYm94LXNlY3Rpb24ge1xuICBkaXNwbGF5OiBmbGV4O1xuICBhbGlnbi1jb250ZW50OiBjZW50ZXI7XG4gIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gIGhlaWdodDogNjBweDtcbn1cblxuLmNoZWNrYm94LW1hcmdpbiB7XG4gIG1hcmdpbjogMCAxMHB4O1xufVxuXG4iXX0= */"

/***/ }),

/***/ "./src/app/task/tasks/tasks.component.html":
/*!*************************************************!*\
  !*** ./src/app/task/tasks/tasks.component.html ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<button mat-raised-button style=\"margin-top: 15px\"\n        (click)=\"filter_hidden=!filter_hidden\">\n    Filters {{filter_applied_text}}\n</button>\n\n<div [hidden]=\"filter_hidden\">\n    <mat-form-field style=\"width: 150px\">\n        <mat-label>Project</mat-label>\n        <mat-select (ngModelChange)=\"project=$event; onchange()\"\n                    [ngModel]=\"project\">\n            <mat-option *ngFor=\"let project of projects\" [value]=\"project.id\">\n                {{project.name}}\n            </mat-option>\n        </mat-select>\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 150px\">\n        <mat-label>Dag</mat-label>\n        <mat-select (ngModelChange)=\"dag=$event; onchange()\"\n                    [ngModel]=\"dag\">\n            <mat-option *ngFor=\"let dag of dags\" [value]=\"dag.id\">\n                {{dag.name}}\n            </mat-option>\n        </mat-select>\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 150px\">\n        <input matInput (keyup)=\"name=$event.target.value;onchange()\"\n               placeholder=\"Name\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 100px\">\n        <input matInput (keyup)=\"id_min=$event.target.value;onchange()\"\n               placeholder=\"Id min\" type=\"number\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 100px\">\n        <input matInput (keyup)=\"id_max=$event.target.value;onchange()\"\n               placeholder=\"Id max\" type=\"number\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"created min\"\n               [ngModel]=\"created_min\"\n               (ngModelChange)=\"created_min = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"created max\"\n               [ngModel]=\"created_max\"\n               (ngModelChange)=\"created_max = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"last activity min\"\n               [ngModel]=\"last_activity_min\"\n               (ngModelChange)=\"last_activity_min = $event;onchange()\">\n    </mat-form-field>\n\n    <mat-form-field style=\"width: 200px\">\n        <input matInput type=\"datetime-local\" placeholder=\"last activity max\"\n               [ngModel]=\"last_activity_max\"\n               (ngModelChange)=\"last_activity_max = $event;onchange()\">\n    </mat-form-field>\n\n    <section class=\"checkbox-section\">\n        <mat-checkbox [(ngModel)]=\"not_ran\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            Not ran\n        </mat-checkbox>\n\n        <mat-checkbox [(ngModel)]=\"queued\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            Queued\n        </mat-checkbox>\n\n        <mat-checkbox [(ngModel)]=\"in_progress\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            In progress\n        </mat-checkbox>\n\n        <mat-checkbox [(ngModel)]=\"failed\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            Failed\n        </mat-checkbox>\n\n        <mat-checkbox [(ngModel)]=\"stopped\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            Stopped\n        </mat-checkbox>\n\n        <mat-checkbox [(ngModel)]=\"skipped\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            Skipped\n        </mat-checkbox>\n\n        <mat-checkbox [(ngModel)]=\"success\" class=\"checkbox-margin\"\n                      (ngModelChange)=\"onchange()\">\n            Success\n        </mat-checkbox>\n    </section>\n</div>\n\n<app-task-table\n        [paginator]=\"this\"\n        [report]=\"report\"\n        [projects]=\"projects\">\n\n</app-task-table>\n\n\n"

/***/ }),

/***/ "./src/app/task/tasks/tasks.component.ts":
/*!***********************************************!*\
  !*** ./src/app/task/tasks/tasks.component.ts ***!
  \***********************************************/
/*! exports provided: TasksComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TasksComponent", function() { return TasksComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _paginator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../paginator */ "./src/app/paginator.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../models */ "./src/app/models.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../helpers */ "./src/app/helpers.ts");
/* harmony import */ var _task_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../task.service */ "./src/app/task/task.service.ts");








var TasksComponent = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TasksComponent, _super);
    function TasksComponent(service, location, router, route) {
        var _this = _super.call(this, service, location, null, null, true, false) || this;
        _this.service = service;
        _this.location = location;
        _this.router = router;
        _this.route = route;
        _this.filter_hidden = true;
        _this.not_ran = false;
        _this.queued = false;
        _this.in_progress = false;
        _this.failed = false;
        _this.stopped = false;
        _this.skipped = false;
        _this.success = false;
        return _this;
    }
    TasksComponent.prototype.ngAfterContentChecked = function () {
        var _this = this;
        this.route.queryParams.subscribe(function (params) {
            if (params['dag'])
                _this.dag = parseInt(params['dag']);
            if (params['status']) {
                _this.not_ran = false;
                _this.queued = false;
                _this.in_progress = false;
                _this.failed = false;
                _this.stopped = false;
                _this.skipped = false;
                _this.success = false;
                _this[params['status']] = true;
            }
        });
    };
    TasksComponent.prototype._ngOnInit = function () {
        var self = this;
        this.data_updated.subscribe(function (res) {
            if (!res || !res.projects) {
                return;
            }
            self.projects = res.projects;
            self.projects.splice(0, 0, { 'id': -1, 'name': 'None' });
            self.dags = res.dags;
            self.dags.splice(0, 0, { 'id': -1, 'name': 'None' });
            self.dags_model = res.dags_model;
        });
    };
    TasksComponent.prototype.get_filter = function () {
        var res = new _models__WEBPACK_IMPORTED_MODULE_5__["TaskFilter"]();
        res.paginator = _super.prototype.get_filter.call(this);
        res.name = this.name;
        res.report = this.report;
        if (this.project != -1) {
            res.project = this.project;
        }
        if (this.dag != -1) {
            res.dag = this.dag;
        }
        res.status = {
            'not_ran': this.not_ran,
            'queued': this.queued,
            'in_progress': this.in_progress,
            'failed': this.failed,
            'stopped': this.stopped,
            'skipped': this.skipped,
            'success': this.success
        };
        res.created_min = _helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(this.created_min);
        res.created_max = _helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(this.created_max);
        res.last_activity_min = _helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(this.last_activity_min);
        res.last_activity_max = _helpers__WEBPACK_IMPORTED_MODULE_6__["Helpers"].parse_time(this.last_activity_max);
        res.id_min = this.id_min;
        res.id_max = this.id_max;
        return res;
    };
    TasksComponent.prototype.onchange = function () {
        this.change.emit();
        var filter = this.get_filter();
        var count = 0;
        if (this.dag && this.dag != -1)
            count += 1;
        if (this.name)
            count += 1;
        if (this.project && this.project != -1)
            count += 1;
        if (this.created_min)
            count += 1;
        if (this.created_max)
            count += 1;
        if (this.last_activity_min)
            count += 1;
        if (this.last_activity_max)
            count += 1;
        for (var _i = 0, _a = Object.getOwnPropertyNames(filter.status); _i < _a.length; _i++) {
            var k = _a[_i];
            count += filter.status[k] == true ? 1 : 0;
        }
        this.filter_applied_text = count > 0 ? "(" + count + " applied)" : '';
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], TasksComponent.prototype, "dag", void 0);
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
    ], TasksComponent.prototype, "report", void 0);
    TasksComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-tasks',
            template: __webpack_require__(/*! ./tasks.component.html */ "./src/app/task/tasks/tasks.component.html"),
            styles: [__webpack_require__(/*! ./tasks.component.css */ "./src/app/task/tasks/tasks.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_task_service__WEBPACK_IMPORTED_MODULE_7__["TaskService"],
            _angular_common__WEBPACK_IMPORTED_MODULE_2__["Location"],
            _angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"],
            _angular_router__WEBPACK_IMPORTED_MODULE_3__["ActivatedRoute"]])
    ], TasksComponent);
    return TasksComponent;
}(_paginator__WEBPACK_IMPORTED_MODULE_4__["Paginator"]));



/***/ }),

/***/ "./src/environments/environment.ts":
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/*! exports provided: environment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "environment", function() { return environment; });
var environment = {
    production: true
};


/***/ }),

/***/ "./src/main.ts":
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/platform-browser-dynamic */ "./node_modules/@angular/platform-browser-dynamic/fesm5/platform-browser-dynamic.js");
/* harmony import */ var _app_app_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app/app.module */ "./src/app/app.module.ts");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./environments/environment */ "./src/environments/environment.ts");




if (_environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].production) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["enableProdMode"])();
}
Object(_angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_1__["platformBrowserDynamic"])().bootstrapModule(_app_app_module__WEBPACK_IMPORTED_MODULE_2__["AppModule"]);


/***/ }),

/***/ 0:
/*!***************************!*\
  !*** multi ./src/main.ts ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /f/projects/mlcomp/mlcomp/server/front/src/main.ts */"./src/main.ts");


/***/ })

},[[0,"runtime","vendor"]]]);
//# sourceMappingURL=main.js.map