
ASN.1 modules for Python
------------------------
[![PyPI](https://img.shields.io/pypi/v/pysnmp-pyasn1-modules.svg?maxAge=2592000)](https://pypi.org/project/pysnmp-pyasn1-modules)
[![Python Versions](https://img.shields.io/pypi/pyversions/pysnmp-pyasn1-modules.svg)](https://pypi.org/project/pysnmp-pyasn1-modules/)
[![CI](https://github.com/pysnmp/pyasn1-modules/actions/workflows/build-test-release.yml/badge.svg)](https://github.com/pysnmp/pyasn1-modules/actions/workflows/build-test-release.yml)
[![Coverage Status](https://img.shields.io/codecov/c/github/pysnmp/pyasn1-modules.svg)](https://codecov.io/github/pysnmp/pyasn1-modules/)
[![GitHub license](https://img.shields.io/badge/license-BSD-blue.svg)](https://raw.githubusercontent.com/pysnmp/pyasn1-modules/master/LICENSE.txt)

The `pyasn1-modules` package contains a collection of
[ASN.1](https://www.itu.int/rec/dologin_pub.asp?lang=e&id=T-REC-X.208-198811-W!!PDF-E&type=items)
data structures expressed as Python classes based on [pyasn1](https://github.com/pysnmp/pyasn1)
data model.

If ASN.1 module you need is not present in this collection, try using
[Asn1ate](https://github.com/kimgr/asn1ate) tool that compiles ASN.1 documents
into pyasn1 code.

Feedback
--------

If something does not work as expected, 
[open an issue](https://github.com/pysnmp/pyasn1-modules/issues) at GitHub
or post your question [on Stack Overflow](https://stackoverflow.com/questions/ask)
 
New modules contributions are welcome via GitHub pull requests.

Copyright (c) 2005-2020, [Ilya Etingof](mailto:etingof@gmail.com).
All rights reserved.
