#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 134
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 54
#define ALIAS_COUNT 17
#define TOKEN_COUNT 21
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 12

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_body_block_keyword = 2,
  anon_sym_LBRACE = 3,
  anon_sym_RBRACE = 4,
  anon_sym_SEMI = 5,
  sym_promise_block_keyword = 6,
  sym_bundle_block_keyword = 7,
  anon_sym_LPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_RPAREN = 10,
  anon_sym_DOLLAR = 11,
  anon_sym_AT = 12,
  anon_sym_DASH_GT = 13,
  anon_sym_EQ_GT = 14,
  sym_quoted_string = 15,
  sym_qualified_identifier = 16,
  sym_promise_guard = 17,
  sym_class_guard = 18,
  sym_comment = 19,
  sym_macro = 20,
  sym_source_file = 21,
  sym__block = 22,
  sym_body_block = 23,
  sym_body_block_body = 24,
  sym__body_attribute = 25,
  sym_promise_block = 26,
  sym_promise_block_body = 27,
  sym_class_guarded_body_attributes = 28,
  sym_bundle_block = 29,
  sym_parameter_list = 30,
  sym_bundle_block_body = 31,
  sym_bundle_section = 32,
  sym__right_value = 33,
  sym_dollar_expression = 34,
  sym_at_expression = 35,
  sym_call = 36,
  sym_list = 37,
  sym__value_list = 38,
  sym_class_guarded_promises = 39,
  sym__promises = 40,
  sym_promise = 41,
  sym_half_promise = 42,
  sym_attribute = 43,
  aux_sym_source_file_repeat1 = 44,
  aux_sym_body_block_body_repeat1 = 45,
  aux_sym_body_block_body_repeat2 = 46,
  aux_sym_promise_block_body_repeat1 = 47,
  aux_sym_parameter_list_repeat1 = 48,
  aux_sym_bundle_block_body_repeat1 = 49,
  aux_sym_bundle_section_repeat1 = 50,
  aux_sym__value_list_repeat1 = 51,
  aux_sym__promises_repeat1 = 52,
  aux_sym_promise_repeat1 = 53,
  alias_sym_at_expression_end = 54,
  alias_sym_at_expression_identifier = 55,
  alias_sym_at_expression_start = 56,
  alias_sym_attribute_name = 57,
  alias_sym_body_block_name = 58,
  alias_sym_body_block_type = 59,
  alias_sym_bundle_block_name = 60,
  alias_sym_bundle_block_type = 61,
  alias_sym_calling_identifier = 62,
  alias_sym_class_guarded_promise_block_attributes = 63,
  alias_sym_dollar_expression_end = 64,
  alias_sym_dollar_expression_identifier = 65,
  alias_sym_dollar_expression_start = 66,
  alias_sym_promise_block_name = 67,
  alias_sym_promise_block_type = 68,
  alias_sym_promiser = 69,
  alias_sym_stakeholder = 70,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "parameter",
  [sym_body_block_keyword] = "body_block_keyword",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SEMI] = ";",
  [sym_promise_block_keyword] = "promise_block_keyword",
  [sym_bundle_block_keyword] = "bundle_block_keyword",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR] = "dollar_expression_operator",
  [anon_sym_AT] = "at_expression_operator",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_EQ_GT] = "=>",
  [sym_quoted_string] = "quoted_string",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_promise_guard] = "promise_guard",
  [sym_class_guard] = "class_guard",
  [sym_comment] = "comment",
  [sym_macro] = "macro",
  [sym_source_file] = "source_file",
  [sym__block] = "_block",
  [sym_body_block] = "body_block",
  [sym_body_block_body] = "body_block_body",
  [sym__body_attribute] = "_body_attribute",
  [sym_promise_block] = "promise_block",
  [sym_promise_block_body] = "promise_block_body",
  [sym_class_guarded_body_attributes] = "class_guarded_body_attributes",
  [sym_bundle_block] = "bundle_block",
  [sym_parameter_list] = "parameter_list",
  [sym_bundle_block_body] = "bundle_block_body",
  [sym_bundle_section] = "bundle_section",
  [sym__right_value] = "_right_value",
  [sym_dollar_expression] = "dollar_expression",
  [sym_at_expression] = "at_expression",
  [sym_call] = "call",
  [sym_list] = "list",
  [sym__value_list] = "_value_list",
  [sym_class_guarded_promises] = "class_guarded_promises",
  [sym__promises] = "_promises",
  [sym_promise] = "promise",
  [sym_half_promise] = "half_promise",
  [sym_attribute] = "attribute",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_body_block_body_repeat1] = "body_block_body_repeat1",
  [aux_sym_body_block_body_repeat2] = "body_block_body_repeat2",
  [aux_sym_promise_block_body_repeat1] = "promise_block_body_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_bundle_block_body_repeat1] = "bundle_block_body_repeat1",
  [aux_sym_bundle_section_repeat1] = "bundle_section_repeat1",
  [aux_sym__value_list_repeat1] = "_value_list_repeat1",
  [aux_sym__promises_repeat1] = "_promises_repeat1",
  [aux_sym_promise_repeat1] = "promise_repeat1",
  [alias_sym_at_expression_end] = "at_expression_end",
  [alias_sym_at_expression_identifier] = "at_expression_identifier",
  [alias_sym_at_expression_start] = "at_expression_start",
  [alias_sym_attribute_name] = "attribute_name",
  [alias_sym_body_block_name] = "body_block_name",
  [alias_sym_body_block_type] = "body_block_type",
  [alias_sym_bundle_block_name] = "bundle_block_name",
  [alias_sym_bundle_block_type] = "bundle_block_type",
  [alias_sym_calling_identifier] = "calling_identifier",
  [alias_sym_class_guarded_promise_block_attributes] = "class_guarded_promise_block_attributes",
  [alias_sym_dollar_expression_end] = "dollar_expression_end",
  [alias_sym_dollar_expression_identifier] = "dollar_expression_identifier",
  [alias_sym_dollar_expression_start] = "dollar_expression_start",
  [alias_sym_promise_block_name] = "promise_block_name",
  [alias_sym_promise_block_type] = "promise_block_type",
  [alias_sym_promiser] = "promiser",
  [alias_sym_stakeholder] = "stakeholder",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_body_block_keyword] = sym_body_block_keyword,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_promise_block_keyword] = sym_promise_block_keyword,
  [sym_bundle_block_keyword] = sym_bundle_block_keyword,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [sym_quoted_string] = sym_quoted_string,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_promise_guard] = sym_promise_guard,
  [sym_class_guard] = sym_class_guard,
  [sym_comment] = sym_comment,
  [sym_macro] = sym_macro,
  [sym_source_file] = sym_source_file,
  [sym__block] = sym__block,
  [sym_body_block] = sym_body_block,
  [sym_body_block_body] = sym_body_block_body,
  [sym__body_attribute] = sym__body_attribute,
  [sym_promise_block] = sym_promise_block,
  [sym_promise_block_body] = sym_promise_block_body,
  [sym_class_guarded_body_attributes] = sym_class_guarded_body_attributes,
  [sym_bundle_block] = sym_bundle_block,
  [sym_parameter_list] = sym_parameter_list,
  [sym_bundle_block_body] = sym_bundle_block_body,
  [sym_bundle_section] = sym_bundle_section,
  [sym__right_value] = sym__right_value,
  [sym_dollar_expression] = sym_dollar_expression,
  [sym_at_expression] = sym_at_expression,
  [sym_call] = sym_call,
  [sym_list] = sym_list,
  [sym__value_list] = sym__value_list,
  [sym_class_guarded_promises] = sym_class_guarded_promises,
  [sym__promises] = sym__promises,
  [sym_promise] = sym_promise,
  [sym_half_promise] = sym_half_promise,
  [sym_attribute] = sym_attribute,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_body_block_body_repeat1] = aux_sym_body_block_body_repeat1,
  [aux_sym_body_block_body_repeat2] = aux_sym_body_block_body_repeat2,
  [aux_sym_promise_block_body_repeat1] = aux_sym_promise_block_body_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_bundle_block_body_repeat1] = aux_sym_bundle_block_body_repeat1,
  [aux_sym_bundle_section_repeat1] = aux_sym_bundle_section_repeat1,
  [aux_sym__value_list_repeat1] = aux_sym__value_list_repeat1,
  [aux_sym__promises_repeat1] = aux_sym__promises_repeat1,
  [aux_sym_promise_repeat1] = aux_sym_promise_repeat1,
  [alias_sym_at_expression_end] = alias_sym_at_expression_end,
  [alias_sym_at_expression_identifier] = alias_sym_at_expression_identifier,
  [alias_sym_at_expression_start] = alias_sym_at_expression_start,
  [alias_sym_attribute_name] = alias_sym_attribute_name,
  [alias_sym_body_block_name] = alias_sym_body_block_name,
  [alias_sym_body_block_type] = alias_sym_body_block_type,
  [alias_sym_bundle_block_name] = alias_sym_bundle_block_name,
  [alias_sym_bundle_block_type] = alias_sym_bundle_block_type,
  [alias_sym_calling_identifier] = alias_sym_calling_identifier,
  [alias_sym_class_guarded_promise_block_attributes] = alias_sym_class_guarded_promise_block_attributes,
  [alias_sym_dollar_expression_end] = alias_sym_dollar_expression_end,
  [alias_sym_dollar_expression_identifier] = alias_sym_dollar_expression_identifier,
  [alias_sym_dollar_expression_start] = alias_sym_dollar_expression_start,
  [alias_sym_promise_block_name] = alias_sym_promise_block_name,
  [alias_sym_promise_block_type] = alias_sym_promise_block_type,
  [alias_sym_promiser] = alias_sym_promiser,
  [alias_sym_stakeholder] = alias_sym_stakeholder,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_body_block_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_promise_block_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_bundle_block_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_promise_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_class_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym_body_block] = {
    .visible = true,
    .named = true,
  },
  [sym_body_block_body] = {
    .visible = true,
    .named = true,
  },
  [sym__body_attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_promise_block] = {
    .visible = true,
    .named = true,
  },
  [sym_promise_block_body] = {
    .visible = true,
    .named = true,
  },
  [sym_class_guarded_body_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_bundle_block] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_bundle_block_body] = {
    .visible = true,
    .named = true,
  },
  [sym_bundle_section] = {
    .visible = true,
    .named = true,
  },
  [sym__right_value] = {
    .visible = false,
    .named = true,
  },
  [sym_dollar_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_at_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__value_list] = {
    .visible = false,
    .named = true,
  },
  [sym_class_guarded_promises] = {
    .visible = true,
    .named = true,
  },
  [sym__promises] = {
    .visible = false,
    .named = true,
  },
  [sym_promise] = {
    .visible = true,
    .named = true,
  },
  [sym_half_promise] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_body_block_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_body_block_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_promise_block_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bundle_block_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bundle_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__value_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__promises_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_promise_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_at_expression_end] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_at_expression_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_at_expression_start] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_body_block_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_body_block_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_bundle_block_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_bundle_block_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_calling_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_class_guarded_promise_block_attributes] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_dollar_expression_end] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_dollar_expression_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_dollar_expression_start] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_promise_block_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_promise_block_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_promiser] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_stakeholder] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = alias_sym_body_block_type,
    [2] = alias_sym_body_block_name,
  },
  [2] = {
    [1] = alias_sym_promise_block_type,
    [2] = alias_sym_promise_block_name,
  },
  [3] = {
    [1] = alias_sym_bundle_block_type,
    [2] = alias_sym_bundle_block_name,
  },
  [4] = {
    [0] = alias_sym_class_guarded_promise_block_attributes,
  },
  [5] = {
    [0] = alias_sym_attribute_name,
  },
  [6] = {
    [0] = alias_sym_promiser,
  },
  [7] = {
    [0] = alias_sym_calling_identifier,
  },
  [8] = {
    [0] = alias_sym_promiser,
    [2] = alias_sym_stakeholder,
  },
  [9] = {
    [1] = alias_sym_dollar_expression_start,
    [2] = alias_sym_dollar_expression_identifier,
    [3] = alias_sym_dollar_expression_end,
  },
  [10] = {
    [1] = alias_sym_dollar_expression_start,
    [3] = alias_sym_dollar_expression_end,
  },
  [11] = {
    [1] = alias_sym_at_expression_start,
    [2] = alias_sym_at_expression_identifier,
    [3] = alias_sym_at_expression_end,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_class_guarded_body_attributes, 2,
    sym_class_guarded_body_attributes,
    alias_sym_class_guarded_promise_block_attributes,
  sym__right_value, 2,
    sym__right_value,
    alias_sym_stakeholder,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
};

static inline bool sym_class_guard_character_set_1(int32_t c) {
  return (c < '0'
    ? (c < '&'
      ? (c < ' '
        ? c == '\t'
        : c <= '!')
      : (c <= '&' || (c < '.'
        ? (c >= '(' && c <= ')')
        : c <= '.')))
    : (c <= '9' || (c < 'a'
      ? (c < '_'
        ? (c >= 'A' && c <= 'Z')
        : c <= '_')
      : (c <= 'z' || c == '|'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(23);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '(') ADVANCE(27);
      if (lookahead == ')') ADVANCE(29);
      if (lookahead == ',') ADVANCE(28);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == ';') ADVANCE(26);
      if (lookahead == '=') ADVANCE(9);
      if (lookahead == '@') ADVANCE(31);
      if (lookahead == '`') ADVANCE(10);
      if (lookahead == '{') ADVANCE(24);
      if (lookahead == '}') ADVANCE(25);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 1:
      if (lookahead == ' ') ADVANCE(46);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == ')') ADVANCE(29);
      if (lookahead == '@') ADVANCE(31);
      if (lookahead == '`') ADVANCE(10);
      if (lookahead == '{') ADVANCE(24);
      if (lookahead == '}') ADVANCE(25);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '`') ADVANCE(10);
      if (lookahead == '}') ADVANCE(25);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '!' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == '.' ||
          lookahead == ':' ||
          lookahead == '|') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '\'') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead != 0) ADVANCE(5);
      END_STATE();
    case 6:
      if (lookahead == ':') ADVANCE(44);
      if (sym_class_guard_character_set_1(lookahead)) ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == ':') ADVANCE(6);
      if (sym_class_guard_character_set_1(lookahead)) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '>') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == '>') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == '`') ADVANCE(34);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == 'd') ADVANCE(16);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(17);
      if (lookahead == 'i') ADVANCE(14);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'f') ADVANCE(1);
      END_STATE();
    case 15:
      if (lookahead == 'f') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'i') ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(11);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 19:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 21:
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 22:
      if (lookahead != 0) ADVANCE(5);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'e') ADVANCE(17);
      if (lookahead == 'i') ADVANCE(14);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_quoted_string);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '.' ||
          lookahead == '|') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '.' ||
          lookahead == '|') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_qualified_identifier);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == ':') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_qualified_identifier);
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_qualified_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_promise_guard);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_promise_guard);
      if (lookahead == ':') ADVANCE(44);
      if (sym_class_guard_character_set_1(lookahead)) ADVANCE(7);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_class_guard);
      if (lookahead == ':') ADVANCE(44);
      if (sym_class_guard_character_set_1(lookahead)) ADVANCE(7);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_macro);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(46);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'b') ADVANCE(1);
      if (lookahead == 'p') ADVANCE(2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'o') ADVANCE(3);
      if (lookahead == 'u') ADVANCE(4);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(5);
      END_STATE();
    case 3:
      if (lookahead == 'd') ADVANCE(6);
      END_STATE();
    case 4:
      if (lookahead == 'n') ADVANCE(7);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(8);
      END_STATE();
    case 6:
      if (lookahead == 'y') ADVANCE(9);
      END_STATE();
    case 7:
      if (lookahead == 'd') ADVANCE(10);
      END_STATE();
    case 8:
      if (lookahead == 'm') ADVANCE(11);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(sym_body_block_keyword);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(12);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(13);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(14);
      END_STATE();
    case 13:
      if (lookahead == 's') ADVANCE(15);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(sym_bundle_block_keyword);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(16);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(sym_promise_block_keyword);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 2},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 2},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 3},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 3},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 3},
  [14] = {.lex_state = 3},
  [15] = {.lex_state = 3},
  [16] = {.lex_state = 3},
  [17] = {.lex_state = 3},
  [18] = {.lex_state = 3},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 3},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 3},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 3},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 3},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 3},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 3},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 3},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 3},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 0},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 0},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_body_block_keyword] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_promise_block_keyword] = ACTIONS(1),
    [sym_bundle_block_keyword] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [sym_quoted_string] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_macro] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(130),
    [sym__block] = STATE(12),
    [sym_body_block] = STATE(12),
    [sym_promise_block] = STATE(12),
    [sym_bundle_block] = STATE(12),
    [aux_sym_source_file_repeat1] = STATE(12),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_body_block_keyword] = ACTIONS(7),
    [sym_promise_block_keyword] = ACTIONS(9),
    [sym_bundle_block_keyword] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [sym_macro] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 9,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    STATE(89), 1,
      sym__right_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(15), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [33] = 10,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    ACTIONS(25), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym__right_value,
    STATE(116), 1,
      sym__value_list,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [68] = 10,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    ACTIONS(27), 1,
      anon_sym_RBRACE,
    STATE(71), 1,
      sym__right_value,
    STATE(113), 1,
      sym__value_list,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [103] = 9,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    STATE(89), 1,
      sym__right_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(29), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [136] = 8,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    STATE(105), 1,
      sym__right_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [165] = 8,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    STATE(89), 1,
      sym__right_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [194] = 8,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      sym_quoted_string,
    ACTIONS(23), 1,
      sym_qualified_identifier,
    STATE(26), 1,
      sym__right_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(43), 4,
      sym_dollar_expression,
      sym_at_expression,
      sym_call,
      sym_list,
  [223] = 7,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(35), 1,
      sym_quoted_string,
    ACTIONS(37), 1,
      sym_promise_guard,
    STATE(80), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(33), 2,
      anon_sym_RBRACE,
      sym_class_guard,
    STATE(11), 3,
      sym_promise,
      sym_half_promise,
      aux_sym__promises_repeat1,
  [249] = 6,
    ACTIONS(39), 1,
      ts_builtin_sym_end,
    ACTIONS(41), 1,
      sym_body_block_keyword,
    ACTIONS(44), 1,
      sym_promise_block_keyword,
    ACTIONS(47), 1,
      sym_bundle_block_keyword,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(10), 5,
      sym__block,
      sym_body_block,
      sym_promise_block,
      sym_bundle_block,
      aux_sym_source_file_repeat1,
  [273] = 7,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(35), 1,
      sym_quoted_string,
    ACTIONS(52), 1,
      sym_promise_guard,
    STATE(80), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(50), 2,
      anon_sym_RBRACE,
      sym_class_guard,
    STATE(13), 3,
      sym_promise,
      sym_half_promise,
      aux_sym__promises_repeat1,
  [299] = 6,
    ACTIONS(7), 1,
      sym_body_block_keyword,
    ACTIONS(9), 1,
      sym_promise_block_keyword,
    ACTIONS(11), 1,
      sym_bundle_block_keyword,
    ACTIONS(54), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(10), 5,
      sym__block,
      sym_body_block,
      sym_promise_block,
      sym_bundle_block,
      aux_sym_source_file_repeat1,
  [323] = 7,
    ACTIONS(56), 1,
      sym_identifier,
    ACTIONS(61), 1,
      sym_quoted_string,
    ACTIONS(64), 1,
      sym_promise_guard,
    STATE(80), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(59), 2,
      anon_sym_RBRACE,
      sym_class_guard,
    STATE(13), 3,
      sym_promise,
      sym_half_promise,
      aux_sym__promises_repeat1,
  [349] = 8,
    ACTIONS(35), 1,
      sym_quoted_string,
    ACTIONS(66), 1,
      anon_sym_RBRACE,
    ACTIONS(68), 1,
      sym_promise_guard,
    ACTIONS(70), 1,
      sym_class_guard,
    STATE(9), 1,
      sym_promise,
    STATE(41), 1,
      sym__promises,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(40), 2,
      sym_class_guarded_promises,
      aux_sym_bundle_section_repeat1,
  [376] = 7,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(72), 1,
      anon_sym_RBRACE,
    ACTIONS(74), 1,
      sym_class_guard,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(18), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
    STATE(52), 2,
      sym_class_guarded_body_attributes,
      aux_sym_body_block_body_repeat2,
  [401] = 8,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(76), 1,
      anon_sym_RBRACE,
    STATE(61), 1,
      aux_sym_promise_block_body_repeat1,
    STATE(106), 1,
      sym_class_guarded_body_attributes,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(23), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
  [428] = 8,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(78), 1,
      anon_sym_RBRACE,
    STATE(74), 1,
      aux_sym_promise_block_body_repeat1,
    STATE(106), 1,
      sym_class_guarded_body_attributes,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(16), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
  [455] = 7,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(80), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(23), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
    STATE(54), 2,
      sym_class_guarded_body_attributes,
      aux_sym_body_block_body_repeat2,
  [480] = 5,
    ACTIONS(31), 1,
      sym_identifier,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(82), 2,
      anon_sym_RBRACE,
      sym_class_guard,
    STATE(23), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
  [499] = 5,
    ACTIONS(31), 1,
      sym_identifier,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(84), 2,
      anon_sym_RBRACE,
      sym_class_guard,
    STATE(19), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
  [518] = 6,
    ACTIONS(35), 1,
      sym_quoted_string,
    ACTIONS(88), 1,
      sym_promise_guard,
    STATE(9), 1,
      sym_promise,
    STATE(78), 1,
      sym__promises,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(86), 2,
      anon_sym_RBRACE,
      sym_class_guard,
  [539] = 3,
    ACTIONS(92), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(90), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [554] = 5,
    ACTIONS(94), 1,
      sym_identifier,
    STATE(115), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(97), 2,
      anon_sym_RBRACE,
      sym_class_guard,
    STATE(23), 2,
      sym__body_attribute,
      aux_sym_body_block_body_repeat1,
  [573] = 7,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_SEMI,
    ACTIONS(103), 1,
      anon_sym_COMMA,
    ACTIONS(105), 1,
      anon_sym_DASH_GT,
    STATE(77), 1,
      aux_sym_promise_repeat1,
    STATE(83), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [596] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(107), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [608] = 6,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(109), 1,
      anon_sym_SEMI,
    ACTIONS(111), 1,
      anon_sym_COMMA,
    STATE(85), 1,
      aux_sym_promise_repeat1,
    STATE(87), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [628] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(113), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(115), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [642] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(117), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(119), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [656] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(121), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(123), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [670] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(125), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [682] = 5,
    ACTIONS(127), 1,
      anon_sym_RBRACE,
    ACTIONS(129), 1,
      sym_promise_guard,
    ACTIONS(131), 1,
      sym_class_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(31), 2,
      sym_class_guarded_promises,
      aux_sym_bundle_section_repeat1,
  [700] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(134), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [712] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(136), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [724] = 5,
    ACTIONS(70), 1,
      sym_class_guard,
    ACTIONS(138), 1,
      anon_sym_RBRACE,
    ACTIONS(140), 1,
      sym_promise_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(31), 2,
      sym_class_guarded_promises,
      aux_sym_bundle_section_repeat1,
  [742] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(142), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(144), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [756] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(146), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(148), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [770] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(150), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(152), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [784] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(154), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(156), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [798] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(158), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [810] = 5,
    ACTIONS(70), 1,
      sym_class_guard,
    ACTIONS(160), 1,
      anon_sym_RBRACE,
    ACTIONS(162), 1,
      sym_promise_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(31), 2,
      sym_class_guarded_promises,
      aux_sym_bundle_section_repeat1,
  [828] = 5,
    ACTIONS(70), 1,
      sym_class_guard,
    ACTIONS(160), 1,
      anon_sym_RBRACE,
    ACTIONS(162), 1,
      sym_promise_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(34), 2,
      sym_class_guarded_promises,
      aux_sym_bundle_section_repeat1,
  [846] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(164), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [858] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(90), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [870] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(166), 5,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_identifier,
  [882] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(168), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(170), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [896] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(172), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(174), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [910] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(176), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(178), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [924] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(180), 2,
      sym_identifier,
      sym_promise_guard,
    ACTIONS(182), 3,
      anon_sym_RBRACE,
      sym_quoted_string,
      sym_class_guard,
  [938] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(184), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [949] = 5,
    ACTIONS(186), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 1,
      sym_class_guard,
    STATE(50), 1,
      aux_sym_promise_block_body_repeat1,
    STATE(106), 1,
      sym_class_guarded_body_attributes,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [966] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(191), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [977] = 4,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(80), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(55), 2,
      sym_class_guarded_body_attributes,
      aux_sym_body_block_body_repeat2,
  [992] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(193), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1003] = 4,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(195), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(55), 2,
      sym_class_guarded_body_attributes,
      aux_sym_body_block_body_repeat2,
  [1018] = 4,
    ACTIONS(197), 1,
      anon_sym_RBRACE,
    ACTIONS(199), 1,
      sym_class_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(55), 2,
      sym_class_guarded_body_attributes,
      aux_sym_body_block_body_repeat2,
  [1033] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(202), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1044] = 4,
    ACTIONS(204), 1,
      anon_sym_COMMA,
    STATE(67), 1,
      aux_sym__value_list_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(15), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [1059] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(206), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1070] = 5,
    ACTIONS(208), 1,
      anon_sym_LBRACE,
    ACTIONS(210), 1,
      anon_sym_LPAREN,
    STATE(69), 1,
      sym_body_block_body,
    STATE(108), 1,
      sym_parameter_list,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1087] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(212), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1098] = 5,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(214), 1,
      anon_sym_RBRACE,
    STATE(50), 1,
      aux_sym_promise_block_body_repeat1,
    STATE(106), 1,
      sym_class_guarded_body_attributes,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1115] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(216), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1126] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(218), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1137] = 4,
    ACTIONS(220), 1,
      anon_sym_RBRACE,
    ACTIONS(222), 1,
      sym_promise_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(64), 2,
      sym_bundle_section,
      aux_sym_bundle_block_body_repeat1,
  [1152] = 5,
    ACTIONS(210), 1,
      anon_sym_LPAREN,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    STATE(58), 1,
      sym_bundle_block_body,
    STATE(107), 1,
      sym_parameter_list,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1169] = 4,
    ACTIONS(227), 1,
      anon_sym_RBRACE,
    ACTIONS(229), 1,
      sym_promise_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(70), 2,
      sym_bundle_section,
      aux_sym_bundle_block_body_repeat1,
  [1184] = 4,
    ACTIONS(233), 1,
      anon_sym_COMMA,
    STATE(67), 1,
      aux_sym__value_list_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(231), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [1199] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(236), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1210] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(238), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1221] = 4,
    ACTIONS(229), 1,
      sym_promise_guard,
    ACTIONS(240), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    STATE(64), 2,
      sym_bundle_section,
      aux_sym_bundle_block_body_repeat1,
  [1236] = 4,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    STATE(57), 1,
      aux_sym__value_list_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(242), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [1251] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(246), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1262] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(248), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1273] = 5,
    ACTIONS(74), 1,
      sym_class_guard,
    ACTIONS(76), 1,
      anon_sym_RBRACE,
    STATE(50), 1,
      aux_sym_promise_block_body_repeat1,
    STATE(106), 1,
      sym_class_guarded_body_attributes,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1290] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(250), 4,
      ts_builtin_sym_end,
      sym_body_block_keyword,
      sym_promise_block_keyword,
      sym_bundle_block_keyword,
  [1301] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(252), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1315] = 4,
    ACTIONS(252), 1,
      anon_sym_SEMI,
    ACTIONS(254), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1329] = 3,
    ACTIONS(258), 1,
      sym_promise_guard,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(256), 2,
      anon_sym_RBRACE,
      sym_class_guard,
  [1341] = 4,
    ACTIONS(260), 1,
      anon_sym_SEMI,
    ACTIONS(262), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1355] = 4,
    ACTIONS(264), 1,
      anon_sym_SEMI,
    ACTIONS(266), 1,
      anon_sym_COMMA,
    STATE(79), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1369] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(268), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1383] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(270), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1397] = 4,
    ACTIONS(252), 1,
      anon_sym_SEMI,
    ACTIONS(254), 1,
      anon_sym_COMMA,
    STATE(95), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1411] = 3,
    ACTIONS(272), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(274), 2,
      anon_sym_RBRACE,
      sym_class_guard,
  [1423] = 4,
    ACTIONS(276), 1,
      anon_sym_SEMI,
    ACTIONS(278), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1437] = 4,
    ACTIONS(17), 1,
      anon_sym_DOLLAR,
    ACTIONS(280), 1,
      sym_qualified_identifier,
    STATE(121), 1,
      sym_dollar_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1451] = 4,
    ACTIONS(276), 1,
      anon_sym_SEMI,
    ACTIONS(278), 1,
      anon_sym_COMMA,
    STATE(92), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1465] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1479] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(231), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [1489] = 4,
    ACTIONS(282), 1,
      sym_identifier,
    ACTIONS(284), 1,
      anon_sym_RPAREN,
    STATE(109), 1,
      aux_sym_parameter_list_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1503] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(286), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1517] = 4,
    ACTIONS(286), 1,
      anon_sym_SEMI,
    ACTIONS(288), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1531] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(290), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1545] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(292), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1559] = 4,
    ACTIONS(292), 1,
      anon_sym_SEMI,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1573] = 4,
    ACTIONS(296), 1,
      anon_sym_SEMI,
    ACTIONS(298), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym_promise_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1587] = 4,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(260), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1601] = 3,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1612] = 3,
    ACTIONS(99), 1,
      sym_identifier,
    STATE(102), 1,
      sym_attribute,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1623] = 3,
    ACTIONS(305), 1,
      anon_sym_COMMA,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1634] = 3,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1645] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(296), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [1654] = 3,
    ACTIONS(309), 1,
      sym_identifier,
    STATE(103), 1,
      aux_sym_parameter_list_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1665] = 3,
    ACTIONS(312), 1,
      anon_sym_LBRACE,
    STATE(62), 1,
      sym_promise_block_body,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1676] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(314), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [1685] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
    ACTIONS(316), 2,
      anon_sym_RBRACE,
      sym_class_guard,
  [1694] = 3,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    STATE(51), 1,
      sym_bundle_block_body,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1705] = 3,
    ACTIONS(208), 1,
      anon_sym_LBRACE,
    STATE(75), 1,
      sym_body_block_body,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1716] = 3,
    ACTIONS(318), 1,
      sym_identifier,
    STATE(103), 1,
      aux_sym_parameter_list_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1727] = 3,
    ACTIONS(320), 1,
      anon_sym_COMMA,
    ACTIONS(322), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1738] = 2,
    ACTIONS(324), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1746] = 2,
    ACTIONS(326), 1,
      sym_qualified_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1754] = 2,
    ACTIONS(328), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1762] = 2,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1770] = 2,
    ACTIONS(330), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1778] = 2,
    ACTIONS(332), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1786] = 2,
    ACTIONS(334), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1794] = 2,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1802] = 2,
    ACTIONS(338), 1,
      anon_sym_COMMA,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1810] = 2,
    ACTIONS(340), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1818] = 2,
    ACTIONS(342), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1826] = 2,
    ACTIONS(344), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1834] = 2,
    ACTIONS(346), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1842] = 2,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1850] = 2,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1858] = 2,
    ACTIONS(352), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1866] = 2,
    ACTIONS(354), 1,
      anon_sym_EQ_GT,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1874] = 2,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1882] = 2,
    ACTIONS(358), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1890] = 2,
    ACTIONS(360), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1898] = 2,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1906] = 2,
    ACTIONS(364), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
  [1914] = 2,
    ACTIONS(366), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_macro,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 33,
  [SMALL_STATE(4)] = 68,
  [SMALL_STATE(5)] = 103,
  [SMALL_STATE(6)] = 136,
  [SMALL_STATE(7)] = 165,
  [SMALL_STATE(8)] = 194,
  [SMALL_STATE(9)] = 223,
  [SMALL_STATE(10)] = 249,
  [SMALL_STATE(11)] = 273,
  [SMALL_STATE(12)] = 299,
  [SMALL_STATE(13)] = 323,
  [SMALL_STATE(14)] = 349,
  [SMALL_STATE(15)] = 376,
  [SMALL_STATE(16)] = 401,
  [SMALL_STATE(17)] = 428,
  [SMALL_STATE(18)] = 455,
  [SMALL_STATE(19)] = 480,
  [SMALL_STATE(20)] = 499,
  [SMALL_STATE(21)] = 518,
  [SMALL_STATE(22)] = 539,
  [SMALL_STATE(23)] = 554,
  [SMALL_STATE(24)] = 573,
  [SMALL_STATE(25)] = 596,
  [SMALL_STATE(26)] = 608,
  [SMALL_STATE(27)] = 628,
  [SMALL_STATE(28)] = 642,
  [SMALL_STATE(29)] = 656,
  [SMALL_STATE(30)] = 670,
  [SMALL_STATE(31)] = 682,
  [SMALL_STATE(32)] = 700,
  [SMALL_STATE(33)] = 712,
  [SMALL_STATE(34)] = 724,
  [SMALL_STATE(35)] = 742,
  [SMALL_STATE(36)] = 756,
  [SMALL_STATE(37)] = 770,
  [SMALL_STATE(38)] = 784,
  [SMALL_STATE(39)] = 798,
  [SMALL_STATE(40)] = 810,
  [SMALL_STATE(41)] = 828,
  [SMALL_STATE(42)] = 846,
  [SMALL_STATE(43)] = 858,
  [SMALL_STATE(44)] = 870,
  [SMALL_STATE(45)] = 882,
  [SMALL_STATE(46)] = 896,
  [SMALL_STATE(47)] = 910,
  [SMALL_STATE(48)] = 924,
  [SMALL_STATE(49)] = 938,
  [SMALL_STATE(50)] = 949,
  [SMALL_STATE(51)] = 966,
  [SMALL_STATE(52)] = 977,
  [SMALL_STATE(53)] = 992,
  [SMALL_STATE(54)] = 1003,
  [SMALL_STATE(55)] = 1018,
  [SMALL_STATE(56)] = 1033,
  [SMALL_STATE(57)] = 1044,
  [SMALL_STATE(58)] = 1059,
  [SMALL_STATE(59)] = 1070,
  [SMALL_STATE(60)] = 1087,
  [SMALL_STATE(61)] = 1098,
  [SMALL_STATE(62)] = 1115,
  [SMALL_STATE(63)] = 1126,
  [SMALL_STATE(64)] = 1137,
  [SMALL_STATE(65)] = 1152,
  [SMALL_STATE(66)] = 1169,
  [SMALL_STATE(67)] = 1184,
  [SMALL_STATE(68)] = 1199,
  [SMALL_STATE(69)] = 1210,
  [SMALL_STATE(70)] = 1221,
  [SMALL_STATE(71)] = 1236,
  [SMALL_STATE(72)] = 1251,
  [SMALL_STATE(73)] = 1262,
  [SMALL_STATE(74)] = 1273,
  [SMALL_STATE(75)] = 1290,
  [SMALL_STATE(76)] = 1301,
  [SMALL_STATE(77)] = 1315,
  [SMALL_STATE(78)] = 1329,
  [SMALL_STATE(79)] = 1341,
  [SMALL_STATE(80)] = 1355,
  [SMALL_STATE(81)] = 1369,
  [SMALL_STATE(82)] = 1383,
  [SMALL_STATE(83)] = 1397,
  [SMALL_STATE(84)] = 1411,
  [SMALL_STATE(85)] = 1423,
  [SMALL_STATE(86)] = 1437,
  [SMALL_STATE(87)] = 1451,
  [SMALL_STATE(88)] = 1465,
  [SMALL_STATE(89)] = 1479,
  [SMALL_STATE(90)] = 1489,
  [SMALL_STATE(91)] = 1503,
  [SMALL_STATE(92)] = 1517,
  [SMALL_STATE(93)] = 1531,
  [SMALL_STATE(94)] = 1545,
  [SMALL_STATE(95)] = 1559,
  [SMALL_STATE(96)] = 1573,
  [SMALL_STATE(97)] = 1587,
  [SMALL_STATE(98)] = 1601,
  [SMALL_STATE(99)] = 1612,
  [SMALL_STATE(100)] = 1623,
  [SMALL_STATE(101)] = 1634,
  [SMALL_STATE(102)] = 1645,
  [SMALL_STATE(103)] = 1654,
  [SMALL_STATE(104)] = 1665,
  [SMALL_STATE(105)] = 1676,
  [SMALL_STATE(106)] = 1685,
  [SMALL_STATE(107)] = 1694,
  [SMALL_STATE(108)] = 1705,
  [SMALL_STATE(109)] = 1716,
  [SMALL_STATE(110)] = 1727,
  [SMALL_STATE(111)] = 1738,
  [SMALL_STATE(112)] = 1746,
  [SMALL_STATE(113)] = 1754,
  [SMALL_STATE(114)] = 1762,
  [SMALL_STATE(115)] = 1770,
  [SMALL_STATE(116)] = 1778,
  [SMALL_STATE(117)] = 1786,
  [SMALL_STATE(118)] = 1794,
  [SMALL_STATE(119)] = 1802,
  [SMALL_STATE(120)] = 1810,
  [SMALL_STATE(121)] = 1818,
  [SMALL_STATE(122)] = 1826,
  [SMALL_STATE(123)] = 1834,
  [SMALL_STATE(124)] = 1842,
  [SMALL_STATE(125)] = 1850,
  [SMALL_STATE(126)] = 1858,
  [SMALL_STATE(127)] = 1866,
  [SMALL_STATE(128)] = 1874,
  [SMALL_STATE(129)] = 1882,
  [SMALL_STATE(130)] = 1890,
  [SMALL_STATE(131)] = 1898,
  [SMALL_STATE(132)] = 1906,
  [SMALL_STATE(133)] = 1914,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [15] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_list, 2),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [29] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_list, 3),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [33] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__promises, 1),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [37] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__promises, 1),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [41] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(118),
  [44] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(133),
  [47] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(131),
  [50] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__promises, 2),
  [52] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__promises, 2),
  [54] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [56] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__promises_repeat1, 2), SHIFT_REPEAT(127),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__promises_repeat1, 2),
  [61] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__promises_repeat1, 2), SHIFT_REPEAT(24),
  [64] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__promises_repeat1, 2),
  [66] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_section, 1),
  [68] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bundle_section, 1),
  [70] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [72] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [76] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [78] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [80] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [82] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_guarded_body_attributes, 2),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_guarded_body_attributes, 1),
  [86] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_guarded_promises, 1),
  [88] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_guarded_promises, 1),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__right_value, 1),
  [92] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_body_block_body_repeat1, 2), SHIFT_REPEAT(127),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_body_block_body_repeat1, 2),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dollar_expression, 4, .production_id = 10),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 7, .production_id = 8),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 7, .production_id = 8),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 3, .production_id = 6),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 3, .production_id = 6),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_half_promise, 2),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_half_promise, 2),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bundle_section_repeat1, 2),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_bundle_section_repeat1, 2),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bundle_section_repeat1, 2), SHIFT_REPEAT(21),
  [134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 3, .production_id = 7),
  [138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_section, 3),
  [140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bundle_section, 3),
  [142] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 4, .production_id = 8),
  [144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 4, .production_id = 8),
  [146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 4, .production_id = 6),
  [148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 4, .production_id = 6),
  [150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 2, .production_id = 6),
  [152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 2, .production_id = 6),
  [154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_half_promise, 3),
  [156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_half_promise, 3),
  [158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dollar_expression, 4, .production_id = 9),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_section, 2),
  [162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bundle_section, 2),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_expression, 4, .production_id = 11),
  [166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 4, .production_id = 7),
  [168] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 5, .production_id = 8),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 5, .production_id = 8),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 5, .production_id = 6),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 5, .production_id = 6),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_half_promise, 4),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_half_promise, 4),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_promise, 6, .production_id = 8),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise, 6, .production_id = 8),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise_block_body, 2),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_promise_block_body_repeat1, 2),
  [188] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_promise_block_body_repeat1, 2), SHIFT_REPEAT(20),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_block, 5, .production_id = 3),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_block_body, 3),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_body_block_body_repeat2, 2),
  [199] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_block_body_repeat2, 2), SHIFT_REPEAT(20),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_block_body, 2),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_block, 4, .production_id = 3),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise_block_body, 3),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise_block, 4, .production_id = 2),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_block_body, 3),
  [220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bundle_block_body_repeat1, 2),
  [222] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bundle_block_body_repeat1, 2), SHIFT_REPEAT(14),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_list_repeat1, 2),
  [233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_list_repeat1, 2), SHIFT_REPEAT(7),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_block_body, 4),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_block, 4, .production_id = 1),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_list, 1),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_promise_block_body, 4),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bundle_block_body, 2),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_block, 5, .production_id = 1),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_guarded_promises, 2),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_guarded_promises, 2),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__body_attribute, 2),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__body_attribute, 2),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_promise_repeat1, 2),
  [298] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_promise_repeat1, 2), SHIFT_REPEAT(99),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(119),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3, .production_id = 5),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_promise_block_body_repeat1, 1, .production_id = 4),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 5),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [360] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_cfengine() {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
