# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v2.model_utils import (
    ModelNormal,
    cached_property,
)


def lazy_import():
    from datadog_api_client.v2.model.service_account_create_attributes import ServiceAccountCreateAttributes
    from datadog_api_client.v2.model.user_relationships import UserRelationships
    from datadog_api_client.v2.model.users_type import UsersType

    globals()["ServiceAccountCreateAttributes"] = ServiceAccountCreateAttributes
    globals()["UserRelationships"] = UserRelationships
    globals()["UsersType"] = UsersType


class ServiceAccountCreateData(ModelNormal):

    validations = {}

    @cached_property
    def openapi_types():
        lazy_import()
        return {
            "attributes": (ServiceAccountCreateAttributes,),
            "relationships": (UserRelationships,),
            "type": (UsersType,),
        }

    attribute_map = {
        "attributes": "attributes",
        "relationships": "relationships",
        "type": "type",
    }

    read_only_vars = {}

    def __init__(self, attributes, type, *args, **kwargs):
        """
        Object to create a service account User.

        :param attributes: Attributes of the created user.
        :type attributes: ServiceAccountCreateAttributes

        :param relationships: Relationships of the user object.
        :type relationships: UserRelationships, optional

        :param type: Users resource type.
        :type type: UsersType
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

        self.attributes = attributes
        self.type = type

    @classmethod
    def _from_openapi_data(cls, attributes, type, *args, **kwargs):
        """Helper creating a new instance from a response."""

        self = super(ServiceAccountCreateData, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        self.attributes = attributes
        self.type = type
        return self
