# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v2.model_utils import (
    ModelNormal,
    cached_property,
)


class Pagination(ModelNormal):

    validations = {}

    @cached_property
    def openapi_types():
        return {
            "total_count": (int,),
            "total_filtered_count": (int,),
        }

    attribute_map = {
        "total_count": "total_count",
        "total_filtered_count": "total_filtered_count",
    }

    read_only_vars = {}

    def __init__(self, *args, **kwargs):
        """
        Pagination object.

        :param total_count: Total count.
        :type total_count: int, optional

        :param total_filtered_count: Total count of elements matched by the filter.
        :type total_filtered_count: int, optional
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    def _from_openapi_data(cls, *args, **kwargs):
        """Helper creating a new instance from a response."""

        self = super(Pagination, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
