# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v2.model_utils import (
    ModelNormal,
    cached_property,
)


class LogsMetricFilter(ModelNormal):

    validations = {}

    @cached_property
    def openapi_types():
        return {
            "query": (str,),
        }

    attribute_map = {
        "query": "query",
    }

    read_only_vars = {}

    def __init__(self, *args, **kwargs):
        """
        The log-based metric filter. Logs matching this filter will be aggregated in this metric.

        :param query: The search query - following the log search syntax.
        :type query: str, optional
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    def _from_openapi_data(cls, *args, **kwargs):
        """Helper creating a new instance from a response."""

        self = super(LogsMetricFilter, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
