# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v2.model_utils import (
    ModelNormal,
    cached_property,
)


class APIKeyCreateAttributes(ModelNormal):

    validations = {}

    @cached_property
    def openapi_types():
        return {
            "name": (str,),
        }

    attribute_map = {
        "name": "name",
    }

    read_only_vars = {}

    def __init__(self, name, *args, **kwargs):
        """
        Attributes used to create an API Key.

        :param name: Name of the API key.
        :type name: str
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

        self.name = name

    @classmethod
    def _from_openapi_data(cls, name, *args, **kwargs):
        """Helper creating a new instance from a response."""

        self = super(APIKeyCreateAttributes, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        self.name = name
        return self
