# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (
    ModelNormal,
    cached_property,
)


def lazy_import():
    from datadog_api_client.v1.model.usage_rum_sessions_hour import UsageRumSessionsHour

    globals()["UsageRumSessionsHour"] = UsageRumSessionsHour


class UsageRumSessionsResponse(ModelNormal):

    validations = {}

    @cached_property
    def openapi_types():
        lazy_import()
        return {
            "usage": ([UsageRumSessionsHour],),
        }

    attribute_map = {
        "usage": "usage",
    }

    read_only_vars = {}

    def __init__(self, *args, **kwargs):
        """
        Response containing the number of RUM Sessions for each hour for a given organization.

        :param usage: Get hourly usage for RUM Sessions.
        :type usage: [UsageRumSessionsHour], optional
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    def _from_openapi_data(cls, *args, **kwargs):
        """Helper creating a new instance from a response."""

        self = super(UsageRumSessionsResponse, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
