"""
Create a new dashboard with timeseries widget containing style attributes
"""

from datadog_api_client.v1 import ApiClient, Configuration
from datadog_api_client.v1.api.dashboards_api import DashboardsApi
from datadog_api_client.v1.model.dashboard import Dashboard
from datadog_api_client.v1.model.dashboard_layout_type import DashboardLayoutType
from datadog_api_client.v1.model.timeseries_widget_definition import TimeseriesWidgetDefinition
from datadog_api_client.v1.model.timeseries_widget_definition_type import TimeseriesWidgetDefinitionType
from datadog_api_client.v1.model.timeseries_widget_request import TimeseriesWidgetRequest
from datadog_api_client.v1.model.widget import Widget
from datadog_api_client.v1.model.widget_display_type import WidgetDisplayType
from datadog_api_client.v1.model.widget_line_type import WidgetLineType
from datadog_api_client.v1.model.widget_line_width import WidgetLineWidth
from datadog_api_client.v1.model.widget_request_style import WidgetRequestStyle

body = Dashboard(
    layout_type=DashboardLayoutType("ordered"),
    title="Example-Create_a_new_dashboard_with_timeseries_widget_containing_style_attributes with timeseries widget",
    widgets=[
        Widget(
            definition=TimeseriesWidgetDefinition(
                type=TimeseriesWidgetDefinitionType("timeseries"),
                requests=[
                    TimeseriesWidgetRequest(
                        q="sum:trace.test.errors{env:prod,service:datadog-api-spec} by {resource_name}.as_count()",
                        on_right_yaxis=False,
                        style=WidgetRequestStyle(
                            palette="warm", line_type=WidgetLineType("solid"), line_width=WidgetLineWidth("normal")
                        ),
                        display_type=WidgetDisplayType("bars"),
                    )
                ],
            )
        )
    ],
)

configuration = Configuration()
with ApiClient(configuration) as api_client:
    api_instance = DashboardsApi(api_client)
    response = api_instance.create_dashboard(body=body)

    print(response)
