"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewRelicFunction = exports.Function = exports.addNewRelicLayer = exports.getNewRelicLayer = exports.NEW_RELIC_LAYERS_ACCOUNT_ID = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const env_1 = require("../../common/env");
const env = require("../../common/env");
const utils_1 = require("../../common/utils");
exports.NEW_RELIC_LAYERS_ACCOUNT_ID = '451483290750'; // AWS account id of NewRelic where exposed layers https://layers.newrelic-external.com/
function getNewRelicLayer(scope, functionName, layerName, layerVersion, region) {
    return lambda.LayerVersion.fromLayerVersionArn(scope, `new-relic-layer-${functionName}`, `arn:aws:lambda:${region}:${exports.NEW_RELIC_LAYERS_ACCOUNT_ID}:layer:${layerName}:${layerVersion}`);
}
exports.getNewRelicLayer = getNewRelicLayer;
function addNewRelicLayer(scope, lambdaFunction, props) {
    lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
        actions: ['secretsmanager:GetSecretValue'],
        resources: [`arn:aws:secretsmanager:eu-west-1:${env_1.CDK_ACCOUNT_ID}:secret:NEW_RELIC_LICENSE_KEY-??????`],
    }));
    lambdaFunction.addEnvironment('NEW_RELIC_ACCOUNT_ID', props.newRelicAccountId);
    lambdaFunction.addEnvironment('NEW_RELIC_LAMBDA_HANDLER', props.handler);
    lambdaFunction.addEnvironment('NEW_RELIC_LAMBDA_EXTENSION_ENABLED', 'true');
    if (props.newRelicwithExtensionSendLogs) {
        lambdaFunction.addEnvironment('NEW_RELIC_EXTENSION_SEND_FUNCTION_LOGS', 'true');
    }
    const layer = getNewRelicLayer(scope, lambdaFunction.functionName, props.newRelicLayerName, props.newRelicLayerVersion, env_1.CDK_REGION);
    lambdaFunction.addLayers(layer);
}
exports.addNewRelicLayer = addNewRelicLayer;
class Function extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.stage = props.stage;
        if (props.withBaseEnvironment) {
            this.addBaseEnvironment();
        }
        if (props.withBaseTags) {
            this.addBaseTags();
        }
    }
    addBaseTags() {
        utils_1.addBaseTags(this);
    }
    addBaseEnvironment() {
        this.addEnvironment('ENVIRONMENT', this.stage);
        this.addEnvironment('TIMESTAMP_DEPLOY_CDK', env.TIMESTAMP_DEPLOY_CDK);
        if (env.BUSINESS_UNIT) {
            this.addEnvironment('BUSINESS_UNIT', env.BUSINESS_UNIT);
        }
        if (env.DOMAIN) {
            this.addEnvironment('DOMAIN', env.DOMAIN);
        }
        if (env.REPOSITORY_NAME) {
            this.addEnvironment('REPOSITORY_NAME', env.REPOSITORY_NAME);
        }
        if (env.REPOSITORY_VERSION) {
            this.addEnvironment('REPOSITORY_VERSION', env.REPOSITORY_VERSION);
        }
    }
}
exports.Function = Function;
_a = JSII_RTTI_SYMBOL_1;
Function[_a] = { fqn: "neulabs-cdk-constructs.constructs.aws_lambda.Function", version: "0.1.8" };
class NewRelicFunction extends Function {
    constructor(scope, id, props) {
        const app_handler = props.handler;
        const handler = 'newrelic_lambda_wrapper.handler';
        super(scope, id, { ...props, handler });
        addNewRelicLayer(scope, this, {
            handler: app_handler,
            newRelicLayerName: props.newRelicLayerName,
            newRelicLayerVersion: props.newRelicLayerVersion,
            newRelicAccountId: props.newRelicAccountId,
            newRelicwithExtensionSendLogs: props.newRelicwithExtensionSendLogs,
        });
    }
}
exports.NewRelicFunction = NewRelicFunction;
_b = JSII_RTTI_SYMBOL_1;
NewRelicFunction[_b] = { fqn: "neulabs-cdk-constructs.constructs.aws_lambda.NewRelicFunction", version: "0.1.8" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvY29uc3RydWN0cy9hd3MtbGFtYmRhL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsMkNBQTJDO0FBQzNDLGlEQUFpRDtBQUVqRCwwQ0FBOEQ7QUFDOUQsd0NBQXdDO0FBQ3hDLDhDQUFpRDtBQUVwQyxRQUFBLDJCQUEyQixHQUFHLGNBQWMsQ0FBQyxDQUFDLHdGQUF3RjtBQXVCbkosU0FBZ0IsZ0JBQWdCLENBQUMsS0FBZ0IsRUFBRSxZQUFtQixFQUFFLFNBQWlCLEVBQUUsWUFBb0IsRUFBRSxNQUFjO0lBQzdILE9BQU8sTUFBTSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsQ0FDNUMsS0FBSyxFQUNMLG1CQUFtQixZQUFZLEVBQUUsRUFDakMsa0JBQWtCLE1BQU0sSUFBSSxtQ0FBMkIsVUFBVSxTQUFTLElBQUksWUFBWSxFQUFFLENBQzdGLENBQUM7QUFDSixDQUFDO0FBTkQsNENBTUM7QUFFRCxTQUFnQixnQkFBZ0IsQ0FBQyxLQUFnQixFQUFFLGNBQStCLEVBQUUsS0FBb0I7SUFDdEcsY0FBYyxDQUFDLGVBQWUsQ0FDNUIsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1FBQ3RCLE9BQU8sRUFBRSxDQUFDLCtCQUErQixDQUFDO1FBQzFDLFNBQVMsRUFBRSxDQUFDLG9DQUFvQyxvQkFBYyxzQ0FBc0MsQ0FBQztLQUN0RyxDQUFDLENBQ0gsQ0FBQztJQUVGLGNBQWMsQ0FBQyxjQUFjLENBQUMsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDL0UsY0FBYyxDQUFDLGNBQWMsQ0FBQywwQkFBMEIsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDekUsY0FBYyxDQUFDLGNBQWMsQ0FBQyxvQ0FBb0MsRUFBRSxNQUFNLENBQUMsQ0FBQztJQUM1RSxJQUFJLEtBQUssQ0FBQyw2QkFBNkIsRUFBRTtRQUN2QyxjQUFjLENBQUMsY0FBYyxDQUFDLHdDQUF3QyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0tBQ2pGO0lBRUQsTUFBTSxLQUFLLEdBQUcsZ0JBQWdCLENBQzVCLEtBQUssRUFDTCxjQUFjLENBQUMsWUFBWSxFQUMzQixLQUFLLENBQUMsaUJBQWlCLEVBQ3ZCLEtBQUssQ0FBQyxvQkFBb0IsRUFDMUIsZ0JBQVUsQ0FDWCxDQUFDO0lBRUYsY0FBYyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUNsQyxDQUFDO0FBeEJELDRDQXdCQztBQUVELE1BQWEsUUFBUyxTQUFRLE1BQU0sQ0FBQyxRQUFRO0lBRzNDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBb0I7UUFDNUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBRXpCLElBQUksS0FBSyxDQUFDLG1CQUFtQixFQUFFO1lBQzdCLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1NBQzNCO1FBRUQsSUFBSSxLQUFLLENBQUMsWUFBWSxFQUFFO1lBQ3RCLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztTQUNwQjtJQUNILENBQUM7SUFFRCxXQUFXO1FBQ1QsbUJBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNwQixDQUFDO0lBRUQsa0JBQWtCO1FBQ2hCLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUMvQyxJQUFJLENBQUMsY0FBYyxDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBRXRFLElBQUksR0FBRyxDQUFDLGFBQWEsRUFBRTtZQUNyQixJQUFJLENBQUMsY0FBYyxDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDekQ7UUFDRCxJQUFJLEdBQUcsQ0FBQyxNQUFNLEVBQUU7WUFDZCxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDM0M7UUFDRCxJQUFJLEdBQUcsQ0FBQyxlQUFlLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUM7U0FDN0Q7UUFDRCxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsRUFBRTtZQUMxQixJQUFJLENBQUMsY0FBYyxDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1NBQ25FO0lBQ0gsQ0FBQzs7QUFwQ0gsNEJBcUNDOzs7QUFFRCxNQUFhLGdCQUFpQixTQUFRLFFBQVE7SUFDNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxNQUFNLFdBQVcsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQ2xDLE1BQU0sT0FBTyxHQUFHLGlDQUFpQyxDQUFDO1FBRWxELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxLQUFLLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQztRQUV4QyxnQkFBZ0IsQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO1lBQzVCLE9BQU8sRUFBRSxXQUFXO1lBQ3BCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLG9CQUFvQjtZQUNoRCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLDZCQUE2QixFQUFFLEtBQUssQ0FBQyw2QkFBNkI7U0FDbkUsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFkSCw0Q0FlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ0RLX0FDQ09VTlRfSUQsIENES19SRUdJT04gfSBmcm9tICcuLi8uLi9jb21tb24vZW52JztcbmltcG9ydCAqIGFzIGVudiBmcm9tICcuLi8uLi9jb21tb24vZW52JztcbmltcG9ydCB7IGFkZEJhc2VUYWdzIH0gZnJvbSAnLi4vLi4vY29tbW9uL3V0aWxzJztcblxuZXhwb3J0IGNvbnN0IE5FV19SRUxJQ19MQVlFUlNfQUNDT1VOVF9JRCA9ICc0NTE0ODMyOTA3NTAnOyAvLyBBV1MgYWNjb3VudCBpZCBvZiBOZXdSZWxpYyB3aGVyZSBleHBvc2VkIGxheWVycyBodHRwczovL2xheWVycy5uZXdyZWxpYy1leHRlcm5hbC5jb20vXG5cbmV4cG9ydCBpbnRlcmZhY2UgRnVuY3Rpb25Qcm9wcyBleHRlbmRzIGxhbWJkYS5GdW5jdGlvblByb3BzIHtcbiAgcmVhZG9ubHkgc3RhZ2U6IHN0cmluZztcbiAgcmVhZG9ubHkgd2l0aEJhc2VFbnZpcm9ubWVudD86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHdpdGhCYXNlVGFncz86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRnVuY3Rpb25OZXdSZWxpY1Byb3BzIGV4dGVuZHMgRnVuY3Rpb25Qcm9wcyB7XG4gIHJlYWRvbmx5IG5ld1JlbGljTGF5ZXJOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5ld1JlbGljTGF5ZXJWZXJzaW9uOiBudW1iZXI7XG4gIHJlYWRvbmx5IG5ld1JlbGljQWNjb3VudElkOiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5ld1JlbGljd2l0aEV4dGVuc2lvblNlbmRMb2dzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBOZXdSZWxpY1Byb3BzIHtcbiAgcmVhZG9ubHkgaGFuZGxlcjogc3RyaW5nO1xuICByZWFkb25seSBuZXdSZWxpY0xheWVyTmFtZTogc3RyaW5nO1xuICByZWFkb25seSBuZXdSZWxpY0xheWVyVmVyc2lvbjogbnVtYmVyO1xuICByZWFkb25seSBuZXdSZWxpY0FjY291bnRJZDogc3RyaW5nO1xuICByZWFkb25seSBuZXdSZWxpY3dpdGhFeHRlbnNpb25TZW5kTG9ncz86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXROZXdSZWxpY0xheWVyKHNjb3BlOiBDb25zdHJ1Y3QsIGZ1bmN0aW9uTmFtZTpzdHJpbmcsIGxheWVyTmFtZTogc3RyaW5nLCBsYXllclZlcnNpb246IG51bWJlciwgcmVnaW9uOiBzdHJpbmcpIHtcbiAgcmV0dXJuIGxhbWJkYS5MYXllclZlcnNpb24uZnJvbUxheWVyVmVyc2lvbkFybihcbiAgICBzY29wZSxcbiAgICBgbmV3LXJlbGljLWxheWVyLSR7ZnVuY3Rpb25OYW1lfWAsXG4gICAgYGFybjphd3M6bGFtYmRhOiR7cmVnaW9ufToke05FV19SRUxJQ19MQVlFUlNfQUNDT1VOVF9JRH06bGF5ZXI6JHtsYXllck5hbWV9OiR7bGF5ZXJWZXJzaW9ufWAsXG4gICk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhZGROZXdSZWxpY0xheWVyKHNjb3BlOiBDb25zdHJ1Y3QsIGxhbWJkYUZ1bmN0aW9uOiBsYW1iZGEuRnVuY3Rpb24sIHByb3BzOiBOZXdSZWxpY1Byb3BzKSB7XG4gIGxhbWJkYUZ1bmN0aW9uLmFkZFRvUm9sZVBvbGljeShcbiAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ3NlY3JldHNtYW5hZ2VyOkdldFNlY3JldFZhbHVlJ10sXG4gICAgICByZXNvdXJjZXM6IFtgYXJuOmF3czpzZWNyZXRzbWFuYWdlcjpldS13ZXN0LTE6JHtDREtfQUNDT1VOVF9JRH06c2VjcmV0Ok5FV19SRUxJQ19MSUNFTlNFX0tFWS0/Pz8/Pz9gXSxcbiAgICB9KSxcbiAgKTtcblxuICBsYW1iZGFGdW5jdGlvbi5hZGRFbnZpcm9ubWVudCgnTkVXX1JFTElDX0FDQ09VTlRfSUQnLCBwcm9wcy5uZXdSZWxpY0FjY291bnRJZCk7XG4gIGxhbWJkYUZ1bmN0aW9uLmFkZEVudmlyb25tZW50KCdORVdfUkVMSUNfTEFNQkRBX0hBTkRMRVInLCBwcm9wcy5oYW5kbGVyKTtcbiAgbGFtYmRhRnVuY3Rpb24uYWRkRW52aXJvbm1lbnQoJ05FV19SRUxJQ19MQU1CREFfRVhURU5TSU9OX0VOQUJMRUQnLCAndHJ1ZScpO1xuICBpZiAocHJvcHMubmV3UmVsaWN3aXRoRXh0ZW5zaW9uU2VuZExvZ3MpIHtcbiAgICBsYW1iZGFGdW5jdGlvbi5hZGRFbnZpcm9ubWVudCgnTkVXX1JFTElDX0VYVEVOU0lPTl9TRU5EX0ZVTkNUSU9OX0xPR1MnLCAndHJ1ZScpO1xuICB9XG5cbiAgY29uc3QgbGF5ZXIgPSBnZXROZXdSZWxpY0xheWVyKFxuICAgIHNjb3BlLFxuICAgIGxhbWJkYUZ1bmN0aW9uLmZ1bmN0aW9uTmFtZSxcbiAgICBwcm9wcy5uZXdSZWxpY0xheWVyTmFtZSxcbiAgICBwcm9wcy5uZXdSZWxpY0xheWVyVmVyc2lvbixcbiAgICBDREtfUkVHSU9OLFxuICApO1xuXG4gIGxhbWJkYUZ1bmN0aW9uLmFkZExheWVycyhsYXllcik7XG59XG5cbmV4cG9ydCBjbGFzcyBGdW5jdGlvbiBleHRlbmRzIGxhbWJkYS5GdW5jdGlvbiB7XG4gIHB1YmxpYyByZWFkb25seSBzdGFnZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBGdW5jdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5zdGFnZSA9IHByb3BzLnN0YWdlO1xuXG4gICAgaWYgKHByb3BzLndpdGhCYXNlRW52aXJvbm1lbnQpIHtcbiAgICAgIHRoaXMuYWRkQmFzZUVudmlyb25tZW50KCk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLndpdGhCYXNlVGFncykge1xuICAgICAgdGhpcy5hZGRCYXNlVGFncygpO1xuICAgIH1cbiAgfVxuXG4gIGFkZEJhc2VUYWdzKCkge1xuICAgIGFkZEJhc2VUYWdzKHRoaXMpO1xuICB9XG5cbiAgYWRkQmFzZUVudmlyb25tZW50KCkge1xuICAgIHRoaXMuYWRkRW52aXJvbm1lbnQoJ0VOVklST05NRU5UJywgdGhpcy5zdGFnZSk7XG4gICAgdGhpcy5hZGRFbnZpcm9ubWVudCgnVElNRVNUQU1QX0RFUExPWV9DREsnLCBlbnYuVElNRVNUQU1QX0RFUExPWV9DREspO1xuXG4gICAgaWYgKGVudi5CVVNJTkVTU19VTklUKSB7XG4gICAgICB0aGlzLmFkZEVudmlyb25tZW50KCdCVVNJTkVTU19VTklUJywgZW52LkJVU0lORVNTX1VOSVQpO1xuICAgIH1cbiAgICBpZiAoZW52LkRPTUFJTikge1xuICAgICAgdGhpcy5hZGRFbnZpcm9ubWVudCgnRE9NQUlOJywgZW52LkRPTUFJTik7XG4gICAgfVxuICAgIGlmIChlbnYuUkVQT1NJVE9SWV9OQU1FKSB7XG4gICAgICB0aGlzLmFkZEVudmlyb25tZW50KCdSRVBPU0lUT1JZX05BTUUnLCBlbnYuUkVQT1NJVE9SWV9OQU1FKTtcbiAgICB9XG4gICAgaWYgKGVudi5SRVBPU0lUT1JZX1ZFUlNJT04pIHtcbiAgICAgIHRoaXMuYWRkRW52aXJvbm1lbnQoJ1JFUE9TSVRPUllfVkVSU0lPTicsIGVudi5SRVBPU0lUT1JZX1ZFUlNJT04pO1xuICAgIH1cbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTmV3UmVsaWNGdW5jdGlvbiBleHRlbmRzIEZ1bmN0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEZ1bmN0aW9uTmV3UmVsaWNQcm9wcykge1xuICAgIGNvbnN0IGFwcF9oYW5kbGVyID0gcHJvcHMuaGFuZGxlcjtcbiAgICBjb25zdCBoYW5kbGVyID0gJ25ld3JlbGljX2xhbWJkYV93cmFwcGVyLmhhbmRsZXInO1xuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7IC4uLnByb3BzLCBoYW5kbGVyIH0pO1xuXG4gICAgYWRkTmV3UmVsaWNMYXllcihzY29wZSwgdGhpcywge1xuICAgICAgaGFuZGxlcjogYXBwX2hhbmRsZXIsXG4gICAgICBuZXdSZWxpY0xheWVyTmFtZTogcHJvcHMubmV3UmVsaWNMYXllck5hbWUsXG4gICAgICBuZXdSZWxpY0xheWVyVmVyc2lvbjogcHJvcHMubmV3UmVsaWNMYXllclZlcnNpb24sXG4gICAgICBuZXdSZWxpY0FjY291bnRJZDogcHJvcHMubmV3UmVsaWNBY2NvdW50SWQsXG4gICAgICBuZXdSZWxpY3dpdGhFeHRlbnNpb25TZW5kTG9nczogcHJvcHMubmV3UmVsaWN3aXRoRXh0ZW5zaW9uU2VuZExvZ3MsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==