/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import java.util.Arrays;

class ShapBuffers {
    private final double[] shapRowCacheForInputs;
    private final double[][] shapRowCacheForOutputs;
    private final int[] iindices;

    public ShapBuffers(MojoTransform transform2) {
        this.iindices = transform2.iindices;
        this.shapRowCacheForInputs = new double[this.iindices.length];
        this.shapRowCacheForOutputs = new double[transform2.oindices.length][];
        for (int i2 = 0; i2 < this.shapRowCacheForOutputs.length; ++i2) {
            this.shapRowCacheForOutputs[i2] = new double[this.iindices.length + 1];
        }
    }

    public double[] prepareShapInputs(MojoFrame globalFrame, int rowIndex) {
        for (int i2 = 0; i2 < this.iindices.length; ++i2) {
            double d2;
            int n2 = this.iindices[i2];
            MojoColumn.Type type = globalFrame.getColumnType(n2);
            switch (type) {
                case Float32: {
                    d2 = ((float[])globalFrame.getColumnData(n2))[rowIndex];
                    break;
                }
                case Float64: {
                    d2 = ((double[])globalFrame.getColumnData(n2))[rowIndex];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("cannot do SHAP on %s:%s", new Object[]{globalFrame.getColumnName(n2), type}));
                }
            }
            this.shapRowCacheForInputs[i2] = d2;
        }
        return this.shapRowCacheForInputs;
    }

    public double[][] prepareShapOutputs() {
        double[][] dArray = this.shapRowCacheForOutputs;
        int n2 = this.shapRowCacheForOutputs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] dArray2 = dArray[i2];
            Arrays.fill(dArray2, Double.NaN);
        }
        return this.shapRowCacheForOutputs;
    }
}

