# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-i2c-interface-generator 0.2.0
# Product:      SVM40
# Version:      0.3.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_i2c_driver import SensirionI2cCommand, CrcCalculator
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class Svm40I2cCmdBase(SensirionI2cCommand):
    """
    SVM40 I²C base command.
    """
    def __init__(self, command, tx_data, rx_length, read_delay, timeout,
                 post_processing_time=0.0):
        """
        Constructs a new SVM40 I²C command.

        :param int/None command:
            The command ID to be sent to the device. None means that no
            command will be sent, i.e. only ``tx_data`` (if not None) will
            be sent. No CRC is added to these bytes since the command ID
            usually already contains a CRC.
        :param bytes-like/list/None tx_data:
            Bytes to be extended with CRCs and then sent to the I²C device.
            None means that no write header will be sent at all (if ``command``
            is None too). An empty list means to send the write header (even if
            ``command`` is None), but without data following it.
        :param int/None rx_length:
            Number of bytes to be read from the I²C device, including CRC
            bytes. None means that no read header is sent at all. Zero means
            to send the read header, but without reading any data.
        :param float read_delay:
            Delay (in Seconds) to be inserted between the end of the write
            operation and the beginning of the read operation. This is needed
            if the device needs some time to prepare the RX data, e.g. if it
            has to perform a measurement. Set to 0.0 to indicate that no delay
            is needed, i.e. the device does not need any processing time.
        :param float timeout:
            Timeout (in Seconds) to be used in case of clock stretching. If the
            device stretches the clock longer than this value, the transceive
            operation will be aborted with a timeout error. Set to 0.0 to
            indicate that the device will not stretch the clock for this
            command.
        :param float post_processing_time:
            Maximum time in seconds the device needs for post processing of
            this command until it is ready to receive the next command. For
            example after a device reset command, the device might need some
            time until it is ready again. Usually this is 0.0s, i.e. no post
            processing is needed.
        """
        super(Svm40I2cCmdBase, self).__init__(
            command=command,
            tx_data=tx_data,
            rx_length=rx_length,
            read_delay=read_delay,
            timeout=timeout,
            crc=CrcCalculator(8, 0x31, 0xFF, 0x00),
            command_bytes=2,
            post_processing_time=post_processing_time,
        )

class Svm40I2cCmdStartContinuousMeasurement(Svm40I2cCmdBase):
    """
    Start Continuous Measurement I²C Command

    Starts continuous measurement in polling mode.

    .. note:: This command is only available in idle mode.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdStartContinuousMeasurement, self).__init__(
            command=0x0010,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.001,
        )


class Svm40I2cCmdStopMeasurement(Svm40I2cCmdBase):
    """
    Stop Measurement I²C Command

    Stops the measurement mode and returns to idle mode.

    .. note:: This command is only available in measurement mode.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdStopMeasurement, self).__init__(
            command=0x0104,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.05,
        )


class Svm40I2cCmdReadMeasuredValuesAsIntegers(Svm40I2cCmdBase):
    """
    Read Measured Values As Integers I²C Command

    Returns the new measurement results as integers.

    .. note:: This command is only available in measurement mode. The firmware
              updates the measurement values every second. Polling data with a
              faster sampling rate will return the same values. The first
              measurement is available 1 second after the start measurement
              command is issued. Any readout prior to this will return zero
              initialized values.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdReadMeasuredValuesAsIntegers, self).__init__(
            command=0x03A6,
            tx_data=None,
            rx_length=9,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - voc_index (int) -
              VOC algorithm output with a scaling value of 10.
            - humidity (int) -
              Compensated ambient humidity in % RH with a scaling factor of
              100.
            - temperature (int) -
              Compensated ambient temperature in degrees celsius with a scaling
              of 200.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        voc_index = int(unpack(">h", checked_data[0:2])[0])  # int16
        humidity = int(unpack(">h", checked_data[2:4])[0])  # int16
        temperature = int(unpack(">h", checked_data[4:6])[0])  # int16
        return voc_index, \
            humidity, \
            temperature


class Svm40I2cCmdReadMeasuredValuesAsIntegersWithRawParameters(Svm40I2cCmdBase):
    """
    Read Measured Values As Integers With Raw Parameters I²C Command

    Returns the new measurement results as integers with raw values added.

    .. note:: This command is only available in measurement mode. The firmware
              updates the measurement values every second. Polling data with a
              faster sampling rate will return the same values. The first
              measurement is available 1 second after the start measurement
              command is issued. Any readout prior to this will return zero
              initialized values.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdReadMeasuredValuesAsIntegersWithRawParameters, self).__init__(
            command=0x03B0,
            tx_data=None,
            rx_length=18,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - voc_index (int) -
              VOC algorithm output with a scaling value of 10.
            - humidity (int) -
              Compensated ambient humidity in % RH with a scaling factor of
              100.
            - temperature (int) -
              Compensated ambient temperature in degrees celsius with a scaling
              of 200.
            - raw_voc_ticks (int) -
              Raw VOC output ticks as read from the SGP sensor.
            - raw_humidity (int) -
              Uncompensated raw humidity in % RH as read from the SHT40 with a
              scaling factor of 100.
            - raw_temperature (int) -
              Uncompensated raw temperature in degrees celsius as read from the
              SHT40 with a scaling of 200.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        voc_index = int(unpack(">h", checked_data[0:2])[0])  # int16
        humidity = int(unpack(">h", checked_data[2:4])[0])  # int16
        temperature = int(unpack(">h", checked_data[4:6])[0])  # int16
        raw_voc_ticks = int(unpack(">H", checked_data[6:8])[0])  # uint16
        raw_humidity = int(unpack(">h", checked_data[8:10])[0])  # int16
        raw_temperature = int(unpack(">h", checked_data[10:12])[0])  # int16
        return voc_index, \
            humidity, \
            temperature, \
            raw_voc_ticks, \
            raw_humidity, \
            raw_temperature


class Svm40I2cCmdGetTemperatureOffsetForRhtMeasurements(Svm40I2cCmdBase):
    """
    Get Temperature Offset For Rht Measurements I²C Command

    Gets the T-Offset for the temperature compensation of the RHT algorithm.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdGetTemperatureOffsetForRhtMeasurements, self).__init__(
            command=0x6014,
            tx_data=None,
            rx_length=3,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return: Temperature offset in degrees celsius with a scaling of 200.
        :rtype: int
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        t_offset = int(unpack(">h", checked_data[0:2])[0])  # int16
        return t_offset


class Svm40I2cCmdSetTemperatureOffsetForRhtMeasurements(Svm40I2cCmdBase):
    """
    Set Temperature Offset For Rht Measurements I²C Command

    Sets the T-Offset for the temperature compensation of the RHT algorithm.
    """

    def __init__(self, t_offset):
        """
        Constructor.

        :param int t_offset:
            Temperature offset in degrees celsius with a scaling of 200.
        """
        super(Svm40I2cCmdSetTemperatureOffsetForRhtMeasurements, self).__init__(
            command=0x6014,
            tx_data=b"".join([pack(">h", t_offset)]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.0,
        )


class Svm40I2cCmdGetVocAlgorithmTuningParameters(Svm40I2cCmdBase):
    """
    Get Voc Algorithm Tuning Parameters I²C Command

    Gets the currently set parameters for customizing the VOC algorithm
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdGetVocAlgorithmTuningParameters, self).__init__(
            command=0x6083,
            tx_data=None,
            rx_length=12,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - voc_index_offset (int) -
              VOC index representing typical (average) conditions. The default
              value is 100.
            - learning_time_hours (int) -
              Time constant of long-term estimator in hours. Past events will
              be forgotten after about twice the learning time. The default
              value is 12 hours.
            - gating_max_duration_minutes (int) -
              Maximum duration of gating in minutes (freeze of estimator during
              high VOC index signal). Zero disables the gating. The default
              value is 180 minutes.
            - std_initial (int) -
              Initial estimate for standard deviation. Lower value boosts
              events during initial learning period, but may result in larger
              device-to-device variations. The default value is 50.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        voc_index_offset = int(unpack(">h", checked_data[0:2])[0])  # int16
        learning_time_hours = int(unpack(">h", checked_data[2:4])[0])  # int16
        gating_max_duration_minutes = int(unpack(">h", checked_data[4:6])[0])  # int16
        std_initial = int(unpack(">h", checked_data[6:8])[0])  # int16
        return voc_index_offset, \
            learning_time_hours, \
            gating_max_duration_minutes, \
            std_initial


class Svm40I2cCmdSetVocAlgorithmTuningParameters(Svm40I2cCmdBase):
    """
    Set Voc Algorithm Tuning Parameters I²C Command

    Sets the parameters to customize the VOC algorithm. This command is only
    available in idle mode.
    """

    def __init__(self, voc_index_offset, learning_time_hours, gating_max_duration_minutes, std_initial):
        """
        Constructor.

        :param int voc_index_offset:
            VOC index representing typical (average) conditions. The default
            value is 100.
        :param int learning_time_hours:
            Time constant of long-term estimator in hours. Past events will be
            forgotten after about twice the learning time. The default value is
            12 hours.
        :param int gating_max_duration_minutes:
            Maximum duration of gating in minutes (freeze of estimator during
            high VOC index signal). Set to zero to disable the gating. The
            default value is 180 minutes.
        :param int std_initial:
            Initial estimate for standard deviation. Lower value boosts events
            during initial learning period, but may result in larger
            device-to-device variations. The default value is 50.
        """
        super(Svm40I2cCmdSetVocAlgorithmTuningParameters, self).__init__(
            command=0x6083,
            tx_data=b"".join([pack(">h", voc_index_offset),
                           pack(">h", learning_time_hours),
                           pack(">h", gating_max_duration_minutes),
                           pack(">h", std_initial)]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.0,
        )


class Svm40I2cCmdStoreNvData(Svm40I2cCmdBase):
    """
    Store Nv Data I²C Command

    Stores all algorithm parameters to the non-volatile memory.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdStoreNvData, self).__init__(
            command=0x6002,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.5,
        )


class Svm40I2cCmdGetVocAlgorithmState(Svm40I2cCmdBase):
    """
    Get Voc Algorithm State I²C Command

    Gets the current VOC algorithm state.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdGetVocAlgorithmState, self).__init__(
            command=0x6181,
            tx_data=None,
            rx_length=12,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return: Current VOC algorithm state.
        :rtype: list(int)
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        state = [int(ii) for ii in unpack(">{}B".format(len(checked_data[0:8]) // 1), checked_data[0:8])]  # list(uint8)
        return state


class Svm40I2cCmdSetVocAlgorithmState(Svm40I2cCmdBase):
    """
    Set Voc Algorithm State I²C Command

    Sets the VOC algorithm state. This command is only available in idle mode.
    """

    def __init__(self, state):
        """
        Constructor.

        :param list(int) state:
            Current VOC algorithm state.
        """
        super(Svm40I2cCmdSetVocAlgorithmState, self).__init__(
            command=0x6181,
            tx_data=b"".join([pack(">{}B".format(len(state)), *state)]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.0,
        )


class Svm40I2cCmdGetVersion(Svm40I2cCmdBase):
    """
    Get Version I²C Command

    Gets the version information for the hardware, firmware and protocol.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdGetVersion, self).__init__(
            command=0xD100,
            tx_data=None,
            rx_length=12,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - firmware_major (int) -
              Firmware major version number.
            - firmware_minor (int) -
              Firmware minor version number.
            - firmware_debug (bool) -
              Firmware debug state. If the debug state is set, the firmware is
              in development.
            - hardware_major (int) -
              Hardware major version number.
            - hardware_minor (int) -
              Hardware minor version number.
            - protocol_major (int) -
              Protocol major version number.
            - protocol_minor (int) -
              Protocol minor version number.
            - padding (int) -
              Padding byte, ignore this.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        firmware_major = int(unpack(">B", checked_data[0:1])[0])  # uint8
        firmware_minor = int(unpack(">B", checked_data[1:2])[0])  # uint8
        firmware_debug = bool(unpack(">?", checked_data[2:3])[0])  # bool
        hardware_major = int(unpack(">B", checked_data[3:4])[0])  # uint8
        hardware_minor = int(unpack(">B", checked_data[4:5])[0])  # uint8
        protocol_major = int(unpack(">B", checked_data[5:6])[0])  # uint8
        protocol_minor = int(unpack(">B", checked_data[6:7])[0])  # uint8
        padding = int(unpack(">B", checked_data[7:8])[0])  # uint8
        return firmware_major, \
            firmware_minor, \
            firmware_debug, \
            hardware_major, \
            hardware_minor, \
            protocol_major, \
            protocol_minor, \
            padding


class Svm40I2cCmdGetSerialNumber(Svm40I2cCmdBase):
    """
    Get Serial Number I²C Command

    Gets the serial number from the device.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdGetSerialNumber, self).__init__(
            command=0xD033,
            tx_data=None,
            rx_length=39,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return: Ascii string containing the serial number. The string has the
                 null-termination character included.
        :rtype: str
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm40I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        serial_number = str(checked_data[0:].decode('utf-8').rstrip('\0'))  # string<..26>
        return serial_number


class Svm40I2cCmdDeviceReset(Svm40I2cCmdBase):
    """
    Device Reset I²C Command

    Executs a reset on the device.

    .. note:: The device will reply before executing the reset.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm40I2cCmdDeviceReset, self).__init__(
            command=0xD304,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.1,
        )

