# kplot theme finding and execution "library"

# for path finding
from glob import glob
import sys

# findpath: gets the path to the given theme, using `glob`
# Arguments:
#    str `style`: name of the style, with no extension or path information

# Returns:
#    if valid path found: path to theme
#    else: no return value

# Other Actions:
#    none

def findpath(style):
    for p in sys.path:
        search = glob(p+'*/kplot/styles/'+style+'.mplstyle')
        if len(search) == 1:
            return search[0]

# loadtheme: takes a path (as generated by findpath) and sets the current style with it
# Arguments:
#    str `path`: path to matplotlib style

# Returns: 
#    none

# Other Actions:
#    Sets the theme using the passed theme path.
def loadtheme(path):
    import kplot.lib
    import matplotlib.pyplot as plt
    s = kplot.lib.findpath(path)
    plt.style.use(s)
