"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const glue_generated_1 = require("./glue.generated");
/**
 * A Glue database.
 */
class Database extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.databaseName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_DatabaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Database);
            }
            throw error;
        }
        let databaseInput = {
            name: props.databaseName,
        };
        if (props.locationUri !== undefined) {
            validateLocationUri(props.locationUri);
            this.locationUri = props.locationUri;
            databaseInput = {
                locationUri: this.locationUri,
                ...databaseInput,
            };
        }
        this.catalogId = core_1.Stack.of(this).account;
        const resource = new glue_generated_1.CfnDatabase(this, 'Resource', {
            catalogId: this.catalogId,
            databaseInput,
        });
        // see https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html#data-catalog-resource-arns
        this.databaseName = this.getResourceNameAttribute(resource.ref);
        this.databaseArn = this.stack.formatArn({
            service: 'glue',
            resource: 'database',
            resourceName: this.databaseName,
        });
        // catalogId is implicitly the accountId, which is why we don't pass the catalogId here
        this.catalogArn = core_1.Stack.of(this).formatArn({
            service: 'glue',
            resource: 'catalog',
        });
    }
    static fromDatabaseArn(scope, id, databaseArn) {
        const stack = core_1.Stack.of(scope);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.databaseArn = databaseArn;
                this.databaseName = stack.splitArn(databaseArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
                this.catalogArn = stack.formatArn({ service: 'glue', resource: 'catalog' });
                this.catalogId = stack.account;
            }
        }
        return new Import(scope, id);
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "@aws-cdk/aws-glue.Database", version: "1.198.0" };
function validateLocationUri(locationUri) {
    if (locationUri.length < 1 || locationUri.length > 1024) {
        throw new Error(`locationUri length must be (inclusively) between 1 and 1024, but was ${locationUri.length}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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