#!/usr/bin/env python 
# -*- coding: utf-8 -*-

#-----------------------------------------------------------------------------
# Copyright (c) 2013-2014, NeXpy Development Team.
#
# Distributed under the terms of the Modified BSD License.
#
# The full license is in the file COPYING, distributed with this software.
#-----------------------------------------------------------------------------

__package_name__ = u'NeXpy'
from ._version import get_versions
__version__ = get_versions()['version']
del get_versions

__documentation_author__ = u'Ray Osborn'
__documentation_copyright__ = u'2013-2020, Ray Osborn'

__license__ = u'BSD'
__author_name__ = u'NeXpy Development Team'
__author_email__ = u'nexpydev@gmail.com'
__author__ = __author_name__ + u' <' + __author_email__ + u'>'

__url__          = u'http://nexpy.github.io/nexpy/'
__download_url__ = u'https://github.com/nexpy/nexpy/'

__description__ = u'NeXpy: A Python GUI to analyze NeXus data'
__long_description__ = \
u"""
NeXpy provides a high-level python interface to `NeXus data 
<http://www.nexusformat.org/>`_ contained within a simple GUI. It is designed to 
provide an intuitive interactive toolbox allowing users both to access existing 
NeXus files and to create new NeXus-conforming data structures without expert 
knowledge of the file format.

The latest development version is always available from `NeXpy's GitHub
site <https://github.com/nexpy/nexpy>`_.
"""
