/*
 * Decompiled with CFR 0.152.
 */
package org.happy.concurrent.synchronizers.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.concurrent.synchronizers.MultiLock_1x3;
import org.happy.concurrent.synchronizers.impl.AbstractMultiLock_1x3;
import org.happy.concurrent.synchronizers.impl.AbstractSynchronizer_1x3;

public class FIFOSynchronizer_1x3<L>
extends AbstractSynchronizer_1x3<L> {
    @Override
    protected AbstractMultiLock_1x3<L> createMultiLock(AbstractMultiLock_1x3<L> parent) {
        if (parent == null) {
            return new FIFOMultiLock_1x3();
        }
        return new FIFOMultiLock_1x3(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lock(final AbstractMultiLock_1x3<L> mLock) {
        Preconditions.checkNotNull(mLock);
        MultiLock_1x3 parent = mLock.getParent();
        if (parent != null) {
            mLock.setLevel(((AbstractMultiLock_1x3)parent).getLevel());
            mLock.setState(MultiLock_1x3.State_1x3.Running);
            return;
        }
        boolean dependenciesExists = false;
        final AtomicReference<Object> waitLatchReference = new AtomicReference<Object>(null);
        Object object = this.getLockObject();
        synchronized (object) {
            final HashMap dependenciesMap = new HashMap();
            for (Map.Entry<L, MultiLock_1x3.Permission_1x3> entry : mLock.getLocksMap().entrySet()) {
                Map locksMap = this.getLocksMap();
                L lock = entry.getKey();
                MultiLock_1x3.Permission_1x3 requiredPerm = entry.getValue();
                SortedSet activatedMultiLockSet = locksMap.get(lock);
                if (activatedMultiLockSet == null) {
                    activatedMultiLockSet = new TreeSet(this.multiLockLevelComparator);
                    locksMap.put(lock, activatedMultiLockSet);
                } else {
                    final AbstractMultiLock_1x3 highestLevelMultiLock = activatedMultiLockSet.last();
                    MultiLock_1x3.Permission_1x3 currentPerm = highestLevelMultiLock.getLocksMap().get(lock);
                    Preconditions.checkNotNull((Object)((Object)currentPerm));
                    if (!MultiLock_1x3.State_1x3.Finished.equals((Object)highestLevelMultiLock.getState()) && this.dependencyExists(requiredPerm, currentPerm)) {
                        if (dependenciesMap.keySet().contains(highestLevelMultiLock)) {
                            Set locksOfMLockSet = (Set)dependenciesMap.get(highestLevelMultiLock);
                            Preconditions.checkNotNull((Object)locksOfMLockSet);
                            locksOfMLockSet.add(lock);
                        } else {
                            HashSet<L> locksOfMLockSet = new HashSet<L>();
                            locksOfMLockSet.add(lock);
                            dependenciesMap.put(highestLevelMultiLock, locksOfMLockSet);
                            dependenciesExists = true;
                            highestLevelMultiLock.getOnPermissionChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<Map<L, MultiLock_1x3.Permission_1x3>>>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void actionPerformedImpl(ActionEventAfter_1x0<Map<L, MultiLock_1x3.Permission_1x3>> event) {
                                    Object object = FIFOSynchronizer_1x3.this.getLockObject();
                                    synchronized (object) {
                                        Map newPermissionsMap = event.getData();
                                        FIFOSynchronizer_1x3.this.removeDependencies(mLock, (CountDownLatch)waitLatchReference.get(), highestLevelMultiLock, newPermissionsMap, dependenciesMap);
                                    }
                                }
                            });
                        }
                    }
                    long level = highestLevelMultiLock.getLevel();
                    if (mLock.getLevel() <= level) {
                        mLock.setLevel(level + 1L);
                    }
                }
                activatedMultiLockSet.add(mLock);
            }
            waitLatchReference.set(new CountDownLatch(dependenciesMap.size()));
        }
        if (dependenciesExists) {
            try {
                ((CountDownLatch)waitLatchReference.get()).await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        mLock.setState(MultiLock_1x3.State_1x3.Running);
    }

    private void removeDependencies(AbstractMultiLock_1x3<L> mLock, CountDownLatch waitLatch, AbstractMultiLock_1x3<L> permissionChangedmLock, Map<L, MultiLock_1x3.Permission_1x3> newPermissionsMap, Map<AbstractMultiLock_1x3<L>, Set<L>> dependenciesMap) {
        Preconditions.checkNotNull(mLock);
        Preconditions.checkNotNull((Object)waitLatch);
        Preconditions.checkNotNull(permissionChangedmLock);
        Preconditions.checkNotNull(newPermissionsMap);
        Preconditions.checkNotNull(dependenciesMap);
        Set<L> locksOfMLockSet = dependenciesMap.get(permissionChangedmLock);
        Set<AbstractMultiLock_1x3<L>> dependencyMultiLockSet = mLock.getDependencyMultiLockSet();
        Iterator<L> it = locksOfMLockSet.iterator();
        while (it.hasNext()) {
            MultiLock_1x3.Permission_1x3 requiredPerm;
            L lock = it.next();
            MultiLock_1x3.Permission_1x3 newPerm = newPermissionsMap.get(lock);
            if (newPerm == null || this.dependencyExists(requiredPerm = mLock.getLocksMap().get(lock), newPerm)) continue;
            it.remove();
            if (!locksOfMLockSet.isEmpty()) continue;
            dependencyMultiLockSet.remove(permissionChangedmLock);
            if (!dependencyMultiLockSet.isEmpty()) continue;
            waitLatch.countDown();
        }
    }

    protected class FIFOMultiLock_1x3
    extends AbstractMultiLock_1x3<L> {
        public FIFOMultiLock_1x3() {
        }

        public FIFOMultiLock_1x3(AbstractMultiLock_1x3<L> parent) {
            super(parent);
        }

        @Override
        protected boolean permissionUpdateAllowed(MultiLock_1x3.Permission_1x3 newPermission, MultiLock_1x3.Permission_1x3 oldPermission) {
            Preconditions.checkNotNull((Object)((Object)newPermission));
            Preconditions.checkNotNull((Object)((Object)oldPermission));
            return newPermission.ordinal() <= oldPermission.ordinal();
        }
    }
}

