/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.util;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.activation.DataHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FileUtils_1x0 {
    private static final int BUFFSIZE = 1024;
    private static byte[] buff1 = new byte[1024];
    private static byte[] buff2 = new byte[1024];
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(DataHandler handler, File file, boolean append) throws IOException {
        Preconditions.checkNotNull((Object)handler, (Object)"data handler can't be null");
        Preconditions.checkNotNull((Object)file, (Object)"file which should be used to store data can't be null!");
        if (!file.exists() && !file.createNewFile()) {
            throw new IllegalArgumentException("file \"" + file.getCanonicalPath() + "\" could not be created!");
        }
        try (FileOutputStream outStream = new FileOutputStream(file, append);){
            handler.writeTo((OutputStream)outStream);
            outStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void close(InputStream iStream, OutputStream oStream) throws IOException {
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        finally {
            if (oStream != null) {
                oStream.close();
            }
        }
    }

    public static boolean isInputStreamContentEquals(InputStream is1, InputStream is2) {
        if (is1 == is2) {
            return true;
        }
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null || is2 == null) {
            return false;
        }
        try {
            int read1 = -1;
            int read2 = -1;
            do {
                int offset2;
                int offset1;
                for (offset1 = 0; offset1 < 1024 && (read1 = is1.read(buff1, offset1, 1024 - offset1)) >= 0; offset1 += read1) {
                }
                for (offset2 = 0; offset2 < 1024 && (read2 = is2.read(buff2, offset2, 1024 - offset2)) >= 0; offset2 += read2) {
                }
                if (offset1 != offset2) {
                    return false;
                }
                if (offset1 != 1024) {
                    Arrays.fill(buff1, offset1, 1024, (byte)0);
                    Arrays.fill(buff2, offset2, 1024, (byte)0);
                }
                if (Arrays.equals(buff1, buff2)) continue;
                return false;
            } while (read1 >= 0 && read2 >= 0);
            return read1 < 0 && read2 < 0;
        }
        catch (Exception ei) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileContentsEquals(File file01, File file02) {
        FileInputStream is1 = null;
        InputStream is2 = null;
        if (file01.length() != file02.length()) {
            return false;
        }
        if (0L == file01.length()) {
            return true;
        }
        try {
            is1 = new FileInputStream(file01);
            is2 = new FileInputStream(file02);
            boolean bl = FileUtils_1x0.isInputStreamContentEquals(is1, is2);
            return bl;
        }
        catch (Exception ei) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is1 != null) {
                    ((InputStream)is1).close();
                }
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (Exception ei2) {}
        }
    }

    public static boolean isFileContentsEquals(String file01URL, String file02URL) {
        return FileUtils_1x0.isFileContentsEquals(new File(file01URL), new File(file02URL));
    }

    public static File getOrCreateDir(String url) throws IOException {
        File dir = new File(url);
        if (dir.exists()) {
            return dir;
        }
        FileUtils.forceMkdir((File)dir);
        return dir;
    }

    public static File getOrCreateFile(String url) throws IOException {
        File file = new File(url);
        if (!file.exists()) {
            String dirUrl = FilenameUtils.getFullPath((String)url);
            FileUtils.forceMkdir((File)new File(dirUrl));
            file.createNewFile();
        }
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0);
        return file;
    }

    public static String convertBytesNumberToHumanReadableForm(long value) {
        long[] dividers = new long[]{0x10000000000L, 0x40000000L, 0x100000L, 1024L, 1L};
        String[] units = new String[]{"TB", "GB", "MB", "KB", "B"};
        if (value < 1L) {
            throw new IllegalArgumentException("Invalid file size: " + value);
        }
        String result = null;
        for (int i = 0; i < dividers.length; ++i) {
            long divider = dividers[i];
            if (value < divider) continue;
            result = FileUtils_1x0.format(value, divider, units[i]);
            break;
        }
        return result;
    }

    private static String format(long value, long divider, String unit) {
        double result = divider > 1L ? (double)value / (double)divider : (double)value;
        return new DecimalFormat("#,##0.#").format(result) + " " + unit;
    }

    public static File createChildFile(File dir, String fileName) {
        Preconditions.checkArgument((boolean)dir.exists(), (Object)"dir doesn't exist");
        Preconditions.checkArgument((boolean)dir.isDirectory(), (Object)"dir shold be a directory");
        try {
            return new File(dir.getCanonicalPath() + File.separator + fileName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("the file couldn't be created!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileToFile(File fin, File fout, boolean append) throws IOException {
        FileChannel inChannel = new FileInputStream(fin).getChannel();
        FileChannel outChannel = new FileOutputStream(fout, append).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                try {
                    inChannel.close();
                }
                catch (IOException ex) {}
            }
            if (outChannel != null) {
                try {
                    outChannel.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToFile(byte[] bytes, File fout, boolean append) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        FileOutputStream os = new FileOutputStream(fout, append);
        try {
            int b;
            while ((b = is.read()) != -1) {
                os.write(b);
            }
            os.flush();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static String concatPathAndFilename(String path, String filename, String separator) {
        Preconditions.checkNotNull((Object)filename, (Object)"filename was null");
        Preconditions.checkNotNull((Object)separator, (Object)"separator was null");
        Preconditions.checkArgument((!separator.isEmpty() ? 1 : 0) != 0, (Object)"separator was empty");
        if (path == null) {
            return filename;
        }
        String trimmedPath = path.trim();
        if (trimmedPath.length() == 0) {
            return filename;
        }
        String trimmedFilename = filename.trim();
        if (trimmedPath.endsWith(separator)) {
            return trimmedPath + trimmedFilename;
        }
        return trimmedPath + separator + trimmedFilename;
    }

    public static File[] listFiles(File srcDir, FileFilter filter) {
        Preconditions.checkNotNull((Object)srcDir, (Object)"source directory was empty");
        Preconditions.checkArgument((boolean)srcDir.isDirectory(), (Object)(srcDir + " is not a directory"));
        File[] files = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        return files;
    }
}

