/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.happy.commons.io.streams.decorators.InputStreamDecorator_1x2;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;

public class EventInputStream_1x2
extends InputStreamDecorator_1x2 {
    private AtomicInteger idCounter = new AtomicInteger(0);
    private AtomicBoolean isSubMethodCall = new AtomicBoolean(false);
    private Delegate_1x0<ActionEventAfter_1x0<Integer>> onReadEvent;
    private AtomicInteger allBytesReadedNumber = new AtomicInteger(0);

    public static EventInputStream_1x2 of(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        return new EventInputStream_1x2(is);
    }

    public EventInputStream_1x2(InputStream is) {
        super(is);
        Preconditions.checkNotNull((Object)is);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.isSubMethodCall.get()) {
            return this.decorated.read();
        }
        this.isSubMethodCall.set(true);
        int b = this.decorated.read();
        this.isSubMethodCall.set(false);
        if (-1 < b) {
            this.fireOnReadEvent(1);
        }
        return b;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isSubMethodCall.get()) {
            return this.decorated.read(b, off, len);
        }
        this.isSubMethodCall.set(true);
        int r = this.decorated.read(b, off, len);
        this.isSubMethodCall.set(false);
        if (0 < r) {
            this.fireOnReadEvent(r);
        }
        return r;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        if (this.isSubMethodCall.get()) {
            return this.decorated.read(b);
        }
        this.isSubMethodCall.set(true);
        int r = this.decorated.read(b);
        this.isSubMethodCall.set(false);
        if (0 < r) {
            this.fireOnReadEvent(r);
        }
        return r;
    }

    protected void fireOnReadEvent(int bytesNumber) {
        Preconditions.checkArgument((-1 < bytesNumber ? 1 : 0) != 0);
        if (this.onReadEvent == null) {
            return;
        }
        int totalBytesNumber = this.allBytesReadedNumber.addAndGet(bytesNumber);
        this.onReadEvent.fire(new ActionEventAfter_1x0<Integer>((Object)this, this.idCounter.getAndIncrement(), "READ BYTES NUMBER", new Integer(totalBytesNumber)));
    }

    public Delegate_1x0<ActionEventAfter_1x0<Integer>> getOnReadEvent() {
        if (this.onReadEvent == null) {
            this.onReadEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Integer>>();
        }
        return this.onReadEvent;
    }
}

