/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.concurrent.loops;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.happy.commons.concurrent.loops.ForEachTask_1x0;
import org.happy.commons.concurrent.loops.ForTask_1x0;
import org.happy.commons.concurrent.loops.Loop_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.util.ObjectPointer_1x0;

public class Parallel_1x0 {
    public static void For(int start, int end, ForTask_1x0 task) {
        Loop_1x0 loop = Parallel_1x0.createFor(start, end, task);
        loop.start();
        loop.join();
    }

    public static Loop_1x0 createFor(int start, int end, ForTask_1x0 task) {
        return Parallel_1x0.createFor(start, end, 1, task);
    }

    public static void For(int start, int end, int grain, ForTask_1x0 task) {
        Loop_1x0 loop = Parallel_1x0.createFor(start, end, grain, task);
        loop.start();
        loop.join();
    }

    public static void For(int start, int end, int grain, int numberOfThreads, ForTask_1x0 task) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be positive number bgger as zero!");
        }
        FJTaskRunnerGroup group = new FJTaskRunnerGroup(numberOfThreads);
        Loop_1x0 loop = Parallel_1x0.createFor(start, end, grain, group, task);
        loop.start();
        loop.join();
        group.interruptAll();
    }

    public static Loop_1x0 createFor(int start, int end, int grain, ForTask_1x0 task) {
        return Parallel_1x0.createFor(start, end, grain, Parallel_1x0.getTaskGroup(), task);
    }

    public static Loop_1x0 createFor(final int start, final int end, final int grain, final FJTaskRunnerGroup group, final ForTask_1x0 task) {
        if (grain < 1) {
            throw new IllegalArgumentException("grain must be bigger  then 0");
        }
        if (end <= start) {
            throw new IllegalArgumentException("start must be smaller as the end");
        }
        if (group == null) {
            throw new IllegalArgumentException("FJTaskRunnerGroup must be unequal to zero");
        }
        if (task == null) {
            throw new IllegalArgumentException("task must be unequal to zero");
        }
        final ObjectPointer_1x0<Boolean> canceled = new ObjectPointer_1x0<Boolean>(false);
        final AtomicInteger activeTaskNumber = new AtomicInteger(0);
        final AtomicBoolean finished = new AtomicBoolean(false);
        final AtomicBoolean allTaskStarted = new AtomicBoolean(false);
        final ObjectPointer_1x0<Object> onFinishedEvent = new ObjectPointer_1x0<Object>(null);
        final FJTask mainTask = new FJTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (int i = start; i < end; i += grain) {
                    final int tStart = i;
                    int tEndTemp = i + grain;
                    if (end < tEndTemp) {
                        tEndTemp = end;
                    }
                    final int tEnd = tEndTemp;
                    FJTask t = new FJTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            int taskNumber;
                            AtomicBoolean atomicBoolean;
                            for (int j = tStart; j < tEnd; ++j) {
                                if (((Boolean)canceled.getObject()).booleanValue()) {
                                    atomicBoolean = finished;
                                    synchronized (atomicBoolean) {
                                        finished.set(true);
                                        finished.notifyAll();
                                        this.fireOnFinishedEvent();
                                        break;
                                    }
                                }
                                task.iteration(j);
                            }
                            if ((taskNumber = activeTaskNumber.decrementAndGet()) == 0 && allTaskStarted.get()) {
                                atomicBoolean = finished;
                                synchronized (atomicBoolean) {
                                    finished.set(true);
                                    finished.notifyAll();
                                    this.fireOnFinishedEvent();
                                }
                            }
                        }
                    };
                    activeTaskNumber.incrementAndGet();
                    group.executeTask(t);
                    if (((Boolean)canceled.getObject()).booleanValue()) break;
                }
                allTaskStarted.set(true);
                if (activeTaskNumber.get() == 0) {
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        finished.set(true);
                        finished.notifyAll();
                        this.fireOnFinishedEvent();
                    }
                }
            }

            private void fireOnFinishedEvent() {
                if (onFinishedEvent.getObject() == null) {
                    return;
                }
                ((Delegate_1x0Impl)onFinishedEvent.getObject()).fire(new ActionEvent(this, 0, "Finished"));
            }
        };
        Loop_1x0 loop = new Loop_1x0(){
            private boolean started = false;

            @Override
            public synchronized void start() {
                this.started = true;
                group.executeTask(mainTask);
            }

            @Override
            public FJTaskRunnerGroup getTaskRunnerGroup() {
                return group;
            }

            @Override
            public Void cancel() {
                canceled.setObject(true);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void join() {
                Object object = this;
                synchronized (object) {
                    if (!this.started) {
                        this.start();
                    }
                }
                object = finished;
                synchronized (object) {
                    if (!finished.get()) {
                        try {
                            finished.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            throw new InternalError("thread was intterupted!");
                        }
                    }
                }
            }

            @Override
            public Delegate_1x0Impl<ActionEvent> getOnFinishedEvent() {
                if (onFinishedEvent.getObject() == null) {
                    onFinishedEvent.setObject(new Delegate_1x0Impl());
                }
                return (Delegate_1x0Impl)onFinishedEvent.getObject();
            }
        };
        return loop;
    }

    public static <E> void ForEach(E[] a, ForEachTask_1x0<E> task) {
        Parallel_1x0.createForEach(a, task).join();
    }

    public static <E> void ForEach(E[] a, int grain, ForEachTask_1x0<E> task) {
        Parallel_1x0.createForEach(a, grain, task).join();
    }

    public static <E> Loop_1x0 createForEach(E[] a, ForEachTask_1x0<E> task) {
        return Parallel_1x0.createForEach(a, Parallel_1x0.getTaskGroup(), task);
    }

    public static <E> Loop_1x0 createForEach(E[] a, FJTaskRunnerGroup group, ForEachTask_1x0<E> task) {
        return Parallel_1x0.createForEach(a, 1, group, task);
    }

    public static <E> Loop_1x0 createForEach(E[] a, int grain, ForEachTask_1x0<E> task) {
        return Parallel_1x0.createForEach(a, grain, Parallel_1x0.getTaskGroup(), task);
    }

    public static <E> Loop_1x0 createForEach(final E[] a, final int grain, FJTaskRunnerGroup group, final ForEachTask_1x0<E> task) {
        if (grain < 1) {
            throw new IllegalArgumentException("grain must be bigger as 0");
        }
        if (a == null) {
            throw new IllegalArgumentException("array can't be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("FJTaskRunnerGroup must be unequal to zero");
        }
        if (task == null) {
            throw new IllegalArgumentException("task must be unequal to zero");
        }
        int iterations = a.length / grain;
        if (a.length % grain != 0) {
            ++iterations;
        }
        Loop_1x0 loop = Parallel_1x0.createFor(0, iterations, new ForTask_1x0(){

            @Override
            public void iteration(int i) {
                int start = i * grain;
                int end = start + grain;
                if (a.length < end) {
                    end = a.length;
                }
                for (int j = start; j < end; ++j) {
                    Object e = a[j];
                    task.iteration(e);
                }
            }
        });
        return loop;
    }

    public static <E> void ForEach(Collection<E> c, ForEachTask_1x0<E> task) {
        Parallel_1x0.createForEach(c, task).join();
    }

    public static <E> Loop_1x0 createForEach(Collection<E> c, ForEachTask_1x0<E> task) {
        return Parallel_1x0.createForEach(c, Parallel_1x0.getTaskGroup(), task);
    }

    public static <E> Loop_1x0 createForEach(final Collection<E> c, final FJTaskRunnerGroup group, final ForEachTask_1x0<E> task) {
        if (c == null) {
            throw new IllegalArgumentException("collection must be unequal to zero");
        }
        if (group == null) {
            throw new IllegalArgumentException("FJTaskRunnerGroup must be unequal to zero");
        }
        if (task == null) {
            throw new IllegalArgumentException("task must be unequal to zero");
        }
        final ObjectPointer_1x0<Boolean> canceled = new ObjectPointer_1x0<Boolean>(false);
        final AtomicInteger activeTaskNumber = new AtomicInteger(0);
        final AtomicBoolean finished = new AtomicBoolean(false);
        final AtomicBoolean allTaskStarted = new AtomicBoolean(false);
        final ObjectPointer_1x0<Object> onFinishedEvent = new ObjectPointer_1x0<Object>(null);
        final FJTask mainTask = new FJTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (final Object e : c) {
                    FJTask t = new FJTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            task.iteration(e);
                            int taskNumber = activeTaskNumber.decrementAndGet();
                            if (((Boolean)canceled.getObject()).booleanValue() || taskNumber == 0 && allTaskStarted.get()) {
                                AtomicBoolean atomicBoolean = finished;
                                synchronized (atomicBoolean) {
                                    finished.set(true);
                                    finished.notifyAll();
                                    this.fireOnFinishedEvent();
                                }
                            }
                        }
                    };
                    activeTaskNumber.incrementAndGet();
                    group.executeTask(t);
                    if (!((Boolean)canceled.getObject()).booleanValue()) continue;
                    break;
                }
                allTaskStarted.set(true);
                if (activeTaskNumber.get() == 0) {
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        finished.set(true);
                        finished.notifyAll();
                        this.fireOnFinishedEvent();
                    }
                }
            }

            private void fireOnFinishedEvent() {
                if (onFinishedEvent.getObject() == null) {
                    return;
                }
                ((Delegate_1x0Impl)onFinishedEvent.getObject()).fire(new ActionEvent(this, 0, "Finished"));
            }
        };
        Loop_1x0 loopController = new Loop_1x0(){
            private boolean started = false;

            @Override
            public synchronized void start() {
                this.started = true;
                group.executeTask(mainTask);
            }

            @Override
            public FJTaskRunnerGroup getTaskRunnerGroup() {
                return group;
            }

            @Override
            public Void cancel() {
                canceled.setObject(true);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void join() {
                Object object = this;
                synchronized (object) {
                    if (!this.started) {
                        this.start();
                    }
                }
                object = finished;
                synchronized (object) {
                    if (!finished.get()) {
                        try {
                            finished.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            throw new InternalError("thread was intterupted!");
                        }
                    }
                }
            }

            @Override
            public Delegate_1x0Impl<ActionEvent> getOnFinishedEvent() {
                if (onFinishedEvent.getObject() == null) {
                    onFinishedEvent.setObject(new Delegate_1x0Impl());
                }
                return (Delegate_1x0Impl)onFinishedEvent.getObject();
            }
        };
        return loopController;
    }

    public static <E> void ForEach(List<E> list, int grain, ForEachTask_1x0<E> task) {
        Parallel_1x0.createForEach(list, grain, task).join();
    }

    public static <E> Loop_1x0 createForEach(List<E> list, int grain, ForEachTask_1x0<E> task) {
        return Parallel_1x0.createForEach(list, grain, Parallel_1x0.getTaskGroup(), task);
    }

    public static <E> Loop_1x0 createForEach(final List<E> list, final int grain, final FJTaskRunnerGroup group, final ForEachTask_1x0<E> task) {
        if (grain < 1) {
            throw new IllegalArgumentException("grain must be bigger  then 0");
        }
        if (list == null) {
            throw new IllegalArgumentException("the list must be unequal to zero");
        }
        if (group == null) {
            throw new IllegalArgumentException("FJTaskRunnerGroup must be unequal to zero");
        }
        if (task == null) {
            throw new IllegalArgumentException("task must be unequal to zero");
        }
        final ObjectPointer_1x0<Boolean> canceled = new ObjectPointer_1x0<Boolean>(false);
        final AtomicInteger activeTaskNumber = new AtomicInteger(0);
        final AtomicBoolean finished = new AtomicBoolean(false);
        final AtomicBoolean allTaskStarted = new AtomicBoolean(false);
        final ObjectPointer_1x0<Object> onFinishedEvent = new ObjectPointer_1x0<Object>(null);
        final FJTask mainTask = new FJTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int size = list.size();
                for (int index = 0; index < size; index += grain) {
                    final ListIterator it = list.listIterator(index);
                    FJTask t = new FJTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            for (int counter = 0; counter < grain && it.hasNext(); ++counter) {
                                Object e = it.next();
                                task.iteration(e);
                            }
                            int taskNumber = activeTaskNumber.decrementAndGet();
                            if (((Boolean)canceled.getObject()).booleanValue() || taskNumber == 0 && allTaskStarted.get()) {
                                AtomicBoolean atomicBoolean = finished;
                                synchronized (atomicBoolean) {
                                    finished.set(true);
                                    finished.notifyAll();
                                    this.fireOnFinishedEvent();
                                }
                            }
                        }
                    };
                    activeTaskNumber.incrementAndGet();
                    group.executeTask(t);
                }
                allTaskStarted.set(true);
                if (activeTaskNumber.get() == 0) {
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        finished.set(true);
                        finished.notifyAll();
                        this.fireOnFinishedEvent();
                    }
                }
            }

            private void fireOnFinishedEvent() {
                if (onFinishedEvent.getObject() == null) {
                    return;
                }
                ((Delegate_1x0Impl)onFinishedEvent.getObject()).fire(new ActionEvent(this, 0, "Finished"));
            }
        };
        Loop_1x0 loopController = new Loop_1x0(){
            private boolean started = false;

            @Override
            public synchronized void start() {
                this.started = true;
                group.executeTask(mainTask);
            }

            @Override
            public FJTaskRunnerGroup getTaskRunnerGroup() {
                return group;
            }

            @Override
            public Void cancel() {
                canceled.setObject(true);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void join() {
                Object object = this;
                synchronized (object) {
                    if (!this.started) {
                        this.start();
                    }
                }
                object = finished;
                synchronized (object) {
                    if (!finished.get()) {
                        try {
                            finished.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            throw new InternalError("thread was intterupted!");
                        }
                    }
                }
            }

            @Override
            public Delegate_1x0Impl<ActionEvent> getOnFinishedEvent() {
                if (onFinishedEvent.getObject() == null) {
                    onFinishedEvent.setObject(new Delegate_1x0Impl());
                }
                return (Delegate_1x0Impl)onFinishedEvent.getObject();
            }
        };
        return loopController;
    }

    private Parallel_1x0() {
    }

    public static FJTaskRunnerGroup getTaskGroup() {
        return SingletonHolder.group;
    }

    private static class SingletonHolder {
        private static final FJTaskRunnerGroup group = new FJTaskRunnerGroup(Runtime.getRuntime().availableProcessors());

        private SingletonHolder() {
        }
    }
}

