/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.happy.collections.maps.decorators.MapDecorator_1x0;
import org.happy.collections.sets.decorators.CacheSet_1x0;
import org.happy.commons.patterns.Cacheable_1x2;

public class CacheMap_1x2<K, V>
extends MapDecorator_1x0<K, V>
implements Cacheable_1x2 {
    protected AbstractMap<K, V> adapterMap;
    private CacheSet_1x0<Map.Entry<K, V>> adaptedCacheSet;

    public static <K, V> CacheMap_1x2<K, V> of(float cachesize, Map<K, V> map) {
        return new CacheMap_1x2<K, V>(cachesize, map);
    }

    public CacheMap_1x2(float cacheSize, final Map<K, V> map) {
        super(map);
        this.adaptedCacheSet = CacheSet_1x0.of(cacheSize, map.entrySet());
        this.adapterMap = new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return CacheMap_1x2.this.adaptedCacheSet;
            }

            @Override
            public V put(K key, V value) {
                CacheMap_1x2.this.adaptedCacheSet.getCache().remove(key);
                return map.put(key, value);
            }
        };
    }

    @Override
    public int size() {
        return this.adapterMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapterMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.adapterMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.adapterMap.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.adapterMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.adapterMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.adapterMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.adapterMap.putAll(m);
    }

    @Override
    public void clear() {
        this.adapterMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.adapterMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.adapterMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.adapterMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.adapterMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.adapterMap.hashCode();
    }

    @Override
    public String toString() {
        return this.adapterMap.toString();
    }

    public float getCacheSize() {
        return this.adaptedCacheSet.getCacheSize();
    }

    public void setCacheSize(float cacheSize) {
        this.adaptedCacheSet.setCacheSize(cacheSize);
    }

    public Map<Map.Entry<K, V>, Integer> getCache() {
        return this.adaptedCacheSet.getCache();
    }

    @Override
    public boolean refresh() {
        this.getCache().clear();
        return true;
    }
}

