/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.happy.collections.maps.EntryImpl_1x0;
import org.happy.collections.maps.decorators.MapDecorator_1x0;
import org.happy.commons.patterns.Commitable_1x0;
import org.happy.commons.patterns.Flushable_1x0;
import org.happy.commons.util.Pair_1x0;

public class BufferedMap_1x0<K, V>
extends MapDecorator_1x0<K, V>
implements Commitable_1x0<Boolean>,
Flushable_1x0<Void> {
    protected transient List<Pair_1x0<Map.Entry<K, V>, Operation>> commandList;
    protected transient Map<K, Pair_1x0<AtomicInteger, V>> keyMap = new HashMap<K, Pair_1x0<AtomicInteger, V>>();
    private int size;

    public static <K, V> BufferedMap_1x0<K, V> of(Map<K, V> map) {
        return new BufferedMap_1x0<K, V>(map);
    }

    public BufferedMap_1x0(Map<K, V> decorateable) {
        super(decorateable);
        this.commandList = new ArrayList<Pair_1x0<Map.Entry<K, V>, Operation>>();
    }

    protected Collection<Map.Entry<K, V>> createBufferSet() {
        HashMap<K, Map.Entry<K, V>> map = new HashMap<K, Map.Entry<K, V>>();
        for (Pair_1x0<Map.Entry<K, V>, Operation> command : this.commandList) {
            Map.Entry<K, V> entry = command.getFst();
            if (Operation.Put.equals((Object)command.getSnd())) {
                map.put(entry.getKey(), entry);
                continue;
            }
            map.remove(entry.getKey());
        }
        return map.values();
    }

    @Override
    public void setDecorated(Map<K, V> decorated) {
        this.flush();
        super.setDecorated(decorated);
        this.size = decorated.size();
    }

    protected void addCommand(K key, V value, Operation op) {
        this.commandList.add(new Pair_1x0<EntryImpl_1x0<K, V>, Operation>(new EntryImpl_1x0<K, V>(key, value), op));
        Pair_1x0<AtomicInteger, V> mapPair = this.keyMap.get(key);
        if (Operation.Put.equals((Object)op)) {
            if (mapPair == null) {
                this.keyMap.put(key, new Pair_1x0<AtomicInteger, V>(new AtomicInteger(1), value));
                if (!((Map)this.decorated).containsKey(key)) {
                    ++this.size;
                }
            } else {
                AtomicInteger number = mapPair.getFst();
                if (number.get() < 0 || number.get() == 0 && !((Map)this.decorated).containsKey(key)) {
                    ++this.size;
                    number.incrementAndGet();
                }
                mapPair.setSnd(value);
            }
        } else if (mapPair == null) {
            this.keyMap.put(key, new Pair_1x0<AtomicInteger, V>(new AtomicInteger(-1), value));
            if (((Map)this.decorated).containsKey(key)) {
                --this.size;
            }
        } else {
            AtomicInteger number = mapPair.getFst();
            if (0 < number.get() || number.get() == 0 && !((Map)this.decorated).containsKey(key)) {
                --this.size;
                number.decrementAndGet();
            }
        }
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Pair_1x0<AtomicInteger, V> mapPair = this.keyMap.get(key);
        if (mapPair != null) {
            int number = mapPair.getFst().get();
            if (0 < number) {
                return true;
            }
            if (number < 0) {
                return false;
            }
        }
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        Pair_1x0<AtomicInteger, V> mapPair = this.keyMap.get(key);
        if (mapPair != null) {
            int number = mapPair.getFst().get();
            if (0 < number) {
                return mapPair.getSnd();
            }
            if (number < 0) {
                return null;
            }
        }
        return super.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V put(K key, V value) {
        int number;
        V oldValue = null;
        Pair_1x0<AtomicInteger, V> mapPair = this.keyMap.get(key);
        oldValue = mapPair != null ? (0 < (number = mapPair.getFst().get()) ? (V)mapPair.getSnd() : null) : (V)super.get(key);
        this.addCommand(key, value, Operation.Put);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int number;
        V oldValue = null;
        Pair_1x0<AtomicInteger, V> mapPair = this.keyMap.get(key);
        oldValue = mapPair != null ? (0 < (number = mapPair.getFst().get()) ? (V)mapPair.getSnd() : null) : (V)super.get(key);
        this.addCommand(key, oldValue, Operation.Remove);
        return oldValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Iterator itDecorated = super.entrySet().iterator();
        final HashMap<K, Pair_1x0<AtomicInteger, V>> keyMapCopy = new HashMap<K, Pair_1x0<AtomicInteger, V>>();
        for (Map.Entry<K, Pair_1x0<AtomicInteger, V>> entry : this.keyMap.entrySet()) {
            keyMapCopy.put(entry.getKey(), new Pair_1x0<AtomicInteger, V>(new AtomicInteger(entry.getValue().getFst().get()), entry.getValue().getSnd()));
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator bufferIterator = BufferedMap_1x0.this.createBufferSet().iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    private Map.Entry<K, V> nextElem = null;
                    private boolean hasNextSolved = false;
                    private boolean hasNext = false;
                    private boolean nextExecuted = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.hasNextSolved) {
                            return this.hasNext;
                        }
                        try {
                            Pair_1x0 pair = null;
                            if (this.nextElem != null) {
                                pair = (Pair_1x0)keyMapCopy.get(this.nextElem.getKey());
                            }
                            while (itDecorated.hasNext()) {
                                this.nextElem = (Map.Entry)itDecorated.next();
                                if (pair != null && ((AtomicInteger)pair.getFst()).get() < 0) {
                                    ((AtomicInteger)pair.getFst()).decrementAndGet();
                                    continue;
                                }
                                this.hasNext = true;
                                boolean bl = true;
                                return bl;
                            }
                            this.hasNext = bufferIterator.hasNext();
                            if (this.hasNext) {
                                this.nextElem = (Map.Entry)bufferIterator.next();
                            }
                            boolean bl = this.hasNext;
                            return bl;
                        }
                        finally {
                            this.hasNextSolved = true;
                        }
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("no more lements, the iterator has riched the end!");
                        }
                        this.nextExecuted = true;
                        this.hasNextSolved = false;
                        return this.nextElem;
                    }

                    @Override
                    public void remove() {
                        if (!this.nextExecuted) {
                            throw new IllegalStateException("you have to excute iterator.next() before you can call remove() method");
                        }
                        Pair_1x0 pair = (Pair_1x0)keyMapCopy.get(this.nextElem);
                        if (pair != null) {
                            ((AtomicInteger)pair.getFst()).decrementAndGet();
                        }
                        BufferedMap_1x0.this.addCommand(this.nextElem.getKey(), this.nextElem.getValue(), Operation.Remove);
                        this.nextExecuted = false;
                    }
                };
            }

            @Override
            public int size() {
                return BufferedMap_1x0.this.size;
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator itDecorated = BufferedMap_1x0.this.entrySet().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return itDecorated.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)itDecorated.next();
                        if (entry != null) {
                            return entry.getKey();
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        itDecorated.remove();
                    }
                };
            }

            @Override
            public int size() {
                return BufferedMap_1x0.this.size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator itDecorated = BufferedMap_1x0.this.entrySet().iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return itDecorated.hasNext();
                    }

                    @Override
                    public V next() {
                        Map.Entry entry = (Map.Entry)itDecorated.next();
                        if (entry != null) {
                            return entry.getValue();
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        itDecorated.remove();
                    }
                };
            }

            @Override
            public int size() {
                return BufferedMap_1x0.this.size;
            }
        };
    }

    @Override
    public Void flush() {
        this.commandList.clear();
        this.keyMap.clear();
        this.size = ((Map)this.decorated).size();
        return null;
    }

    @Override
    public Boolean commit() {
        if (this.commandList.isEmpty()) {
            return true;
        }
        for (Pair_1x0<Map.Entry<K, V>, Operation> command : this.commandList) {
            if (Operation.Put.equals((Object)command.getSnd())) {
                ((Map)this.decorated).put(command.getFst().getKey(), command.getFst().getValue());
                continue;
            }
            ((Map)this.decorated).remove(command.getFst().getKey());
        }
        this.flush();
        return true;
    }

    protected static enum Operation {
        Put,
        Remove;

    }
}

