/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.lists.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.happy.collections.Collections_1x2;
import org.happy.collections.lists.decorators.ListDecorator_1x0;
import org.happy.collections.lists.decorators.iterators.ListIteratorDecorator_1x0;
import org.happy.commons.util.ObjectPointer_1x0;
import org.happy.commons.util.comparators.HashComparator_1x0;
import org.happy.commons.util.comparators.InvertComparator_1x0;

public class SortedList_1x0<E>
extends ListDecorator_1x0<E, List<E>> {
    protected final int minListSizeForArrayType = 128;
    private boolean inverted = false;
    private Comparator<E> comparator = null;
    private SortType type = null;

    public static <E> SortedList_1x0<E> of(List<E> list, Comparator<E> comparator) {
        return new SortedList_1x0<E>(list, comparator);
    }

    public static <E> SortedList_1x0<E> of(List<E> list, Comparator<E> comparator, boolean doSort) {
        return new SortedList_1x0<E>(list, comparator, doSort);
    }

    public static <E> SortedList_1x0<E> of(List<E> list, Comparator<E> comparator, SortType type) {
        return new SortedList_1x0<E>(list, comparator, type, false, true);
    }

    public static <E> SortedList_1x0<E> of(List<E> list, Comparator<E> comparator, SortType type, boolean inverted, boolean doSort) {
        return new SortedList_1x0<E>(list, comparator, type, inverted, doSort);
    }

    public SortedList_1x0(List<E> list) {
        this(list, new HashComparator_1x0());
    }

    public SortedList_1x0(List<E> list, Comparator<E> comparator) {
        this(list, comparator, SortType.Array, false, true);
    }

    public SortedList_1x0(List<E> list, Comparator<E> comparator, boolean doSort) {
        this(list, comparator, SortType.Array, false, doSort);
    }

    public SortedList_1x0(List<E> list, Comparator<E> comparator, SortType type, boolean inverted, boolean doSort) {
        super(list);
        this.comparator = comparator;
        if (inverted) {
            this.comparator = new InvertComparator_1x0<E>(comparator);
        }
        this.inverted = inverted;
        this.type = type;
        if (doSort) {
            Collections_1x2.sort(list, this.comparator);
        }
    }

    @Override
    public boolean add(E element) {
        if (this.size() < 128 || SortType.Linked.equals((Object)this.type)) {
            ListIterator<E> it = ((List)this.decorated).listIterator();
            while (it.hasNext()) {
                Object current = it.next();
                if (0 > this.comparator.compare(current, element)) continue;
                it.previous();
                it.add(element);
                return true;
            }
        } else {
            int index = this.findInsertionIndex_TypeArray((List)this.decorated, element, 0, ((List)this.decorated).size() - 1, new ObjectPointer_1x0<Integer>(0));
            int sz = this.size();
            Object last = ((List)this.decorated).get(sz - 1);
            if (index == sz || this.comparator.compare(last, element) < 0) {
                ((List)this.decorated).add(element);
            } else {
                ((List)this.decorated).add(index, element);
            }
            return true;
        }
        return ((List)this.decorated).add(element);
    }

    @Override
    public void add(int index, E element) {
        int result;
        if (0 < index && 0 < (result = this.comparator.compare(((List)this.decorated).get(index - 1), element))) {
            throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + element.toString() + "is bigger then " + ((List)this.decorated).get(index - 1).toString());
        }
        if (index < ((List)this.decorated).size() - 2 && 0 <= (result = this.comparator.compare(element, ((List)this.decorated).get(index + 1)))) {
            throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + element.toString() + "is smaller then " + ((List)this.decorated).get(index + 1).toString());
        }
        ((List)this.decorated).add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int result;
        if (c.isEmpty()) {
            return true;
        }
        ArrayList<E> list = new ArrayList<E>(c);
        Collections.sort(list, this.comparator);
        for (E elem : c) {
            list.add(elem);
        }
        Object firstElem = list.get(0);
        Object lastElem = list.get(list.size() - 1);
        if (0 < index && (result = this.comparator.compare(((List)this.decorated).get(index - 1), firstElem)) < 0) {
            throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + firstElem.toString() + "is bigger then " + ((List)this.decorated).get(index - 1).toString());
        }
        if (index < ((List)this.decorated).size() - 2 && 0 < (result = this.comparator.compare(lastElem, ((List)this.decorated).get(index + 1)))) {
            throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + lastElem.toString() + "is smaller then " + ((List)this.decorated).get(index + 1).toString());
        }
        return ((List)this.decorated).addAll(index, list);
    }

    @Override
    public E set(int index, E element) {
        int result;
        if (0 < index && 0 < (result = this.comparator.compare(((List)this.decorated).get(index - 1), element))) {
            throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + element.toString() + "is bigger then " + ((List)this.decorated).get(index - 1).toString());
        }
        if (index < ((List)this.decorated).size() - 2 && 0 < (result = this.comparator.compare(element, ((List)this.decorated).get(index + 1)))) {
            throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + element.toString() + "is smaller then " + ((List)this.decorated).get(index + 1).toString());
        }
        return ((List)this.decorated).set(index, element);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        return ((List)this.decorated).iterator();
    }

    @Override
    protected ListIterator<E> listIteratorImpl(int index) {
        return new ListIteratorDecorator_1x0<E>(((List)this.decorated).listIterator(index)){
            private E currentElem;
            private boolean iterationDirectionByUsingNext;
            {
                this.currentElem = null;
                this.iterationDirectionByUsingNext = true;
            }

            @Override
            public E next() {
                this.iterationDirectionByUsingNext = true;
                this.currentElem = super.next();
                return this.currentElem;
            }

            @Override
            public E previous() {
                this.iterationDirectionByUsingNext = false;
                this.currentElem = super.previous();
                return this.currentElem;
            }

            @Override
            public void add(E e) {
                int result;
                boolean iterationDirectionByUsingNextCopy = this.iterationDirectionByUsingNext;
                Object nextElem = null;
                if (!iterationDirectionByUsingNextCopy) {
                    this.next();
                }
                if (this.hasNext()) {
                    nextElem = this.next();
                    this.previous();
                    this.previous();
                    this.next();
                }
                if (!iterationDirectionByUsingNextCopy) {
                    this.previous();
                }
                if (this.currentElem != null && 0 < (result = SortedList_1x0.this.comparator.compare(this.currentElem, e))) {
                    throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + this.currentElem.toString() + "is bigger then " + this.currentElem.toString());
                }
                if (nextElem != null && 0 <= (result = SortedList_1x0.this.comparator.compare(e, nextElem))) {
                    throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + nextElem.toString() + "is smaller then " + nextElem.toString());
                }
                super.add(e);
            }

            @Override
            public void set(E e) {
                int result;
                int result2;
                Object prevElem = null;
                if (this.hasPrevious()) {
                    prevElem = this.previous();
                    this.next();
                }
                if (prevElem != null && 0 < (result2 = SortedList_1x0.this.comparator.compare(prevElem, e))) {
                    throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + prevElem.toString() + "is bigger then " + prevElem.toString());
                }
                Object nextElem = null;
                if (this.hasNext()) {
                    nextElem = this.previous();
                    this.previous();
                }
                if (nextElem != null && 0 <= (result = SortedList_1x0.this.comparator.compare(e, nextElem))) {
                    throw new IllegalStateException("SortedList_1x0.set(int index, E element) caused exception, because " + nextElem.toString() + "is smaller then " + nextElem.toString());
                }
                super.set(e);
            }
        };
    }

    @Override
    public int indexOf(Object element) {
        int left;
        if (((List)this.decorated).size() < 128 || SortType.Linked.equals((Object)this.type)) {
            return super.indexOf(element);
        }
        Object elemE = null;
        try {
            elemE = element;
        }
        catch (ClassCastException ex) {
            return -1;
        }
        if (elemE == null) {
            return -1;
        }
        ObjectPointer_1x0<Integer> rightBorder = new ObjectPointer_1x0<Integer>(0);
        int index = left = this.findInsertionIndex_TypeArray((List)this.decorated, elemE, 0, ((List)this.decorated).size(), rightBorder);
        int iteratorIndex = left;
        ListIterator it = ((List)this.decorated).listIterator(iteratorIndex);
        while (it.hasNext()) {
            Object e = it.next();
            if (element.equals(e)) {
                return index;
            }
            if (rightBorder.getObject() >= ++index) continue;
            break;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        int left;
        if (((List)this.decorated).size() < 128 || SortType.Linked.equals((Object)this.type)) {
            return super.lastIndexOf(element);
        }
        Object elemE = null;
        try {
            elemE = element;
        }
        catch (ClassCastException ex) {
            return -1;
        }
        if (elemE == null) {
            return -1;
        }
        ObjectPointer_1x0<Integer> rightBorder = new ObjectPointer_1x0<Integer>(0);
        int index = left = this.findInsertionIndex_TypeArray((List)this.decorated, elemE, 0, ((List)this.decorated).size(), rightBorder);
        ListIterator it = ((List)this.decorated).listIterator(left);
        boolean found = false;
        while (it.hasNext()) {
            Object e = it.next();
            if (rightBorder.getObject() < index) break;
            if (elemE.equals(e)) {
                found = true;
            } else if (found) {
                return index - 1;
            }
            ++index;
        }
        if (found) {
            return index - 1;
        }
        return -1;
    }

    protected int findInsertionIndex_TypeArray(List<E> list, E element, int left, int right, ObjectPointer_1x0<Integer> rightBorder) {
        if (rightBorder == null) {
            throw new IllegalArgumentException("rightBorder can't be null");
        }
        if (right < left) {
            throw new IllegalArgumentException("right must be bigger or equals as the left");
        }
        if (right - left <= 128) {
            rightBorder.setObject(right);
            return this.findInsertionIndex_TypeLinked(list, element, left, right);
        }
        int midle = left + (right - left) / 2;
        Object midleE = ((List)this.decorated).get(midle);
        int comparedValue = this.comparator.compare(midleE, element);
        if (0 < comparedValue) {
            return this.findInsertionIndex_TypeArray(list, element, left, midle, rightBorder);
        }
        if (comparedValue == 0) {
            int e;
            ListIterator<int> it = this.listIterator(midle);
            int index = midle;
            while (it.hasPrevious() && 0 == this.comparator.compare(e = it.previous(), element)) {
                --index;
            }
            rightBorder.setObject(index);
            return index;
        }
        return this.findInsertionIndex_TypeArray(list, element, midle, right, rightBorder);
    }

    protected int findInsertionIndex_TypeLinked(List<E> list, E element, int left, int right) {
        int index = left;
        ListIterator<E> it = list.listIterator(left);
        while (it.hasNext()) {
            E e = it.next();
            if (0 <= this.comparator.compare(e, element)) {
                return index;
            }
            ++index;
        }
        return right;
    }

    @Override
    public boolean contains(Object obj) {
        return 0 <= this.indexOf(obj);
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (0 <= index) {
            ((List)this.decorated).remove(index);
            return true;
        }
        return false;
    }

    public static enum SortType {
        Array,
        Linked;

    }
}

